/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog$;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.SnapshotFile;
import org.apache.kafka.storage.internals.log.TxnMetadata;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import org.apache.kafka.storage.internals.log.VerificationStateEntry;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0011-a\u0001\u00024h\u00011DQa\u001d\u0001\u0005\u0002QD\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\t\u0017\u0005\r\u0001\u00011AA\u0002\u0013%\u0011Q\u0001\u0005\u000b\u0003#\u0001\u0001\u0019!A!B\u0013I\bbCA\n\u0001\u0001\u0007\t\u0019!C\u0005\u0003+A1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026!Y\u0011\u0011\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\f\u0011%\tY\u0004\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA \u0011%\ti\u0005\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002^\u0001\u0001\u000b\u0011BA)\u0011%\ty\u0006\u0001b\u0001\n\u0013\t\t\u0007\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA2\u0011%\tY\u0007\u0001b\u0001\n\u0013\ti\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA8\u0011%\t9\b\u0001b\u0001\n\u0013\tI\b\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0011BA>\u0011%\t\u0019\t\u0001b\u0001\n\u0013\t\t\u0007\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA2\u0011%\t9\t\u0001b\u0001\n\u0013\tI\t\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAF\u0011%\tI\n\u0001b\u0001\n\u0013\tY\n\u0003\u0005\u00024\u0002\u0001\u000b\u0011BAO\u0011%\t)\f\u0001b\u0001\n\u0013\t9\f\u0003\u0005\u0002@\u0002\u0001\u000b\u0011BA]\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!a7\u0001\t\u0003\t\u0019\rC\u0004\u0002f\u0002!\t!a1\t\u000f\u0005=\b\u0001\"\u0001\u0002D\"9\u00111\u001f\u0001\u0005\u0002\u0005\r\u0007bBA|\u0001\u0011\u0005\u00111\u0019\u0005\b\u0003w\u0004A\u0011AAb\u0011\u001d\ty\u0010\u0001C\u0001\u0003\u0007DqAa\u0001\u0001\t\u0003\t\u0019\rC\u0004\u0003\b\u0001!\t!a1\t\u000f\t-\u0001\u0001\"\u0001\u0002D\"9!q\u0002\u0001\u0005\u0002\u0005\r\u0007b\u0002B\n\u0001\u0011\u0005!Q\u0003\u0005\b\u0005'\u0001A\u0011\u0001B\u0019\u0011\u001d\u00119\u0004\u0001C\u0001\u0003\u0007DqAa\u000f\u0001\t\u0003\t\u0019\rC\u0004\u0003@\u0001!\t!a1\t\u000f\t\r\u0003\u0001\"\u0001\u0002D\"9!q\t\u0001\u0005\u0002\u0005\r\u0007b\u0002B&\u0001\u0011\u0005\u00111\u0019\u0005\b\u0005\u001f\u0002A\u0011AAb\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0003\u0007DqAa\u0016\u0001\t\u0003\t\u0019\rC\u0004\u0003\\\u0001!\t!a1\t\u000f\t}\u0003\u0001\"\u0001\u0002D\"9!1\r\u0001\u0005\u0002\u0005\r\u0007b\u0002B4\u0001\u0011\u0005\u00111\u0019\u0005\b\u0005W\u0002A\u0011AAb\u0011\u001d\u0011y\u0007\u0001C\u0001\u0003\u0007DqAa\u001d\u0001\t\u0003\t\u0019\rC\u0004\u0003x\u0001!\t!a1\t\u000f\tm\u0004\u0001\"\u0001\u0002D\"9!q\u0010\u0001\u0005\u0002\u0005\r\u0007b\u0002BB\u0001\u0011\u0005\u00111\u0019\u0005\b\u0005\u000f\u0003A\u0011AAb\u0011\u001d\u0011Y\t\u0001C\u0001\u0003\u0007DqAa$\u0001\t\u0003\t\u0019\rC\u0004\u0003\u0014\u0002!\t!a1\t\u000f\t]\u0005\u0001\"\u0001\u0002D\"9!1\u0014\u0001\u0005\u0002\u0005\r\u0007b\u0002BP\u0001\u0011\u0005\u00111\u0019\u0005\b\u0005G\u0003A\u0011AAb\u0011\u001d\u00119\u000b\u0001C\u0001\u0003\u0007DqAa+\u0001\t\u0003\t\u0019\rC\u0004\u00030\u0002!\t!a1\t\u000f\tM\u0006\u0001\"\u0001\u0002D\"9!q\u0017\u0001\u0005\u0002\u0005\r\u0007b\u0002B^\u0001\u0011\u0005\u00111\u0019\u0005\b\u0005\u007f\u0003A\u0011AAb\u0011\u001d\u0011\u0019\r\u0001C\u0001\u0003\u0007DqAa2\u0001\t\u0003\t\u0019\rC\u0004\u0003L\u0002!\t!a1\t\u000f\t=\u0007\u0001\"\u0001\u0002D\"9!1\u001b\u0001\u0005\u0002\u0005\r\u0007b\u0002Bk\u0001\u0011\u0005\u00111\u0019\u0005\b\u00053\u0004A\u0011AAb\u0011\u001d\u0011i\u000e\u0001C\u0001\u0003\u0007DqA!9\u0001\t\u0003\t\u0019\rC\u0004\u0003f\u0002!\t!a1\t\u000f\t%\b\u0001\"\u0001\u0003l\"911\u0004\u0001\u0005\u0002\u0005\r\u0007bBB\u0010\u0001\u0011\u0005\u00111\u0019\u0005\b\u0007G\u0001A\u0011AAb\u0011\u001d\u00199\u0003\u0001C\u0001\u0003\u0007Dqaa\u000b\u0001\t\u0003\t\u0019\rC\u0004\u00040\u0001!Ia!\r\t\u000f\r5\u0003\u0001\"\u0003\u0004P!I1\u0011\u0012\u0001\u0012\u0002\u0013%11\u0012\u0005\n\u0007C\u0003\u0011\u0013!C\u0005\u0007GCqaa*\u0001\t\u0013\u0019I\u000bC\u0005\u0004H\u0002\t\n\u0011\"\u0003\u0004$\"I1\u0011\u001a\u0001\u0012\u0002\u0013%11\u001a\u0005\n\u0007\u001f\u0004\u0011\u0013!C\u0005\u0007#Dqaa*\u0001\t\u0013\u0019)\u000eC\u0004\u0004j\u0002!Iaa;\t\u000f\u0011\r\u0001\u0001\"\u0003\u0005\u0006\tA\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005!L\u0017a\u00017pO*\t!.A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0007C\u00018r\u001b\u0005y'\"\u00019\u0002\u000bM\u001c\u0017\r\\1\n\u0005I|'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002kB\u0011a\u000fA\u0007\u0002O\u00061An\\4ESJ,\u0012!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f!![8\u000b\u0003y\fAA[1wC&\u0019\u0011\u0011A>\u0003\t\u0019KG.Z\u0001\u000bY><G)\u001b:`I\u0015\fH\u0003BA\u0004\u0003\u001b\u00012A\\A\u0005\u0013\r\tYa\u001c\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0010\r\t\t\u00111\u0001z\u0003\rAH%M\u0001\bY><G)\u001b:!\u00031\u0019H/\u0019;f\u001b\u0006t\u0017mZ3s+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005=RBAA\u000e\u0015\rA\u0017Q\u0004\u0006\u0005\u0003?\t\t#A\u0005j]R,'O\\1mg*!\u00111EA\u0013\u0003\u001d\u0019Ho\u001c:bO\u0016T1A[A\u0014\u0015\u0011\tI#a\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti#A\u0002pe\u001eLA!!\r\u0002\u001c\t!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\f\u0001c\u001d;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\t\u0005\u001d\u0011q\u0007\u0005\n\u0003\u001f1\u0011\u0011!a\u0001\u0003/\tQb\u001d;bi\u0016l\u0015M\\1hKJ\u0004\u0013\u0001\u0003;f]\u0006tG/\u00133\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015S0\u0001\u0003mC:<\u0017\u0002BA%\u0003\u0007\u0012aa\u0015;sS:<\u0017!\u0003;f]\u0006tG/\u00133!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002RA!\u00111KA-\u001b\t\t)F\u0003\u0003\u0002X\u0005\u0015\u0012AB2p[6|g.\u0003\u0003\u0002\\\u0005U#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00039s_\u0012,8-\u001a:JIV\u0011\u00111\r\t\u0004]\u0006\u0015\u0014bAA4_\n!Aj\u001c8h\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\u0002/5\f\u0007\u0010\u0016:b]N\f7\r^5p]RKW.Z8vi6\u001bXCAA8!\rq\u0017\u0011O\u0005\u0004\u0003gz'aA%oi\u0006AR.\u0019=Ue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u00025A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0005\u0005m\u0004\u0003BA\r\u0003{JA!a \u0002\u001c\tQ\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jO\u0006Y\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jO\u0002\n\u0001\u0004\\1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t\u0003ea\u0017\r^3Ue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b)&A\u0003vi&d7/\u0003\u0003\u0002\u0016\u0006=%\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001b\rDWmY6tk6\u001cFo\u001c:f+\t\ti\n\u0005\u0003\u0002 \u0006=VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0011\rDWmY6tk6TA!a\t\u0002(*\u0019!.!+\u000b\t\u0005-\u0016QV\u0001\nG>tg\r\\;f]RT\u0011\u0001`\u0005\u0005\u0003c\u000b\tK\u0001\tFe\u0015\u001b\u0005.Z2lgVl7\u000b^8sK\u0006q1\r[3dWN,Xn\u0015;pe\u0016\u0004\u0013AD2iK\u000e\\7/^7QCJ\fWn]\u000b\u0003\u0003s\u0003B!a(\u0002<&!\u0011QXAQ\u00059\u0019\u0005.Z2lgVl\u0007+\u0019:b[N\fqb\u00195fG.\u001cX/\u001c)be\u0006l7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003\u000fA3AGAd!\u0011\tI-a6\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\f1!\u00199j\u0015\u0011\t\t.a5\u0002\u000f),\b/\u001b;fe*!\u0011Q[A\u0016\u0003\u0015QWO\\5u\u0013\u0011\tI.a3\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rY\u0012q\u001c\t\u0005\u0003\u0013\f\t/\u0003\u0003\u0002d\u0006-'!C!gi\u0016\u0014X)Y2i\u0003I!Xm\u001d;CCNL7-\u00133NCB\u0004\u0018N\\4)\u0007q\tI\u000f\u0005\u0003\u0002J\u0006-\u0018\u0002BAw\u0003\u0017\u0014A\u0001V3ti\u00061C/Z:u\u0003B\u0004XM\u001c3Uq:l\u0015M]6fe^KG\u000f\u001b(p!J|G-^2feN#\u0018\r^3)\u0007u\tI/\u0001\u0010uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z,sCB\f%o\\;oI\"\u001aa$!;\u0002[Q,7\u000f\u001e)s_\u0012,8-\u001a:TKF,XM\\2f/&$\bn\u0016:ba\u0006\u0013x.\u001e8e\u0005\u0006$8\r\u001b*fG>\u0014H\rK\u0002 \u0003S\fQ\u0005^3tiB\u0013x\u000eZ;dKJ\u001cV-];f]\u000e,\u0017J\u001c<bY&$wK]1q\u0003J|WO\u001c3)\u0007\u0001\nI/\u0001\u0016uKN$hj\u001c,bY&$\u0017\r^5p]>sg)\u001b:ti\u0016sGO]=XQ\u0016tGj\\1eS:<Gj\\4)\u0007\u0005\nI/A\u0012uKN$8i\u001c8ue>d'+Z2pe\u0012\u0014U/\u001c9t!J|G-^2fe\u0016\u0003xn\u00195)\u0007\t\nI/\u0001\u0011uKN$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016$\u0007fA\u0012\u0002j\u0006\u0019B/Z:u\u0019N|')\u0019;dQ\u0006\u0003\b/\u001a8eg\"\u001aA%!;\u00023Q,7\u000f^*lSB,U\u000e\u001d;z)J\fgn]1di&|gn\u001d\u0015\u0004K\u0005%\u0018aF1tg\u0016\u0014H\u000f\u0016=o\u001b\u0016$\u0018\rZ1uC\u0016\u000bX/\u00197t)\u0019\t9Aa\u0006\u0003.!9!\u0011\u0004\u0014A\u0002\tm\u0011\u0001C3ya\u0016\u001cG/\u001a3\u0011\r\tu!1\u0005B\u0014\u001b\t\u0011yBC\u0002\u0003\"u\fA!\u001e;jY&!!Q\u0005B\u0010\u0005\u0011a\u0015n\u001d;\u0011\t\u0005e!\u0011F\u0005\u0005\u0005W\tYBA\u0006Uq:lU\r^1eCR\f\u0007b\u0002B\u0018M\u0001\u0007!1D\u0001\u0007C\u000e$X/\u00197\u0015\r\u0005\u001d!1\u0007B\u001b\u0011\u001d\u0011Ib\na\u0001\u0005OAqAa\f(\u0001\u0004\u00119#\u0001\fuKN$\b*Y:MCR,GK]1og\u0006\u001cG/[8oQ\rA\u0013\u0011^\u0001-i\u0016\u001cH\u000fS1t\u0019\u0006$X\r\u0016:b]N\f7\r^5p]&s\u0017\u000e^5bY&TX\rZ!gi\u0016\u0014(+\u001a7pC\u0012D3!KAu\u0003M\"Xm\u001d;ICNd\u0015\r^3Ue\u0006t7/Y2uS>tW\u000b\u001d3bi\u0016$\u0017I\u001a;feB\u000b'\u000f^5bYR\u0013XO\\2bi&|g\u000eK\u0002+\u0003S\f\u0001\u0007^3ti\"\u000b7\u000fT1uKR\u0013\u0018M\\:bGRLwN\\+qI\u0006$X\rZ!gi\u0016\u0014h)\u001e7m)J,hnY1uS>t\u0007fA\u0016\u0002j\u0006\u0001C/Z:u\u0019\u0006\u001cHo\u0015;bE2,wJ\u001a4tKR\u001cu.\u001c9mKR,G\r\u0016=oQ\ra\u0013\u0011^\u0001\u001fi\u0016\u001cH\u000f\u0015:fa\u0006\u0014X-\u00169eCR,Gi\\3t\u001d>$X*\u001e;bi\u0016D3!LAu\u0003y)\b\u000fZ1uKB\u0013x\u000eZ;dKJ$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rK\u0002/\u0003S\fA\u0006^3ti>+Ho\u00144TKF,XM\\2f\u0003\u001a$XM]\"p]R\u0014x\u000e\u001c*fG>\u0014H-\u00129pG\"\u0014U/\u001c9)\u0007=\nI/\u0001\u0019uKN$hj\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\!qa\u0016tGmV5uQ>swm\\5oOR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004a\u0005%\u0018a\f;fgR$&/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a*f[>4Xm](vi>3'+\u00198hKNs\u0017\r]:i_R\u001c\bfA\u0019\u0002j\u0006\u0001B/Z:u)\u0006\\Wm\u00158baNDw\u000e\u001e\u0015\u0004e\u0005%\u0018A\b;fgR4U\r^2i':\f\u0007o\u001d5pi\u0016k\u0007\u000f^=T]\u0006\u00048\u000b[8uQ\r\u0019\u0014\u0011^\u0001-i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_R,fNZ5oSNDW\r\u001a+sC:\u001c\u0018m\u0019;j_:D3\u0001NAu\u0003)\"Xm\u001d;SK\u000e|g/\u001a:Ge>l7K\\1qg\"|GOR5oSNDW\r\u001a+sC:\u001c\u0018m\u0019;j_:D3!NAu\u0003\u001d\"Xm\u001d;SK\u000e|g/\u001a:Ge>l7K\\1qg\"|G/R7qif$&/\u00198tC\u000e$\u0018n\u001c8)\u0007Y\nI/\u0001\u0015uKN$\bK]8ek\u000e,'o\u0015;bi\u0016\fe\r^3s\r\u0016t7-\u001b8h\u0003\n|'\u000f^'be.,'\u000fK\u00028\u0003S\fQ\u0004^3tiJ+Wn\u001c<f\u000bb\u0004\u0018N]3e!&$7o\u00148SK2|\u0017\r\u001a\u0015\u0004q\u0005%\u0018!\f;fgR\f5mY3qi\u0006\u0003\b/\u001a8e/&$\bn\\;u!J|G-^2feN#\u0018\r^3P]J+\u0007\u000f\\5dC\"\u001a\u0011(!;\u0002SQ,7\u000f^!dG\u0016\u0004H/\u00119qK:$w+\u001b;i'\u0016\fX/\u001a8dK\u001e\u000b\u0007o](o%\u0016\u0004H.[2bQ\rQ\u0014\u0011^\u0001\u001ai\u0016\u001cH\u000fR3mKR,7K\\1qg\"|Go\u001d\"fM>\u0014X\rK\u0002<\u0003S\f1\u0004^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#\bf\u0001\u001f\u0002j\u0006\u0019B/Z:u%\u0016dw.\u00193T]\u0006\u00048\u000f[8ug\"\u001aQ(!;\u0002MQ,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\u0018I\u001a;feR\u0013XO\\2bi&|g\u000eK\u0002?\u0003S\fa\u0006^3ti2{\u0017\r\u001a$s_6\u001cf.\u00199tQ>$(+\u001a;bS:\u001chj\u001c8FqBL'/\u001a3Qe>$WoY3sg\"\u001aq(!;\u0002CQ,7\u000f^*lSB\u001cf.\u00199tQ>$\u0018JZ(gMN,G/\u00168dQ\u0006tw-\u001a3)\u0007\u0001\u000bI/\u0001\ruKN$\b+\u001b3FqBL'/\u0019;j_:$\u0016.\\3pkRD3!QAu\u0003}!Xm\u001d;QS\u0012,\u0005\u0010]5sCRLwN\u001c+j[\u0016|W\u000f^+qI\u0006$X\r\u001a\u0015\u0004\u0005\u0006%\u0018a\u0006;fgR4\u0015N]:u+:\u001cH/\u00192mK>3gm]3uQ\r\u0019\u0015\u0011^\u0001/i\u0016\u001cH\u000f\u0015:pIV\u001cWM]:XSRDwJ\\4pS:<GK]1og\u0006\u001cG/[8og\u0012{g\u000e^#ya&\u0014X\rK\u0002E\u0003S\fQ\u0006^3tiN+\u0017/^3oG\u0016tu\u000e\u001e,bY&$\u0017\r^3e\r>\u0014xI]8va6+G/\u00193bi\u0006$v\u000e]5dQ\r)\u0015\u0011^\u0001\u001di\u0016\u001cHo\u00147e\u000bB|7\r\u001b$pe\u000e{g\u000e\u001e:pYJ+7m\u001c:eQ\r1\u0015\u0011^\u0001\u0017i\u0016\u001cHoQ8pe\u0012Lg.\u0019;pe\u001a+gnY5oO\"\u001aq)!;\u0002AQ,7\u000f^\"p_J$\u0017N\\1u_J4UM\\2fI\u00063G/\u001a:SK2|\u0017\r\u001a\u0015\u0004\u0011\u0006%\u0018!\b;fgRdu.\u00193Ge>lW)\u001c9usNs\u0017\r]:i_R4\u0015\u000e\\3)\u0007%\u000bI/A\u0011uKN$Hj\\1e\rJ|W\u000e\u0016:v]\u000e\fG/\u001a3T]\u0006\u00048\u000f[8u\r&dW\rK\u0002K\u0003S\fq\u0004^3ti2{\u0017\r\u001a$s_6\u001cuN\u001d:vaR\u001cf.\u00199tQ>$h)\u001b7fQ\rY\u0015\u0011^\u0001\u001ci\u0016\u001cH/\u00119qK:$W)\u001c9us\u000e{g\u000e\u001e:pY\n\u000bGo\u00195)\u00071\u000bI/\u0001\u000fuKN$(+\u001a7pC\u00124%o\\7US\u0016\u0014X\rZ*oCB\u001c\bn\u001c;)\u00075\u000bI/A\ruKN$8K\\1qg\"|GOR5mK\u001a{'o\u00144gg\u0016$\bf\u0001(\u0002j\u0006\tD/Z:u%\u0016lwN^3TiJ\f\u0017p\u00158baNDw\u000e^:LK\u0016\u00048\t\\3b]NCW\u000f\u001e3po:\u001cf.\u00199tQ>$\u0018a\u0007;fgR\u0014V-\\8wK\u0006cGn\u0015;sCf\u001cf.\u00199tQ>$8\u000fK\u0002Q\u0003S\fA\u0005^3tiJ+Wn\u001c<f\u0003:$W*\u0019:l':\f\u0007o\u001d5pi\u001a{'\u000fR3mKRLwN\u001c\u0015\u0004#\u0006%\u0018A\r;fgR\u0014V-\\8wK\u0006sG-T1sWNs\u0017\r]:i_R4uN\u001d#fY\u0016$\u0018n\u001c8BYJ,\u0017\rZ=EK2,G/\u001a3)\u0007I\u000bI/\u0001\ruKN$XI\u001c;ss\u001a{'OV3sS\u001aL7-\u0019;j_:D3aUAu\u0003\u001d\"Xm\u001d;TKF,XM\\2f\u0003:$W\t]8dQ&sg+\u001a:jM&\u001c\u0017\r^5p]\u0016sGO]=)\u0007Q\u000bI/\u0001\u001duKN$H\u000b\u001b:po>+Ho\u00144Pe\u0012,'oU3rk\u0016t7-Z,ji\"4VM]5gS\u000e\fG/[8o'\u0016\fX/\u001a8dK\u000eCWmY6\u0015\t\u0005\u001d!Q\u001e\u0005\b\u0005_,\u0006\u0019\u0001By\u0003I!\u0017P\\1nS\u000e\fG\u000e\\=ESN\f'\r\\3\u0011\u00079\u0014\u00190C\u0002\u0003v>\u0014qAQ8pY\u0016\fg\u000eK\u0002V\u0005s\u0004BAa?\u0004\u00025\u0011!Q \u0006\u0005\u0005\u007f\fy-\u0001\u0004qCJ\fWn]\u0005\u0005\u0007\u0007\u0011iPA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDs!VB\u0004\u0007'\u0019)\u0002\u0005\u0003\u0004\n\r=QBAB\u0006\u0015\u0011\u0019iA!@\u0002\u0011A\u0014xN^5eKJLAa!\u0005\u0004\f\tYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006BB\f\u00073I\u0012!A\r\u0002\u0001\u0005!C/Z:u-\u0016\u0014\u0018NZ5dCRLwN\\*uCR,WI\u001c;ss\u0016C\b/\u001b:bi&|g\u000eK\u0002W\u0003S\f!\u0004^3ti\u0006\u0013G.\u001a+p\t\u0016$Xm\u0019;D_J\u0014X\u000f\u001d;j_:D3aVAu\u00039\"Xm\u001d;DQ\u0016\u001c7n];n'R|'/Z#oiJL(+\u001a8b[\u0016$wJ\u001c)be\u0016tG\u000fR5s+B$\u0017\r^3)\u0007a\u000bI/A\u001duKN$8\t[3dWN,X.\u00128uef\u0014VM\\1nK\u0012<\u0006.\u001a8T]\u0006\u00048\u000f[8u\r&dW-T1sW\u0016$gi\u001c:EK2,G/[8oQ\rI\u0016\u0011^\u00016i\u0016\u001cHo\u00115fG.\u001cX/\\*u_J,WI\u001c;ss&\u001b(+Z7pm\u0016$wJ\\*oCB\u001c\bn\u001c;GS2,G)\u001a7fi&|g\u000eK\u0002[\u0003S\f1\u0004^3ti2{\u0017\r\u001a$s_6\u001cuN\u001d:vaR\u001cf.\u00199tQ>$H\u0003BA\u0004\u0007gAqa!\u000e\\\u0001\u0004\u00199$A\bnC.,g)\u001b7f\u0007>\u0014(/\u001e9u!\u001dq7\u0011HB\u001f\u0003\u000fI1aa\u000fp\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0004@\r%SBAB!\u0015\u0011\u0019\u0019e!\u0012\u0002\u0011\rD\u0017M\u001c8fYNT1aa\u0012~\u0003\rq\u0017n\\\u0005\u0005\u0007\u0017\u001a\tEA\u0006GS2,7\t[1o]\u0016d\u0017AE1qa\u0016tG-\u00128e)btW*\u0019:lKJ$\u0002c!\u0015\u0004^\r\u000541MB7\u0007{\u001a\ti!\"\u0011\u000b9\u001c\u0019fa\u0016\n\u0007\rUsN\u0001\u0004PaRLwN\u001c\t\u0005\u00033\u0019I&\u0003\u0003\u0004\\\u0005m!\u0001D\"p[BdW\r^3e)bt\u0007bBB09\u0002\u0007\u0011qC\u0001\b[\u0006\u0004\b/\u001b8h\u0011\u001d\ty\u0006\u0018a\u0001\u0003GBqa!\u001a]\u0001\u0004\u00199'A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004]\u000e%\u0014bAB6_\n)1\u000b[8si\"91q\u000e/A\u0002\rE\u0014aC2p]R\u0014x\u000e\u001c+za\u0016\u0004Baa\u001d\u0004z5\u00111Q\u000f\u0006\u0005\u0007o\n)&\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0007w\u001a)HA\tD_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016Dqaa ]\u0001\u0004\t\u0019'\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\n\u0007\u0007c\u0006\u0013!a\u0001\u0003_\n\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u0013\r\u001dE\f%AA\u0002\u0005\r\u0014!\u0003;j[\u0016\u001cH/Y7q\u0003q\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uIY*\"a!$+\t\u0005=4qR\u0016\u0003\u0007#\u0003Baa%\u0004\u001e6\u00111Q\u0013\u0006\u0005\u0007/\u001bI*A\u0005v]\u000eDWmY6fI*\u001911T8\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004 \u000eU%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3sI\u0011,g-Y;mi\u0012:TCABSU\u0011\t\u0019ga$\u0002\r\u0005\u0004\b/\u001a8e)I\t9aa+\u0004.\u000e=6\u0011WB[\u0007o\u001bIl!0\t\u000f\u0005Mq\f1\u0001\u0002\u0018!9\u0011qL0A\u0002\u0005\r\u0004bBB3?\u0002\u00071q\r\u0005\b\u0007g{\u0006\u0019AA8\u0003\r\u0019X-\u001d\u0005\b\u0007\u007fz\u0006\u0019AA2\u0011%\u00199i\u0018I\u0001\u0002\u0004\t\u0019\u0007C\u0005\u0004<~\u0003\n\u00111\u0001\u0003r\u0006y\u0011n\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000eC\u0005\u0004@~\u0003\n\u00111\u0001\u0004B\u00061qN]5hS:\u0004B!!\u0007\u0004D&!1QYA\u000e\u00051\t\u0005\u000f]3oI>\u0013\u0018nZ5o\u0003A\t\u0007\u000f]3oI\u0012\"WMZ1vYR$c'\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%oU\u00111Q\u001a\u0016\u0005\u0005c\u001cy)\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%qU\u001111\u001b\u0016\u0005\u0007\u0003\u001cy\t\u0006\u0007\u0002\b\r]7\u0011\\Bn\u0007;\u001c9\u000fC\u0004\u0002\u0014\r\u0004\r!a\u0006\t\u000f\u0005}3\r1\u0001\u0002d!91qP2A\u0002\u0005\r\u0004bBBpG\u0002\u00071\u0011]\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0007g\u001a\u0019/\u0003\u0003\u0004f\u000eU$a\u0003*fG>\u0014HMQ1uG\"Dqaa0d\u0001\u0004\u0019\t-\u0001\fdkJ\u0014XM\u001c;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;t+\t\u0019i\u000f\u0005\u0004\u0004p\u000eu\u00181\r\b\u0005\u0007c\u001cI\u0010E\u0002\u0004t>l!a!>\u000b\u0007\r]8.\u0001\u0004=e>|GOP\u0005\u0004\u0007w|\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0004\u0000\u0012\u0005!aA*fi*\u001911`8\u00025Y\fG.\u001b3bi\u0016\u001c\u0005.Z2lgVl7\u000b^8sK\u0016sGO]=\u0015\r\u0005\u001dAq\u0001C\u0005\u0011\u001d\t\u0019\"\u001aa\u0001\u0003/Aq!!'f\u0001\u0004\ti\n")
public class ProducerStateManagerTest {
    private File logDir;
    private ProducerStateManager stateManager;
    private final String tenantId;
    private final TopicPartition partition = new TopicPartition(new StringBuilder(5).append(this.tenantId()).append("_test").toString(), 0);
    private final long producerId;
    private final int maxTransactionTimeoutMs;
    private final ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), true);
    private final long lateTransactionTimeoutMs = (long)this.maxTransactionTimeoutMs() + 300000L;
    private final MockTime time = new MockTime();
    private final E2EChecksumStore checksumStore = TestUtils$.MODULE$.createChecksumStore();
    private final ChecksumParams checksumParams = new ChecksumParams(Optional.of(this.checksumStore()), true, true);

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private ProducerStateManager stateManager() {
        return this.stateManager;
    }

    private void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    private String tenantId() {
        return this.tenantId;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private long producerId() {
        return this.producerId;
    }

    private int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    private ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    private long lateTransactionTimeoutMs() {
        return this.lateTransactionTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    private E2EChecksumStore checksumStore() {
        return this.checksumStore;
    }

    private ChecksumParams checksumParams() {
        return this.checksumParams;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, false, AppendOrigin.CLIENT));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, false, AppendOrigin.CLIENT);
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.REPLICATION, this.time().milliseconds());
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L), 2020L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)0L)), this.stateManager().lastEntry(this.producerId()).map(x$3 -> BoxesRunTime.boxToLong((long)x$3.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry.empty((long)this.producerId()), AppendOrigin.CLIENT, this.time().milliseconds(), this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), seq, producerEpoch));
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals(Optional.of(firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLsoBatchAppends() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo append = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, this.time().milliseconds());
        this.appendData$1(24L, 27L, append, producerEpoch, seq);
        Option firstTxnAbort = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, append, coordinatorEpoch, producerEpoch);
        this.appendData$1(29L, 31L, append, producerEpoch, seq);
        Option secondTxnComplete = this.appendEndTxn$1(ControlRecordType.COMMIT, 32L, append, coordinatorEpoch, producerEpoch);
        ProducerAppendInfo appendDiffProdId = this.stateManager().prepareUpdate(2L, AppendOrigin.CLIENT, this.time().milliseconds());
        this.appendData$1(33L, 34L, appendDiffProdId, producerEpoch, seq);
        Option thirdTxnComplete = this.appendEndTxn$1(ControlRecordType.COMMIT, 35L, appendDiffProdId, coordinatorEpoch, producerEpoch);
        this.stateManager().update(append);
        this.stateManager().update(appendDiffProdId);
        Assertions.assertEquals((long)((CompletedTxn)secondTxnComplete.get()).firstOffset, (long)this.stateManager().proposedLastStableOffset((CompletedTxn)firstTxnAbort.get()));
        this.stateManager().completeTxn((CompletedTxn)firstTxnAbort.get());
        Assertions.assertEquals((long)((CompletedTxn)thirdTxnComplete.get()).firstOffset, (long)this.stateManager().proposedLastStableOffset((CompletedTxn)secondTxnComplete.get()));
        this.stateManager().completeTxn((CompletedTxn)secondTxnComplete.get());
        this.stateManager().onHighWatermarkUpdated(35L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(33L)), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        long firstAppendTimeMs = this.time().milliseconds();
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, firstAppendTimeMs);
        this.appendData$2(16L, 20L, firstAppend, producerEpoch, seq);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), 16L, firstAppendTimeMs), (TxnMetadata)firstAppend.startedTransactions().get(0));
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(16L)), (Object)this.stateManager().firstUnstableOffset());
        long secondAppendTimeMs = this.time().milliseconds();
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, secondAppendTimeMs);
        Option firstCompletedTxn = this.appendEndTxn$2(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$2(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$2(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$2(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$2(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$2(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$2(30L, 31L, secondAppend, producerEpoch, seq);
        int size = secondAppend.startedTransactions().size();
        Assertions.assertEquals((int)2, (int)size);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L), secondAppendTimeMs), (TxnMetadata)secondAppend.startedTransactions().get(0));
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L), secondAppendTimeMs), (TxnMetadata)secondAppend.startedTransactions().get(size - 1));
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(30L)), (Object)this.stateManager().firstUnstableOffset());
    }

    public void assertTxnMetadataEquals(List<TxnMetadata> expected, List<TxnMetadata> actual) {
        Iterator<TxnMetadata> expectedIter = expected.iterator();
        Iterator<TxnMetadata> actualIter = actual.iterator();
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        while (expectedIter.hasNext() && actualIter.hasNext()) {
            this.assertTxnMetadataEquals(expectedIter.next(), actualIter.next());
        }
    }

    public void assertTxnMetadataEquals(TxnMetadata expected, TxnMetadata actual) {
        Assertions.assertEquals((long)expected.producerId, (long)actual.producerId);
        Assertions.assertEquals((Object)expected.firstOffset, (Object)actual.firstOffset);
        Assertions.assertEquals((Object)expected.lastOffset, (Object)actual.lastOffset);
    }

    @Test
    public void testHasLateTransaction() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId1, epoch1, ControlRecordType.COMMIT, 200L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId2, epoch2, ControlRecordType.COMMIT, 250L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionInitializedAfterReload() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        long loadTimeMs = this.time().milliseconds();
        reloadedStateManager.truncateAndReload(0L, this.stateManager().mapEndOffset(), loadTimeMs);
        Assertions.assertFalse((boolean)reloadedStateManager.hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterPartialTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateAndReload(0L, 80L, this.time().milliseconds());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterFullTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateFullyAndStartAt(150L);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().proposedLastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().proposedLastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().proposedLastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, this.time().milliseconds());
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L), 20L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, this.time().milliseconds());
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), false, AppendOrigin.CLIENT);
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT, appendTimeMs);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L, appendTimeMs)), appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L, appendTimeMs)), appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Optional completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isPresent());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId);
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset);
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset);
        Assertions.assertFalse((boolean)completedTxn.isAborted);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L, appendTimeMs)), appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = AppendOrigin.CLIENT;
            this.append(x$17, x$18, bumpedEpoch, 2, 2L, x$23, true, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = AppendOrigin.CLIENT;
            this.append(x$25, x$26, x$27, 2, 2L, x$31, true, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = AppendOrigin.CLIENT;
        this.append(x$33, x$34, bumpedEpoch, 0, 0L, x$39, true, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = AppendOrigin.CLIENT;
            this.append(x$9, x$10, epoch, 1, 1L, x$15, false, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())))), (String)"Snapshot file is empty");
        Optional snapshotFileOpt = this.stateManager().snapshotFileForOffset(2L);
        Assertions.assertTrue((boolean)snapshotFileOpt.isPresent());
        Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileOpt.get()).isOpenForWrite());
    }

    @Test
    public void testFetchSnapshotEmptySnapShot() {
        int offset = 1;
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().fetchSnapshot((long)offset));
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = AppendOrigin.CLIENT;
        this.append(recoveredMapping, x$18, epoch, 2, 2L, x$23, true, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$7 = 0;
        this.appendEndTxnMarker(x$1, x$2, epoch, ControlRecordType.ABORT, 0L, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Optional lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isPresent());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)recoveredMapping.activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        boolean x$8 = false;
        this.append(recoveredMapping, x$2, epoch, sequence, 2L, 70001L, x$8, AppendOrigin.REPLICATION);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)recoveredMapping.activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            boolean x$8 = false;
            this.append(x$1, x$2, epoch, outOfOrderSequence, 1L, 1L, x$8, AppendOrigin.CLIENT);
        });
        Assertions.assertTrue((boolean)this.stateManager().activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntry);
        Assertions.assertEquals((long)0L, (long)producerStateEntry.lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        boolean x$16 = false;
        this.append(x$9, x$10, epoch, outOfOrderSequence, 1L, 1L, x$16, AppendOrigin.REPLICATION);
        ProducerStateEntry producerStateEntryForReplication = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntryForReplication);
        Assertions.assertEquals((int)outOfOrderSequence, (int)producerStateEntryForReplication.lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        Map snapshots = ((IterableOnceOps)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))).map((Function1 & Serializable)offset -> ProducerStateManagerTest.$anonfun$testDeleteSnapshotsBefore$1(this, BoxesRunTime.unboxToInt((Object)offset)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        Assertions.assertFalse((boolean)((SnapshotFile)snapshots.apply((Object)BoxesRunTime.boxToInteger((int)2))).isOpenForWrite());
        Assertions.assertTrue((boolean)((SnapshotFile)snapshots.apply((Object)BoxesRunTime.boxToInteger((int)3))).isOpenForWrite());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        snapshots.values().foreach((Function1 & Serializable)s -> {
            ProducerStateManagerTest.$anonfun$testDeleteSnapshotsBefore$2(s);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testReloadSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Object[] pathAndDataList = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> new Tuple2((Object)file.toPath(), (Object)Files.readAllBytes(file.toPath())), ClassTag$.MODULE$.apply(Tuple2.class));
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), this.currentSnapshotOffsets());
        this.stateManager().truncateAndReload(3L, 5L, this.time().milliseconds());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), this.currentSnapshotOffsets());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(pathAndDataList), (Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Path path = (Path)x0$1._1();
                byte[] data = (byte[])x0$1._2();
                return Files.write(path, data, new OpenOption[0]);
            }
            throw new MatchError(null);
        });
        this.stateManager().truncateFullyAndReloadSnapshots();
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Optional entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Optional entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)this.stateManager().activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testPidExpirationTimeoutUpdated() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.time().sleep((long)this.producerStateManagerConfig().producerIdExpirationMs());
        this.producerStateManagerConfig().setProducerIdExpirationMs(Optional.of(this.tenantId()), Optional.of(Predef$.MODULE$.int2Integer(this.producerStateManagerConfig().producerIdExpirationMs() + 1)));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)sequence, (int)((ProducerStateEntry)this.stateManager().activeProducers().values().iterator().next()).lastSeq());
        this.time().sleep(1L);
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().activeProducers().isEmpty());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long anotherPid = 2L;
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, anotherPid, epoch, sequence, 105L, x$15, true, x$16);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.of(105L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        short epoch = (short)0;
        long x$2 = this.producerId();
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, -1, 99L, x$8, true, AppendOrigin.COORDINATOR);
        long x$10 = this.producerId();
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, -1, 100L, x$16, true, AppendOrigin.COORDINATOR);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Optional lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), lastEntry.map(x -> BoxesRunTime.boxToInteger((int)x.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, producerEpoch, 0, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)batch.iterator()).thenReturn(Collections.emptyIterator());
        this.append(this.stateManager(), producerId, baseOffset, batch, AppendOrigin.CLIENT);
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testReloadFromTieredSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Option maybeFile = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.stateManager().snapshotFileForOffset(3L))).map((Function1 & Serializable)x$4 -> x$4.file());
        Assertions.assertTrue((boolean)maybeFile.isDefined(), (String)"expected to find snapshot file at offset 3");
        File snapshotFile = (File)maybeFile.get();
        ByteBuffer buf = ByteBuffer.allocate((int)snapshotFile.length());
        try (FileChannel fc = FileChannel.open(snapshotFile.toPath(), new OpenOption[0]);){
            Utils.readFully((FileChannel)fc, (ByteBuffer)buf, (long)0L);
        }
        buf.flip();
        long originalLastDataOffset = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastDataOffset();
        int originalLastOffsetDelta = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastOffsetDelta();
        int originalLastSeq = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq();
        long originalLastTimestamp = ((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastTimestamp();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().truncateFullyAndStartAt(0L);
        this.stateManager().reloadFromTieredSnapshot(this.time().milliseconds(), buf, 3L);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        Assertions.assertTrue((boolean)this.stateManager().snapshotFileForOffset(3L).isPresent(), (String)"expected a snapshot file to exist for the restored snapshot");
        Assertions.assertEquals((int)this.logDir().listFiles().length, (int)1, (String)"expected all other snapshot files to be cleared, leaving only the restored snapshot file");
        ProducerStateEntry reloadedLastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((long)originalLastDataOffset, (long)reloadedLastEntry.lastDataOffset(), (String)"expected lastDataOffset to be restored");
        Assertions.assertEquals((int)originalLastOffsetDelta, (int)reloadedLastEntry.lastOffsetDelta(), (String)"expected lastOffsetDelta to be restored");
        Assertions.assertEquals((int)originalLastSeq, (int)reloadedLastEntry.lastSeq(), (String)"expected lastSeq to be restored");
        Assertions.assertEquals((long)originalLastTimestamp, (long)reloadedLastEntry.lastTimestamp(), (String)"expected lastTimestamp to be restored");
    }

    @Test
    public void testSnapshotFileForOffset() {
        Assertions.assertTrue((boolean)Paths.get(this.logDir().getAbsolutePath(), "00000000000000000020.snapshot").toFile().createNewFile());
        TopicPartition tp = new TopicPartition("test_topic", 0);
        ProducerStateManager producerStateManager = new ProducerStateManager(tp, this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        File foundFile = ((SnapshotFile)producerStateManager.snapshotFileForOffset(20L).get()).file();
        Assertions.assertEquals((Object)"00000000000000000020.snapshot", (Object)foundFile.getName());
        Assertions.assertTrue((boolean)foundFile.exists());
        Assertions.assertFalse((boolean)producerStateManager.snapshotFileForOffset(19L).isPresent());
    }

    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(5L)));
        Assertions.assertEquals((Object)OptionalLong.of(42L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(5L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L, 42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir(), (boolean)true)).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(42L)));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir(), (boolean)true)).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(".deleted"));
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L);
        Files.createFile(file.toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Files.delete(file.toPath());
        Assertions.assertTrue((!manager.removeAndMarkSnapshotForDeletion(5L).isPresent() ? 1 : 0) != 0);
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testEntryForVerification() {
        VerificationGuard originalEntryVerificationGuard = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0).verificationGuard();
        VerificationStateEntry updatedEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.verifyEntry$1(this.producerId(), updatedEntry, originalEntryVerificationGuard);
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, (short)0, 0, 0L, x$7, true, x$8);
        this.stateManager().clearVerificationStateEntry(this.producerId());
        Assertions.assertNull((Object)this.stateManager().verificationStateEntry(this.producerId()));
    }

    @Test
    public void testSequenceAndEpochInVerificationEntry() {
        VerificationStateEntry originalEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 1, (short)0);
        VerificationGuard originalEntryVerificationGuard = originalEntry.verificationGuard();
        this.verifyEntry$2(this.producerId(), originalEntry, 1, (short)0, originalEntryVerificationGuard);
        VerificationStateEntry updatedEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.verifyEntry$2(this.producerId(), updatedEntry, 0, (short)0, originalEntryVerificationGuard);
        VerificationStateEntry updatedEntryNewEpoch = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 2, (short)1);
        this.verifyEntry$2(this.producerId(), updatedEntryNewEpoch, 2, (short)1, originalEntryVerificationGuard);
        VerificationStateEntry updatedEntryOldEpoch = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.verifyEntry$2(this.producerId(), updatedEntryOldEpoch, 2, (short)1, originalEntryVerificationGuard);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testThrowOutOfOrderSequenceWithVerificationSequenceCheck(boolean dynamicallyDisable) {
        VerificationStateEntry originalEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        if (dynamicallyDisable) {
            this.producerStateManagerConfig().setTransactionVerificationEnabled(false);
        }
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            long x$7 = this.append$default$6();
            AppendOrigin x$8 = AppendOrigin.CLIENT;
            this.append(x$1, x$2, (short)0, 4, 0L, x$7, true, x$8);
        });
        Assertions.assertEquals((Object)originalEntry, (Object)this.stateManager().verificationStateEntry(this.producerId()));
    }

    @Test
    public void testVerificationStateEntryExpiration() {
        VerificationStateEntry originalEntry = this.stateManager().maybeCreateVerificationStateEntry(this.producerId(), 0, (short)0);
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() / 2));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertEquals((Object)originalEntry, (Object)this.stateManager().verificationStateEntry(this.producerId()));
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() / 2 + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertNull((Object)this.stateManager().verificationStateEntry(this.producerId()));
    }

    @Test
    public void testAbleToDetectCorruption() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        File file = (File)this.stateManager().fetchSnapshot(2L).get();
        FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.WRITE);
        channel.truncate(channel.size() - 1L);
        int getChecksumInfoForFile_size = (int)file.length();
        Assertions.assertNotEquals(LogTestUtils$.MODULE$.getChecksumInfoForFile(this.checksumStore().store(), file, getChecksumInfoForFile_size, false), (Object)this.checksumStore().store().get(file.getAbsolutePath()));
    }

    @Test
    public void testChecksumStoreEntryRenamedOnParentDirUpdate() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        String oldFileName = ((File)this.stateManager().fetchSnapshot(1L).get()).getAbsolutePath();
        Optional oldChecksumInfo = this.checksumStore().store().get(oldFileName);
        Assertions.assertTrue((boolean)this.checksumStore().store().get(oldFileName).isPresent());
        this.stateManager().updateParentDir(TestUtils.tempDirectory(null, null));
        String newFileName = ((File)this.stateManager().fetchSnapshot(1L).get()).getAbsolutePath();
        Optional newChecksumInfo = this.checksumStore().store().get(newFileName);
        Assertions.assertFalse((boolean)this.checksumStore().store().get(oldFileName).isPresent());
        Assertions.assertTrue((boolean)this.checksumStore().store().get(newFileName).isPresent());
        Assertions.assertEquals((Object)oldChecksumInfo, (Object)newChecksumInfo);
    }

    @Test
    public void testChecksumEntryRenamedWhenSnapshotFileMarkedForDeletion() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        SnapshotFile snapshotFile = (SnapshotFile)this.stateManager().removeAndMarkSnapshotForDeletion(1L).get();
        Assertions.assertEquals((int)1, (int)this.checksumStore().store().size());
        Assertions.assertTrue((boolean)((Object)snapshotFile.file().toPath()).toString().endsWith(".deleted"));
        Assertions.assertTrue((boolean)this.checksumStore().store().contains(snapshotFile.file().getAbsolutePath()));
    }

    @Test
    public void testChecksumStoreEntryIsRemovedOnSnapshotFileDeletion() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        String fileName = ((File)this.stateManager().fetchSnapshot(1L).get()).getAbsolutePath();
        Assertions.assertTrue((boolean)this.checksumStore().store().get(fileName).isPresent());
        this.stateManager().deleteSnapshotsBefore(2L);
        Assertions.assertFalse((boolean)this.checksumStore().store().get(fileName).isPresent());
        Assertions.assertEquals((int)0, (int)this.checksumStore().store().size());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.validateChecksumStoreEntry(this.stateManager(), this.checksumStore());
        OptionalLong latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)latestSnapshotOffset);
        File snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)latestSnapshotOffset.getAsLong());
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time(), Optional.empty(), this.checksumParams());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)loadedProducerState);
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, AppendOrigin.COORDINATOR, appendTimeMs);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp)));
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable)x$1 -> {
            mapping.completeTxn(x$1);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin, appendTimeMs);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        long appendTimeMs = this.time().milliseconds();
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin, appendTimeMs);
        producerAppendInfo.append(batch, Optional.empty());
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.CLIENT;
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)MergedLog$.MODULE$.offsetFromFile(file)), (ClassTag)ClassTag$.MODULE$.Long())).toSet();
    }

    private void validateChecksumStoreEntry(ProducerStateManager stateManager, E2EChecksumStore checksumStore) {
        File file = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)stateManager.mapEndOffset());
        int getChecksumInfoForFile_size = (int)file.length();
        Assertions.assertEquals(LogTestUtils$.MODULE$.getChecksumInfoForFile(checksumStore.store(), file, getChecksumInfoForFile_size, false), (Object)checksumStore.store().get(file.getAbsolutePath()));
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds())));
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final Option appendEndTxn$2(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$2, short producerEpoch$3) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$2), producerEpoch$3, offset, this.time().milliseconds())));
    }

    private final void appendData$2(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$3, AtomicInteger seq$2) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$3, seq$2.get(), seq$2.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset), endOffset, true);
        seq$2.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$4) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry.empty((long)producerId), AppendOrigin.CLIENT, this.time().milliseconds(), this.stateManager().maybeCreateVerificationStateEntry(producerId, 0, producerEpoch$4));
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$4, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteSnapshotsBefore$1(ProducerStateManagerTest $this, int offset) {
        SnapshotFile snapshot = (SnapshotFile)$this.stateManager().snapshotFileForOffset((long)offset).get();
        Assertions.assertTrue((boolean)snapshot.isOpenForWrite());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)snapshot);
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshotsBefore$2(SnapshotFile s) {
        Assertions.assertFalse((boolean)s.isOpenForWrite());
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap(new byte[]{37}), file.size() / 2L);
    }

    private final void verifyEntry$1(long producerId, VerificationStateEntry newEntry, VerificationGuard originalEntryVerificationGuard$1) {
        VerificationStateEntry entry = this.stateManager().verificationStateEntry(producerId);
        Assertions.assertEquals((Object)originalEntryVerificationGuard$1, (Object)entry.verificationGuard());
        Assertions.assertEquals((Object)entry.verificationGuard(), (Object)newEntry.verificationGuard());
    }

    private final void verifyEntry$2(long producerId, VerificationStateEntry newEntry, int expectedSequence, short expectedEpoch, VerificationGuard originalEntryVerificationGuard$2) {
        VerificationStateEntry entry = this.stateManager().verificationStateEntry(producerId);
        Assertions.assertEquals((Object)originalEntryVerificationGuard$2, (Object)entry.verificationGuard());
        Assertions.assertEquals((Object)entry.verificationGuard(), (Object)newEntry.verificationGuard());
        Assertions.assertEquals((int)expectedSequence, (int)entry.lowestSequence());
        Assertions.assertEquals((short)expectedEpoch, (short)entry.epoch());
    }

    public ProducerStateManagerTest() {
        this.tenantId = "lkc-abcd";
        this.producerId = 1L;
        this.maxTransactionTimeoutMs = 300000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

