/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.util.Map;
import java.util.Properties;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u00192A!\u000b\u0001\u0001U!AaF\u0001B\u0001B\u0003%q\u0006\u0003\u0005=\u0005\t\u0005\t\u0015!\u0003>\u0011!\u0019%A!A!\u0002\u0013!\u0005\"B\u0013\u0003\t\u00039\u0005\"B'\u0003\t\u0003r\u0005b\u0002\u0018\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007a\u0002\u0001\u000b\u0011B5\t\u000f\u0001\u0004!\u0019!C\u0001c\"1!\u000f\u0001Q\u0001\n\u0005Dqa\u001d\u0001C\u0002\u0013\u0005A\u000fC\u0004\u0002\f\u0001\u0001\u000b\u0011B;\t\u0013\u00055\u0001A1A\u0005\u0002\u0005=\u0001bBA\t\u0001\u0001\u0006I\u0001\u0012\u0005\n\u0003'\u0001!\u0019!C\u0001\u0003+A\u0001\"!\b\u0001A\u0003%\u0011q\u0003\u0005\ty\u0001\u0011\r\u0011\"\u0001\u0002 !9\u0011\u0011\u0005\u0001!\u0002\u0013i\u0004\"CA\u0012\u0001\t\u0007I\u0011AA\u0013\u0011\u001d\t9\u0003\u0001Q\u0001\n!Cq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002J\u0001!\t!a\u000b\u0003EM+w-\\3oi\u0012+G.\u001a;j_:$\u0006N]8ui2,'oQ8oM&<G+Z:u\u0015\tQ2$A\u0002m_\u001eT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003e\u0011!\u0005V3tiN+w-\\3oi\u0012+G.\u001a;j_:$\u0006N]8ui2,'oQ8oM&<7C\u0001\u0002,!\tAC&\u0003\u0002.3\tq2+Z4nK:$H)\u001a7fi&|g\u000e\u00165s_R$H.\u001a:D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u00021u5\t\u0011G\u0003\u00023g\u0005)Q\u000f^5mg*\u0011A'N\u0001\u0007G>lWn\u001c8\u000b\u0005q1$BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001eL!aO\u0019\u0003\tQKW.Z\u0001\u0007G>tg-[4\u0011\u0005y\nU\"A \u000b\u0005\u0001[\u0012AB:feZ,'/\u0003\u0002C\u007f\tY1*\u00194lC\u000e{gNZ5h\u0003M!\u0017n]6DQ\u0016\u001c7.T5o\t\u0016d\u0017-_'t!\t\u0001S)\u0003\u0002GC\t\u0019\u0011J\u001c;\u0015\t!S5\n\u0014\t\u0003\u0013\ni\u0011\u0001\u0001\u0005\u0006]\u0019\u0001\ra\f\u0005\u0006y\u0019\u0001\r!\u0010\u0005\u0006\u0007\u001a\u0001\r\u0001R\u0001\u000bM&dWm\u0015;pe\u0016\u001cHCA(`!\r\u00016+V\u0007\u0002#*\u0011!+I\u0001\u000bG>dG.Z2uS>t\u0017B\u0001+R\u0005\r\u0019V-\u001d\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000bAAZ5mK*\u0011!lW\u0001\u0004]&|'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=^\u0013\u0011BR5mKN#xN]3\t\u000b\u0001<\u0001\u0019A1\u0002\u000f1|w\rR5sgB\u0019\u0001k\u00152\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\\\u0016AA5p\u0013\t9GM\u0001\u0003GS2,W#A5\u0011\u0005)tW\"A6\u000b\u00051l\u0017\u0001B;uS2T!\u0001Q\u001b\n\u0005=\\'\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0016\u0003\u0005\f\u0001\u0002\\8h\t&\u00148\u000fI\u0001\u000fi\u0016\u001cHOR5mKN#xN]3t+\u0005)\bc\u0001)TmB\u0019q/!\u0002\u000f\u0005a|hBA=\u007f\u001d\tQX0D\u0001|\u0015\taX$\u0001\u0004=e>|GOP\u0005\u00029%\u0011!gG\u0005\u0005\u0003\u0003\t\u0019!A\u0005UKN$X\u000b^5mg*\u0011!gG\u0005\u0005\u0003\u000f\tIA\u0001\fEKR,'/\\5oSN$\u0018n\u0019$jY\u0016\u001cFo\u001c:f\u0015\u0011\t\t!a\u0001\u0002\u001fQ,7\u000f\u001e$jY\u0016\u001cFo\u001c:fg\u0002\n\u0001\u0003Z5tW\u000eCWmY6EK2\f\u00170T:\u0016\u0003\u0011\u000b\u0011\u0003Z5tW\u000eCWmY6EK2\f\u00170T:!\u0003\u0019\"W\r\\3uS>tG\u000b\u001b:piRdWM\u001d#jg.4%/Z3IK\u0006$'o\\8n\u0005f$Xm]\u000b\u0003\u0003/\u00012\u0001IA\r\u0013\r\tY\"\t\u0002\u0005\u0019>tw-A\u0014eK2,G/[8o)\"\u0014x\u000e\u001e;mKJ$\u0015n]6Ge\u0016,\u0007*Z1ee>|WNQ=uKN\u0004S#A\u001f\u0002\u000f\r|gNZ5hA\u0005QA/Z:u\u0007>tg-[4\u0016\u0003!\u000b1\u0002^3ti\u000e{gNZ5hA\u0005\u0001C/Z:u+B$\u0017\r^3ESN\\gI]3f)\"\u0014Xm\u001d5pY\u0012\u0014\u0015\u0010^3t)\t\ti\u0003E\u0002!\u0003_I1!!\r\"\u0005\u0011)f.\u001b;)\u0007Y\t)\u0004\u0005\u0003\u00028\u0005\u0015SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002@\u0005\u0005\u0013a\u00026va&$XM\u001d\u0006\u0004\u0003\u0007B\u0014!\u00026v]&$\u0018\u0002BA$\u0003s\u0011A\u0001V3ti\u0006YC/Z:u\u000f\u0016$H)\u001a7fi&|g.T1y'\u0016<W.\u001a8ugB+'OU;o)J\fgn]5uS>t7\u000fK\u0002\u0018\u0003k\u0001")
public class SegmentDeletionThrottlerConfigTest {
    private final MockTime time = new MockTime();
    private final Seq<File> logDirs = new .colon.colon((Object)TestUtils.tempFile((String)"kafka", (String)".tmp"), (List)new .colon.colon((Object)TestUtils.tempFile((String)"kafka", (String)".tmp"), (List)Nil$.MODULE$));
    private final Seq<TestUtils.DeterministicFileStore> testFileStores = (Seq)this.logDirs().map((Function1 & Serializable)x$1 -> new TestUtils.DeterministicFileStore(TestUtils$.MODULE$.DefaultTotalAvailableBytes(), TestUtils$.MODULE$.DefaultInitialUsableBytes()));
    private final int diskCheckDelayMs;
    private final long deletionThrottlerDiskFreeHeadroomBytes;
    private final KafkaConfig config;
    private final TestSegmentDeletionThrottlerConfig testConfig;

    public MockTime time() {
        return this.time;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Seq<TestUtils.DeterministicFileStore> testFileStores() {
        return this.testFileStores;
    }

    public int diskCheckDelayMs() {
        return this.diskCheckDelayMs;
    }

    public long deletionThrottlerDiskFreeHeadroomBytes() {
        return this.deletionThrottlerDiskFreeHeadroomBytes;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public TestSegmentDeletionThrottlerConfig testConfig() {
        return this.testConfig;
    }

    @Test
    public void testUpdateDiskFreeThresholdBytes() {
        Assertions.assertEquals((long)this.deletionThrottlerDiskFreeHeadroomBytes(), (long)this.testConfig().diskFreeThresholdBytes());
        this.testConfig().maybeUpdateDiskFreeThresholdBytes(false, 0x500000000L);
        Assertions.assertEquals((long)this.deletionThrottlerDiskFreeHeadroomBytes(), (long)this.testConfig().diskFreeThresholdBytes());
        this.testConfig().maybeUpdateDiskFreeThresholdBytes(true, 0x500000000L);
        Assertions.assertEquals((long)0xF00000000L, (long)this.testConfig().diskFreeThresholdBytes());
    }

    @Test
    public void testGetDeletionMaxSegmentsPerRunTransitions() {
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.time().sleep((long)this.diskCheckDelayMs());
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.time().sleep((long)this.diskCheckDelayMs());
        this.testFileStores().headOption().foreach((Function1 & Serializable)fileStore -> {
            SegmentDeletionThrottlerConfigTest.$anonfun$testGetDeletionMaxSegmentsPerRunTransitions$1(this, fileStore);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.testFileStores().headOption().foreach((Function1 & Serializable)fileStore -> {
            fileStore.writeLargeFile(1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.time().sleep((long)this.diskCheckDelayMs());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertFalse((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.testFileStores().headOption().foreach((Function1 & Serializable)fileStore -> {
            fileStore.deleteLargeFile(1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertFalse((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.time().sleep((long)this.diskCheckDelayMs());
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
    }

    public static final /* synthetic */ void $anonfun$testGetDeletionMaxSegmentsPerRunTransitions$1(SegmentDeletionThrottlerConfigTest $this, TestUtils.DeterministicFileStore fileStore) {
        long fileSize = fileStore.getUsableSpace() - $this.testConfig().diskFreeThresholdBytes();
        Assertions.assertTrue((fileSize > 0L ? 1 : 0) != 0);
        fileStore.writeLargeFile(fileSize);
    }

    public SegmentDeletionThrottlerConfigTest() {
        this.diskCheckDelayMs = 100;
        this.deletionThrottlerDiskFreeHeadroomBytes = 0xA00000000L;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), TestUtils$.MODULE$.MockZkConnect());
        props.put(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "25");
        props.put(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), Long.toString(this.deletionThrottlerDiskFreeHeadroomBytes()));
        this.config = new KafkaConfig((Map)props);
        this.testConfig = new TestSegmentDeletionThrottlerConfig((Time)this.time(), this.config(), this.diskCheckDelayMs());
    }

    public class TestSegmentDeletionThrottlerConfig
    extends SegmentDeletionThrottlerConfig {
        public Seq<FileStore> fileStores(Seq<File> logDirs) {
            return this.kafka$log$SegmentDeletionThrottlerConfigTest$TestSegmentDeletionThrottlerConfig$$$outer().testFileStores();
        }

        public /* synthetic */ SegmentDeletionThrottlerConfigTest kafka$log$SegmentDeletionThrottlerConfigTest$TestSegmentDeletionThrottlerConfig$$$outer() {
            return SegmentDeletionThrottlerConfigTest.this;
        }

        public TestSegmentDeletionThrottlerConfig(Time time, KafkaConfig config, int diskCheckMinDelayMs) {
            if (SegmentDeletionThrottlerConfigTest.this == null) {
                throw null;
            }
            super(time, config, diskCheckMinDelayMs);
        }
    }
}

