/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.ChecksumInfo;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dB\u0011B\u000b\u0001A\u0002\u0003\u0007I\u0011A\u0016\t\u0013i\u0002\u0001\u0019!a\u0001\n\u0003Y\u0004\"C!\u0001\u0001\u0004\u0005\t\u0015)\u0003-\u0011\u001d\u0011\u0005A1A\u0005\u0002\rCaa\u0012\u0001!\u0002\u0013!\u0005b\u0002%\u0001\u0005\u0004%\t!\u0013\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002&\t\u000f9\u0003!\u0019!C\u0001\u001f\"1A\f\u0001Q\u0001\nACq!\u0018\u0001C\u0002\u0013\u0005a\f\u0003\u0004c\u0001\u0001\u0006Ia\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006a\u0002!\t\u0001\u001a\u0005\u0006k\u0002!\t\u0001\u001a\u0005\u0006u\u0002!\t\u0001\u001a\u0005\u0006y\u0002!\t\u0001\u001a\u0005\u0006}\u0002!\t\u0001\u001a\u0005\u0007\u0003\u0003\u0001A\u0011\u00013\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001BBA\u0010\u0001\u0011\u0005A\r\u0003\u0004\u0002$\u0001!\t\u0001\u001a\u0005\u0007\u0003O\u0001A\u0011\u00013\u0003\u001bQKW.Z%oI\u0016DH+Z:u\u0015\tYB$A\u0002m_\u001eT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003i\t1!\u001b3y+\u0005a\u0003CA\u00179\u001b\u0005q#BA\u000e0\u0015\t\u0001\u0014'A\u0005j]R,'O\\1mg*\u0011!gM\u0001\bgR|'/Y4f\u0015\tiBG\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<\u0017BA\u001d/\u0005%!\u0016.\\3J]\u0012,\u00070A\u0004jIb|F%Z9\u0015\u0005qz\u0004CA\u0011>\u0013\tq$E\u0001\u0003V]&$\bb\u0002!\u0004\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\n\u0014\u0001B5eq\u0002\n!\"\\1y\u000b:$(/[3t+\u0005!\u0005CA\u0011F\u0013\t1%EA\u0002J]R\f1\"\\1y\u000b:$(/[3tA\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0016\u0003)\u0003\"!I&\n\u00051\u0013#\u0001\u0002'p]\u001e\f1BY1tK>3gm]3uA\u0005i1\r[3dWN,Xn\u0015;pe\u0016,\u0012\u0001\u0015\t\u0003#jk\u0011A\u0015\u0006\u0003'R\u000b\u0001b\u00195fG.\u001cX/\u001c\u0006\u0003eUS!!\b,\u000b\u0005]C\u0016!C2p]\u001adW/\u001a8u\u0015\u0005I\u0016AA5p\u0013\tY&K\u0001\tFe\u0015\u001b\u0005.Z2lgVl7\u000b^8sK\u0006q1\r[3dWN,Xn\u0015;pe\u0016\u0004\u0013AD2iK\u000e\\7/^7QCJ\fWn]\u000b\u0002?B\u0011\u0011\u000bY\u0005\u0003CJ\u0013ab\u00115fG.\u001cX/\u001c)be\u0006l7/A\bdQ\u0016\u001c7n];n!\u0006\u0014\u0018-\\:!\u0003\u0015\u0019X\r^;q)\u0005a\u0004FA\u0007g!\t9g.D\u0001i\u0015\tI'.A\u0002ba&T!a\u001b7\u0002\u000f),\b/\u001b;fe*\u0011QNN\u0001\u0006UVt\u0017\u000e^\u0005\u0003_\"\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007F\u0001\bs!\t97/\u0003\u0002uQ\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u000bi\u0016\u001cH\u000fT8pWV\u0003\bFA\bx!\t9\u00070\u0003\u0002zQ\n!A+Z:u\u0003%!Xm\u001d;F]R\u0014\u0018\u0010\u000b\u0002\u0011o\u0006\tB/Z:u\u000b:$(/_(wKJ4Gn\\<)\u0005E9\u0018\u0001\u0004;fgR$&/\u001e8dCR,\u0007F\u0001\nx\u0003)!Xm\u001d;BaB,g\u000e\u001a\u0015\u0003']\fQ\"\u00199qK:$WI\u001c;sS\u0016\u001cHc\u0001\u001f\u0002\n!1\u00111\u0002\u000bA\u0002\u0011\u000b!B\\;n\u000b:$(/[3t\u0003MqwN\\#ySN$XM\u001c;UK6\u0004h)\u001b7f)\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005mQBAA\u000b\u0015\rI\u0016q\u0003\u0006\u0003\u00033\tAA[1wC&!\u0011QDA\u000b\u0005\u00111\u0015\u000e\\3\u0002\u001fQ,7\u000f^*b]&$\u0018p\u00115fG.D#AF<\u0002\u0015Q,7\u000f\u001e*f_B,g\u000e\u000b\u0002\u0018o\u0006YB/Z:u\u0007\",7m[:v[V\u0003H-\u0019;fI>s\u0017\t\u001d9f]\u0012D#\u0001G<")
public class TimeIndexTest {
    private TimeIndex idx;
    private final int maxEntries;
    private final long baseOffset;
    private final E2EChecksumStore checksumStore = TestUtils$.MODULE$.createChecksumStore();
    private final ChecksumParams checksumParams = new ChecksumParams(Optional.of(this.checksumStore()), true, true);

    public TimeIndex idx() {
        return this.idx;
    }

    public void idx_$eq(TimeIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public E2EChecksumStore checksumStore() {
        return this.checksumStore;
    }

    public ChecksumParams checksumParams() {
        return this.checksumParams;
    }

    @BeforeEach
    public void setup() {
        this.idx_$eq(new TimeIndex(this.nonExistentTempFile(), this.baseOffset(), this.maxEntries() * 12, this.checksumParams()));
    }

    @AfterEach
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
            return;
        }
    }

    @Test
    public void testLookUp() {
        Assertions.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(100L));
        this.appendEntries(this.maxEntries() - 1);
        Assertions.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(9L));
        Assertions.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().lookup(25L));
        Assertions.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().lookup(30L));
    }

    @Test
    public void testEntry() {
        this.appendEntries(this.maxEntries() - 1);
        Assertions.assertEquals((Object)new TimestampOffset(10L, 55L), (Object)this.idx().entry(0));
        Assertions.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().entry(1));
        Assertions.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().entry(2));
        Assertions.assertEquals((Object)new TimestampOffset(40L, 85L), (Object)this.idx().entry(3));
    }

    @Test
    public void testEntryOverflow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().entry(0));
    }

    @Test
    public void testTruncate() {
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncate();
        Assertions.assertEquals((int)0, (int)this.idx().entries());
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncateTo(10L + this.baseOffset());
        Assertions.assertEquals((int)0, (int)this.idx().entries());
    }

    @Test
    public void testAppend() {
        this.appendEntries(this.maxEntries() - 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().maybeAppend(10000L, 1000L, System.currentTimeMillis()));
        Assertions.assertThrows(InvalidOffsetException.class, () -> this.idx().maybeAppend(10000L, (long)(this.maxEntries() - 2) * 10L, true));
        this.idx().maybeAppend(10000L, 1000L, true);
    }

    private void appendEntries(int numEntries) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numEntries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.idx().maybeAppend((long)i * 10L, (long)(i * 10) + this.baseOffset(), System.currentTimeMillis()));
    }

    public File nonExistentTempFile() {
        File file = TestUtils.tempFile((String)"kafka", (String)".tmp");
        file.delete();
        return file;
    }

    @Test
    public void testSanityCheck() {
        this.idx().sanityCheck();
        this.appendEntries(5);
        TimestampOffset firstEntry = this.idx().entry(0);
        this.idx().sanityCheck();
        this.idx().close();
        BooleanRef shouldCorruptOffset = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptTimestamp = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptLength = BooleanRef.create((boolean)false);
        this.idx_$eq(new TimeIndex(this, shouldCorruptOffset, shouldCorruptTimestamp, firstEntry, shouldCorruptLength){
            private final BooleanRef shouldCorruptOffset$1;
            private final BooleanRef shouldCorruptTimestamp$1;
            private final TimestampOffset firstEntry$1;
            private final BooleanRef shouldCorruptLength$1;

            public TimestampOffset lastEntry() {
                TimestampOffset superLastEntry = super.lastEntry();
                long offset = this.shouldCorruptOffset$1.elem ? this.baseOffset() - 1L : superLastEntry.offset;
                long timestamp = this.shouldCorruptTimestamp$1.elem ? this.firstEntry$1.timestamp - 1L : superLastEntry.timestamp;
                return new TimestampOffset(timestamp, offset);
            }

            public long length() {
                long superLength = super.length();
                if (this.shouldCorruptLength$1.elem) {
                    return superLength - 1L;
                }
                return superLength;
            }
            {
                this.shouldCorruptOffset$1 = shouldCorruptOffset$1;
                this.shouldCorruptTimestamp$1 = shouldCorruptTimestamp$1;
                this.firstEntry$1 = firstEntry$1;
                this.shouldCorruptLength$1 = shouldCorruptLength$1;
                super($outer.idx().file(), $outer.baseOffset(), $outer.maxEntries() * 12, true, true, $outer.checksumParams());
            }
        });
        shouldCorruptOffset.elem = true;
        Assertions.assertThrows(CorruptIndexException.class, () -> this.idx().sanityCheck());
        shouldCorruptOffset.elem = false;
        shouldCorruptTimestamp.elem = true;
        Assertions.assertThrows(CorruptIndexException.class, () -> this.idx().sanityCheck());
        shouldCorruptTimestamp.elem = false;
        shouldCorruptLength.elem = true;
        Assertions.assertThrows(CorruptIndexException.class, () -> this.idx().sanityCheck());
        shouldCorruptLength.elem = false;
        this.idx().sanityCheck();
        this.idx().close();
    }

    @Test
    public void testReopen() {
        this.appendEntries(5);
        Assertions.assertEquals((int)5, (int)this.idx().entries());
        this.idx().close();
        Assertions.assertThrows(IllegalStateException.class, () -> new TimeIndex(this.idx().file(), this.baseOffset(), this.maxEntries() * 12, false, true, this.checksumParams()));
        this.idx_$eq(new TimeIndex(this.idx().file(), this.baseOffset(), this.maxEntries() * 12, true, true, this.checksumParams()));
        Assertions.assertEquals((int)5, (int)this.idx().entries());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int timestamp = i * 10;
            long offset = (long)(i * 10) + this.baseOffset();
            Assertions.assertEquals((Object)new TimestampOffset((long)timestamp, offset), (Object)this.idx().lookup((long)timestamp));
        });
    }

    @Test
    public void testChecksumUpdatedOnAppend() {
        ChecksumStore store = this.checksumStore().store();
        store.initializeEntry(this.idx().file().getAbsolutePath());
        store.initializeEntry("expected");
        this.idx().maybeAppend(1000L, 2000L, true);
        store.update("expected", 1000L);
        store.update("expected", (int)(2000L - this.baseOffset()));
        long expectedChecksum = ((ChecksumInfo)store.get("expected").get()).checksum().getValue();
        long actualChecksum = ((ChecksumInfo)store.get(this.idx().file().getAbsolutePath()).get()).checksum().getValue();
        Assertions.assertEquals((long)expectedChecksum, (long)actualChecksum);
    }

    public TimeIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

