/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.util.Collections;
import java.util.Optional;
import kafka.log.LogTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.log.TxnIndexSearchResult;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=B\u0011B\r\u0001A\u0002\u0003\u0007I\u0011A\u001a\t\u0013q\u0002\u0001\u0019!a\u0001\n\u0003i\u0004\"C\"\u0001\u0001\u0004\u0005\t\u0015)\u00035\u0011%!\u0005\u00011AA\u0002\u0013\u0005Q\tC\u0005U\u0001\u0001\u0007\t\u0019!C\u0001+\"Iq\u000b\u0001a\u0001\u0002\u0003\u0006KA\u0012\u0005\b1\u0002\u0011\r\u0011\"\u0001Z\u0011\u0019i\u0006\u0001)A\u00055\"9a\f\u0001b\u0001\n\u0003y\u0006BB6\u0001A\u0003%\u0001\rC\u0004m\u0001\t\u0007I\u0011A7\t\rE\u0004\u0001\u0015!\u0003o\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0015y\b\u0001\"\u0001t\u0011\u0019\tI\u0001\u0001C\u0001g\"1\u00111\u0003\u0001\u0005\u0002MDa!a\u0006\u0001\t\u0003\u0019\bBBA\u000e\u0001\u0011\u00051\u000f\u0003\u0004\u0002 \u0001!\ta\u001d\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u0019\t)\u0006\u0001C\u0001g\"9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003BBA3\u0001\u0011\u00051\u000f\u0003\u0004\u0002j\u0001!\ta\u001d\u0005\u0007\u0003[\u0002A\u0011A:\t\r\u0005E\u0004\u0001\"\u0001t\u0011\u0019\t)\b\u0001C\u0001g\"1\u0011\u0011\u0010\u0001\u0005\u0002MDa!! \u0001\t\u0003\u0019\bBBAA\u0001\u0011\u00051\u000fC\u0004\u0002\u0006\u0002!I!a\"\u0003)Q\u0013\u0018M\\:bGRLwN\\%oI\u0016DH+Z:u\u0015\t\u0019C%A\u0002m_\u001eT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"!\r\u0001\u000e\u0003\t\nAAZ5mKV\tA\u0007\u0005\u00026u5\taG\u0003\u00028q\u0005\u0011\u0011n\u001c\u0006\u0002s\u0005!!.\u0019<b\u0013\tYdG\u0001\u0003GS2,\u0017\u0001\u00034jY\u0016|F%Z9\u0015\u0005y\n\u0005CA\u0015@\u0013\t\u0001%F\u0001\u0003V]&$\bb\u0002\"\u0004\u0003\u0003\u0005\r\u0001N\u0001\u0004q\u0012\n\u0014!\u00024jY\u0016\u0004\u0013!B5oI\u0016DX#\u0001$\u0011\u0005\u001d\u0013V\"\u0001%\u000b\u0005\rJ%B\u0001&L\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002M\u001b\u000691\u000f^8sC\u001e,'BA\u0013O\u0015\ty\u0005+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0006\u0019qN]4\n\u0005MC%\u0001\u0005+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3y\u0003%Ig\u000eZ3y?\u0012*\u0017\u000f\u0006\u0002?-\"9!IBA\u0001\u0002\u00041\u0015AB5oI\u0016D\b%\u0001\u0004pM\u001a\u001cX\r^\u000b\u00025B\u0011\u0011fW\u0005\u00039*\u0012A\u0001T8oO\u00069qN\u001a4tKR\u0004\u0013!D2iK\u000e\\7/^7Ti>\u0014X-F\u0001a!\t\t\u0017.D\u0001c\u0015\t\u0019G-\u0001\u0005dQ\u0016\u001c7n];n\u0015\taUM\u0003\u0002&M*\u0011q\r[\u0001\nG>tg\r\\;f]RT\u0011aN\u0005\u0003U\n\u0014\u0001#\u0012\u001aF\u0007\",7m[:v[N#xN]3\u0002\u001d\rDWmY6tk6\u001cFo\u001c:fA\u0005q1\r[3dWN,X\u000eU1sC6\u001cX#\u00018\u0011\u0005\u0005|\u0017B\u00019c\u00059\u0019\u0005.Z2lgVl\u0007+\u0019:b[N\fqb\u00195fG.\u001cX/\u001c)be\u0006l7\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002}!\u0012a\"\u001e\t\u0003mvl\u0011a\u001e\u0006\u0003qf\f1!\u00199j\u0015\tQ80A\u0004kkBLG/\u001a:\u000b\u0005q\u0004\u0016!\u00026v]&$\u0018B\u0001@x\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fZ8x]\"\u001aq\"a\u0001\u0011\u0007Y\f)!C\u0002\u0002\b]\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002EQ,7\u000f\u001e)pg&$\u0018n\u001c8TKR\u001cuN\u001d:fGRd\u0017p\u00165f]>\u0003XM\\3eQ\r\u0001\u0012Q\u0002\t\u0004m\u0006=\u0011bAA\to\n!A+Z:u\u0003\r\"Xm\u001d;SK>\u0004XM\u001c$bS2<\u0006.\u001a8GS2,\u0017\t\u001c:fC\u0012LX\t_5tiND3!EA\u0007\u0003=!Xm\u001d;TC:LG/_\"iK\u000e\\\u0007f\u0001\n\u0002\u000e\u0005QB/Z:u\u0019\u0006\u001cHo\u00144gg\u0016$X*^:u\u0013:\u001c'/Z1tK\"\u001a1#!\u0004\u00029Q,7\u000f\u001e'bgR|eMZ:fi\u000e\u000bgN\\8u\t\u0016\u001c'/Z1tK\"\u001aA#!\u0004\u0002=Q,7\u000f^\"pY2,7\r^!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cHc\u0001 \u0002(!9\u0011\u0011F\u000bA\u0002\u0005-\u0012AF:i_VdGMV1mS\u0012\fG/Z\"iK\u000e\\7/^7\u0011\u0007%\ni#C\u0002\u00020)\u0012qAQ8pY\u0016\fg\u000eK\u0002\u0016\u0003g\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sI\u0018A\u00029be\u0006l7/\u0003\u0003\u0002>\u0005]\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":Q#!\u0011\u0002N\u0005=\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\t\u0005\u001d\u0013qG\u0001\taJ|g/\u001b3fe&!\u00111JA#\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdC!!\u0015\u0002Te\t\u0011!G\u0001\u0001\u0003A\"Xm\u001d;D_2dWm\u0019;BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7O\u0012:p[\u000e{'O];qi\u0016$\u0017J\u001c3fq\"\u001aa#!\u0004\u0002\u0019Q,7\u000f\u001e+sk:\u001c\u0017\r^3\u0015\u0007y\ni\u0006C\u0004\u0002*]\u0001\r!a\u000b)\u0007]\t\u0019\u0004K\u0004\u0018\u0003\u0003\ni%a\u0019-\t\u0005E\u00131K\u0001\u0014i\u0016\u001cH/\u00112peR,G\r\u0016=o'\u0016\u0014H-\u001a\u0015\u00041\u00055\u0011a\u0004;fgR\u0014VM\\1nK&sG-\u001a=)\u0007e\ti!A\nuKN$X\u000b\u001d3bi\u0016\u0004\u0016M]3oi\u0012K'\u000fK\u0002\u001b\u0003\u001b\t1\u0004^3ti\u000eCWmY6tk6,\u0006\u000fZ1uK\u0012|e.\u00119qK:$\u0007fA\u000e\u0002\u000e\u0005!D/Z:u\u0007\",7m[:v[:{G/\u00169eCR,G-\u00134DQ\u0016\u001c7n];n!J|G/Z2uS>t\u0017j\u001d#jg\u0006\u0014G.\u001a3)\u0007q\ti!\u0001\fuKN$8\t[3dWN,X\u000e\u0016:v]\u000e\fG/[8oQ\ri\u0012QB\u0001Bi\u0016\u001cHOU3Pa\u0016t\u0017N\\4B]\u0016C\u0018n\u001d;j]\u001eLe\u000eZ3y/&dGNT8u%\u0016Le.\u001b;jC2L'0Z\"iK\u000e\\7/^7Ti>\u0014X-\u00128uefD3AHA\u0007\u0003\r#Xm\u001d;DQ\u0016\u001c7n];n!J|G/Z2uS>t7\u000b[8vY\u0012\u0014U-\u00128bE2,G-\u00134F]R\u0014\u00180\u0012=jgR|eNU3Pa\u0016t\u0017N\\4B]&sG-\u001a=)\u0007}\ti!\u0001\bwKJLg-_\"iK\u000e\\7/^7\u0015\u000by\nI)a#\t\u000b\u0011\u0003\u0003\u0019\u0001$\t\u000f\u00055\u0005\u00051\u0001\u0002\u0010\u0006)1\u000f^8sKB\u0019\u0011-!%\n\u0007\u0005M%MA\u0007DQ\u0016\u001c7n];n'R|'/\u001a")
public class TransactionIndexTest {
    private File file;
    private TransactionIndex index;
    private final long offset;
    private final E2EChecksumStore checksumStore = TestUtils$.MODULE$.createChecksumStore();
    private final ChecksumParams checksumParams = new ChecksumParams(Optional.of(this.checksumStore()), true, true);

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    public E2EChecksumStore checksumStore() {
        return this.checksumStore;
    }

    public ChecksumParams checksumParams() {
        return this.checksumParams;
    }

    @BeforeEach
    public void setup() {
        this.file_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        this.index_$eq(new TransactionIndex(this.offset(), this.file(), false, this.checksumParams()));
    }

    @AfterEach
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        .colon.colon abortedTxns = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTxns.foreach(arg_0 -> TransactionIndexTest.$anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file(), true, this.checksumParams());
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTxns.$plus$plus((IterableOnce)new .colon.colon((Object)anotherAbortedTxn, (List)Nil$.MODULE$))).asJava(), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test
    public void testReopenFailWhenFileAlreadyExists() {
        this.index().append(new AbortedTxn(0L, 0L, 10L, 11L));
        this.index().close();
        Assertions.assertThrows(IllegalStateException.class, () -> new TransactionIndex(0L, this.file(), false, this.checksumParams()));
        this.index_$eq(new TransactionIndex(this.offset(), this.file(), true, this.checksumParams()));
    }

    @Test
    public void testSanityCheck() {
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach(arg_0 -> TransactionIndexTest.$anonfun$testSanityCheck$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file(), true, this.checksumParams());
        Assertions.assertThrows(CorruptIndexException.class, () -> reopenedIndex.sanityCheck());
    }

    @Test
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 15L, 11L)));
    }

    @Test
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 10L, 11L)));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectAbortedTransactions(boolean shouldValidateChecksum) {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testCollectAbortedTransactions$1$adapted(this.index(), arg_0));
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L, shouldValidateChecksum);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)result.abortedTransactions);
        Assertions.assertFalse((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(0L, 32L, shouldValidateChecksum);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.take(3)).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(0L, 35L, shouldValidateChecksum);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(10L, 35L, shouldValidateChecksum);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(11L, 35L, shouldValidateChecksum);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.slice(1, 4)).asJava(), (Object)result.abortedTransactions);
        Assertions.assertTrue((boolean)result.isComplete);
        result = this.index().collectAbortedTxns(20L, 41L, shouldValidateChecksum);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.slice(2, 4)).asJava(), (Object)result.abortedTransactions);
        Assertions.assertFalse((boolean)result.isComplete);
    }

    @Test
    public void testCollectAbortedTransactionsFromCorruptedIndex() {
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach(arg_0 -> TransactionIndexTest.$anonfun$testCollectAbortedTransactionsFromCorruptedIndex$1$adapted(this.index(), arg_0));
        this.checksumStore().store().update(this.file().getAbsolutePath(), 123);
        Assertions.assertThrows(CorruptIndexException.class, () -> this.index().collectAbortedTxns(20L, 41L, true));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTruncate(boolean shouldValidateChecksum) {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 2L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 16L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testTruncate$1$adapted(this.index(), arg_0));
        this.index().truncateTo(51L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions).asJava(), (Object)this.index().collectAbortedTxns((long)0L, (long)100L, (boolean)shouldValidateChecksum).abortedTransactions);
        this.index().truncateTo(50L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTransactions.take(3)).asJava(), (Object)this.index().collectAbortedTxns((long)0L, (long)100L, (boolean)shouldValidateChecksum).abortedTransactions);
        this.index().reset();
        Assertions.assertEquals(Collections.emptyList(), (Object)this.index().collectAbortedTxns((long)0L, (long)100L, (boolean)shouldValidateChecksum).abortedTransactions);
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assertions.assertEquals((short)0, (short)abortedTxn.version());
        Assertions.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils.tempFile((String)"kafka", (String)".tmp");
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        java.util.List abortedTxns = this.index().collectAbortedTxns((long)0L, (long)100L, (boolean)true).abortedTransactions;
        Assertions.assertEquals((int)2, (int)abortedTxns.size());
        Assertions.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.get(0)).firstOffset());
        Assertions.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.get(1)).firstOffset());
    }

    @Test
    public void testUpdateParentDir() {
        File tmpParentDir = new File(TestUtils.tempDirectory(null, null), "parent");
        tmpParentDir.mkdir();
        Assertions.assertNotEquals((Object)tmpParentDir, (Object)this.index().file().getParentFile());
        this.index().updateParentDir(tmpParentDir);
        Assertions.assertEquals((Object)tmpParentDir, (Object)this.index().file().getParentFile());
    }

    @Test
    public void testChecksumUpdatedOnAppend() {
        ChecksumStore store = this.checksumStore().store();
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach(arg_0 -> TransactionIndexTest.$anonfun$testChecksumUpdatedOnAppend$1$adapted(this.index(), arg_0));
        this.verifyChecksum(this.index(), store);
    }

    @Test
    public void testChecksumNotUpdatedIfChecksumProtectionIsDisabled() {
        .colon.colon abortedTxns = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        this.index_$eq(new TransactionIndex(this.offset(), this.file(), false, new ChecksumParams(Optional.of(this.checksumStore()), false, false)));
        abortedTxns.foreach(arg_0 -> TransactionIndexTest.$anonfun$testChecksumNotUpdatedIfChecksumProtectionIsDisabled$1$adapted(this.index(), arg_0));
        Assertions.assertEquals((int)0, (int)this.checksumStore().store().size());
    }

    @Test
    public void testChecksumTruncation() {
        ChecksumStore store = this.checksumStore().store();
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 2L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 16L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach(arg_0 -> TransactionIndexTest.$anonfun$testChecksumTruncation$1$adapted(this.index(), arg_0));
        this.verifyChecksum(this.index(), store);
        this.index().truncateTo(100L);
        this.verifyChecksum(this.index(), store);
        this.index().truncateTo(51L);
        this.verifyChecksum(this.index(), store);
        this.index().truncateTo(50L);
        this.verifyChecksum(this.index(), store);
        this.index().truncateTo(15L);
        this.verifyChecksum(this.index(), store);
        this.index().truncateTo(0L);
        this.verifyChecksum(this.index(), store);
        this.index().reset();
        this.verifyChecksum(this.index(), store);
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        this.index().truncateTo(0L);
        this.verifyChecksum(this.index(), store);
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().reset();
        this.verifyChecksum(this.index(), store);
    }

    @Test
    public void testReOpeningAnExistingIndexWillNotReInitializeChecksumStoreEntry() {
        ChecksumStore store = this.checksumStore().store();
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().close();
        this.verifyChecksum(this.index(), store);
        TransactionIndex reOpenedIndex = new TransactionIndex(this.offset(), this.index().file(), true, this.checksumParams());
        reOpenedIndex.append(new AbortedTxn(1L, 5L, 15L, 16L));
        this.verifyChecksum(reOpenedIndex, store);
    }

    @Test
    public void testChecksumProtectionShouldBeEnabledIfEntryExistOnReOpeningAnIndex() {
        ChecksumStore store = this.checksumStore().store();
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().close();
        TransactionIndex reOpenedIndex = new TransactionIndex(this.offset(), this.index().file(), true, this.checksumParams());
        reOpenedIndex.append(new AbortedTxn(1L, 5L, 15L, 16L));
        this.verifyChecksum(reOpenedIndex, store);
    }

    private void verifyChecksum(TransactionIndex index, ChecksumStore store) {
        Optional actualChecksum = store.get(index.file().getAbsolutePath());
        Assertions.assertEquals(LogTestUtils$.MODULE$.getChecksumInfoForFile(store, index.file(), (int)index.file().length(), true), (Object)actualChecksum);
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }

    public static final /* synthetic */ Object $anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(TransactionIndex eta$0$1$1, AbortedTxn x$1) {
        eta$0$1$1.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSanityCheck$1$adapted(TransactionIndex eta$0$1$2, AbortedTxn x$1) {
        eta$0$1$2.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCollectAbortedTransactions$1$adapted(TransactionIndex eta$0$1$3, AbortedTxn x$1) {
        eta$0$1$3.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCollectAbortedTransactionsFromCorruptedIndex$1$adapted(TransactionIndex eta$0$1$4, AbortedTxn x$1) {
        eta$0$1$4.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncate$1$adapted(TransactionIndex eta$0$1$5, AbortedTxn x$1) {
        eta$0$1$5.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testChecksumUpdatedOnAppend$1$adapted(TransactionIndex eta$0$1$6, AbortedTxn x$1) {
        eta$0$1$6.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testChecksumNotUpdatedIfChecksumProtectionIsDisabled$1$adapted(TransactionIndex eta$0$1$7, AbortedTxn x$1) {
        eta$0$1$7.append(x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testChecksumTruncation$1$adapted(TransactionIndex eta$0$1$8, AbortedTxn x$1) {
        eta$0$1$8.append(x$1);
        return BoxedUnit.UNIT;
    }
}

