/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.metrics.BrokerLoad;
import kafka.network.DataPlaneAcceptor$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

@Timeout(value=120000L)
@ScalaSignature(bytes="\u0006\u0005\t}f\u0001B\u001b7\u0001mBQ\u0001\u0013\u0001\u0005\u0002%Cq\u0001\u0014\u0001C\u0002\u0013\u0005Q\n\u0003\u0004R\u0001\u0001\u0006IA\u0014\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0011\u0019\t\u0007\u0001)A\u0005)\"I!\r\u0001a\u0001\u0002\u0004%\ta\u0019\u0005\nO\u0002\u0001\r\u00111A\u0005\u0002!D\u0011B\u001c\u0001A\u0002\u0003\u0005\u000b\u0015\u00023\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0003y\u0007\"C<\u0001\u0001\u0004\u0005\r\u0011\"\u0001y\u0011%Q\b\u00011A\u0001B\u0003&\u0001\u000fC\u0004|\u0001\t\u0007I\u0011\u0001?\t\u000f\u0005-\u0001\u0001)A\u0005{\"I\u0011Q\u0002\u0001C\u0002\u0013\u0005\u0011q\u0002\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u0012!A\u00111\u0005\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002&\u0001\u0001\u000b\u0011B?\t\u0013\u0005\u001d\u0002A1A\u0005\u0002\u0005%\u0002\u0002CA\u001b\u0001\u0001\u0006I!a\u000b\t\u0013\u0005]\u0002A1A\u0005\u0002\u0005e\u0002\u0002CA#\u0001\u0001\u0006I!a\u000f\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0004bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bDq!a2\u0001\t\u0013\tI\rC\u0004\u0002L\u0002!I!!4\t\u0013\u0005e\u0007!%A\u0005\n\u0005m\u0007bBAy\u0001\u0011\u0005\u00111\u001f\u0005\b\u0005\u0017\u0001A\u0011AAz\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003gDqAa\u0005\u0001\t\u0003\t\u0019\u0010C\u0004\u0003\u0018\u0001!IA!\u0007\t\u0013\t5\u0003!%A\u0005\n\t=\u0003b\u0002B\f\u0001\u0011%!1\u000b\u0005\b\u0005?\u0002A\u0011AAz\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0003gDqAa\u001a\u0001\t\u0003\t\u0019\u0010C\u0004\u0003l\u0001!\t!a=\t\u000f\t=\u0004\u0001\"\u0001\u0002t\"9!1\u000f\u0001\u0005\u0002\u0005M\bb\u0002B<\u0001\u0011\u0005\u00111\u001f\u0005\b\u0005w\u0002A\u0011AAz\u0011\u001d\u0011y\b\u0001C\u0001\u0003gDqAa!\u0001\t\u0003\t\u0019\u0010C\u0004\u0003\b\u0002!\t!a=\t\u000f\t-\u0005\u0001\"\u0001\u0003\u000e\"9!\u0011\u0014\u0001\u0005\u0002\u0005M\bb\u0002BO\u0001\u0011\u0005\u00111\u001f\u0005\b\u0005C\u0003A\u0011\u0002BR\u0011\u001d\u0011I\u000b\u0001C\u0001\u0003g\u0014aB\u0011:pW\u0016\u0014Hj\\1e)\u0016\u001cHO\u0003\u00028q\u00059Q.\u001a;sS\u000e\u001c(\"A\u001d\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0010\"\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\r\u0005s\u0017PU3g!\t\u0019e)D\u0001E\u0015\t)\u0005(A\u0003vi&d7/\u0003\u0002H\t\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001K!\tY\u0005!D\u00017\u0003\u0019qw\u000eZ3JIV\ta\n\u0005\u0002>\u001f&\u0011\u0001K\u0010\u0002\u0004\u0013:$\u0018a\u00028pI\u0016LE\rI\u0001\u0005i&lW-F\u0001U!\t)v,D\u0001W\u0015\t9\u0006,\u0001\u0003vi&d'BA-[\u0003\u0019\u0019XM\u001d<fe*\u0011\u0011h\u0017\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a-\nAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0006ce>\\WM\u001d'pC\u0012,\u0012\u0001\u001a\t\u0003\u0017\u0016L!A\u001a\u001c\u0003\u0015\t\u0013xn[3s\u0019>\fG-\u0001\bce>\\WM\u001d'pC\u0012|F%Z9\u0015\u0005%d\u0007CA\u001fk\u0013\tYgH\u0001\u0003V]&$\bbB7\b\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\n\u0014a\u00032s_.,'\u000fT8bI\u0002*\u0012\u0001\u001d\t\u0003cVl\u0011A\u001d\u0006\u0003oMT!\u0001\u001e.\u0002\r\r|W.\\8o\u0013\t1(OA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003SfDq!\u001c\u0006\u0002\u0002\u0003\u0007\u0001/\u0001\u0005nKR\u0014\u0018nY:!\u0003a\u0019V\r\\3di>\u0014X*\u001a;sS\u000e\u001cxI\u001d9Qe\u00164\u0017\u000e_\u000b\u0002{B\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!A.\u00198h\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005\u007f\n11\u000b\u001e:j]\u001e\f\u0011dU3mK\u000e$xN]'fiJL7m]$saB\u0013XMZ5yA\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003bkRD'bAA\u000eg\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002 \u0005U!\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0003E\u0019XmY;sSRL\bK]8u_\u000e|G\u000eI\u0001\u0018[VdG/\u001b+f]\u0006tG\u000fT5ti\u0016tWM\u001d(b[\u0016\f\u0001$\\;mi&$VM\\1oi2K7\u000f^3oKJt\u0015-\\3!\u00031!WMZ1vYR\u0004&o\u001c9t+\t\tY\u0003\u0005\u0003\u0002.\u0005ERBAA\u0018\u0015\r9\u00161A\u0005\u0005\u0003g\tyC\u0001\u0006Qe>\u0004XM\u001d;jKN\fQ\u0002Z3gCVdG\u000f\u0015:paN\u0004\u0013!\u00043fM\u0006,H\u000e^\"p]\u001aLw-\u0006\u0002\u0002<A!\u0011QHA!\u001b\t\tyD\u0003\u0002Zq%!\u00111IA \u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001d\u0011,g-Y;mi\u000e{gNZ5hA\u0005iQn\\2l'\u0016dWm\u0019;peN$B!a\u0013\u0002pA1\u0011QJA/\u0003GrA!a\u0014\u0002Z9!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002Vi\na\u0001\u0010:p_Rt\u0014\"A \n\u0007\u0005mc(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0013\u0011\r\u0002\u0005\u0019&\u001cHOC\u0002\u0002\\y\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003S\u001a\u0018a\u00028fi^|'o[\u0005\u0005\u0003[\n9G\u0001\u0005TK2,7\r^8s\u0011\u00159d\u00031\u0001q\u0003AiwnY6LC\u001a\\\u0017m\u00115b]:,G\u000e\u0006\u0005\u0002v\u0005m\u0014QQAE!\u0011\t)'a\u001e\n\t\u0005e\u0014q\r\u0002\r\u0017\u000647.Y\"iC:tW\r\u001c\u0005\b\u0003{:\u0002\u0019AA@\u00031\u0011XmZ5ti\u0016\u0014H+[7f!\ri\u0014\u0011Q\u0005\u0004\u0003\u0007s$\u0001\u0002'p]\u001eDq!a\"\u0018\u0001\u0004\ty(A\u0007iC:$7\u000f[1lKRKW.\u001a\u0005\b\u0003\u0017;\u0002\u0019AA@\u0003I\tW\u000f\u001e5f]RL7-\u0019;j_:$\u0016.\\3\u0002/5|7m['vYRLG+\u001a8b]RlU\r^1eCR\fG\u0003BAI\u0003;\u0003B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0004\u0003/C\u0016aC7vYRLG/\u001a8b]RLA!a'\u0002\u0016\n\u0019R*\u001e7uSR+g.\u00198u\u001b\u0016$\u0018\rZ1uC\"9\u0011q\u0014\rA\u0002\u0005\u0005\u0016A\u00027lG&#7\u000f\u0005\u0004\u0002$\u0006-\u0016\u0011\u0017\b\u0005\u0003K\u000b9\u000bE\u0002\u0002RyJ1!!+?\u0003\u0019\u0001&/\u001a3fM&!\u0011QVAX\u0005\r\u0019V\r\u001e\u0006\u0004\u0003Ss\u0004\u0003BAR\u0003gKA!!\u0003\u00020\u0006Ia.\u00198pgR{Wj\u001d\u000b\u0005\u0003s\u000by\fE\u0002>\u0003wK1!!0?\u0005\u0019!u.\u001e2mK\"9\u0011\u0011Y\rA\u0002\u0005}\u0014!\u00028b]>\u001c\u0018a\u0004:b]\u0012|W\u000eV5nK:\u000bgn\\:\u0016\u0005\u0005}\u0014a\u0003:b]\u0012|WNU1uS>,\"!!/\u00025]\f\u0017\u000e^!oI\u001e+GO\u0011:pW\u0016\u0014Hj\\1e\u001b\u0016$(/[2\u0015\t\u0005=\u0017q\u001b\t\u0005\u0003#\f\u0019.D\u0001t\u0013\r\t)n\u001d\u0002\u0007\u001b\u0016$(/[2\t\u000f\td\u0002\u0013!a\u0001I\u0006!s/Y5u\u0003:$w)\u001a;Ce>\\WM\u001d'pC\u0012lU\r\u001e:jG\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002^*\u001aA-a8,\u0005\u0005\u0005\b\u0003BAr\u0003[l!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a;?\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\f)OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004^3ti\n\u0013xn[3s\u0019>\fG-T3ue&\u001cw+Z5hQR\u001cH#A5)\u0007y\t9\u0010\u0005\u0003\u0002z\n\u001dQBAA~\u0015\u0011\ti0a@\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003\u0002\t\r\u0011a\u00026va&$XM\u001d\u0006\u0004\u0005\u000bi\u0016!\u00026v]&$\u0018\u0002\u0002B\u0005\u0003w\u0014A\u0001V3ti\u0006)B/Z:u\u001d>$8\u000b^1si&tw-T3ue&\u001c\u0007fA\u0010\u0002x\u0006\u0011C/Z:u/J\f\u0007/\u0011:pk:$'+Z2pe\u0012,'OU3rk\u0016\u001cHo](oYfD3\u0001IA|\u0003i!Xm\u001d;J]\u000e\u0014X-\\3oi\u0006dGj\\1e\u0003Z,'/Y4fQ\r\t\u0013q_\u0001\u001ci\u0016\u001cHoV5uQN\u000bW\u000e\u001d7fg\u0012K7\u000f\u001e:jEV$\u0018n\u001c8\u0015\u000f%\u0014YBa\u0010\u0003J!9!Q\u0004\u0012A\u0002\t}\u0011AB3wK:$8\u000f\u0005\u0004\u0003\"\t-\"qF\u0007\u0003\u0005GQAA!\n\u0003(\u00059Q.\u001e;bE2,'b\u0001B\u0015}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t5\"1\u0005\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bcB\u001f\u00032\u0005e&QG\u0005\u0004\u0005gq$A\u0002+va2,'\u0007\u0005\u0003\u00038\tmRB\u0001B\u001d\u0015\r\u0011\u00161A\u0005\u0005\u0005{\u0011ID\u0001\u0005EkJ\fG/[8o\u0011\u001d\u0011\tE\ta\u0001\u0005\u0007\n\u0011\"Y:tKJ$\u0018n\u001c8\u0011\u0011u\u0012)%!/\u0002:&L1Aa\u0012?\u0005%1UO\\2uS>t'\u0007C\u0005\u0003L\t\u0002\n\u00111\u0001\u0002<\u000511m\u001c8gS\u001e\fQ\u0005^3ti^KG\u000f[*b[BdWm\u001d#jgR\u0014\u0018NY;uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tE#\u0006BA\u001e\u0003?$\u0012\"\u001bB+\u0005/\u0012YF!\u0018\t\u000b\t$\u0003\u0019\u00013\t\u000f\teC\u00051\u0001\u0002L\u0005I1/\u001a7fGR|'o\u001d\u0005\b\u0005;!\u0003\u0019\u0001B\u0010\u0011\u001d\u0011\t\u0005\na\u0001\u0005\u0007\n!\u0003^3ti&#G.\u001a\"s_.,'\u000fT8bI\"\u001aQ%a>\u0002+Q,7\u000f^*j]\u001edWMU3rk\u0016\u001cH\u000fT8bI\"\u001aa%a>\u0002/Q,7\u000f^'vYRL\u0007\u000f\\3SKF,Xm\u001d;M_\u0006$\u0007fA\u0014\u0002x\u0006aB/Z:u'&tw\r\\3SKF,Xm\u001d;US6,\u0017I^3sC\u001e,\u0007f\u0001\u0015\u0002x\u0006\u0001D/Z:u\u001bVdG/\u001b9mKJ+\u0017/^3tiRKW.Z!wKJ\fw-Z,ji\"LgnU1na2,\u0007+\u001a:j_\u0012D3!KA|\u0003u!Xm\u001d;Es:\fW.[2TKJ4\u0018nY3SKF,Xm\u001d;US6,\u0007f\u0001\u0016\u0002x\u0006yB/Z:u\tft\u0017-\\5d/>\u00148\u000e\\8bI\u000e{WM\u001a4jG&,g\u000e^:)\u0007-\n90A\u000euKN$X*\u001e7uSBdWmU1na2Lgn\u001a)fe&|Gm\u001d\u0015\u0004Y\u0005]\u0018\u0001\u0007;fgRlU\u000f\u001c;ja2,7+Y7qY\u0016\u001cu.\u001e8ug\"\u001aQ&a>\u0002'Q,7\u000f\u001e\"s_.,'\u000fT8bI\u000ecwn]3)\u00079\n90A\ruKN$(I]8lKJdu.\u00193JI\u0016l\u0007o\u001c;f]\u000eL\bfA\u0018\u0002x\u0006ab/\u001a:jMflU\r\u001e:jGN\f5M]8tg&s7\u000f^1oG\u0016\u001cHcA5\u0003\u0010\"9!\u0011\u0013\u0019A\u0002\tM\u0015a\u00052s_.,'\u000fT8bI&s7\u000f^1oG\u0016\u001c\b#BA\u0017\u0005+#\u0017\u0002\u0002BL\u0003_\u0011Q!U;fk\u0016\fq\u0004^3ti6+G/\u001a:t/&$\bnU1nK:\u000bW.Z%eK:$\u0018nY1mQ\r\t\u0014q_\u0001\u0013i\u0016\u001cH\u000f\u00165s_V<\u0007\u000e];u\u0019>\fG\rK\u00023\u0003o\f!\"\\5c)>\u0014\u0015\u0010^3t)\u0011\tIL!*\t\u000f\t\u001d6\u00071\u0001\u0002:\u0006\u0019Q.\u001b2\u0002\u0011Q,\u0017M\u001d#po:D3\u0001\u000eBW!\u0011\tIPa,\n\t\tE\u00161 \u0002\n\u0003\u001a$XM]#bG\"Ds\u0001\u0001B[\u0005w\u0013i\f\u0005\u0003\u0002z\n]\u0016\u0002\u0002B]\u0003w\u0014q\u0001V5nK>,H/A\u0003wC2,XMH\u0002\u0002)\u0004\u0007")
public class BrokerLoadTest
implements Logging {
    private final int nodeId;
    private final MockTime time = new MockTime();
    private BrokerLoad brokerLoad;
    private Metrics metrics;
    private final String SelectorMetricsGrpPrefix;
    private final SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
    private final String multiTenantListenerName;
    private final Properties defaultProps;
    private final KafkaConfig defaultConfig;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerLoad brokerLoad() {
        return this.brokerLoad;
    }

    public void brokerLoad_$eq(BrokerLoad x$1) {
        this.brokerLoad = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public String SelectorMetricsGrpPrefix() {
        return this.SelectorMetricsGrpPrefix;
    }

    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public String multiTenantListenerName() {
        return this.multiTenantListenerName;
    }

    public Properties defaultProps() {
        return this.defaultProps;
    }

    public KafkaConfig defaultConfig() {
        return this.defaultConfig;
    }

    private List<Selector> mockSelectors(Metrics metrics) {
        ChannelBuilder channelBuilderMock = (ChannelBuilder)Mockito.mock(ChannelBuilder.class);
        LogContext logContextMock = (LogContext)Mockito.mock(LogContext.class);
        Logger loggerMock = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logContextMock.logger(Selector.class)).thenReturn((Object)loggerMock);
        Selector selector = new Selector(0L, metrics, (Time)this.time(), this.SelectorMetricsGrpPrefix(), channelBuilderMock, logContextMock);
        return new .colon.colon((Object)selector, (List)Nil$.MODULE$);
    }

    private KafkaChannel mockKafkaChannel(long registerTime, long handshakeTime, long authenticationTime) {
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        KafkaChannel.KafkaChannelMetrics channelMetrics = (KafkaChannel.KafkaChannelMetrics)Mockito.mock(KafkaChannel.KafkaChannelMetrics.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)channelMetrics.transportHandshakeTimeNanos())).thenReturn((Object)BoxesRunTime.boxToLong((long)handshakeTime));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)channelMetrics.authenticationTimeNanos())).thenReturn((Object)BoxesRunTime.boxToLong((long)authenticationTime));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)channelMetrics.computeConnectionLocalServiceTimeNanos())).thenReturn((Object)BoxesRunTime.boxToLong((long)(registerTime + handshakeTime + authenticationTime)));
        Mockito.when((Object)channel.metrics()).thenReturn((Object)channelMetrics);
        return channel;
    }

    private MultiTenantMetadata mockMultiTenantMetadata(Set<String> lkcIds) {
        MultiTenantMetadata metadata = (MultiTenantMetadata)Mockito.mock(MultiTenantMetadata.class);
        Mockito.when((Object)metadata.kafkaLogicalClusterIds()).thenReturn((Object)CollectionConverters$.MODULE$.SetHasAsJava(lkcIds).asJava());
        return metadata;
    }

    private double nanosToMs(long nanos) {
        long positiveNanos = package$.MODULE$.max(nanos, 0L);
        return (double)TimeUnit.NANOSECONDS.toMicros(positiveNanos) / (double)TimeUnit.MILLISECONDS.toMicros(1L);
    }

    private long randomTimeNanos() {
        Random$.MODULE$.setSeed(System.nanoTime());
        return Duration.ofMillis(1L).toNanos() + (long)Random$.MODULE$.nextInt(1000000);
    }

    private double randomRatio() {
        Random$.MODULE$.setSeed(System.nanoTime());
        return 0.0 + 1.0 * Random$.MODULE$.nextDouble();
    }

    /*
     * WARNING - void declaration
     */
    private Metric waitAndGetBrokerLoadMetric(BrokerLoad brokerLoad) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerLoadTest.$anonfun$waitAndGetBrokerLoadMetric$1(brokerLoad)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for broker load metric to populate");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (Metric)brokerLoad.brokerLoadTenantMetric("").get();
    }

    private BrokerLoad waitAndGetBrokerLoadMetric$default$1() {
        return this.brokerLoad();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerLoadMetricWeights() {
        void apply_multiTenantMetadata;
        void apply_requestThreadIdleMeter;
        void apply_config;
        this.metrics_$eq(new Metrics((Time)this.time()));
        KafkaScheduler scheduler = new KafkaScheduler(1);
        scheduler.startup();
        None$ none$ = None$.MODULE$;
        Meter meter = (Meter)Mockito.mock(Meter.class);
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.defaultProps());
        Metrics apply_metrics = this.metrics();
        Object var5_5 = null;
        kafkaConfig = null;
        meter = null;
        none$ = null;
        this.brokerLoad_$eq(new BrokerLoad(apply_metrics, (KafkaConfig)apply_config, (Meter)apply_requestThreadIdleMeter, scheduler, (Option)apply_multiTenantMetadata));
        this.brokerLoad().startMetric();
        BrokerLoad.BrokerLoadGauge brokerLoadGauge = this.brokerLoad().newBrokerLoadGauge();
        double middle = (this.brokerLoad().brokerLoadConfig().weightsUpperBound() + this.brokerLoad().brokerLoadConfig().weightsLowerBound()) / (double)2;
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(1.0, 0.0), (Object)brokerLoadGauge.weights(0.0));
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(1.0, 0.0), (Object)brokerLoadGauge.weights(this.brokerLoad().brokerLoadConfig().weightsLowerBound()));
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(0.5, 0.5), (Object)brokerLoadGauge.weights(middle));
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(0.0, 1.0), (Object)brokerLoadGauge.weights(this.brokerLoad().brokerLoadConfig().weightsUpperBound()));
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(0.0, 1.0), (Object)brokerLoadGauge.weights(1.0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNotStartingMetric() {
        void apply_multiTenantMetadata;
        void apply_kafkaScheduler;
        void apply_requestThreadIdleMeter;
        this.metrics_$eq(new Metrics((Time)this.time()));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        None$ none$ = None$.MODULE$;
        KafkaScheduler kafkaScheduler = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        KafkaConfig apply_config = KafkaConfig$.MODULE$.fromProps(this.defaultProps());
        Metrics apply_metrics = this.metrics();
        Object var2_6 = null;
        Object var3_5 = null;
        meter = null;
        kafkaScheduler = null;
        none$ = null;
        this.brokerLoad_$eq(new BrokerLoad(apply_metrics, apply_config, (Meter)apply_requestThreadIdleMeter, (KafkaScheduler)apply_kafkaScheduler, (Option)apply_multiTenantMetadata));
        selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testNotStartingMetric$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), 0.0, this.time().milliseconds());
        this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, 0.0, this.time().milliseconds());
        this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), this.randomTimeNanos());
        this.brokerLoad().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWrapAroundRecorderRequestsOnly() {
        void apply_multiTenantMetadata;
        void apply_requestThreadIdleMeter;
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        KafkaScheduler scheduler = new KafkaScheduler(1);
        scheduler.startup();
        Some some = new Some((Object)metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        Metrics apply_metrics = this.metrics();
        Object var14_8 = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(apply_metrics, config, (Meter)apply_requestThreadIdleMeter, scheduler, (Option)apply_multiTenantMetadata));
        selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWrapAroundRecorderRequestsOnly$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        Metric brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        double prevLoad = 0.0;
        for (double i = 0.0; i < (double)10000; i += 1.0) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), 0.0, this.time().milliseconds());
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, 0.0, this.time().milliseconds());
            KafkaChannel channel = this.mockKafkaChannel(this.randomTimeNanos(), this.randomTimeNanos(), this.randomTimeNanos());
            this.brokerLoad().notifyOnConnection(channel);
            this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), this.randomTimeNanos());
            double currLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis() / 10L);
            if (i > 0.0 && i % 10.0 == 0.0) {
                Predef$.MODULE$.assert(currLoad != 0.0);
                Predef$.MODULE$.assert(prevLoad == 0.0 && currLoad != 0.0 || prevLoad != currLoad);
            } else {
                Predef$.MODULE$.assert(prevLoad == 0.0 && currLoad == 0.0 || prevLoad == currLoad);
            }
            prevLoad = currLoad;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncrementalLoadAverage() {
        void apply_multiTenantMetadata;
        void apply_requestThreadIdleMeter;
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        props.put("confluent.broker.load.window.size.ms", "6000");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler scheduler = new KafkaScheduler(1);
        scheduler.startup();
        Some some = new Some((Object)metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        Metrics apply_metrics = this.metrics();
        Object var16_7 = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(apply_metrics, config, (Meter)apply_requestThreadIdleMeter, scheduler, (Option)apply_multiTenantMetadata));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testIncrementalLoadAverage$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        Metric brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        double prevLoad = 0.0;
        long timeMs = 1L;
        this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), this.randomRatio(), this.time().milliseconds());
        this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, this.randomRatio(), this.time().milliseconds());
        this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), Duration.ofMillis(2L).toNanos());
        KafkaChannel channel = this.mockKafkaChannel(this.randomTimeNanos(), this.randomTimeNanos(), this.randomTimeNanos());
        this.brokerLoad().notifyOnConnection(channel);
        this.time().sleep(config.brokerLoadWindowSizeMs().toMillis());
        for (int maxRequests = 50000; maxRequests > 0; --maxRequests) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), this.randomRatio(), this.time().milliseconds());
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, this.randomRatio(), this.time().milliseconds());
            this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), Duration.ofMillis(timeMs).toNanos());
            KafkaChannel channel2 = this.mockKafkaChannel(this.randomTimeNanos(), this.randomTimeNanos(), this.randomTimeNanos());
            this.brokerLoad().notifyOnConnection(channel2);
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis());
            ++timeMs;
            double curLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            Predef$.MODULE$.assert(curLoad != prevLoad);
            prevLoad = curLoad;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testWithSamplesDistribution(ListBuffer<Tuple2<Object, Duration>> events, Function2<Object, Object, BoxedUnit> assertion, KafkaConfig config) {
        void apply_multiTenantMetadata;
        void apply_requestThreadIdleMeter;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler scheduler = new KafkaScheduler(1);
        scheduler.startup();
        Some some = new Some((Object)metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        Metrics apply_metrics = this.metrics();
        Object var14_8 = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(apply_metrics, config, (Meter)apply_requestThreadIdleMeter, scheduler, (Option)apply_multiTenantMetadata));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        events.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_brokerLoadValue <= 1.0 || testWithSamplesDistribution_brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        assertion.apply$mcVDD$sp(testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_brokerLoadValue);
    }

    private void testWithSamplesDistribution(BrokerLoad brokerLoad, List<Selector> selectors, ListBuffer<Tuple2<Object, Duration>> events, Function2<Object, Object, BoxedUnit> assertion) {
        Metric brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        events.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double brokerLoadValue = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
        Assertions.assertTrue((brokerLoadValue >= 0.0 && brokerLoadValue <= 1.0 || brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option optionalServiceTimeMetric = brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)optionalServiceTimeMetric.isDefined());
        double averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        assertion.apply$mcVDD$sp(averageTotalServiceLocalTimeValue, brokerLoadValue);
    }

    private KafkaConfig testWithSamplesDistribution$default$3() {
        return this.defaultConfig();
    }

    @Test
    public void testIdleBrokerLoad() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3600).foreach((Function1 & Serializable)x$4 -> BrokerLoadTest.$anonfun$testIdleBrokerLoad$1(samples, BoxesRunTime.unboxToInt((Object)x$4)));
        this.testWithSamplesDistribution((ListBuffer<Tuple2<Object, Duration>>)samples, (Function2<Object, Object, BoxedUnit>)BrokerLoadTest.assertion$1(), this.defaultConfig());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSingleRequestLoad() {
        void testWithSamplesDistribution_apply_multiTenantMetadata;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter;
        void testWithSamplesDistribution_apply_multiTenantMetadata2;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter2;
        void testWithSamplesDistribution_apply_multiTenantMetadata3;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter3;
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs())), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config = this.defaultConfig();
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler.startup();
        Some some = new Some((Object)testWithSamplesDistribution_metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics = this.metrics();
        Object var13_7 = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics, testWithSamplesDistribution_config, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter3, testWithSamplesDistribution_scheduler, (Option)testWithSamplesDistribution_apply_multiTenantMetadata3));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue == 0.0);
        Object var6_9 = null;
        Object var7_10 = null;
        Object var10_12 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_8 = null;
        samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) * (double)5)), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config2 = this.defaultConfig();
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler2 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler2.startup();
        Some some2 = new Some((Object)testWithSamplesDistribution_metadata2);
        Meter meter2 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics2 = this.metrics();
        Object var27_19 = null;
        meter2 = null;
        some2 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics2, testWithSamplesDistribution_config2, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter2, testWithSamplesDistribution_scheduler2, (Option)testWithSamplesDistribution_apply_multiTenantMetadata2));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        Object var20_21 = null;
        Object var21_22 = null;
        Object var24_24 = null;
        Object var16_14 = null;
        Object var17_15 = null;
        Object var18_16 = null;
        Object var19_20 = null;
        samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) / (double)5)), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config3 = this.defaultConfig();
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler3 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler3.startup();
        Some some3 = new Some((Object)testWithSamplesDistribution_metadata3);
        Meter meter3 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics3 = this.metrics();
        Object var41_31 = null;
        meter3 = null;
        some3 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics3, testWithSamplesDistribution_config3, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter, testWithSamplesDistribution_scheduler3, (Option)testWithSamplesDistribution_apply_multiTenantMetadata));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 == 0.0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleRequestLoad() {
        void var39_38;
        void testWithSamplesDistribution_apply_multiTenantMetadata;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter;
        void testWithSamplesDistribution_config;
        void testWithSamplesDistribution_apply_multiTenantMetadata2;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter2;
        void testWithSamplesDistribution_config2;
        void testWithSamplesDistribution_apply_multiTenantMetadata3;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter3;
        void testWithSamplesDistribution_config3;
        void testWithSamplesDistribution_apply_multiTenantMetadata4;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter4;
        ObjectRef samples = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)Duration.ZERO)}))));
        KafkaConfig testWithSamplesDistribution_config4 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler.startup();
        Some some = new Some((Object)testWithSamplesDistribution_metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics = this.metrics();
        Object var14_8 = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics, testWithSamplesDistribution_config4, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter4, testWithSamplesDistribution_scheduler, (Option)testWithSamplesDistribution_apply_multiTenantMetadata4));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        testWithSamplesDistribution_events.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue > 0.0);
        Object var7_10 = null;
        Object var8_11 = null;
        Object var11_13 = null;
        Object var2_3 = null;
        Object var3_2 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_9 = null;
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig kafkaConfig = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events2 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler2 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler2.startup();
        Some some2 = new Some((Object)testWithSamplesDistribution_metadata2);
        Meter meter2 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics2 = this.metrics();
        Object var29_21 = null;
        meter2 = null;
        some2 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics2, (KafkaConfig)testWithSamplesDistribution_config3, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter3, testWithSamplesDistribution_scheduler2, (Option)testWithSamplesDistribution_apply_multiTenantMetadata3));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        testWithSamplesDistribution_events2.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        Object var22_23 = null;
        Object var23_24 = null;
        Object var26_26 = null;
        Object var17_16 = null;
        kafkaConfig = null;
        Object var19_17 = null;
        Object var20_18 = null;
        Object var21_22 = null;
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(this.defaultConfig().brokerLoadNumSamples()) - 1).foreach((Function1 & Serializable)i -> BrokerLoadTest.$anonfun$testMultipleRequestLoad$3(this, samples, BoxesRunTime.unboxToInt((Object)i)));
        KafkaConfig kafkaConfig2 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events3 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler3 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler3.startup();
        Some some3 = new Some((Object)testWithSamplesDistribution_metadata3);
        Meter meter3 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics3 = this.metrics();
        Object var44_34 = null;
        meter3 = null;
        some3 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics3, (KafkaConfig)testWithSamplesDistribution_config2, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter2, testWithSamplesDistribution_scheduler3, (Option)testWithSamplesDistribution_apply_multiTenantMetadata2));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        testWithSamplesDistribution_events3.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 > 0.0);
        Object var37_36 = null;
        Object var38_37 = null;
        Object var41_39 = null;
        Object var32_29 = null;
        kafkaConfig2 = null;
        Object var34_30 = null;
        Object var35_31 = null;
        Object var36_35 = null;
        ((ListBuffer)samples.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Integer2int(this.defaultConfig().brokerLoadNumSamples()) + 1)), (Object)this.defaultConfig().brokerLoadWindowSizeMs()));
        KafkaConfig kafkaConfig3 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events4 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata4 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler4 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler4.startup();
        Some some4 = new Some((Object)testWithSamplesDistribution_metadata4);
        Meter meter4 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics4 = this.metrics();
        Object var59_47 = null;
        meter4 = null;
        some4 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics4, (KafkaConfig)testWithSamplesDistribution_config, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter, testWithSamplesDistribution_scheduler4, (Option)testWithSamplesDistribution_apply_multiTenantMetadata));
        List<Selector> testWithSamplesDistribution_selectors4 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors4.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        testWithSamplesDistribution_events4.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 > 0.0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 > var39_38);
    }

    @Test
    public void testSingleRequestTimeAverage() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        this.testWithSamplesDistribution((ListBuffer<Tuple2<Object, Duration>>)samples, (Function2<Object, Object, BoxedUnit>)this.assertion$2(), this.defaultConfig());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleRequestTimeAverageWithinSamplePeriod() {
        void testWithSamplesDistribution_apply_multiTenantMetadata;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter;
        void testWithSamplesDistribution_apply_multiTenantMetadata2;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter2;
        void testWithSamplesDistribution_apply_multiTenantMetadata3;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter3;
        void testWithSamplesDistribution_config;
        void testWithSamplesDistribution_apply_multiTenantMetadata4;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter4;
        void testWithSamplesDistribution_config2;
        ObjectRef samples = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L))}))));
        KafkaConfig kafkaConfig = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler.startup();
        Some some = new Some((Object)testWithSamplesDistribution_metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics = this.metrics();
        Object var16_8 = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics, (KafkaConfig)testWithSamplesDistribution_config2, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter4, testWithSamplesDistribution_scheduler, (Option)testWithSamplesDistribution_apply_multiTenantMetadata4));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        testWithSamplesDistribution_events.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Assertions.assertEquals((double)(((Tuple2)((ListBuffer)samples.elem).apply(0))._1$mcD$sp() + ((Tuple2)((ListBuffer)samples.elem).apply(1))._1$mcD$sp()), (double)this.nanosToMs((long)testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue), (double)0.0);
        Object var9_10 = null;
        Object var10_11 = null;
        Object var13_13 = null;
        Object var4_3 = null;
        kafkaConfig = null;
        Object var6_4 = null;
        Object var7_5 = null;
        Object var8_9 = null;
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig kafkaConfig2 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events2 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler2 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler2.startup();
        Some some2 = new Some((Object)testWithSamplesDistribution_metadata2);
        Meter meter2 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics2 = this.metrics();
        Object var31_21 = null;
        meter2 = null;
        some2 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics2, (KafkaConfig)testWithSamplesDistribution_config, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter3, testWithSamplesDistribution_scheduler2, (Option)testWithSamplesDistribution_apply_multiTenantMetadata3));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        testWithSamplesDistribution_events2.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$2(this, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2);
        Object var24_23 = null;
        Object var25_24 = null;
        Object var28_26 = null;
        Object var19_16 = null;
        kafkaConfig2 = null;
        Object var21_17 = null;
        Object var22_18 = null;
        Object var23_22 = null;
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", Integer.toString(10));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)config.brokerLoadWindowSizeMs())}));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(config.brokerLoadNumSamples()) - 2).foreach((Function1 & Serializable)x$16 -> BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$3(samples, config, BoxesRunTime.unboxToInt((Object)x$16)));
        ListBuffer testWithSamplesDistribution_events3 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler3 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler3.startup();
        Some some3 = new Some((Object)testWithSamplesDistribution_metadata3);
        Meter meter3 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics3 = this.metrics();
        Object var45_35 = null;
        meter3 = null;
        some3 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics3, config, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter2, testWithSamplesDistribution_scheduler3, (Option)testWithSamplesDistribution_apply_multiTenantMetadata2));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        testWithSamplesDistribution_events3.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(this.nanosToMs((long)testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) < 2.0, (Function0 & Serializable)() -> "Avg request time should be less than 1.0");
        Object var38_37 = null;
        Object var39_38 = null;
        Object var42_40 = null;
        Object var34_30 = null;
        Object var35_31 = null;
        Object var36_32 = null;
        Object var37_36 = null;
        ((ListBuffer)samples.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)config.brokerLoadWindowSizeMs()));
        ((ListBuffer)samples.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)config.brokerLoadWindowSizeMs()));
        ListBuffer testWithSamplesDistribution_events4 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata4 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler4 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler4.startup();
        Some some4 = new Some((Object)testWithSamplesDistribution_metadata4);
        Meter meter4 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics4 = this.metrics();
        Object var59_47 = null;
        meter4 = null;
        some4 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics4, config, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter, testWithSamplesDistribution_scheduler4, (Option)testWithSamplesDistribution_apply_multiTenantMetadata));
        List<Selector> testWithSamplesDistribution_selectors4 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors4.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        testWithSamplesDistribution_events4.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$6(this, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicServiceRequestTime() {
        void var10_11;
        void apply_multiTenantMetadata;
        void apply_requestThreadIdleMeter;
        void apply_config;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler scheduler = new KafkaScheduler(1);
        scheduler.startup();
        Some some = new Some((Object)metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        KafkaConfig kafkaConfig = this.defaultConfig();
        Metrics apply_metrics = this.metrics();
        Object var29_6 = null;
        kafkaConfig = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(apply_metrics, (KafkaConfig)apply_config, (Meter)apply_requestThreadIdleMeter, scheduler, (Option)apply_multiTenantMetadata));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testDynamicServiceRequestTime$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L))}));
        BrokerLoad testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_brokerLoadValue <= 1.0 || testWithSamplesDistribution_brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_brokerLoadValue > 0.0);
        Object var8_9 = null;
        Object var9_10 = null;
        Object var12_12 = null;
        Properties props = this.defaultProps();
        double newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) * (double)5;
        props.put("confluent.broker.load.average.service.request.time.ms", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_brokerLoadValue2 <= 1.0 || testWithSamplesDistribution_brokerLoadValue2 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        Predef$.MODULE$.assert(var10_11 > testWithSamplesDistribution_brokerLoadValue2);
        Object var15_16 = null;
        Object var16_17 = null;
        Object var19_19 = null;
        newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) / (double)5;
        props.put("confluent.broker.load.average.service.request.time.ms", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_brokerLoadValue3 <= 1.0 || testWithSamplesDistribution_brokerLoadValue3 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_brokerLoadValue3 > 0.0);
        Predef$.MODULE$.assert(var10_11 < testWithSamplesDistribution_brokerLoadValue3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicWorkloadCoefficients() {
        void var10_11;
        void apply_multiTenantMetadata;
        void apply_requestThreadIdleMeter;
        void apply_config;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler scheduler = new KafkaScheduler(1);
        scheduler.startup();
        Some some = new Some((Object)metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        KafkaConfig kafkaConfig = this.defaultConfig();
        Metrics apply_metrics = this.metrics();
        Object var29_6 = null;
        kafkaConfig = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(apply_metrics, (KafkaConfig)apply_config, (Meter)apply_requestThreadIdleMeter, scheduler, (Option)apply_multiTenantMetadata));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testDynamicWorkloadCoefficients$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L))}));
        BrokerLoad testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_brokerLoadValue <= 1.0 || testWithSamplesDistribution_brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_brokerLoadValue > 0.0);
        Object var8_9 = null;
        Object var9_10 = null;
        Object var12_12 = null;
        Properties props = this.defaultProps();
        double newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadWorkloadCoefficient()) * (double)5;
        props.put("confluent.broker.load.workload.coefficient", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_brokerLoadValue2 <= 1.0 || testWithSamplesDistribution_brokerLoadValue2 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        Predef$.MODULE$.assert(var10_11 > testWithSamplesDistribution_brokerLoadValue2);
        Object var15_16 = null;
        Object var16_17 = null;
        Object var19_19 = null;
        newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadWorkloadCoefficient()) / (double)5;
        props.put("confluent.broker.load.workload.coefficient", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_brokerLoadValue3 <= 1.0 || testWithSamplesDistribution_brokerLoadValue3 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_brokerLoadValue3 > 0.0);
        Predef$.MODULE$.assert(var10_11 < testWithSamplesDistribution_brokerLoadValue3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleSamplingPeriods() {
        void testWithSamplesDistribution_apply_multiTenantMetadata;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter;
        void var11_11;
        void testWithSamplesDistribution_apply_multiTenantMetadata2;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter2;
        void testWithSamplesDistribution_apply_multiTenantMetadata3;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter3;
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().multipliedBy(5L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config = this.defaultConfig();
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler.startup();
        Some some = new Some((Object)testWithSamplesDistribution_metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics = this.metrics();
        Object var16_7 = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics, testWithSamplesDistribution_config, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter3, testWithSamplesDistribution_scheduler, (Option)testWithSamplesDistribution_apply_multiTenantMetadata3));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue > 0.0);
        Object var9_9 = null;
        Object var10_10 = null;
        Object var13_12 = null;
        Object var5_2 = null;
        Object var6_3 = null;
        Object var7_4 = null;
        Object var8_8 = null;
        Properties props = this.defaultProps();
        long newSamplingPeriod = this.defaultConfig().brokerLoadWindowSizeMs().multipliedBy(5L).toMillis();
        props.put("confluent.broker.load.window.size.ms", Long.toString(newSamplingPeriod));
        KafkaConfig testWithSamplesDistribution_config2 = KafkaConfig$.MODULE$.fromProps(props);
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler2 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler2.startup();
        Some some2 = new Some((Object)testWithSamplesDistribution_metadata2);
        Meter meter2 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics2 = this.metrics();
        Object var30_21 = null;
        meter2 = null;
        some2 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics2, testWithSamplesDistribution_config2, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter2, testWithSamplesDistribution_scheduler2, (Option)testWithSamplesDistribution_apply_multiTenantMetadata2));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 != var11_11);
        Object var23_23 = null;
        Object var24_24 = null;
        Object var27_26 = null;
        Object var19_16 = null;
        Object var20_17 = null;
        Object var21_18 = null;
        Object var22_22 = null;
        newSamplingPeriod = this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(5L).toMillis();
        props.put("confluent.broker.load.window.size.ms", Long.toString(newSamplingPeriod));
        KafkaConfig testWithSamplesDistribution_config3 = KafkaConfig$.MODULE$.fromProps(props);
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler3 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler3.startup();
        Some some3 = new Some((Object)testWithSamplesDistribution_metadata3);
        Meter meter3 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics3 = this.metrics();
        Object var44_33 = null;
        meter3 = null;
        some3 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics3, testWithSamplesDistribution_config3, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter, testWithSamplesDistribution_scheduler3, (Option)testWithSamplesDistribution_apply_multiTenantMetadata));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 > 0.0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 != var11_11);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleSampleCounts() {
        void testWithSamplesDistribution_apply_multiTenantMetadata;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter;
        void var12_13;
        void testWithSamplesDistribution_apply_multiTenantMetadata2;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter2;
        void testWithSamplesDistribution_apply_multiTenantMetadata3;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter3;
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", Integer.toString(10));
        ObjectRef config = ObjectRef.create((Object)KafkaConfig$.MODULE$.fromProps(props));
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(((KafkaConfig)config.elem).brokerLoadNumSamples()) * 2).foreach((Function1 & Serializable)i -> BrokerLoadTest.$anonfun$testMultipleSampleCounts$1(samples, config, BoxesRunTime.unboxToInt((Object)i)));
        KafkaConfig testWithSamplesDistribution_config = (KafkaConfig)config.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler.startup();
        Some some = new Some((Object)testWithSamplesDistribution_metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics = this.metrics();
        Object var17_9 = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics, testWithSamplesDistribution_config, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter3, testWithSamplesDistribution_scheduler, (Option)testWithSamplesDistribution_apply_multiTenantMetadata3));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue > 0.0);
        Object var10_11 = null;
        Object var11_12 = null;
        Object var14_14 = null;
        Object var6_4 = null;
        Object var7_5 = null;
        Object var8_6 = null;
        Object var9_10 = null;
        long newSampleSize = Predef$.MODULE$.Integer2int(((KafkaConfig)config.elem).brokerLoadNumSamples()) * 2;
        props.put("confluent.broker.load.num.samples", Long.toString(newSampleSize));
        config.elem = KafkaConfig$.MODULE$.fromProps(props);
        KafkaConfig testWithSamplesDistribution_config2 = (KafkaConfig)config.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler2 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler2.startup();
        Some some2 = new Some((Object)testWithSamplesDistribution_metadata2);
        Meter meter2 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics2 = this.metrics();
        Object var31_22 = null;
        meter2 = null;
        some2 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics2, testWithSamplesDistribution_config2, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter2, testWithSamplesDistribution_scheduler2, (Option)testWithSamplesDistribution_apply_multiTenantMetadata2));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 != var12_13);
        Object var24_24 = null;
        Object var25_25 = null;
        Object var28_27 = null;
        Object var20_17 = null;
        Object var21_18 = null;
        Object var22_19 = null;
        Object var23_23 = null;
        newSampleSize = Predef$.MODULE$.Integer2int(((KafkaConfig)config.elem).brokerLoadNumSamples()) / 4;
        props.put("confluent.broker.load.num.samples", Long.toString(newSampleSize));
        config.elem = KafkaConfig$.MODULE$.fromProps(props);
        KafkaConfig testWithSamplesDistribution_config3 = (KafkaConfig)config.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler3 = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler3.startup();
        Some some3 = new Some((Object)testWithSamplesDistribution_metadata3);
        Meter meter3 = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics3 = this.metrics();
        Object var45_34 = null;
        meter3 = null;
        some3 = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics3, testWithSamplesDistribution_config3, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter, testWithSamplesDistribution_scheduler3, (Option)testWithSamplesDistribution_apply_multiTenantMetadata));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 > 0.0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 != var12_13);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerLoadClose() {
        void testWithSamplesDistribution_apply_multiTenantMetadata;
        void testWithSamplesDistribution_apply_requestThreadIdleMeter;
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3600).foreach((Function1 & Serializable)i -> BrokerLoadTest.$anonfun$testBrokerLoadClose$1(this, samples, BoxesRunTime.unboxToInt((Object)i)));
        KafkaConfig testWithSamplesDistribution_config = this.defaultConfig();
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler testWithSamplesDistribution_scheduler = new KafkaScheduler(1);
        testWithSamplesDistribution_scheduler.startup();
        Some some = new Some((Object)testWithSamplesDistribution_metadata);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        Metrics testWithSamplesDistribution_apply_metrics = this.metrics();
        Object var13_7 = null;
        meter = null;
        some = null;
        this.brokerLoad_$eq(new BrokerLoad(testWithSamplesDistribution_apply_metrics, testWithSamplesDistribution_config, (Meter)testWithSamplesDistribution_apply_requestThreadIdleMeter, testWithSamplesDistribution_scheduler, (Option)testWithSamplesDistribution_apply_multiTenantMetadata));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.brokerLoad());
        samples.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testWithSamplesDistribution$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$3);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 || testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue == 0.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue > 0.0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue > 0.0);
        Object var6_9 = null;
        Object var7_10 = null;
        Object var10_12 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_8 = null;
        this.brokerLoad().close();
        Assertions.assertFalse((boolean)this.brokerLoad().brokerLoadMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().brokerLoadTenantMetric("").isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageTotalServiceLocalTimeMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageExternalNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageReplicationNetworkThreadIdleRatioMetric().isDefined());
    }

    @Test
    public void testBrokerLoadIdempotency() {
        int requiredInstanceCount = 100;
        ConcurrentLinkedQueue<BrokerLoad> brokerLoadInstances = new ConcurrentLinkedQueue<BrokerLoad>();
        ConcurrentLinkedQueue taskStatus = new ConcurrentLinkedQueue();
        ObjectRef executor = ObjectRef.create((Object)Executors.newSingleThreadExecutor());
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        KafkaScheduler scheduler = new KafkaScheduler(1);
        scheduler.startup();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), requiredInstanceCount).foreach((Function1)(JFunction1.mcZI.sp & Serializable)x$31 -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$2(this, scheduler, metadata, brokerLoadInstances)))));
        Duration waitTimeout = Duration.ofSeconds(10L);
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        ((ExecutorService)executor.elem).shutdown();
        executor.elem = Executors.newFixedThreadPool(10);
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$5(this, brokerLoad)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        this.verifyMetricsAcrossInstances(brokerLoadInstances);
        Selector mockSelector = (Selector)this.mockSelectors(this.metrics()).head();
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$8(this, brokerLoad, mockSelector)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        this.verifyMetricsAcrossInstances(brokerLoadInstances);
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$11(this, brokerLoad)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        this.verifyMetricsAcrossInstances(brokerLoadInstances);
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$14(brokerLoad)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        ((ExecutorService)executor.elem).shutdown();
    }

    public void verifyMetricsAcrossInstances(Queue<BrokerLoad> brokerLoadInstances) {
        double firstBrokerLoadPercent = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoadInstances.peek().brokerLoadMetric().get()).metricValue());
        double firstBrokerLoadTenantPercent = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoadInstances.peek().brokerLoadTenantMetric("").get()).metricValue());
        double firstBrokerLoadServiceTime = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoadInstances.peek().weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
        double firstBrokerLoadExternalThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoadInstances.peek().weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
        double firstBrokerLoadReplicationThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoadInstances.peek().weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
        brokerLoadInstances.forEach(brokerLoad -> {
            double load = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.brokerLoadMetric().get()).metricValue());
            double tenantLoad = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.brokerLoadMetric().get()).metricValue());
            double serviceTime = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
            double externalThreadIdle = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
            double replicationThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
            Assertions.assertEquals((double)firstBrokerLoadPercent, (double)load);
            Assertions.assertEquals((double)firstBrokerLoadTenantPercent, (double)tenantLoad);
            Assertions.assertEquals((double)firstBrokerLoadServiceTime, (double)serviceTime);
            Assertions.assertEquals((double)firstBrokerLoadExternalThreadsIdle, (double)externalThreadIdle);
            Assertions.assertEquals((double)firstBrokerLoadReplicationThreadsIdle, (double)replicationThreadsIdle);
        });
    }

    @Test
    public void testMetersWithSameNameIdentical() {
        String requestHandlerAvgIdleMetricName = new StringBuilder(28).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("RequestHandlerAvgIdlePercent").toString();
        Meter firstMeter = new KafkaMetricsGroup(this.getClass()).newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS);
        Meter secondMeter = new KafkaMetricsGroup(this.getClass()).newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS);
        Assertions.assertSame((Object)firstMeter, (Object)secondMeter);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testThroughputLoad() {
        void apply_multiTenantMetadata;
        void apply_kafkaScheduler;
        void apply_requestThreadIdleMeter;
        void apply_config;
        None$ none$ = None$.MODULE$;
        KafkaScheduler kafkaScheduler = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.defaultProps());
        Metrics apply_metrics = new Metrics((Time)this.time());
        Object var6_5 = null;
        kafkaConfig = null;
        meter = null;
        kafkaScheduler = null;
        none$ = null;
        this.brokerLoad_$eq(new BrokerLoad(apply_metrics, (KafkaConfig)apply_config, (Meter)apply_requestThreadIdleMeter, (KafkaScheduler)apply_kafkaScheduler, (Option)apply_multiTenantMetadata));
        BrokerLoad.BrokerLoadV2Gauge brokerLoadv2Gauge = this.brokerLoad().newBrokerLoadV2Gauge();
        Assertions.assertEquals((double)brokerLoadv2Gauge.throughputLoad(ClientQuotaType.PRODUCE), (double)0.0);
        Assertions.assertEquals((double)brokerLoadv2Gauge.throughputLoad(ClientQuotaType.FETCH), (double)0.0);
        Assertions.assertEquals((double)brokerLoadv2Gauge.throughputLoad(ClientQuotaType.PRODUCER_ID), (double)0.0);
        int produceBrokerLimit = 25;
        int fetchBrokerLimit = 75;
        int produceThroughput = 10;
        int fetchThroughput = 30;
        this.brokerLoad().updateReportedUsage(ClientQuotaType.PRODUCE, (double)produceThroughput * (double)1024 * (double)1024, (double)produceBrokerLimit * (double)1024 * (double)1024);
        this.brokerLoad().updateReportedUsage(ClientQuotaType.FETCH, (double)fetchThroughput * (double)1024 * (double)1024, (double)fetchBrokerLimit * (double)1024 * (double)1024);
        Assertions.assertEquals((double)0.48, (double)brokerLoadv2Gauge.throughputLoad(ClientQuotaType.PRODUCE));
        Assertions.assertEquals((double)0.48, (double)brokerLoadv2Gauge.throughputLoad(ClientQuotaType.FETCH));
        produceThroughput = 20;
        fetchThroughput = 60;
        this.brokerLoad().updateReportedUsage(ClientQuotaType.PRODUCE, (double)produceThroughput * (double)1024 * (double)1024, (double)produceBrokerLimit * (double)1024 * (double)1024);
        this.brokerLoad().updateReportedUsage(ClientQuotaType.FETCH, (double)fetchThroughput * (double)1024 * (double)1024, (double)fetchBrokerLimit * (double)1024 * (double)1024);
        Assertions.assertEquals((double)0.88, (double)brokerLoadv2Gauge.throughputLoad(ClientQuotaType.PRODUCE), (double)1.0E-4);
        Assertions.assertEquals((double)0.88, (double)brokerLoadv2Gauge.throughputLoad(ClientQuotaType.FETCH), (double)1.0E-4);
    }

    private double mibToBytes(double mib) {
        return mib * (double)1024 * (double)1024;
    }

    @AfterEach
    public void tearDown() {
        if (this.brokerLoad() != null) {
            this.brokerLoad().close();
        }
        if (this.metrics() != null) {
            this.metrics().close();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$waitAndGetBrokerLoadMetric$1(BrokerLoad brokerLoad$1) {
        return brokerLoad$1.brokerLoadTenantMetric("").isDefined();
    }

    public static final /* synthetic */ String $anonfun$waitAndGetBrokerLoadMetric$2() {
        return "Timed out waiting for broker load metric to populate";
    }

    public static final /* synthetic */ void $anonfun$testNotStartingMetric$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWrapAroundRecorderRequestsOnly$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testIncrementalLoadAverage$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWithSamplesDistribution$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ boolean $anonfun$testWithSamplesDistribution$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testWithSamplesDistribution$3(BrokerLoadTest $this, BrokerLoad brokerLoad$2, List selectors$1, Tuple2 x$3) {
        if (x$3 != null) {
            double value = x$3._1$mcD$sp();
            Duration duration = (Duration)x$3._2();
            if (value != 0.0) {
                long timeNanos = (long)(value * 1000000.0);
                brokerLoad$2.notifyOnThreadUsage($this.multiTenantListenerName(), 0.0, $this.time().milliseconds());
                brokerLoad$2.notifyOnThreadUsage($this.securityProtocol().name, 0.0, $this.time().milliseconds());
                KafkaChannel channel = $this.mockKafkaChannel(timeNanos, timeNanos, timeNanos);
                brokerLoad$2.notifyOnConnection(channel);
                brokerLoad$2.recordRequestTimeNanos((Selector)selectors$1.head(), timeNanos);
            }
            $this.time().sleep(duration.toMillis());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testIdleBrokerLoad$1(ListBuffer samples$1, int x$4) {
        return (ListBuffer)samples$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)Duration.ofSeconds(1L)));
    }

    private static final Function2 assertion$1() {
        return (JFunction2.mcVDD.sp & Serializable)(x$5, brokerLoad) -> Predef$.MODULE$.assert(brokerLoad == 0.0);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testMultipleRequestLoad$3(BrokerLoadTest $this, ObjectRef samples$2, int i) {
        return (ListBuffer)((ListBuffer)samples$2.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)(i + 1)), (Object)$this.defaultConfig().brokerLoadWindowSizeMs()));
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestLoad$4(DoubleRef prevLoad$1, double x$11, double brokerLoad) {
        prevLoad$1.elem = brokerLoad;
        Predef$.MODULE$.assert(prevLoad$1.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestLoad$5(DoubleRef prevLoad$1, double x$12, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad > prevLoad$1.elem);
    }

    private final Function2 assertion$2() {
        return (JFunction2.mcVDD.sp & Serializable)(avgRequestTime, x$13) -> Assertions.assertEquals((double)4.0, (double)this.nanosToMs((long)avgRequestTime), (double)0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$1(BrokerLoadTest $this, ObjectRef samples$3, double avgRequestTime, double x$14) {
        Assertions.assertEquals((double)(((Tuple2)((ListBuffer)samples$3.elem).apply(0))._1$mcD$sp() + ((Tuple2)((ListBuffer)samples$3.elem).apply(1))._1$mcD$sp()), (double)$this.nanosToMs((long)avgRequestTime), (double)0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$2(BrokerLoadTest $this, double avgRequestTime, double x$15) {
        Assertions.assertEquals((double)1.0, (double)$this.nanosToMs((long)avgRequestTime), (double)1.0E-6);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$3(ObjectRef samples$3, KafkaConfig config$1, int x$16) {
        return (ListBuffer)((ListBuffer)samples$3.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)config$1.brokerLoadWindowSizeMs()));
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$6(BrokerLoadTest $this, double avgRequestTime, double x$18) {
        Assertions.assertEquals((double)2.0, (double)$this.nanosToMs((long)avgRequestTime), (double)0.0);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$2(DoubleRef defaultLoad$1, double x$19, double brokerLoad) {
        defaultLoad$1.elem = brokerLoad;
        Predef$.MODULE$.assert(defaultLoad$1.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$3(DoubleRef defaultLoad$1, double x$20, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$1.elem > brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$4(DoubleRef defaultLoad$1, double x$21, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$1.elem < brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$2(DoubleRef defaultLoad$2, double x$22, double brokerLoad) {
        defaultLoad$2.elem = brokerLoad;
        Predef$.MODULE$.assert(defaultLoad$2.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$3(DoubleRef defaultLoad$2, double x$23, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$2.elem > brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$4(DoubleRef defaultLoad$2, double x$24, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$2.elem < brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSamplingPeriods$1(DoubleRef load$1, double x$25, double brokerLoad) {
        load$1.elem = brokerLoad;
        Predef$.MODULE$.assert(load$1.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSamplingPeriods$2(DoubleRef load$1, double x$26, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$1.elem);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSamplingPeriods$3(DoubleRef load$1, double x$27, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$1.elem);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testMultipleSampleCounts$1(ListBuffer samples$4, ObjectRef config$2, int i) {
        return (ListBuffer)samples$4.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)i), (Object)((KafkaConfig)config$2.elem).brokerLoadWindowSizeMs()));
    }

    public static final /* synthetic */ void $anonfun$testMultipleSampleCounts$2(DoubleRef load$2, double x$28, double brokerLoad) {
        load$2.elem = brokerLoad;
        Predef$.MODULE$.assert(load$2.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSampleCounts$3(DoubleRef load$2, double x$29, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$2.elem);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSampleCounts$4(DoubleRef load$2, double x$30, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$2.elem);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testBrokerLoadClose$1(BrokerLoadTest $this, ListBuffer samples$5, int i) {
        return (ListBuffer)samples$5.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)i), (Object)$this.defaultConfig().brokerLoadWindowSizeMs()));
    }

    private static final Function2 assertion$3(DoubleRef lastLoad$1, DoubleRef lastServiceLocalTime$1) {
        return (JFunction2.mcVDD.sp & Serializable)(serviceLocalTimeAvg, brokerLoad) -> {
            Predef$.MODULE$.assert(brokerLoad > 0.0);
            Predef$.MODULE$.assert(serviceLocalTimeAvg > 0.0);
            lastLoad$1.elem = brokerLoad;
            lastServiceLocalTime$1.elem = serviceLocalTimeAvg;
        };
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$2(BrokerLoadTest $this, KafkaScheduler scheduler$1, MultiTenantMetadata metadata$1, Queue brokerLoadInstances$1) {
        void apply_multiTenantMetadata;
        void apply_requestThreadIdleMeter;
        void apply_config;
        Some some = new Some((Object)metadata$1);
        Meter meter = (Meter)Mockito.mock(Meter.class);
        KafkaConfig kafkaConfig = $this.defaultConfig();
        Metrics apply_metrics = $this.metrics();
        Object var5_7 = null;
        kafkaConfig = null;
        meter = null;
        some = null;
        BrokerLoad brokerLoad = new BrokerLoad(apply_metrics, (KafkaConfig)apply_config, (Meter)apply_requestThreadIdleMeter, scheduler$1, (Option)apply_multiTenantMetadata);
        brokerLoad.startMetric();
        Assertions.assertTrue((boolean)brokerLoad.brokerLoadMetric().isDefined());
        $this.waitAndGetBrokerLoadMetric(brokerLoad);
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().isDefined());
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageReplicationNetworkThreadIdleRatioMetric().isDefined());
        return brokerLoadInstances$1.add(brokerLoad);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$5(BrokerLoadTest $this, BrokerLoad brokerLoad$3) {
        KafkaChannel channel = $this.mockKafkaChannel($this.randomTimeNanos(), $this.randomTimeNanos(), $this.randomTimeNanos());
        brokerLoad$3.notifyOnConnection(channel);
        $this.time().sleep($this.defaultConfig().brokerLoadWindowSizeMs().toMillis());
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$8(BrokerLoadTest $this, BrokerLoad brokerLoad$4, Selector mockSelector$1) {
        brokerLoad$4.recordRequestTimeNanos(mockSelector$1, $this.randomTimeNanos());
        $this.time().sleep($this.defaultConfig().brokerLoadWindowSizeMs().toMillis());
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$11(BrokerLoadTest $this, BrokerLoad brokerLoad$5) {
        brokerLoad$5.notifyOnThreadUsage($this.multiTenantListenerName(), $this.randomRatio(), $this.time().milliseconds());
        brokerLoad$5.notifyOnThreadUsage($this.securityProtocol().name, $this.randomRatio(), $this.time().milliseconds());
        $this.time().sleep($this.defaultConfig().brokerLoadWindowSizeMs().toMillis());
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$14(BrokerLoad brokerLoad$6) {
        brokerLoad$6.close();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public BrokerLoadTest() {
        void apply_doLog;
        void var1_26;
        this.nodeId = 0;
        this.SelectorMetricsGrpPrefix = "";
        this.multiTenantListenerName = "EXTERNAL";
        int x$1 = this.nodeId();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        Some x$3 = new Some((Object)this.securityProtocol());
        boolean x$4 = true;
        boolean x$5 = true;
        TestUtils$ createBrokerConfig$default$5_this = TestUtils$.MODULE$;
        Object var25_6 = null;
        int x$6 = createBrokerConfig$default$5_this.RandomPort();
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var28_18 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$6, (Option<SecurityProtocol>)x$3, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        properties.put("confluent.multitenant.listener.names", this.multiTenantListenerName());
        properties.put("confluent.broker.load.enabled", "true");
        properties.put("confluent.broker.load.tenant.metric.enable", "true");
        properties.put("confluent.broker.load.delay.metric.start.ms", "0");
        properties.put("confluent.broker.load.update.metric.tags.interval.ms", "100");
        this.defaultProps = var1_26;
        boolean bl = true;
        Properties apply_props = this.defaultProps();
        this.defaultConfig = new KafkaConfig((Map)apply_props, (boolean)apply_doLog);
    }
}

