/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.ConsumerLagEmitter;
import kafka.metrics.ConsumerLagEmitter$;
import kafka.metrics.MemberTopicPartition;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rud\u0001\u0002'N\u0001ICQ!\u0017\u0001\u0005\u0002iCqA\u0014\u0001A\u0002\u0013%Q\fC\u0004k\u0001\u0001\u0007I\u0011B6\t\rE\u0004\u0001\u0015)\u0003_\u0011\u001d\u0011\b\u00011A\u0005\nMDq\u0001 \u0001A\u0002\u0013%Q\u0010\u0003\u0004\u0000\u0001\u0001\u0006K\u0001\u001e\u0005\n\u0003\u0003\u0001\u0001\u0019!C\u0005\u0003\u0007A\u0011\"!\u0006\u0001\u0001\u0004%I!a\u0006\t\u0011\u0005m\u0001\u0001)Q\u0005\u0003\u000bA\u0011\"!\b\u0001\u0001\u0004%I!a\b\t\u0013\u0005E\u0002\u00011A\u0005\n\u0005M\u0002\u0002CA\u001c\u0001\u0001\u0006K!!\t\t\u0013\u0005e\u0002\u00011A\u0005\n\u0005m\u0002\"CA\"\u0001\u0001\u0007I\u0011BA#\u0011!\tI\u0005\u0001Q!\n\u0005u\u0002\"CA&\u0001\t\u0007I\u0011BA'\u0011!\t)\u0006\u0001Q\u0001\n\u0005=\u0003\"CA,\u0001\t\u0007I\u0011BA-\u0011!\t\t\b\u0001Q\u0001\n\u0005m\u0003\"CA:\u0001\t\u0007I\u0011BA;\u0011!\t)\t\u0001Q\u0001\n\u0005]\u0004\"CAD\u0001\t\u0007I\u0011BA;\u0011!\tI\t\u0001Q\u0001\n\u0005]\u0004\"CAF\u0001\t\u0007I\u0011BAG\u0011!\ty\n\u0001Q\u0001\n\u0005=\u0005\"CAQ\u0001\t\u0007I\u0011BAR\u0011!\ti\u000b\u0001Q\u0001\n\u0005\u0015\u0006\"CAX\u0001\t\u0007I\u0011BAR\u0011!\t\t\f\u0001Q\u0001\n\u0005\u0015\u0006\"CAZ\u0001\t\u0007I\u0011BAR\u0011!\t)\f\u0001Q\u0001\n\u0005\u0015\u0006\"CA\\\u0001\t\u0007I\u0011BAR\u0011!\tI\f\u0001Q\u0001\n\u0005\u0015\u0006\"CA^\u0001\t\u0007I\u0011BA;\u0011!\ti\f\u0001Q\u0001\n\u0005]\u0004\"CA`\u0001\t\u0007I\u0011BA;\u0011!\t\t\r\u0001Q\u0001\n\u0005]\u0004bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003;\u0004A\u0011AAc\u0011\u001d\t9\u000f\u0001C\u0001\u0003\u000bDq!!=\u0001\t\u0003\t)\rC\u0004\u0002v\u0002!\t!!2\t\u000f\u0005e\b\u0001\"\u0001\u0002F\"9\u0011Q \u0001\u0005\u0002\u0005\u0015\u0007b\u0002B\u0001\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005\u000b\u0001A\u0011AAc\u0011\u001d\u0011I\u0001\u0001C\u0001\u0003\u000bDqA!\u0004\u0001\t\u0003\t)\rC\u0004\u0003\u0012\u0001!\t!!2\t\u000f\tU\u0001\u0001\"\u0001\u0003\u0018!9!Q\u0004\u0001\u0005\u0002\u0005\u0015\u0007b\u0002B\u0011\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005K\u0001A\u0011AAc\u0011\u001d\u0011I\u0003\u0001C\u0001\u0003\u000bDqA!\f\u0001\t\u0003\t)\rC\u0004\u00032\u0001!\t!!2\t\u000f\tU\u0002\u0001\"\u0001\u0002F\"9!\u0011\b\u0001\u0005\u0002\u0005\u0015\u0007b\u0002B\u001f\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057BqA! \u0001\t\u0013\u0011y\bC\u0004\u00030\u0002!IA!-\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!\u0011\u001c\u0001\u0005\n\tm\u0007b\u0002B|\u0001\u0011%!\u0011 \u0005\b\u0005\u007f\u0004A\u0011BB\u0001\u0011%\u0019\t\u0003AI\u0001\n\u0013\u0019\u0019\u0003C\u0004\u0004:\u0001!Iaa\u000f\t\u000f\r}\u0002\u0001\"\u0003\u0004B!91\u0011\n\u0001\u0005\n\r-\u0003\"CB/\u0001E\u0005I\u0011BB\u0012\u0011\u001d\u0019y\u0006\u0001C\u0005\u0007CBqa!\u001d\u0001\t\u0013\u0019\u0019H\u0001\fD_:\u001cX/\\3s\u0019\u0006<W)\\5ui\u0016\u0014H+Z:u\u0015\tqu*A\u0004nKR\u0014\u0018nY:\u000b\u0003A\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A.\u0011\u0005q\u0003Q\"A'\u0016\u0003y\u0003\"a\u00185\u000e\u0003\u0001T!AT1\u000b\u0005\t\u001c\u0017AB2p[6|gN\u0003\u0002QI*\u0011QMZ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\f1a\u001c:h\u0013\tI\u0007MA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003Y>\u0004\"\u0001V7\n\u00059,&\u0001B+oSRDq\u0001]\u0002\u0002\u0002\u0003\u0007a,A\u0002yIE\n\u0001\"\\3ue&\u001c7\u000fI\u0001\u0010[>\u001c7.\u00113nS:\u001cE.[3oiV\tA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006)\u0011\rZ7j]*\u0011\u0011pY\u0001\bG2LWM\u001c;t\u0013\tYhOA\bN_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0003MiwnY6BI6Lgn\u00117jK:$x\fJ3r)\tag\u0010C\u0004q\r\u0005\u0005\t\u0019\u0001;\u0002!5|7m[!e[&t7\t\\5f]R\u0004\u0013\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0007\u0005=1-A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002BA\n\u0003\u0013\u0011\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002)\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\ra\u0017\u0011\u0004\u0005\ta&\t\t\u00111\u0001\u0002\u0006\u0005\trM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA\u0011!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tA!\u001e;jY*\u0019\u00111F2\u0002\rM,'O^3s\u0013\u0011\ty#!\n\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018!D:dQ\u0016$W\u000f\\3s?\u0012*\u0017\u000fF\u0002m\u0003kA\u0001\u0002\u001d\u0007\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013AE2p]N,X.\u001a:MC\u001e,U.\u001b;uKJ,\"!!\u0010\u0011\u0007q\u000by$C\u0002\u0002B5\u0013!cQ8ogVlWM\u001d'bO\u0016k\u0017\u000e\u001e;fe\u000612m\u001c8tk6,'\u000fT1h\u000b6LG\u000f^3s?\u0012*\u0017\u000fF\u0002m\u0003\u000fB\u0001\u0002]\b\u0002\u0002\u0003\u0007\u0011QH\u0001\u0014G>t7/^7fe2\u000bw-R7jiR,'\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002PA!\u00111EA)\u0013\u0011\t\u0019&!\n\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016,\"!a\u0017\u0011\t\u0005u\u00131\u000e\b\u0005\u0003?\n9\u0007E\u0002\u0002bUk!!a\u0019\u000b\u0007\u0005\u0015\u0014+\u0001\u0004=e>|GOP\u0005\u0004\u0003S*\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002n\u0005=$AB*ue&twMC\u0002\u0002jU\u000bQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0013\u0001C4s_V\u0004\u0018\n\u001a\u0019\u0016\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0006!!.\u0019<b\u0013\u0011\ti'a\u001f\u0002\u0013\u001d\u0014x.\u001e9JIB\u0002\u0013\u0001C4s_V\u0004\u0018\nZ\u0019\u0002\u0013\u001d\u0014x.\u001e9JIF\u0002\u0013!C1mY\u001e\u0013x.\u001e9t+\t\ty\t\u0005\u0004\u0002\u0012\u0006m\u0015qO\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u00033+\u0016AC2pY2,7\r^5p]&!\u0011QTAJ\u0005\u0011a\u0015n\u001d;\u0002\u0015\u0005dGn\u0012:pkB\u001c\b%\u0001\tu_BL7\r\r)beRLG/[8oaU\u0011\u0011Q\u0015\t\u0005\u0003O\u000bI+D\u0001b\u0013\r\tY+\u0019\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003E!x\u000e]5daA\u000b'\u000f^5uS>t\u0007\u0007I\u0001\u0011i>\u0004\u0018n\u0019\u0019QCJ$\u0018\u000e^5p]F\n\u0011\u0003^8qS\u000e\u0004\u0004+\u0019:uSRLwN\\\u0019!\u0003A!x\u000e]5dcA\u000b'\u000f^5uS>t\u0007'A\tu_BL7-\r)beRLG/[8oa\u0001\n\u0001\u0003^8qS\u000e\f\u0004+\u0019:uSRLwN\\\u0019\u0002#Q|\u0007/[22!\u0006\u0014H/\u001b;j_:\f\u0004%\u0001\u000bEKN\u001c'/\u001b2f\u000fJ|W\u000f\u001d%b]\u0012dWM]\u0001\u0016\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9IC:$G.\u001a:!\u0003M1U\r^2i\u001f\u001a47/\u001a;t\u0011\u0006tG\r\\3s\u0003Q1U\r^2i\u001f\u001a47/\u001a;t\u0011\u0006tG\r\\3sA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u00031D3aJAe!\u0011\tY-!7\u000e\u0005\u00055'\u0002BAh\u0003#\f1!\u00199j\u0015\u0011\t\u0019.!6\u0002\u000f),\b/\u001b;fe*\u0019\u0011q\u001b4\u0002\u000b),h.\u001b;\n\t\u0005m\u0017Q\u001a\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!B2m_N,\u0007f\u0001\u0015\u0002bB!\u00111ZAr\u0013\u0011\t)/!4\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0006;fgR\u001cuN\\:v[\u0016\u0014H*Y4NKR\u0014\u0018nY:)\u0007%\nY\u000f\u0005\u0003\u0002L\u00065\u0018\u0002BAx\u0003\u001b\u0014A\u0001V3ti\u0006\u0001B/Z:u\u000bb\u0004\u0018N]3He>,\bo\u001d\u0015\u0004U\u0005-\u0018a\n;fgRd\u0015n\u001d;He>,\bo\u001d%b]\u0012dWM]#se>\u00148\u000b[8vY\u0012\u001c6.\u001b9BY2D3aKAv\u00031\"Xm\u001d;MSN$xI]8vaND\u0015M\u001c3mKJ,%O]8s'\"|W\u000f\u001c3SKR\f\u0017N\\$bk\u001e,7\u000fK\u0002-\u0003W\fA\u0006^3ti\u0012+7o\u0019:jE\u0016<%o\\;q\u0011\u0006tG\r\\3s\u000bJ\u0014xN]*i_VdGmU6ja\u001e\u0013x.\u001e9)\u00075\nY/\u0001\u0014uKN$\u0018J\u001c<bY&$\u0007K]8u_\u000e|G\u000eV=qKNCw.\u001e7e'.L\u0007o\u0012:pkBD3ALAv\u0003-\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$8\u000fS1oI2,'/\u0012:s_J\u001c\u0006n\\;mIN[\u0017\u000e]$s_V\u0004\bfA\u0018\u0002l\u0006\u0019C/Z:u\u001f:d\u0017PR3uG\"|eMZ:fiN4uN]*uC\ndWm\u0012:pkB\u001c\bf\u0001\u0019\u0002l\u0006\u0001E/Z:u\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9IC:$G.\u001a:FeJ|'o\u00155pk2$W\t\u001f9je\u0016<\u0015-^4f/\",gNT8u\u0007>|'\u000fZ5oCR|'\u000fK\u00022\u0003W\fq\b^3ti\u001a+Go\u00195PM\u001a\u001cX\r^:IC:$G.\u001a:FeJ|'o\u00155pk2$W\t\u001f9je\u0016<\u0015-^4f/\",gNT8u\u0007>|'\u000fZ5oCR|'\u000fK\u00023\u0003W\fq\u0006[1oI2,'/\u0012:s_J\u001c\u0006n\\;mI\u0016C\b/\u001b:f\u000f\u0006,x-Z,iK:tu\u000e^\"p_J$\u0017N\\1u_J$2\u0001\u001cB\r\u0011\u001d\u0011Yb\ra\u0001\u00037\nq\u0001[1oI2,'/\u0001\u001buKN$X\t_2faRLwN\\%o\t\u0016\u001cXM]5bY&TX-Q:tS\u001etW.\u001a8u'\"|W\u000f\u001c3TW&\u0004X*Z7cKJD3\u0001NAv\u0003a\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$8\u000fS1oI2,'\u000fU1si&$\u0018n\u001c8FeJ|'o\u00155pk2$7k[5q!\u0006\u0014H/\u001b;j_:D3!NAv\u0003A\"Xm\u001d;MSN$xJ\u001a4tKR\u001c\b+\u0019:uSRLwN\\#se>\u00148\u000b[8vY\u0012\u001c6.\u001b9QCJ$\u0018\u000e^5p]\"\u001aa'a;\u0002OQ,7\u000f^\"iC:<W-\u00138NK6\u0014WM]:iSB\u001c\u0006n\\;mIV\u0003H-\u0019;f\u000f\u0006,x-\u001a\u0015\u0004o\u0005-\u0018!\n;fgR\u0014VMY1mC:\u001c\u0017N\\4He>,\bo\u00155pk2$'+\u001a;bS:<\u0015-^4fQ\rA\u00141^\u0001.i\u0016\u001cHOT3hCRLg/Z\"p]N,X.\u001a:MC\u001e\u001c\u0006n\\;mI\n+'+Z2pe\u0012,G-Q:[KJ|\u0007fA\u001d\u0002l\u0006qC/Z:u\u000b6\u0004H/_\"veJ,g\u000e^(gMN,Go]*i_VdGMT8u\u0007>,h\u000e^!t\u000bb\u0004\u0018N]3eQ\rQ\u00141^\u0001\u001di\u0016\u001cH/T3nE\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tG+Y4tQ\rY\u00141^\u00011i\u0016\u001cH/T1zE\u0016\u0004&/\u001a4jqR{\u0007/[2QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5UK:\fg\u000e\u001e$v]\u000e$\u0018n\u001c8)\u0007q\nY/\u0001\nwKJLg-_'f[\n,'/T3ue&\u001cG#\u00027\u0003F\t=\u0003b\u0002B${\u0001\u0007!\u0011J\u0001\u0007[\u0016l'-\u001a:\u0011\u0007q\u0013Y%C\u0002\u0003N5\u0013A#T3nE\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B){\u0001\u0007!1K\u0001\fKb\u0004Xm\u0019;fI2\u000bw\rE\u0002U\u0005+J1Aa\u0016V\u0005\u0011auN\\4\u0002#Y,'/\u001b4z\u001b\u0016$(/[2WC2,X-\u0006\u0003\u0003^\t-D#\u00027\u0003`\t\r\u0004b\u0002B1}\u0001\u0007\u00111L\u0001\u000b[\u0016$(/[2OC6,\u0007b\u0002B3}\u0001\u0007!qM\u0001\u000eKb\u0004Xm\u0019;fIZ\u000bG.^3\u0011\t\t%$1\u000e\u0007\u0001\t\u001d\u0011iG\u0010b\u0001\u0005_\u0012\u0011\u0001V\t\u0005\u0005c\u00129\bE\u0002U\u0005gJ1A!\u001eV\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001\u0016B=\u0013\r\u0011Y(\u0016\u0002\u0004\u0003:L\u0018\u0001G2sK\u0006$X\rT5ti\u001e\u0013x.\u001e9t%\u0016\u001c\bo\u001c8tKR!!\u0011\u0011BN!\u0019\u0011\u0019Ia#\u0003\u00106\u0011!Q\u0011\u0006\u0005\u0005\u000f\u0013I)\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\n\u0002\u0000%!!Q\u0012BC\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0005#\u00139*\u0004\u0002\u0003\u0014*\u0019!QS1\u0002\u000f5,7o]1hK&!!\u0011\u0014BJ\u0005Ya\u0015n\u001d;He>,\bo\u001d*fgB|gn]3ECR\f\u0007b\u0002BO\u007f\u0001\u0007!qT\u0001\u0007OJ|W\u000f]:\u0011\r\t\u0005&1VA.\u001d\u0011\u0011\u0019Ka*\u000f\t\u0005\u0005$QU\u0005\u0002-&\u0019!\u0011V+\u0002\u000fA\f7m[1hK&!\u0011Q\u0014BW\u0015\r\u0011I+V\u0001\u001eGJ,\u0017\r^3MSN$xI]8vaN,%O]8s%\u0016\u001c\bo\u001c8tKR!!\u0011\u0011BZ\u0011\u001d\u0011)\f\u0011a\u0001\u0005o\u000bQ!\u001a:s_J\u0004BA!/\u0003@6\u0011!1\u0018\u0006\u0004\u0005{\u000b\u0017\u0001\u00039s_R|7m\u001c7\n\t\t\u0005'1\u0018\u0002\u0007\u000bJ\u0014xN]:\u0002#\r\u0014X-\u0019;f\u0019&\u001cH/\u001a3He>,\b\u000f\u0006\u0003\u0003H\nU\u0007\u0003\u0002Be\u0005\u001ftAA!%\u0003L&!!Q\u001aBJ\u0003Ya\u0015n\u001d;He>,\bo\u001d*fgB|gn]3ECR\f\u0017\u0002\u0002Bi\u0005'\u00141\u0002T5ti\u0016$wI]8va*!!Q\u001aBJ\u0011\u001d\u00119.\u0011a\u0001\u00037\nqa\u001a:pkBLE-\u0001\u000fde\u0016\fG/\u001a#fg\u000e\u0014\u0018NY3He>,\bo\u001d*fgB|gn]3\u0015\t\tu'1\u001f\t\u0007\u0005\u0007\u0013YIa8\u0011\r\t\u0005(1\u001dBs\u001b\t\u0011I)\u0003\u0003\u0002\u001e\n%\u0005\u0003\u0002Bt\u0005[tAA!%\u0003j&!!1\u001eBJ\u0003i!Um]2sS\n,wI]8vaN\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0011yO!=\u0003\u001d\u0011+7o\u0019:jE\u0016$wI]8va*!!1\u001eBJ\u0011\u001d\u0011iJ\u0011a\u0001\u0005k\u0004bA!)\u0003,\n\u0015\u0018!I2sK\u0006$X\rR3tGJL'-Z$s_V\u00048/\u0012:s_J\u0014Vm\u001d9p]N,GC\u0002Bo\u0005w\u0014i\u0010C\u0004\u0003X\u000e\u0003\r!a\u0017\t\u000f\tU6\t1\u0001\u00038\u0006Q2M]3bi\u00164U\r^2i\u001f\u001a47/\u001a;t%\u0016\u001c\bo\u001c8tKRA11AB\n\u00073\u0019i\u0002\u0005\u0004\u0003\u0004\n-5Q\u0001\t\u0005\u0007\u000f\u0019iA\u0004\u0003\u0003\u0012\u000e%\u0011\u0002BB\u0006\u0005'\u000bqc\u00144gg\u0016$h)\u001a;dQJ+7\u000f]8og\u0016$\u0015\r^1\n\t\r=1\u0011\u0003\u0002\u0019\u001f\u001a47/\u001a;GKR\u001c\u0007NU3ta>t7/Z$s_V\u0004(\u0002BB\u0006\u0005'Cqa!\u0006E\u0001\u0004\u00199\"A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\u0011\tKa+\u0002&\"911\u0004#A\u0002\tM\u0013A\u00032bg\u0016|eMZ:fi\"I1q\u0004#\u0011\u0002\u0003\u0007!1K\u0001\u0013S:\u001c'/Z7f]RLgnZ(gMN,G/\u0001\u0013de\u0016\fG/\u001a$fi\u000eDwJ\u001a4tKR\u001c(+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019)C\u000b\u0003\u0003T\r\u001d2FAB\u0015!\u0011\u0019Yc!\u000e\u000e\u0005\r5\"\u0002BB\u0018\u0007c\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rMR+\u0001\u0006b]:|G/\u0019;j_:LAaa\u000e\u0004.\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002?\r\u0014X-\u0019;f\r\u0016$8\r[(gMN,Go]#se>\u0014(+Z:q_:\u001cX\r\u0006\u0003\u0004\u0004\ru\u0002b\u0002B[\r\u0002\u0007!qW\u0001\u0015GJ,\u0017\r^3DkJ\u0014XM\u001c;PM\u001a\u001cX\r^:\u0015\u0011\r\u001511IB#\u0007\u000fBqa!\u0006H\u0001\u0004\u00199\u0002C\u0004\u0004\u001c\u001d\u0003\rAa\u0015\t\u000f\r}q\t1\u0001\u0003T\u0005\u00192M]3bi\u0016d\u0015\r^3ti>3gm]3ugRA1QJB,\u00073\u001aY\u0006\u0005\u0005\u0003b\u000e=\u0013QUB*\u0013\u0011\u0019\tF!#\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002z\rU\u0013\u0002\u0002B,\u0003wBqa!\u0006I\u0001\u0004\u00199\u0002C\u0004\u0004\u001c!\u0003\rAa\u0015\t\u0013\r}\u0001\n%AA\u0002\tM\u0013!H2sK\u0006$X\rT1uKN$xJ\u001a4tKR\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0002!\r\u0014X-\u0019;f\u0003N\u001c\u0018n\u001a8nK:$H\u0003BB2\u0007_\u0002R\u0001VB3\u0007SJ1aa\u001aV\u0005\u0015\t%O]1z!\r!61N\u0005\u0004\u0007[*&\u0001\u0002\"zi\u0016Dqa!\u0006K\u0001\u0004\u00199\"\u0001\rde\u0016\fG/Z\"p]N,X.\u001a:MC\u001e,U.\u001b;uKJ$B!!\u0010\u0004v!1qo\u0013a\u0001\u0007o\u00022!^B=\u0013\r\u0019YH\u001e\u0002\u0006\u0003\u0012l\u0017N\u001c")
public class ConsumerLagEmitterTest {
    private Metrics metrics = null;
    private MockAdminClient mockAdminClient = null;
    private GroupCoordinator groupCoordinator = null;
    private Scheduler scheduler = null;
    private ConsumerLagEmitter consumerLagEmitter = null;
    private final MockTime time = new MockTime();
    private final String protocolType;
    private final String groupId0;
    private final String groupId1;
    private final List<String> allGroups = new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)Nil$.MODULE$));
    private final TopicPartition topic0Partition0 = new TopicPartition("topic-0", 0);
    private final TopicPartition topic0Partition1 = new TopicPartition("topic-0", 1);
    private final TopicPartition topic1Partition0 = new TopicPartition("topic-1", 0);
    private final TopicPartition topic1Partition1 = new TopicPartition("topic-1", 1);
    private final String DescribeGroupHandler;
    private final String FetchOffsetsHandler;

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private MockAdminClient mockAdminClient() {
        return this.mockAdminClient;
    }

    private void mockAdminClient_$eq(MockAdminClient x$1) {
        this.mockAdminClient = x$1;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private void groupCoordinator_$eq(GroupCoordinator x$1) {
        this.groupCoordinator = x$1;
    }

    private Scheduler scheduler() {
        return this.scheduler;
    }

    private void scheduler_$eq(Scheduler x$1) {
        this.scheduler = x$1;
    }

    private ConsumerLagEmitter consumerLagEmitter() {
        return this.consumerLagEmitter;
    }

    private void consumerLagEmitter_$eq(ConsumerLagEmitter x$1) {
        this.consumerLagEmitter = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId0() {
        return this.groupId0;
    }

    private String groupId1() {
        return this.groupId1;
    }

    private List<String> allGroups() {
        return this.allGroups;
    }

    private TopicPartition topic0Partition0() {
        return this.topic0Partition0;
    }

    private TopicPartition topic0Partition1() {
        return this.topic0Partition1;
    }

    private TopicPartition topic1Partition0() {
        return this.topic1Partition0;
    }

    private TopicPartition topic1Partition1() {
        return this.topic1Partition1;
    }

    private String DescribeGroupHandler() {
        return this.DescribeGroupHandler;
    }

    private String FetchOffsetsHandler() {
        return this.FetchOffsetsHandler;
    }

    @BeforeEach
    public void initialize() {
        java.util.List brokers = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new Node(0, "localhost", 9092), (List)Nil$.MODULE$)).asJava();
        this.metrics_$eq(new Metrics());
        this.groupCoordinator_$eq((GroupCoordinator)Mockito.mock(GroupCoordinator.class));
        this.scheduler_$eq((Scheduler)new MockScheduler((Time)this.time()));
        this.mockAdminClient_$eq(new MockAdminClient(brokers, (Node)brokers.get(0)));
        this.consumerLagEmitter_$eq(this.createConsumerLagEmitter((Admin)this.mockAdminClient()));
    }

    @AfterEach
    public void close() {
        if (this.consumerLagEmitter() != null) {
            this.consumerLagEmitter().shutdown();
        }
        if (this.metrics() != null) {
            this.metrics().close();
        }
        if (this.mockAdminClient() != null) {
            this.mockAdminClient().close();
            return;
        }
    }

    @Test
    public void testConsumerLagMetrics() {
        String groupId2 = "lkc-xxxxx_group-2";
        TopicPartition topic2Partition0 = new TopicPartition("lkc-xxxxx_topic-2", 0);
        TopicPartition unprefixedTopic2Partition0 = new TopicPartition("topic-2", 0);
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 2, (short)1), (List)new .colon.colon((Object)new NewTopic("topic-1", 2, (short)1), (List)new .colon.colon((Object)new NewTopic("lkc-xxxxx_topic-2", 1, (short)1), (List)Nil$.MODULE$)));
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member0 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setGroupInstanceId("group.instance.0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroupMember member1 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-1").setClientId("client-1").setClientHost("host-1").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroupMember member2 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-1:member-0").setGroupInstanceId("group.instance.1").setClientId("client-2").setClientHost("host-2").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic1Partition0(), (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroupMember member3 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-1:member-1").setClientId("client-3").setClientHost("host-3").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic1Partition1(), (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroupMember member4 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("lkc-xxxxx_group-2:member-0").setClientId("client-4").setClientHost("host-4").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)unprefixedTopic2Partition0, (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member0, (List)new .colon.colon((Object)member1, (List)Nil$.MODULE$))).asJava());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member2, (List)new .colon.colon((Object)member3, (List)Nil$.MODULE$))).asJava());
        DescribeGroupsResponseData.DescribedGroup group2 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId2).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member4, (List)Nil$.MODULE$)).asJava());
        .colon.colon topic0Partitions = new .colon.colon((Object)this.topic0Partition0(), (List)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$));
        .colon.colon topic1Partitions = new .colon.colon((Object)this.topic1Partition0(), (List)new .colon.colon((Object)this.topic1Partition1(), (List)Nil$.MODULE$));
        .colon.colon topic2Partitions = new .colon.colon((Object)topic2Partition0, (List)Nil$.MODULE$);
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$)))).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)new .colon.colon((Object)group1, (List)new .colon.colon((Object)group2, (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topic0Partitions, 10000L, 5000L));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId1())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topic1Partitions, 15000L, 3500L));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId2)), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topic2Partitions, 6000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topic0Partitions, 25000L, 4000L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topic1Partitions, 35000L, 3000L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topic2Partitions, 35000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member0.groupInstanceId()), member0.memberId(), member0.clientId(), this.topic0Partition0()), 15000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition1()), 14000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member2.groupInstanceId()), member2.memberId(), member2.clientId(), this.topic1Partition0()), 20000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member3.groupInstanceId()), member3.memberId(), member3.clientId(), this.topic1Partition1()), 19500L);
        this.verifyMemberMetric(new MemberTopicPartition(groupId2, Option$.MODULE$.apply((Object)member4.groupInstanceId()), member4.memberId(), member4.clientId(), topic2Partition0), 29000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)5L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)3));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
    }

    @Test
    public void testExpireGroups() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        DescribeGroupsResponseData.DescribedGroupMember member0 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroupMember member1 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-1:member-0").setClientId("client-1").setClientHost("host-1").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member0, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member1, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse(this.allGroups())).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId1(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsResponse((List<String>)package$.MODULE$.List().empty()));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)Nil$.MODULE$))).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)new .colon.colon((Object)group1, (List)Nil$.MODULE$))));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId1(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group1, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 10000L, 0L));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId1())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 5000L, 0L)).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member0.groupInstanceId()), member0.memberId(), member0.clientId(), this.topic0Partition0()), 15000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition0()), 20000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)2L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 35000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        Assertions.assertEquals((int)0, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testListGroupsHandlerErrorShouldSkipAll() {
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsErrorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)0))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)0))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        Assertions.assertEquals((int)0, (int)this.consumerLagEmitter().consumerLagMetrics().size());
    }

    @Test
    public void testListGroupsHandlerErrorShouldRetainGauges() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsErrorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testDescribeGroupHandlerErrorShouldSkipGroup() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse(this.allGroups()));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava(this.allGroups()).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)new .colon.colon((Object)group1, (List)Nil$.MODULE$))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
    }

    @Test
    public void testInvalidProtocolTypeShouldSkipGroup() {
        String invalidProtocolType = "invalid-protocol";
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup invalidGroupSummary = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(invalidProtocolType).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse(this.allGroups()));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava(this.allGroups()).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)invalidGroupSummary, (List)new .colon.colon((Object)group, (List)Nil$.MODULE$))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testFetchOffsetsHandlerErrorShouldSkipGroup() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse(this.allGroups()));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava(this.allGroups()).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)new .colon.colon((Object)group1, (List)Nil$.MODULE$))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId1())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsErrorResponse(Errors.COORDINATOR_NOT_AVAILABLE));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
    }

    @Test
    public void testOnlyFetchOffsetsForStableGroups() {
        String groupId2 = "group-2";
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup stableGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId2).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup rebalancingGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.PREPARING_REBALANCE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup emptyGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.EMPTY.toString()).setProtocolType(this.protocolType());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$)))).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)rebalancingGroup, (List)new .colon.colon((Object)emptyGroup, (List)new .colon.colon((Object)stableGroup, (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId2)), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition("group-2", Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
    }

    @Test
    public void testDescribeGroupHandlerErrorShouldExpireGaugeWhenNotCoordinator() {
        this.handlerErrorShouldExpireGaugeWhenNotCoordinator(this.DescribeGroupHandler());
    }

    @Test
    public void testFetchOffsetsHandlerErrorShouldExpireGaugeWhenNotCoordinator() {
        this.handlerErrorShouldExpireGaugeWhenNotCoordinator(this.FetchOffsetsHandler());
    }

    public void handlerErrorShouldExpireGaugeWhenNotCoordinator(String handler) {
        if (!((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.DescribeGroupHandler(), this.FetchOffsetsHandler()}))).contains((Object)handler)) {
            Assertions.fail((String)new StringBuilder(16).append("unknown handler ").append(handler).toString());
        }
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        String string = handler;
        String string2 = this.DescribeGroupHandler();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsErrorResponse(this.groupId0(), Errors.COORDINATOR_LOAD_IN_PROGRESS)).thenReturn(this.createDescribeGroupsErrorResponse(this.groupId0(), Errors.NOT_COORDINATOR));
            Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        } else {
            Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
            Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L)).thenReturn(this.createFetchOffsetsErrorResponse(Errors.COORDINATOR_NOT_AVAILABLE)).thenReturn(this.createFetchOffsetsErrorResponse(Errors.NOT_COORDINATOR));
        }
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        Assertions.assertEquals((int)0, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        String string3 = handler;
        String string4 = this.DescribeGroupHandler();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
            return;
        }
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testExceptionInDeserializeAssignmentShouldSkipMember() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member0 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(new byte[]{0, 1});
        DescribeGroupsResponseData.DescribedGroupMember member1 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-1").setClientId("client-1").setClientHost("host-1").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroupMember member2 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-2").setClientId("client-2").setClientHost("host-2").setMemberAssignment((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member0, (List)new .colon.colon((Object)member1, (List)new .colon.colon((Object)member2, (List)Nil$.MODULE$)))).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testFetchOffsetsHandlerPartitionErrorShouldSkipPartition() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 2, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$));
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        OffsetFetchResponseData.OffsetFetchResponseGroup currentOffsets = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(this.groupId0()).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.topic0Partition0().topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.topic0Partition0().partition()).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata(""), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.topic0Partition1().topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.topic0Partition1().partition()).setErrorCode(Errors.NONE.code()).setCommittedOffset(15000L).setCommittedLeaderEpoch(-1).setMetadata(""), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$))).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(CompletableFuture.completedFuture(currentOffsets));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition1()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testListOffsetsPartitionErrorShouldSkipPartition() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 2, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$));
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        java.util.Map failedTopicPartitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic0Partition0()), (Object)Errors.LEADER_NOT_AVAILABLE.exception())}))).asJava();
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.mockAdminClient().updateOffsetsWithExceptions(failedTopicPartitions);
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition1()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testChangeInMembershipShouldUpdateGauge() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        DescribeGroupsResponseData.DescribedGroupMember member0 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroupMember member1 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-1").setClientId("client-1").setClientHost("host-1").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member0, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member1, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group1, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 5000L, 0L)).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member0.groupInstanceId()), member0.memberId(), member0.clientId(), this.topic0Partition0()), 20000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 35000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testRebalancingGroupShouldRetainGauge() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup rebalancingGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.PREPARING_REBALANCE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)rebalancingGroup, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 40000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 46000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 6000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 6000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testNegativeConsumerLagShouldBeRecordedAsZero() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 30000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 0L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testEmptyCurrentOffsetsShouldNotCountAsExpired() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.eq((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(this.groupId0())), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)package$.MODULE$.List().empty(), 0L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (OffsetFetchRequestData.OffsetFetchRequestGroup)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
    }

    @Test
    public void testMemberTopicPartitionTags() {
        scala.collection.mutable.Map externalTags = new MemberTopicPartition("lkc-yyyyy_external-group", (Option)new Some((Object)"group-instance-0"), "member-0", "client-0", new TopicPartition("lkc-yyyyy_external-topic", 0)).tags();
        Assertions.assertEquals((Object)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer-group"), (Object)"external-group"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-instance-id"), (Object)"group-instance-0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member"), (Object)"member-0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)"external-topic"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"lkc-yyyyy")}))), (Object)externalTags);
        scala.collection.mutable.Map internalTags = new MemberTopicPartition("internal-group", (Option)None$.MODULE$, "member-1", "client-1", new TopicPartition("__consumer_offsets", 50)).tags();
        Assertions.assertEquals((Object)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer-group"), (Object)"internal-group"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member"), (Object)"member-1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)"__consumer_offsets"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)"50")}))), (Object)internalTags);
    }

    @Test
    public void testMaybePrefixTopicPartitionsWithTenantFunction() {
        .colon.colon unprefixedTopicPartitions = new .colon.colon((Object)new TopicPartition("test-topic", 0), (List)new .colon.colon((Object)new TopicPartition("test-topic", 1), (List)new .colon.colon((Object)new TopicPartition("test-topic", 2), (List)new .colon.colon((Object)new TopicPartition("test-topic", 3), (List)Nil$.MODULE$))));
        String externalGroup = "lkc-yyyyy_test-group";
        ((List)this.consumerLagEmitter().maybePrefixTopicPartitionsWithTenantFunction(externalGroup).apply((Object)unprefixedTopicPartitions)).foreach((Function1 & Serializable)topicPartition -> {
            ConsumerLagEmitterTest.$anonfun$testMaybePrefixTopicPartitionsWithTenantFunction$1(topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyMemberMetric(MemberTopicPartition member, long expectedLag) {
        Option metric = CollectionConverters$.MODULE$.MapHasAsScala(this.metrics().metrics()).asScala().get((Object)this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", CollectionConverters$.MODULE$.MutableMapHasAsJava(member.tags()).asJava()));
        Assertions.assertTrue((boolean)metric.isDefined());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)expectedLag), (Object)((KafkaMetric)metric.get()).metricValue());
    }

    private <T> void verifyMetricValue(String metricName, T expectedValue) {
        Option metric = CollectionConverters$.MODULE$.MapHasAsScala(this.metrics().metrics()).asScala().get((Object)this.metrics().metricName(metricName, ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        Assertions.assertTrue((boolean)metric.isDefined());
        Assertions.assertEquals(expectedValue, (Object)((KafkaMetric)metric.get()).metricValue());
    }

    private CompletableFuture<ListGroupsResponseData> createListGroupsResponse(List<String> groups) {
        return CompletableFuture.completedFuture(new ListGroupsResponseData().setGroups(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)groups.map((Function1 & Serializable)groupId -> this.createListedGroup((String)groupId))).asJava()));
    }

    private CompletableFuture<ListGroupsResponseData> createListGroupsErrorResponse(Errors error) {
        return CompletableFuture.completedFuture(new ListGroupsResponseData().setErrorCode(error.code()));
    }

    private ListGroupsResponseData.ListedGroup createListedGroup(String groupId) {
        return new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType(this.protocolType()).setGroupState(ConsumerGroupState.STABLE.toString());
    }

    private CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> createDescribeGroupsResponse(List<DescribeGroupsResponseData.DescribedGroup> groups) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.SeqHasAsJava(groups).asJava());
    }

    private CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> createDescribeGroupsErrorResponse(String groupId, Errors error) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(error.code()), (List)Nil$.MODULE$)).asJava());
    }

    private CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> createFetchOffsetsResponse(List<TopicPartition> topicPartitions, long baseOffset, long incrementingOffset) {
        return CompletableFuture.completedFuture(this.createCurrentOffsets(topicPartitions, baseOffset, incrementingOffset));
    }

    private long createFetchOffsetsResponse$default$3() {
        return 0L;
    }

    private CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> createFetchOffsetsErrorResponse(Errors error) {
        CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup> failedFuture = new CompletableFuture<OffsetFetchResponseData.OffsetFetchResponseGroup>();
        failedFuture.completeExceptionally(error.exception());
        return failedFuture;
    }

    private OffsetFetchResponseData.OffsetFetchResponseGroup createCurrentOffsets(List<TopicPartition> topicPartitions, long baseOffset, long incrementingOffset) {
        List topics = ((IterableOnceOps)((List)topicPartitions.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                int index = x0$1._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(topicPartition.partition()).setCommittedOffset(baseOffset + (long)index * incrementingOffset).setMetadata("").setCommittedLeaderEpoch(-1));
            }
            throw new MatchError(null);
        }).groupBy((Function1 & Serializable)x$1 -> ((TopicPartition)x$1._1()).topic()).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String topic = (String)x0$2._1();
                List partitions = (List)x0$2._2();
                return new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions.map((Function1 & Serializable)x$2 -> (OffsetFetchResponseData.OffsetFetchResponsePartitions)x$2._2())).asJava());
            }
            throw new MatchError(null);
        })).toList();
        return new OffsetFetchResponseData.OffsetFetchResponseGroup().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
    }

    private java.util.Map<TopicPartition, Long> createLatestOffsets(List<TopicPartition> topicPartitions, long baseOffset, long incrementingOffset) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((List)topicPartitions.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                int index = x0$1._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)(baseOffset + (long)index * incrementingOffset));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    private long createLatestOffsets$default$3() {
        return 0L;
    }

    private byte[] createAssignment(List<TopicPartition> topicPartitions) {
        return ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(CollectionConverters$.MODULE$.SeqHasAsJava(topicPartitions).asJava()), (short)3).array();
    }

    private ConsumerLagEmitter createConsumerLagEmitter(Admin admin) {
        return new ConsumerLagEmitter(this.metrics(), this.scheduler(), this.groupCoordinator(), 60000L, admin);
    }

    public static final /* synthetic */ void $anonfun$testMaybePrefixTopicPartitionsWithTenantFunction$1(TopicPartition topicPartition) {
        Assertions.assertEquals((Object)"lkc-yyyyy_test-topic", (Object)topicPartition.topic());
    }

    public ConsumerLagEmitterTest() {
        this.protocolType = "consumer";
        this.groupId0 = "group-0";
        this.groupId1 = "group-1";
        this.DescribeGroupHandler = "describeGroup";
        this.FetchOffsetsHandler = "fetchOffsets";
    }
}

