/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import kafka.metrics.LinuxDiskMetricsCollector;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Timeout(value=120000L)
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001B\u000b\u0017\u0001mAQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001A\u0002\u0013\u0005Q\u0006C\u00047\u0001\u0001\u0007I\u0011A\u001c\t\ru\u0002\u0001\u0015)\u0003/\u0011\u001dq\u0004\u00011A\u0005\u0002}Bq\u0001\u0014\u0001A\u0002\u0013\u0005Q\n\u0003\u0004P\u0001\u0001\u0006K\u0001\u0011\u0005\b!\u0002\u0011\r\u0011\"\u0001R\u0011\u0019A\u0006\u0001)A\u0005%\"9\u0011\f\u0001b\u0001\n\u0003Q\u0006BB4\u0001A\u0003%1\fC\u0004i\u0001\t\u0007I\u0011A5\t\r)\u0004\u0001\u0015!\u0003b\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015A\b\u0001\"\u0001m\u0011\u0015i\b\u0001\"\u0001m\u0011\u0019\t)\u0001\u0001C\u0001Y\"1\u0011\u0011\u0002\u0001\u0005\u00021Da!!\u0004\u0001\t\u0003a\u0007BBA\t\u0001\u0011\u0005ANA\u000fMS:,\b\u0010R5tW6+GO]5dg\u000e{G\u000e\\3di>\u0014H+Z:u\u0015\t9\u0002$A\u0004nKR\u0014\u0018nY:\u000b\u0003e\tQa[1gW\u0006\u001c\u0001aE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0019\u0003\u0015)H/\u001b7t\u0013\t9CEA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0016\u0001\u001b\u00051\u0012a\u00022bg\u0016$\u0015N]\u000b\u0002]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0003S>T\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\t!a)\u001b7f\u0003-\u0011\u0017m]3ESJ|F%Z9\u0015\u0005aZ\u0004CA\u000f:\u0013\tQdD\u0001\u0003V]&$\bb\u0002\u001f\u0004\u0003\u0003\u0005\rAL\u0001\u0004q\u0012\n\u0014\u0001\u00032bg\u0016$\u0015N\u001d\u0011\u0002\tQLW.Z\u000b\u0002\u0001B\u0011\u0011IS\u0007\u0002\u0005*\u0011Qe\u0011\u0006\u0003\t\u0016\u000baaY8n[>t'BA\rG\u0015\t9\u0005*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0006\u0019qN]4\n\u0005-\u0013%\u0001\u0002+j[\u0016\f\u0001\u0002^5nK~#S-\u001d\u000b\u0003q9Cq\u0001\u0010\u0004\u0002\u0002\u0003\u0007\u0001)A\u0003uS6,\u0007%A\u0003qe>\u00048/F\u0001S!\t\u0019f+D\u0001U\u0015\t)&'\u0001\u0003vi&d\u0017BA,U\u0005)\u0001&o\u001c9feRLWm]\u0001\u0007aJ|\u0007o\u001d\u0011\u0002\u0019-\fgm[1D_:4\u0017nZ:\u0016\u0003m\u00032\u0001X0b\u001b\u0005i&B\u00010\u001f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Av\u00131aU3r!\t\u0011W-D\u0001d\u0015\t!\u0007$\u0001\u0004tKJ4XM]\u0005\u0003M\u000e\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006i1.\u00194lC\u000e{gNZ5hg\u0002\n1b[1gW\u0006\u001cuN\u001c4jOV\t\u0011-\u0001\u0007lC\u001a\\\u0017mQ8oM&<\u0007%A\u0003tKR,\u0006\u000fF\u00019Q\tqa\u000e\u0005\u0002pm6\t\u0001O\u0003\u0002re\u0006\u0019\u0011\r]5\u000b\u0005M$\u0018a\u00026va&$XM\u001d\u0006\u0003k\"\u000bQA[;oSRL!a\u001e9\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0004dY\u0016\fg.\u00169)\u0005=Q\bCA8|\u0013\ta\bOA\u0005BMR,'/R1dQ\u0006qA/Z:u\t\u00164\u0018nY3MSN$\bF\u0001\t\u0000!\ry\u0017\u0011A\u0005\u0004\u0003\u0007\u0001(\u0001\u0002+fgR\f1\u0002^3ti6+GO]5dg\"\u0012\u0011c`\u0001\ti\u0016\u001cHOU1uK\"\u0012!c`\u0001\u000bi\u0016\u001cH/V:bE2,\u0007FA\n\u0000\u0003\r\"Xm\u001d;V]\u0006\u0014G.\u001a+p%\u0016\fGMT8oKbL7\u000f^3oiB\u0013xn\u0019$jY\u0016D#\u0001F@)\u000f\u0001\t9\"!\b\u0002 A\u0019q.!\u0007\n\u0007\u0005m\u0001OA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0007\u0005!\u000e\u0019")
public class LinuxDiskMetricsCollectorTest
implements Logging {
    private File baseDir = null;
    private Time time = null;
    private final Properties props = new Properties();
    private final Seq<KafkaConfig> kafkaConfigs;
    private final KafkaConfig kafkaConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File baseDir() {
        return this.baseDir;
    }

    public void baseDir_$eq(File x$1) {
        this.baseDir = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public Seq<KafkaConfig> kafkaConfigs() {
        return this.kafkaConfigs;
    }

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    @BeforeEach
    public void setUp() {
        this.baseDir_$eq(TestUtils.tempDirectory(null, null));
        this.time_$eq((Time)new MockTime(100L, 1000L));
    }

    @AfterEach
    public void cleanUp() {
        Utils.delete((File)this.baseDir(), (boolean)false);
    }

    @Test
    public void testDeviceList() {
        String diskStats = "  8 0 sda 425340 145628 83735176 3176407 71440550 167315203 2216615250 269742334 0 71146779 233664417\n\t8 16 sdb 6396 757 340594 87481 23734 54031 739680 88939 0 78283 171644\n 0 0";
        String mounts = "/dev/sda /mnt/data/data0\n/dev/sdb /mnt/logs\n/dev/sdc /mnt/data/data1\n";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(this.baseDir().toPath().resolve("mounts"), mounts.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        LinuxDiskMetricsCollector collector = new LinuxDiskMetricsCollector(this.kafkaConfig(), this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sda"), (Object)"/mnt/data/data0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sdc"), (Object)"/mnt/data/data1")})), (Object)collector.devices());
    }

    @Test
    public void testMetrics() {
        String diskStats1 = "8 0 sda 425340 145628 83735176 3176407 71440550 167315203 2216615250 269742334 0 71146779 233664417";
        String mounts = "/dev/sda /mnt/data/data0";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats1.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(this.baseDir().toPath().resolve("mounts"), mounts.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        LinuxDiskMetricsCollector collector = new LinuxDiskMetricsCollector(this.kafkaConfig(), this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying());
        Assertions.assertEquals((int)11, (int)collector.metrics().length);
    }

    @Test
    public void testRate() {
        String diskStats1 = "8 0 sda 425340 145628 83735176 3176407 71440550 167315203 2216615250 269742334 1 71146779 233664417";
        String mounts = "/dev/sda /mnt/data/data0";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats1.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(this.baseDir().toPath().resolve("mounts"), mounts.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        LinuxDiskMetricsCollector collector = new LinuxDiskMetricsCollector(this.kafkaConfig(), this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying());
        Assertions.assertEquals((double)0.0, (double)collector.metricRate("sda", 0), (double)1.0E-4);
        Assertions.assertEquals((double)1.0, (double)collector.metricRate("sda", 8), (double)1.0E-4);
        this.time().sleep(10L);
        String diskStats2 = "8 0 sda 425440 145628 83735176 3176407 71440550 167315203 2216615250 269742334 10 71146779 233664417";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)10000.0, (double)collector.metricRate("sda", 0), (double)1.0E-4);
        Assertions.assertEquals((double)10.0, (double)collector.metricRate("sda", 8), (double)1.0E-4);
        Assertions.assertEquals((double)-1.0, (double)collector.metricRate("sdd", 0), (double)1.0E-4);
        Assertions.assertEquals((double)-1.0, (double)collector.metricRate("sda", 11), (double)1.0E-4);
    }

    @Test
    public void testUsable() {
        String diskStats = "8 0 sda 425340 145628 83735176 3176407 71440550 167315203 2216615250 269742334 0 71146779 233664417";
        String mounts = "/dev/sda /mnt/data/data0";
        Files.write(this.baseDir().toPath().resolve("diskstats"), diskStats.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(this.baseDir().toPath().resolve("mounts"), mounts.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertTrue((boolean)new LinuxDiskMetricsCollector(this.kafkaConfig(), this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying()).usable());
    }

    @Test
    public void testUnableToReadNonexistentProcFile() {
        LinuxDiskMetricsCollector collector = new LinuxDiskMetricsCollector(this.kafkaConfig(), this.baseDir().getAbsolutePath(), this.time(), this.logger().underlying());
        Assertions.assertFalse((boolean)collector.usable());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)collector.devices());
        Assertions.assertEquals((int)0, (int)collector.metrics().length);
    }

    public LinuxDiskMetricsCollectorTest() {
        this.props().put(KafkaConfig$.MODULE$.LogDirsProp(), "/mnt/data/data0/logs/,/mnt/data/data1");
        this.kafkaConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.props();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
        this.kafkaConfig = (KafkaConfig)this.kafkaConfigs().apply(0);
    }
}

