/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import kafka.controller.PartitionSLOMetrics;
import kafka.controller.PartitionSLOMetrics$;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m3AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002B\u0002\u0015\u0001A\u0003%Q\u0004C\u0003*\u0001\u0011%!\u0006C\u0003?\u0001\u0011\u0005q\bC\u0003Q\u0001\u0011\u0005q\bC\u0003V\u0001\u0011\u0005q\bC\u0003X\u0001\u0011\u0005q\bC\u0003Z\u0001\u0011\u0005qHA\fQCJ$\u0018\u000e^5p]Ncu*T3ue&\u001c7\u000fV3ti*\u0011A\"D\u0001\b[\u0016$(/[2t\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\f\u0003=iW\r\u001e:jGN\u0014VmZ5tiJLX#A\u000f\u0011\u0005y1S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001B2pe\u0016T!\u0001\u0004\u0012\u000b\u0005\r\"\u0013AB=b[6,'OC\u0001&\u0003\r\u0019w.\\\u0005\u0003O}\u0011q\"T3ue&\u001c7OU3hSN$(/_\u0001\u0011[\u0016$(/[2t%\u0016<\u0017n\u001d;ss\u0002\n!dZ3u\u001b\u0016$(/[2OC6,7O\u0012:p[J+w-[:uef$\u0012a\u000b\t\u0004YE\u001aT\"A\u0017\u000b\u00059z\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003aM\t!bY8mY\u0016\u001cG/[8o\u0013\t\u0011TFA\u0002TKR\u0004\"\u0001N\u001e\u000f\u0005UJ\u0004C\u0001\u001c\u0014\u001b\u00059$B\u0001\u001d\u0010\u0003\u0019a$o\\8u}%\u0011!hE\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;'\u0005)1/\u001a;vaR\t\u0001\t\u0005\u0002\u0013\u0003&\u0011!i\u0005\u0002\u0005+:LG\u000f\u000b\u0002\u0006\tB\u0011QIT\u0007\u0002\r*\u0011q\tS\u0001\u0004CBL'BA%K\u0003\u001dQW\u000f]5uKJT!a\u0013'\u0002\u000b),h.\u001b;\u000b\u00035\u000b1a\u001c:h\u0013\tyeI\u0001\u0006CK\u001a|'/Z#bG\"\fA\u0004^3tiB\u000b'\u000f^5uS>tW*\u001a;sS\u000e\u001c8I]3bi&|g\u000e\u000b\u0002\u0007%B\u0011QiU\u0005\u0003)\u001a\u0013A\u0001V3ti\u0006\u0011C/Z:u)\u0016t\u0017M\u001c;QCJ$\u0018\u000e^5p]6+GO]5dg\u000e\u0013X-\u0019;j_:D#a\u0002*\u0002EQ,7\u000f\u001e+f]\u0006tG\u000fU1si&$\u0018n\u001c8Bm\u0006LG.\u00192jY&$\u0018p\u00157pQ\tA!+\u0001\u0011uKN$H+\u001a8b]R\u0004\u0016M\u001d;ji&|g.T3ue&\u001c7/\u00169eCR,\u0007FA\u0005S\u0001")
public class PartitionSLOMetricsTest {
    private final MetricsRegistry metricsRegistry = KafkaYammerMetrics.defaultRegistry();

    public MetricsRegistry metricsRegistry() {
        return this.metricsRegistry;
    }

    private Set<String> getMetricNamesFromRegistry() {
        Set names = (Set)Set$.MODULE$.empty();
        this.metricsRegistry().allMetrics().keySet().forEach(p -> names.add((Object)p.getName()));
        return names;
    }

    @BeforeEach
    public void setup() {
        PartitionSLOMetrics$.MODULE$.onControllerChange(0, false, false);
    }

    @Test
    public void testPartitionMetricsCreation() {
        Assertions.assertTrue((boolean)PartitionSLOMetrics$.MODULE$.getPartitionMetricsMap().isEmpty());
        PartitionSLOMetrics$.MODULE$.onControllerChange(0, true, false);
        Assertions.assertEquals((int)PartitionSLOMetrics$.MODULE$.getPartitionMetricsMap().size(), (int)1);
        Set<String> metrics = this.getMetricNamesFromRegistry();
        Assertions.assertTrue((boolean)metrics.contains((Object)PartitionSLOMetrics$.MODULE$.GlobalUnderMinIsrPartitionCountMetric()));
        Assertions.assertTrue((boolean)metrics.contains((Object)PartitionSLOMetrics$.MODULE$.GlobalPartitionCountMetric()));
        Assertions.assertTrue((boolean)metrics.contains((Object)PartitionSLOMetrics$.MODULE$.GlobalOfflinePartitionsCount()));
        Assertions.assertTrue((boolean)metrics.contains((Object)PartitionSLOMetrics$.MODULE$.GlobalPartitionAvailabilityMetric()));
        Assertions.assertFalse((boolean)metrics.contains((Object)PartitionSLOMetrics$.MODULE$.TenantPartitionAvailabilitySLOMetric()));
    }

    @Test
    public void testTenantPartitionMetricsCreation() {
        Assertions.assertTrue((boolean)PartitionSLOMetrics$.MODULE$.getPartitionMetricsMap().isEmpty());
        PartitionSLOMetrics$.MODULE$.onControllerChange(0, true, false);
        Assertions.assertEquals((int)PartitionSLOMetrics$.MODULE$.getPartitionMetricsMap().size(), (int)1);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics("lkc-123_topic", 0, 0, 0);
        Assertions.assertTrue((boolean)PartitionSLOMetrics$.MODULE$.getPartitionMetrics("lkc-123").isEmpty());
        PartitionSLOMetrics$.MODULE$.onControllerChange(0, true, true);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics("lkc-123-topic", 0, 0, 0);
        Assertions.assertTrue((boolean)PartitionSLOMetrics$.MODULE$.getPartitionMetrics("lkc-123").isEmpty());
        Assertions.assertFalse((boolean)this.getMetricNamesFromRegistry().contains((Object)PartitionSLOMetrics$.MODULE$.TenantPartitionAvailabilitySLOMetric()));
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics("lkc_123", 0, 0, 0);
        Assertions.assertTrue((boolean)PartitionSLOMetrics$.MODULE$.getPartitionMetrics("lkc_123").isEmpty());
        Assertions.assertFalse((boolean)this.getMetricNamesFromRegistry().contains((Object)PartitionSLOMetrics$.MODULE$.TenantPartitionAvailabilitySLOMetric()));
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics("lkc-123_topic", 0, 0, 0);
        Assertions.assertTrue((!PartitionSLOMetrics$.MODULE$.getPartitionMetrics("lkc-123").isEmpty() ? 1 : 0) != 0);
        Assertions.assertEquals((int)PartitionSLOMetrics$.MODULE$.getPartitionMetricsMap().size(), (int)2);
        Assertions.assertTrue((boolean)this.getMetricNamesFromRegistry().contains((Object)PartitionSLOMetrics$.MODULE$.TenantPartitionAvailabilitySLOMetric()));
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics("lkc-123_topic", 2, 0, 0);
        Assertions.assertTrue((!PartitionSLOMetrics$.MODULE$.getPartitionMetrics("lkc-123").isEmpty() ? 1 : 0) != 0);
        Assertions.assertEquals((int)PartitionSLOMetrics$.MODULE$.getPartitionMetricsMap().size(), (int)2);
        Assertions.assertTrue((boolean)this.getMetricNamesFromRegistry().contains((Object)PartitionSLOMetrics$.MODULE$.TenantPartitionAvailabilitySLOMetric()));
    }

    @Test
    public void testTenantPartitionAvailabilitySlo() {
        String tenant = "lkc-9pzxv0";
        String topic = "lkc-9pzxv0__confluent-kafka-rbac-healthcheck_09";
        Assertions.assertTrue((boolean)PartitionSLOMetrics$.MODULE$.getPartitionMetricsMap().isEmpty());
        PartitionSLOMetrics$.MODULE$.onControllerChange(0, true, true);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics(topic, 0, 0, 0);
        Assertions.assertTrue((boolean)this.getMetricNamesFromRegistry().contains((Object)PartitionSLOMetrics$.MODULE$.TenantPartitionAvailabilitySLOMetric()));
        Assertions.assertTrue((!PartitionSLOMetrics$.MODULE$.getPartitionMetrics(tenant).isEmpty() ? 1 : 0) != 0);
        double slo = ((PartitionSLOMetrics)PartitionSLOMetrics$.MODULE$.getPartitionMetrics(tenant).get()).getPartitionAvailabilitySLO();
        Assertions.assertEquals((double)1.0, (double)slo);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics(topic, 10, 0, 0);
        slo = ((PartitionSLOMetrics)PartitionSLOMetrics$.MODULE$.getPartitionMetrics(tenant).get()).getPartitionAvailabilitySLO();
        Assertions.assertEquals((double)1.0, (double)slo);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics(topic, 10, 1, 0);
        slo = ((PartitionSLOMetrics)PartitionSLOMetrics$.MODULE$.getPartitionMetrics(tenant).get()).getPartitionAvailabilitySLO();
        Assertions.assertEquals((double)0.9, (double)slo);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics(topic, 10, 0, 1);
        slo = ((PartitionSLOMetrics)PartitionSLOMetrics$.MODULE$.getPartitionMetrics(tenant).get()).getPartitionAvailabilitySLO();
        Assertions.assertEquals((double)0.9, (double)slo);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics(topic, 10, 1, 1);
        slo = ((PartitionSLOMetrics)PartitionSLOMetrics$.MODULE$.getPartitionMetrics(tenant).get()).getPartitionAvailabilitySLO();
        Assertions.assertEquals((double)0.8, (double)slo);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionMetrics(topic, 10, 0, 0);
        slo = ((PartitionSLOMetrics)PartitionSLOMetrics$.MODULE$.getPartitionMetrics(tenant).get()).getPartitionAvailabilitySLO();
        Assertions.assertEquals((double)1.0, (double)slo);
    }

    @Test
    public void testTenantPartitionMetricsUpdate() {
        String tenant = "lkc-123";
        String topic = new StringBuilder(11).append(tenant).append("_test_topic").toString();
        Assertions.assertTrue((boolean)PartitionSLOMetrics$.MODULE$.getPartitionMetricsMap().isEmpty());
        PartitionSLOMetrics$.MODULE$.onControllerChange(0, true, true);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionCount(topic, 1);
        PartitionSLOMetrics tm = (PartitionSLOMetrics)PartitionSLOMetrics$.MODULE$.getPartitionMetrics(tenant).get();
        Assertions.assertEquals((int)tm.getTotalPartitionCount(), (int)1);
        Assertions.assertTrue((boolean)this.getMetricNamesFromRegistry().contains((Object)PartitionSLOMetrics$.MODULE$.TenantPartitionAvailabilitySLOMetric()));
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionCount(topic, 1);
        Assertions.assertEquals((int)tm.getTotalPartitionCount(), (int)2);
        PartitionSLOMetrics$.MODULE$.updateTenantOfflinePartitionCount(topic, 1);
        Assertions.assertEquals((int)tm.getOfflinePartitionCount(), (int)1);
        PartitionSLOMetrics$.MODULE$.updateTenantOfflinePartitionCount(topic, -1);
        Assertions.assertEquals((int)tm.getOfflinePartitionCount(), (int)0);
        PartitionSLOMetrics$.MODULE$.updateTenantUnderMinIsrCount(topic, 1);
        Assertions.assertEquals((int)tm.getUnderMinIsrCount(), (int)1);
        PartitionSLOMetrics$.MODULE$.updateTenantUnderMinIsrCount(topic, -1);
        Assertions.assertEquals((int)tm.getUnderMinIsrCount(), (int)0);
        PartitionSLOMetrics$.MODULE$.updateTenantPartitionCount(topic, -2);
        Assertions.assertEquals((int)tm.getTotalPartitionCount(), (int)0);
    }
}

