/*
 * Decompiled with CFR 0.152.
 */
package kafka.migration;

import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.migration.MigrationTierTopicProducer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Tag(value="bazel:shard_count:2")
@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013%Q\u0005\u0003\u00044\u0001\u0001\u0006IA\n\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019q\u0004\u0001)A\u0005m!Iq\b\u0001a\u0001\u0002\u0004%I\u0001\u0011\u0005\n\r\u0002\u0001\r\u00111A\u0005\n\u001dC\u0011\"\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B!\t\u00139\u0003\u0001\u0019!a\u0001\n\u0013y\u0005\"C*\u0001\u0001\u0004\u0005\r\u0011\"\u0003U\u0011%1\u0006\u00011A\u0001B\u0003&\u0001\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0003e\u0001\u0011\u0005\u0001\fC\u0003j\u0001\u0011\u0005\u0001\fC\u0003o\u0001\u0011\u0005\u0001\fC\u0003q\u0001\u0011%\u0011\u000fC\u0004\u0002\u001a\u0001!I!a\u0007\t\r\u0005\r\u0002\u0001\"\u0003Y\u0005yi\u0015n\u001a:bi&|g\u000eV5feR{\u0007/[2Qe>$WoY3s)\u0016\u001cHO\u0003\u0002\u0016-\u0005IQ.[4sCRLwN\u001c\u0006\u0002/\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011\u0001F\u0001\u0005i&lW-F\u0001'!\t9\u0013'D\u0001)\u0015\tI#&\u0001\u0003vi&d'BA\u0016-\u0003\u0019\u0019XM\u001d<fe*\u0011q#\f\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014x-\u0003\u00023Q\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0005dYV\u001cH/\u001a:JIV\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!A.\u00198h\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001d\u0003\rM#(/\u001b8h\u0003)\u0019G.^:uKJLE\rI\u0001\u0007G>tg-[4\u0016\u0003\u0005\u0003\"A\u0011#\u000e\u0003\rS!a\u000b\f\n\u0005\u0015\u001b%aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\tA5\n\u0005\u0002\u001c\u0013&\u0011!\n\b\u0002\u0005+:LG\u000fC\u0004M\u000f\u0005\u0005\t\u0019A!\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u000255LwM]1uS>tG+[3s)>\u0004\u0018n\u0019)s_\u0012,8-\u001a:\u0016\u0003A\u0003\"aI)\n\u0005I#\"AG'jOJ\fG/[8o)&,'\u000fV8qS\u000e\u0004&o\u001c3vG\u0016\u0014\u0018AH7jOJ\fG/[8o)&,'\u000fV8qS\u000e\u0004&o\u001c3vG\u0016\u0014x\fJ3r)\tAU\u000bC\u0004M\u0015\u0005\u0005\t\u0019\u0001)\u000275LwM]1uS>tG+[3s)>\u0004\u0018n\u0019)s_\u0012,8-\u001a:!\u0003\u0015\u0019X\r^+q)\u0005A\u0005F\u0001\u0007[!\tY&-D\u0001]\u0015\tif,A\u0002ba&T!a\u00181\u0002\u000f),\b/\u001b;fe*\u0011\u0011mL\u0001\u0006UVt\u0017\u000e^\u0005\u0003Gr\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007FA\u0007g!\tYv-\u0003\u0002i9\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001.i\u0016\u001cH/\u00138ji&\fG.\u001b>f\u0003:$\u0017+^3vKB\u000b'\u000f^5uS>tG)\u001a7fi\u0016Le.\u001b;jCR,\u0007F\u0001\bl!\tYF.\u0003\u0002n9\n!A+Z:u\u0003A!Xm\u001d;Q_2dG)\u001e:bi&|g\u000e\u000b\u0002\u0010W\u0006)\"M]8lKJ\u001cHk\\\"mkN$XM]%nC\u001e,GC\u0001:y!\t\u0019h/D\u0001u\u0015\t)H&A\u0003j[\u0006<W-\u0003\u0002xi\na1\t\\;ti\u0016\u0014\u0018*\\1hK\")\u0011\u0010\u0005a\u0001u\u00069!M]8lKJ\u001c\b#B>\u0002\b\u00055ab\u0001?\u0002\u00049\u0019Q0!\u0001\u000e\u0003yT!a \r\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012bAA\u00039\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0005\u0003\u0017\u00111aU3r\u0015\r\t)\u0001\b\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u0017\u0002\u00115,G/\u00193bi\u0006LA!a\u0006\u0002\u0012\t\u0011\"I]8lKJ\u0014VmZ5tiJ\fG/[8o\u0003I\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0015\u0005\u0005u\u0001cA:\u0002 %\u0019\u0011\u0011\u0005;\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u000391XM]5gsNCW\u000f\u001e3po:Ds\u0001AA\u0014\u0003[\ty\u0003E\u0002\\\u0003SI1!a\u000b]\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003c\t1CY1{K2T4\u000f[1sI~\u001bw.\u001e8uuI\u0002")
public class MigrationTierTopicProducerTest {
    private final MockTime time = TestUtils$.MODULE$.defaultMockTime();
    private final String clusterId;
    private KafkaConfig config;
    private MigrationTierTopicProducer migrationTierTopicProducer;

    private MockTime time() {
        return this.time;
    }

    private String clusterId() {
        return this.clusterId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private MigrationTierTopicProducer migrationTierTopicProducer() {
        return this.migrationTierTopicProducer;
    }

    private void migrationTierTopicProducer_$eq(MigrationTierTopicProducer x$1) {
        this.migrationTierTopicProducer = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.migrationTierTopicProducer_$eq(new MigrationTierTopicProducer(this.config(), this.clusterId(), (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        if (this.migrationTierTopicProducer() != null && !this.migrationTierTopicProducer().isShutdown() && this.migrationTierTopicProducer().isStarted()) {
            this.migrationTierTopicProducer().shutdown();
            return;
        }
    }

    @Test
    public void testInitializeAndQueuePartitionDeleteInitiate() {
        MetadataImage metadataImage = this.buildMetadataImage();
        Assertions.assertFalse((boolean)this.migrationTierTopicProducer().isInitialized());
        this.migrationTierTopicProducer().initialize(metadataImage);
        Assertions.assertEquals((int)2, (int)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MigrationTierTopicProducerTest.$anonfun$testInitializeAndQueuePartitionDeleteInitiate$1(this, x$3))));
        Assertions.assertTrue((boolean)this.migrationTierTopicProducer().isInitialized());
        this.migrationTierTopicProducer().queuePartitionDeleteInitiate("test", Uuid.randomUuid(), 0, 1);
        Assertions.assertEquals((int)1, (int)this.migrationTierTopicProducer().queuedMetadataCount());
        this.migrationTierTopicProducer().start();
        Assertions.assertTrue((boolean)this.migrationTierTopicProducer().isStarted());
        this.verifyShutdown();
    }

    @Test
    public void testPollDuration() {
        MetadataImage metadataImage = this.buildMetadataImage();
        Assertions.assertFalse((boolean)this.migrationTierTopicProducer().isInitialized());
        this.migrationTierTopicProducer().initialize(metadataImage);
        Assertions.assertTrue((boolean)this.migrationTierTopicProducer().isInitialized());
        long timeBefore = System.currentTimeMillis();
        this.migrationTierTopicProducer().doWork();
        Assertions.assertTrue((System.currentTimeMillis() - timeBefore >= this.migrationTierTopicProducer().MAX_POLL_TIMEOUT_MS() ? 1 : 0) != 0);
        this.verifyShutdown();
    }

    private ClusterImage brokersToClusterImage(Seq<BrokerRegistration> brokers) {
        java.util.Map brokerMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)brokers.map((Function1 & Serializable)broker -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker.id()), broker))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        return new ClusterImage(brokerMap, Collections.emptyMap());
    }

    private MetadataImage buildMetadataImage() {
        BrokerRegistration brokerRegistration = BrokerRegistration.fromRecord((RegisterBrokerRecord)new RegisterBrokerRecord().setBrokerId(0).setIsMigratingZkBroker(true).setBrokerEpoch(1L).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort((int)((short)9092)).setName("PLAINTEXT").setHost("192.163.1.1")).iterator())));
        BrokerRegistration brokerRegistration2 = BrokerRegistration.fromRecord((RegisterBrokerRecord)new RegisterBrokerRecord().setBrokerId(1).setIsMigratingZkBroker(true).setBrokerEpoch(1L).setEndPoints(new RegisterBrokerRecord.BrokerEndpointCollection(Collections.singleton(new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort((int)((short)9092)).setName("PLAINTEXT").setHost("192.163.1.2")).iterator())));
        ClusterImage clusterImage = this.brokersToClusterImage((Seq<BrokerRegistration>)new .colon.colon((Object)brokerRegistration, (List)new .colon.colon((Object)brokerRegistration2, (List)Nil$.MODULE$)));
        return new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, clusterImage, TopicsImage.EMPTY, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
    }

    private void verifyShutdown() {
        this.migrationTierTopicProducer().shutdown();
        Assertions.assertFalse((boolean)this.migrationTierTopicProducer().isInitialized());
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MigrationTierTopicProducerTest.$anonfun$verifyShutdown$1(this, x$4))));
    }

    public static final /* synthetic */ boolean $anonfun$testInitializeAndQueuePartitionDeleteInitiate$1(MigrationTierTopicProducerTest $this, MetricName x$3) {
        String string = x$3.getType();
        String string2 = $this.migrationTierTopicProducer().getClass().getSimpleName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyShutdown$1(MigrationTierTopicProducerTest $this, MetricName x$4) {
        String string = x$4.getType();
        String string2 = $this.migrationTierTopicProducer().getClass().getSimpleName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public MigrationTierTopicProducerTest() {
        this.clusterId = "test-cluster";
    }
}

