/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.SocketServer$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ProcessorQueueSizePercentiles$;
import kafka.server.QueueSizePercentiles;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=f\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YB\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0013A\u0005\"\u0003(\u0001\u0001\u0004\u0005\t\u0015)\u0003<\u0011%y\u0005\u00011AA\u0002\u0013%\u0001\u000bC\u0005U\u0001\u0001\u0007\t\u0019!C\u0005+\"Iq\u000b\u0001a\u0001\u0002\u0003\u0006K!\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019\u0011\u0007\u0001)A\u00055\"91\r\u0001b\u0001\n\u0013!\u0007B\u0002=\u0001A\u0003%Q\rC\u0005z\u0001\u0001\u0007\t\u0019!C\u0005u\"Qq\u0010\u0001a\u0001\u0002\u0004%I!!\u0001\t\u0015\u0005\u0015\u0001\u00011A\u0001B\u0003&1\u0010C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011\u0011\u0003\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011Q\u0003\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a!9\u00111\u0004\u0001!\u0002\u0013Y\u0007\"CA\u000f\u0001\t\u0007I\u0011BA\r\u0011\u001d\ty\u0002\u0001Q\u0001\n-D\u0011\"!\t\u0001\u0005\u0004%I!!\u0007\t\u000f\u0005\r\u0002\u0001)A\u0005W\"I\u0011Q\u0005\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002*!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA&\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003+\u0002A\u0011AA,\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!a\u001b\u0001\t\u0003\t\u0019\u0004C\u0004\u0002v\u0001!\t!a\r\t\u000f\u0005e\u0004\u0001\"\u0001\u00024!9\u0011Q\u0010\u0001\u0005\u0002\u0005M\u0002bBAA\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u000b\u0003A\u0011AA\u001a\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!&\u0001\t\u0013\t9\nC\u0004\u0002 \u0002!I!!)\u0003;\r{gN\u001a7vK:$8i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d+fgRT!AK\u0016\u0002\u000f9,Go^8sW*\tA&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002oA\u0011\u0001\bA\u0007\u0002S\u00059Q.\u001a;sS\u000e\u001cX#A\u001e\u0011\u0005q*U\"A\u001f\u000b\u0005er$BA A\u0003\u0019\u0019w.\\7p]*\u0011A&\u0011\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G{\t9Q*\u001a;sS\u000e\u001c\u0018aC7fiJL7m]0%KF$\"!\u0013'\u0011\u0005AR\u0015BA&2\u0005\u0011)f.\u001b;\t\u000f5\u001b\u0011\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\u0002\u00115,GO]5dg\u0002\n\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0016\u0003E\u0003\"\u0001\u000f*\n\u0005MK#\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003Q\u0019wN\u001c8fGRLwN\\)v_R\f7o\u0018\u0013fcR\u0011\u0011J\u0016\u0005\b\u001b\u001a\t\t\u00111\u0001R\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u0005i&lW-F\u0001[!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0003vi&d'BA0A\u0003\u0019\u0019XM\u001d<fe&\u0011\u0011\r\u0018\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005IA.[:uK:,'o]\u000b\u0002KB!a-[6t\u001b\u00059'B\u000152\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003U\u001e\u00141!T1q!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0003mC:<'\"\u00019\u0002\t)\fg/Y\u0005\u0003e6\u0014aa\u0015;sS:<\u0007C\u0001;w\u001b\u0005)(B\u0001\u0016?\u0013\t9XO\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\u0006mSN$XM\\3sg\u0002\n\u0001\u0004\\5ti\u0016tWM])vKV,7+\u001b>f'\u0016t7o\u001c:t+\u0005Y\b\u0003\u00024jgr\u0004\"\u0001P?\n\u0005yl$AB*f]N|'/\u0001\u000fmSN$XM\\3s#V,W/Z*ju\u0016\u001cVM\\:peN|F%Z9\u0015\u0007%\u000b\u0019\u0001C\u0004N\u001b\u0005\u0005\t\u0019A>\u000231L7\u000f^3oKJ\fV/Z;f'&TXmU3og>\u00148\u000fI\u0001\u001eI\u00164\u0017-\u001e7u\u0007>tg.Z2uS>t7I]3bi&|gNU1uKV\u0011\u00111\u0002\t\u0004a\u00055\u0011bAA\bc\t\u0019\u0011J\u001c;\u0002=\u0011,g-Y;mi\u000e{gN\\3di&|gn\u0011:fCRLwN\u001c*bi\u0016\u0004\u0013!H2p]:,7\r^5p]J\u000bG/Z)v_R\f\u0017\t\u001a6vgRlWM\u001c;\u0002=\r|gN\\3di&|gNU1uKF+x\u000e^1BI*,8\u000f^7f]R\u0004\u0013!G3yi\u0016\u0014h.\u00197MSN$XM\\3s\u0019&l\u0017\u000e\u001e)s_B,\u0012a[\u0001\u001bKb$XM\u001d8bY2K7\u000f^3oKJd\u0015.\\5u!J|\u0007\u000fI\u0001\u001aKb$XM\u001d8bY2K7\u000f^3oKJ4En\\8s!J|\u0007/\u0001\u000efqR,'O\\1m\u0019&\u001cH/\u001a8fe\u001acwn\u001c:Qe>\u0004\b%\u0001\u000fsKBd\u0017nY1uS>tG*[:uK:,'O\u00127p_J\u0004&o\u001c9\u0002;I,\u0007\u000f\\5dCRLwN\u001c'jgR,g.\u001a:GY>|'\u000f\u0015:pa\u0002\n!c]1na2,W\t\u001f9je\u0006$\u0018n\u001c8NgV\u0011\u0011\u0011\u0006\t\u0004a\u0005-\u0012bAA\u0017c\t!Aj\u001c8h\u0003M\u0019\u0018-\u001c9mK\u0016C\b/\u001b:bi&|g.T:!\u0003\u0015\u0019X\r^+q)\u0005I\u0005fA\u000e\u00028A!\u0011\u0011HA$\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012aA1qS*!\u0011\u0011IA\"\u0003\u001dQW\u000f]5uKJT1!!\u0012D\u0003\u0015QWO\\5u\u0013\u0011\tI%a\u000f\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\ra\u0012q\n\t\u0005\u0003s\t\t&\u0003\u0003\u0002T\u0005m\"!C!gi\u0016\u0014X)Y2i\u0003)\u0012'o\\6feB\u0013x\u000e]:XSRDW\t\u001f;fe:\fGnQ8o]\u0016\u001cG/[8o%\u0006$X\rT5nSR,\"!!\u0017\u0011\t\u0005m\u0013qL\u0007\u0003\u0003;R!!X8\n\t\u0005\u0005\u0014Q\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018AF2sK\u0006$XmQ8o]\u0016\u001cG/[8o#V|G/Y:\u0015\u0007%\u000b9\u0007C\u0004\u0002jy\u0001\r!!\u0017\u0002\u000bA\u0014x\u000e]:\u0002_Q,7\u000f^+oG>tg-[4ve\u0016$G*[:uK:,'oQ8o]\u0016\u001cG/[8o%\u0006$XM\u00127p_J\u0004&o\u001c9)\u0007}\ty\u0007\u0005\u0003\u0002:\u0005E\u0014\u0002BA:\u0003w\u0011A\u0001V3ti\u0006AC/Z:u\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|gNU1uKR+h.\u001b8h\t&\u001c\u0018M\u00197fI\"\u001a\u0001%a\u001c\u0002QQ,7\u000f\u001e*fIV\u001cW\rT5ti\u0016tWM])v_R\fw+\u001b;i\u0011&<\u0007.U;fk\u0016\u001c\u0016N_3)\u0007\u0005\ny'A\u0015uKN$\u0018J\\2sK\u0006\u001cX\rT5ti\u0016tWM])v_R\fw+\u001b;i\u0019><\u0018+^3vKNK'0\u001a\u0015\u0004E\u0005=\u0014A\u000b;fgR\u0014VmY8oM&<WO]3MSN$XM\\3s\u0007>tg.Z2uS>t'+\u0019;f\r2|wN\u001d\u0015\u0004G\u0005=\u0014\u0001\u000b;fgR\u0014VmY8oM&<WO]3MSN$XM\\3s\u001b\u0006D8i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0007f\u0001\u0013\u0002p\u0005A\"/Z2pe\u0012\u0004&o\\2fgN|'/U;fk\u0016\u001c\u0016N_3\u0015\u000b%\u000bi)!%\t\r\u0005=U\u00051\u0001t\u0003!a\u0017n\u001d;f]\u0016\u0014\bbBAJK\u0001\u0007\u00111B\u0001\u0006m\u0006dW/Z\u0001\u0019e\u0016\u001cwN\u001c4jOV\u0014X\rT5ti\u0016tWM])v_R\fGcB%\u0002\u001a\u0006m\u0015Q\u0014\u0005\u0006\u001f\u001a\u0002\r!\u0015\u0005\b\u0003S2\u0003\u0019AA-\u0011\u0019\tyI\na\u0001g\u0006\tc/\u001a:jMfd\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0017+^8uCR)\u0011*a)\u0002&\"1\u0011qR\u0014A\u0002MDq!a*(\u0001\u0004\tI+\u0001\nfqB,7\r^3e#V|G/\u0019'j[&$\bc\u0001\u0019\u0002,&\u0019\u0011QV\u0019\u0003\r\u0011{WO\u00197f\u0001")
public class ConfluentConnectionQuotasTest {
    private Metrics metrics;
    private ConnectionQuotas connectionQuotas;
    private final MockTime time = new MockTime();
    private final Map<String, ListenerName> listeners = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EXTERNAL"), (Object)new ListenerName("EXTERNAL")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"REPLICATION"), (Object)new ListenerName("REPLICATION"))}));
    private Map<ListenerName, Sensor> listenerQueueSizeSensors;
    private final int defaultConnectionCreationRate;
    private final int connectionRateQuotaAdjustment;
    private final String externalListenerLimitProp = new StringBuilder(0).append(((ListenerName)this.listeners().apply((Object)"EXTERNAL")).configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
    private final String externalListenerFloorProp = new StringBuilder(0).append(((ListenerName)this.listeners().apply((Object)"EXTERNAL")).configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp()).toString();
    private final String replicationListenerFloorProp = new StringBuilder(0).append(((ListenerName)this.listeners().apply((Object)"REPLICATION")).configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp()).toString();
    private final long sampleExpirationMs = TimeUnit.MINUTES.toMillis(1L);

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    private Map<String, ListenerName> listeners() {
        return this.listeners;
    }

    private Map<ListenerName, Sensor> listenerQueueSizeSensors() {
        return this.listenerQueueSizeSensors;
    }

    private void listenerQueueSizeSensors_$eq(Map<ListenerName, Sensor> x$1) {
        this.listenerQueueSizeSensors = x$1;
    }

    private int defaultConnectionCreationRate() {
        return this.defaultConnectionCreationRate;
    }

    private int connectionRateQuotaAdjustment() {
        return this.connectionRateQuotaAdjustment;
    }

    private String externalListenerLimitProp() {
        return this.externalListenerLimitProp;
    }

    private String externalListenerFloorProp() {
        return this.externalListenerFloorProp;
    }

    private String replicationListenerFloorProp() {
        return this.replicationListenerFloorProp;
    }

    private long sampleExpirationMs() {
        return this.sampleExpirationMs;
    }

    @BeforeEach
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.metrics_$eq(new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time()));
        this.listenerQueueSizeSensors_$eq((Map<ListenerName, Sensor>)((IterableOnceOps)this.listeners().values().map((Function1 & Serializable)listener -> {
            void add_stat;
            void createPercentiles_tags;
            void createPercentiles_metricNamePrefix;
            void createPercentiles_queueSize;
            void createPercentiles_metrics;
            Sensor sensor = this.metrics().sensor(new StringBuilder(19).append("ProcessorQueueSize-").append(listener.value()).toString());
            Map map = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener"), (Object)listener.value())}));
            String string = "";
            int n = Processor$.MODULE$.ConnectionQueueSize();
            Metrics metrics = this.metrics();
            ProcessorQueueSizePercentiles$ createPercentiles_this = ProcessorQueueSizePercentiles$.MODULE$;
            Object var3_7 = null;
            metrics = null;
            string = null;
            map = null;
            Percentiles percentiles = QueueSizePercentiles.createPercentiles$((QueueSizePercentiles)createPercentiles_this, (Metrics)createPercentiles_metrics, (int)createPercentiles_queueSize, (String)createPercentiles_metricNamePrefix, (Map)createPercentiles_tags);
            if (sensor == null) {
                throw null;
            }
            sensor.add((CompoundStat)add_stat, null);
            percentiles = null;
            return new Tuple2(listener, (Object)sensor);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @AfterEach
    public void tearDown() {
        if (this.connectionQuotas() != null) {
            this.connectionQuotas().close();
        }
        this.metrics().close();
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    public Properties brokerPropsWithExternalConnectionRateLimit() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var21_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var22_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var23_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 0, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:0,REPLICATION://localhost:1");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), Integer.toString(2));
        props.put(KafkaConfig$.MODULE$.NumThroughputQuotaSamplesProp(), Integer.toString(2));
        props.put(KafkaConfig$.MODULE$.QuotaWindowSizeSecondsProp(), Integer.toString(1));
        props.put(new StringBuilder(0).append(((ListenerName)this.listeners().apply((Object)"EXTERNAL")).configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), Integer.toString(this.defaultConnectionCreationRate()));
        return props;
    }

    private void createConnectionQuotas(Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, (Time)this.time(), this.metrics()));
        this.listeners().values().foreach((Function1 & Serializable)x$4 -> {
            ConfluentConnectionQuotasTest.$anonfun$createConnectionQuotas$1(this, config, x$4);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUnconfiguredListenerConnectionRateFloorProp() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        ListenerName replicationListener = (ListenerName)this.listeners().apply((Object)"REPLICATION");
        this.createConnectionQuotas(this.brokerPropsWithExternalConnectionRateLimit());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.recordProcessorQueueSize(externalListener, 16);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(replicationListener);
        this.verifyListenerConnectionRateQuota(replicationListener, Defaults$.MODULE$.MaxConnectionCreationRate());
        this.recordProcessorQueueSize(replicationListener, 16);
        this.verifyListenerConnectionRateQuota(replicationListener, Defaults$.MODULE$.MaxConnectionCreationRate());
    }

    @Test
    public void testListenerConnectionRateTuningDisabled() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        ListenerName replicationListener = (ListenerName)this.listeners().apply((Object)"REPLICATION");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int replicationConnectionRateFloor = this.defaultConnectionCreationRate() + 5;
        props.put(this.externalListenerFloorProp(), Integer.toString(this.defaultConnectionCreationRate()));
        props.put(new StringBuilder(0).append(replicationListener.configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), Integer.toString(this.defaultConnectionCreationRate()));
        props.put(this.replicationListenerFloorProp(), Integer.toString(replicationConnectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.recordProcessorQueueSize(replicationListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(replicationListener);
        this.verifyListenerConnectionRateQuota(replicationListener, this.defaultConnectionCreationRate());
    }

    @Test
    public void testReduceListenerQuotaWithHighQueueSize() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        ListenerName replicationListener = (ListenerName)this.listeners().apply((Object)"REPLICATION");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int connectionRateFloor = 30;
        props.put(this.externalListenerFloorProp(), Integer.toString(connectionRateFloor));
        props.put(new StringBuilder(0).append(replicationListener.configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), Integer.toString(this.defaultConnectionCreationRate()));
        props.put(this.replicationListenerFloorProp(), Integer.toString(connectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.connectionQuotas().maybeAdjustListenerQuota(replicationListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
        this.verifyListenerConnectionRateQuota(replicationListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, connectionRateFloor);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, connectionRateFloor);
    }

    @Test
    public void testIncreaseListenerQuotaWithLowQueueSize() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int connectionRateFloor = 30;
        props.put(this.externalListenerFloorProp(), Integer.toString(connectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
        this.time().sleep(this.sampleExpirationMs());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
    }

    @Test
    public void testReconfigureListenerConnectionRateFloor() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int connectionRateFloor = 30;
        props.put(this.externalListenerFloorProp(), Integer.toString(connectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, connectionRateFloor);
        int reducedFloor = 25;
        props.put(this.externalListenerFloorProp(), Integer.toString(reducedFloor));
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, connectionRateFloor);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, reducedFloor);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> this.connectionQuotas().maybeAdjustListenerQuota(externalListener));
        this.verifyListenerConnectionRateQuota(externalListener, reducedFloor);
        int increasedFloor = 32;
        props.put(this.externalListenerFloorProp(), Integer.toString(increasedFloor));
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, increasedFloor);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, increasedFloor);
        this.time().sleep(this.sampleExpirationMs());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, increasedFloor + this.connectionRateQuotaAdjustment());
        props.remove(this.externalListenerFloorProp());
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
    }

    @Test
    public void testReconfigureListenerMaxConnectionRate() {
        ListenerName externalListener = (ListenerName)this.listeners().apply((Object)"EXTERNAL");
        Properties props = this.brokerPropsWithExternalConnectionRateLimit();
        int connectionRateFloor = 30;
        int newRateLimit = 45;
        props.put(this.externalListenerFloorProp(), Integer.toString(connectionRateFloor));
        this.createConnectionQuotas(props);
        this.recordProcessorQueueSize(externalListener, 16);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
        props.put(this.externalListenerLimitProp(), Integer.toString(newRateLimit));
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, newRateLimit);
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, newRateLimit - this.connectionRateQuotaAdjustment());
        props.put(this.externalListenerLimitProp(), Integer.toString(this.defaultConnectionCreationRate()));
        this.reconfigureListenerQuota(this.connectionQuotas(), props, externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate());
        this.connectionQuotas().maybeAdjustListenerQuota(externalListener);
        this.verifyListenerConnectionRateQuota(externalListener, this.defaultConnectionCreationRate() - this.connectionRateQuotaAdjustment());
    }

    private void recordProcessorQueueSize(ListenerName listener, int value) {
        ((Sensor)this.listenerQueueSizeSensors().apply((Object)listener)).record((double)value);
    }

    private void reconfigureListenerQuota(ConnectionQuotas connectionQuotas, Properties props, ListenerName listener) {
        java.util.Map listenerConfig = KafkaConfig$.MODULE$.fromProps(props).valuesWithPrefixOverride(listener.configPrefix());
        ((ConnectionQuotas.ListenerConnectionQuota)connectionQuotas.maxConnectionsPerListener().apply((Object)listener)).reconfigure(listenerConfig);
    }

    private void verifyListenerConnectionRateQuota(ListenerName listener, double expectedQuotaLimit) {
        KafkaMetric rateMetric = this.metrics().metric(this.metrics().metricName("connection-tokens", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener.value())));
        Assertions.assertEquals((double)expectedQuotaLimit, (double)rateMetric.config().quota().bound(), (double)0.01);
        KafkaMetric rateLimitMetric = this.metrics().metric(this.metrics().metricName("connection-accept-limit", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener.value())));
        Assertions.assertEquals((double)expectedQuotaLimit, (double)BoxesRunTime.unboxToDouble((Object)rateLimitMetric.metricValue()), (double)0.01);
    }

    public static final /* synthetic */ void $anonfun$createConnectionQuotas$1(ConfluentConnectionQuotasTest $this, KafkaConfig config$1, ListenerName x$4) {
        $this.connectionQuotas().addListener(config$1, x$4);
    }

    public ConfluentConnectionQuotasTest() {
        this.defaultConnectionCreationRate = 40;
        this.connectionRateQuotaAdjustment = 5;
    }
}

