/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004:\u0001\u0001\u0006Ia\r\u0005\bu\u0001\u0011\r\u0011\"\u00033\u0011\u0019Y\u0004\u0001)A\u0005g!9A\b\u0001b\u0001\n\u0013\u0011\u0004BB\u001f\u0001A\u0003%1\u0007C\u0004?\u0001\t\u0007I\u0011\u0002\u001a\t\r}\u0002\u0001\u0015!\u00034\u0011\u001d\u0001\u0005A1A\u0005\nIBa!\u0011\u0001!\u0002\u0013\u0019\u0004b\u0002\"\u0001\u0005\u0004%IA\r\u0005\u0007\u0007\u0002\u0001\u000b\u0011B\u001a\t\u000b\u0011\u0003A\u0011K#\t\u0013M\u0003\u0001\u0019!a\u0001\n\u0013!\u0006\"C4\u0001\u0001\u0004\u0005\r\u0011\"\u0003i\u0011%Y\u0007\u00011A\u0001B\u0003&Q\u000bC\u0004m\u0001\t\u0007I\u0011B7\t\rq\u0004\u0001\u0015!\u0003o\u0011\u001di\bA1A\u0005\nIBaA \u0001!\u0002\u0013\u0019\u0004\u0002C@\u0001\u0005\u0004%\t\"!\u0001\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u0007Aq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!9\u00111\n\u0001\u0005\u0012\u00055\u0003\"CA9\u0001E\u0005I\u0011CA:\u0011%\tI\tAI\u0001\n#\t\u0019\bC\u0004\u0002\f\u0002!\t\"!$\t\u000f\u0005E\u0005\u0001\"\u0001\u0002B\t!2i\u001c8oK\u000e$\u0018n\u001c8NCb\fu-\u001a+fgRT!AI\u0012\u0002\u000f9,Go^8sW*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016$\u0003\r\t\u0007/[\u0005\u0003Y%\u0012A#\u00112tiJ\f7\r^\"p]N,X.\u001a:UKN$\u0018A\u0002\u001fj]&$h\bF\u00010!\t\u0001\u0004!D\u0001\"\u0003Y!Xm\u001d;D_:tWm\u0019;j_:l\u0015\r_!hK6\u001bX#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u0007%sG/A\fuKN$8i\u001c8oK\u000e$\u0018n\u001c8NCb\fu-Z'tA\u00059B/Z:u\u0007>tg.Z2uS>tW*\u0019=JI2,Wj]\u0001\u0019i\u0016\u001cHoQ8o]\u0016\u001cG/[8o\u001b\u0006D\u0018\n\u001a7f\u001bN\u0004\u0013!\t;fgR\u001cuN\u001c8fGRLwN\\'j]\u0016C\b/\u001b:f\u0013:$XM\u001d<bY6\u001b\u0018A\t;fgR\u001cuN\u001c8fGRLwN\\'j]\u0016C\b/\u001b:f\u0013:$XM\u001d<bY6\u001b\b%A\u0007uKN$Hj\\8q\u0007>,h\u000e^\u0001\u000fi\u0016\u001cH\u000fT8pa\u000e{WO\u001c;!\u0003Q!Xm\u001d;SKF,Xm\u001d;US6,w.\u001e;Ng\u0006)B/Z:u%\u0016\fX/Z:u)&lWm\\;u\u001bN\u0004\u0013!\u0006;fgR$U\r\\5wKJLH+[7f_V$Xj]\u0001\u0017i\u0016\u001cH\u000fR3mSZ,'/\u001f+j[\u0016|W\u000f^'tA\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003\r&\u0003\"\u0001N$\n\u0005!+$\u0001B+oSRDQA\u0013\bA\u0002-\u000b!\u0002\u001d:pa\u0016\u0014H/[3t!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0003vi&d'\"\u0001)\u0002\t)\fg/Y\u0005\u0003%6\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003!\u0019wN\\:v[\u0016\u0014X#A+\u0011\tY{\u0016-Y\u0007\u0002/*\u00111\u000b\u0017\u0006\u00033j\u000bqa\u00197jK:$8O\u0003\u0002%7*\u0011A,X\u0001\u0007CB\f7\r[3\u000b\u0003y\u000b1a\u001c:h\u0013\t\u0001wK\u0001\u0005D_:\u001cX/\\3s!\r!$\rZ\u0005\u0003GV\u0012Q!\u0011:sCf\u0004\"\u0001N3\n\u0005\u0019,$\u0001\u0002\"zi\u0016\fAbY8ogVlWM]0%KF$\"AR5\t\u000f)\u0004\u0012\u0011!a\u0001+\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\r|gn];nKJ\u0004\u0013!\u00039s_\u0012,8-\u001a:t+\u0005q\u0007cA8um6\t\u0001O\u0003\u0002re\u00069Q.\u001e;bE2,'BA:6\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003kB\u0014aAQ;gM\u0016\u0014\b\u0003B<{C\u0006l\u0011\u0001\u001f\u0006\u0003sb\u000b\u0001\u0002\u001d:pIV\u001cWM]\u0005\u0003wb\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\u0018A\u00039s_\u0012,8-\u001a:tA\u0005Qa.^7SK\u000e|'\u000fZ:\u0002\u00179,XNU3d_J$7\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011!B;uS2\u001c(bAA\u00075\u000611m\\7n_:LA!!\u0005\u0002\b\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003)\u0011'o\\6feRKW.\u001a\u000b\u0005\u0003\u0007\tI\u0002\u0003\u0004\u0002\u001ca\u0001\raM\u0001\tEJ|7.\u001a:JI\u0006)1/\u001a;VaR\u0019a)!\t\t\u000f\u0005\r\u0012\u00041\u0001\u0002&\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002(\u0005MRBAA\u0015\u0015\rQ\u00131\u0006\u0006\u0005\u0003[\ty#A\u0004kkBLG/\u001a:\u000b\u0007\u0005ER,A\u0003kk:LG/\u0003\u0003\u00026\u0005%\"\u0001\u0003+fgRLeNZ8)\u0007e\tI\u0004\u0005\u0003\u0002(\u0005m\u0012\u0002BA\u001f\u0003S\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u0001$)\u0007i\t)\u0005\u0005\u0003\u0002(\u0005\u001d\u0013\u0002BA%\u0003S\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002%\r\u0014X-\u0019;f)\u0016\u001cH\u000f\u0015:pIV\u001cWM\u001d\u000b\bm\u0006=\u0013\u0011NA7\u0011\u001d\t\tf\u0007a\u0001\u0003'\n!B\u0019:pW\u0016\u0014H*[:u!\u0011\t)&a\u0019\u000f\t\u0005]\u0013q\f\t\u0004\u00033*TBAA.\u0015\r\ti&J\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005T'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\n9G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003C*\u0004\u0002CA67A\u0005\t\u0019A\u001a\u0002#\u0011,G.\u001b<fef$\u0016.\\3pkRl5\u000f\u0003\u0005\u0002pm\u0001\n\u00111\u00014\u0003A\u0011X-];fgR$\u0016.\\3pkRl5/\u0001\u000fde\u0016\fG/\u001a+fgR\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U$fA\u001a\u0002x-\u0012\u0011\u0011\u0010\t\u0005\u0003w\n))\u0004\u0002\u0002~)!\u0011qPAA\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004V\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9)! \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000fde\u0016\fG/\u001a+fgR\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002!I,w-[:uKJ\u0004&o\u001c3vG\u0016\u0014Hc\u0001<\u0002\u0010\")\u0011P\ba\u0001m\u0006!B/Z:u'\u0016tG-Q2s_N\u001cX*\u0019=BO\u0016D3aHAK!\u0011\t9#a&\n\t\u0005e\u0015\u0011\u0006\u0002\u0005)\u0016\u001cH\u000fK\u0004 \u0003;\u000b\u0019+!*\u0011\t\u0005\u001d\u0012qT\u0005\u0005\u0003C\u000bICA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003q\u0002")
public class ConnectionMaxAgeTest
extends AbstractConsumerTest {
    private final int testConnectionMaxAgeMs;
    private final int testConnectionMaxIdleMs;
    private final int testConnectionMinExpireIntervalMs;
    private final int testLoopCount;
    private final int testRequestTimeoutMs;
    private final int testDeliveryTimeoutMs;
    private Consumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final int numRecords;
    private final Time time = new MockTime();

    private int testConnectionMaxAgeMs() {
        return this.testConnectionMaxAgeMs;
    }

    private int testConnectionMaxIdleMs() {
        return this.testConnectionMaxIdleMs;
    }

    private int testConnectionMinExpireIntervalMs() {
        return this.testConnectionMinExpireIntervalMs;
    }

    private int testLoopCount() {
        return this.testLoopCount;
    }

    private int testRequestTimeoutMs() {
        return this.testRequestTimeoutMs;
    }

    private int testDeliveryTimeoutMs() {
        return this.testDeliveryTimeoutMs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), Integer.toString(this.testConnectionMaxIdleMs()));
        properties.put(KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp(), Integer.toString(this.testConnectionMaxAgeMs()));
        properties.put(KafkaConfig$.MODULE$.ConnectionMinExpireIntervalMsProp(), Integer.toString(this.testConnectionMinExpireIntervalMs()));
    }

    private Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    private int numRecords() {
        return this.numRecords;
    }

    public Time time() {
        return this.time;
    }

    @Override
    public Time brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), SecurityProtocol.PLAINTEXT);
        String x$3 = "group";
        None$ x$4 = None$.MODULE$;
        String x$5 = "earliest";
        boolean x$6 = true;
        boolean x$7 = false;
        int x$8 = 500;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$3, (Option<String>)x$4, x$5, x$6, x$7, x$8, SecurityProtocol.PLAINTEXT, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$12, (String)null));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.consumer().close(Duration.ZERO);
        this.producers().foreach((Function1 & Serializable)x$2 -> {
            x$2.close(Duration.ZERO);
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createTestProducer(String brokerList, int deliveryTimeoutMs, int requestTimeoutMs) {
        SecurityProtocol x$2 = this.securityProtocol();
        Option<File> x$3 = this.trustStoreFile();
        Option<Properties> x$4 = this.clientSaslProperties();
        int x$7 = -1;
        long x$8 = 60000L;
        long x$9 = 0x100000L;
        int x$10 = Integer.MAX_VALUE;
        int x$11 = 0;
        int x$12 = 16384;
        String x$13 = "none";
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(brokerList, x$7, x$8, x$9, x$10, deliveryTimeoutMs, x$11, x$12, x$13, requestTimeoutMs, x$2, x$3, x$4, x$14, x$15, x$16);
        return this.registerProducer(producer);
    }

    public int createTestProducer$default$2() {
        return this.testDeliveryTimeoutMs();
    }

    public int createTestProducer$default$3() {
        return this.testRequestTimeoutMs();
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    @Test
    @Timeout(value=60L)
    public void testSendAcrossMaxAge() {
        KafkaProducer<byte[], byte[]> producer = this.createTestProducer(this.bootstrapServers(this.bootstrapServers$default$1()), this.createTestProducer$default$2(), this.createTestProducer$default$3());
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)this.consumer().assignment().size());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.testLoopCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)loopCounter -> {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Loop count ").append(loopCounter).append(", start message is ").append(loopCounter * this.numRecords()).toString());
            int startingTimestamp = loopCounter * this.numRecords();
            this.sendRecords(producer, this.numRecords(), this.tp(), loopCounter * this.numRecords());
            this.time().sleep((long)(this.testConnectionMaxAgeMs() + 1));
            Consumer<byte[], byte[]> x$1 = this.consumer();
            int x$2 = this.numRecords();
            int x$3 = this.numRecords();
            int x$4 = loopCounter * this.numRecords();
            long x$5 = startingTimestamp;
            int x$6 = this.consumeAndVerifyRecords$default$4();
            TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
            TopicPartition x$8 = this.consumeAndVerifyRecords$default$7();
            this.consumeAndVerifyRecords(x$1, x$2, x$4, x$6, x$5, x$7, x$8, x$3);
        });
        Assertions.assertTrue((BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)server -> BoxesRunTime.boxToLong((long)TestUtils$.MODULE$.totalMetricValue((KafkaBroker)server, "aged-connections-killed-count")))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) > 0L ? 1 : 0) != 0, (String)"Connections should have been expired due to excessive age");
    }

    public ConnectionMaxAgeTest() {
        this.testConnectionMaxAgeMs = 2000;
        this.testConnectionMaxIdleMs = -1;
        this.testConnectionMinExpireIntervalMs = 100;
        this.testLoopCount = 3;
        this.testRequestTimeoutMs = 120000;
        this.testDeliveryTimeoutMs = 120000;
        this.numRecords = 10;
    }
}

