/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kafka.network.ConnectionQuota;
import kafka.network.IpQuotaEntity;
import kafka.network.ListenerIpQuotaEntity;
import kafka.network.ListenerTenantQuotaEntity;
import kafka.network.TenantQuotaEntity;
import kafka.network.TooManyConnectionsException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectionQuotaTest {
    private Metrics metrics;

    @BeforeEach
    public void beforeEach() {
        this.metrics = new Metrics();
    }

    @AfterEach
    public void afterEach() {
        this.metrics.close();
    }

    @Test
    public void testBuilder() {
        new ConnectionQuota.Builder(this.metrics).setMaxConnectionsOverride(Collections.emptyMap()).setDefaultMaxConnections(2).setCreateQuotaEntity(IpQuotaEntity::new).setCreateListenerConnectionQuotaEntity((addr, listenerName) -> new ListenerIpQuotaEntity(addr, listenerName.value())).setCalculateDefaultMaxConnectionRate(() -> 1.0).setEntityMetricTag("ip").setMetricValueToEntity(addr -> InetAddress.getLoopbackAddress()).setCalculateDefaultMaxConnections(() -> 10).build();
    }

    @Test
    public void testConnectionRate() throws UnknownHostException {
        ConnectionQuota connectionQuota = new ConnectionQuota.Builder(this.metrics).setMaxConnectionsOverride(Collections.emptyMap()).setDefaultMaxConnections(2).setCreateQuotaEntity(IpQuotaEntity::new).setCreateListenerConnectionQuotaEntity((addr, listenerName) -> new ListenerIpQuotaEntity(addr, listenerName.value())).setCalculateDefaultMaxConnectionRate(() -> 1.0).setEntityMetricTag("ip").setMetricValueToEntity(addr -> InetAddress.getLoopbackAddress()).setCalculateDefaultMaxConnections(() -> 10).build();
        InetAddress address = InetAddress.getLoopbackAddress();
        Assertions.assertFalse((boolean)connectionQuota.containsConnectionRateOverride((Object)address));
        Assertions.assertEquals((double)1.0, (double)connectionQuota.maxConnectionRate((Object)InetAddress.getLoopbackAddress()));
        connectionQuota.updateDefaultMaxConnectionRate(Optional.of(3.0));
        Assertions.assertEquals((double)3.0, (double)connectionQuota.maxConnectionRate((Object)InetAddress.getLoopbackAddress()));
        Assertions.assertFalse((boolean)connectionQuota.containsConnectionRateOverride((Object)address));
        Assertions.assertFalse((boolean)connectionQuota.containsConnectionRateOverride((Object)InetAddress.getLocalHost()));
        connectionQuota.updateMaxConnectionRate((Object)address, 4.0);
        Assertions.assertEquals((double)4.0, (double)connectionQuota.maxConnectionRate((Object)address));
        Assertions.assertEquals((double)3.0, (double)connectionQuota.maxConnectionRate((Object)InetAddress.getLocalHost()));
        Assertions.assertTrue((boolean)connectionQuota.containsConnectionRateOverride((Object)address));
        Assertions.assertFalse((boolean)connectionQuota.containsConnectionRateOverride((Object)InetAddress.getLocalHost()));
    }

    @Test
    public void testConnectionCount() throws UnknownHostException {
        ConnectionQuota connectionQuota = new ConnectionQuota.Builder(this.metrics).setMaxConnectionsOverride(Collections.emptyMap()).setDefaultMaxConnections(2).setCreateQuotaEntity(IpQuotaEntity::new).setCreateListenerConnectionQuotaEntity((addr, listenerName) -> new ListenerIpQuotaEntity(addr, listenerName.value())).setCalculateDefaultMaxConnectionRate(() -> 1.0).setEntityMetricTag("ip").setMetricValueToEntity(addr -> InetAddress.getLoopbackAddress()).setCalculateDefaultMaxConnections(() -> 10).build();
        InetAddress address = InetAddress.getLoopbackAddress();
        Assertions.assertNull((Object)connectionQuota.connectionCountOrDefault((Object)address, null));
        Assertions.assertEquals((int)0, (int)connectionQuota.connectionCount((Object)address));
        Assertions.assertFalse((boolean)connectionQuota.containsEntity((Object)address));
        connectionQuota.incrementConnectionCount((Object)address);
        Assertions.assertEquals((int)1, (int)connectionQuota.connectionCount((Object)address));
        Assertions.assertTrue((boolean)connectionQuota.containsEntity((Object)address));
        connectionQuota.incrementConnectionCount((Object)address);
        Assertions.assertEquals((int)2, (int)connectionQuota.connectionCount((Object)address));
        Assertions.assertEquals((int)0, (int)connectionQuota.connectionCount((Object)InetAddress.getLocalHost()));
        Assertions.assertFalse((boolean)connectionQuota.containsEntity((Object)InetAddress.getLocalHost()));
        connectionQuota.decrementConnectionCount((Object)address);
        Assertions.assertEquals((int)1, (int)connectionQuota.connectionCount((Object)address));
        connectionQuota.decrementConnectionCount((Object)address);
        Assertions.assertNull((Object)connectionQuota.connectionCountOrDefault((Object)address, null));
        Assertions.assertEquals((int)0, (int)connectionQuota.connectionCount((Object)address));
        connectionQuota.decrementConnectionCount((Object)address);
        Assertions.assertNull((Object)connectionQuota.connectionCountOrDefault((Object)address, null));
        Assertions.assertEquals((int)0, (int)connectionQuota.connectionCount((Object)address));
        Assertions.assertFalse((boolean)connectionQuota.containsEntity((Object)address));
    }

    @Test
    public void testEnforceMaxConnectionLimit() throws UnknownHostException {
        ConnectionQuota connectionQuota = new ConnectionQuota.Builder(this.metrics).setMaxConnectionsOverride(Collections.emptyMap()).setDefaultMaxConnections(2).setCreateQuotaEntity(IpQuotaEntity::new).setCreateListenerConnectionQuotaEntity((addr, listenerName) -> new ListenerIpQuotaEntity(addr, listenerName.value())).setCalculateDefaultMaxConnectionRate(() -> 1.0).setEntityMetricTag("ip").setMetricValueToEntity(addr -> InetAddress.getLoopbackAddress()).setCalculateDefaultMaxConnections(() -> 10).build();
        InetAddress address = InetAddress.getLoopbackAddress();
        connectionQuota.enforceMaxConnectionLimit((Object)address);
        connectionQuota.incrementConnectionCount((Object)address);
        connectionQuota.enforceMaxConnectionLimit((Object)address);
        connectionQuota.incrementConnectionCount((Object)address);
        connectionQuota.enforceMaxConnectionLimit((Object)address);
        connectionQuota.incrementConnectionCount((Object)address);
        Assertions.assertThrows(TooManyConnectionsException.class, () -> connectionQuota.enforceMaxConnectionLimit((Object)address));
        connectionQuota.enforceMaxConnectionLimit((Object)InetAddress.getLocalHost());
        connectionQuota.decrementConnectionCount((Object)address);
        connectionQuota.enforceMaxConnectionLimit((Object)address);
    }

    @Test
    public void testGetOrCreateConnectionRateThrottleSensor() {
        ConnectionQuota connectionQuota = new ConnectionQuota.Builder(this.metrics).setMaxConnectionsOverride(Collections.emptyMap()).setDefaultMaxConnections(2).setCreateQuotaEntity(IpQuotaEntity::new).setCreateListenerConnectionQuotaEntity((addr, listenerName) -> new ListenerIpQuotaEntity(addr, listenerName.value())).setCalculateDefaultMaxConnectionRate(() -> 1.0).setEntityMetricTag("ip").setMetricValueToEntity(addr -> InetAddress.getLoopbackAddress()).setCalculateDefaultMaxConnections(() -> 10).build();
        Sensor sensor = connectionQuota.getOrCreateConnectionRateThrottleSensor((Object)InetAddress.getLoopbackAddress());
        Assertions.assertEquals((Object)String.format("ConnectionRateThrottleTime-%s", InetAddress.getLoopbackAddress().getHostAddress()), (Object)sensor.name());
        Assertions.assertFalse((boolean)sensor.hasExpired());
    }

    @Test
    public void testAddressFromMetricName() {
        String metricTag = "ip";
        ConnectionQuota connectionQuota = new ConnectionQuota.Builder(this.metrics).setMaxConnectionsOverride(Collections.emptyMap()).setDefaultMaxConnections(2).setCreateQuotaEntity(IpQuotaEntity::new).setCreateListenerConnectionQuotaEntity((addr, listenerName) -> new ListenerIpQuotaEntity(addr, listenerName.value())).setCalculateDefaultMaxConnectionRate(() -> 1.0).setEntityMetricTag(metricTag).setMetricValueToEntity(this::hostAddressToInetAddress).setCalculateDefaultMaxConnections(() -> 10).build();
        Map<String, String> tags = Collections.singletonMap(metricTag, InetAddress.getLoopbackAddress().getHostAddress());
        MetricName metricName = new MetricName("name", "group", "description", tags);
        Assertions.assertEquals((Object)InetAddress.getLoopbackAddress(), (Object)connectionQuota.entityFromMetricName(metricName));
    }

    @Test
    public void testIsEntityConnectionQuotaMetric() {
        String metricTag = "ip";
        ConnectionQuota connectionQuota = new ConnectionQuota.Builder(this.metrics).setMaxConnectionsOverride(Collections.emptyMap()).setDefaultMaxConnections(2).setCreateQuotaEntity(IpQuotaEntity::new).setCreateListenerConnectionQuotaEntity((addr, listenerName) -> new ListenerIpQuotaEntity(addr, listenerName.value())).setCalculateDefaultMaxConnectionRate(() -> 1.0).setEntityMetricTag(metricTag).setMetricValueToEntity(this::hostAddressToInetAddress).setCalculateDefaultMaxConnections(() -> 10).build();
        Map<String, String> ipTags = Collections.singletonMap(metricTag, InetAddress.getLoopbackAddress().getHostAddress());
        MetricName ipMetricName = new MetricName("connection-tokens", "socket-server-metrics", "description", ipTags);
        Assertions.assertTrue((boolean)connectionQuota.isEntityConnectionQuotaMetric(ipMetricName));
        Map<String, String> tenantTags = Collections.singletonMap("tenant", "lkc-abcd");
        MetricName tenantMetricName = new MetricName("connection-tokens", "socket-server-metrics", "description", tenantTags);
        Assertions.assertFalse((boolean)connectionQuota.isEntityConnectionQuotaMetric(tenantMetricName));
    }

    @Test
    public void testIsEntityConnectionCountMetric() {
        String metricTag = "tenant";
        ConnectionQuota connectionQuota = new ConnectionQuota.Builder(this.metrics).setMaxConnectionsOverride(Collections.emptyMap()).setDefaultMaxConnections(2).setCreateQuotaEntity(TenantQuotaEntity::new).setCreateListenerConnectionQuotaEntity((addr, listenerName) -> new ListenerTenantQuotaEntity(addr, listenerName.value())).setCalculateDefaultMaxConnectionRate(() -> 1.0).setEntityMetricTag(metricTag).setCalculateDefaultMaxConnections(() -> 10).setMetricValueToEntity(tenant -> tenant).build();
        Map<String, String> ipTags = Collections.singletonMap("ip", InetAddress.getLoopbackAddress().getHostAddress());
        MetricName ipMetricName = new MetricName("authenticated-unthrottled-connection-count", "socket-server-metrics", "description", ipTags);
        Assertions.assertFalse((boolean)connectionQuota.isEntityConnectionCountMetric(ipMetricName));
        Map<String, String> tenantTags = Collections.singletonMap(metricTag, "lkc-abcd");
        MetricName tenantMetricName = new MetricName("authenticated-unthrottled-connection-count", "socket-server-metrics", "description", tenantTags);
        Assertions.assertTrue((boolean)connectionQuota.isEntityConnectionCountMetric(tenantMetricName));
    }

    @Test
    public void testConnectionCountUpdates() throws UnknownHostException {
        ConnectionQuota connectionQuota = new ConnectionQuota.Builder(this.metrics).setMaxConnectionsOverride(new HashMap()).setDefaultMaxConnections(2).setCreateQuotaEntity(TenantQuotaEntity::new).setCreateListenerConnectionQuotaEntity((addr, listenerName) -> new ListenerTenantQuotaEntity(addr, listenerName.value())).setCalculateDefaultMaxConnectionRate(() -> 1.0).setEntityMetricTag("tenant").setMetricValueToEntity(tenant -> tenant).setCalculateDefaultMaxConnections(() -> 10).build();
        String lkcId = "lkc-abcd1";
        Assertions.assertEquals((int)2, (int)connectionQuota.maxConnections((Object)lkcId));
        connectionQuota.updateDefaultMaxConnections(Optional.of(3));
        Assertions.assertEquals((int)3, (int)connectionQuota.maxConnections((Object)lkcId));
        connectionQuota.updateMaxConnectionsQuota((Object)lkcId, 4);
        Assertions.assertEquals((int)4, (int)connectionQuota.maxConnections((Object)lkcId));
        Assertions.assertEquals((int)3, (int)connectionQuota.maxConnections((Object)"lkc-random"));
        connectionQuota.updateDefaultMaxConnections(Optional.empty());
        Assertions.assertEquals((int)4, (int)connectionQuota.maxConnections((Object)lkcId));
        Assertions.assertEquals((int)10, (int)connectionQuota.maxConnections((Object)"lkc-random"));
        connectionQuota.removeMaxConnectionsQuota((Object)lkcId);
        Assertions.assertEquals((int)10, (int)connectionQuota.maxConnections((Object)lkcId));
    }

    private InetAddress hostAddressToInetAddress(String ip) {
        try {
            return InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

