/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tmb\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u000f\u0001\u0005BeBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004K\u0001\u0001\u0006IA\u0011\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019I\u0006\u0001)A\u0005\u001b\"9!\f\u0001b\u0001\n\u0003Y\u0006B\u00022\u0001A\u0003%A\fC\u0004d\u0001\t\u0007I\u0011A!\t\r\u0011\u0004\u0001\u0015!\u0003C\u0011\u001d)\u0007A1A\u0005\u0002eBaA\u001a\u0001!\u0002\u0013Q\u0004\"C4\u0001\u0001\u0004\u0005\r\u0011\"\u0001i\u0011%\t\b\u00011AA\u0002\u0013\u0005!\u000fC\u0005y\u0001\u0001\u0007\t\u0011)Q\u0005S\")\u0011\u0010\u0001C!u\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003g\u0001A\u0011AA\u0015\u0011\u001d\ti\u0004\u0001C\u0001\u0003SAq!!\u0011\u0001\t\u0003\tI\u0003C\u0004\u0002F\u0001!\t!!\u000b\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L!9\u0011\u0011\u0010\u0001\u0005\n\u0005m\u0004bBAF\u0001\u0011%\u0011Q\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\t9\u000b\u0001C\u0005\u0003SC\u0011\"!0\u0001#\u0003%I!a0\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"1\u0011Q\u001d\u0001\u0005\u0002eBq!a:\u0001\t\u0003\tI\u000fC\u0004\u0002t\u0002!I!!>\t\u0013\u0005e\b!%A\u0005\n\u0005m\bbBA\u0000\u0001\u0011%!\u0011\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057AqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u0003,\u0001!IA!\f\u00035\u0011Kh.Y7jG\u000e{gN\\3di&|g.U;pi\u0006$Vm\u001d;\u000b\u0005%R\u0013a\u00028fi^|'o\u001b\u0006\u0002W\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001/!\ty#'D\u00011\u0015\t\t$&\u0001\u0004tKJ4XM]\u0005\u0003gA\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003!\n1B\u0019:pW\u0016\u00148i\\;oiV\t!\b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDHA\u0002J]R\fQ\u0001^8qS\u000e,\u0012A\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bA\u0001\\1oO*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n\u0001\u0002\\5ti\u0016tWM]\u000b\u0002\u001bB\u0011ajV\u0007\u0002\u001f*\u0011\u0011\u0006\u0015\u0006\u0003#J\u000baaY8n[>t'BA\u0016T\u0015\t!V+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0006\u0019qN]4\n\u0005a{%\u0001\u0004'jgR,g.\u001a:OC6,\u0017!\u00037jgR,g.\u001a:!\u00031awnY1m\u0003\u0012$'/Z:t+\u0005a\u0006CA/a\u001b\u0005q&BA0G\u0003\rqW\r^\u0005\u0003Cz\u00131\"\u00138fi\u0006#GM]3tg\u0006iAn\\2bY\u0006#GM]3tg\u0002\n1\"\u001e8l]><h\u000eS8ti\u0006aQO\\6o_^t\u0007j\\:uA\u0005i\u0002\u000f\\1j]R,\u0007\u0010\u001e'jgR,g.\u001a:EK\u001a\fW\u000f\u001c;Rk>$\u0018-\u0001\u0010qY\u0006Lg\u000e^3yi2K7\u000f^3oKJ$UMZ1vYR\fVo\u001c;bA\u0005AQ\r_3dkR|'/F\u0001j!\tQw.D\u0001l\u0015\taW.\u0001\u0006d_:\u001cWO\u001d:f]RT!A\u001c$\u0002\tU$\u0018\u000e\\\u0005\u0003a.\u0014q\"\u0012=fGV$xN]*feZL7-Z\u0001\rKb,7-\u001e;pe~#S-\u001d\u000b\u0003gZ\u0004\"a\u000f;\n\u0005Ud$\u0001B+oSRDqa\u001e\b\u0002\u0002\u0003\u0007\u0011.A\u0002yIE\n\u0011\"\u001a=fGV$xN\u001d\u0011\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHCA:|\u0011\u0015a\b\u00031\u0001~\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003}~l\u0011!\\\u0005\u0004\u0003\u0003i'A\u0003)s_B,'\u000f^5fg\u0006)1/\u001a;VaR\u00191/a\u0002\t\u000f\u0005%\u0011\u00031\u0001\u0002\f\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002\u000e\u0005mQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0016\u0005]\u0011a\u00026va&$XM\u001d\u0006\u0004\u00033)\u0016!\u00026v]&$\u0018\u0002BA\u000f\u0003\u001f\u0011\u0001\u0002V3ti&sgm\u001c\u0015\u0004#\u0005\u0005\u0002\u0003BA\u0007\u0003GIA!!\n\u0002\u0010\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012a\u001d\u0015\u0004%\u00055\u0002\u0003BA\u0007\u0003_IA!!\r\u0002\u0010\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001bi\u0016\u001cH\u000fR=oC6L7mQ8o]\u0016\u001cG/[8o#V|G/\u0019\u0015\u0004'\u0005]\u0002\u0003BA\u0007\u0003sIA!a\u000f\u0002\u0010\t!A+Z:u\u0003\t\"Xm\u001d;Es:\fW.[2MSN$XM\\3s\u0007>tg.Z2uS>t\u0017+^8uC\"\u001aA#a\u000e\u0002]Q,7\u000f\u001e#z]\u0006l\u0017n\u0019'jgR,g.\u001a:D_:tWm\u0019;j_:\u001c%/Z1uS>t'+\u0019;f#V|G/\u0019\u0015\u0004+\u0005]\u0012\u0001\t;fgR$\u0015P\\1nS\u000eL\u0005oQ8o]\u0016\u001cG/[8o%\u0006$X-U;pi\u0006D3AFA\u001c\u0003I\u0011XmY8oM&<WO]3TKJ4XM]:\u0015\u000fM\fi%!\u0015\u0002\\!1\u0011qJ\fA\u0002u\f\u0001B\\3x!J|\u0007o\u001d\u0005\b\u0003':\u0002\u0019AA+\u0003=\u0001XM\u001d\"s_.,'oQ8oM&<\u0007cA\u001e\u0002X%\u0019\u0011\u0011\f\u001f\u0003\u000f\t{w\u000e\\3b]\"9\u0011QL\fA\u0002\u0005}\u0013!D1Qe>\u0004Hk\u001c,fe&4\u0017\u0010E\u0004<\u0003C\n)'!\u001a\n\u0007\u0005\rDH\u0001\u0004UkBdWM\r\t\u0005\u0003O\n)H\u0004\u0003\u0002j\u0005E\u0004cAA6y5\u0011\u0011Q\u000e\u0006\u0004\u0003_b\u0013A\u0002\u001fs_>$h(C\u0002\u0002tq\na\u0001\u0015:fI\u00164\u0017bA%\u0002x)\u0019\u00111\u000f\u001f\u0002-U\u0004H-\u0019;f\u0013B\u001cuN\u001c8fGRLwN\u001c*bi\u0016$Ra]A?\u0003\u000fCq!a \u0019\u0001\u0004\t\t)\u0001\u0002jaB)1(a!\u0002f%\u0019\u0011Q\u0011\u001f\u0003\r=\u0003H/[8o\u0011\u0019\tI\t\u0007a\u0001u\u0005YQ\u000f\u001d3bi\u0016$'+\u0019;f\u0003=9\u0018-\u001b;G_Jd\u0015n\u001d;f]\u0016\u0014HcA:\u0002\u0010\"9\u0011\u0011S\rA\u0002\u0005\u0015\u0014\u0001\u00047jgR,g.\u001a:OC6,\u0017!E2sK\u0006$X-\u00113nS:\u001cE.[3oiR\u0011\u0011q\u0013\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003\u0015\tG-\\5o\u0015\r\t\tKU\u0001\bG2LWM\u001c;t\u0013\u0011\t)+a'\u0003\u000b\u0005#W.\u001b8\u0002+]\f\u0017\u000e\u001e$pe\u000e{gNZ5h\u001f:\u001cVM\u001d<feR91/a+\u00020\u0006M\u0006bBAW7\u0001\u0007\u0011QM\u0001\taJ|\u0007OT1nK\"9\u0011\u0011W\u000eA\u0002\u0005\u0015\u0014!\u00039s_B4\u0016\r\\;f\u0011%\t)l\u0007I\u0001\u0002\u0004\t9,A\u0005nCb<\u0016-\u001b;NgB\u00191(!/\n\u0007\u0005mFH\u0001\u0003M_:<\u0017aH<bSR4uN]\"p]\u001aLwm\u00148TKJ4XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0019\u0016\u0005\u0003o\u000b\u0019m\u000b\u0002\u0002FB!\u0011qYAi\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017!C;oG\",7m[3e\u0015\r\ty\rP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAj\u0003\u0013\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0001(o\u001c3vG\u0016\u0014V-];fgR,\"!!7\u0011\t\u0005m\u0017\u0011]\u0007\u0003\u0003;T1!a8Q\u0003!\u0011X-];fgR\u001c\u0018\u0002BAr\u0003;\u0014a\u0002\u0015:pIV\u001cWMU3rk\u0016\u001cH/A\bd_:tWm\u0019;j_:\u001cu.\u001e8u\u0003\u001d\u0019wN\u001c8fGR$B!a;\u0002rB\u0019Q,!<\n\u0007\u0005=hL\u0001\u0004T_\u000e\\W\r\u001e\u0005\u0007\u0017~\u0001\r!!\u001a\u00023\r\u0014X-\u0019;f\u0003:$g+\u001a:jMf\u001cuN\u001c8fGRLwN\u001c\u000b\u0004g\u0006]\b\u0002C&!!\u0003\u0005\r!!\u001a\u0002G\r\u0014X-\u0019;f\u0003:$g+\u001a:jMf\u001cuN\u001c8fGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q \u0016\u0005\u0003K\n\u0019-\u0001\twKJLg-_\"p]:,7\r^5p]R\u00191Oa\u0001\t\u000f\t\u0015!\u00051\u0001\u0002l\u000611o\\2lKR\fAC^3sS\u001aLX*\u0019=D_:tWm\u0019;j_:\u001cH#B:\u0003\f\t=\u0001B\u0002B\u0007G\u0001\u0007!(\u0001\bnCb\u001cuN\u001c8fGRLwN\\:\t\u000f\tE1\u00051\u0001\u0003\u0014\u0005\u00112m\u001c8oK\u000e$x+\u001b;i\r\u0006LG.\u001e:f!\u0011Y$QC:\n\u0007\t]AHA\u0005Gk:\u001cG/[8oa\u0005\u00012m\u001c8oK\u000e$\u0018I\u001c3WKJLg-\u001f\u000b\u0007\u0003+\u0012iBa\b\t\r-#\u0003\u0019AA3\u0011\u001d\u0011\t\u0003\na\u0001\u0003+\n!#[4o_J,\u0017jT#yG\u0016\u0004H/[8og\u00061r/Y5u\r>\u00148i\u001c8oK\u000e$\u0018n\u001c8D_VtG\u000fF\u0002t\u0005OAaA!\u000b&\u0001\u0004Q\u0014aF3ya\u0016\u001cG/\u001a3D_:tWm\u0019;j_:\u001cu.\u001e8u\u0003Q1XM]5gs\u000e{gN\\3di&|gNU1uKRI1Oa\f\u00034\t]\"\u0011\b\u0005\u0007\u0005c1\u0003\u0019\u0001\u001e\u0002#5LgnQ8o]\u0016\u001cG/[8o%\u0006$X\r\u0003\u0004\u00036\u0019\u0002\rAO\u0001\u0012[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0007BB&'\u0001\u0004\t)\u0007C\u0004\u0003\"\u0019\u0002\r!!\u0016")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private final String unknownHost;
    private final int plaintextListenerDefaultQuota;
    private ExecutorService executor;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public String unknownHost() {
        return this.unknownHost;
    }

    public int plaintextListenerDefaultQuota() {
        return this.plaintextListenerDefaultQuota;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), "1");
        properties.put(KafkaConfig$.MODULE$.NumThroughputQuotaSamplesProp(), "1");
        properties.put("listener.name.plaintext.max.connection.creation.rate", Integer.toString(this.plaintextListenerDefaultQuota()));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), this.brokerCount(), this.brokerCount(), (Seq<KafkaBroker>)this.servers(), new Properties());
    }

    @Override
    @AfterEach
    public void tearDown() {
        try {
            if (this.executor() != null) {
                this.executor().shutdownNow();
                Assertions.assertTrue((boolean)this.executor().awaitTermination(10L, TimeUnit.SECONDS));
            }
        }
        finally {
            super.tearDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicConnectionQuota() {
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), Integer.toString(maxConnectionsPerIP));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), (Object)Integer.toString(maxConnectionsPerIP)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIP - 1).map((Function1 & Serializable)x$13 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l2 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs2), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns.foreach((Function1 & Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs3 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs3), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Object var4_3 = null;
        Object var6_5 = null;
        int maxConnectionsPerIPOverride = 7;
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), (Object)new StringBuilder(10).append("localhost:").append(maxConnectionsPerIPOverride).toString()));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIPOverride - 1).map((Function1 & Serializable)x$13 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l4 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs4 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs4), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l5 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs5 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs5), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns2.foreach((Function1 & Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        });
        long l6 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs6 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs6), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicListenerConnectionQuota() {
        void verifyMaxConnections_connectWithFailure;
        int initialConnectionCount = this.connectionCount();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "5");
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsProp(), (Object)"5"));
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_maxConnections = 5;
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), verifyMaxConnections_maxConnections - 1).map((Function1 & Serializable)x$13 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l2 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs2), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns.foreach((Function1 & Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs3 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs3), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        intersect = null;
        Object var14_6 = null;
        String newListeners = "PLAINTEXT://localhost:0,INTERNAL://localhost:0";
        props.put(KafkaConfig$.MODULE$.ListenersProp(), newListeners);
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "PLAINTEXT:PLAINTEXT,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "10");
        props.put("listener.name.internal.max.connections", "5");
        props.put("listener.name.plaintext.max.connections", "5");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)newListeners));
        this.waitForListener("INTERNAL");
        IndexedSeq conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable)x$2 -> this.connect("PLAINTEXT"));
        conns = (IndexedSeq)conns.$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable)x$3 -> this.connect("INTERNAL")));
        conns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        conns.foreach((Function1 & Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$6(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int maxConnectionsPlaintext = 7;
        String listenerProp = new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        props.put(listenerProp, Integer.toString(maxConnectionsPlaintext));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)listenerProp, (Object)Integer.toString(maxConnectionsPlaintext)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext - 1).map((Function1 & Serializable)x$13 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l5 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs4 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs4), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l6 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs5 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs5), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns2.foreach((Function1 & Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        });
        long l7 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs6 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs6), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Object var39_23 = null;
        Object var41_25 = null;
        IndexedSeq plaintextConnections = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext).map((Function1 & Serializable)x$5 -> this.connect("PLAINTEXT"));
        this.executor_$eq(Executors.newSingleThreadExecutor());
        Future<?> future = this.executor().submit(() -> this.createAndVerifyConnection("PLAINTEXT"));
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)future.isDone());
        ((Socket)plaintextConnections.head()).close();
        future.get(30L, TimeUnit.SECONDS);
        plaintextConnections.foreach((Function1 & Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$12(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        IndexedSeq plaintextConns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable)x$7 -> this.connect("PLAINTEXT"));
        IndexedSeq internalConns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable)x$8 -> this.connect("INTERNAL"));
        plaintextConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        plaintextConns = (IndexedSeq)plaintextConns.$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).map((Function1 & Serializable)x$9 -> this.connect("PLAINTEXT")));
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$19(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Internal connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        plaintextConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        Assertions.assertThrows(IOException.class, () -> internalConns.foreach((Function1 & Serializable)socket -> (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), (Socket)socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))));
        plaintextConns.foreach((Function1 & Serializable)x$10 -> {
            x$10.close();
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable)x$11 -> {
            x$11.close();
            return BoxedUnit.UNIT;
        });
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$26(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testDynamicListenerConnectionCreationRateQuota() {
        .colon.colon newListenerNames = new .colon.colon((Object)"PLAINTEXT", (List)new .colon.colon((Object)"EXTERNAL", (List)Nil$.MODULE$));
        String newListeners = "PLAINTEXT://localhost:0,EXTERNAL://localhost:0";
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ListenersProp(), newListeners);
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "PLAINTEXT:PLAINTEXT,EXTERNAL:PLAINTEXT");
        int initialConnectionCount = this.connectionCount();
        int connRateLimit = 9;
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)newListeners));
        this.waitForListener("EXTERNAL");
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        props.clear();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), Integer.toString(connRateLimit));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), (Object)Integer.toString(connRateLimit)));
        this.verifyConnectionRate(8, connRateLimit, "EXTERNAL", false);
        this.waitForConnectionCount(initialConnectionCount);
        int listenerConnRateLimit = 4;
        String plaintextListenerProp = new StringBuilder(0).append(this.listener().configPrefix()).append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        props.put(new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString(), Integer.toString(listenerConnRateLimit));
        props.put(plaintextListenerProp, Integer.toString(listenerConnRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(listenerConnRateLimit)));
        this.executor_$eq(Executors.newFixedThreadPool(newListenerNames.size()));
        ((scala.collection.immutable.Seq)newListenerNames.map((Function1 & Serializable)listener -> this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, (String)listener, false)))).foreach((Function1 & Serializable)x$12 -> x$12.get(40L, TimeUnit.SECONDS));
        this.waitForConnectionCount(initialConnectionCount);
        int newPlaintextRateLimit = 12;
        props.put(plaintextListenerProp, Integer.toString(newPlaintextRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(newPlaintextRateLimit)));
        Future<?> plaintextFuture = this.executor().submit(() -> this.verifyConnectionRate(10, newPlaintextRateLimit, "PLAINTEXT", false));
        Future<?> externalFuture = this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, "EXTERNAL", false));
        plaintextFuture.get(40L, TimeUnit.SECONDS);
        externalFuture.get(40L, TimeUnit.SECONDS);
        this.waitForConnectionCount(initialConnectionCount);
    }

    @Test
    public void testDynamicIpConnectionRateQuota() {
        int connRateLimit = 10;
        int initialConnectionCount = this.connectionCount();
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        this.updateIpConnectionRate((Option<String>)None$.MODULE$, connRateLimit);
        this.verifyConnectionRate(8, connRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
        int newRateLimit = 18;
        this.updateIpConnectionRate((Option<String>)new Some((Object)this.localAddress().getHostAddress()), newRateLimit);
        this.verifyConnectionRate(14, newRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
    }

    /*
     * WARNING - void declaration
     */
    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        int initialConnectionCount = this.connectionCount();
        try (Admin adminClient = this.createAdminClient();){
            TestUtils$.MODULE$.incrementalAlterConfigs(this.servers(), adminClient, newProps, perBrokerConfig, AlterConfigOp.OpType.SET).all().get();
            this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), 10000L);
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$reconfigureServers$1(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$reconfigureServers$2(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateIpConnectionRate(Option<String> ip, int updatedRate) {
        int initialConnectionCount = this.connectionCount();
        try (Admin adminClient = this.createAdminClient();){
            ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), ip.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))}))).asJava());
            scala.collection.immutable.Map request = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)updatedRate)))})))}));
            TestUtils$.MODULE$.alterClientQuotas(adminClient, (Map<ClientQuotaEntity, Map<String, Option<Object>>>)request).all().get();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$1(this, ip, updatedRate)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for connection rate update to propagate");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$4(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$5(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void waitForListener(String listenerName) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForListener$1(this, listenerName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    private Admin createAdminClient() {
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers(this.servers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    /*
     * WARNING - void declaration
     */
    private ProduceRequest produceRequest() {
        void withRecords_timestampType;
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var1_2 = null;
        Object var2_1 = null;
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(this.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records))))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var3_6 = null;
        return (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build();
    }

    public int connectionCount() {
        return ((KafkaServer)this.servers().head()).socketServer().connectionCount(this.localAddress());
    }

    public Socket connect(String listener) {
        ListenerName listenerName = ListenerName.normalised((String)listener);
        return new Socket("localhost", ((KafkaServer)this.servers().head()).socketServer().boundPort(listenerName));
    }

    private void createAndVerifyConnection(String listener) {
        try (Socket socket = this.connect(listener);){
            this.verifyConnection(socket);
        }
    }

    private String createAndVerifyConnection$default$1() {
        return "PLAINTEXT";
    }

    private void verifyConnection(Socket socket) {
        ProduceResponse produceResponse = (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyMaxConnections(int maxConnections, Function0<BoxedUnit> connectWithFailure) {
        int initialConnectionCount = this.connectionCount();
        IndexedSeq conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnections - 1).map((Function1 & Serializable)x$13 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnections)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        conns = (IndexedSeq)conns.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> connectWithFailure.apply$mcV$sp());
        ((Socket)conns.head()).close();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnections)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        conns.foreach((Function1 & Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
    }

    private boolean connectAndVerify(String listener, boolean ignoreIOExceptions) {
        boolean bl;
        try (Socket socket = this.connect(listener);){
            try {
                this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
                bl = true;
            }
            catch (IOException e) {
                if (!ignoreIOExceptions) {
                    throw e;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForConnectionCount(int expectedConnectionCount) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$1(this, expectedConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$2(this, expectedConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyConnectionRate(int minConnectionRate, int maxConnectionRate, String listener, boolean ignoreIOExceptions) {
        long runTimeMs = TimeUnit.SECONDS.toMillis(13L);
        long startTimeMs = System.currentTimeMillis();
        long endTimeMs = startTimeMs + runTimeMs;
        int connCount = 0;
        while (System.currentTimeMillis() < endTimeMs) {
            if (!this.connectAndVerify(listener, ignoreIOExceptions)) continue;
            ++connCount;
        }
        long elapsedMs = System.currentTimeMillis() - startTimeMs;
        double actualRate = (double)connCount / (double)elapsedMs * (double)1000;
        double rateCap = maxConnectionRate < Integer.MAX_VALUE ? 1.2 * (double)maxConnectionRate : 2.147483647E9;
        Assertions.assertTrue((actualRate <= rateCap ? 1 : 0) != 0, (String)new StringBuilder(41).append("Listener ").append(listener).append(" connection rate ").append(actualRate).append(" must be below ").append(rateCap).toString());
        Assertions.assertTrue((actualRate >= (double)minConnectionRate ? 1 : 0) != 0, (String)new StringBuilder(41).append("Listener ").append(listener).append(" connection rate ").append(actualRate).append(" must be above ").append(minConnectionRate).toString());
    }

    private final void connectAndVerify$1() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        }
    }

    private final void connectAndVerify$2() {
        socket.setSoTimeout(1000);
        try (Socket socket = this.connect("PLAINTEXT");){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$6(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$7() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$12(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$13() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$19(DynamicConnectionQuotaTest $this) {
        return $this.connectionCount() <= 10;
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$20() {
        return "Internal connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$26(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$27() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$reconfigureServers$1(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return initialConnectionCount$2 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$reconfigureServers$2(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return new StringBuilder(59).append("Admin client connection not closed (initial = ").append(initialConnectionCount$2).append(", current = ").append($this.connectionCount()).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$1(DynamicConnectionQuotaTest $this, Option ip$1, int updatedRate$1) {
        return ((KafkaServer)$this.servers().head()).socketServer().connectionQuotas().ipConnectionQuota().maxConnectionRate((Object)InetAddress.getByName((String)ip$1.getOrElse((Function0 & Serializable)() -> $this.unknownHost()))) == (double)updatedRate$1;
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$3() {
        return "Timed out waiting for connection rate update to propagate";
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$4(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return initialConnectionCount$3 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$5(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return new StringBuilder(59).append("Admin client connection not closed (initial = ").append(initialConnectionCount$3).append(", current = ").append($this.connectionCount()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$waitForListener$1(DynamicConnectionQuotaTest $this, String listenerName$1) {
        try {
            Assertions.assertTrue((((KafkaServer)$this.servers().head()).socketServer().boundPort(ListenerName.normalised((String)listenerName$1)) > 0 ? 1 : 0) != 0);
            return;
        }
        catch (KafkaException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicConnectionQuotaTest $this, String propValue$1, String propName$1) {
        Assertions.assertEquals((Object)propValue$1, ((KafkaServer)$this.servers().head()).config().originals().get(propName$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$2(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$3() {
        return "produce request connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$5(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$6() {
        return "connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$8(DynamicConnectionQuotaTest $this, int initialConnectionCount$4) {
        return initialConnectionCount$4 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$9() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$waitForConnectionCount$1(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return expectedConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$waitForConnectionCount$2(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return new StringBuilder(47).append("Connections not closed (expected = ").append(expectedConnectionCount$1).append(" current = ").append($this.connectionCount()).append(")").toString();
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
        this.unknownHost = "255.255.0.1";
        this.plaintextListenerDefaultQuota = 30;
    }
}

