/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.HashMap;
import kafka.network.ListenerAutoTuningQuota;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ListenerAutoTuningQuotaTest {
    private Metrics metrics;
    private Sensor connectionRateThrottleSensor;
    private Sensor connectionRateLimitSensor;

    @BeforeEach
    public void beforeEach() {
        this.metrics = new Metrics();
        this.connectionRateThrottleSensor = this.metrics.sensor("connectionRateThrottleSensor");
        this.connectionRateLimitSensor = this.metrics.sensor("connectionRateLimitSensor");
    }

    @AfterEach
    public void afterEach() {
        this.metrics.close();
    }

    @Test
    public void testConfigure() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(KafkaConfig.MaxConnectionCreationRateProp(), "10");
        configs.put(KafkaConfig.MaxConnectionCreationRateFloorProp(), "1");
        ListenerAutoTuningQuota autoTuningQuota = new ListenerAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        autoTuningQuota.configure("EXTERNAL", configs);
        Assertions.assertEquals((double)10.0, (double)autoTuningQuota.current());
        Assertions.assertEquals((double)0.0, (double)autoTuningQuota.connectionRateThrottleEnableThreshold());
    }

    @Test
    public void testConnectionRateThrottleSensor() {
        ListenerAutoTuningQuota autoTuningQuota = new ListenerAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        Assertions.assertEquals((Object)this.connectionRateThrottleSensor, (Object)autoTuningQuota.connectionRateThrottleSensor());
    }

    @Test
    public void testConnectionRateLimitSensor() {
        ListenerAutoTuningQuota autoTuningQuota = new ListenerAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        Assertions.assertEquals((Object)this.connectionRateLimitSensor, (Object)autoTuningQuota.connectionRateLimitSensor());
    }
}

