/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.Collections;
import java.util.HashMap;
import kafka.network.ListenerIpAutoTuningQuota;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ListenerIpAutoTuningQuotaTest {
    private Metrics metrics;
    private Sensor connectionRateThrottleSensor;
    private Sensor connectionRateLimitSensor;

    @BeforeEach
    public void beforeEach() {
        this.metrics = new Metrics();
        this.connectionRateThrottleSensor = this.metrics.sensor("connectionRateThrottleSensor");
        this.connectionRateLimitSensor = this.metrics.sensor("connectionRateLimitSensor");
    }

    @AfterEach
    public void afterEach() {
        this.metrics.close();
    }

    @Test
    public void testConfigure() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(KafkaConfig.ListenerConnectionRatePerIpMaxProp(), "10");
        configs.put(KafkaConfig.ListenerConnectionRatePerIpFloorProp(), "1");
        configs.put(KafkaConfig.ListenerConnectionRatePerIpStepProp(), "2");
        configs.put(KafkaConfig.MaxConnectionRatePerIpThrottleEnableThresholdProp(), "0.2");
        ListenerIpAutoTuningQuota autoTuningQuota = new ListenerIpAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        autoTuningQuota.configure("EXTERNAL", configs);
        Assertions.assertEquals((double)10.0, (double)autoTuningQuota.current());
        Assertions.assertEquals((double)0.2, (double)autoTuningQuota.connectionRateThrottleEnableThreshold());
    }

    @Test
    public void testValidate() {
        HashMap<String, String> validConfigs = new HashMap<String, String>();
        validConfigs.put(KafkaConfig.ListenerConnectionRatePerIpMaxProp(), "10");
        validConfigs.put(KafkaConfig.ListenerConnectionRatePerIpFloorProp(), "1");
        validConfigs.put(KafkaConfig.ListenerConnectionRatePerIpStepProp(), "2");
        validConfigs.put(KafkaConfig.MaxConnectionRatePerIpThrottleEnableThresholdProp(), "0.2");
        ListenerIpAutoTuningQuota autoTuningQuota = new ListenerIpAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        autoTuningQuota.validate(validConfigs);
        autoTuningQuota.validate(Collections.emptyMap());
        HashMap<String, String> invalidIpThrottleThreshold = new HashMap<String, String>();
        invalidIpThrottleThreshold.put(KafkaConfig.MaxConnectionRatePerIpThrottleEnableThresholdProp(), "1.1");
        Assertions.assertThrows(ConfigException.class, () -> autoTuningQuota.validate(invalidIpThrottleThreshold));
    }

    @Test
    public void testConnectionRateThrottleSensor() {
        ListenerIpAutoTuningQuota autoTuningQuota = new ListenerIpAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        Assertions.assertEquals((Object)this.connectionRateThrottleSensor, (Object)autoTuningQuota.connectionRateThrottleSensor());
    }

    @Test
    public void testConnectionRateLimitSensor() {
        ListenerIpAutoTuningQuota autoTuningQuota = new ListenerIpAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        Assertions.assertEquals((Object)this.connectionRateLimitSensor, (Object)autoTuningQuota.connectionRateLimitSensor());
    }
}

