/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.Collections;
import java.util.HashMap;
import kafka.network.ListenerTenantAutoTuningQuota;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ListenerTenantAutoTuningQuotaTest {
    private Metrics metrics;
    private Sensor connectionRateThrottleSensor;
    private Sensor connectionRateLimitSensor;

    @BeforeEach
    public void beforeEach() {
        this.metrics = new Metrics();
        this.connectionRateThrottleSensor = this.metrics.sensor("connectionRateThrottleSensor");
        this.connectionRateLimitSensor = this.metrics.sensor("connectionRateLimitSensor");
    }

    @AfterEach
    public void afterEach() {
        this.metrics.close();
    }

    @Test
    public void testConfigure() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("confluent.max.connection.rate.per.tenant", "10");
        configs.put("confluent.floor.connection.rate.per.tenant", "1");
        configs.put("confluent.step.connection.rate.per.tenant", "2");
        configs.put("max.connection.creation.rate.per.tenant.enable.threshold", "0.2");
        ListenerTenantAutoTuningQuota autoTuningQuota = new ListenerTenantAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        autoTuningQuota.configure("EXTERNAL", configs);
        Assertions.assertEquals((double)10.0, (double)autoTuningQuota.current());
        Assertions.assertEquals((double)0.2, (double)autoTuningQuota.connectionRateThrottleEnableThreshold());
    }

    @Test
    public void testValidate() {
        HashMap<String, String> validConfigs = new HashMap<String, String>();
        validConfigs.put("confluent.max.connection.rate.per.tenant", "10");
        validConfigs.put("confluent.floor.connection.rate.per.tenant", "1");
        validConfigs.put("confluent.step.connection.rate.per.tenant", "2");
        validConfigs.put("max.connection.creation.rate.per.tenant.enable.threshold", "0.2");
        ListenerTenantAutoTuningQuota autoTuningQuota = new ListenerTenantAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        autoTuningQuota.validate(validConfigs);
        autoTuningQuota.validate(Collections.emptyMap());
        HashMap<String, String> invalidIpThrottleThreshold = new HashMap<String, String>();
        invalidIpThrottleThreshold.put("max.connection.creation.rate.per.tenant.enable.threshold", "1.1");
        Assertions.assertThrows(ConfigException.class, () -> autoTuningQuota.validate(invalidIpThrottleThreshold));
    }

    @Test
    public void testConnectionRateThrottleSensor() {
        ListenerTenantAutoTuningQuota autoTuningQuota = new ListenerTenantAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        Assertions.assertEquals((Object)this.connectionRateThrottleSensor, (Object)autoTuningQuota.connectionRateThrottleSensor());
    }

    @Test
    public void testConnectionRateLimitSensor() {
        ListenerTenantAutoTuningQuota autoTuningQuota = new ListenerTenantAutoTuningQuota(this.connectionRateThrottleSensor, this.connectionRateLimitSensor);
        Assertions.assertEquals((Object)this.connectionRateLimitSensor, (Object)autoTuningQuota.connectionRateLimitSensor());
    }
}

