/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import io.opentelemetry.context.Context;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kafka.metrics.BrokerLoad;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import kafka.network.RequestMetrics;
import kafka.server.ActionQueue;
import kafka.server.DelayedActionQueue;
import kafka.server.EnvelopeUtils$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}f\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004B\u0001\u0001\u0006IA\u000f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u00199\u0005\u0001)A\u0005\t\")q\f\u0001C\u0001A\")q\u000e\u0001C\u0001A\")A\u000f\u0001C\u0001A\")a\u000f\u0001C\u0001A\")\u0001\u0010\u0001C\u0005s\"I\u00111\u0003\u0001\u0012\u0002\u0013%\u0011Q\u0003\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u0019\tI\u0005\u0001C\u0001A\"1\u0011Q\n\u0001\u0005\u0002\u0001Da!!\u0015\u0001\t\u0003\u0001\u0007BBA+\u0001\u0011\u0005\u0001\rC\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"I\u0011q\u0015\u0001\u0012\u0002\u0013%\u0011Q\u0003\u0005\b\u0003S\u0003A\u0011BAV\u0011\u001d\t\t\f\u0001C\u0005\u0003gC\u0011\"a/\u0001#\u0003%I!!\u0006\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"1\u0011Q\u0019\u0001\u0005\u0002\u0001Da!!3\u0001\t\u0003\u0001\u0007bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u000fAqA!\u0005\u0001\t\u0013\u0011\u0019\u0002C\u0004\u0003 \u0001!\tA!\t\t\u0013\t5\u0002!%A\u0005\u0002\t=\u0002\"\u0003B\u001a\u0001E\u0005I\u0011AA\u000b\u0011\u001d\t9\u0004\u0001C\u0001\u0005kA\u0011Ba\u000f\u0001#\u0003%\t!!\u0006\t\u000f\tu\u0002\u0001\"\u0003\u0003@!9!\u0011\f\u0001\u0005\n\tm\u0003b\u0002B-\u0001\u0011%!q\u0012\u0005\b\u0005O\u0003A\u0011\u0002BU\u0005I\u0011V-];fgR\u001c\u0005.\u00198oK2$Vm\u001d;\u000b\u0005%R\u0013a\u00028fi^|'o\u001b\u0006\u0002W\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001/!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u000e\t\u0003o\u0001i\u0011\u0001K\u0001\u0016e\u0016\fX/Z:u\u0007\"\fgN\\3m\u001b\u0016$(/[2t+\u0005Q\u0004CA\u001e?\u001d\t9D(\u0003\u0002>Q\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017BA A\u0005\u001diU\r\u001e:jGNT!!\u0010\u0015\u0002-I,\u0017/^3ti\u000eC\u0017M\u001c8fY6+GO]5dg\u0002\na\u0002\u001d:j]\u000eL\u0007/\u00197TKJ$W-F\u0001E%\r)\u0005\n\u0015\u0004\u0005\r\u0016\u0001AI\u0001\u0007=e\u00164\u0017N\\3nK:$h(A\bqe&t7-\u001b9bYN+'\u000fZ3!!\tIe*D\u0001K\u0015\tYE*\u0001\u0003mC:<'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f*\u0013aa\u00142kK\u000e$\bCA)^\u001b\u0005\u0011&BA*U\u0003\u0011\tW\u000f\u001e5\u000b\u0005U3\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005]C\u0016AB2p[6|gN\u0003\u0002,3*\u0011!lW\u0001\u0007CB\f7\r[3\u000b\u0003q\u000b1a\u001c:h\u0013\tq&KA\nLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197TKJ$W-\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005\t\u0007CA\u0018c\u0013\t\u0019\u0007G\u0001\u0003V]&$\bF\u0001\u0004f!\t1W.D\u0001h\u0015\tA\u0017.A\u0002ba&T!A[6\u0002\u000f),\b/\u001b;fe*\u0011AnW\u0001\u0006UVt\u0017\u000e^\u0005\u0003]\u001e\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002)Q,7\u000f^*fe&\fG.\u001b>f%\u0016\fX/Z:uQ\t9\u0011\u000f\u0005\u0002ge&\u00111o\u001a\u0002\u0005)\u0016\u001cH/A\tuKN$\u0018\t\u001c;feJ+\u0017/^3tiND#\u0001C9\u00025Q,7\u000f\u001e%fC2$\bn\u00115fG.$v\u000e^1m)&lW-T:)\u0005%\t\u0018a\u00052vS2$\u0007K]8ek\u000e,'+Z9vKN$HC\u0002>~\u0003\u000b\tI\u0001\u0005\u0002<w&\u0011A\u0010\u0011\u0002\b%\u0016\fX/Z:u\u0011\u0015q(\u00021\u0001\u0000\u00039\u0019H/\u0019:u)&lWMT1o_N\u00042aLA\u0001\u0013\r\t\u0019\u0001\r\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\b)\u0001\rAO\u0001\b[\u0016$(/[2t\u0011%\tYA\u0003I\u0001\u0002\u0004\ti!A\u0005qe&t7-\u001b9bYB\u0019\u0011+a\u0004\n\u0007\u0005E!K\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002;\t,\u0018\u000e\u001c3Qe>$WoY3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM*\"!a\u0006+\t\u00055\u0011\u0011D\u0016\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0005\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0005}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!\"-^5mIB\u0013x\u000eZ;dKJ+7\u000f]8og\u0016$b!a\f\u00026\u0005e\u0002cA\u001e\u00022%\u0019\u00111\u0007!\u0003\u0011I+7\u000f]8og\u0016Da!a\u000e\r\u0001\u0004Q\u0018a\u0002:fcV,7\u000f\u001e\u0005\b\u0003wa\u0001\u0019AA\u001f\u0003-\t7\r^5p]F+X-^3\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011+\u0003\u0019\u0019XM\u001d<fe&!\u0011qIA!\u0005-\t5\r^5p]F+X-^3\u00029Q,7\u000f^%oGJ,W.\u001a8uC2\fE\u000e^3s%\u0016\fX/Z:ug\"\u0012Q\"]\u0001\u0017i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8lg\"\u0012a\"]\u0001#i\u0016\u001cHOT8o\u00032$XM\u001d*fcV,7\u000f^:O_R$&/\u00198tM>\u0014X.\u001a3)\u0005=\t\u0018\u0001\u0005;fgRT5o\u001c8SKF,Xm\u001d;tQ\t\u0001\u0012/A\ruKN$()^5mI\u0016sg/\u001a7pa\u0016\u0014Vm\u001d9p]N,GcA1\u0002^!9\u0011qL\tA\u0002\u0005\u0005\u0014!B3se>\u0014\b\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001dd+\u0001\u0005qe>$xnY8m\u0013\u0011\tY'!\u001a\u0003\r\u0015\u0013(o\u001c:tQ\r\t\u0012q\u000e\t\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011QO5\u0002\rA\f'/Y7t\u0013\u0011\tI(a\u001d\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000fK\u0006\u0012\u0003{\nI)a#\u0002\u000e\u0006=\u0005\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u00151O\u0001\taJ|g/\u001b3fe&!\u0011qQAA\u0005))e.^7T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003C\nQA\\1nKNdc!!%\u0002\u0016\u0006e\u0015EAAJ\u0003\u0011quJT#\"\u0005\u0005]\u0015\u0001H\"M+N#VIU0B+RCuJU%[\u0003RKuJT0G\u0003&cU\tR\u0011\u0003\u00037\u000baBT(U?\u000e{e\n\u0016*P\u00192+%+\u0001\rck&dG\rT3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgR$rA_AQ\u0003G\u000b)\u000bC\u0003\u007f%\u0001\u0007q\u0010\u0003\u0004\u0002\bI\u0001\rA\u000f\u0005\n\u0003\u0017\u0011\u0002\u0013!a\u0001\u0003\u001b\t!EY;jY\u0012dU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u001a\u0014!\u00072vS2$G*Z1eKJ\fe\u000eZ%teJ+7\u000f]8og\u0016$b!a\f\u0002.\u0006=\u0006BBA\u001c)\u0001\u0007!\u0010C\u0004\u0002<Q\u0001\r!!\u0010\u00025\t,\u0018\u000e\u001c3Va\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0015\u000fi\f),a.\u0002:\")a0\u0006a\u0001\u007f\"1\u0011qA\u000bA\u0002iB\u0011\"a\u0003\u0016!\u0003\u0005\r!!\u0004\u0002I\t,\u0018\u000e\u001c3Va\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM\n1DY;jY\u0012,\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014Vm\u001d9p]N,GCBA\u0018\u0003\u0003\f\u0019\r\u0003\u0004\u00028]\u0001\rA\u001f\u0005\b\u0003w9\u0002\u0019AA\u001f\u0003]\"Xm\u001d;Fq\u000edW\u000fZ3MK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cHO\u0012:p[\n\u0013xn[3s\u0019>\fGmQ1mGVd\u0017\r^5p]\"\u0012\u0001$]\u00013i\u0016\u001cH/\u0012=dYV$W-\u00169eCR,W*\u001a;bI\u0006$\u0018M\u0012:p[\n\u0013xn[3s\u0019>\fGmQ1mGVd\u0017\r^5p]\"\u0012\u0011$]\u0001\u0018EVLG\u000eZ\"sK\u0006$X\rV8qS\u000e\u0014V-];fgR$B!!5\u0002^B!\u00111[Am\u001b\t\t)NC\u0002\u0002XZ\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u00037\f)NA\nDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fC\u0004\u0002`j\u0001\r!!9\u0002\u000bQ|\u0007/[2\u0011\t\u0005\r\u0018\u0011\u001f\b\u0005\u0003K\fi\u000fE\u0002\u0002hBj!!!;\u000b\u0007\u0005-H&\u0001\u0004=e>|GOP\u0005\u0004\u0003_\u0004\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002t\u0006U(AB*ue&twMC\u0002\u0002pB\n\u0001DY;jY\u0012\u001c%/Z1uKR{\u0007/[2SKN\u0004xN\\:f)\u0019\tYP!\u0001\u0003\u0004A!\u00111[A\u007f\u0013\u0011\ty0!6\u0003)\r\u0013X-\u0019;f)>\u0004\u0018nY:SKN\u0004xN\\:f\u0011\u001d\tyn\u0007a\u0001\u0003CDq!a\u0018\u001c\u0001\u0004\t\t'A\u000fck&dG-\u00168xe\u0006\u0004\b/\u001a3F]Z,Gn\u001c9f%\u0016\fX/Z:u)\rQ(\u0011\u0002\u0005\b\u0003oa\u0002\u0019\u0001B\u0006!\u0011\t\u0019N!\u0004\n\t\t=\u0011Q\u001b\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\u0006Y\u0011n\u001d,bY&$'j]8o)\u0011\u0011)Ba\u0007\u0011\u0007=\u00129\"C\u0002\u0003\u001aA\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0003\u001eu\u0001\r!!9\u0002\u0007M$(/\u0001\nsKF,Xm\u001d;XSRDW*\u001a;sS\u000e\u001cH#\u0003>\u0003$\t\u001d\"\u0011\u0006B\u0016\u0011\u001d\u0011)C\ba\u0001\u0005\u0017\t1A]3r\u0011\u0019\t9A\ba\u0001u!9aP\bI\u0001\u0002\u0004y\b\"CA\u0006=A\u0005\t\u0019AA\u0007\u0003q\u0011X-];fgR<\u0016\u000e\u001e5NKR\u0014\u0018nY:%I\u00164\u0017-\u001e7uIM*\"A!\r+\u0007}\fI\"\u0001\u000fsKF,Xm\u001d;XSRDW*\u001a;sS\u000e\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0015\u000bi\u00149D!\u000f\t\u000f\t\u0015\u0012\u00051\u0001\u0003\f!I\u00111B\u0011\u0011\u0002\u0003\u0007\u0011QB\u0001\u0012e\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012\u0014!\u00058foJ+\u0017/^3ti\u000e{g\u000e^3yiR1!\u0011\tB$\u0005/\u0002B!a5\u0003D%!!QIAk\u00059\u0011V-];fgR\u001cuN\u001c;fqRDqA!\u0013$\u0001\u0004\u0011Y%\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0005\u001b\u0012\u0019&\u0004\u0002\u0003P)\u0019!\u0011\u000b'\u0002\u00079Lw.\u0003\u0003\u0003V\t=#A\u0003\"zi\u0016\u0014UO\u001a4fe\"9\u00111B\u0012A\u0002\u00055\u0011!\u0002;p\u001b\u0006\u0004H\u0003\u0002B/\u0005S\u0002\u0002Ba\u0018\u0003f\u0005\u0005\u0018\u0011]\u0007\u0003\u0005CR1Aa\u00191\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005O\u0012\tGA\u0002NCBDqAa\u001b%\u0001\u0004\u0011i'\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0005_\u0012II\u0004\u0003\u0003r\t\u0015e\u0002\u0002B:\u0005\u0007sAA!\u001e\u0003\u0002:!!q\u000fB@\u001d\u0011\u0011IH! \u000f\t\u0005\u001d(1P\u0005\u00029&\u0011!lW\u0005\u0003WeK!a\u0016-\n\u0007\u0005]g+\u0003\u0003\u0003\b\u0006U\u0017aE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$\u0018\u0002\u0002BF\u0005\u001b\u0013aaQ8oM&<'\u0002\u0002BD\u0003+$BA!\u0018\u0003\u0012\"9!1N\u0013A\u0002\tM\u0005\u0003\u0002BK\u0005CsAAa&\u0003\u001e6\u0011!\u0011\u0014\u0006\u0004\u000573\u0016aB7fgN\fw-Z\u0005\u0005\u0005?\u0013I*\u0001\u0012J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005G\u0013)KA\rBYR,'/\u00192mK\u000e{gNZ5h\u0007>dG.Z2uS>t'\u0002\u0002BP\u00053\u000bQCY;jY\u0012,eN^3m_B,'+Z:q_:\u001cX\r\u0006\u0004\u0003,\nE&Q\u0017\t\u0005\u0003'\u0014i+\u0003\u0003\u00030\u0006U'\u0001E#om\u0016dw\u000e]3SKN\u0004xN\\:f\u0011\u0019\u0011\u0019L\na\u0001u\u0006IQO\\<sCB\u0004X\r\u001a\u0005\b\u0005o3\u0003\u0019\u0001B]\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BAj\u0005wKAA!0\u0002V\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/\u001a")
public class RequestChannelTest {
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private final KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

        public byte[] serialize(KafkaPrincipal principal) {
            return principal.toString().getBytes(StandardCharsets.UTF_8);
        }

        public KafkaPrincipal deserialize(byte[] bytes) {
            return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
        }
    };

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private KafkaPrincipalSerde principalSerde() {
        return this.principalSerde;
    }

    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    @Test
    public void testSerializeRequest() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(brokerResource, new AlterConfigsRequest.Config((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)).asJava())), true).build(), this.request$default$2());
        ByteBuffer serialized = alterConfigs.serialize();
        Assertions.assertEquals((Object)alterConfigs.buffer().rewind(), (Object)serialized.rewind());
    }

    @Test
    public void testAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry keystoreLocation = new AlterConfigsRequest.ConfigEntry("ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeyPassword = new AlterConfigsRequest.ConfigEntry("listener.name.internal.ssl.key.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeyPassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeyPassword.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeystore = new AlterConfigsRequest.ConfigEntry("listener.name.internal.ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeystore, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeystore.name()), (Object)"/path/to/keystore")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainJaasConfig = new AlterConfigsRequest.ConfigEntry("listener.name.internal.plain.sasl.jaas.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainJaasConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainJaasConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainLoginCallback = new AlterConfigsRequest.ConfigEntry("listener.name.internal.plain.sasl.login.callback.handler.class", "test.LoginClass");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainLoginCallback, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainLoginCallback.name()), (Object)plainLoginCallback.value())})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry customConfig = new AlterConfigsRequest.ConfigEntry("custom.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        AlterConfigsRequest.ConfigEntry compressionType = new AlterConfigsRequest.ConfigEntry("compression.type", "lz4");
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)compressionType, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")})), sensitiveValue);
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.emptyMap(), true).build(), this.request$default$2());
        Assertions.assertEquals(Collections.emptyMap(), (Object)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs());
    }

    @Test
    public void testHealthCheckTotalTimeMs() {
        TenantMetadata healthCheckTenantMetadata = new TenantMetadata.Builder("ClusterId2", "UserResourceId2").healthcheckTenant(true).build();
        MultiTenantPrincipal healthCheckPrincipal = new MultiTenantPrincipal("user2", healthCheckTenantMetadata);
        long startTimeNanos = Time.SYSTEM.nanoseconds();
        RequestChannel.Metrics requestMetrics = new RequestChannel.Metrics(ApiMessageType.ListenerType.BROKER);
        DelayedActionQueue actionQueue = new DelayedActionQueue();
        RequestChannel.Request healthCheckRequest = this.buildProduceRequest(startTimeNanos, requestMetrics, (KafkaPrincipal)healthCheckPrincipal);
        RequestChannel.Response healthCheckResponse = this.buildProduceResponse(healthCheckRequest, (ActionQueue)actionQueue);
        RequestChannel.Request nonHealthCheckRequest = this.buildProduceRequest(startTimeNanos, requestMetrics, this.buildProduceRequest$default$3());
        RequestChannel.Response nonHealthCheckResponse = this.buildProduceResponse(nonHealthCheckRequest, (ActionQueue)actionQueue);
        healthCheckRequest.updateRequestMetrics(startTimeNanos, startTimeNanos, healthCheckResponse, (Option)None$.MODULE$, null, healthCheckRequest.updateRequestMetrics$default$6());
        nonHealthCheckRequest.updateRequestMetrics(startTimeNanos, startTimeNanos, nonHealthCheckResponse, (Option)None$.MODULE$, null, nonHealthCheckRequest.updateRequestMetrics$default$6());
        actionQueue.tryCompleteActions();
        RequestMetrics m = requestMetrics.apply(ApiKeys.PRODUCE.name);
        Assertions.assertEquals((long)1L, (long)m.healthCheckTotalTimeHist().count());
        Assertions.assertEquals((long)2L, (long)m.totalTimeHist().count());
    }

    private RequestChannel.Request buildProduceRequest(long startTimeNanos, RequestChannel.Metrics metrics, KafkaPrincipal principal) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(256), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        ProduceRequest.Builder requestBuilder = ProduceRequest.forMagic((byte)2, (ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(9).setRecords((BaseRecords)builder.build())))).iterator())).setAcks((short)1).setTimeoutMs(5000));
        return this.requestWithMetrics(requestBuilder.build(), metrics, startTimeNanos, principal);
    }

    private KafkaPrincipal buildProduceRequest$default$3() {
        return new KafkaPrincipal("User", "user");
    }

    private RequestChannel.Response buildProduceResponse(RequestChannel.Request request, ActionQueue actionQueue) {
        ProduceResponse rawProduceResponse = new ProduceResponse(new ProduceResponseData());
        return new RequestChannel.SendResponse(request, request.buildResponseSend((AbstractResponse)rawProduceResponse, actionQueue), (Option)None$.MODULE$);
    }

    @Test
    public void testIncrementalAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Map keystorePassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, (Map)keystoreLocation.$plus$plus((IterableOnce)keystorePassword), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeyPassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.key.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeyPassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.key.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeystore = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeystore, listenerKeystore, sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.plain.sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainJaasConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.plain.sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
        Map plainLoginCallback = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.plain.sasl.login.callback.handler.class"), (Object)"test.LoginClass")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainLoginCallback, plainLoginCallback, sensitiveValue);
        Map sslProtocols = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.APPEND, sslProtocols, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SUBTRACT, sslProtocols, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        Map cipherSuites = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.cipher.suites"), null)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.DELETE, cipherSuites, cipherSuites, sensitiveValue);
        Map customConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        Map compressionType = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")}));
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, compressionType, compressionType, sensitiveValue);
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource linkResource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "link1");
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, (Map)keystoreLocation.$plus$plus((IterableOnce)keystorePassword), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map linkJaasConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, linkJaasConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testCreateClusterLinks() {
        String sensitiveValue = "secret";
        Map keystorePassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfigs$1(keystorePassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfigs$1(keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfigs$1((Map)keystoreLocation.$plus$plus((IterableOnce)keystorePassword), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfigs$1(plainJaasConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testNonAlterRequestsNotTransformed() {
        RequestChannel.Request metadataRequest = this.request(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"topic", (List)Nil$.MODULE$)).asJava(), true).build(), this.request$default$2());
        Assertions.assertSame((Object)metadataRequest.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl())), (Object)metadataRequest.loggableRequest());
    }

    @Test
    public void testJsonRequests() {
        String sensitiveValue = "secret";
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        .colon.colon entries = new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)entries).asJavaCollection())), true).build(), this.request$default$2());
        Assertions.assertTrue((boolean)this.isValidJson(RequestConvertToJson$.MODULE$.request(alterConfigs.loggableRequest()).toString()));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED", "NOT_CONTROLLER"})
    public void testBuildEnvelopeResponse(Errors error) {
        String topic = "foo";
        CreateTopicsRequest createTopicRequest = this.buildCreateTopicRequest(topic);
        RequestChannel.Request unwrapped = this.buildUnwrappedEnvelopeRequest((AbstractRequest)createTopicRequest);
        CreateTopicsResponse createTopicResponse = this.buildCreateTopicResponse(topic, error);
        EnvelopeResponse envelopeResponse = this.buildEnvelopeResponse(unwrapped, (AbstractResponse)createTopicResponse);
        if (Errors.NOT_CONTROLLER.equals(error)) {
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)envelopeResponse.error());
            Assertions.assertNull((Object)envelopeResponse.responseData());
            return;
        }
        Assertions.assertEquals((Object)Errors.NONE, (Object)envelopeResponse.error());
        AbstractResponse unwrappedResponse = AbstractResponse.parseResponse((ByteBuffer)envelopeResponse.responseData(), (RequestHeader)unwrapped.header(), (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)createTopicResponse.data(), (Object)unwrappedResponse.data());
    }

    private RequestChannel.Request buildLeaderAndIsrRequest(long startTimeNanos, RequestChannel.Metrics metrics, KafkaPrincipal principal) {
        String topic = "LeaderAndIsr";
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic, Uuid.randomUuid());
        short version = ApiKeys.LEADER_AND_ISR.latestVersion();
        LeaderAndIsrRequest leaderAndIsrRequest = new LeaderAndIsrRequest.Builder(version, 1, 0, startTimeNanos, Collections.singletonList(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(15).setLeader(1).setLeaderEpoch(20)), topicIds, false, Collections.emptySet(), true).build(version);
        return this.requestWithMetrics((AbstractRequest)leaderAndIsrRequest, metrics, startTimeNanos, principal);
    }

    private KafkaPrincipal buildLeaderAndIsrRequest$default$3() {
        return new KafkaPrincipal("User", "user");
    }

    private RequestChannel.Response buildLeaderAndIsrResponse(RequestChannel.Request request, ActionQueue actionQueue) {
        LeaderAndIsrResponse rawLeaderAndIsrResponse = new LeaderAndIsrResponse(new LeaderAndIsrResponseData(), ApiKeys.LEADER_AND_ISR.latestVersion());
        return new RequestChannel.SendResponse(request, request.buildResponseSend((AbstractResponse)rawLeaderAndIsrResponse, actionQueue), (Option)None$.MODULE$);
    }

    private RequestChannel.Request buildUpdateMetadataRequest(long startTimeNanos, RequestChannel.Metrics metrics, KafkaPrincipal principal) {
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        String topic = "foo";
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        ArrayList brokerHealthStates = new ArrayList();
        topicIds.put(topic, Uuid.randomUuid());
        ArrayList cells = new ArrayList();
        ArrayList liveBrokers = new ArrayList();
        UpdateMetadataRequest updateMetadataRequest = new UpdateMetadataRequest.Builder(version, 0, 0, startTimeNanos, brokerHealthStates, Collections.singletonList(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(0).setLeader(1)), liveBrokers, topicIds, cells, false).build(version);
        return this.requestWithMetrics((AbstractRequest)updateMetadataRequest, metrics, startTimeNanos, principal);
    }

    private KafkaPrincipal buildUpdateMetadataRequest$default$3() {
        return new KafkaPrincipal("User", "user");
    }

    private RequestChannel.Response buildUpdateMetadataResponse(RequestChannel.Request request, ActionQueue actionQueue) {
        UpdateMetadataResponse rawUpdateMetadataResponse = new UpdateMetadataResponse(new UpdateMetadataResponseData());
        return new RequestChannel.SendResponse(request, request.buildResponseSend((AbstractResponse)rawUpdateMetadataResponse, actionQueue), (Option)None$.MODULE$);
    }

    @Test
    public void testExcludeLeaderAndIsrRequestFromBrokerLoadCalculation() {
        long startTimeNanos = Time.SYSTEM.nanoseconds();
        RequestChannel.Metrics requestMetrics = new RequestChannel.Metrics(ApiMessageType.ListenerType.ZK_BROKER);
        DelayedActionQueue actionQueue = new DelayedActionQueue();
        RequestChannel.Request request = this.buildLeaderAndIsrRequest(startTimeNanos, requestMetrics, this.buildLeaderAndIsrRequest$default$3());
        RequestChannel.Response response = this.buildLeaderAndIsrResponse(request, (ActionQueue)actionQueue);
        BrokerLoad brokerLoad = (BrokerLoad)Mockito.mock(BrokerLoad.class);
        request.updateRequestMetrics(startTimeNanos, startTimeNanos, response, (Option)new Some((Object)brokerLoad), null, request.updateRequestMetrics$default$6());
        ((BrokerLoad)Mockito.verify((Object)brokerLoad, (VerificationMode)Mockito.times((int)0))).recordRequestTimeNanos(null, startTimeNanos);
    }

    @Test
    public void testExcludeUpdateMetadataFromBrokerLoadCalculation() {
        long startTimeNanos = Time.SYSTEM.nanoseconds();
        RequestChannel.Metrics requestMetrics = new RequestChannel.Metrics(ApiMessageType.ListenerType.ZK_BROKER);
        DelayedActionQueue actionQueue = new DelayedActionQueue();
        RequestChannel.Request request = this.buildUpdateMetadataRequest(startTimeNanos, requestMetrics, this.buildUpdateMetadataRequest$default$3());
        RequestChannel.Response response = this.buildUpdateMetadataResponse(request, (ActionQueue)actionQueue);
        BrokerLoad brokerLoad = (BrokerLoad)Mockito.mock(BrokerLoad.class);
        request.updateRequestMetrics(startTimeNanos, startTimeNanos, response, (Option)new Some((Object)brokerLoad), null, request.updateRequestMetrics$default$6());
        ((BrokerLoad)Mockito.verify((Object)brokerLoad, (VerificationMode)Mockito.times((int)0))).recordRequestTimeNanos(null, startTimeNanos);
    }

    private CreateTopicsRequest buildCreateTopicRequest(String topic) {
        CreateTopicsRequestData requestData = new CreateTopicsRequestData();
        requestData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topic).setReplicationFactor((short)-1).setNumPartitions(-1));
        return (CreateTopicsRequest)new CreateTopicsRequest.Builder(requestData).build();
    }

    private CreateTopicsResponse buildCreateTopicResponse(String topic, Errors error) {
        CreateTopicsResponseData responseData = new CreateTopicsResponseData();
        responseData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topic).setErrorCode(error.code()));
        return new CreateTopicsResponse(responseData);
    }

    private RequestChannel.Request buildUnwrappedEnvelopeRequest(AbstractRequest request2) {
        RequestChannel.Request wrappedRequest = TestUtils$.MODULE$.buildEnvelopeRequest(request2, this.principalSerde(), this.requestChannelMetrics(), System.nanoTime(), -1L, true);
        AtomicReference unwrappedRequest = new AtomicReference();
        EnvelopeUtils$.MODULE$.handleEnvelopeRequest(wrappedRequest, this.requestChannelMetrics(), (Function1 & Serializable)request -> {
            unwrappedRequest.set(request);
            return BoxedUnit.UNIT;
        });
        return (RequestChannel.Request)unwrappedRequest.get();
    }

    private boolean isValidJson(String str) {
        try {
            new ObjectMapper().readTree(str);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public RequestChannel.Request requestWithMetrics(AbstractRequest req, RequestChannel.Metrics metrics, long startTimeNanos, KafkaPrincipal principal) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer, principal);
        return new RequestChannel.Request(1, requestContext, startTimeNanos, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, metrics, (Option)None$.MODULE$, Context.root(), NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    public RequestChannel.Request request(AbstractRequest req, KafkaPrincipal principal) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer, principal);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class), (Option)None$.MODULE$, Context.root(), NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    public long requestWithMetrics$default$3() {
        return 0L;
    }

    public KafkaPrincipal requestWithMetrics$default$4() {
        return new KafkaPrincipal("User", "user");
    }

    public KafkaPrincipal request$default$2() {
        return new KafkaPrincipal("User", "user");
    }

    private RequestContext newRequestContext(ByteBuffer buffer, KafkaPrincipal principal) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), null, false);
    }

    private Map<String, String> toMap(AlterConfigsRequest.Config config) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(config.entries()).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, String> toMap(IncrementalAlterConfigsRequestData.AlterableConfigCollection config) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)config).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private EnvelopeResponse buildEnvelopeResponse(RequestChannel.Request unwrapped, AbstractResponse response) {
        Assertions.assertTrue((boolean)unwrapped.envelope().isDefined());
        RequestChannel.Request envelope = (RequestChannel.Request)unwrapped.envelope().get();
        DelayedActionQueue actionQueue = new DelayedActionQueue();
        Send send = unwrapped.buildResponseSend(response, (ActionQueue)actionQueue);
        actionQueue.tryCompleteActions();
        ByteBuffer sendBytes = TestUtils.toBuffer((Send)send);
        Assertions.assertEquals((int)sendBytes.getInt(), (int)sendBytes.remaining());
        AbstractResponse envelopeResponse = AbstractResponse.parseResponse((ByteBuffer)sendBytes, (RequestHeader)envelope.header(), (MessageContext)MessageContext.IDENTITY);
        Assertions.assertTrue((boolean)(envelopeResponse instanceof EnvelopeResponse));
        return (EnvelopeResponse)envelopeResponse;
    }

    private final void verifyConfig$1(ConfigResource resource, Seq entries, Map expectedValues, String sensitiveValue$1) {
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)entries).asJavaCollection())), true).build(), this.request$default$2());
        AlterConfigsRequest.Config loggedConfig = (AlterConfigsRequest.Config)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs().get(resource);
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$1), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterRequests$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs$1, AlterConfigOp.OpType op$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            String value = (String)x0$1._2();
            return alterableConfigs$1.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(name).setValue(value).setConfigOperation(op$1.id()));
        }
        throw new MatchError(null);
    }

    private static final IncrementalAlterConfigsRequest incrementalAlterConfigs$1(ConfigResource resource, Map entries, AlterConfigOp.OpType op) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        entries.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestChannelTest.$anonfun$testIncrementalAlterRequests$1(alterableConfigs, op, x0$1)));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resource.name()).setResourceType(resource.type().id()).setConfigs(alterableConfigs));
        return (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(data).build();
    }

    private final void verifyConfig$2(ConfigResource resource, AlterConfigOp.OpType op, Map entries, Map expectedValues, String sensitiveValue$2) {
        RequestChannel.Request alterConfigs = this.request((AbstractRequest)RequestChannelTest.incrementalAlterConfigs$1(resource, entries, op), this.request$default$2());
        IncrementalAlterConfigsRequestData.AlterableConfigCollection loggedConfig = ((IncrementalAlterConfigsRequest)alterConfigs.loggableRequest()).data().resources().find(resource.type().id(), resource.name()).configs();
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$2), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    private final void verifyConfigs$1(Map requestConfigs, Map expectedLoggedConfigs, String sensitiveValue$3) {
        Set<NewClusterLink> link = Collections.singleton(new NewClusterLink("linkName", "clusterId", CollectionConverters$.MODULE$.MapHasAsJava(requestConfigs).asJava()));
        CreateClusterLinksRequest createRequest = (CreateClusterLinksRequest)new CreateClusterLinksRequest.Builder(link, false, false, 10000).build();
        RequestChannel.Request createLinks = this.request((AbstractRequest)createRequest, this.request$default$2());
        CreateClusterLinksRequest loggableRequest = (CreateClusterLinksRequest)createLinks.loggableRequest();
        scala.collection.mutable.Map loggedConfigs = CollectionConverters$.MODULE$.MapHasAsScala(((NewClusterLink)CollectionConverters$.MODULE$.CollectionHasAsScala(loggableRequest.newClusterLinks()).asScala().head()).configs()).asScala();
        Assertions.assertEquals((Object)expectedLoggedConfigs, (Object)loggedConfigs);
        String createLinksDesc = RequestConvertToJson$.MODULE$.requestDesc(createLinks.header(), createLinks.requestLog(), true).toString();
        Assertions.assertFalse((boolean)createLinksDesc.contains(sensitiveValue$3), (String)new StringBuilder(24).append("Sensitive config logged ").append(createLinksDesc).toString());
    }
}

