/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import io.opentelemetry.context.Context;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import kafka.network.PrincipalConvertToJson$;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.AppendRecordsRequestData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.RequestHeaderDataJsonConverter;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AppendRecordsRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AdaptiveSampler;
import org.apache.kafka.common.utils.LogAction;
import org.apache.kafka.common.utils.SlowLogAction;
import org.apache.kafka.common.utils.TimeBasedSampler;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBQA\n\u0001\u0005\u0002\u001dBQ\u0001\u000f\u0001\u0005\u0002\u001dBQA\u000f\u0001\u0005\u0002\u001dBQ\u0001\u0010\u0001\u0005\u0002\u001dBQA\u0010\u0001\u0005\u0002\u001dBQ\u0001\u0011\u0001\u0005\u0002\u001dBQA\u0011\u0001\u0005\u0002\u001dBQ\u0001\u0012\u0001\u0005\u0002\u001dBQA\u0012\u0001\u0005\u0002\u001dBQ\u0001\u0013\u0001\u0005\u0002\u001dBQA\u0013\u0001\u0005\u0002\u001dBQ\u0001\u0014\u0001\u0005\u0002\u001dBQA\u0014\u0001\u0005\u0002\u001dBQ\u0001\u0015\u0001\u0005\nECQ!\u0019\u0001\u0005\n\tDQA\u001d\u0001\u0005\nMDQ!\u001f\u0001\u0005\niDq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u00024\u0001!I!!\u000e\u00031I+\u0017/^3ti\u000e{gN^3siR{'j]8o)\u0016\u001cHO\u0003\u0002\u00181\u00059a.\u001a;x_J\\'\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u00051\u0012A\u0007;fgR\fE\u000e\u001c*fcV,7\u000f\u001e+za\u0016\u001c\b*\u00198eY\u0016$G#\u0001\u0015\u0011\u0005uI\u0013B\u0001\u0016\u001f\u0005\u0011)f.\u001b;)\u0005\ta\u0003CA\u00177\u001b\u0005q#BA\u00181\u0003\r\t\u0007/\u001b\u0006\u0003cI\nqA[;qSR,'O\u0003\u00024i\u0005)!.\u001e8ji*\tQ'A\u0002pe\u001eL!a\u000e\u0018\u0003\tQ+7\u000f^\u0001\"i\u0016\u001cH/\u00117m\u0003BLg+\u001a:tS>t7OU3ta>t7/\u001a%b]\u0012dW\r\u001a\u0015\u0003\u00071\n1\u0004^3ti\u0006cGNU3ta>t7/\u001a+za\u0016\u001c\b*\u00198eY\u0016$\u0007F\u0001\u0003-\u0003U!Xm\u001d;SKF,Xm\u001d;IK\u0006$WM\u001d(pI\u0016D#!\u0002\u0017\u0002[Q,7\u000f\u001e*fcV,7\u000f\u001e%fC\u0012,'OT8eK^KG\u000f\u001b#faJ,7-\u0019;fI\u0006\u0003\u0018NV3sg&|g\u000e\u000b\u0002\u0007Y\u0005\u0011B/Z:u\u00072LWM\u001c;J]\u001a|gj\u001c3fQ\t9A&A\buKN$(+Z9vKN$H)Z:dQ\tAA&\u0001\fuKN$(+Z9vKN$H)Z:d\u001b\u0016$(/[2tQ\tIA&\u0001\nuKN$8\u000b\\8x\u0019><'+Z9EKN\u001c\u0007F\u0001\u0006-\u0003\u001d\"Xm\u001d;BaB,g\u000e\u001a*fG>\u0014Hm\u001d*fcV,7\u000f\u001e'pON\u0014VmY8sIN\u001c\u0016N_3)\u0005-a\u0013\u0001\t;fgR\\\u0015MZ6b!JLgnY5qC2T5o\u001c8D_:4XM]:j_:D#\u0001\u0004\u0017\u0002IQ,7\u000f^\"p]\u001adW/\u001a8u!JLgnY5qC2T5o\u001c8D_:4XM]:j_:D#!\u0004\u0017\u0002CQ,7\u000f\u001e+f]\u0006tG\u000f\u0015:j]\u000eL\u0007/\u00197Kg>t7i\u001c8wKJ\u001c\u0018n\u001c8)\u00059a\u0013aE1tg\u0016\u0014H\u000f\u0015:j]\u000eL\u0007/\u00197Kg>tGC\u0001\u0015S\u0011\u0015\u0019v\u00021\u0001U\u0003%\u0001(/\u001b8dSB\fG\u000e\u0005\u0002V?6\taK\u0003\u0002X1\u0006!\u0011-\u001e;i\u0015\tI&,\u0001\u0005tK\u000e,(/\u001b;z\u0015\tYF,\u0001\u0004d_6lwN\u001c\u0006\u00033uS!A\u0018\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u0001gK\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u00021\u0005\u001c8/\u001a:u\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0015N|g\u000eF\u0002)G\u0012DQa\u0015\tA\u0002QCQ!\u001a\tA\u0002\u0019\fAA[:p]B\u0011q\r]\u0007\u0002Q*\u0011\u0011N[\u0001\tI\u0006$\u0018MY5oI*\u00111\u000e\\\u0001\bU\u0006\u001c7n]8o\u0015\tig.A\u0005gCN$XM\u001d=nY*\tq.A\u0002d_6L!!\u001d5\u0003\u0011)\u001bxN\u001c(pI\u0016\fA$Y:tKJ$8i\u001c8gYV,g\u000e\u001e)sS:\u001c\u0017\u000e]1m\u0015N|g\u000eF\u0002)ibDQaU\tA\u0002U\u0004\"!\u0016<\n\u0005]4&AE\"p]\u001adW/\u001a8u!JLgnY5qC2DQ!Z\tA\u0002\u0019\f\u0011$Y:tKJ$H+\u001a8b]R\u0004&/\u001b8dSB\fGNS:p]R!\u0001f_A\b\u0011\u0015\u0019&\u00031\u0001}!\ri\u00181B\u0007\u0002}*\u0019q0!\u0001\u0002\u00175,H\u000e^5uK:\fg\u000e\u001e\u0006\u00043\u0005\r!\u0002BA\u0003\u0003\u000f\t\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005%\u0011AA5p\u0013\r\tiA \u0002\u0015\u001bVdG/\u001b+f]\u0006tG\u000f\u0015:j]\u000eL\u0007/\u00197\t\u000b\u0015\u0014\u0002\u0019\u00014\u0002\u000fI,\u0017/^3tiR!\u0011QCA\u0012!\u0011\t9\"!\b\u000f\u0007\u0015\nI\"C\u0002\u0002\u001cY\taBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0003\u0002 \u0005\u0005\"a\u0002*fcV,7\u000f\u001e\u0006\u0004\u000371\u0002bBA\u0013'\u0001\u0007\u0011qE\u0001\u0004e\u0016\f\b\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055\",\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\t$a\u000b\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgR\f\u0011C\\3x%\u0016\fX/Z:u\u0007>tG/\u001a=u)\u0011\t9$!\u0010\u0011\t\u0005%\u0012\u0011H\u0005\u0005\u0003w\tYC\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000f\u0005}B\u00031\u0001\u0002B\u00051!-\u001e4gKJ\u0004B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0002oS>T!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n)E\u0001\u0006CsR,')\u001e4gKJ\u0004")
public class RequestConvertToJsonTest {
    @Test
    public void testAllRequestTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values()), (Function1 & Serializable)key -> {
            short version = key.latestVersion();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)(ApiKeys.DESCRIBE_ACLS.equals(key) ? ((DescribeAclsRequestData)ApiMessageType.fromApiKey((short)key.id).newRequest()).setPatternTypeFilter((byte)1).setResourceTypeFilter((byte)1).setPermissionType((byte)1).setOperation((byte)1) : ApiMessageType.fromApiKey((short)key.id).newRequest()), (short)version);
            AbstractRequest req = AbstractRequest.parseRequest((ApiKeys)key, (short)version, (ByteBuffer)bytes, (MessageContext)MessageContext.IDENTITY).request;
            try {
                return RequestConvertToJson$.MODULE$.request(req);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled request keys");
    }

    @Test
    public void testAllApiVersionsResponseHandled() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values()), (Function1 & Serializable)key -> {
            RequestConvertToJsonTest.$anonfun$testAllApiVersionsResponseHandled$1(key);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAllResponseTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values()), (Function1 & Serializable)key -> {
            short version = key.latestVersion();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)ApiMessageType.fromApiKey((short)key.id).newResponse(), (short)version);
            AbstractResponse res = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes, (short)version, (MessageContext)MessageContext.IDENTITY);
            try {
                return RequestConvertToJson$.MODULE$.response(res, version);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled response keys");
    }

    @Test
    public void testRequestHeaderNode() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestHeader header = this.request((AbstractRequest)alterIsrRequest).header();
        ObjectNode expectedNode = (ObjectNode)RequestHeaderDataJsonConverter.write((RequestHeaderData)header.data(), (short)header.headerVersion(), (boolean)false);
        expectedNode.set("requestApiKeyName", (JsonNode)new TextNode(header.apiKey().toString()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestHeaderNode(header);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestHeaderNodeWithDeprecatedApiVersion() {
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)0, (int)0, (int)0, Collections.emptyMap()).build((short)0);
        RequestHeader header = this.request((AbstractRequest)fetchRequest).header();
        ObjectNode expectedNode = (ObjectNode)RequestHeaderDataJsonConverter.write((RequestHeaderData)header.data(), (short)header.headerVersion(), (boolean)false);
        expectedNode.set("requestApiKeyName", (JsonNode)new TextNode(header.apiKey().toString()));
        expectedNode.set("requestApiVersionDeprecated", (JsonNode)BooleanNode.TRUE);
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestHeaderNode(header);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testClientInfoNode() {
        ClientInformation clientInfo = new ClientInformation("name", "1");
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("softwareName", (JsonNode)new TextNode(clientInfo.softwareName()));
        expectedNode.set("softwareVersion", (JsonNode)new TextNode(clientInfo.softwareVersion()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.clientInfoNode(clientInfo);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDesc() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("isForwarded", (JsonNode)(req.isForwarded() ? BooleanNode.TRUE : BooleanNode.FALSE));
        expectedNode.set("requestHeader", RequestConvertToJson$.MODULE$.requestHeaderNode(req.header()));
        expectedNode.set("request", (JsonNode)req.requestLog().getOrElse((Function0 & Serializable)() -> new TextNode("")));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDescMetrics() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        boolean totalTimeMs = true;
        int requestQueueTimeMs = 2;
        int apiLocalTimeMs = 3;
        int apiRemoteTimeMs = 4;
        int apiThrottleTimeMs = 5;
        int responseQueueTimeMs = 6;
        int responseSendTimeMs = 7;
        int responseSendIoTimeMs = 8;
        int responseSizeBytes = 9;
        int temporaryMemoryBytes = 10;
        int messageConversionsTimeMs = 11;
        ObjectNode expectedPrincipalNode = new ObjectNode(JsonNodeFactory.instance);
        expectedPrincipalNode.set("class", (JsonNode)new TextNode("KafkaPrincipal"));
        expectedPrincipalNode.set("type", (JsonNode)new TextNode("User"));
        expectedPrincipalNode.set("name", (JsonNode)new TextNode("user"));
        expectedPrincipalNode.set("tokenAuthenticated", (JsonNode)BooleanNode.FALSE);
        ObjectNode expectedNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        expectedNode.set("response", (JsonNode)req.responseLog().getOrElse((Function0 & Serializable)() -> new TextNode("")));
        expectedNode.set("connection", (JsonNode)new TextNode(req.context().connectionId));
        expectedNode.set("clientAddress", (JsonNode)new TextNode(req.context().clientAddress.getHostAddress()));
        expectedNode.set("totalTimeMs", (JsonNode)new DoubleNode((double)totalTimeMs));
        expectedNode.set("requestQueueTimeMs", (JsonNode)new DoubleNode((double)requestQueueTimeMs));
        expectedNode.set("localTimeMs", (JsonNode)new DoubleNode((double)apiLocalTimeMs));
        expectedNode.set("remoteTimeMs", (JsonNode)new DoubleNode((double)apiRemoteTimeMs));
        expectedNode.set("throttleTimeMs", (JsonNode)new LongNode((long)apiThrottleTimeMs));
        expectedNode.set("responseQueueTimeMs", (JsonNode)new DoubleNode((double)responseQueueTimeMs));
        expectedNode.set("sendTimeMs", (JsonNode)new DoubleNode((double)responseSendTimeMs));
        expectedNode.set("sendIoTimeMs", (JsonNode)new DoubleNode((double)responseSendIoTimeMs));
        expectedNode.set("responseSize", (JsonNode)new LongNode((long)responseSizeBytes));
        expectedNode.set("securityProtocol", (JsonNode)new TextNode(req.context().securityProtocol.toString()));
        expectedNode.set("principal", (JsonNode)expectedPrincipalNode);
        expectedNode.set("listener", (JsonNode)new TextNode(req.context().listenerName.value()));
        expectedNode.set("clientInformation", RequestConvertToJson$.MODULE$.clientInfoNode(req.context().clientInformation));
        expectedNode.set("temporaryMemoryBytes", (JsonNode)new LongNode((long)temporaryMemoryBytes));
        expectedNode.set("messageConversionsTime", (JsonNode)new DoubleNode((double)messageConversionsTimeMs));
        expectedNode.set("isDisconnectedClient", (JsonNode)BooleanNode.TRUE);
        ObjectNode actualNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDescMetrics(req.header(), req.requestLog(), req.responseLog(), req.context(), req.session(), req.isForwarded(), (double)totalTimeMs, (double)requestQueueTimeMs, (double)apiLocalTimeMs, (double)apiRemoteTimeMs, (long)apiThrottleTimeMs, (double)responseQueueTimeMs, (double)responseSendTimeMs, (double)responseSendIoTimeMs, (long)responseSizeBytes, (long)temporaryMemoryBytes, (double)messageConversionsTimeMs, true, LogAction.LOGGED, 0.0);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testSlowLogReqDesc() {
        ProduceRequest produceRequest = new ProduceRequest(new ProduceRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)produceRequest);
        AdaptiveSampler slowLogSampler = new AdaptiveSampler(false, 48L);
        boolean totalTimeMs = true;
        int requestQueueTimeMs = 2;
        int apiLocalTimeMs = 3;
        int apiRemoteTimeMs = 4;
        int apiThrottleTimeMs = 5;
        int responseQueueTimeMs = 6;
        int responseSendTimeMs = 7;
        int responseSendIoTimeMs = 8;
        int responseSizeBytes = 9;
        int temporaryMemoryBytes = 10;
        int messageConversionsTimeMs = 11;
        int slowLogThresholdOverride = -1;
        int minP99SlowLogThreshold = -1;
        ObjectNode expectedPrincipalNode = new ObjectNode(JsonNodeFactory.instance);
        expectedPrincipalNode.set("class", (JsonNode)new TextNode("KafkaPrincipal"));
        expectedPrincipalNode.set("type", (JsonNode)new TextNode("User"));
        expectedPrincipalNode.set("name", (JsonNode)new TextNode("user"));
        expectedPrincipalNode.set("tokenAuthenticated", (JsonNode)BooleanNode.FALSE);
        ObjectNode expectedNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        expectedNode.set("response", (JsonNode)req.responseLog().getOrElse((Function0 & Serializable)() -> new TextNode("")));
        expectedNode.set("connection", (JsonNode)new TextNode(req.context().connectionId));
        expectedNode.set("clientAddress", (JsonNode)new TextNode(req.context().clientAddress.getHostAddress()));
        expectedNode.set("totalTimeMs", (JsonNode)new DoubleNode((double)totalTimeMs));
        expectedNode.set("requestQueueTimeMs", (JsonNode)new DoubleNode((double)requestQueueTimeMs));
        expectedNode.set("localTimeMs", (JsonNode)new DoubleNode((double)apiLocalTimeMs));
        expectedNode.set("remoteTimeMs", (JsonNode)new DoubleNode((double)apiRemoteTimeMs));
        expectedNode.set("throttleTimeMs", (JsonNode)new LongNode((long)apiThrottleTimeMs));
        expectedNode.set("responseQueueTimeMs", (JsonNode)new DoubleNode((double)responseQueueTimeMs));
        expectedNode.set("sendTimeMs", (JsonNode)new DoubleNode((double)responseSendTimeMs));
        expectedNode.set("sendIoTimeMs", (JsonNode)new DoubleNode((double)responseSendIoTimeMs));
        expectedNode.set("responseSize", (JsonNode)new LongNode((long)responseSizeBytes));
        expectedNode.set("securityProtocol", (JsonNode)new TextNode(req.context().securityProtocol.toString()));
        expectedNode.set("principal", (JsonNode)expectedPrincipalNode);
        expectedNode.set("listener", (JsonNode)new TextNode(req.context().listenerName.value()));
        expectedNode.set("clientInformation", RequestConvertToJson$.MODULE$.clientInfoNode(req.context().clientInformation));
        expectedNode.set("isDisconnectedClient", (JsonNode)BooleanNode.TRUE);
        expectedNode.set("temporaryMemoryBytes", (JsonNode)new LongNode((long)temporaryMemoryBytes));
        expectedNode.set("messageConversionsTime", (JsonNode)new DoubleNode((double)messageConversionsTimeMs));
        expectedNode.set("isSlowLog", (JsonNode)BooleanNode.TRUE);
        expectedNode.set("slowLogThreshold", (JsonNode)new DoubleNode(100.0));
        ObjectNode actualNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDescMetrics(req.header(), req.requestLog(), req.responseLog(), req.context(), req.session(), req.isForwarded(), (double)totalTimeMs, (double)requestQueueTimeMs, (double)apiLocalTimeMs, (double)apiRemoteTimeMs, (long)apiThrottleTimeMs, (double)responseQueueTimeMs, (double)responseSendTimeMs, (double)responseSendIoTimeMs, (long)responseSizeBytes, (long)temporaryMemoryBytes, (double)messageConversionsTimeMs, true, (LogAction)new SlowLogAction((TimeBasedSampler)slowLogSampler, Predef$.MODULE$.double2Double((double)slowLogThresholdOverride), Predef$.MODULE$.double2Double((double)minP99SlowLogThreshold)), 100.0);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testAppendRecordsRequestLogsRecordsSize() {
        int recordsSize = 1024;
        ByteBuffer readableRecords_buffer = ByteBuffer.allocate(recordsSize);
        Object var5_2 = null;
        MemoryRecords records = new MemoryRecords(readableRecords_buffer);
        AppendRecordsRequestData appendRecordsRequestData = new AppendRecordsRequestData().setTopics(Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId(Uuid.ZERO_UUID).setPartitions(Collections.singletonList(new AppendRecordsRequestData.PartitionData().setRecords((BaseRecords)records)))));
        JsonNode requestNode = RequestConvertToJson$.MODULE$.request(new AppendRecordsRequest.Builder(appendRecordsRequestData).build());
        Assertions.assertEquals((Object)new IntNode(recordsSize), (Object)requestNode.at("/topics/0/partitions/0/recordsSizeInBytes"));
    }

    @Test
    public void testKafkaPrincipalJsonConversion() {
        this.assertPrincipalJson(KafkaPrincipal.ANONYMOUS);
        this.assertPrincipalJson(new KafkaPrincipal("User", "userfoo"));
        this.assertPrincipalJson(new KafkaPrincipal("group", "userfoo"));
        this.assertPrincipalJson(new KafkaPrincipal("User", "userbar", true));
        this.assertPrincipalJson(new KafkaPrincipal("group", "userbar", false));
    }

    @Test
    public void testConfluentPrincipalJsonConversion() {
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("User", "userfoo", "authfoo"));
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("group", "userbar", "authfoo", false));
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("User", "userbar", "authfoo", true));
    }

    @Test
    public void testTenantPrincipalJsonConversion() {
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1("clusterfoo", "orgfoo", "envfoo", false, false, false)));
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1("clusterbar", "orgfoo", "envfoo", false, false, false)));
        String x$2 = "clusterfoo";
        String x$3 = "orgfoo";
        boolean x$4 = false;
        boolean x$5 = false;
        boolean x$6 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1(x$2, x$3, "envbar", x$4, x$5, x$6)));
        String x$8 = "clusterfoo";
        String x$9 = "envfoo";
        boolean x$10 = false;
        boolean x$11 = false;
        boolean x$12 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$8, "orgbar", x$9, x$10, x$11, x$12)));
        String x$14 = "clusterfoo";
        String x$15 = "orgfoo";
        String x$16 = "envfoo";
        boolean x$17 = false;
        boolean x$18 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1(x$14, x$15, x$16, true, x$17, x$18)));
        String x$20 = "clusterfoo";
        String x$21 = "orgfoo";
        String x$22 = "envfoo";
        boolean x$23 = false;
        boolean x$24 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$20, x$21, x$22, x$23, true, x$24)));
        String x$26 = "clusterfoo";
        String x$27 = "orgfoo";
        String x$28 = "envfoo";
        boolean x$29 = false;
        boolean x$30 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$26, x$27, x$28, x$29, x$30, true)));
    }

    private void assertPrincipalJson(KafkaPrincipal principal) {
        JsonNode jsonNode = PrincipalConvertToJson$.MODULE$.convert(principal);
        if (principal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)principal;
            this.assertTenantPrincipalJson(multiTenantPrincipal, jsonNode);
            return;
        }
        if (principal instanceof ConfluentPrincipal) {
            ConfluentPrincipal confluentPrincipal = (ConfluentPrincipal)principal;
            this.assertConfluentPrincipalJson(confluentPrincipal, jsonNode);
            return;
        }
        if (principal != null) {
            this.assertKafkaPrincipalJson(principal, jsonNode);
            return;
        }
        throw new MatchError(null);
    }

    private void assertKafkaPrincipalJson(KafkaPrincipal principal, JsonNode json) {
        Assertions.assertEquals((Object)principal.getClass().getSimpleName(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalClassKey()).textValue());
        Assertions.assertEquals((Object)principal.getPrincipalType(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalTypeKey()).textValue());
        Assertions.assertEquals((Object)principal.getName(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalNameKey()).textValue());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tokenAuthenticated()), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.TokenAuthenticatedKey()).booleanValue()));
    }

    private void assertConfluentPrincipalJson(ConfluentPrincipal principal, JsonNode json) {
        this.assertKafkaPrincipalJson((KafkaPrincipal)principal, json);
        Assertions.assertEquals((Object)principal.authenticationId(), (Object)json.get(PrincipalConvertToJson$.MODULE$.AuthenticationIdKey()).textValue());
    }

    private void assertTenantPrincipalJson(MultiTenantPrincipal principal, JsonNode json) {
        this.assertConfluentPrincipalJson((ConfluentPrincipal)principal, json);
        Assertions.assertEquals((Object)principal.user(), (Object)json.get(PrincipalConvertToJson$.MODULE$.UserKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().tenantName, (Object)json.get(PrincipalConvertToJson$.MODULE$.TenantNameKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().clusterId, (Object)json.get(PrincipalConvertToJson$.MODULE$.ClusterIdKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().organizationId, (Object)json.get(PrincipalConvertToJson$.MODULE$.OrganizationIdKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().environmentId, (Object)json.get(PrincipalConvertToJson$.MODULE$.EnvironmentIdKey()).textValue());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isServiceAccount), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsServiceAccountKey()).booleanValue()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isApiKeyAuthenticated), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsApiKeyAuthenticatedKey()).booleanValue()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isHealthcheckTenant), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsHealthcheckTenantKey()).booleanValue()));
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class), (Option)None$.MODULE$, Context.root(), NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), null, false);
    }

    public static final /* synthetic */ void $anonfun$testAllApiVersionsResponseHandled$1(ApiKeys key) {
        ArrayBuffer unhandledVersions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        key.allVersions().forEach(version -> {
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)(ApiKeys.DESCRIBE_LOG_DIRS.equals(key) ? ((DescribeLogDirsResponseData)ApiMessageType.fromApiKey((short)key$1.id).newResponse()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()) : ApiMessageType.fromApiKey((short)key$1.id).newResponse()), (short)Predef$.MODULE$.Short2short(version));
            AbstractResponse response = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes, (short)Predef$.MODULE$.Short2short(version), (MessageContext)MessageContext.IDENTITY);
            try {
                RequestConvertToJson$.MODULE$.response(response, Predef$.MODULE$.Short2short(version));
                return;
            }
            catch (IllegalStateException illegalStateException) {
                unhandledVersions.$plus$eq(version);
                return;
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledVersions, (String)new StringBuilder(34).append("API: ").append(key.toString()).append(" - Unhandled request versions").toString());
    }

    private static final TenantMetadata tenantMetadata$1(String clusterId, String organizationId, String environmentId, boolean serviceAccount, boolean apiKeyAuthenticated, boolean healthcheckTenant) {
        return new TenantMetadata.Builder(clusterId, null).organizationId(organizationId).environmentId(environmentId).serviceAccount(serviceAccount).apiKeyAuthenticated(apiKeyAuthenticated).healthcheckTenant(healthcheckTenant).build();
    }

    private static final String tenantMetadata$default$1$1() {
        return "clusterfoo";
    }

    private static final String tenantMetadata$default$2$1() {
        return "orgfoo";
    }

    private static final String tenantMetadata$default$3$1() {
        return "envfoo";
    }

    private static final boolean tenantMetadata$default$4$1() {
        return false;
    }

    private static final boolean tenantMetadata$default$5$1() {
        return false;
    }

    private static final boolean tenantMetadata$default$6$1() {
        return false;
    }
}

