/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.MetadataLogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r}a\u0001B\"E\u0005%CQ\u0001\u0015\u0001\u0005\u0002EC\u0011\u0002\u0016\u0001A\u0002\u0003\u0007I\u0011A+\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0003y\u0006\"C3\u0001\u0001\u0004\u0005\t\u0015)\u0003W\u0011\u001d1\u0007A1A\u0005\u0002\u001dDa!\u001e\u0001!\u0002\u0013A\u0007b\u0002<\u0001\u0005\u0004%\ta\u001e\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u0002=\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u00111\u0004\u0001\u0005\u0002\u0005\r\u0001bBA\u0013\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003_\u0001A\u0011AA\u0002\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003\u0007Aq!a\u000e\u0001\t\u0003\t\u0019\u0001C\u0004\u0002<\u0001!\t!a\u0001\t\u000f\u0005}\u0002\u0001\"\u0001\u0002\u0004!9\u00111\t\u0001\u0005\u0002\u0005\r\u0001bBA$\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u0017\u0002A\u0011AA\u0002\u0011\u001d\ty\u0005\u0001C\u0001\u0003\u0007Aq!a\u0015\u0001\t\u0003\t\u0019\u0001C\u0004\u0002X\u0001!\t!a\u0001\t\u000f\u0005m\u0003\u0001\"\u0001\u0002\u0004!9\u0011q\f\u0001\u0005\u0002\u0005\r\u0001bBA2\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003O\u0002A\u0011AA\u0002\u0011\u001d\tY\u0007\u0001C\u0001\u0003\u0007Aq!a\u001c\u0001\t\u0003\t\u0019\u0001C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005\r\u0001bBAK\u0001\u0011\u0005\u00111\u0001\u0005\b\u00033\u0003A\u0011AA\u0002\u0011\u001d\ti\n\u0001C\u0001\u0003\u0007Aq!!)\u0001\t\u0003\t\u0019\u0001C\u0004\u0002&\u0002!\t!a\u0001\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u00111\u001a\u0001\u0005\u0002\u0005\r\u0001bBAh\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003'\u0004A\u0011AA\u0002\u0011\u001d\t9\u000e\u0001C\u0001\u0003\u0007Aq!a7\u0001\t\u0003\t\u0019\u0001C\u0004\u0002`\u0002!\t!a\u0001\t\u000f\u0005\r\b\u0001\"\u0001\u0002\u0004!9\u0011q\u001d\u0001\u0005\u0002\u0005\r\u0001bBAv\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003_\u0004A\u0011AA\u0002\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003\u0007Aq!a>\u0001\t\u0003\t\u0019\u0001C\u0004\u0002|\u0002!\t!a\u0001\u0007\r\u0005}\b\u0001\u0001B\u0001\u0011\u0019\u00016\u0007\"\u0001\u0003*!9\u0011QY\u001a\u0005B\t=\u0002b\u0002B#g\u0011\u0005#q\t\u0005\b\u0005/\u001aD\u0011\tB-\u0011%\u0011I\u0007\u0001b\u0001\n\u0003\u0011Y\u0007\u0003\u0005\u0003t\u0001\u0001\u000b\u0011\u0002B7\u0011\u001d\u0011)\b\u0001C\u0001\u0005oB\u0011B!)\u0001#\u0003%\tAa)\t\u0013\te\u0006!%A\u0005\u0002\tm\u0006b\u0002B`\u0001\u0011\u0005!\u0011\u0019\u0005\n\u0005\u0017\u0004\u0011\u0013!C\u0001\u0005GC\u0011B!4\u0001#\u0003%\tAa/\t\u000f\t=\u0007\u0001\"\u0001\u0003R\"9!q\u001a\u0001\u0005\u0002\t-\bb\u0002B\u0000\u0001\u0011%1\u0011\u0001\u0002\u0015\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001e$Vm\u001d;\u000b\u0005\u00153\u0015\u0001\u0002:bMRT\u0011aR\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\n\u0005\u0002L\u001d6\tAJC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyEJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0003\"a\u0015\u0001\u000e\u0003\u0011\u000bq\u0001^3na\u0012K'/F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0002j_*\t1,\u0001\u0003kCZ\f\u0017BA/Y\u0005\u00111\u0015\u000e\\3\u0002\u0017Q,W\u000e\u001d#je~#S-\u001d\u000b\u0003A\u000e\u0004\"aS1\n\u0005\td%\u0001B+oSRDq\u0001Z\u0002\u0002\u0002\u0003\u0007a+A\u0002yIE\n\u0001\u0002^3na\u0012K'\u000fI\u0001\t[>\u001c7\u000eV5nKV\t\u0001\u000e\u0005\u0002jg6\t!N\u0003\u0002lY\u0006!Q\u000f^5m\u0015\tig.\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f>T!\u0001]9\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0018aA8sO&\u0011AO\u001b\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u0001\b[\u0016$(/[2t+\u0005A\bCA=~\u001b\u0005Q(B\u0001<|\u0015\tah.\u0001\u0004d_6lwN\\\u0005\u0003}j\u0014q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u0015\u0019X\r^+q)\u0005\u0001\u0007fA\u0005\u0002\bA!\u0011\u0011BA\f\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011aA1qS*!\u0011\u0011CA\n\u0003\u001dQW\u000f]5uKJT1!!\u0006r\u0003\u0015QWO\\5u\u0013\u0011\tI\"a\u0003\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rQ\u0011q\u0004\t\u0005\u0003\u0013\t\t#\u0003\u0003\u0002$\u0005-!!C!gi\u0016\u0014X)Y2i\u0003)!Xm\u001d;D_:4\u0017n\u001a\u0015\u0004\u0017\u0005%\u0002\u0003BA\u0005\u0003WIA!!\f\u0002\f\t!A+Z:u\u0003i!Xm\u001d;V]\u0016D\b/Z2uK\u0012\f\u0005\u000f]3oI>3gm]3uQ\ra\u0011\u0011F\u0001\u0013i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|G\u000fK\u0002\u000e\u0003S\tq\u0004^3ti\u000e\u0013X-\u0019;f':\f\u0007o\u001d5pi\u001a\u0013x.\\#oI>3gm]3uQ\rq\u0011\u0011F\u0001)i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|G\u000fT1uKJ$\u0006.\u00198IS\u001eDw+\u0019;fe6\f'o\u001b\u0015\u0004\u001f\u0005%\u0012\u0001\t;fgR\u001c%/Z1uKNs\u0017\r]:i_RlUo\u00195MCR,'/\u00129pG\"D3\u0001EA\u0015\u0003\u0019\"Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;CK\u001a|'/\u001a'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0015\u0004#\u0005%\u0012\u0001\t;fgR\u001c%/Z1uKNs\u0017\r]:i_R$\u0015N^3sO&tw-\u00129pG\"D3AEA\u0015\u0003q!Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;PY\u0012,'/\u00129pG\"D3aEA\u0015\u0003\t\"Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;XSRDW*[:tS:<W\t]8dQ\"\u001aA#!\u000b\u00025Q,7\u000f^\"sK\u0006$X-\u0012=jgRLgnZ*oCB\u001c\bn\u001c;)\u0007U\tI#A\u0006uKN$Hk\u001c9jG&#\u0007f\u0001\f\u0002*\u00059B/Z:u%\u0016\fG-T5tg&twm\u00158baNDw\u000e\u001e\u0015\u0004/\u0005%\u0012!\b;fgR$U\r\\3uK:{g.\u0012=jgR,g\u000e^*oCB\u001c\bn\u001c;)\u0007a\tI#A\u0011uKN$HK];oG\u0006$XMR;mYf$v\u000eT1uKN$8K\\1qg\"|G\u000fK\u0002\u001a\u0003S\t1\u0005^3tiR\u0013XO\\2bi\u0016<\u0016\u000e\u001c7SK6|g/Z(mI\u0016\u00148K\\1qg\"|G\u000fK\u0002\u001b\u0003S\t1\u0005^3tiN#\u0018M\u001d;va^KG\u000f[%om\u0006d\u0017\u000eZ*oCB\u001c\bn\u001c;Ti\u0006$X\rK\u0002\u001c\u0003S\tA\u0006^3tiNs\u0017\r]:i_R$U\r\\3uS>tw+\u001b;i\u0013:4\u0018\r\\5e':\f\u0007o\u001d5piN#\u0018\r^3)\u0007q\tI#\u0001\bnKR\fG-\u0019;b\u0019><G)\u001b:\u0015\u0007Y\u000b9\b\u0003\u0004\u0002zu\u0001\rAV\u0001\u0007Y><G)\u001b:\u0002%]\u0014\u0018\u000e^3F[B$\u0018p\u00158baNDw\u000e\u001e\u000b\u0006A\u0006}\u00141\u0011\u0005\u0007\u0003\u0003s\u0002\u0019\u0001,\u0002\u00175,G/\u00193bi\u0006$\u0015N\u001d\u0005\b\u0003\u000bs\u0002\u0019AAD\u0003)\u0019h.\u00199tQ>$\u0018\n\u001a\t\u0005\u0003\u0013\u000bi)\u0004\u0002\u0002\f*\u0011QI\\\u0005\u0005\u0003\u001f\u000bYI\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\u0002/Q,7\u000f\u001e#pKNtG\u000f\u0016:v]\u000e\fG/\u001a$vY2L\bfA\u0010\u0002*\u0005YB/Z:u\u00072,\u0017M\\;q!\u0006\u0014H/[1m':\f\u0007o\u001d5piND3\u0001IA\u0015\u0003e!Xm\u001d;DY\u0016\fg.\u001e9PY\u0012,'o\u00158baNDw\u000e^:)\u0007\u0005\nI#A\u0013uKN$8I]3bi\u0016\u0014V\r\u001d7jG\u0006$X\r\u001a'pOR\u0013XO\\2bi\u0016\u001ch)\u001e7ms\"\u001a!%!\u000b\u0002!Q,7\u000f^'bq\n\u000bGo\u00195TSj,\u0007fA\u0012\u0002*\u0005qB/Z:u)J,hnY1uK\n+Gn\\<IS\u001eDw+\u0019;fe6\f'o\u001b\u0015\u0004I\u0005%\u0012A\u00042vS2$g)\u001e7m\u0005\u0006$8\r\u001b\u000b\t\u0003[\u000bI,a1\u0002HB!\u0011qVA[\u001b\t\t\tLC\u0002\u00024n\faA]3d_J$\u0017\u0002BA\\\u0003c\u0013Q\"T3n_JL(+Z2pe\u0012\u001c\bbBA^K\u0001\u0007\u0011QX\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eE\u0002L\u0003\u007fK1!!1M\u0005\rIe\u000e\u001e\u0005\b\u0003\u000b,\u0003\u0019AA_\u0003)\u0011XmY8sINK'0\u001a\u0005\b\u0003\u0013,\u0003\u0019AA_\u0003Mi\u0017\r\u001f\"bi\u000eD7+\u001b>f\u0013:\u0014\u0015\u0010^3t\u0003)\"Xm\u001d;WC2LG-\u0019;f\u000bB|7\r[$sK\u0006$XM\u001d+iC:d\u0015m\u001d;L]><h.\u00129pG\"D3AJA\u0015\u00031\"Xm\u001d;WC2LG-\u0019;f\u000bB|7\r\u001b'fgN$\u0006.\u00198PY\u0012,7\u000f^*oCB\u001c\bn\u001c;Fa>\u001c\u0007\u000eK\u0002(\u0003S\ta\u0006^3tiZ\u000bG.\u001b3bi\u0016|eMZ:fi2+7o\u001d+iC:|E\u000eZ3tiNs\u0017\r]:i_R|eMZ:fi\"\u001a\u0001&!\u000b\u0002[Q,7\u000f\u001e,bY&$\u0017\r^3PM\u001a\u001cX\r^#rk\u0006dGk\\(mI\u0016\u001cHo\u00158baNDw\u000e^(gMN,G\u000fK\u0002*\u0003S\t!\t^3tiZ\u000bG.\u001b3bi\u0016,fn\u001b8po:,\u0005o\\2i\u0019\u0016\u001c8\u000f\u00165b]2\u000b7\u000f^&o_^twI]3bi\u0016\u0014H\u000b[1o\u001f2$Wm\u001d;T]\u0006\u00048\u000f[8uQ\rQ\u0013\u0011F\u0001)i\u0016\u001cHOV1mS\u0012\fG/Z#q_\u000eDG*Z:t)\"\fgNR5sgR,\u0005o\\2i\u0013:dun\u001a\u0015\u0004W\u0005%\u0012\u0001\n;fgR4\u0016\r\\5eCR,wJ\u001a4tKR<%/Z1u)\"\fg.\u00128e\u001f\u001a47/\u001a;)\u00071\nI#A\u000fuKN$h+\u00197jI\u0006$Xm\u00144gg\u0016$H*Z:t)\"\fg\u000eT#PQ\ri\u0013\u0011F\u0001 i\u0016\u001cHOV1mS\u0012\fG/\u001a,bY&$W\t]8dQ\u0006sGm\u00144gg\u0016$\bf\u0001\u0018\u0002*\u00051C/Z:u\u0003\u00124\u0018M\\2f\u0019><7\u000b^1si>3gm]3u\u0003\u001a$XM]\"mK\u0006t\u0017N\\4)\u0007=\nI#A\nuKN$H)\u001a7fi\u0016\u001cf.\u00199tQ>$8\u000fK\u00021\u0003S\ta\u0003^3tiN{g\r\u001e*fi\u0016tG/[8o\u0019&l\u0017\u000e\u001e\u0015\u0004c\u0005%\u0012A\t;fgR\u001cVmZ7f]R\u001cH*Z:t)\"\fg\u000eT1uKN$8K\\1qg\"|G\u000fK\u00023\u0003S\u0011aBQ=uK\u0006\u0013(/Y=TKJ$WmE\u00034\u0005\u0007\u0011y\u0001\u0005\u0003\u0003\u0006\t-QB\u0001B\u0004\u0015\r\u0011IAW\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u000e\t\u001d!AB(cU\u0016\u001cG\u000f\u0005\u0004\u0003\u0012\te!QD\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005i1/\u001a:jC2L'0\u0019;j_:T!\u0001 7\n\t\tm!1\u0003\u0002\f%\u0016\u001cwN\u001d3TKJ$W\rE\u0003L\u0005?\u0011\u0019#C\u0002\u0003\"1\u0013Q!\u0011:sCf\u00042a\u0013B\u0013\u0013\r\u00119\u0003\u0014\u0002\u0005\u0005f$X\r\u0006\u0002\u0003,A\u0019!QF\u001a\u000e\u0003\u0001!b!!0\u00032\tU\u0002b\u0002B\u001ak\u0001\u0007!QD\u0001\u0005I\u0006$\u0018\rC\u0004\u00038U\u0002\rA!\u000f\u0002%M,'/[1mSj\fG/[8o\u0007\u0006\u001c\u0007.\u001a\t\u0005\u0005w\u0011\t%\u0004\u0002\u0003>)\u0019!qH>\u0002\u0011A\u0014x\u000e^8d_2LAAa\u0011\u0003>\tArJ\u00196fGR\u001cVM]5bY&T\u0018\r^5p]\u000e\u000b7\r[3\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000f\u0001\u0014IEa\u0013\u0003N!9!1\u0007\u001cA\u0002\tu\u0001b\u0002B\u001cm\u0001\u0007!\u0011\b\u0005\b\u0005\u001f2\u0004\u0019\u0001B)\u0003\ryW\u000f\u001e\t\u0005\u0005w\u0011\u0019&\u0003\u0003\u0003V\tu\"\u0001C,sSR\f'\r\\3\u0002\tI,\u0017\r\u001a\u000b\u0007\u0005;\u0011YF!\u001a\t\u000f\tus\u00071\u0001\u0003`\u0005)\u0011N\u001c9viB!!1\bB1\u0013\u0011\u0011\u0019G!\u0010\u0003\u0011I+\u0017\rZ1cY\u0016DqAa\u001a8\u0001\u0004\ti,\u0001\u0003tSj,\u0017\u0001\u0007#fM\u0006,H\u000e^'fi\u0006$\u0017\r^1M_\u001e\u001cuN\u001c4jOV\u0011!Q\u000e\t\u0004'\n=\u0014b\u0001B9\t\n\tR*\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\u00023\u0011+g-Y;mi6+G/\u00193bi\u0006dunZ\"p]\u001aLw\rI\u0001\u0017EVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e\fe\u000e\u001a#jeRQ!\u0011\u0010BK\u0005/\u0013YJa(\u0011\u0013-\u0013YHa \u0003\u0010\n5\u0014b\u0001B?\u0019\n1A+\u001e9mKN\u0002BA!!\u0003\f6\u0011!1\u0011\u0006\u0005\u0005\u000b\u00139)\u0001\u0003gS2,'b\u0001BE5\u0006\u0019a.[8\n\t\t5%1\u0011\u0002\u0005!\u0006$\b\u000eE\u0002T\u0005#K1Aa%E\u0005AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rC\u0003Uu\u0001\u0007a\u000b\u0003\u0004\u0003\u001aj\u0002\r\u0001[\u0001\u0005i&lW\rC\u0005\u0003\u001ej\u0002\n\u00111\u0001\u0003n\u0005\tR.\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\t\u000fYT\u0004\u0013!a\u0001q\u0006\u0001#-^5mI6+G/\u00193bi\u0006dunZ!oI\u0012K'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)K\u000b\u0003\u0003n\t\u001d6F\u0001BU!\u0011\u0011YK!.\u000e\u0005\t5&\u0002\u0002BX\u0005c\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tMF*\u0001\u0006b]:|G/\u0019;j_:LAAa.\u0003.\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002A\t,\u0018\u000e\u001c3NKR\fG-\u0019;b\u0019><\u0017I\u001c3ESJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005{S3\u0001\u001fBT\u0003A\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\u0006\u0006\u0003\u0010\n\r'Q\u0019Bd\u0005\u0013DQ\u0001V\u001fA\u0002YCaA!'>\u0001\u0004A\u0007\"\u0003BO{A\u0005\t\u0019\u0001B7\u0011\u001d1X\b%AA\u0002a\f!DY;jY\u0012lU\r^1eCR\fGj\\4%I\u00164\u0017-\u001e7uIM\n!DY;jY\u0012lU\r^1eCR\fGj\\4%I\u00164\u0017-\u001e7uIQ\na!\u00199qK:$G\u0003\u0003Bj\u00053\u0014\u0019Oa:\u0011\t\u0005%%Q[\u0005\u0005\u0005/\fYIA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u00057\u0004\u0005\u0019\u0001Bo\u0003\rawn\u001a\t\u0005\u0003\u0013\u0013y.\u0003\u0003\u0003b\u0006-%!\u0004*fa2L7-\u0019;fI2{w\rC\u0004\u0003f\u0002\u0003\r!!0\u0002\u001f9,XNY3s\u001f\u001a\u0014VmY8sINDqA!;A\u0001\u0004\ti,A\u0003fa>\u001c\u0007\u000eF\u0003a\u0005[\u0014i\u0010C\u0004\u0003p\u0006\u0003\rA!=\u0002\u001dMt\u0017\r]:i_R<&/\u001b;feB!!1\u001fB}\u001b\t\u0011)PC\u0002\u0003x:\f\u0001b\u001d8baNDw\u000e^\u0005\u0005\u0005w\u0014)PA\tSC^\u001cf.\u00199tQ>$xK]5uKJDqA!:B\u0001\u0004\ti,\u0001\nde\u0016\fG/\u001a'pO\u0012K'/Z2u_JLH#\u0002,\u0004\u0004\r\u0015\u0001BBA=\u0005\u0002\u0007a\u000bC\u0004\u0004\b\t\u0003\ra!\u0003\u0002\u00151|w\rR5s\u001d\u0006lW\r\u0005\u0003\u0004\f\rea\u0002BB\u0007\u0007+\u00012aa\u0004M\u001b\t\u0019\tBC\u0002\u0004\u0014!\u000ba\u0001\u0010:p_Rt\u0014bAB\f\u0019\u00061\u0001K]3eK\u001aLAaa\u0007\u0004\u001e\t11\u000b\u001e:j]\u001eT1aa\u0006M\u0001")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();
    private final Metrics metrics = new Metrics();
    private final MetadataLogConfig DefaultMetadataLogConfig = new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1);

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir(), (boolean)false);
        this.metrics().close();
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), Arrays.asList("broker"));
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9093");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), BoxesRunTime.boxToInteger((int)2));
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMillisProp(), BoxesRunTime.boxToInteger((int)10240));
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
            this.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig, this.metrics());
        });
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
        this.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig, this.metrics());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnexpectedAppendOffset() {
        void withRecords_records;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var6_6 = null;
        simpleRecordArray = null;
        log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            CompressionType withRecords_compressionType = CompressionType.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        });
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            CompressionType withRecords_compressionType = CompressionType.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsFollower((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        });
    }

    @Test
    public void testCreateSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var5_5 = null;
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        this.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        this.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch(1L, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords - 1), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var5_5 = null;
        log.log().maybeIncrementLogStartOffset(snapshotId.offset() - 1L, LogStartOffsetIncrementReason.SegmentDeletion);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset() - 2L, snapshotId.epoch())));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotOlderEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var5_5 = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        this.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        this.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    @Test
    public void testCreateExistingSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var5_5 = null;
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int offset = 10;
        int epoch = 0;
        this.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
    }

    @Test
    public void testTruncateFullyToLatestSnapshot() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(sameEpochSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.endOffset().offset);
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.highWatermark().offset);
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(greaterEpochSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var8_8 = null;
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.endOffset().offset);
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId1).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var11_8 = null;
        this.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId2).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var13_11 = null;
        this.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId3).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var15_14 = null;
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        this.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(greaterSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var17_17 = null;
        Assertions.assertNotEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        Assertions.assertTrue((boolean)var3_3.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        var3_3.close();
        this.mockTime().sleep(var4_4.fileDeleteDelayMs());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$3 -> x$3.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$7((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testStartupWithInvalidSnapshotState() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        AbstractLog qual$1 = log.log();
        Option x$2 = qual$1.truncateFullyAndStartAt$default$2();
        qual$1.truncateFullyAndStartAt(100L, x$2);
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        Assertions.assertThrows(IllegalStateException.class, () -> this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(50L, 1));
        Assertions.assertThrows(IllegalStateException.class, () -> this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(100L, 1));
        log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        AbstractLog qual$2 = log.log();
        Option x$4 = qual$2.truncateFullyAndStartAt$default$2();
        qual$2.truncateFullyAndStartAt(200L, x$4);
        log.close();
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(500L, 1));
        log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        Assertions.assertEquals((long)500L, (long)log.log().logStartOffset());
    }

    @Test
    public void testSnapshotDeletionWithInvalidSnapshotState() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        log.log().truncateFullyAndStartAt(100L, log.log().truncateFullyAndStartAt$default$2());
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(100L, 1);
        this.writeEmptySnapshot(metadataDir, snapshotId);
        Path deletedPath = Snapshots.markForDelete((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId);
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
        Assertions.assertThrows(IllegalStateException.class, () -> this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics()));
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
    }

    private File metadataLogDir(File logDir) {
        TopicPartition logDirName_topicPartition = KafkaRaftServer$.MODULE$.MetadataPartition();
        Object var2_2 = null;
        return new File(logDir.getAbsolutePath(), LocalLog$.MODULE$.logDirName(logDirName_topicPartition));
    }

    private void writeEmptySnapshot(File metadataDir, OffsetAndEpoch snapshotId) {
        try (FileRawSnapshotWriter writer = FileRawSnapshotWriter.create((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId, Optional.empty());){
            writer.freeze();
        }
    }

    @Test
    public void testDoesntTruncateFully() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(olderEpochSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(olderOffsetSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var8_8 = null;
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void var2_2;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        this.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var8_7 = null;
        var3_3.flush(false);
        var3_3.close();
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)var3_3.startOffset());
        Assertions.assertEquals((int)epoch, (int)var3_3.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)var3_3.endOffset().offset);
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset);
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$6 -> x$6.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId1).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var12_8 = null;
        this.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId2).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var14_11 = null;
        this.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId3).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var16_14 = null;
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        this.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(greaterSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var18_17 = null;
        var3_3.close();
        KafkaMetadataLog secondLog = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(var4_4.fileDeleteDelayMs());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$8 -> x$8.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$7((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        log.close();
        KafkaMetadataLog secondLog = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch(), (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.endOffset().offset);
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.highWatermark().offset);
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        int x$2 = this.DefaultMetadataLogConfig().copy$default$1();
        int x$3 = this.DefaultMetadataLogConfig().copy$default$2();
        long x$4 = this.DefaultMetadataLogConfig().copy$default$3();
        long x$5 = this.DefaultMetadataLogConfig().copy$default$4();
        long x$6 = this.DefaultMetadataLogConfig().copy$default$5();
        int x$7 = this.DefaultMetadataLogConfig().copy$default$7();
        long x$8 = this.DefaultMetadataLogConfig().copy$default$8();
        int x$9 = this.DefaultMetadataLogConfig().copy$default$9();
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig().copy(x$2, x$3, x$4, x$5, x$6, maxBatchSizeInBytes, x$7, x$8, x$9), this.metrics());
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int numRecords = 10;
        int epoch = 5;
        this.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset);
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), CompressionType.NONE, 0L, this.mockTime().milliseconds(), false, leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int numberOfRecords = 1;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int offset = 2;
        int epoch = 1;
        this.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        log.log().maybeIncrementLogStartOffset((long)offset, LogStartOffsetIncrementReason.SegmentDeletion);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int offset = 2;
        int epoch = 1;
        this.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        log.truncateToLatestSnapshot();
        this.append((ReplicatedLog)log, numOfRecords, 1);
        this.append((ReplicatedLog)log, numOfRecords, 2);
        this.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        log.truncateToLatestSnapshot();
        this.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int numberOfRecords = 1;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int numberOfRecords = 10;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        this.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), this.DefaultMetadataLogConfig(), this.metrics());
        int numberOfRecords = 5;
        int epoch = 1;
        this.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        MetadataLogConfig config = new MetadataLogConfig(512, 512, 10000L, 256L, 60000L, 512, this.DefaultMetadataLogConfig().maxFetchSizeInBytes(), 60000L, 1);
        config.copy(config.copy$default$1(), config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.metrics());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$9 -> this.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId1).get();){
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2(this, rawSnapshotWriter);
        }
        Object var9_4 = null;
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId2).get();){
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3(this, rawSnapshotWriter);
        }
        Object var11_8 = null;
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset() ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    @Test
    public void testDeleteSnapshots() {
        MetadataLogConfig config = this.DefaultMetadataLogConfig().copy(1024, 1024, 10000L, 1024L, 60000L, 100, this.DefaultMetadataLogConfig().copy$default$7(), this.DefaultMetadataLogConfig().copy$default$8(), this.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.metrics());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable)x$10 -> this.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
            try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId).get();){
                RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
                KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3(this, rawSnapshotWriter);
            }
        });
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$4((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Object var3_3 = null;
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    @Test
    public void testSoftRetentionLimit() {
        MetadataLogConfig config = this.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 100, this.DefaultMetadataLogConfig().copy$default$7(), this.DefaultMetadataLogConfig().copy$default$8(), this.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.metrics());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$11 -> this.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId1).get();){
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2(this, rawSnapshotWriter);
        }
        Object var5_4 = null;
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId2).get();){
            RawSnapshotWriter rawSnapshotWriter = (RawSnapshotWriter)resource_resource;
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(this, rawSnapshotWriter);
        }
        Object var7_8 = null;
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$4(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    @Test
    public void testSegmentsLessThanLatestSnapshot() {
        MetadataLogConfig config = this.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 200, this.DefaultMetadataLogConfig().copy$default$7(), this.DefaultMetadataLogConfig().copy$default$8(), this.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = this.buildMetadataLog(this.tempDir(), this.mockTime(), config, this.metrics());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$12 -> this.append((ReplicatedLog)log, 10, 1));
        log.updateHighWatermark(new LogOffsetMetadata(log.endOffset().offset));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(((LogSegment)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.log().localLogSegments()).asScala().drop(1)).head()).baseOffset(), 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId1).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var9_4 = null;
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(((LogSegment)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.log().localLogSegments()).asScala().drop(2)).head()).baseOffset(), 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId2).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var11_7 = null;
        long defaultLogRetentionMs = 1209600000L;
        this.mockTime().sleep(defaultLogRetentionMs);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount());
        Assertions.assertTrue((log.startOffset() > 0L ? 1 : 0) != 0, (String)new StringBuilder(23).append(log.startOffset()).append(" must be greater than 0").toString());
        long latestSnapshotOffset = ((OffsetAndEpoch)log.latestSnapshotId().get()).offset();
        Assertions.assertTrue((latestSnapshotOffset >= log.startOffset() ? 1 : 0) != 0, (String)new StringBuilder(56).append("latest snapshot offset (").append(latestSnapshotOffset).append(") must be >= log start offset (").append(log.startOffset()).append(")").toString());
    }

    public MetadataLogConfig DefaultMetadataLogConfig() {
        return this.DefaultMetadataLogConfig;
    }

    public Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig, Metrics metrics) {
        TopicPartition logDirName_topicPartition = KafkaRaftServer$.MODULE$.MetadataPartition();
        Object var7_5 = null;
        File logDir = this.createLogDirectory(tempDir, LocalLog$.MODULE$.logDirName(logDirName_topicPartition));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), logDir, (Time)time, metrics, (Scheduler)time.scheduler, metadataLogConfig, KafkaMetadataLog$.MODULE$.apply$default$8(), KafkaMetadataLog$.MODULE$.apply$default$9());
        return new Tuple3((Object)logDir.toPath(), (Object)metadataLog, (Object)metadataLogConfig);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaMetadataLog buildMetadataLog(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig, Metrics metrics) {
        void var6_6;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = this.buildMetadataLogAndDir(tempDir, time, metadataLogConfig, metrics);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        return var6_6;
    }

    public MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return this.DefaultMetadataLogConfig();
    }

    public Metrics buildMetadataLogAndDir$default$4() {
        return this.metrics();
    }

    public MetadataLogConfig buildMetadataLog$default$3() {
        return this.DefaultMetadataLogConfig();
    }

    public Metrics buildMetadataLog$default$4() {
        return this.metrics();
    }

    /*
     * WARNING - void declaration
     */
    public LogAppendInfo append(ReplicatedLog log, int numberOfRecords, int epoch) {
        void withRecords_records;
        void withRecords_compressionType;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable)number -> KafkaMetadataLogTest.$anonfun$append$1(BoxesRunTime.unboxToInt((Object)number))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = log.endOffset().offset;
        compressionType = null;
        simpleRecordArray = null;
        return log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)epoch, (boolean)false, (SimpleRecord[])withRecords_records), epoch);
    }

    /*
     * WARNING - void declaration
     */
    public void append(RawSnapshotWriter snapshotWriter, int numberOfRecords) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable)number -> KafkaMetadataLogTest.$anonfun$append$2(BoxesRunTime.unboxToInt((Object)number))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        snapshotWriter.append(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
    }

    private File createLogDirectory(File logDir, String logDirName) {
        String logDirPath = logDir.getAbsolutePath();
        File dir = new File(logDirPath, logDirName);
        if (!Files.exists(dir.toPath(), new LinkOption[0])) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        return dir;
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$7(KafkaMetadataLog log$7, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$7.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$7(KafkaMetadataLog log$8, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$8.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$2(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$3(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$3(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 10);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$4(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset());
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$2(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        $this.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(KafkaMetadataLog log$13, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$13.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$4(KafkaMetadataLog log$13, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset(), (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$13.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(log$13, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$1(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$2(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotBeforeLogStartOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotOlderEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateExistingSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeEmptySnapshot$1$adapted(FileRawSnapshotWriter x$4) {
        x$4.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupPartialSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateReplicatedLogTruncatesFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanOldestSnapshotEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetLessThanOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetEqualToOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanFirstEpochInLog$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$2$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$3$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$2$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$3$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentsLessThanLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentsLessThanLatestSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeleteSnapshots$3$adapted(KafkaMetadataLogTest $this, RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3($this, snapshot);
        return BoxedUnit.UNIT;
    }

    public class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        public byte[] read(Readable input, int size) {
            return input.readArray(size);
        }

        public /* synthetic */ KafkaMetadataLogTest kafka$raft$KafkaMetadataLogTest$ByteArraySerde$$$outer() {
            return KafkaMetadataLogTest.this;
        }

        public ByteArraySerde() {
            if (KafkaMetadataLogTest.this == null) {
                throw null;
            }
        }
    }
}

