/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.log.LogManager$;
import kafka.raft.KafkaRaftManager;
import kafka.raft.KafkaRaftManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer;
import kafka.tools.TestRaftServer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001\u0002\n\u0014\u0001aAQa\b\u0001\u0005\u0002\u0001BQa\t\u0001\u0005\n\u0011BQA\u0015\u0001\u0005\nMCQ\u0001\u001c\u0001\u0005\n5Dq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011q\u0010\u0001\u0005\u0002\u0005=\u0004bBAB\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!(\u0001\t\u0003\ty\u0007C\u0004\u0002\"\u0002!\t!a\u001c\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002p!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005=\u0004bBAW\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003c\u0003A\u0011BAZ\u0005=\u0011\u0016M\u001a;NC:\fw-\u001a:UKN$(B\u0001\u000b\u0016\u0003\u0011\u0011\u0018M\u001a;\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"A\n\u0002)\r\u0014X-\u0019;f5.\u0014%o\\6fe\u000e{gNZ5h)\u0015)3\u0006M\u001bN!\t1\u0013&D\u0001(\u0015\tAS#\u0001\u0004tKJ4XM]\u0005\u0003U\u001d\u00121bS1gW\u0006\u001cuN\u001c4jO\")AF\u0001a\u0001[\u0005\u0001R.[4sCRLwN\\#oC\ndW\r\u001a\t\u000359J!aL\u000e\u0003\u000f\t{w\u000e\\3b]\")\u0011G\u0001a\u0001e\u00051an\u001c3f\u0013\u0012\u0004\"AG\u001a\n\u0005QZ\"aA%oi\")aG\u0001a\u0001o\u00051An\\4ESJ\u00042\u0001\u000f!D\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=/\u00051AH]8pizJ\u0011\u0001H\u0005\u0003\u007fm\tq\u0001]1dW\u0006<W-\u0003\u0002B\u0005\n\u00191+Z9\u000b\u0005}Z\u0002C\u0001#L\u001b\u0005)%B\u0001$H\u0003\u00111\u0017\u000e\\3\u000b\u0005!K\u0015a\u00018j_*\t!*\u0001\u0003kCZ\f\u0017B\u0001'F\u0005\u0011\u0001\u0016\r\u001e5\t\u000b9\u0013\u0001\u0019A(\u0002\u00175,G/\u00193bi\u0006$\u0015N\u001d\t\u00045A\u001b\u0015BA)\u001c\u0005\u0019y\u0005\u000f^5p]\u0006a1M]3bi\u0016\u001cuN\u001c4jOR)Q\u0005V5kW\")Qk\u0001a\u0001-\u0006a\u0001O]8dKN\u001c(k\u001c7fgB\u0019qk\u00170\u000f\u0005aK\u0006C\u0001\u001e\u001c\u0013\tQ6$\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u00131aU3u\u0015\tQ6\u0004\u0005\u0002`M:\u0011\u0001\r\u001a\b\u0003C\u000et!A\u000f2\n\u0003YI!\u0001K\u000b\n\u0005\u0015<\u0013aD&bM.\f'+\u00194u'\u0016\u0014h/\u001a:\n\u0005\u001dD'a\u0003)s_\u000e,7o\u001d*pY\u0016T!!Z\u0014\t\u000bE\u001a\u0001\u0019\u0001\u001a\t\u000bY\u001a\u0001\u0019A\u001c\t\u000b9\u001b\u0001\u0019A(\u0002#\r\u0014X-\u0019;f%\u00064G/T1oC\u001e,'\u000f\u0006\u0003oo\u0006%\u0001c\u0001\u0012pc&\u0011\u0001o\u0005\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u00042A\u0007:u\u0013\t\u00198DA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001bk&\u0011ao\u0007\u0002\u0005\u0005f$X\rC\u0003y\t\u0001\u0007\u00110\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\u0007i\f)!D\u0001|\u0015\taX0\u0001\u0004d_6lwN\u001c\u0006\u0003-yT1a`A\u0001\u0003\u0019\t\u0007/Y2iK*\u0011\u00111A\u0001\u0004_J<\u0017bAA\u0004w\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BBA\u0006\t\u0001\u0007Q%\u0001\u0004d_:4\u0017nZ\u0001\u0012i\u0016\u001cHOT8eK&#\u0007K]3tK:$H\u0003BA\t\u0003/\u00012AGA\n\u0013\r\t)b\u0007\u0002\u0005+:LG\u000f\u0003\u0004V\u000b\u0001\u0007\u0011\u0011\u0004\t\u0004/\u0006m\u0011bAA\u000f;\n11\u000b\u001e:j]\u001eD3!BA\u0011!\u0011\t\u0019#!\r\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\ta\u0001]1sC6\u001c(\u0002BA\u0016\u0003[\tqA[;qSR,'O\u0003\u0003\u00020\u0005\u0005\u0011!\u00026v]&$\u0018\u0002BA\u001a\u0003K\u0011\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d)\u0011qGA\"\u0003\u000b\u0002B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0005\u0003{\t)#\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\t\t%a\u000f\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0019\t9%a\u0013\u0002P\u0005\u0012\u0011\u0011J\u0001\u0007EJ|7.\u001a:\"\u0005\u00055\u0013AC2p]R\u0014x\u000e\u001c7fe\u0006\u0012\u0011\u0011K\u0001\u0012EJ|7.\u001a:-G>tGO]8mY\u0016\u0014\u0018\u0001\t;fgRdun\u001a#je2{7m[,iK:\u001cuN\u001c;s_2dWM](oYf$B!!\u0005\u0002X!9\u0011\u0011\f\u0004A\u0002\u0005e\u0011a\u00023jeRK\b/\u001a\u0015\u0004\r\u0005\u0005\u0002f\u0002\u0004\u00028\u0005\r\u0013q\f\u0017\u0007\u0003C\n)'!\u001b\"\u0005\u0005\r\u0014!D7fi\u0006$\u0017\r^1._:d\u00170\t\u0002\u0002h\u0005AAn\\4._:d\u00170\t\u0002\u0002l\u0005!!m\u001c;i\u0003M\"Xm\u001d;M_\u001e$\u0015N\u001d'pG.<\u0006.\u001a8Ce>\\WM](oYf<\u0016\u000e\u001e5TKB\f'/\u0019;f\u001b\u0016$\u0018\rZ1uC\u0012K'\u000f\u0006\u0002\u0002\u0012!\u001aq!a\u001d\u0011\t\u0005U\u00141P\u0007\u0003\u0003oRA!!\u001f\u0002*\u0005\u0019\u0011\r]5\n\t\u0005u\u0014q\u000f\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$8\u000b[;uI><h.S8UQJ,\u0017\r\u001a\u0015\u0004\u0011\u0005M\u0014a\b;fgR,fnY1vO\"$X\t_2faRLwN\\%o\u0013>$\u0006N]3bI\"\u001a\u0011\"a\u001d\u0002#\r\u0014X-\u0019;f\u001b\u0016$\u0018\rZ1uC2{w\r\u0006\u0003\u0002\u0012\u0005-\u0005BBA\u0006\u0015\u0001\u0007Q%\u0001\nbgN,'\u000f\u001e'pO\u0012K'o]#ySN$H\u0003CA\t\u0003#\u000b)*!'\t\r\u0005M5\u00021\u00018\u0003\u001dawn\u001a#jeNDa!a&\f\u0001\u0004y\u0015AD7fi\u0006$\u0017\r^1M_\u001e$\u0015N\u001d\u0005\u0007\u00037[\u0001\u0019A\u0017\u0002#\u0015D\b/Z2u\u001b\u0016$\u0018\rZ1uC2{w-A\u0014uKN$X*[4sCRLgn\u001a.l\u0005J|7.\u001a:EK2,G/Z:NKR\fG-\u0019;b\u0019><\u0007f\u0001\u0007\u0002t\u0005\u0001D/Z:u\u001d>tW*[4sCRLgn\u001a.l\u0005J|7.\u001a:E_\u0016\u001chj\u001c;EK2,G/Z'fi\u0006$\u0017\r^1M_\u001eD3!DA:\u0003!\"Xm\u001d;[W\n\u0013xn[3s\t>,7OT8u\t\u0016dW\r^3TKB\f'/\u0019;f\u0019><G)\u001b:tQ\rq\u00111O\u0001$i\u0016\u001cHOW6Ce>\\WM\u001d#pKNtu\u000e\u001e#fY\u0016$XmU1nK2{w\rR5sQ\ry\u00111O\u0001(i\u0016\u001cHo\u0013*bMR\u0014%o\\6fe\u0012{Wm\u001d(pi\u0012+G.\u001a;f\u001b\u0016$\u0018\rZ1uC2{w\rK\u0002\u0011\u0003g\n!BZ5mK2{7m[3e)\ri\u0013Q\u0017\u0005\u0007\u0003o\u000b\u0002\u0019A\"\u0002\tA\fG\u000f\u001b")
public class RaftManagerTest {
    private KafkaConfig createZkBrokerConfig(boolean migrationEnabled, int nodeId, Seq<Path> logDir, Option<Path> metadataDir) {
        Properties props = new Properties();
        props.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        logDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.LogDirProp(), ((Object)value).toString()));
        if (migrationEnabled) {
            metadataDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), ((Object)value).toString()));
            props.setProperty(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        }
        props.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), Integer.toString(nodeId));
        return new KafkaConfig((Map)props);
    }

    private KafkaConfig createConfig(Set<KafkaRaftServer.ProcessRole> processRoles, int nodeId, Seq<Path> logDir, Option<Path> metadataDir) {
        Properties props = new Properties();
        logDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.LogDirProp(), ((Object)value).toString()));
        metadataDir.foreach((Function1 & Serializable)value -> props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), ((Object)value).toString()));
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), processRoles.mkString(","));
        props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        if (processRoles.contains((Object)KafkaRaftServer.BrokerRole$.MODULE$)) {
            props.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "PLAINTEXT");
            if (processRoles.contains((Object)KafkaRaftServer.ControllerRole$.MODULE$)) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
            } else {
                int voterId = nodeId + 1;
                props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(voterId).append("@localhost:9093").toString());
            }
        } else if (processRoles.contains((Object)KafkaRaftServer.ControllerRole$.MODULE$)) {
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:9093");
            props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        }
        return new KafkaConfig((Map)props);
    }

    private KafkaRaftManager<byte[]> createRaftManager(TopicPartition topicPartition, KafkaConfig config) {
        Uuid topicId = new Uuid(0L, 2L);
        return new KafkaRaftManager(Uuid.randomUuid().toString(), config, (RecordSerde)new TestRaftServer.ByteArraySerde(), topicPartition, topicId, Time.SYSTEM, new Metrics(Time.SYSTEM), Option$.MODULE$.empty(), CompletableFuture.completedFuture(RaftConfig.parseVoterConnections((java.util.List)config.quorumVoters())), (FaultHandler)Mockito.mock(FaultHandler.class), Optional.empty());
    }

    @ParameterizedTest
    @ValueSource(strings={"broker", "controller", "broker,controller"})
    public void testNodeIdPresent(String processRoles) {
        Set processRolesSet = Predef$.MODULE$.Set().empty();
        if (processRoles.contains("broker")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.BrokerRole$[]{KafkaRaftServer.BrokerRole$.MODULE$})));
        }
        if (processRoles.contains("controller")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ControllerRole$[]{KafkaRaftServer.ControllerRole$.MODULE$})));
        }
        File logDir = TestUtils.tempDirectory(null, null);
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<KafkaRaftServer.ProcessRole>)processRolesSet, nodeId, (Seq<Path>)new .colon.colon((Object)logDir.toPath(), (List)Nil$.MODULE$), (Option<Path>)None$.MODULE$));
        Assertions.assertEquals((int)nodeId, (int)raftManager.client().nodeId().getAsInt());
        raftManager.shutdown();
    }

    @ParameterizedTest
    @ValueSource(strings={"metadata-only", "log-only", "both"})
    public void testLogDirLockWhenControllerOnly(String dirType) {
        .colon.colon logDir;
        Object object = dirType.equals("metadata-only") ? (Seq)package$.MODULE$.Seq().empty() : (logDir = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$));
        None$ metadataDir = dirType.equals("log-only") ? None$.MODULE$ : new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<KafkaRaftServer.ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.ControllerRole$.MODULE$}))), nodeId, (Seq<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse(() -> RaftManagerTest.$anonfun$testLogDirLockWhenControllerOnly$1((Seq)logDir))).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    @Test
    public void testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir() {
        .colon.colon logDir = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<KafkaRaftServer.ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}))), nodeId, (Seq<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse(() -> RaftManagerTest.$anonfun$testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir$1((Seq)logDir))).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    @Test
    public void testShutdownIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        MockFaultHandler faultHandler = new MockFaultHandler("RaftManagerTestFaultHandler");
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft", (FaultHandler)faultHandler);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        CompletableFuture<Object> shutdownFuture = new CompletableFuture<Object>();
        Mockito.when((Object)raftClient.shutdown(5000)).thenReturn(shutdownFuture);
        ioThread.initiateShutdown();
        Assertions.assertTrue((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownInitiated());
        ((KafkaRaftClient)Mockito.verify((Object)raftClient)).shutdown(5000);
        shutdownFuture.complete(null);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ioThread.run();
        Assertions.assertFalse((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
        Assertions.assertNull((Object)faultHandler.firstException());
    }

    @Test
    public void testUncaughtExceptionInIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        MockFaultHandler faultHandler = new MockFaultHandler("RaftManagerTestFaultHandler");
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft", (FaultHandler)faultHandler);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        RuntimeException exception = new RuntimeException();
        raftClient.poll();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{exception});
        ioThread.run();
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
        Assertions.assertTrue((boolean)ioThread.isThreadFailed());
        Assertions.assertFalse((boolean)ioThread.isRunning());
        Throwable caughtException = faultHandler.firstException().getCause();
        Assertions.assertEquals((Object)exception, (Object)caughtException);
    }

    public void createMetadataLog(KafkaConfig config) {
        this.createRaftManager(new TopicPartition("__cluster_metadata", 0), config).shutdown();
    }

    public void assertLogDirsExist(Seq<Path> logDirs, Option<Path> metadataLogDir, boolean expectMetadataLog) {
        Assertions.assertTrue((boolean)Files.exists((Path)metadataLogDir.get(), new LinkOption[0]));
        logDirs.foreach((Function1 & Serializable)logDir -> {
            RaftManagerTest.$anonfun$assertLogDirsExist$1(logDir);
            return BoxedUnit.UNIT;
        });
        if (expectMetadataLog) {
            Assertions.assertTrue((boolean)Files.exists(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new LinkOption[0]));
            return;
        }
        Assertions.assertFalse((boolean)Files.exists(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new LinkOption[0]));
    }

    @Test
    public void testMigratingZkBrokerDeletesMetadataLog() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(true, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, false);
    }

    @Test
    public void testNonMigratingZkBrokerDoesNotDeleteMetadataLog() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(false, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        Files.createDirectory(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new FileAttribute[0]);
        RuntimeException err = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config), (String)"Should have not deleted the metadata log");
        Assertions.assertEquals((Object)"Not deleting metadata log dir since migrations are not enabled.", (Object)err.getMessage());
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, true);
    }

    @Test
    public void testZkBrokerDoesNotDeleteSeparateLogDirs() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$));
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(true, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, false);
    }

    @Test
    public void testZkBrokerDoesNotDeleteSameLogDir() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$));
        Option metadataLogDir = logDirs.headOption();
        int nodeId = 1;
        KafkaConfig config = this.createZkBrokerConfig(true, nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, false);
    }

    @Test
    public void testKRaftBrokerDoesNotDeleteMetadataLog() {
        .colon.colon logDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataLogDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaConfig config = this.createConfig((Set<KafkaRaftServer.ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}))), nodeId, (Seq<Path>)logDirs, (Option<Path>)metadataLogDir);
        this.createMetadataLog(config);
        Assertions.assertThrows(RuntimeException.class, () -> KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config), (String)"Should not have deleted metadata log");
        this.assertLogDirsExist((Seq<Path>)logDirs, (Option<Path>)metadataLogDir, true);
    }

    private boolean fileLocked(Path path) {
        boolean bl;
        try (FileChannel resource_resource = FileChannel.open(path, StandardOpenOption.WRITE);){
            bl = RaftManagerTest.$anonfun$fileLocked$1(resource_resource);
        }
        return bl;
    }

    public static final /* synthetic */ Path $anonfun$testLogDirLockWhenControllerOnly$1(Seq logDir$1) {
        return (Path)logDir$1.head();
    }

    public static final /* synthetic */ Path $anonfun$testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir$1(Seq logDir$2) {
        return (Path)logDir$2.head();
    }

    public static final /* synthetic */ void $anonfun$assertLogDirsExist$1(Path logDir) {
        Assertions.assertTrue((boolean)Files.exists(logDir, new LinkOption[0]), (String)"Should not delete log dir");
    }

    public static final /* synthetic */ boolean $anonfun$fileLocked$1(FileChannel channel) {
        try {
            Option$.MODULE$.apply((Object)channel.tryLock()).foreach((Function1 & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            return false;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return true;
        }
    }

    public static final /* synthetic */ Object $anonfun$fileLocked$1$adapted(FileChannel channel) {
        return BoxesRunTime.boxToBoolean((boolean)RaftManagerTest.$anonfun$fileLocked$1(channel));
    }
}

