/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kafka.restore.MessageEmitter;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.TestObjectsBuilder;
import kafka.restore.db.FileRestoreDB;
import kafka.restore.db.Job;
import kafka.restore.db.RestoreDB;
import kafka.restore.db.Utils;
import kafka.restore.statemachine.StateMachineController;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class StateMachineControllerTest {
    @Test
    public void testBuildStateMachinesFromDB() throws URISyntaxException, IOException {
        MessageEmitter messageEmitter = (MessageEmitter)Mockito.mock(MessageEmitter.class);
        RestoreMetricsManager restoreMetricsManager = (RestoreMetricsManager)Mockito.mock(RestoreMetricsManager.class);
        RestoreDB restoreDB = TestObjectsBuilder.buildRestoreDBWithOnePartition();
        Job job = (Job)restoreDB.getJobs().get(restoreDB.getJobs().size() - 1);
        StateMachineController smc = new StateMachineController(job, messageEmitter, restoreMetricsManager);
        FiniteStateMachine fsm = smc.getFiniteStateMachineByTopicPartition(new TopicPartition(TestObjectsBuilder.topic, TestObjectsBuilder.partition));
        Assertions.assertFalse((boolean)smc.isAllTasksDone());
        Assertions.assertEquals((int)1, (int)smc.waitingCount());
        Assertions.assertEquals((Object)State.START, (Object)fsm.currentState());
        restoreDB = new FileRestoreDB();
        String filename = "partitionListForRestore";
        String suffix = ".yaml";
        if (System.getenv("BAZEL_TEST") != null) {
            try (InputStream is = this.getClass().getClassLoader().getResource("partitionListForRestore.yaml").openStream();){
                File tempFile = File.createTempFile("partitionListForRestore", ".yaml");
                Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Utils.loadPartitionsIntoRestoreDB((File)tempFile, (RestoreDB)restoreDB);
            }
        } else {
            URI uri = this.getClass().getClassLoader().getResource("partitionListForRestore.yaml").toURI();
            Utils.loadPartitionsIntoRestoreDB((File)new File(uri), (RestoreDB)restoreDB);
        }
        job = (Job)restoreDB.getJobs().get(restoreDB.getJobs().size() - 1);
        smc = new StateMachineController(job, messageEmitter, restoreMetricsManager);
        Assertions.assertFalse((boolean)smc.isAllTasksDone());
        Assertions.assertEquals((int)1, (int)smc.waitingCount());
    }
}

