/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kafka.restore.db.FileRestoreDB;
import kafka.restore.db.Job;
import kafka.restore.db.RestoreDB;
import kafka.restore.db.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UtilsTest {
    @Test
    public void testIsRestoreDBEmpty() {
        FileRestoreDB restoreDB = new FileRestoreDB();
        Assertions.assertTrue((boolean)Utils.isRestoreDBEmpty((RestoreDB)restoreDB));
    }

    @Test
    public void testLoadPartitionsIntoRestoreDB() throws FileNotFoundException, URISyntaxException, IOException {
        File partitionListFile = this.getFileFromResource("partitionListForRestore.yaml");
        FileRestoreDB restoreDB = new FileRestoreDB();
        Utils.loadPartitionsIntoRestoreDB((File)partitionListFile, (RestoreDB)restoreDB);
        Job job = (Job)restoreDB.getJobs().get(0);
        Assertions.assertEquals((int)1, (int)job.getPartitionCount());
    }

    private File getFileFromResource(String fileName) throws URISyntaxException, IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL resource = classLoader.getResource(fileName);
        if (resource == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        if (System.getenv("BAZEL_TEST") != null) {
            try (InputStream is = resource.openStream();){
                File tempFile = File.createTempFile(fileName, null);
                Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                File file = tempFile;
                return file;
            }
        }
        return new File(resource.toURI());
    }
}

