/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import java.io.File;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.tier.TierTestUtils;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.OpaqueData;
import org.junit.jupiter.api.Assertions;

public class OperatorTestUtil {
    public static void uploadInitateAndComplete(FileTierPartitionState state, TopicIdPartition tpid, int epoch, UUID objectId, long startOffset, long endOffset, int size, long maxTimestamp) {
        OffsetAndEpoch stateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
        state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(tpid, epoch, objectId, startOffset, endOffset, maxTimestamp, maxTimestamp, size, false, false, false, TierUploadType.Archive, stateOffset, OpaqueData.ZEROED), TierTestUtils.nextTierTopicOffsetAndEpoch());
        state.append((AbstractTierMetadata)new TierSegmentUploadComplete(tpid, epoch, objectId, stateOffset), TierTestUtils.nextTierTopicOffsetAndEpoch());
    }

    public static void deleteInitiateAndComplete(FileTierPartitionState state, TopicIdPartition tpid, int epoch, UUID objectId, long deleteTimestamp) {
        OffsetAndEpoch stateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentDeleteInitiate(tpid, epoch, objectId, stateOffset), TierTestUtils.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentDeleteComplete(tpid, epoch, objectId, stateOffset, deleteTimestamp), TierTestUtils.nextTierTopicOffsetAndEpoch()));
    }

    public static String getTierStateFile(File dir) {
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !MergedLog.isTierStateFile((File)file)) continue;
            return file.getAbsolutePath();
        }
        return null;
    }
}

