/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.restore.operators.FtpsSegmentView;
import kafka.restore.operators.OperatorTestUtil;
import kafka.restore.operators.ResetPartitionOperator;
import kafka.server.Defaults;
import kafka.tier.TierTestUtils;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.CompactStats;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.store.OpaqueData;
import kafka.utils.TestUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ResetPartitionOperatorTest {
    File parentDir = TestUtils.tempDir();
    File dir = TestUtils.randomPartitionLogDir(this.parentDir);
    TopicPartition tp = MergedLog.parseTopicPartitionName((File)this.dir);
    TopicIdPartition tpid = new TopicIdPartition(this.tp.topic(), UUID.randomUUID(), this.tp.partition());
    LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
    MockTime time = new MockTime();
    FileTierPartitionState state;
    List<UUID> objectIds = new ArrayList<UUID>();

    @BeforeEach
    public void setup() throws IOException {
        TierTestUtils.initTierTopicOffset();
        for (int i = 0; i < 4; ++i) {
            this.objectIds.add(UUID.randomUUID());
        }
    }

    @AfterEach
    public void teardown() throws IOException {
        if (this.state != null) {
            this.state.close();
        }
        this.dir.delete();
        this.parentDir.delete();
        this.objectIds.clear();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testResetPartitionOperator(boolean isFtpsCleanupEnabled) throws Exception {
        boolean isLogCleanerFeatureEnabled = isFtpsCleanupEnabled;
        TierPartitionStateCleanupConfig cleanupConfig = new TierPartitionStateCleanupConfig(isFtpsCleanupEnabled, Defaults.TierPartitionStateCleanupDelayMs(), 0L);
        this.state = new FileTierPartitionState(this.dir, this.logDirFailureChannel, this.tp, true, (Scheduler)this.time.scheduler, false, isLogCleanerFeatureEnabled, (Time)this.time, cleanupConfig, false, -1);
        this.state.setTopicId(this.tpid.topicId());
        this.state.beginCatchup();
        this.state.onCatchUpComplete();
        this.prepareFtps();
        ResetPartitionOperator resetOperator = new ResetPartitionOperator(this.tp, OperatorTestUtil.getTierStateFile(this.dir));
        FtpsSegmentView operaterConext = resetOperator.operatorContext();
        long headerSize = operaterConext.header().size();
        Assertions.assertFalse((boolean)operaterConext.segmentStateMap().containsKey(this.objectIds.get(1)));
        Assertions.assertEquals((long)0L, (long)operaterConext.header().startOffset());
        Assertions.assertEquals((long)200L, (long)operaterConext.header().endOffset());
        Assertions.assertEquals((int)3, (int)operaterConext.segmentStateMap().size());
        Assertions.assertEquals((int)3, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        Map pathMap = resetOperator.execute();
        Assertions.assertEquals((int)3, (int)pathMap.size());
        Assertions.assertTrue((boolean)pathMap.containsKey(this.objectIds.get(0)));
        Assertions.assertTrue((boolean)pathMap.containsKey(this.objectIds.get(2)));
        Assertions.assertTrue((boolean)pathMap.containsKey(this.objectIds.get(3)));
        Assertions.assertEquals((long)headerSize, (long)operaterConext.header().size());
        Assertions.assertEquals((long)-1L, (long)operaterConext.header().startOffset());
        Assertions.assertEquals((long)-1L, (long)operaterConext.header().endOffset());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)operaterConext.header().errorOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)operaterConext.header().restoreOffsetAndEpoch());
        Assertions.assertEquals((long)-1L, (long)operaterConext.header().compactDirtyStartOffset());
        Assertions.assertEquals((Object)CompactStats.EMPTY, (Object)operaterConext.header().lastCompactStats());
        Assertions.assertEquals((Object)CompactStats.EMPTY, (Object)operaterConext.header().accumulatedCompactStats());
        resetOperator = new ResetPartitionOperator(this.tp, OperatorTestUtil.getTierStateFile(this.dir));
        operaterConext = resetOperator.operatorContext();
        Assertions.assertEquals((long)headerSize, (long)operaterConext.header().size());
        Assertions.assertEquals((long)-1L, (long)operaterConext.header().startOffset());
        Assertions.assertEquals((long)-1L, (long)operaterConext.header().endOffset());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)operaterConext.header().errorOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)operaterConext.header().restoreOffsetAndEpoch());
        Assertions.assertEquals((long)-1L, (long)operaterConext.header().compactDirtyStartOffset());
        Assertions.assertEquals((Object)CompactStats.EMPTY, (Object)operaterConext.header().lastCompactStats());
        Assertions.assertEquals((Object)CompactStats.EMPTY, (Object)operaterConext.header().accumulatedCompactStats());
        Assertions.assertEquals((int)0, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE));
        Assertions.assertEquals((int)0, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        Assertions.assertEquals((int)3, (int)operaterConext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_FENCED));
    }

    private void prepareFtps() throws IOException {
        long timestamp = 1000L;
        this.state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid, 0, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 0, this.objectIds.get(0), 0L, 99L, 100, timestamp);
        OffsetAndEpoch stateOffset = this.state.lastLocalMaterializedSrcOffsetAndEpoch();
        this.state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid, 0, this.objectIds.get(1), 100L, 199L, timestamp + 1000L, timestamp + 1000L, 100, false, false, false, TierUploadType.Archive, stateOffset, OpaqueData.ZEROED), TierTestUtils.nextTierTopicOffsetAndEpoch());
        this.state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid, 1, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 1, this.objectIds.get(2), 100L, 149L, 50, timestamp + 2000L);
        OperatorTestUtil.uploadInitateAndComplete(this.state, this.tpid, 1, this.objectIds.get(3), 150L, 200L, 50, timestamp + 3000L);
        this.state.close();
    }
}

