/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.TestObjectsBuilder;
import kafka.restore.db.RestoreDB;
import kafka.restore.rest.RestoreRestServer;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mockito.Mockito;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class RestoreRestServerTest {
    private static RestoreRestServer restServer;

    @BeforeAll
    public void setup() throws Exception {
        RestoreDB restoreDB = TestObjectsBuilder.buildRestoreDBWithOnePartition();
        RestoreMetricsManager restoreMetricsManager = (RestoreMetricsManager)Mockito.mock(RestoreMetricsManager.class);
        Time time = Time.SYSTEM;
        restServer = new RestoreRestServer(restoreMetricsManager, time);
        restServer.setRestoreDB(restoreDB);
        restServer.start();
    }

    @AfterAll
    public void tearDown() throws Exception {
        restServer.stop();
    }

    @Test
    public void testStatusEndpoint() throws Exception {
        URL url = new URL("http://localhost:9090/v1/restore/status");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        int status = con.getResponseCode();
        String content = RestoreRestServerTest.getContentFromResponse(con);
        String expectedContent = "{\"data\":{\"attributes\":[{\"job_id\":0,\"job_status\":\"NOT_STARTED\",\"waiting_partition_count\":1,\"inprogress_partition_count\":0,\"failed_partition_count\":0,\"completed_partition_count\":0}]}}";
        Assertions.assertEquals((int)200, (int)status);
        Assertions.assertEquals((Object)expectedContent, (Object)content);
        con.disconnect();
    }

    @Test
    public void testUnknownCommand() throws Exception {
        URL url = new URL("http://localhost:9090/v1/restore/unknown");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        int status = con.getResponseCode();
        String content = RestoreRestServerTest.getContentFromResponse(con);
        String expectedContent = "{\"errors\":[{\"id\":0,\"status\":500,\"title\":\"Unknown command\"}]}";
        Assertions.assertEquals((int)500, (int)status);
        Assertions.assertEquals((Object)expectedContent, (Object)content);
        con.disconnect();
    }

    @Test
    public void testStartCommand() throws Exception {
        URI uri = new URI("http://localhost:9090/v1/restore/start");
        HttpPost post = new HttpPost(uri);
        StringBuilder body = new StringBuilder();
        body.append("{\"").append("dry_run").append("\": ").append(true).append("}");
        StringEntity params = new StringEntity(body.toString());
        post.addHeader("content-type", "application/json; utf-8");
        post.setEntity((HttpEntity)params);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);
        Assertions.assertEquals((int)200, (int)httpResponse.getStatusLine().getStatusCode());
    }

    private static String getContentFromResponse(HttpURLConnection con) throws IOException {
        String inputLine;
        int status = con.getResponseCode();
        InputStreamReader streamReader = null;
        streamReader = status > 299 ? new InputStreamReader(con.getErrorStream()) : new InputStreamReader(con.getInputStream());
        BufferedReader in = new BufferedReader(streamReader);
        StringBuffer content = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        return content.toString();
    }
}

