/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kafka.restore.schedulers.CompletableFutureRetryer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class CompletableFutureRetryerTest {
    private static final Duration WAIT_BETWEEN = Duration.ofMillis(20L);
    private Supplier<String> operation;
    private Supplier<CompletableFuture<String>> attempter;
    private ThreadPoolExecutor threadPool;
    private CompletableFutureRetryer retries;
    private Time time;
    private long observedRunTime;
    private long observedFailures;
    private Consumer<Long> runTimeReporter = new Consumer<Long>(){

        @Override
        public void accept(Long aLong) {
            CompletableFutureRetryerTest.this.observedRunTime = aLong;
        }
    };
    private Consumer<Long> numFailuresReporter = new Consumer<Long>(){

        @Override
        public void accept(Long aLong) {
            CompletableFutureRetryerTest.this.observedFailures = CompletableFutureRetryerTest.this.observedFailures + aLong;
        }
    };

    @BeforeEach
    void beforeEach() {
        this.operation = (Supplier)Mockito.mock(Supplier.class);
        this.attempter = () -> CompletableFuture.supplyAsync(this.operation);
        this.threadPool = new ThreadPoolExecutor(10, 10, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.time = new MockTime();
        this.retries = new CompletableFutureRetryer(this.threadPool, WAIT_BETWEEN, this.time);
        this.observedRunTime = -1L;
        this.observedFailures = 0L;
    }

    @AfterEach
    void afterEach() {
        this.threadPool.shutdownNow();
    }

    @Test
    void givenAWorkingAttempterThenTimerIsAccurateAndResultIsCorrect() throws Exception {
        BDDMockito.given((Object)this.operation.get()).willAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                CompletableFutureRetryerTest.this.time.sleep(1000L);
                return "yes!!";
            }
        });
        CompletableFuture retriesCompletableFuture = this.retries.withTimedRetries(this.attempter, t -> false, 3, this.runTimeReporter, this.numFailuresReporter);
        String result = (String)retriesCompletableFuture.get();
        Assertions.assertEquals((Object)"yes!!", (Object)result);
        Assertions.assertEquals((long)1000L, (long)this.observedRunTime);
        Assertions.assertEquals((long)0L, (long)this.observedFailures);
    }

    @Test
    void givenAFailingThenSucceedingAttempterThenTimerIsAccurateAndThereAreMultipleAttempts() throws Exception {
        BDDMockito.given((Object)this.operation.get()).willThrow(new Throwable[]{new RuntimeException("boom!")}).willThrow(new Throwable[]{new RuntimeException("boom!")}).willAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                CompletableFutureRetryerTest.this.time.sleep(1000L);
                return "yes!!";
            }
        });
        CompletableFuture retriesCompletableFuture = this.retries.withTimedRetries(this.attempter, t -> true, 3, this.runTimeReporter, this.numFailuresReporter);
        String result = (String)retriesCompletableFuture.get();
        Long expectedRuntimeMs = WAIT_BETWEEN.toMillis() * 2L + 1000L;
        Assertions.assertEquals((Object)"yes!!", (Object)result);
        Assertions.assertEquals((Long)expectedRuntimeMs, (long)this.observedRunTime);
        Assertions.assertEquals((long)2L, (long)this.observedFailures);
        ((Supplier)BDDMockito.then(this.operation).should(Mockito.times((int)3))).get();
    }

    @Test
    void givenAContinuouslyFailingAttempterThenNumFailuresIsAccurateAndResultsAreError() throws Exception {
        BDDMockito.given((Object)this.operation.get()).willThrow(new Throwable[]{new RuntimeException("boom!")});
        CompletableFuture retriesCompletableFuture = this.retries.withTimedRetries(this.attempter, t -> true, 4, this.runTimeReporter, this.numFailuresReporter);
        Assertions.assertThrows(ExecutionException.class, retriesCompletableFuture::get);
        Assertions.assertEquals((long)-1L, (long)this.observedRunTime);
        Assertions.assertEquals((long)4L, (long)this.observedFailures);
        ((Supplier)BDDMockito.then(this.operation).should(Mockito.times((int)4))).get();
    }

    @Test
    void givenAWorkingAttempterThenTheResultIsProvided() throws Exception {
        BDDMockito.given((Object)this.operation.get()).willReturn((Object)"yes!!");
        String result = (String)this.retries.withRetries(this.attempter, t -> false, 3).get();
        Assertions.assertEquals((Object)result, (Object)"yes!!");
    }

    @Test
    void givenAContinuouslyFailingAttempterThenTheResultIsError() throws Exception {
        BDDMockito.given((Object)this.operation.get()).willThrow(new Throwable[]{new RuntimeException("boom!")});
        Assertions.assertThrows(ExecutionException.class, () -> {
            String cfr_ignored_0 = (String)this.retries.withRetries(this.attempter, t -> true, 3).get();
        });
        ((Supplier)BDDMockito.then(this.operation).should(Mockito.times((int)3))).get();
    }

    @Test
    void givenAFailingThenSucceedingAttempterThenThereAreMultipleAttempts() throws Exception {
        BDDMockito.given((Object)this.operation.get()).willThrow(new Throwable[]{new RuntimeException("boom!")}).willThrow(new Throwable[]{new RuntimeException("boom!")}).willReturn((Object)"yes!!");
        String result = (String)this.retries.withRetries(this.attempter, t -> true, 3).get();
        Assertions.assertEquals((Object)result, (Object)"yes!!");
        ((Supplier)BDDMockito.then(this.operation).should(Mockito.times((int)3))).get();
    }

    @Test
    void givenAnOperationWhichFailsWithAnUnhandleableExceptionThenFailsAtUnhandled() {
        BDDMockito.given((Object)this.operation.get()).willThrow(new Throwable[]{new RuntimeException("boom!")}).willThrow(new Throwable[]{new IllegalStateException("boom!")}).willReturn((Object)"yes!!");
        Assertions.assertThrows(ExecutionException.class, () -> {
            String cfr_ignored_0 = (String)this.retries.withRetries(this.attempter, t -> t.getClass().equals(RuntimeException.class), 3).get();
        });
        ((Supplier)BDDMockito.then(this.operation).should(Mockito.times((int)2))).get();
    }
}

