/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import kafka.restore.RestoreConfig;
import kafka.restore.RestoreOrchestrator;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaFetchFtpsRequest;
import kafka.restore.messages.KafkaRequest;
import kafka.restore.messages.MessageResponse;
import kafka.restore.schedulers.AsyncServiceSchedulerResultsReceiver;
import kafka.restore.schedulers.FtpsDownloadHandler;
import kafka.restore.schedulers.KafkaConnectionPoolImpl;
import org.apache.kafka.common.utils.Time;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FtpsFileDownloadLoadTest {
    private Server server;

    @BeforeEach
    public void setUp() throws Exception {
        this.server = new Server(RestoreConfig.kafkaInternalRestServerPort);
        ContextHandler restoreContext = new ContextHandler("/v1/restore");
        restoreContext.setContextPath("/v1/restore");
        restoreContext.setHandler((Handler)new FtpsDownloadHandler());
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{restoreContext, new DefaultHandler()});
        this.server.setHandler((Handler)contexts);
        this.server.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
    }

    @Test
    public void testKafkaConnectionPoolDownloadFtps() throws InterruptedException {
        RestoreOrchestrator resultsReceiver = (RestoreOrchestrator)Mockito.mock(RestoreOrchestrator.class);
        KafkaConnectionPoolImpl kafkaConnectionPool = new KafkaConnectionPoolImpl((AsyncServiceSchedulerResultsReceiver)resultsReceiver, 5, "/tmp", null, Time.SYSTEM);
        kafkaConnectionPool.startUp();
        NodeConfig broker = new NodeConfig(0, "localhost", 9072);
        int partitions = 50;
        int i = 0;
        while (i < partitions) {
            String topic = "test";
            int partition = i++;
            KafkaFetchFtpsRequest request = new KafkaFetchFtpsRequest(0, topic, partition, broker);
            kafkaConnectionPool.submitKafkaRequest((KafkaRequest)request);
        }
        Thread.sleep(10000L);
        ((RestoreOrchestrator)Mockito.verify((Object)resultsReceiver, (VerificationMode)Mockito.times((int)partitions))).reportServiceSchedulerResponse((MessageResponse)Mockito.any());
    }
}

