/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.snapshot;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kafka.restore.RestoreMetricsManager;
import kafka.restore.RestoreUtil;
import kafka.restore.configmap.PartitionConfig;
import kafka.restore.db.PartitionRestoreContext;
import kafka.restore.snapshot.FtpsStateForRestore;
import kafka.restore.snapshot.PointInTimeTierPartitionStateBuilder;
import kafka.tier.TopicIdPartition;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.store.objects.metadata.TierPartitionStateSnapshotMetadata;
import kafka.tier.store.objects.metadata.TierTopicSnapshotMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class PointInTimeTierPartitionStateBuilderTest {
    private static MockTime time = new MockTime();
    private static MockInMemoryTierObjectStoreConfig config = new MockInMemoryTierObjectStoreConfig();
    private static TierObjectStore store = new MockInMemoryTierObjectStore((Time)time, config);
    private static Path workingDir = new File("/tmp/PointInTimeTierPartitionStateBuilderTest").toPath();
    private static String ftpsBasename = "00000000000000000000.tierstate";
    String topic = "foo";
    int partition = 0;
    UUID topicId = UUID.randomUUID();
    TopicPartition tp = new TopicPartition(this.topic, this.partition);
    TopicIdPartition tpid = new TopicIdPartition(this.topic, this.topicId, this.partition);
    private static RestoreMetricsManager metrics;

    @BeforeAll
    public static void prep() {
        metrics = new RestoreMetricsManager(new Metrics(), "");
        workingDir.toFile().mkdirs();
    }

    @AfterAll
    public static void shutdown() throws IOException {
        store.close();
        Files.walk(workingDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    private TierPartitionStateSnapshotMetadata putFTPS(Path dir, long timestamp, long offset, TopicIdPartition tpid) throws IOException {
        FileTierPartitionStateSnapshotObject snapshotObject = new FileTierPartitionStateSnapshotObject(UUID.randomUUID(), timestamp, new OffsetAndEpoch(offset, Optional.empty()), 0, ftpsBasename, Algorithm.ADLER);
        TierPartitionStateSnapshotMetadata metadata = new TierPartitionStateSnapshotMetadata(tpid, snapshotObject);
        String filename = ((FragmentLocation)metadata.toFragmentLocation("", FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT).get()).objectPath();
        Path path = Paths.get(dir.toString(), filename);
        path.toFile().getParentFile().mkdirs();
        path.toFile().createNewFile();
        store.putObject((ObjectStoreMetadata)metadata, path.toFile(), ObjectType.TIER_PARTITION_STATE_METADATA_SNAPSHOT);
        return metadata;
    }

    private TierTopicSnapshotMetadata putTTPS(Path dir, TierTopicSnapshotObject snapshotObject) throws IOException {
        TierTopicSnapshotMetadata metadata = new TierTopicSnapshotMetadata(snapshotObject);
        String filename = ((FragmentLocation)metadata.toFragmentLocation("", FragmentType.TIER_TOPIC_SNAPSHOT).get()).objectPath();
        Path path = Paths.get(dir.toString(), filename);
        store.putObject((ObjectStoreMetadata)metadata, path.toFile(), ObjectType.TIER_TOPIC_SNAPSHOT);
        Files.deleteIfExists(path);
        return metadata;
    }

    @Test
    public void testFetchFtpsMetadata() throws Exception {
        PointInTimeTierPartitionStateBuilder builder = new PointInTimeTierPartitionStateBuilder(store, RestoreUtil.createThreadPool((int)1, (int)10), metrics);
        Path dir = Files.createTempDirectory(workingDir, "testFetchFtpsMetadata", new FileAttribute[0]);
        TierPartitionStateSnapshotMetadata metadata1 = this.putFTPS(dir, 5L, 0L, this.tpid);
        TierPartitionStateSnapshotMetadata metadata2 = this.putFTPS(dir, 10L, 1L, this.tpid);
        TierPartitionStateSnapshotMetadata metadata3 = this.putFTPS(dir, 20L, 2L, this.tpid);
        HashMap<TopicPartition, PartitionRestoreContext> partitionRestoreContextMap = new HashMap<TopicPartition, PartitionRestoreContext>();
        PartitionRestoreContext partitionRestoreContext = new PartitionRestoreContext(this.topic, Utils.toKafkaUuid((UUID)this.topicId).toString(), new PartitionConfig(this.partition, null), 0L, Long.MAX_VALUE, null, null);
        partitionRestoreContextMap.put(this.tp, partitionRestoreContext);
        PointInTimeTierPartitionStateBuilder.FtpsSnapshotsMetadata metadataResultLatest = builder.getSnapshotUtils().locateFtpsSnapshotsByTimestamp(partitionRestoreContextMap);
        Assertions.assertTrue((boolean)metadataResultLatest.minLastMaterializedEventTs.isPresent(), (String)"no snapshots found");
        Assertions.assertEquals((Object)metadata3, metadataResultLatest.snapshotMap.get(this.tpid), (String)"Long.MAX_VALUE timestamp did not return latest snapshot");
        partitionRestoreContext.revertCompactionSinceTimestamp = 15L;
        PointInTimeTierPartitionStateBuilder.FtpsSnapshotsMetadata metadataResultMiddle = builder.getSnapshotUtils().locateFtpsSnapshotsByTimestamp(partitionRestoreContextMap);
        Assertions.assertTrue((boolean)metadataResultMiddle.minLastMaterializedEventTs.isPresent(), (String)"no snapshots found");
        Assertions.assertEquals((Object)metadata2, metadataResultMiddle.snapshotMap.get(this.tpid), (String)"intermediate timestamp did not return immediately preceding snapshot");
        partitionRestoreContext.revertCompactionSinceTimestamp = 5L;
        PointInTimeTierPartitionStateBuilder.FtpsSnapshotsMetadata metadataResultExact = builder.getSnapshotUtils().locateFtpsSnapshotsByTimestamp(partitionRestoreContextMap);
        Assertions.assertTrue((boolean)metadataResultExact.minLastMaterializedEventTs.isPresent(), (String)"no snapshots found");
        Assertions.assertEquals((Object)metadata1, metadataResultExact.snapshotMap.get(this.tpid), (String)"did not return snapshot with exact matching timestamp");
        partitionRestoreContext.revertCompactionSinceTimestamp = 0L;
        PointInTimeTierPartitionStateBuilder.FtpsSnapshotsMetadata metadataResultNone = builder.getSnapshotUtils().locateFtpsSnapshotsByTimestamp(partitionRestoreContextMap);
        Assertions.assertFalse((boolean)metadataResultNone.minLastMaterializedEventTs.isPresent(), (String)"snapshots incorrectly found");
        Assertions.assertNull(metadataResultNone.snapshotMap.get(this.tpid), (String)"no snapshot should have been found for timestamp < minimum existing timestamp");
    }

    @Test
    public void testDownloadFtpsSnapshotFile() throws Exception {
        Path srcDir = Paths.get(workingDir.toString(), "srcDir");
        srcDir.toFile().mkdirs();
        Path ftpsSnapshotDir = Paths.get(workingDir.toString(), "ftpsSnapshotDir");
        ftpsSnapshotDir.toFile().mkdirs();
        Path stitchedFtpsDir = Paths.get(workingDir.toString(), "stitchedFtpsDir");
        stitchedFtpsDir.toFile().mkdirs();
        TopicIdPartition tpid = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionStateSnapshotMetadata metadata = this.putFTPS(srcDir, 5L, 0L, tpid);
        HashMap<TopicIdPartition, TierPartitionStateSnapshotMetadata> toBeDownloadFtps = new HashMap<TopicIdPartition, TierPartitionStateSnapshotMetadata>();
        toBeDownloadFtps.put(tpid, metadata);
        PointInTimeTierPartitionStateBuilder builder = new PointInTimeTierPartitionStateBuilder(store, RestoreUtil.createThreadPool((int)1, (int)10), metrics);
        Map tierPartitionSnapshotFileFutures = builder.getSnapshotUtils().downloadFtpsSnapshotsInParallel(toBeDownloadFtps, ftpsSnapshotDir);
        HashMap<TopicPartition, PartitionRestoreContext> partitionRestoreContextMap = new HashMap<TopicPartition, PartitionRestoreContext>();
        PartitionRestoreContext partitionRestoreContext = new PartitionRestoreContext(this.topic, this.topicId.toString(), null, 0L, 0L, null, null);
        partitionRestoreContextMap.put(this.tp, partitionRestoreContext);
        Map results = builder.initStateForRestoreMap(tierPartitionSnapshotFileFutures, stitchedFtpsDir, partitionRestoreContextMap);
        Path stitchedFtpsPath = ((FtpsStateForRestore)results.get((Object)tpid)).ftpsSnapshot;
        Assertions.assertNotNull((Object)stitchedFtpsPath);
    }
}

