/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.snapshot;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import kafka.restore.snapshot.SnapshotObjectStoreUtils;
import kafka.restore.snapshot.TierTopicConsumerForRestore;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.OpaqueData;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierTopicConsumerForRestoreTest {
    private static final short TIER_TOPIC_NUM_PARTITIONS = 10;
    private static final String CLUSTER_ID = "mycluster";
    private static final String TIER_TOPIC_NAME = TierTopic.topicName((String)"");
    private static final Set<TopicPartition> TIER_TOPIC_PARTITIONS = TierTopicManager.partitions((String)TIER_TOPIC_NAME, (int)10);
    private static final MockProducerSupplier<byte[], byte[]> PRODUCER_SUPPLIER = new MockProducerSupplier();
    private static final MockConsumerSupplier<byte[], byte[]> CONSUMER_SUPPLIER = new MockConsumerSupplier<byte[], byte[]>("restore", TIER_TOPIC_PARTITIONS, PRODUCER_SUPPLIER.producer(), 0L);

    @Test
    public void testConsumerSeeksToTierTopicPartitionOffset() {
        HashMap<Integer, Long> tierTopicPartitionOffsets = new HashMap<Integer, Long>();
        for (int i = 0; i < 10; ++i) {
            tierTopicPartitionOffsets.put(i, 100L + (long)i * 100L);
        }
        TierTopicConsumerForRestore tierTopicConsumerForRestore = new TierTopicConsumerForRestore(tierTopicPartitionOffsets, Collections.EMPTY_SET, CONSUMER_SUPPLIER);
        tierTopicConsumerForRestore.initialize();
        tierTopicConsumerForRestore.doWork();
        for (int i = 0; i < 10; ++i) {
            TopicPartition tp = new TopicPartition(TIER_TOPIC_NAME, i);
            long offset = tierTopicConsumerForRestore.consumer().position(tp);
            Assertions.assertEquals((long)(100L + (long)i * 100L), (long)offset);
        }
    }

    @Test
    public void testConsumerBuffersRecords() {
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize(10);
        TopicIdPartition tpid0 = new TopicIdPartition("my-topic", UUID.randomUUID(), 0);
        TopicIdPartition tpid1 = new TopicIdPartition("my-topic", UUID.randomUUID(), 1);
        TopicIdPartition tpid2 = new TopicIdPartition("my-topic", UUID.randomUUID(), 2);
        HashSet<TopicIdPartition> tpids = new HashSet<TopicIdPartition>();
        tpids.add(tpid0);
        tpids.add(tpid1);
        tpids.add(tpid2);
        HashMap<Integer, Long> tierTopicPartitionOffsets = new HashMap<Integer, Long>();
        for (int i = 0; i < 10; ++i) {
            tierTopicPartitionOffsets.put(i, 0L);
        }
        TierTopicConsumerForRestore tierTopicConsumerForRestore = new TierTopicConsumerForRestore(tierTopicPartitionOffsets, tpids, CONSUMER_SUPPLIER);
        tierTopicConsumerForRestore.initialize();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(tpid1, 0, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED);
        ProducerRecord producerRecord1 = new ProducerRecord(tierTopic.topicName(), Integer.valueOf(tierTopic.toTierTopicPartition(tpid1).partition()), (Object)uploadInitiate1.serializeKey(), (Object)uploadInitiate1.serializeValue());
        PRODUCER_SUPPLIER.producer().send(producerRecord1);
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(tpid2, 0, UUID.randomUUID(), 0L, 100L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED);
        ProducerRecord producerRecord2 = new ProducerRecord(tierTopic.topicName(), Integer.valueOf(tierTopic.toTierTopicPartition(tpid2).partition()), (Object)uploadInitiate2.serializeKey(), (Object)uploadInitiate2.serializeValue());
        PRODUCER_SUPPLIER.producer().send(producerRecord2);
        TierSegmentUploadInitiate uploadInitiate3 = new TierSegmentUploadInitiate(tpid2, 0, UUID.randomUUID(), 101L, 200L, 200L, 200L, 100, false, false, false, TierUploadType.Archive, OffsetAndEpoch.EMPTY, OpaqueData.ZEROED);
        ProducerRecord producerRecord3 = new ProducerRecord(tierTopic.topicName(), Integer.valueOf(tierTopic.toTierTopicPartition(tpid2).partition()), (Object)uploadInitiate3.serializeKey(), (Object)uploadInitiate3.serializeValue());
        PRODUCER_SUPPLIER.producer().send(producerRecord3);
        CONSUMER_SUPPLIER.moveRecordsFromProducer();
        tierTopicConsumerForRestore.doWork();
        Queue tpid0Records = tierTopicConsumerForRestore.getRecords(tpid0);
        Assertions.assertEquals((int)0, (int)tpid0Records.size());
        tpid0Records = tierTopicConsumerForRestore.getRecords(tpid0);
        Assertions.assertEquals((int)0, (int)tpid0Records.size());
        Queue tpid1Records = tierTopicConsumerForRestore.getRecords(tpid1);
        Assertions.assertEquals((int)1, (int)tpid1Records.size());
        Assertions.assertTrue((boolean)SnapshotObjectStoreUtils.deserializeRecord((ConsumerRecord)((ConsumerRecord)tpid1Records.poll())).equals((Object)uploadInitiate1));
        tpid1Records = tierTopicConsumerForRestore.getRecords(tpid1);
        Assertions.assertEquals((int)0, (int)tpid1Records.size());
        Queue tpid2Records = tierTopicConsumerForRestore.getRecords(tpid2);
        Assertions.assertEquals((int)2, (int)tpid2Records.size());
        Assertions.assertTrue((boolean)SnapshotObjectStoreUtils.deserializeRecord((ConsumerRecord)((ConsumerRecord)tpid2Records.poll())).equals((Object)uploadInitiate2));
        Assertions.assertTrue((boolean)SnapshotObjectStoreUtils.deserializeRecord((ConsumerRecord)((ConsumerRecord)tpid2Records.poll())).equals((Object)uploadInitiate3));
        tpid2Records = tierTopicConsumerForRestore.getRecords(tpid1);
        Assertions.assertEquals((int)0, (int)tpid2Records.size());
    }
}

