/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.nio.charset.StandardCharsets;
import kafka.security.authorizer.AclEntry;
import kafka.security.authorizer.AclEntry$;
import kafka.utils.Json$;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00113Aa\u0002\u0005\u0001\u001f!)a\u0003\u0001C\u0001/!9!\u0004\u0001b\u0001\n\u0003Y\u0002B\u0002\u0015\u0001A\u0003%A\u0004C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\t\rM\u0002\u0001\u0015!\u0003,\u0011\u0015!\u0004\u0001\"\u00016\u00051\t5\r\\#oiJLH+Z:u\u0015\tI!\"\u0001\u0006bkRDwN]5{KJT!a\u0003\u0007\u0002\u0011M,7-\u001e:jifT\u0011!D\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"!\u0007\u0001\u000e\u0003!\t\u0001B]3t_V\u00148-Z\u000b\u00029A\u0011QDJ\u0007\u0002=)\u0011!d\b\u0006\u0003A\u0005\naaY8n[>t'BA\u0007#\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001dr\"a\u0004*fg>,(oY3QCR$XM\u001d8\u0002\u0013I,7o\\;sG\u0016\u0004\u0013aB!dY*\u001bxN\\\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB*ue&tw-\u0001\u0005BG2T5o\u001c8!\u0003U!Xm\u001d;BG2T5o\u001c8D_:4XM]:j_:$\u0012A\u000e\t\u0003#]J!\u0001\u000f\n\u0003\tUs\u0017\u000e\u001e\u0015\u0003\ri\u0002\"a\u000f\"\u000e\u0003qR!!\u0010 \u0002\u0007\u0005\u0004\u0018N\u0003\u0002@\u0001\u00069!.\u001e9ji\u0016\u0014(BA!%\u0003\u0015QWO\\5u\u0013\t\u0019EH\u0001\u0003UKN$\b")
public class AclEntryTest {
    private final ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
    private final String AclJson;

    public ResourcePattern resource() {
        return this.resource;
    }

    public String AclJson() {
        return this.AclJson;
    }

    @Test
    public void testAclJsonConversion() {
        AclEntry acl1 = AclEntry$.MODULE$.apply(new KafkaPrincipal("User", "alice"), AclPermissionType.DENY, "host1", AclOperation.READ, this.resource());
        AclEntry acl2 = AclEntry$.MODULE$.apply(new KafkaPrincipal("User", "bob"), AclPermissionType.ALLOW, "*", AclOperation.READ, this.resource());
        AclEntry acl3 = AclEntry$.MODULE$.apply(new KafkaPrincipal("User", "bob"), AclPermissionType.DENY, "host1", AclOperation.READ, this.resource());
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1, acl2, acl3}));
        Assertions.assertEquals((Object)acls, (Object)AclEntry$.MODULE$.fromBytes(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)AclEntry$.MODULE$.toJsonCompatibleMap(acls)).asJava()), this.resource()));
        Assertions.assertEquals((Object)acls, (Object)AclEntry$.MODULE$.fromBytes(this.AclJson().getBytes(StandardCharsets.UTF_8), this.resource()));
        ResourcePattern resource2 = new ResourcePattern(ResourceType.GROUP, "test", PatternType.PREFIXED);
        Assertions.assertEquals((Object)acls, (Object)AclEntry$.MODULE$.fromBytes(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)AclEntry$.MODULE$.toJsonCompatibleMap(acls)).asJava()), resource2));
        Assertions.assertEquals((Object)acls, (Object)AclEntry$.MODULE$.fromBytes(this.AclJson().getBytes(StandardCharsets.UTF_8), resource2));
    }

    public AclEntryTest() {
        this.AclJson = "{\"version\": 1, \"acls\": [{\"host\": \"host1\",\"permissionType\": \"Deny\",\"operation\": \"READ\", \"principal\": \"User:alice\"  },\n    {  \"host\":  \"*\" ,  \"permissionType\": \"Allow\",  \"operation\":  \"Read\", \"principal\": \"User:bob\"  },\n    {  \"host\": \"host1\",  \"permissionType\": \"Deny\",  \"operation\":   \"Read\" ,  \"principal\": \"User:bob\"}]}";
    }
}

