/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import io.confluent.telemetry.api.events.NoOpEventEmitter;
import io.opentelemetry.context.Context;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import kafka.network.RequestChannel;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005!4A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)\u0011\u0007\u0001C\u0001A!)1\u0007\u0001C\u0001A!)Q\u0007\u0001C\u0001A!)q\u0007\u0001C\u0001A!)\u0011\b\u0001C\u0001A!)1\b\u0001C\u0001A!)Q\b\u0001C\u0005}!)!\n\u0001C\u0005\u0017\")q\n\u0001C\u0005!\n\u0019\u0012)\u001e;i_JL'0\u001a:Vi&d7\u000fV3ti*\u0011abD\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(B\u0001\t\u0012\u0003!\u0019XmY;sSRL(\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005i\u0011A\u000f;fgRL7oQ3oiJ\fG.\u001b>fI\u0006\u001bGNU3rk\u0016\u001cHo\u00148Le\u00064G/\u00143t\u0005J|7.\u001a:GC2\u001cXm\u00148Ok2d\u0017I]4t)\u0005\t\u0003C\u0001\f#\u0013\t\u0019sC\u0001\u0003V]&$\bF\u0001\u0002&!\t1s&D\u0001(\u0015\tA\u0013&A\u0002ba&T!AK\u0016\u0002\u000f),\b/\u001b;fe*\u0011A&L\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002]\u0005\u0019qN]4\n\u0005A:#\u0001\u0002+fgR\fA\t^3ti&\u001c8)\u001a8ue\u0006d\u0017N_3e\u0003\u000ed'+Z9vKN$xJ\\&sC\u001a$X\nZ:Ce>\\WM\u001d$bYN,wJ\\'vYRLG/\u001a8b]R\u001cE.^:uKJD#aA\u0013\u0002\u000fR,7\u000f^5t\u0007\u0016tGO]1mSj,G-Q2m%\u0016\fX/Z:u\u001f:\\%/\u00194u\u001b\u0012\u001c(I]8lKJ4\u0015\r\\:f\u001f:tuN\\!dY\u000e\u0013X-\u0019;f\t\u0016dW\r^3SKFD#\u0001B\u0013\u0002}Q,7\u000f^5t\u0007\u0016tGO]1mSj,G-Q2m%\u0016\fX/Z:u\u001f:\\%/\u00194u\u001b\u0012\u001c(I]8lKJ4\u0015\r\\:f\u001f:tuN\u001c\"s_.,'OU3rQ\t)Q%A\u001euKN$\u0018n]\"f]R\u0014\u0018\r\\5{K\u0012\f5\r\u001c*fcV,7\u000f^(o\u0017J\fg\r^'eg\n\u0013xn[3s\r\u0006d7/Z(o\u001d>tW\nZ:SKFD#AB\u0013\u0002\u0005R,7\u000f^5t\u0007\u0016tGO]1mSj,G-Q2m%\u0016\fX/Z:u\u001f:\\%/\u00194u\u001b\u0012\u001c(I]8lKJ$&/^3D_J\u0014Xm\u0019;De\u0016\fG/Z!dYJ+\u0017\u000f\u000b\u0002\bK\u0005\u0011E/Z:uSN\u001cUM\u001c;sC2L'0\u001a3BG2\u0014V-];fgR|en\u0013:bMRlEm\u001d\"s_.,'\u000f\u0016:vK\u000e{'O]3di\u0012+G.\u001a;f\u0003\u000ed'+Z9)\u0005!)\u0013aE4fi\u000e\u0013X-\u0019;f\u0003\u000ed'+Z9vKN$X#A \u0011\u0005\u0001CU\"A!\u000b\u0005\t\u001b\u0015\u0001\u0003:fcV,7\u000f^:\u000b\u0005\u0011+\u0015AB2p[6|gN\u0003\u0002\u0013\r*\u0011q)L\u0001\u0007CB\f7\r[3\n\u0005%\u000b%!E\"sK\u0006$X-Q2mgJ+\u0017/^3ti\u0006\u0019r-\u001a;EK2,G/Z!dYJ+\u0017/^3tiV\tA\n\u0005\u0002A\u001b&\u0011a*\u0011\u0002\u0012\t\u0016dW\r^3BG2\u001c(+Z9vKN$\u0018\u0001G4fiJ+\u0017/^3ti\u000eC\u0017M\u001c8fYJ+\u0017/^3tiR\u0019\u0011k\u00171\u0011\u0005ICfBA*W\u001b\u0005!&BA+\u0012\u0003\u001dqW\r^<pe.L!a\u0016+\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011\u0011L\u0017\u0002\b%\u0016\fX/Z:u\u0015\t9F\u000bC\u0003]\u0017\u0001\u0007Q,A\u0004sKF,Xm\u001d;\u0011\u0005\u0001s\u0016BA0B\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\"B1\f\u0001\u0004\u0011\u0017aB1qS.+\u0017p\u001d\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\u000e\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003O\u0012\u0014q!\u00119j\u0017\u0016L8\u000f")
public class AuthorizerUtilsTest {
    @Test
    public void testisCentralizedAclRequestOnKraftMdsBrokerFalseOnNullArgs() {
        Assertions.assertFalse((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(null, null));
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Map data = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)config.originals()).thenReturn((Object)data);
        Assertions.assertFalse((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, null));
        ((Map)Mockito.verify((Object)data, (VerificationMode)Mockito.times((int)0))).get(ArgumentMatchers.any());
        RequestChannel.Request request = (RequestChannel.Request)Mockito.mock(RequestChannel.Request.class);
        RequestHeader header = (RequestHeader)Mockito.mock(RequestHeader.class);
        Mockito.when((Object)request.header()).thenReturn((Object)header);
        Assertions.assertFalse((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(null, request));
        ((RequestHeader)Mockito.verify((Object)header, (VerificationMode)Mockito.times((int)0))).apiKey();
    }

    @Test
    public void testisCentralizedAclRequestOnKraftMdsBrokerFalseOnMultitenantCluster() {
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        RequestChannel.Request request = this.getRequestChannelRequest((AbstractRequest)this.getCreateAclRequest(), ApiKeys.CREATE_ACLS);
        Set roles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}));
        HashMap data = new HashMap();
        Mockito.when((Object)config.processRoles()).thenReturn((Object)roles);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.isMdsEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)config.originals()).thenReturn(data);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.isMultitenantCluster())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertFalse((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, request));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.isMultitenantCluster())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertTrue((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, request));
    }

    @Test
    public void testisCentralizedAclRequestOnKraftMdsBrokerFalseOnNonAclCreateDeleteReq() {
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        RequestChannel.Request request = (RequestChannel.Request)Mockito.mock(RequestChannel.Request.class);
        RequestHeader header = (RequestHeader)Mockito.mock(RequestHeader.class);
        Set roles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}));
        Mockito.when((Object)config.processRoles()).thenReturn((Object)roles);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.isMdsEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)header.apiKey()).thenReturn((Object)ApiKeys.CREATE_TOPICS);
        Mockito.when((Object)request.header()).thenReturn((Object)header);
        Assertions.assertFalse((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, request));
        ((RequestHeader)Mockito.verify((Object)header, (VerificationMode)Mockito.times((int)2))).apiKey();
    }

    @Test
    public void testisCentralizedAclRequestOnKraftMdsBrokerFalseOnNonBrokerReq() {
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Set roles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.ControllerRole$.MODULE$}));
        RequestChannel.Request request = this.getRequestChannelRequest((AbstractRequest)this.getCreateAclRequest(), ApiKeys.CREATE_ACLS);
        Mockito.when((Object)config.processRoles()).thenReturn((Object)roles);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.isMdsEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertFalse((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, request));
        roles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}));
        Mockito.when((Object)config.processRoles()).thenReturn((Object)roles);
        Assertions.assertTrue((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, request));
    }

    @Test
    public void testisCentralizedAclRequestOnKraftMdsBrokerFalseOnNonMdsReq() {
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        HashMap data = new HashMap();
        RequestChannel.Request request = this.getRequestChannelRequest((AbstractRequest)this.getCreateAclRequest(), ApiKeys.CREATE_ACLS);
        Set roles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}));
        Mockito.when((Object)config.processRoles()).thenReturn((Object)roles);
        Mockito.when((Object)config.originals()).thenReturn(data);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.isMdsEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertFalse((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, request));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.isMdsEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, request));
    }

    @Test
    public void testisCentralizedAclRequestOnKraftMdsBrokerTrueCorrectCreateAclReq() {
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        HashMap data = new HashMap();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.isMdsEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)config.originals()).thenReturn(data);
        RequestChannel.Request request = this.getRequestChannelRequest((AbstractRequest)this.getCreateAclRequest(), ApiKeys.CREATE_ACLS);
        Set roles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}));
        Mockito.when((Object)config.processRoles()).thenReturn((Object)roles);
        Assertions.assertTrue((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, request));
    }

    @Test
    public void testisCentralizedAclRequestOnKraftMdsBrokerTrueCorrectDeleteAclReq() {
        KafkaConfig config = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        HashMap data = new HashMap();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)config.isMdsEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)config.originals()).thenReturn(data);
        RequestChannel.Request request = this.getRequestChannelRequest((AbstractRequest)this.getDeleteAclRequest(), ApiKeys.DELETE_ACLS);
        Set roles = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer.ProcessRole[]{KafkaRaftServer.BrokerRole$.MODULE$}));
        Mockito.when((Object)config.processRoles()).thenReturn((Object)roles);
        Assertions.assertTrue((boolean)AuthorizerUtils$.MODULE$.isCentralizedAclRequestOnKraftMdsBroker(config, request));
    }

    private CreateAclsRequest getCreateAclRequest() {
        return (CreateAclsRequest)new CreateAclsRequest.Builder(new CreateAclsRequestData()).setClusterId("cluster-123").build();
    }

    private DeleteAclsRequest getDeleteAclRequest() {
        return (DeleteAclsRequest)new DeleteAclsRequest.Builder(new DeleteAclsRequestData()).setClusterId("cluster-123").build();
    }

    private RequestChannel.Request getRequestChannelRequest(AbstractRequest request, ApiKeys apiKeys) {
        KafkaPrincipal testPrincipal = new KafkaPrincipal("User", "testUser");
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(apiKeys, request.version(), "client1", 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), testPrincipal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics, (Option)None$.MODULE$, Context.root(), NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }
}

