/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Optional;
import java.util.UUID;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%haB\u0010!!\u0003\r\ta\n\u0005\u0006]\u0001!\ta\f\u0005\u0006C\u00011\ta\r\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u001dQ\u0005A1A\u0005\u0002\u0005Cqa\u0013\u0001C\u0002\u0013\u0005\u0011\tC\u0004M\u0001\t\u0007I\u0011A'\t\u000f]\u0003!\u0019!C\u0001\u001b\"9\u0001\f\u0001b\u0001\n\u0003I\u0006b\u00021\u0001\u0005\u0004%\t!\u0011\u0005\nC\u0002\u0001\r\u00111A\u0005\u0002\tD\u0011\u0002\u001b\u0001A\u0002\u0003\u0007I\u0011A5\t\u00131\u0004\u0001\u0019!a\u0001\n\u0003i\u0007\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0001v\u0011%9\b\u00011AA\u0002\u0013\u0005\u0001\u0010C\u0005\u007f\u0001\u0001\u0007\t\u0019!C\u0001\u007f\"1\u00111\u0001\u0001\u0005\u0002=Ba!a\u0007\u0001\t\u0003y\u0003BBA\u0010\u0001\u0011\u0005q\u0006\u0003\u0004\u0002$\u0001!\ta\f\u0005\u0007\u0003O\u0001A\u0011A\u0018\t\r\u0005-\u0002\u0001\"\u00010\u0011\u0019\ty\u0003\u0001C\u0001_!1\u00111\u0007\u0001\u0005\u0002=Ba!a\u000e\u0001\t\u0003y\u0003bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\n\u0003C\u0002\u0011\u0013!C\u0001\u0003GBq!!\u001f\u0001\t\u0003\tY\bC\u0004\u0002\"\u0002!\t!a)\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]'A\u0005\"bg\u0016\fU\u000f\u001e5pe&TXM\u001d+fgRT!!\t\u0012\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002$I\u0005A1/Z2ve&$\u0018PC\u0001&\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\t\u0001\u0007\u0005\u0002*c%\u0011!G\u000b\u0002\u0005+:LG/F\u00015!\t)d(D\u00017\u0015\t\tsG\u0003\u00029s\u000511/\u001a:wKJT!!\n\u001e\u000b\u0005mb\u0014AB1qC\u000eDWMC\u0001>\u0003\ry'oZ\u0005\u0003\u007fY\u0012!\"Q;uQ>\u0014\u0018N_3s\u0003)\u0019X\u000f]3s+N,'o]\u000b\u0002\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005Y\u0006twMC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%AB*ue&tw-\u0001\u0005vg\u0016\u0014h.Y7f\u0003%)8/\u001a:oC6,''A\u0005qe&t7-\u001b9bYV\ta\n\u0005\u0002P+6\t\u0001K\u0003\u0002R%\u0006!\u0011-\u001e;i\u0015\t\u00193K\u0003\u0002Us\u000511m\\7n_:L!A\u0016)\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006Q\u0001O]5oG&\u0004\u0018\r\u001c\u001a\u0002\u001dI,\u0017/^3ti\u000e{g\u000e^3yiV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002^'\u0006A!/Z9vKN$8/\u0003\u0002`9\nq!+Z9vKN$8i\u001c8uKb$\u0018!D:va\u0016\u0014Xk]3s\u001d\u0006lW-\u0001\u0004d_:4\u0017nZ\u000b\u0002GB\u0011AMZ\u0007\u0002K*\u0011\u0001\bJ\u0005\u0003O\u0016\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\u0005AR\u0007bB6\f\u0003\u0003\u0005\raY\u0001\u0004q\u0012\n\u0014a\u0004>p_.+W\r]3s\u00072LWM\u001c;\u0016\u00039\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0013\u0002\u0013i|wn[3fa\u0016\u0014\u0018BA:q\u0005=Qvn\\&fKB,'o\u00117jK:$\u0018a\u0005>p_.+W\r]3s\u00072LWM\u001c;`I\u0015\fHC\u0001\u0019w\u0011\u001dYW\"!AA\u00029\f\u0001B]3t_V\u00148-Z\u000b\u0002sB\u0011!\u0010`\u0007\u0002w*\u0011qoU\u0005\u0003{n\u0014qBU3t_V\u00148-\u001a)biR,'O\\\u0001\re\u0016\u001cx.\u001e:dK~#S-\u001d\u000b\u0004a\u0005\u0005\u0001bB6\u0010\u0003\u0003\u0005\r!_\u00010i\u0016\u001cH/Q;uQ>\u0014\u0018N_3CsJ+7o\\;sG\u0016$\u0016\u0010]3Nk2$\u0018\u000e\u001d7f\u0003\u0012$\u0017I\u001c3SK6|g/\u001a\u0015\u0004!\u0005\u001d\u0001\u0003BA\u0005\u0003/i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0004CBL'\u0002BA\t\u0003'\tqA[;qSR,'OC\u0002\u0002\u0016q\nQA[;oSRLA!!\u0007\u0002\f\t!A+Z:u\u0003\t#Xm\u001d;BkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qK&\u001bx\u000e\\1uS>tWK\u001c:fY\u0006$X\r\u001a#f]f<vN\u001c;E_6Lg.\u0019;f\u00032dwn\u001e\u0015\u0004#\u0005\u001d\u0011A\f;fgR\fU\u000f\u001e5pe&TXMQ=SKN|WO]2f)f\u0004X\rR3osR\u000b7.Z:Qe\u0016\u001cW\rZ3oG\u0016D3AEA\u0004\u0003]\"Xm\u001d;BkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qKB\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,G)\u001a8z\t>l\u0017N\\1uK\"\u001a1#a\u0002\u0002oQ,7\u000f^!vi\"|'/\u001b>f\u0005f\u0014Vm]8ve\u000e,G+\u001f9f/&dGmY1sIJ+7o\\;sG\u0016$UM\\=E_6Lg.\u0019;fQ\r!\u0012qA\u0001/i\u0016\u001cH/Q;uQ>\u0014\u0018N_3CsJ+7o\\;sG\u0016$\u0016\u0010]3XSRD\u0017\t\u001c7Pa\u0016\u0014\u0018\r^5p]\u0006\u001bW\rK\u0002\u0016\u0003\u000f\t\u0011\u0006^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,w+\u001b;i\u00032d\u0007j\\:u\u0003\u000e,\u0007f\u0001\f\u0002\b\u0005qC/Z:u\u0003V$\bn\u001c:ju\u0016\u0014\u0015PU3t_V\u00148-\u001a+za\u0016<\u0016\u000e\u001e5BY2\u0004&/\u001b8dSB\fG.Q2fQ\r9\u0012qA\u0001-i\u0016\u001cH/Q;uQ>\u0014(0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/Z*va\u0016\u0014Xk]3s\u0011\u0006\u001c\u0018iY2fgND3\u0001GA\u0004\u0003EqWm\u001e*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u000b\b5\u0006}\u0012\u0011IA)\u0011\u0015a\u0015\u00041\u0001O\u0011\u001d\t\u0019%\u0007a\u0001\u0003\u000b\nQb\u00197jK:$\u0018\t\u001a3sKN\u001c\b\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-c)A\u0002oKRLA!a\u0014\u0002J\tY\u0011J\\3u\u0003\u0012$'/Z:t\u0011%\t\u0019&\u0007I\u0001\u0002\u0004\t)&\u0001\u0004ba&\\U-\u001f\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111L*\u0002\u0011A\u0014x\u000e^8d_2LA!a\u0018\u0002Z\t9\u0011\t]5LKf\u001c\u0018a\u00078foJ+\u0017/^3ti\u000e{g\u000e^3yi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002f)\"\u0011QKA4W\t\tI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA:U\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0014Q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aF1vi\"|'/\u001b>f\u0005f\u0014Vm]8ve\u000e,G+\u001f9f))\ti(a!\u0002\u0006\u0006\u001d\u0015q\u0013\t\u0004S\u0005}\u0014bAAAU\t9!i\\8mK\u0006t\u0007\"B\u0011\u001c\u0001\u0004!\u0004\"\u0002-\u001c\u0001\u0004Q\u0006bBAE7\u0001\u0007\u00111R\u0001\n_B,'/\u0019;j_:\u0004B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#\u001b\u0016aA1dY&!\u0011QSAH\u00051\t5\r\\(qKJ\fG/[8o\u0011\u001d\tIj\u0007a\u0001\u00037\u000bAB]3t_V\u00148-\u001a+za\u0016\u00042A_AO\u0013\r\tyj\u001f\u0002\r%\u0016\u001cx.\u001e:dKRK\b/Z\u0001\bC\u0012$\u0017i\u00197t)\u001d\u0001\u0014QUAT\u0003\u000fDQ!\t\u000fA\u0002QBq!!+\u001d\u0001\u0004\tY+\u0001\u0003bG\u0016\u001c\bCBAW\u0003w\u000b\tM\u0004\u0003\u00020\u0006]\u0006cAAYU5\u0011\u00111\u0017\u0006\u0004\u0003k3\u0013A\u0002\u001fs_>$h(C\u0002\u0002:*\na\u0001\u0015:fI\u00164\u0017\u0002BA_\u0003\u007f\u00131aU3u\u0015\r\tIL\u000b\t\u0005\u0003\u001b\u000b\u0019-\u0003\u0003\u0002F\u0006=%AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uefDa!!3\u001d\u0001\u0004I\u0018a\u0004:fg>,(oY3QCR$XM\u001d8\u0002\u0015I,Wn\u001c<f\u0003\u000ed7\u000f\u0006\u0005\u0002~\u0005=\u0017\u0011[Aj\u0011\u0015\tS\u00041\u00015\u0011\u001d\tI+\ba\u0001\u0003WCa!!3\u001e\u0001\u0004I\u0018a\u0005:f[>4X-Q2mg^KG\u000f[*uCR,GCCA?\u00033\fY.!8\u0002`\")\u0011E\ba\u0001i!9\u0011\u0011\u0016\u0010A\u0002\u0005-\u0006BBAe=\u0001\u0007\u0011\u0010C\u0004\u0002bz\u0001\r!a9\u0002\u0011\u0005\u001cGn\u0015;bi\u0016\u0004B!!$\u0002f&!\u0011q]AH\u0005!\t5\r\\*uCR,\u0007")
public interface BaseAuthorizerTest {
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username2_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal2_$eq(KafkaPrincipal var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String var1);

    public Authorizer authorizer();

    public String superUsers();

    public String username();

    public String username2();

    public KafkaPrincipal principal();

    public KafkaPrincipal principal2();

    public RequestContext requestContext();

    public String superUserName();

    public KafkaConfig config();

    public void config_$eq(KafkaConfig var1);

    public ZooKeeperClient zooKeeperClient();

    public void zooKeeperClient_$eq(ZooKeeperClient var1);

    public ResourcePattern resource();

    public void resource_$eq(ResourcePattern var1);

    public static /* synthetic */ void testAuthorizeByResourceTypeMultipleAddAndRemove$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeMultipleAddAndRemove();
    }

    @Test
    default public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry denyRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
            this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
                this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
                Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            });
            this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
        });
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow();
    }

    @Test
    default public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.GROUP, "s", PatternType.PREFIXED);
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl7 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl6, acl7}))), resource1);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl4}))), resource2);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), resource3);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host2 should not have READ access to any consumer group");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.CLUSTER), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should have READ access to at least one topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeDenyTakesPrecedence$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeDenyTakesPrecedence();
    }

    @Test
    default public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should have WRITE access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should not have WRITE access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypePrefixedResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypePrefixedResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern a = new ResourcePattern(ResourceType.GROUP, "a", PatternType.PREFIXED);
        ResourcePattern ab = new ResourcePattern(ResourceType.GROUP, "ab", PatternType.PREFIXED);
        ResourcePattern abc = new ResourcePattern(ResourceType.GROUP, "abc", PatternType.PREFIXED);
        ResourcePattern abcd = new ResourcePattern(ResourceType.GROUP, "abcd", PatternType.PREFIXED);
        ResourcePattern abcde = new ResourcePattern(ResourceType.GROUP, "abcde", PatternType.PREFIXED);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abcde);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 should have READ access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), abcd);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abc);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), a);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), ab);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 still should not have READ access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWildcardResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWildcardResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern wildcard = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern prefixed = new ResourcePattern(ResourceType.GROUP, "hello", PatternType.PREFIXED);
        ResourcePattern literal = new ResourcePattern(ResourceType.GROUP, "aloha", PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), prefixed);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 should have WRITE access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 now should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), literal);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllOperationAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllOperationAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllOperationAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry denyAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        AccessControlEntry allowAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyWrite = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWrite, allowAll}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAll}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllHostAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllHostAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllHostAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        String allHost = AclEntry$.MODULE$.WildcardHost();
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry allowHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowHost1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyHost1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllHost}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllPrincipalAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllPrincipalAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        String allUser = AclEntry$.MODULE$.WildcardPrincipalString();
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry allowUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u2h1Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowUser1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyUser1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllUser}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorzeByResourceTypeSuperUserHasAccess$(BaseAuthorizerTest $this) {
        $this.testAuthorzeByResourceTypeSuperUserHasAccess();
    }

    @Test
    default public void testAuthorzeByResourceTypeSuperUserHasAccess() {
        AccessControlEntry denyAllAce = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        KafkaPrincipal superUser1 = new KafkaPrincipal("User", this.superUserName());
        InetAddress host1 = InetAddress.getByName("192.0.4.4");
        ResourcePattern allTopicsResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        ResourcePattern clusterResource = new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL);
        ResourcePattern groupResource = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern transactionIdResource = new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "*", PatternType.LITERAL);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), allTopicsResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), clusterResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), groupResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), transactionIdResource);
        RequestContext superUserContext = this.newRequestContext(superUser1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TOPIC), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.CLUSTER), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.GROUP), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"superuser always has access, no matter what acls.");
    }

    public static /* synthetic */ RequestContext newRequestContext$(BaseAuthorizerTest $this, KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return $this.newRequestContext(principal, clientAddress, apiKey);
    }

    default public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY, null, false);
    }

    public static /* synthetic */ ApiKeys newRequestContext$default$3$(BaseAuthorizerTest $this) {
        return $this.newRequestContext$default$3();
    }

    default public ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    public static /* synthetic */ boolean authorizeByResourceType$(BaseAuthorizerTest $this, Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return $this.authorizeByResourceType(authorizer, requestContext, operation, resourceType);
    }

    default public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        AuthorizationResult authorizationResult = authorizer.authorizeByResourceType((AuthorizableRequestContext)requestContext, operation, resourceType);
        AuthorizationResult authorizationResult2 = AuthorizationResult.ALLOWED;
        return !(authorizationResult != null ? !authorizationResult.equals(authorizationResult2) : authorizationResult2 != null);
    }

    public static /* synthetic */ void addAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        $this.addAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable)ace -> new AclBinding(resourcePattern, ace));
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bindings.toList()).asJava())).asScala().map((Function1 & Serializable)x$6 -> (AclCreateResult)x$6.toCompletableFuture().get())).foreach((Function1 & Serializable)result -> {
            BaseAuthorizerTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean removeAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        return $this.removeAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        return this.removeAclsWithState(authorizer, aces, resourcePattern, AclState.ANY);
    }

    public static /* synthetic */ boolean removeAclsWithState$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern, AclState aclState) {
        return $this.removeAclsWithState(authorizer, (Set<AccessControlEntry>)aces, resourcePattern, aclState);
    }

    default public boolean removeAclsWithState(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern, AclState aclState) {
        Set bindings = aces.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)})) : (Set)aces.map((Function1 & Serializable)ace -> new AclBinding(resourcePattern, ace).toFilter());
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bindings.toList()).asJava(), Optional.empty(), aclState)).asScala().map((Function1 & Serializable)x$7 -> (AclDeleteResult)x$7.toCompletableFuture().get())).forall((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)BaseAuthorizerTest.$anonfun$removeAclsWithState$3(result)));
    }

    public static /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static /* synthetic */ boolean $anonfun$removeAclsWithState$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
        result.aclBindingDeleteResults().forEach(r -> r.exception().ifPresent(e -> {
            throw e;
        }));
        return !result.aclBindingDeleteResults().isEmpty();
    }

    public static void $init$(BaseAuthorizerTest $this) {
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq("User:superuser1; User:superuser2");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq("alice");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$username2_$eq("alex");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(new KafkaPrincipal("User", $this.username()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal2_$eq(new KafkaPrincipal("User", $this.username2()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq($this.newRequestContext($this.principal(), InetAddress.getByName("192.168.0.1"), $this.newRequestContext$default$3()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq("superuser1");
    }
}

