/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientIdTopicPartition;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherPool;
import kafka.server.FetcherStats;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.server.PushReplicationState;
import kafka.server.ReplicaState;
import kafka.server.TierOffsetInfo;
import kafka.server.TierStateMachine;
import kafka.server.Truncating$;
import kafka.utils.Implicits;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rUd\u0001\u0002\u001f>\u0001\tCQ!\u0013\u0001\u0005\u0002)Cq!\u0014\u0001C\u0002\u0013\u0005a\n\u0003\u0004S\u0001\u0001\u0006Ia\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0001U\u0011\u0019A\u0006\u0001)A\u0005+\"9\u0011\f\u0001b\u0001\n\u0003Q\u0006BB1\u0001A\u0003%1\fC\u0003c\u0001\u0011\u00051\rC\u0003u\u0001\u0011%Q\u000f\u0003\u0004\u0002\u000e\u0001!\ta\u0019\u0005\u0007\u0003/\u0001A\u0011A2\t\r\u0005m\u0001\u0001\"\u0001d\u0011\u0019\ty\u0002\u0001C\u0001G\"1\u00111\u0005\u0001\u0005\u0002\rDa!a\n\u0001\t\u0003\u0019\u0007BBA\u0016\u0001\u0011\u00051\r\u0003\u0004\u00020\u0001!\ta\u0019\u0005\u0007\u0003g\u0001A\u0011A2\t\r\u0005]\u0002\u0001\"\u0001d\u0011\u001d\tY\u0004\u0001C\u0005\u0003{A\u0011\"a\u0013\u0001#\u0003%I!!\u0014\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!I\u0011\u0011\u0013\u0001\u0012\u0002\u0013%\u00111\u0013\u0005\b\u0003/\u0003A\u0011BAM\r\u0019\t\t\u000b\u0001\u0003\u0002$\"I\u00111V\r\u0003\u0002\u0003\u0006Ia\u0017\u0005\u0007\u0013f!\t!!,\t\r\u0005U\u0016\u0004\"\u0011d\u0011\u0019\t9,\u0007C!G\"1\u0011,\u0007C!\u0003sCq!a/\u001a\t\u0003\ni\fC\u0004\u0002rf!\t%a=\t\u000f\u0005u\u0018\u0004\"\u0011\u0002\u0000\"9!QC\r\u0005B\t]\u0001b\u0002B\u000f3\u0011\u0005#q\u0004\u0005\b\u0005/JB\u0011\tB-\u0011\u001d\u0011)'\u0007C!\u0005OB\u0011B!#\u001a\u0005\u0004%\tEa#\t\u0011\t5\u0015\u0004)A\u0005\u0003kDqAa$\u001a\t\u0003\u0012\tJ\u0002\u0004\u0003\u0018\u0002!!\u0011\u0014\u0005\u0007\u0013&\"\tA!-\t\u000f\tU\u0016\u0006\"\u0011\u00038\"9!\u0011[\u0015\u0005B\tMgA\u0002Bs\u0001\u0011\u00119\u000f\u0003\u0006\u0003p6\u0012\t\u0011)A\u0005\u0003_C!B!=.\u0005\u0003\u0005\u000b\u0011\u0002Bz\u0011)\u0011I0\fB\u0001B\u0003%!1 \u0005\u000b\u0007\u0003i#\u0011!Q\u0001\n\t-\u0006BB%.\t\u0003\u0019\u0019\u0001C\u0004\u0004\u00105\"\tf!\u0005\t\u000f\r]R\u0006\"\u0015\u0004:!91qI\u0017\u0005R\r%\u0003bBB)[\u0011E31\u000b\u0005\b\u00073jC\u0011KB.\u0011\u001d\u0019y&\fC)\u0007CBqa!\u001a.\t#\u001a9\u0007C\u0005\u0004r5\u0012\r\u0011\"\u0015\u0003\f\"A11O\u0017!\u0002\u0013\t)P\u0001\u000eBEN$(/Y2u\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002?\u007f\u000511/\u001a:wKJT\u0011\u0001Q\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\t\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0003\"\u0001\u0014\u0001\u000e\u0003u\n1BZ3uG\"|eMZ:fiV\tq\n\u0005\u0002E!&\u0011\u0011+\u0012\u0002\u0005\u0019>tw-\u0001\u0007gKR\u001c\u0007n\u00144gg\u0016$\b%A\u0006mK\u0006$WM]#q_\u000eDW#A+\u0011\u0005\u00113\u0016BA,F\u0005\rIe\u000e^\u0001\rY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eI\u0001\u000fEJ|7.\u001a:F]\u0012\u0004v.\u001b8u+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010@\u0003\u001d\u0019G.^:uKJL!\u0001Y/\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\u0006y!M]8lKJ,e\u000e\u001a)pS:$\b%A\ndY\u0016\fg.T3ue&\u001c'+Z4jgR\u0014\u0018\u0010F\u0001e!\t!U-\u0003\u0002g\u000b\n!QK\\5uQ\tA\u0001\u000e\u0005\u0002je6\t!N\u0003\u0002lY\u0006\u0019\u0011\r]5\u000b\u00055t\u0017a\u00026va&$XM\u001d\u0006\u0003_B\fQA[;oSRT\u0011!]\u0001\u0004_J<\u0017BA:k\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u000fO\u0016$X*\u001a;sS\u000e4\u0016\r\\;f)\t1\u0018\u0010\u0005\u0002Eo&\u0011\u00010\u0012\u0002\u0004\u0003:L\b\"\u0002>\n\u0001\u0004Y\u0018\u0001\u00028b[\u0016\u00042\u0001`A\u0004\u001d\ri\u00181\u0001\t\u0003}\u0016k\u0011a \u0006\u0004\u0003\u0003\t\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u0006\u0015\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0005\u0003\u0017\u0011aa\u0015;sS:<'bAA\u0003\u000b\u0006IB/Z:u\u0003\u0012$\u0017I\u001c3SK6|g/\u001a)beRLG/[8oQ\rQ\u0011\u0011\u0003\t\u0004S\u0006M\u0011bAA\u000bU\n!A+Z:u\u0003y!Xm\u001d;NKR\u0014\u0018n\u0019$bS2,G\rU1si&$\u0018n\u001c8D_VtG\u000fK\u0002\f\u0003#\ta\u0004^3ti6+GO]5d!\u0006,8/\u001a3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\u00071\t\t\"A\ruKN$H)Z1e)\"\u0014X-\u00193D_VtG/T3ue&\u001c\u0007fA\u0007\u0002\u0012\u0005\u0019B/Z:u\r\u0016$8\r\u001b*bi\u0016lU\r\u001e:jG\"\u001aa\"!\u0005\u0002%Q,7\u000f\u001e+pi\u0006dG*Y4NKR\u0014\u0018n\u0019\u0015\u0004\u001f\u0005E\u0011a\u0007;fgRl\u0015n\u001a:bi\u0016LenU=oGB\u000b'\u000f^5uS>t7\u000fK\u0002\u0011\u0003#\tq\u0003^3ti6\u000b\u0017PY3Va\u0012\fG/\u001a+pa&\u001c\u0017\nZ:)\u0007E\t\t\"\u0001\u000buKN$X\t\u001f9b]\u0012$\u0006N]3bIB{w\u000e\u001c\u0015\u0004%\u0005E\u0011\u0001\u0006;fgR\u001c\u0006N]5oWRC'/Z1e!>|G\u000eK\u0002\u0014\u0003#\tA\u0003^3tiJ+7/\u001b>f)\"\u0014X-\u00193Q_>dGc\u00023\u0002@\u0005\r\u0013q\t\u0005\u0007\u0003\u0003\"\u0002\u0019A+\u0002%\r,(O]3oi\u001a+Go\u00195feNK'0\u001a\u0005\u0007\u0003\u000b\"\u0002\u0019A+\u0002\u001d9,wOR3uG\",'oU5{K\"A\u0011\u0011\n\u000b\u0011\u0002\u0003\u0007Q+A\u0005ce>\\WM\u001d(v[\u0006qB/Z:u%\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001fR3!VA)W\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA/\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0014q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AE7bW\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:$\u0002\"a\u001a\u0002\u0006\u0006%\u0015Q\u0012\t\u0007\u0003S\ny'a\u001d\u000e\u0005\u0005-$bAA7\u000b\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00141\u000e\u0002\u0004'\u0016$\b\u0003BA;\u0003\u0003k!!a\u001e\u000b\t\u0005e\u00141P\u0001\u0007G>lWn\u001c8\u000b\u0007\u0001\u000biHC\u0002\u0002\u0000A\fa!\u00199bG\",\u0017\u0002BAB\u0003o\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002\bZ\u0001\r!V\u0001\ti>\u0004\u0018n\u0019(v[\"1\u00111\u0012\fA\u0002U\u000bA\u0002]1si&$\u0018n\u001c8Ok6D\u0001\"a$\u0017!\u0003\u0005\ra_\u0001\fi>\u0004\u0018n\u0019)sK\u001aL\u00070\u0001\u000fnC.,Gk\u001c9jGB\u000b'\u000f^5uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U%fA>\u0002R\u0005Yq-\u001a;Ce>\\WM]%e)\u0015)\u00161TAP\u0011\u001d\ti\n\u0007a\u0001\u0003g\n!\u0001\u001e9\t\r\u0005%\u0003\u00041\u0001V\u0005}iunY6SKNL'0\u001a$fi\u000eDWM\u001d'fC\u0012,'/\u00128e!>Lg\u000e^\n\u00053\r\u000b)\u000bE\u0002M\u0003OK1!!+>\u00059aU-\u00193fe\u0016sG\rU8j]R\fAb]8ve\u000e,'I]8lKJ$B!a,\u00024B\u0019\u0011\u0011W\r\u000e\u0003\u0001Aa!a+\u001c\u0001\u0004Y\u0016!D5oSRL\u0017\r^3DY>\u001cX-A\u0003dY>\u001cX\rF\u0001\\\u0003)\u0011W/\u001b7e\r\u0016$8\r\u001b\u000b\u0005\u0003\u007f\u000b\t\u000f\u0005\u0004\u0002B\u0006=\u0017Q\u001b\b\u0005\u0003\u0007\fYM\u0004\u0003\u0002F\u0006%gb\u0001@\u0002H&\t\u0001)\u0003\u0002?\u007f%\u0019\u0011QZ\u001f\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&!\u0011\u0011[Aj\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og*\u0019\u0011QZ\u001f\u0011\u000b\u0011\u000b9.a7\n\u0007\u0005eWI\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0003\fi.\u0003\u0003\u0002`\u0006M'\u0001\u0004*fa2L7-\u0019$fi\u000eD\u0007bBAr?\u0001\u0007\u0011Q]\u0001\ra\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\t\t\u0003S\n9/a\u001d\u0002l&!\u0011\u0011^A6\u0005\ri\u0015\r\u001d\t\u0004\u0019\u00065\u0018bAAx{\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u0006y\u0011n\u001d*fC\u0012Lhi\u001c:GKR\u001c\u0007\u000e\u0006\u0003\u0002v\u0006m\bc\u0001#\u0002x&\u0019\u0011\u0011`#\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0014\u0011A\u0002\u0005M\u0014a\u00054fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$HC\u0002B\u0001\u0005\u001b\u0011\t\u0002\u0005\u0003\u0003\u0004\t%QB\u0001B\u0003\u0015\u0011\tIHa\u0002\u000b\u0007y\nY(\u0003\u0003\u0003\f\t\u0015!AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\b\u0005\u001f\t\u0003\u0019AA:\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DaAa\u0005\"\u0001\u0004)\u0016AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\f\u0011CZ3uG\"d\u0015\r^3ti>3gm]3u)\u0019\u0011\tA!\u0007\u0003\u001c!9!q\u0002\u0012A\u0002\u0005M\u0004B\u0002B\nE\u0001\u0007Q+\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0005C\u0011I\u0005\u0005\u0005\u0002j\u0005\u001d\u00181\u000fB\u0012!\u0011\u0011)Ca\u0011\u000f\t\t\u001d\"Q\b\b\u0005\u0005S\u0011ID\u0004\u0003\u0003,\t]b\u0002\u0002B\u0017\u0005kqAAa\f\u000349\u0019aP!\r\n\u0003EL1!a q\u0013\r\u0001\u0015QP\u0005\u0005\u0003s\nY(\u0003\u0003\u0003<\u0005]\u0014aB7fgN\fw-Z\u0005\u0005\u0005\u007f\u0011\t%\u0001\u0011PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3ECR\f'\u0002\u0002B\u001e\u0003oJAA!\u0012\u0003H\tqQ\t]8dQ\u0016sGm\u00144gg\u0016$(\u0002\u0002B \u0005\u0003BqAa\u0013$\u0001\u0004\u0011i%\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\u0002\"!\u001b\u0002h\u0006M$q\n\t\u0005\u0005#\u0012\u0019&D\u0001\u001a\u0013\u0011\u0011)&a*\u0003\u0013\u0015\u0003xn\u00195ECR\f\u0017A\b4fi\u000eDG+[3s\u001b\u0006$XM]5bY&T\u0018\r^5p]R\u000b'oZ3u)\u0019\u0011YF!\u0019\u0003dA\u0019AJ!\u0018\n\u0007\t}SH\u0001\bUS\u0016\u0014xJ\u001a4tKRLeNZ8\t\u000f\t=A\u00051\u0001\u0002t!1!1\u0003\u0013A\u0002U\u000bQAZ3uG\"$BA!\u001b\u0003rAA\u0011\u0011NAt\u0003g\u0012Y\u0007\u0005\u0003\u0003R\t5\u0014\u0002\u0002B8\u0003O\u0013\u0011BR3uG\"$\u0015\r^1\t\u000f\tMT\u00051\u0001\u0003v\u0005aa-\u001a;dQJ+\u0017/^3tiB!!q\u000fBB\u001d\u0011\u0011IHa \u000e\u0005\tm$\u0002\u0002B?\u0003o\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005\u0003\u0013Y(\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0003\u0006\n\u001d%a\u0002\"vS2$WM\u001d\u0006\u0005\u0005\u0003\u0013Y(\u0001\u000fjgR\u0013XO\\2bi&|gn\u00148GKR\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\u0005U\u0018!H5t)J,hnY1uS>twJ\u001c$fi\u000eD7+\u001e9q_J$X\r\u001a\u0011\u00021\u0019,Go\u00195FCJd\u0017.Z:u\u0019>\u001c\u0017\r\\(gMN,G\u000f\u0006\u0004\u0003\u0002\tM%Q\u0013\u0005\b\u0005\u001fA\u0003\u0019AA:\u0011\u0019\u0011\u0019\u0002\u000ba\u0001+\n\tSj\\2l%\u0016\u001c\u0018N_3GKR\u001c\u0007.\u001a:US\u0016\u00148\u000b^1uK6\u000b7\r[5oKN)\u0011Fa'\u0003,B!!Q\u0014BT\u001b\t\u0011yJ\u0003\u0003\u0003\"\n\r\u0016\u0001\u00027b]\u001eT!A!*\u0002\t)\fg/Y\u0005\u0005\u0005S\u0013yJ\u0001\u0004PE*,7\r\u001e\t\u0004\u0019\n5\u0016b\u0001BX{\t\u0001B+[3s'R\fG/Z'bG\"Lg.\u001a\u000b\u0003\u0005g\u00032!!-*\u0003\u0015\u0019H/\u0019:u)!\tYO!/\u0003<\n}\u0006b\u0002B\bW\u0001\u0007\u00111\u000f\u0005\b\u0005{[\u0003\u0019AAv\u0003E\u0019WO\u001d:f]R4U\r^2i'R\fG/\u001a\u0005\b\u0005\u0003\\\u0003\u0019\u0001Bb\u0003I1W\r^2i!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\t\u0015'1\u001a\b\u0005\u0005O\u00119-\u0003\u0003\u0003J\n\u0005\u0013!\u0005$fi\u000eD'+Z:q_:\u001cX\rR1uC&!!Q\u001aBh\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!!\u0011\u001aB!\u0003Ei\u0017-\u001f2f\u0003\u00124\u0018M\\2f'R\fG/\u001a\u000b\u0007\u0005+\u0014\tOa9\u0011\r\t]'Q\\Av\u001b\t\u0011IN\u0003\u0003\u0003\\\n\r\u0016\u0001B;uS2LAAa8\u0003Z\nAq\n\u001d;j_:\fG\u000eC\u0004\u0002\u001e2\u0002\r!a\u001d\t\u000f\tuF\u00061\u0001\u0002l\n9B+Z:u%\u0016\u001c\u0018N_3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\n\u0004[\t%\bc\u0001'\u0003l&\u0019!Q^\u001f\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u00061A.Z1eKJ\f\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u00071\u0013)0C\u0002\u0003xv\u0012\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002!A\fWo]3e!\u0006\u0014H/\u001b;j_:\u001c\bc\u0001'\u0003~&\u0019!q`\u001f\u0003!A\u000bWo]3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00064fi\u000eDG+[3s'R\fG/Z'bG\"Lg.\u001a\u000b\u000b\u0007\u000b\u00199a!\u0003\u0004\f\r5\u0001cAAY[!9!q\u001e\u001aA\u0002\u0005=\u0006b\u0002Bye\u0001\u0007!1\u001f\u0005\b\u0005s\u0014\u0004\u0019\u0001B~\u0011\u001d\u0019\tA\ra\u0001\u0005W\u000bA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003CB\n\u0007S\u0019Yc!\f\u0011\u000b\u0011\u000b9n!\u0006\u0011\t\r]1QE\u0007\u0003\u00073QAaa\u0007\u0004\u001e\u0005\u0019An\\4\u000b\t\r}1\u0011E\u0001\nS:$XM\u001d8bYNTAaa\t\u0002|\u000591\u000f^8sC\u001e,\u0017\u0002BB\u0014\u00073\u0011Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007b\u0002B\bg\u0001\u0007\u00111\u000f\u0005\u0006\u001bN\u0002\ra\u0014\u0005\b\u0007_\u0019\u0004\u0019AB\u0019\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!11GB\u001b\u001b\u0005i\u0013\u0002\u0002B8\u0005W\f\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0007\u0003k\u001cYd!\u0010\t\u000f\t=A\u00071\u0001\u0002t!91q\b\u001bA\u0002\r\u0005\u0013a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u00071\u001b\u0019%C\u0002\u0004Fu\u0012Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR)Ama\u0013\u0004N!9!qB\u001bA\u0002\u0005M\u0004BBB(k\u0001\u0007q*\u0001\u0004pM\u001a\u001cX\r^\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007\u000e\u0006\u0003\u0004V\r]\u0003\u0003\u0002#\u0002XVCqAa\u00047\u0001\u0004\t\u0019(\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\u0007=\u001bi\u0006C\u0004\u0003\u0010]\u0002\r!a\u001d\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\u0007=\u001b\u0019\u0007C\u0004\u0003\u0010a\u0002\r!a\u001d\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0004j\r-4Q\u000e\t\u0006\t\u0006]'\u0011\u0001\u0005\b\u0005\u001fI\u0004\u0019AA:\u0011\u0019\u0019y'\u000fa\u0001+\u0006)Q\r]8dQ\u0006y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0002A%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G\r\t")
public class AbstractFetcherManagerTest {
    private final long fetchOffset;
    private final int leaderEpoch;
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 9092);

    public long fetchOffset() {
        return this.fetchOffset;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAndRemovePartition() {
        void apply_failedAttempts;
        void apply_replicationSessionId;
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_currentLeaderEpoch;
        void apply_lag;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset(), (Option)None$.MODULE$);
        Mockito.when((Object)leader.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)leader);
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        boolean bl = false;
        None$ none$ = None$.MODULE$;
        None$ none$2 = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        int n = this.leaderEpoch();
        None$ none$3 = None$.MODULE$;
        long apply_offset = this.fetchOffset();
        none$3 = null;
        truncating$ = null;
        none$2 = null;
        none$ = null;
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId, apply_offset, (Option)apply_lag, (int)apply_currentLeaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch, (Option)apply_replicationSessionId, (int)apply_failedAttempts))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn(Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testMetricPausedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Combined$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        String metricName = "PausedPartitionsCount";
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.pausedPartitions().putAll((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new PushReplicationState(0, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new PushReplicationState(1, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L))))})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader1 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader2 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$1;
            private final AbstractFetcherThread fetcher2$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$1;
                }
                return this.fetcher2$1;
            }
            {
                this.fetcher1$1 = fetcher1$1;
                this.fetcher2$1 = fetcher2$1;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset(), (Option)None$.MODULE$);
        Mockito.when((Object)fetcher1.leader()).thenReturn((Object)leader1);
        Mockito.when((Object)leader1.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)fetcher2.leader()).thenReturn((Object)leader2);
        Mockito.when((Object)fetcher2.leader().brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((int)2, (int)fetcherManager.deadThreadCount());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher1)).start();
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher2)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher1.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher2.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true), ScalaRunTime$.MODULE$.toObjectArray((Object)new boolean[]{false}));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    @Test
    public void testFetchRateMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader1 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader1.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader2 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader2.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$2;
            private final AbstractFetcherThread fetcher2$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$2;
                }
                return this.fetcher2$2;
            }
            {
                this.fetcher1$2 = fetcher1$2;
                this.fetcher2$2 = fetcher2$2;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)Uuid.randomUuid()), this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset(), (Option)None$.MODULE$);
        Meter requestRate1 = (Meter)Mockito.mock(Meter.class);
        Meter requestRate2 = (Meter)Mockito.mock(Meter.class);
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)requestRate1.oneMinuteRate())).thenReturn((Object)BoxesRunTime.boxToDouble((double)10.0));
        Mockito.when((Object)BoxesRunTime.boxToDouble((double)requestRate2.oneMinuteRate())).thenReturn((Object)BoxesRunTime.boxToDouble((double)5.0));
        FetcherStats fetcherStats1 = (FetcherStats)Mockito.mock(FetcherStats.class);
        FetcherStats fetcherStats2 = (FetcherStats)Mockito.mock(FetcherStats.class);
        Mockito.when((Object)fetcherStats1.requestRate()).thenReturn((Object)requestRate1);
        Mockito.when((Object)fetcherStats2.requestRate()).thenReturn((Object)requestRate2);
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher1.leader()).thenReturn((Object)leader1);
        Mockito.when((Object)fetcher1.fetcherStats()).thenReturn((Object)fetcherStats1);
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher2.leader()).thenReturn((Object)leader2);
        Mockito.when((Object)fetcher2.fetcherStats()).thenReturn((Object)fetcherStats2);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$1(x0$1)))).values().headOption().get()).value()));
        Assertions.assertEquals((int)0, (int)((IterableOnceOps)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$2(x0$2)))).keys().filter((Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$3(k)))).size());
        Assertions.assertEquals((double)15.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$4(x0$3)))).values().headOption().get()).value()));
        fetcherManager.createSeparateFetcherMetrics();
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$5(x0$4)))).values().headOption().get()).value()));
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$testFetchRateMetric$6(x0$5)))).values().headOption().get()).value()));
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher1)).start();
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher1, (VerificationMode)Mockito.times((int)2))).addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher2)).start();
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher2, (VerificationMode)Mockito.times((int)2))).addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
    }

    @Test
    public void testTotalLagMetric() {
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$3;
            private final AbstractFetcherThread fetcher2$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$3;
                }
                return this.fetcher2$3;
            }
            {
                this.fetcher1$3 = fetcher1$3;
                this.fetcher2$3 = fetcher2$3;
                super("fetcher-manager", "fetcher-manager", 1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        IndexedSeq tps = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)i -> AbstractFetcherManagerTest.$anonfun$testTotalLagMetric$1(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq fetcher1Partitions = (IndexedSeq)tps.slice(0, 2);
        IndexedSeq fetcher2Partitions = (IndexedSeq)tps.slice(2, 4);
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)Uuid.randomUuid()), this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset(), (Option)None$.MODULE$);
        scala.collection.immutable.Map fetcher1FetchState = ((IterableOnceOps)fetcher1Partitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)initialFetchState))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map fetcher2FetchState = ((IterableOnceOps)fetcher2Partitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)initialFetchState))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ClientIdAndBroker metricId = new ClientIdAndBroker("0", "localhost", 9092);
        FetcherLagStats fetcherLagStats1 = (FetcherLagStats)Mockito.mock(FetcherLagStats.class);
        Function1 & Serializable valueFactory = (Function1 & Serializable)k -> new FetcherLagMetrics(new ClientIdTopicPartition(metricId.clientId(), k), (Map)Map$.MODULE$.empty());
        Pool lagStats1 = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats1.getAndMaybePut(fetcher1Partitions.apply(0))).lag_$eq(0L);
        ((FetcherLagMetrics)lagStats1.getAndMaybePut(fetcher1Partitions.apply(1))).lag_$eq(2L);
        Pool lagStats2 = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats2.getAndMaybePut(fetcher2Partitions.apply(0))).lag_$eq(1L);
        ((FetcherLagMetrics)lagStats2.getAndMaybePut(fetcher2Partitions.apply(1))).lag_$eq(3L);
        FetcherLagStats fetcherLagStats2 = (FetcherLagStats)Mockito.mock(FetcherLagStats.class);
        Mockito.when((Object)fetcherLagStats1.stats()).thenReturn((Object)lagStats1);
        Mockito.when((Object)fetcherLagStats2.stats()).thenReturn((Object)lagStats2);
        Mockito.when((Object)fetcher1.addPartitions((Map)fetcher1FetchState)).thenReturn((Object)fetcher1Partitions.toSet());
        Mockito.when((Object)fetcher1.fetcherLagStats()).thenReturn((Object)fetcherLagStats1);
        Mockito.when((Object)fetcher2.addPartitions((Map)fetcher2FetchState)).thenReturn((Object)fetcher2Partitions.toSet());
        Mockito.when((Object)fetcher2.fetcherLagStats()).thenReturn((Object)fetcherLagStats2);
        fetcherManager.addFetcherForPartitions((Map)fetcher1FetchState, (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)2L), (Object)this.getMetricValue("TotalLag"));
        fetcherManager.addFetcherForPartitions((Map)fetcher2FetchState, (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)6L), (Object)this.getMetricValue("TotalLag"));
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher1)).start();
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher2)).start();
    }

    @Test
    public void testMigrateInSyncPartitions() {
        MockTime time = new MockTime();
        AbstractFetcherThread fetcher1 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader1 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader1.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherThread fetcher2 = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader2 = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        Mockito.when((Object)leader2.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, time, fetcher1, fetcher2){
            private final AbstractFetcherThread fetcher1$4;
            private final AbstractFetcherThread fetcher2$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                FetcherPool fetcherPool2 = fetcherPool;
                FetcherPool.Default$ default$ = FetcherPool.Default$.MODULE$;
                if (fetcherPool2 != null && fetcherPool2.equals(default$)) {
                    return this.fetcher1$4;
                }
                return this.fetcher2$4;
            }
            {
                this.fetcher1$4 = fetcher1$4;
                this.fetcher2$4 = fetcher2$4;
                super("fetcher-manager", "fetcher-manager", 1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)new Some((Object)time$1.scheduler), (Map)Map$.MODULE$.empty());
            }
        };
        TopicPartition tp_0 = new TopicPartition("topic", 0);
        TopicPartition tp_1 = new TopicPartition("topic", 1);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState_0 = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset(), (Option)None$.MODULE$);
        InitialFetchState initialFetchState_1 = new InitialFetchState((Option)topicId, this.brokerEndPoint(), this.leaderEpoch(), this.fetchOffset(), (Option)None$.MODULE$);
        PartitionFetchState partitionFetchState_0 = new PartitionFetchState((Option)topicId, this.fetchOffset(), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), this.leaderEpoch(), (Option)None$.MODULE$, (ReplicaState)Mockito.mock(ReplicaState.class), (Option)None$.MODULE$, (Option)None$.MODULE$, 0);
        Function1 & Serializable valueFactory = arg_0 -> AbstractFetcherManagerTest.$anonfun$testMigrateInSyncPartitions$1(new ClientIdAndBroker("0", "localhost", 9092), arg_0);
        Pool lagStats = new Pool((Option)new Some((Object)valueFactory));
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_0)).lag_$eq(0L);
        ((FetcherLagMetrics)lagStats.getAndMaybePut((Object)tp_1)).lag_$eq(1L);
        FetcherLagStats fetcherLagStats = (FetcherLagStats)Mockito.mock(FetcherLagStats.class);
        Mockito.when((Object)fetcherLagStats.stats()).thenReturn((Object)lagStats);
        Mockito.when((Object)fetcher1.leader()).thenReturn((Object)leader1);
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        Mockito.when((Object)fetcher1.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_1})));
        Mockito.when((Object)fetcher1.fetcherLagStats()).thenReturn((Object)fetcherLagStats);
        Mockito.when((Object)fetcher1.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})))).thenReturn(Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)partitionFetchState_0)})));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fetcher1.partitionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)fetcher2.leader()).thenReturn((Object)leader2);
        Mockito.when((Object)fetcher2.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp_0})));
        Mockito.when((Object)fetcher2.fetcherLagStats()).thenReturn((Object)fetcherLagStats);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fetcher2.partitionCount())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)fetcher2.fetchState(tp_0)).thenReturn((Object)new Some((Object)partitionFetchState_0));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_0), (Object)initialFetchState_0)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp_1), (Object)initialFetchState_1)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        Assertions.assertEquals((int)1, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertTrue((boolean)fetcherManager.fetcherThreadMap().contains((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher2, tp_0, (Option)topicId);
        time.sleep(1001L);
        Assertions.assertEquals((int)2, (int)fetcherManager.fetcherThreadMap().size());
        Assertions.assertEquals((Object)fetcher1, (Object)fetcherManager.fetcherThreadMap().apply((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.Default$.MODULE$)));
        Assertions.assertEquals((Object)fetcher2, (Object)fetcherManager.fetcherThreadMap().apply((Object)new FetcherTag(0, 0, (FetcherPool)FetcherPool.InSync$.MODULE$)));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher2, tp_0, (Option)topicId);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher1)).start();
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher2)).start();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeUpdateTopicIds() {
        void apply_failedAttempts;
        void apply_replicationSessionId;
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_failedAttempts2;
        void apply_replicationSessionId2;
        void apply_lastFetchedEpoch2;
        void apply_state2;
        void apply_lag;
        void apply_failedAttempts3;
        void apply_replicationSessionId3;
        void apply_lastFetchedEpoch3;
        void apply_state3;
        void apply_failedAttempts4;
        void apply_replicationSessionId4;
        void apply_lastFetchedEpoch4;
        void apply_state4;
        void apply_lag2;
        MockTime time = new MockTime();
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        LeaderEndPoint leader = (LeaderEndPoint)Mockito.mock(LeaderEndPoint.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, time, fetcher){
            private final AbstractFetcherThread fetcher$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.fetcher$4;
            }
            {
                this.fetcher$4 = fetcher$4;
                super("fetcher-manager", "fetcher-manager", 2, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)new Some((Object)time$2.scheduler), (Map)Map$.MODULE$.empty());
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Some topicId1 = new Some((Object)Uuid.randomUuid());
        Some topicId2 = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset, (Option)None$.MODULE$);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset, (Option)None$.MODULE$);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)leader);
        Mockito.when((Object)leader.brokerEndPoint()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        boolean bl = false;
        None$ none$ = None$.MODULE$;
        None$ none$2 = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ none$3 = None$.MODULE$;
        None$ apply_topicId = None$.MODULE$;
        Object var18_19 = null;
        none$3 = null;
        truncating$ = null;
        none$2 = null;
        none$ = null;
        boolean bl2 = false;
        None$ none$4 = None$.MODULE$;
        None$ none$5 = None$.MODULE$;
        Truncating$ truncating$2 = Truncating$.MODULE$;
        None$ apply_lag3 = None$.MODULE$;
        Object var24_24 = null;
        truncating$2 = null;
        none$5 = null;
        none$4 = null;
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId, fetchOffset, (Option)apply_lag2, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state4, (Option)apply_lastFetchedEpoch4, (Option)apply_replicationSessionId4, (int)apply_failedAttempts4))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId1, fetchOffset, (Option)apply_lag3, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state3, (Option)apply_lastFetchedEpoch3, (Option)apply_replicationSessionId3, (int)apply_failedAttempts3)));
        boolean bl3 = false;
        None$ none$6 = None$.MODULE$;
        None$ none$7 = None$.MODULE$;
        Truncating$ truncating$3 = Truncating$.MODULE$;
        None$ none$8 = None$.MODULE$;
        None$ apply_topicId2 = None$.MODULE$;
        Object var29_30 = null;
        none$8 = null;
        truncating$3 = null;
        none$7 = null;
        none$6 = null;
        boolean bl4 = false;
        None$ none$9 = None$.MODULE$;
        None$ none$10 = None$.MODULE$;
        Truncating$ truncating$4 = Truncating$.MODULE$;
        None$ apply_lag4 = None$.MODULE$;
        Object var35_35 = null;
        truncating$4 = null;
        none$10 = null;
        none$9 = null;
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId2, fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state2, (Option)apply_lastFetchedEpoch2, (Option)apply_replicationSessionId2, (int)apply_failedAttempts2))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId2, fetchOffset, (Option)apply_lag4, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch, (Option)apply_replicationSessionId, (int)apply_failedAttempts)));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})), (FetcherPool)FetcherPool.InSync$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds);
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp1), (Option)topicId1);
        AbstractFetcherManagerTest.verifyFetchState$2(fetcher.fetchState(tp2), (Option)topicId2);
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, 6);
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, 6);
    }

    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, "topic_");
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                return this.$outer.new TestResizeFetcherThread(new MockResizeFetcherLeaderEndPoint(this.$outer, sourceBroker), this.failedPartitions(), this.pausedPartitions(), this.$outer.new MockResizeFetcherTierStateMachine());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1, (FetchConnectionsMode)FetchConnectionsMode.Isolated$.MODULE$, (Option)None$.MODULE$, (Map)Map$.MODULE$.empty());
            }
        };
        try {
            fetcherManager.addFetcherForPartitions((Map)((IterableOnceOps)fetchingTopicPartitions.map((Function1 & Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, new StringBuilder(11).append("kafka-host-").append(brokerId).toString(), 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L, (Option)None$.MODULE$));
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (FetcherPool)FetcherPool.Default$.MODULE$, fetcherManager.addFetcherForPartitions$default$3());
            ((IterableOnceOps)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize, fetcherManager.resizeThreadPool$default$2());
            scala.collection.mutable.Set ownedPartitions = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
            fetcherManager.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1), arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String topic = new StringBuilder(0).append(topicPrefix).append(i).toString();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            return !(string != null ? !string.equals(name$1) : name$1 != null);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            String string2 = "MinFetchRate";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$2(Tuple2 x0$2) {
        if (x0$2 != null) {
            String string = ((MetricName)x0$2._1()).getName();
            String string2 = "MinFetchRate";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$3(MetricName k) {
        return k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name()) || k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            String string = ((MetricName)x0$3._1()).getName();
            String string2 = "TotalFetchRate";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$5(Tuple2 x0$4) {
        if (x0$4 != null) {
            MetricName k = (MetricName)x0$4._1();
            String string = k.getName();
            String string2 = "MinFetchRate";
            return string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.Default$.MODULE$.name());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRateMetric$6(Tuple2 x0$5) {
        if (x0$5 != null) {
            MetricName k = (MetricName)x0$5._1();
            String string = k.getName();
            String string2 = "MinFetchRate";
            return string != null && string.equals(string2) && k.getMBeanName().contains(FetcherPool.InSync$.MODULE$.name());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testTotalLagMetric$1(int i) {
        return new TopicPartition("topic", i);
    }

    public static final /* synthetic */ FetcherLagMetrics $anonfun$testMigrateInSyncPartitions$1(ClientIdAndBroker metricId$2, TopicPartition k) {
        return new FetcherLagMetrics(new ClientIdTopicPartition(metricId$2.clientId(), k), (Map)Map$.MODULE$.empty());
    }

    private static final void verifyFetchState$1(AbstractFetcherThread fetcher, TopicPartition tp, Option expectedTopicId) {
        Option fetchState = fetcher.fetchState(tp);
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    private static final void verifyFetchState$2(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, FetcherPool fetcherPool$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp, fetcherPool$1), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, FetcherTag brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        FetcherPool fetcherPool = brokerIdAndFetcherId.fetcherPool();
        fetcherThread.partitions().foreach((Function1 & Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherPool, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public AbstractFetcherManagerTest() {
        this.fetchOffset = 10L;
        this.leaderEpoch = 15;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, FetcherTag brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class MockResizeFetcherLeaderEndPoint
    implements LeaderEndPoint {
        private final BrokerEndPoint sourceBroker;
        private final boolean isTruncationOnFetchSupported;
        public final /* synthetic */ AbstractFetcherManagerTest $outer;

        public void initiateClose() {
        }

        public void close() {
        }

        public BrokerEndPoint brokerEndPoint() {
            return this.sourceBroker;
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            return new AbstractFetcherThread.ResultWithPartitions((Object)None$.MODULE$, (Map)Map$.MODULE$.empty());
        }

        public boolean isReadyForFetch(TopicPartition tp) {
            return true;
        }

        public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return (Map)Map$.MODULE$.empty();
        }

        public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int currentLeaderEpoch) {
            throw new UnsupportedOperationException("fetchTierMaterializationTargetFromLeader is not supported in this test");
        }

        public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
            return (Map)Map$.MODULE$.empty();
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockResizeFetcherLeaderEndPoint$$$outer() {
            return this.$outer;
        }

        public MockResizeFetcherLeaderEndPoint(AbstractFetcherManagerTest $outer, BrokerEndPoint sourceBroker) {
            this.sourceBroker = sourceBroker;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.isTruncationOnFetchSupported = false;
        }
    }

    private class MockResizeFetcherTierStateMachine
    implements TierStateMachine {
        public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
            throw new UnsupportedOperationException("Materializing tier state is not supported in this test.");
        }

        public Optional<PartitionFetchState> maybeAdvanceState(TopicPartition tp, PartitionFetchState currentFetchState) {
            return Optional.empty();
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockResizeFetcherTierStateMachine$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public MockResizeFetcherTierStateMachine() {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
        }
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        private final boolean isOffsetForLeaderEpochSupported;

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
            return true;
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return new Some((Object)new OffsetAndEpoch(1L, 0));
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return this.isOffsetForLeaderEpochSupported;
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(MockResizeFetcherLeaderEndPoint leader, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, TierStateMachine fetchTierStateMachine) {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            ExponentialBackoff x$7 = new ExponentialBackoff(0L, 2, 1000L, 0.0);
            BrokerTopicStats x$8 = new BrokerTopicStats();
            boolean x$9 = true;
            Map x$10 = (Map)Map$.MODULE$.empty();
            super("test-resize-fetcher", "mock-fetcher", (LeaderEndPoint)leader, failedPartitions, pausedPartitions, x$7, fetchTierStateMachine, x$9, x$8, x$10);
            this.isOffsetForLeaderEpochSupported = false;
        }
    }
}

