/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.network.SocketServer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.$less$colon$less$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0004\t\u00015A\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!\u0006\u0005\u00067\u0001!\t\u0001\b\u0005\u0006A\u0001!\t!\t\u0005\u0006Y\u0001!\t!\t\u0005\u0006a\u0001!I!\r\u0005\u0006\u0013\u0002!IA\u0013\u0002\u001f\u00032dwnY1uKB\u0013x\u000eZ;dKJLEm\u001d*fcV,7\u000f\u001e+fgRT!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0017aB2mkN$XM\u001d\t\u0003-ei\u0011a\u0006\u0006\u00031)\tA\u0001^3ti&\u0011!d\u0006\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"!H\u0010\u0011\u0005y\u0001Q\"\u0001\u0005\t\u000bQ\u0011\u0001\u0019A\u000b\u0002OQ,7\u000f^!mY>\u001c\u0017\r^3Qe>$WoY3sg&#7+\u001a8u)>\u001cuN\u001c;s_2dWM\u001d\u000b\u0002EA\u0011qbI\u0005\u0003IA\u0011A!\u00168ji\"\u00121A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S]\t!\"\u00198o_R\fG/[8o\u0013\tY\u0003FA\u0006DYV\u001cH/\u001a:UKN$\u0018A\u000b;fgR\fE\u000e\\8dCR,\u0007K]8ek\u000e,'o]%e'\u0016tG\u000fV8O_:\u001cuN\u001c;s_2dWM\u001d\u0015\u0005\t\u0019rs&A\u0006d_:$(o\u001c7mKJ\u001cX$A\u0002\u0002CM,g\u000eZ!oIJ+7-Z5wK\u0006cGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ:\u0015\u0007IzD\t\u0005\u00024{5\tAG\u0003\u00026m\u0005A!/Z9vKN$8O\u0003\u00028q\u000511m\\7n_:T!aC\u001d\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\u0005\u0003}Q\u00121$\u00117m_\u000e\fG/\u001a)s_\u0012,8-\u001a:JIN\u0014Vm\u001d9p]N,\u0007\"\u0002!\u0006\u0001\u0004\t\u0015\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bC\u0001\u0010C\u0013\t\u0019\u0005B\u0001\u0007Ce>\\WM]*feZ,'\u000fC\u0003F\u000b\u0001\u0007a)\u0001\td_:$(o\u001c7mKJ\u001cVM\u001d<feB\u0011adR\u0005\u0003\u0011\"\u0011\u0001cQ8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:\u0002#\r|gN\\3di\u0006sGMU3dK&4X\rF\u00023\u0017NCQ\u0001\u0014\u0004A\u00025\u000bacY8oiJ|G\u000e\\3s'>\u001c7.\u001a;TKJ4XM\u001d\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!*\tqA\\3uo>\u00148.\u0003\u0002S\u001f\na1k\\2lKR\u001cVM\u001d<fe\")AK\u0002a\u0001+\u00069!/Z9vKN$\bCA\u001aW\u0013\t9FG\u0001\u000eBY2|7-\u0019;f!J|G-^2fe&#7OU3rk\u0016\u001cH\u000f\u000b\u0003\u00013\u000e$\u0007C\u0001.b\u001b\u0005Y&B\u0001/^\u0003\r\t\u0007/\u001b\u0006\u0003=~\u000bqA[;qSR,'O\u0003\u0002aw\u0005)!.\u001e8ji&\u0011!m\u0017\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005A\b\u0006\u0002\u0001gG2\u0004\"a\u001a6\u000e\u0003!T!![.\u0002\u0013\u0015DH/\u001a8tS>t\u0017BA6i\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0002[\u000e\na\u000e\u0005\u0002pc6\t\u0001O\u0003\u0002a/%\u0011!\u000f\u001d\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8tQ\u0011\u0001Ao\u001e=\u0011\u0005\u001d*\u0018B\u0001<)\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;t\u0003-\u0019G.^:uKJ$\u0016\u0010]3%\u0003eL!A_>\u0002\u000b-\u0013\u0016I\u0012+\u000b\u0005qD\u0013\u0001\u0002+za\u0016DS\u0001\u0001@d\u0003\u0007\u0001\"AW@\n\u0007\u0005\u00051LA\u0002UC\u001e\f#!!\u0002\u0002\u0017%tG/Z4sCRLwN\u001c")
public class AllocateProducerIdsRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest
    public void testAllocateProducersIdSentToController() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        BrokerServer sourceBroker = raftCluster.brokers().findFirst().get();
        int controllerId = sourceBroker.raftManager().leaderAndEpoch().leaderId().getAsInt();
        ControllerServer controllerServer = raftCluster.controllers().filter(x$1 -> x$1.config().nodeId() == controllerId).findFirst().get();
        AllocateProducerIdsResponse allocateResponse = this.sendAndReceiveAllocateProducerIds(sourceBroker, controllerServer);
        Assertions.assertEquals((Object)Errors.NONE, (Object)allocateResponse.error());
        Assertions.assertEquals((int)1000, (int)allocateResponse.data().producerIdLen());
        Assertions.assertTrue((allocateResponse.data().producerIdStart() >= 0L ? 1 : 0) != 0);
    }

    @ClusterTest(controllers=3)
    public void testAllocateProducersIdSentToNonController() {
        RaftClusterInvocationContext.RaftClusterInstance raftCluster = (RaftClusterInvocationContext.RaftClusterInstance)this.cluster;
        BrokerServer sourceBroker = raftCluster.brokers().findFirst().get();
        int controllerId = sourceBroker.raftManager().leaderAndEpoch().leaderId().getAsInt();
        ControllerServer controllerServer = raftCluster.controllers().filter(x$2 -> x$2.config().nodeId() != controllerId).findFirst().get();
        AllocateProducerIdsResponse allocateResponse = this.sendAndReceiveAllocateProducerIds(sourceBroker, controllerServer);
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)allocateResponse.data().errorCode()));
    }

    private AllocateProducerIdsResponse sendAndReceiveAllocateProducerIds(BrokerServer sourceBroker, ControllerServer controllerServer) {
        AllocateProducerIdsRequest allocateRequest = (AllocateProducerIdsRequest)new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData().setBrokerId(sourceBroker.config().brokerId()).setBrokerEpoch(sourceBroker.lifecycleManager().brokerEpoch())).build();
        return this.connectAndReceive(controllerServer.socketServer(), allocateRequest);
    }

    private AllocateProducerIdsResponse connectAndReceive(SocketServer controllerSocketServer, AllocateProducerIdsRequest request) {
        return (AllocateProducerIdsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controllerSocketServer, this.cluster.controllerListenerName().get(), ClassTag$.MODULE$.apply(AllocateProducerIdsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public AllocateProducerIdsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

