/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.network.SocketServer;
import kafka.server.AlterMirrorsRequestTest$SourceRecord$;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ClusterTestDefaults(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
@ExtendWith(value={ClusterTestExtensions.class})
@Tags(value={@Tag(value="integration"), @Tag(value="bazel:size:large")})
@ScalaSignature(bytes="\u0006\u0005\u0011Ec\u0001\u0002'N\u0001IC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006M\u0002!\ta\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0011\u0019)\b\u0001)A\u0005[\"9a\u000f\u0001b\u0001\n\u00139\bBB>\u0001A\u0003%\u0001P\u0002\u0003}\u0001\u0001k\bBCA\u000e\u000f\tU\r\u0011\"\u0001\u0002\u001e!Q\u0011QF\u0004\u0003\u0012\u0003\u0006I!a\b\t\u0013\u0005=rA!f\u0001\n\u00039\b\"CA\u0019\u000f\tE\t\u0015!\u0003y\u0011)\t\u0019d\u0002BK\u0002\u0013\u0005\u0011Q\u0007\u0005\u000b\u0003\u0007:!\u0011#Q\u0001\n\u0005]\u0002BCA#\u000f\tU\r\u0011\"\u0001\u00026!Q\u0011qI\u0004\u0003\u0012\u0003\u0006I!a\u000e\t\u0015\u0005%sA!f\u0001\n\u0003\tY\u0005\u0003\u0006\u0002T\u001d\u0011\t\u0012)A\u0005\u0003\u001bBaAZ\u0004\u0005\u0002\u0005U\u0003\"CA3\u000f\u0005\u0005I\u0011AA4\u0011%\t\u0019hBI\u0001\n\u0003\t)\bC\u0005\u0002\f\u001e\t\n\u0011\"\u0001\u0002\u000e\"I\u0011\u0011S\u0004\u0012\u0002\u0013\u0005\u00111\u0013\u0005\n\u0003/;\u0011\u0013!C\u0001\u0003'C\u0011\"!'\b#\u0003%\t!a'\t\u0011\u0005}u!!A\u0005B1D\u0001\"!)\b\u0003\u0003%\ta\u001e\u0005\n\u0003G;\u0011\u0011!C\u0001\u0003KC\u0011\"!-\b\u0003\u0003%\t%a-\t\u0013\u0005\u0005w!!A\u0005\u0002\u0005\r\u0007\"CAg\u000f\u0005\u0005I\u0011IAh\u0011%\t\u0019nBA\u0001\n\u0003\n)\u000eC\u0005\u0002X\u001e\t\t\u0011\"\u0011\u0002Z\"I\u00111\\\u0004\u0002\u0002\u0013\u0005\u0013Q\\\u0004\n\u0003C\u0004\u0011\u0011!E\u0001\u0003G4\u0001\u0002 \u0001\u0002\u0002#\u0005\u0011Q\u001d\u0005\u0007M\u000e\"\t!!@\t\u0013\u0005]7%!A\u0005F\u0005e\u0007\"CA\u0000G\u0005\u0005I\u0011\u0011B\u0001\u0011%\u0011iaIA\u0001\n\u0003\u0013y\u0001C\u0004\u0003\"\u0001!\tAa\t\t\u000f\t=\u0003\u0001\"\u0001\u0003R!9!1\u0014\u0001\u0005\u0002\tE\u0003b\u0002BQ\u0001\u0011\u0005!\u0011\u000b\u0005\b\u0005O\u0003A\u0011\u0001B)\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005#BqAa-\u0001\t\u0003\u0011\t\u0006C\u0004\u0003:\u0002!\tA!\u0015\t\u000f\tu\u0006\u0001\"\u0001\u0003R!9!\u0011\u0019\u0001\u0005\u0002\tE\u0003b\u0002Bc\u0001\u0011\u0005!\u0011\u000b\u0005\b\u0005\u0017\u0004A\u0011\u0001B)\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0005#BqAa6\u0001\t\u0003\u0011\t\u0006C\u0004\u0003f\u0002!\tA!\u0015\t\u000f\t-\b\u0001\"\u0003\u0003n\"911\u0002\u0001\u0005\n\r5\u0001bBB\u0010\u0001\u0011%1\u0011\u0005\u0005\n\u0007[\u0001\u0011\u0013!C\u0005\u0007_A\u0011ba\r\u0001#\u0003%Iaa\f\t\u000f\rU\u0002\u0001\"\u0003\u00048!91q\b\u0001\u0005\n\r\u0005\u0003bBB#\u0001\u0011%1q\t\u0005\b\u0007\u001f\u0002A\u0011BB)\u0011\u001d\u0019\u0019\b\u0001C\u0005\u0007kBqaa\u001d\u0001\t\u0013\u00199\tC\u0005\u0004,\u0002\t\n\u0011\"\u0003\u0004.\"I1\u0011\u0017\u0001\u0012\u0002\u0013%\u0011Q\u0012\u0005\b\u0007g\u0003A\u0011BB[\u0011\u001d\u0019I\r\u0001C\u0005\u0007\u0017Dqaa6\u0001\t\u0013\u0019I\u000eC\u0004\u0004f\u0002!Iaa:\t\u000f\rM\b\u0001\"\u0003\u0004v\"911 \u0001\u0005\n\ru\bb\u0002C\u0002\u0001\u0011%AQ\u0001\u0005\b\t\u0017\u0001A\u0011\u0002C\u0007\u0005]\tE\u000e^3s\u001b&\u0014(o\u001c:t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002O\u001f\u000611/\u001a:wKJT\u0011\u0001U\u0001\u0006W\u000647.Y\u0002\u0001'\r\u00011+\u0017\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,\u0016\u0002\u0007\u0003:L(+\u001a4\u0011\u0005ikV\"A.\u000b\u0005q{\u0015!B;uS2\u001c\u0018B\u00010\\\u0005\u001daunZ4j]\u001e\fqb\u00197vgR,'/\u00138ti\u0006t7-\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G>\u000bA\u0001^3ti&\u0011QM\u0019\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"\u0001\u001b6\u0011\u0005%\u0004Q\"A'\t\u000b}\u0013\u0001\u0019\u00011\u0002\u00111Lgn\u001b(b[\u0016,\u0012!\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fA\u0001\\1oO*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0019\u0019FO]5oO\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN,\u0012\u0001\u001f\t\u0003)fL!A_+\u0003\u0007%sG/A\tsKF,Xm\u001d;US6,w.\u001e;Ng\u0002\u0012AbU8ve\u000e,'+Z2pe\u0012\u001cRaB*\u007f\u0003\u0007\u0001\"\u0001V@\n\u0007\u0005\u0005QKA\u0004Qe>$Wo\u0019;\u0011\t\u0005\u0015\u0011Q\u0003\b\u0005\u0003\u000f\t\tB\u0004\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti!U\u0001\u0007yI|w\u000e\u001e \n\u0003YK1!a\u0005V\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0006\u0002\u001a\ta1+\u001a:jC2L'0\u00192mK*\u0019\u00111C+\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003SqA!a\t\u0002&A\u0019\u0011\u0011B+\n\u0007\u0005\u001dR+\u0001\u0004Qe\u0016$WMZ\u0005\u0004i\u0006-\"bAA\u0014+\u00061Ao\u001c9jG\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0002\u0015A\f'\u000f^5uS>t\u0007%A\u0002lKf,\"!a\u000e\u0011\u000bQ\u000bI$!\u0010\n\u0007\u0005mRKA\u0003BeJ\f\u0017\u0010E\u0002U\u0003\u007fI1!!\u0011V\u0005\u0011\u0011\u0015\u0010^3\u0002\t-,\u0017\u0010I\u0001\u0006m\u0006dW/Z\u0001\u0007m\u0006dW/\u001a\u0011\u0002\r=4gm]3u+\t\ti\u0005E\u0002U\u0003\u001fJ1!!\u0015V\u0005\u0011auN\\4\u0002\u000f=4gm]3uAQa\u0011qKA.\u0003;\ny&!\u0019\u0002dA\u0019\u0011\u0011L\u0004\u000e\u0003\u0001Aq!a\u0007\u0013\u0001\u0004\ty\u0002\u0003\u0004\u00020I\u0001\r\u0001\u001f\u0005\b\u0003g\u0011\u0002\u0019AA\u001c\u0011\u001d\t)E\u0005a\u0001\u0003oAq!!\u0013\u0013\u0001\u0004\ti%\u0001\u0003d_BLH\u0003DA,\u0003S\nY'!\u001c\u0002p\u0005E\u0004\"CA\u000e'A\u0005\t\u0019AA\u0010\u0011!\tyc\u0005I\u0001\u0002\u0004A\b\"CA\u001a'A\u0005\t\u0019AA\u001c\u0011%\t)e\u0005I\u0001\u0002\u0004\t9\u0004C\u0005\u0002JM\u0001\n\u00111\u0001\u0002N\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA<U\u0011\ty\"!\u001f,\u0005\u0005m\u0004\u0003BA?\u0003\u000fk!!a \u000b\t\u0005\u0005\u00151Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\"V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\u000byHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0010*\u001a\u00010!\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0013\u0016\u0005\u0003o\tI(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q\u0014\u0016\u0005\u0003\u001b\nI(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9+!,\u0011\u0007Q\u000bI+C\u0002\u0002,V\u00131!\u00118z\u0011!\tykGA\u0001\u0002\u0004A\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00026B1\u0011qWA_\u0003Ok!!!/\u000b\u0007\u0005mV+\u0001\u0006d_2dWm\u0019;j_:LA!a0\u0002:\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)-a3\u0011\u0007Q\u000b9-C\u0002\u0002JV\u0013qAQ8pY\u0016\fg\u000eC\u0005\u00020v\t\t\u00111\u0001\u0002(\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\ri\u0017\u0011\u001b\u0005\t\u0003_s\u0012\u0011!a\u0001q\u0006A\u0001.Y:i\u0007>$W\rF\u0001y\u0003!!xn\u0015;sS:<G#A7\u0002\r\u0015\fX/\u00197t)\u0011\t)-a8\t\u0013\u0005=\u0016%!AA\u0002\u0005\u001d\u0016\u0001D*pkJ\u001cWMU3d_J$\u0007cAA-GM)1%a:\u0002tBy\u0011\u0011^Ax\u0003?A\u0018qGA\u001c\u0003\u001b\n9&\u0004\u0002\u0002l*\u0019\u0011Q^+\u0002\u000fI,h\u000e^5nK&!\u0011\u0011_Av\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\u000e\t\u0005\u0003k\fY0\u0004\u0002\u0002x*\u0019\u0011\u0011`9\u0002\u0005%|\u0017\u0002BA\f\u0003o$\"!a9\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0005]#1\u0001B\u0003\u0005\u000f\u0011IAa\u0003\t\u000f\u0005ma\u00051\u0001\u0002 !1\u0011q\u0006\u0014A\u0002aDq!a\r'\u0001\u0004\t9\u0004C\u0004\u0002F\u0019\u0002\r!a\u000e\t\u000f\u0005%c\u00051\u0001\u0002N\u00059QO\\1qa2LH\u0003\u0002B\t\u0005;\u0001R\u0001\u0016B\n\u0005/I1A!\u0006V\u0005\u0019y\u0005\u000f^5p]BaAK!\u0007\u0002 a\f9$a\u000e\u0002N%\u0019!1D+\u0003\rQ+\b\u000f\\36\u0011%\u0011ybJA\u0001\u0002\u0004\t9&A\u0002yIA\nQa]3ukB$BA!\n\u0003,A\u0019AKa\n\n\u0007\t%RK\u0001\u0003V]&$\bb\u0002B\u0017Q\u0001\u0007!qF\u0001\u000eG2,8\u000f^3s\u0007>tg-[4\u0011\u0007\u0005\u0014\t$C\u0002\u00034\t\u0014Qb\u00117vgR,'oQ8oM&<\u0007f\u0001\u0015\u00038A!!\u0011\bB&\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012aA1qS*!!\u0011\tB\"\u0003\u001dQW\u000f]5uKJTAA!\u0012\u0003H\u0005)!.\u001e8ji*\u0011!\u0011J\u0001\u0004_J<\u0017\u0002\u0002B'\u0005w\u0011!BQ3g_J,W)Y2i\u0003U!Xm\u001d;BYR,'/T5se>\u00148/R7qif$\"A!\n)\u000f%\u0012)&!\u0012\u0003`A!!q\u000bB.\u001b\t\u0011IFC\u0002\u0002\u0006\nLAA!\u0018\u0003Z\ta1\t\\;ti\u0016\u0014H+Z:ug22!\u0011\rB=\u0005\u0003[#Ba\u0019\u0003j\t-$Q\u000fB<!\u0011\u00119F!\u001a\n\t\t\u001d$\u0011\f\u0002\f\u00072,8\u000f^3s)\u0016\u001cH/A\u0006dYV\u001cH/\u001a:UsB,GE\u0001B7\u0013\u0011\u0011yG!\u001d\u0002\u0005i[%\u0002\u0002B:\u00053\nA\u0001V=qK\u00069!M]8lKJ\u001cX$A\u0001,\r\t\r$\u0011\u000eB>I\t\u0011i(\u0003\u0003\u0003\u0000\tE\u0014!B&S\u0003\u001a#6F\u0003B2\u0005S\u0012YHa!\u0003\u0006\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000e\n\u0002\u0003\b&!!\u0011\u0012BF\u0003-I%\tU04?Zz\u0016J\u0016\u0019\u000b\t\t5%qR\u0001\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]*!!\u0011\u0013BJ\u0003\u0019\u0019w.\\7p]*\u0019aJ!&\u000b\u0007A\u00139J\u0003\u0003\u0003\u001a\n\u001d\u0013AB1qC\u000eDW-A\u000buKN$\u0018\t\u001c;fe6K'O]8sg\n\u000bGm\u00149)\u000f)\u0012)&!\u0012\u0003 22!\u0011\rB=\u0005\u0003\u000bq\u0003^3ti\u001a\u000b\u0017\u000e\\8wKJl\u0015N\u001d:peR{\u0007/[2)\u000f-\u0012)&!\u0012\u0003&22!\u0011\rB=\u0005\u0003\u000ba\u0003^3tiB\u0013x.\\8uK6K'O]8s)>\u0004\u0018n\u0019\u0015\bY\tU\u0013Q\tBVY\u0019\u0011\tG!\u001f\u0003\u0002\u0006yB/Z:u'R|\u0007/T5se>\u0014Hk\u001c9jG&sg/\u00197jIR{\u0007/[2)\u000f5\u0012)&!\u0012\u0003222!\u0011\rB=\u0005\u0003\u000b1\u0005^3tiN#x\u000e]'jeJ|'\u000fV8qS\u000etuN\\3ySN$XM\u001c;U_BL7\rK\u0004/\u0005+\n)Ea.-\r\t\u0005$\u0011\u0010BA\u0003Q!Xm\u001d;DY\u0016\f'/T5se>\u0014Hk\u001c9jG\"ZqFa\u0019\u0003j\t-$Q\u000fB<\u0003\u0001\"Xm\u001d;DY\u0016\f'/T5se>\u0014Hk\u001c9jG&sg/\u00197jIR{\u0007/[2)\u0017A\u0012\u0019G!\u001b\u0003l\tU$qO\u0001%i\u0016\u001cHo\u00117fCJl\u0015N\u001d:peR{\u0007/[2O_:,\u00070[:uK:$Hk\u001c9jG\"Z\u0011Ga\u0019\u0003j\t-$Q\u000fB<\u0003Q!Xm\u001d;QCV\u001cX-T5se>\u0014Hk\u001c9jG\":!G!\u0016\u0002F\t%GF\u0002B1\u0005s\u0012\t)\u0001\u0011uKN$\b+Y;tK6K'O]8s)>\u0004\u0018nY%om\u0006d\u0017\u000e\u001a+pa&\u001c\u0007fB\u001a\u0003V\u0005\u0015#q\u001a\u0017\u0007\u0005C\u0012IH!!\u0002IQ,7\u000f\u001e)bkN,W*\u001b:s_J$v\u000e]5d\u001d>tW\r_5ti\u0016tG\u000fV8qS\u000eDs\u0001\u000eB+\u0003\u000b\u0012)\u000e\f\u0004\u0003b\te$\u0011Q\u0001*i\u0016\u001cHOU3wKJ\u001cX-\u00118e'^\f\u0007o\u00149t+:\u001cX\u000f\u001d9peR,G\r\u0015:f\u0013\n\u00036gN\u0019)\u000fU\u0012)&!\u0012\u0003\\2\u0012!Q\\\u0016\u000b\u0005G\u0012IGa\u001f\u0003\u0004\n}GE\u0001Bq\u0013\u0011\u0011\u0019Oa#\u0002\u0017%\u0013\u0005kX\u001a`o}Ke\u000bM\u0001@i\u0016\u001cHOU3wKJ\u001cX-\u00118e'^\f\u0007o\u00149fe\u0006$\u0018n\u001c8JgJ+'.Z2uK\u0012<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u00032$XM]'jeJ|'o\u00149tQ\u001d1$QKA#\u0005SdcA!\u0019\u0003z\t\u0005\u0015\u0001\u0006:v]^KG\u000f\u001b*f[>$Xm\u00117vgR,'\u000f\u0006\u0003\u0003&\t=\bb\u0002Byo\u0001\u0007!1_\u0001\tG\u0006dGNY1dWBYAK!>\u0002 \te(1 B\u0013\u0013\r\u001190\u0016\u0002\n\rVt7\r^5p]N\u0002R\u0001\u0016B\n\u0003?\u0001BA!@\u0004\b5\u0011!q \u0006\u0005\u0007\u0003\u0019\u0019!A\u0003bI6LgN\u0003\u0003\u0004\u0006\tU\u0015aB2mS\u0016tGo]\u0005\u0005\u0007\u0013\u0011yP\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002+\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7nV5uQRA!QEB\b\u00073\u0019Y\u0002C\u0004\u0004\u0012a\u0002\raa\u0005\u0002\u0017\u0005$W.\u001b8DY&,g\u000e\u001e\t\u0005\u0005{\u001c)\"\u0003\u0003\u0004\u0018\t}(!B!e[&t\u0007BB69\u0001\u0004\ty\u0002C\u0004\u0004\u001ea\u0002\r!a\b\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001c\u0018aD2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5\u0015\u0015\t\u001521EB\u0013\u0007O\u0019I\u0003C\u0004\u0004\u0012e\u0002\raa\u0005\t\u000f\u0005m\u0011\b1\u0001\u0002 !A1.\u000fI\u0001\u0002\u0004\u0011I\u0010C\u0005\u0004,e\u0002\n\u00111\u0001\u0003z\u0006YQ.\u001b:s_J$v\u000e]5d\u0003e\u0019'/Z1uKR{\u0007/[2XSRDG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\rE\"\u0006\u0002B}\u0003s\n\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%i\u0005y1\u000f^8q\u001b&\u0014(o\u001c:U_BL7\r\u0006\u0004\u0003&\re21\b\u0005\b\u00037a\u0004\u0019AA\u0010\u0011\u001d\u0019i\u0004\u0010a\u0001\u0003\u000b\f1b]=oG\"\u0014xN\\5{K\u0006\u00012\r\\3be6K'O]8s)>\u0004\u0018n\u0019\u000b\u0005\u0005K\u0019\u0019\u0005C\u0004\u0002\u001cu\u0002\r!a\b\u0002!A\fWo]3NSJ\u0014xN\u001d+pa&\u001cGC\u0002B\u0013\u0007\u0013\u001aY\u0005C\u0004\u0002\u001cy\u0002\r!a\b\t\u000f\r5c\b1\u0001\u0002F\u00061QM\\1cY\u0016\f1\"\u00197uKJl\u0015N\u001d:peR111KB4\u0007S\u0002ba!\u0016\u0004^\r\u0005TBAB,\u0015\u0011\u0019Ifa\u0017\u0002\u0013%tG/\u001a:oC2\u001c(\u0002\u0002BI\u0005+KAaa\u0018\u0004X\ty1*\u00194lC\u001a+H/\u001e:f\u00136\u0004H\u000eE\u0002o\u0007GJ1a!\u001ap\u0005\u00111v.\u001b3\t\u000f\u0005mq\b1\u0001\u0002 !911N A\u0002\r5\u0014AA8q!\u0011\u0011ipa\u001c\n\t\rE$q \u0002\u000e\u00032$XM]'jeJ|'o\u00149\u0002\u0019\u0005dG/\u001a:NSJ\u0014xN]:\u0015\t\r]4Q\u0010\t\u0007\u0003\u000b\u0019Iha\u0015\n\t\rm\u0014\u0011\u0004\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0004\u0000\u0001\u0003\ra!!\u0002\u001d\u0005dG/\u001a:NSJ\u0014xN](qgBA\u0011\u0011EBB\u0003?\u0019i'\u0003\u0003\u0004\u0006\u0006-\"aA'baRA1qOBE\u0007G\u001b9\u000bC\u0004\u0004\f\u0006\u0003\ra!$\u0002\u0007=\u00048\u000f\u0005\u0004\u0002\u0006\re4q\u0012\t\u0005\u0007#\u001biJ\u0004\u0003\u0004\u0014\u000eeUBABK\u0015\u0011\u00199ja\u0017\u0002\u000f5,7o]1hK&!11TBK\u0003]\tE\u000e^3s\u001b&\u0014(o\u001c:t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0004 \u000e\u0005&aD'jeJ|'o\u00149fe\u0006$\u0018n\u001c8\u000b\t\rm5Q\u0013\u0005\n\u0007K\u000b\u0005\u0013!a\u0001\u0003\u000b\fAB^1mS\u0012\fG/Z(oYfD\u0001b!+B!\u0003\u0005\r\u0001_\u0001\ni&lWm\\;u\u001bN\fa#\u00197uKJl\u0015N\u001d:peN$C-\u001a4bk2$HEM\u000b\u0003\u0007_SC!!2\u0002z\u00051\u0012\r\u001c;fe6K'O]8sg\u0012\"WMZ1vYR$3'A\ftK:$\u0017\t\u001c;fe6K'O]8sgJ+\u0017/^3tiRA1qWBb\u0007\u000b\u001c9\r\u0005\u0003\u0004:\u000e}VBAB^\u0015\u0011\u0019ila\u0017\u0002\u0011I,\u0017/^3tiNLAa!1\u0004<\n!\u0012\t\u001c;fe6K'O]8sgJ+7\u000f]8og\u0016Dqaa#E\u0001\u0004\u0019i\tC\u0004\u0004&\u0012\u0003\r!!2\t\r\r%F\t1\u0001y\u0003Q!Wm]2sS\n,7\t\\;ti\u0016\u0014H*\u001b8lgR!1QZBk!\u0019\t)a!\u001f\u0004PB!!Q`Bi\u0013\u0011\u0019\u0019Na@\u0003-\rcWo\u001d;fe2Kgn\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:Dqa!\u0001F\u0001\u0004\u0011Y0\u0001\u0006mSN$Hk\u001c9jGN$Baa7\u0004dB1\u0011QAB=\u0007;\u0004BA!@\u0004`&!1\u0011\u001dB\u0000\u00051!v\u000e]5d\u0019&\u001cH/\u001b8h\u0011\u001d\u0019\tA\u0012a\u0001\u0007'\ta\u0002Z3tGJL'-Z'jeJ|'\u000f\u0006\u0004\u0004j\u000e=8\u0011\u001f\t\u0005\u0005{\u001cY/\u0003\u0003\u0004n\n}(AF'jeJ|'\u000fV8qS\u000e$Um]2sSB$\u0018n\u001c8\t\u000f\r\u0005q\t1\u0001\u0003|\"9\u00111D$A\u0002\u0005}\u0011a\u00037jgRl\u0015N\u001d:peN$Baa>\u0004zB1\u0011QAB=\u0003?Aqa!\u0001I\u0001\u0004\u0011Y0A\nu_BL7-S:BGRLg/Z'jeJ|'\u000f\u0006\u0004\u0002F\u000e}H\u0011\u0001\u0005\b\u0007\u0003I\u0005\u0019\u0001B~\u0011\u001d\tY\"\u0013a\u0001\u0003?\t1\u0003^8qS\u000eL5\u000fU1vg\u0016$W*\u001b:s_J$b!!2\u0005\b\u0011%\u0001bBB\u0001\u0015\u0002\u0007!1 \u0005\b\u00037Q\u0005\u0019AA\u0010\u0003Q!x\u000e]5d\u0013N\u001cFo\u001c9qK\u0012l\u0015N\u001d:peR1\u0011Q\u0019C\b\t#Aqa!\u0001L\u0001\u0004\u0011Y\u0010C\u0004\u0002\u001c-\u0003\r!a\b)\u001f\u0001!)B!\u001b\u0005\u001c\tU$q\u000fC\u0011\u0005o\u0002BAa\u0016\u0005\u0018%!A\u0011\u0004B-\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;tI\t!i\"\u0003\u0003\u0005 \tE\u0014AE!M\u0019~suJT0D\u001fJ+5+\u0013#F\u001dR\u000b1bY8oiJ|G\u000e\\3sg\":\u0001\u0001\"\n\u0002F\u0011E\u0002\u0003\u0002C\u0014\t[i!\u0001\"\u000b\u000b\t\u0011-\"1H\u0001\nKb$XM\\:j_:LA\u0001b\f\u0005*\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5-\u0005\u0011M2E\u0001C\u001b!\u0011!9\u0004b\u000f\u000e\u0005\u0011e\"b\u0001B#E&!AQ\bC\u001d\u0005U\u0019E.^:uKJ$Vm\u001d;FqR,gn]5p]NDs\u0001\u0001C!\u0003\u000b\"9\u0005\u0005\u0003\u0003:\u0011\r\u0013\u0002\u0002C#\u0005w\u00111\u0001V1hC\t!I%A\u0006j]R,wM]1uS>t\u0007f\u0002\u0001\u0005B\u0005\u0015CQJ\u0011\u0003\t\u001f\n\u0001CY1{K2T4/\u001b>fu1\f'oZ3")
public class AlterMirrorsRequestTest
implements Logging {
    private volatile AlterMirrorsRequestTest$SourceRecord$ SourceRecord$module;
    private final ClusterInstance clusterInstance;
    private final String linkName;
    private final int requestTimeoutMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    public AlterMirrorsRequestTest$SourceRecord$ SourceRecord() {
        if (this.SourceRecord$module == null) {
            this.SourceRecord$lzycompute$1();
        }
        return this.SourceRecord$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private String linkName() {
        return this.linkName;
    }

    private int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    @BeforeEach
    public void setup(ClusterConfig clusterConfig) {
        clusterConfig.serverProperties().setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "encoder-secret");
        clusterConfig.serverProperties().setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        clusterConfig.serverProperties().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "1");
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testAlterMirrorsEmpty() {
        Assertions.assertTrue((boolean)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)package$.MODULE$.List().empty(), false, this.alterMirrors$default$3()).isEmpty());
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testAlterMirrorsBadOp() {
        AlterMirrorsRequestData.MirrorOperation badOp = new AlterMirrorsRequestData.MirrorOperation().setTopic("topic").setOperationCode((byte)127);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)new .colon.colon((Object)badOp, (List)Nil$.MODULE$), false, this.alterMirrors$default$3()).head(), InvalidRequestException.class, (Option<String>)None$.MODULE$);
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testFailoverMirrorTopic() {
        String topic = "topic";
        ConfluentAdmin localAdmin = (ConfluentAdmin)this.clusterInstance.createAdminClient();
        this.runWithRemoteCluster((Function3<String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function3 & Serializable)(remoteBootstrapServers, x$1, remoteAdmin) -> {
            AlterMirrorsRequestTest.$anonfun$testFailoverMirrorTopic$1(this, localAdmin, topic, remoteBootstrapServers, x$1, remoteAdmin);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testPromoteMirrorTopic() {
        String topic = "topic";
        ConfluentAdmin localAdmin = (ConfluentAdmin)this.clusterInstance.createAdminClient();
        this.runWithRemoteCluster((Function3<String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function3 & Serializable)(remoteBootstrapServers, x$2, remoteAdmin) -> {
            AlterMirrorsRequestTest.$anonfun$testPromoteMirrorTopic$1(this, localAdmin, topic, remoteBootstrapServers, x$2, remoteAdmin);
            return BoxedUnit.UNIT;
        });
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testStopMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.stopMirrorTopic("topic!", false));
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testStopMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.stopMirrorTopic("unknown-topic", false));
    }

    @ClusterTest(clusterType=Type.ZK, brokers=1)
    public void testClearMirrorTopic() {
        String activeTopic = "active-topic";
        String stoppedTopic = "stopped-topic";
        try (ConfluentAdmin localAdmin = (ConfluentAdmin)this.clusterInstance.createAdminClient();){
            this.runWithRemoteCluster((Function3<String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function3 & Serializable)(remoteBootstrapServers, x$3, remoteAdmin) -> {
                AlterMirrorsRequestTest.$anonfun$testClearMirrorTopic$1(this, localAdmin, activeTopic, stoppedTopic, remoteBootstrapServers, x$3, remoteAdmin);
                return BoxedUnit.UNIT;
            });
        }
    }

    @ClusterTest(clusterType=Type.ZK, brokers=1)
    public void testClearMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.clearMirrorTopic("topic!"));
    }

    @ClusterTest(clusterType=Type.ZK, brokers=1)
    public void testClearMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.clearMirrorTopic("unknown-topic"));
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testPauseMirrorTopic() {
        String topic = "topic";
        try (ConfluentAdmin localAdmin = (ConfluentAdmin)this.clusterInstance.createAdminClient();){
            this.runWithRemoteCluster((Function3<String, Option<String>, ConfluentAdmin, BoxedUnit>)(Function3 & Serializable)(remoteBootstrapServers, x$4, remoteAdmin) -> {
                AlterMirrorsRequestTest.$anonfun$testPauseMirrorTopic$1(this, localAdmin, topic, remoteBootstrapServers, x$4, remoteAdmin);
                return BoxedUnit.UNIT;
            });
        }
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testPauseMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.pauseMirrorTopic("topic!", true));
        Assertions.assertThrows(InvalidTopicException.class, () -> this.pauseMirrorTopic("topic!", false));
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testPauseMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.pauseMirrorTopic("unknown-topic", true));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.pauseMirrorTopic("unknown-topic", false));
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_7_IV0)})
    public void testReverseAndSwapOpsUnsupportedPreIBP371() {
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future<?>)this.alterMirror("topic1", AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR), (Class<? extends Throwable>)InvalidRequestException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future<?>)this.alterMirror("topic1", AlterMirrorOp.REVERSE_AND_PAUSE_REMOTE_MIRROR), (Class<? extends Throwable>)InvalidRequestException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future<?>)this.alterMirror("topic1", AlterMirrorOp.ROLLBACK), (Class<? extends Throwable>)InvalidRequestException.class, (Option<String>)None$.MODULE$);
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=1), @ClusterTest(clusterType=Type.KRAFT), @ClusterTest(clusterType=Type.KRAFT, metadataVersion=MetadataVersion.IBP_3_6_IV0)})
    public void testReverseAndSwapOperationIsRejectedWithMultipleAlterMirrorOps() {
        scala.collection.immutable.Map alterMirrorOps1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)AlterMirrorOp.REVERSE_AND_PAUSE_REMOTE_MIRROR)}));
        this.alterMirrors((scala.collection.immutable.Map<String, AlterMirrorOp>)alterMirrorOps1).foreach((Function1 & Serializable)x$5 -> {
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future<?>)x$5, (Class<? extends Throwable>)InvalidRequestException.class, (Option<String>)None$.MODULE$);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map alterMirrorOps2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)AlterMirrorOp.PAUSE)}));
        this.alterMirrors((scala.collection.immutable.Map<String, AlterMirrorOp>)alterMirrorOps2).foreach((Function1 & Serializable)x$6 -> {
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future<?>)x$6, (Class<? extends Throwable>)InvalidRequestException.class, (Option<String>)None$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    private void runWithRemoteCluster(Function3<String, Option<String>, ConfluentAdmin, BoxedUnit> callback) {
        ClusterInstance remoteCluster = this.clusterInstance.duplicateCluster(builder -> builder.brokers(1));
        remoteCluster.start();
        remoteCluster.waitForReadyBrokers();
        try {
            Admin admin = remoteCluster.createAdminClient();
            String clusterId = (String)admin.describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.requestTimeoutMs()))).clusterId().get();
            callback.apply((Object)remoteCluster.bootstrapServers(), (Object)Option$.MODULE$.apply((Object)clusterId), (Object)((ConfluentAdmin)admin));
        }
        finally {
            remoteCluster.stop();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createClusterLinkWith(Admin adminClient, String linkName, String bootstrapServers) {
        ConfluentAdmin admin = (ConfluentAdmin)adminClient;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)bootstrapServers)}));
        NewClusterLink newClusterLink = new NewClusterLink(linkName, null, CollectionConverters$.MODULE$.MapHasAsJava((Map)configs).asJava());
        admin.createClusterLinks(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)newClusterLink, (List)Nil$.MODULE$)).asJavaCollection(), (CreateClusterLinksOptions)new CreateClusterLinksOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.requestTimeoutMs()))).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterMirrorsRequestTest.$anonfun$createClusterLinkWith$1(this, admin)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterMirrorsRequestTest.$anonfun$createClusterLinkWith$2(linkName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createTopicWith(Admin adminClient, String topic, Option<String> linkName, Option<String> mirrorTopic) {
        ConfluentAdmin admin = (ConfluentAdmin)adminClient;
        NewTopic newTopic = new NewTopic(topic, Optional.empty(), Optional.of(BoxesRunTime.boxToShort((short)1)));
        linkName.foreach((Function1 & Serializable)ln -> newTopic.mirror(Optional.of(new NewMirrorTopic(ln, (String)mirrorTopic.get()))));
        admin.createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJavaCollection(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.requestTimeoutMs()))).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterMirrorsRequestTest.$anonfun$createTopicWith$2(this, adminClient)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterMirrorsRequestTest.$anonfun$createTopicWith$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (mirrorTopic.isDefined()) {
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!AlterMirrorsRequestTest.$anonfun$createTopicWith$4(this, adminClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)AlterMirrorsRequestTest.$anonfun$createTopicWith$5(topic));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            return;
        }
    }

    private Option<String> createTopicWith$default$3() {
        return None$.MODULE$;
    }

    private Option<String> createTopicWith$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private void stopMirrorTopic(String topic, boolean synchronize) {
        try {
            AlterMirrorOp stopOp = synchronize ? AlterMirrorOp.PROMOTE : AlterMirrorOp.FAILOVER;
            this.alterMirror(topic, stopOp).get();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.topicIsStoppedMirror((ConfluentAdmin)this.clusterInstance.createAdminClient(), topic)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)AlterMirrorsRequestTest.$anonfun$stopMirrorTopic$2(topic));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private void clearMirrorTopic(String topic) {
        try {
            this.alterMirror(topic, AlterMirrorOp.CLEAR).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void pauseMirrorTopic(String topic, boolean enable) {
        block7: {
            try {
                AlterMirrorOp pauseOp = enable ? AlterMirrorOp.PAUSE : AlterMirrorOp.RESUME;
                this.alterMirror(topic, pauseOp).get();
                if (enable) {
                    long l = 100L;
                    long waitUntilTrue_waitTimeMs = 15000L;
                    long waitUntilTrue_startTime = System.currentTimeMillis();
                    while (!this.topicIsPausedMirror((ConfluentAdmin)this.clusterInstance.createAdminClient(), topic)) {
                        void waitUntilTrue_pause;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                            Assertions.fail((String)AlterMirrorsRequestTest.$anonfun$pauseMirrorTopic$2(topic));
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    }
                    break block7;
                }
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!this.topicIsActiveMirror((ConfluentAdmin)this.clusterInstance.createAdminClient(), topic)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)AlterMirrorsRequestTest.$anonfun$pauseMirrorTopic$4(topic));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                return;
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }
    }

    private KafkaFutureImpl<Void> alterMirror(String topic, AlterMirrorOp op) {
        AlterMirrorsRequestData.MirrorOperation mirrorOp = new AlterMirrorsRequestData.MirrorOperation().setTopic(topic).setOperationCode(op.id());
        return (KafkaFutureImpl)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)new .colon.colon((Object)mirrorOp, (List)Nil$.MODULE$), false, this.alterMirrors$default$3()).head();
    }

    private List<KafkaFutureImpl<Void>> alterMirrors(scala.collection.immutable.Map<String, AlterMirrorOp> alterMirrorOps) {
        return this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)((IterableOnceOps)alterMirrorOps.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                AlterMirrorOp op = (AlterMirrorOp)x0$1._2();
                return new AlterMirrorsRequestData.MirrorOperation().setTopic(topic).setOperationCode(op.id());
            }
            throw new MatchError(null);
        })).toList(), false, this.alterMirrors$default$3());
    }

    private List<KafkaFutureImpl<Void>> alterMirrors(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs) {
        LinkedHashMap results = new LinkedHashMap();
        ops.foreach((Function1 & Serializable)op -> results.put(op.topic(), new KafkaFutureImpl()));
        this.sendAlterMirrorsRequest(ops, validateOnly, timeoutMs).complete(results);
        Assertions.assertEquals((int)ops.size(), (int)results.size());
        return CollectionConverters$.MODULE$.CollectionHasAsScala(results.values()).asScala().toList();
    }

    private boolean alterMirrors$default$2() {
        return false;
    }

    private int alterMirrors$default$3() {
        return this.requestTimeoutMs();
    }

    private AlterMirrorsResponse sendAlterMirrorsRequest(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs) {
        SocketServer socketServer = this.clusterInstance.brokerSocketServers().size() > 1 ? this.clusterInstance.anyNonControllerBrokerSocketServer() : this.clusterInstance.anyBrokerSocketServer();
        AlterMirrorsRequest request = (AlterMirrorsRequest)new AlterMirrorsRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava(ops).asJava(), validateOnly, timeoutMs).build();
        return (AlterMirrorsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, socketServer, this.clusterInstance.clientListener(), ClassTag$.MODULE$.apply(AlterMirrorsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private List<ClusterLinkDescription> describeClusterLinks(ConfluentAdmin admin) {
        return CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)admin.describeClusterLinks(new DescribeClusterLinksOptions().linkNames(Collections.singleton(this.linkName()))).result().get()).asScala().toList();
    }

    private List<TopicListing> listTopics(Admin admin) {
        return CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)admin.listTopics().listings().get()).asScala().toList();
    }

    private MirrorTopicDescription describeMirror(ConfluentAdmin admin, String topic) {
        return (MirrorTopicDescription)((java.util.Map)admin.describeMirrors(Collections.singleton(topic), new DescribeMirrorsOptions()).all().get()).get(topic);
    }

    private List<String> listMirrors(ConfluentAdmin admin) {
        return CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)admin.listMirrors(new ListMirrorsOptions()).result().get()).asScala().toList();
    }

    private boolean topicIsActiveMirror(ConfluentAdmin admin, String topic) {
        MirrorTopicDescription.State state = this.describeMirror(admin, topic).state();
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.ACTIVE;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    private boolean topicIsPausedMirror(ConfluentAdmin admin, String topic) {
        MirrorTopicDescription.State state = this.describeMirror(admin, topic).state();
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.PAUSED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    private boolean topicIsStoppedMirror(ConfluentAdmin admin, String topic) {
        MirrorTopicDescription.State state = this.describeMirror(admin, topic).state();
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    private final void SourceRecord$lzycompute$1() {
        synchronized (this) {
            if (this.SourceRecord$module == null) {
                this.SourceRecord$module = new AlterMirrorsRequestTest$SourceRecord$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testFailoverMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$1, String topic$1, String remoteBootstrapServers, Option x$1, ConfluentAdmin remoteAdmin) {
        $this.createClusterLinkWith((Admin)localAdmin$1, $this.linkName(), remoteBootstrapServers);
        $this.createTopicWith((Admin)remoteAdmin, topic$1, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        $this.createTopicWith((Admin)localAdmin$1, topic$1, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)topic$1));
        $this.stopMirrorTopic(topic$1, false);
        Assertions.assertThrows(InvalidRequestException.class, () -> $this.stopMirrorTopic(topic$1, false));
    }

    public static final /* synthetic */ void $anonfun$testPromoteMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$2, String topic$2, String remoteBootstrapServers, Option x$2, ConfluentAdmin remoteAdmin) {
        $this.createClusterLinkWith((Admin)localAdmin$2, $this.linkName(), remoteBootstrapServers);
        $this.createTopicWith((Admin)remoteAdmin, topic$2, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        $this.createTopicWith((Admin)localAdmin$2, topic$2, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)topic$2));
        $this.stopMirrorTopic(topic$2, true);
        Assertions.assertThrows(InvalidRequestException.class, () -> $this.stopMirrorTopic(topic$2, true));
    }

    public static final /* synthetic */ boolean $anonfun$testClearMirrorTopic$2(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$3) {
        return $this.listMirrors(localAdmin$3).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClearMirrorTopic$3() {
        return "Expected to see no more mirrors configured.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testClearMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$3, String activeTopic$1, String stoppedTopic$1, String remoteBootstrapServers, Option x$3, ConfluentAdmin remoteAdmin) {
        try {
            $this.createClusterLinkWith((Admin)localAdmin$3, $this.linkName(), remoteBootstrapServers);
            $this.createTopicWith((Admin)remoteAdmin, activeTopic$1, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$3, activeTopic$1, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)activeTopic$1));
            Assertions.assertTrue((boolean)$this.topicIsActiveMirror(localAdmin$3, activeTopic$1));
            $this.clearMirrorTopic(activeTopic$1);
            $this.clearMirrorTopic(activeTopic$1);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!AlterMirrorsRequestTest.$anonfun$testClearMirrorTopic$2($this, localAdmin$3)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Expected to see no more mirrors configured.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            $this.createTopicWith((Admin)remoteAdmin, stoppedTopic$1, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$3, stoppedTopic$1, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)stoppedTopic$1));
            Assertions.assertTrue((boolean)$this.topicIsActiveMirror(localAdmin$3, stoppedTopic$1));
            $this.stopMirrorTopic(stoppedTopic$1, false);
            $this.clearMirrorTopic(stoppedTopic$1);
            Assertions.assertTrue((boolean)$this.listMirrors(localAdmin$3).isEmpty());
        }
        finally {
            remoteAdmin.close();
        }
    }

    public static final /* synthetic */ void $anonfun$testPauseMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$4, String topic$3, String remoteBootstrapServers, Option x$4, ConfluentAdmin remoteAdmin) {
        try {
            $this.createClusterLinkWith((Admin)localAdmin$4, $this.linkName(), remoteBootstrapServers);
            $this.createTopicWith((Admin)remoteAdmin, topic$3, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$4, topic$3, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)topic$3));
            Assertions.assertTrue((boolean)$this.topicIsActiveMirror(localAdmin$4, topic$3));
            $this.pauseMirrorTopic(topic$3, true);
            $this.pauseMirrorTopic(topic$3, true);
            $this.pauseMirrorTopic(topic$3, false);
            $this.pauseMirrorTopic(topic$3, false);
        }
        finally {
            remoteAdmin.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$createClusterLinkWith$1(AlterMirrorsRequestTest $this, ConfluentAdmin admin$1) {
        return $this.describeClusterLinks(admin$1).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$createClusterLinkWith$2(String linkName$1) {
        return new StringBuilder(33).append("Cluster link ").append(linkName$1).append(" not created in time").toString();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicWith$2(AlterMirrorsRequestTest $this, Admin adminClient$1) {
        return $this.listTopics(adminClient$1).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$createTopicWith$3(String topic$4) {
        return new StringBuilder(26).append("Topic ").append(topic$4).append(" not created in time").toString();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicWith$4(AlterMirrorsRequestTest $this, Admin adminClient$1) {
        return $this.listMirrors((ConfluentAdmin)adminClient$1).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$createTopicWith$5(String topic$4) {
        return new StringBuilder(33).append("Mirror topic ").append(topic$4).append(" not created in time").toString();
    }

    public static final /* synthetic */ String $anonfun$stopMirrorTopic$2(String topic$5) {
        return new StringBuilder(35).append("Topic ").append(topic$5).append(" not in STOPPED state in time").toString();
    }

    public static final /* synthetic */ String $anonfun$pauseMirrorTopic$2(String topic$6) {
        return new StringBuilder(34).append("Topic ").append(topic$6).append(" not in PAUSED state in time").toString();
    }

    public static final /* synthetic */ String $anonfun$pauseMirrorTopic$4(String topic$6) {
        return new StringBuilder(34).append("Topic ").append(topic$6).append(" not in ACTIVE state in time").toString();
    }

    public AlterMirrorsRequestTest(ClusterInstance clusterInstance) {
        this.clusterInstance = clusterInstance;
        this.linkName = "test-link";
        this.requestTimeoutMs = 15000;
    }

    public class SourceRecord
    implements Product,
    Serializable {
        private final String topic;
        private final int partition;
        private final byte[] key;
        private final byte[] value;
        private final long offset;
        public final /* synthetic */ AlterMirrorsRequestTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String topic() {
            return this.topic;
        }

        public int partition() {
            return this.partition;
        }

        public byte[] key() {
            return this.key;
        }

        public byte[] value() {
            return this.value;
        }

        public long offset() {
            return this.offset;
        }

        public SourceRecord copy(String topic, int partition, byte[] key, byte[] value, long offset) {
            return new SourceRecord(this.kafka$server$AlterMirrorsRequestTest$SourceRecord$$$outer(), topic, partition, key, value, offset);
        }

        public String copy$default$1() {
            return this.topic();
        }

        public int copy$default$2() {
            return this.partition();
        }

        public byte[] copy$default$3() {
            return this.key();
        }

        public byte[] copy$default$4() {
            return this.value();
        }

        public long copy$default$5() {
            return this.offset();
        }

        public String productPrefix() {
            return "SourceRecord";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.topic();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.partition());
                }
                case 2: {
                    return this.key();
                }
                case 3: {
                    return this.value();
                }
                case 4: {
                    return BoxesRunTime.boxToLong((long)this.offset());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SourceRecord;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "topic";
                }
                case 1: {
                    return "partition";
                }
                case 2: {
                    return "key";
                }
                case 3: {
                    return "value";
                }
                case 4: {
                    return "offset";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.topic())), (int)this.partition()), (int)Statics.anyHash((Object)this.key())), (int)Statics.anyHash((Object)this.value())), (int)Statics.longHash((long)this.offset())), (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof SourceRecord && ((SourceRecord)x$1).kafka$server$AlterMirrorsRequestTest$SourceRecord$$$outer() == this.kafka$server$AlterMirrorsRequestTest$SourceRecord$$$outer())) break block3;
                    SourceRecord sourceRecord = (SourceRecord)x$1;
                    if (this.partition() != sourceRecord.partition() || this.offset() != sourceRecord.offset()) break block3;
                    String string = this.topic();
                    String string2 = sourceRecord.topic();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    if (this.key() != sourceRecord.key() || this.value() != sourceRecord.value() || !sourceRecord.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ AlterMirrorsRequestTest kafka$server$AlterMirrorsRequestTest$SourceRecord$$$outer() {
            return this.$outer;
        }

        public SourceRecord(AlterMirrorsRequestTest $outer, String topic, int partition, byte[] key, byte[] value, long offset) {
            this.topic = topic;
            this.partition = partition;
            this.key = key;
            this.value = value;
            this.offset = offset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

