/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.server.AlterPartitionManager;
import kafka.server.AlterPartitionManagerTest$;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.ZkAlterPartitionManager;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\ree\u0001B A\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004[\u0001\u0001\u0006IA\u0015\u0005\b7\u0002\u0011\r\u0011\"\u0001]\u0011\u0019A\u0007\u0001)A\u0005;\"9\u0011\u000e\u0001b\u0001\n\u0003Q\u0007B\u0002:\u0001A\u0003%1\u000eC\u0004t\u0001\t\u0007I\u0011\u0001;\t\ri\u0004\u0001\u0015!\u0003v\u0011\u001dY\bA1A\u0005\u0002qDq!!\u0001\u0001A\u0003%Q\u0010C\u0006\u0002\u0004\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0001bCA\b\u0001\u0001\u0007\t\u0019!C\u0001\u0003#A1\"!\b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\b!I\u0011q\u0004\u0001C\u0002\u0013\u0005\u0011\u0011\u0005\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002$!I\u00111\u0006\u0001C\u0002\u0013\u0005\u0011\u0011\u0005\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002$!I\u0011q\u0006\u0001C\u0002\u0013\u0005\u0011\u0011\u0005\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002$!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!a,\u0001\t\u0003\t\t\fC\u0004\u0002<\u0002!\t!!0\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u00026!9\u0011\u0011\u001b\u0001\u0005\u0002\u0005U\u0002bBAk\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u00033\u0004A\u0011AA\u001b\u0011\u001d\ti\u000e\u0001C\u0001\u0003kAq!!9\u0001\t\u0003\t)\u0004C\u0004\u0002f\u0002!I!a:\t\u000f\u0005e\b\u0001\"\u0003\u0002|\"9!Q\u0002\u0001\u0005\u0002\u0005U\u0002b\u0002B\t\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0005+\u0001A\u0011AA\u001b\u0011\u001d\u0011I\u0002\u0001C\u0001\u0003kAqA!\b\u0001\t\u0013\u0011y\u0002C\u0004\u0003$\u0001!IA!\n\t\u000f\tM\u0002\u0001\"\u0001\u00036!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u0005/\u0002A\u0011\u0002B-\u0011\u001d\u0011y\n\u0001C\u0005\u0005CCqAa5\u0001\t\u0013\u0011)\u000eC\u0004\u0003d\u0002!IA!:\t\u000f\rE\u0001\u0001\"\u0003\u0004\u0014!911\u0004\u0001\u0005\u0002\u0005U\u0002bBB\u0010\u0001\u0011\u00051\u0011\u0005\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011%\u0019I\u0005AI\u0001\n\u0013\u0019Y\u0005C\u0005\u0004b\u0001\t\n\u0011\"\u0003\u0004d!I1q\r\u0001\u0012\u0002\u0013%1\u0011\u000e\u0005\n\u0007[\u0002\u0011\u0013!C\u0005\u0007SB\u0011ba\u001c\u0001#\u0003%Ia!\u001b\t\u0013\rE\u0004!%A\u0005\n\rMtaBB<\u0001\"\u00051\u0011\u0010\u0004\u0007\u007f\u0001C\taa\u001f\t\r1[D\u0011AB?\u0011\u001d\t\ti\u000fC\u0001\u0007\u007fBq!!,<\t\u0003\u0019yIA\rBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:UKN$(BA!C\u0003\u0019\u0019XM\u001d<fe*\t1)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001dB\u0011q\nA\u0007\u0002\u0001\u0006)Ao\u001c9jGV\t!\u000b\u0005\u0002T16\tAK\u0003\u0002V-\u0006!A.\u00198h\u0015\u00059\u0016\u0001\u00026bm\u0006L!!\u0017+\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u00059Ao\u001c9jG&#W#A/\u0011\u0005y3W\"A0\u000b\u0005\u0001\f\u0017AB2p[6|gN\u0003\u0002DE*\u00111\rZ\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\f1a\u001c:h\u0013\t9wL\u0001\u0003Vk&$\u0017\u0001\u0003;pa&\u001c\u0017\n\u001a\u0011\u0002\tQLW.Z\u000b\u0002WB\u0011A\u000e]\u0007\u0002[*\u0011an\\\u0001\u0005kRLGN\u0003\u0002BC&\u0011\u0011/\u001c\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#A;\u0011\u0005YDX\"A<\u000b\u0005M|\u0016BA=x\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\tEJ|7.\u001a:JIV\tQ\u0010\u0005\u0002H}&\u0011q\u0010\u0013\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003I\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003\u0017i\u0011a\\\u0005\u0004\u0003\u001by'A\b(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003Y\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:`I\u0015\fH\u0003BA\n\u00033\u00012aRA\u000b\u0013\r\t9\u0002\u0013\u0002\u0005+:LG\u000fC\u0005\u0002\u001c5\t\t\u00111\u0001\u0002\b\u0005\u0019\u0001\u0010J\u0019\u0002'\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM\u001d\u0011\u0002\u0007Q\u0004\b'\u0006\u0002\u0002$A\u0019a,!\n\n\u0007\u0005\u001drL\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006!A\u000f\u001d\u0019!\u0003\r!\b/M\u0001\u0005iB\f\u0004%A\u0002uaJ\nA\u0001\u001e93A\u0005)1/\u001a;vaR\u0011\u00111\u0003\u0015\u0004+\u0005e\u0002\u0003BA\u001e\u0003\u0013j!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0004CBL'\u0002BA\"\u0003\u000b\nqA[;qSR,'OC\u0002\u0002H\u0011\fQA[;oSRLA!a\u0013\u0002>\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0013Q,7\u000f\u001e\"bg&\u001cG\u0003BA\n\u0003#Bq!a\u0015\u0017\u0001\u0004\t)&A\bnKR\fG-\u0019;b-\u0016\u00148/[8o!\u0011\t9&a\u0017\u000e\u0005\u0005e#B\u00011p\u0013\u0011\ti&!\u0017\u0003\u001f5+G/\u00193bi\u00064VM]:j_:D3AFA1!\u0011\t\u0019'!\u001b\u000e\u0005\u0005\u0015$\u0002BA4\u0003\u0003\na\u0001]1sC6\u001c\u0018\u0002BA6\u0003K\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d1\u0012qNA>\u0003{\u0002B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0005\u0003k\n)'\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\tI(a\u001d\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0005\u0005}\u0014EAAA\u0003]\u0001(o\u001c<jI\u0016lU\r^1eCR\fg+\u001a:tS>t7/\u0001\ruKN$()Y:jG^KG\u000f\u001b\"s_.,'/\u00129pG\"$B!a\u0005\u0002\b\"9\u00111K\fA\u0002\u0005U\u0003fA\f\u0002b!:q#a\u001c\u0002|\u00055EFAA@\u0003\u0001\"Xm\u001d;CCNL7mU3oi2+\u0017\rZ3s%\u0016\u001cwN^3ssN#\u0018\r^3\u0015\r\u0005M\u00111SAK\u0011\u001d\t\u0019\u0006\u0007a\u0001\u0003+Bq!a&\u0019\u0001\u0004\tI*A\nmK\u0006$WM\u001d*fG>4XM]=Ti\u0006$X\r\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\ty*Y\u0001\t[\u0016$\u0018\rZ1uC&!\u00111UAO\u0005MaU-\u00193feJ+7m\u001c<fef\u001cF/\u0019;fQ\rA\u0012\u0011\r\u0015\b1\u0005=\u00141PAUY\t\tY+\t\u0002\u0002.\u0006Q\u0002O]8wS\u0012,G*Z1eKJ\u0014VmY8wKJL8\u000b^1uK\u0006AB/Z:u\u001fZ,'o\u001e:ji\u0016<\u0016\u000e\u001e5j]\n\u000bGo\u00195\u0015\t\u0005M\u00111\u0017\u0005\b\u0003'J\u0002\u0019AA+Q\rI\u0012\u0011\r\u0015\b3\u0005=\u00141PA]Y\t\ty(A\buKN$8+\u001b8hY\u0016\u0014\u0015\r^2i)\u0011\t\u0019\"a0\t\u000f\u0005M#\u00041\u0001\u0002V!\u001a!$!\u0019)\u000fi\ty'a\u001f\u0002F2\u0012\u0011qP\u0001\u0017i\u0016\u001cHoU;c[&$hI]8n\u0007\u0006dGNY1dW\"\u001a1$a3\u0011\t\u0005m\u0012QZ\u0005\u0005\u0003\u001f\fiD\u0001\u0003UKN$\u0018a\u0006;fgR\fU\u000f\u001e5pe&T\u0018\r^5p]\u001a\u000b\u0017\u000e\\3eQ\ra\u00121Z\u0001\u0015i\u0016\u001cHo\u0015;bY\u0016\u0014%o\\6fe\u0016\u0003xn\u00195)\u0007u\tY-A\tuKN$XK\\6o_^t7+\u001a:wKJD3AHAf\u0003\u0001\"Xm\u001d;SKR\u0014\u0018p\u00148BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3)\u0007}\tY-\u0001\u0012uKN$(+\u001a;ss>sWK\\:vaB|'\u000f^3e-\u0016\u00148/[8o\u000bJ\u0014xN\u001d\u0015\u0004A\u0005-\u0017\u0001\u0007;fgR\u0014V\r\u001e:z\u001f:$v\u000e\u001d'fm\u0016dWI\u001d:peR!\u00111CAu\u0011\u001d\tY/\ta\u0001\u0003[\fQ!\u001a:s_J\u0004B!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0004\u0003g|\u0016\u0001\u00039s_R|7m\u001c7\n\t\u0005]\u0018\u0011\u001f\u0002\u0007\u000bJ\u0014xN]:\u00021Q,7\u000f\u001e*fiJLxJ\\#se>\u0014(+Z:q_:\u001cX\r\u0006\u0003\u0002\u0014\u0005u\bbBA\u0000E\u0001\u0007!\u0011A\u0001\te\u0016\u001c\bo\u001c8tKB!!1\u0001B\u0005\u001b\t\u0011)AC\u0002\u0003\b\u0005\fqa\u00197jK:$8/\u0003\u0003\u0003\f\t\u0015!AD\"mS\u0016tGOU3ta>t7/Z\u0001\u0019i\u0016\u001cH/\u00138wC2LG-\u00169eCR,g+\u001a:tS>t\u0007fA\u0012\u0002L\u0006IB/Z:u+:\\gn\\<o)>\u0004\u0018n\u0019)beRLG/[8oQ\r!\u00131Z\u0001\u0018i\u0016\u001cHOT8u\u0019\u0016\fG-\u001a:Pe\u001a{G\u000e\\8xKJD3!JAf\u0003I!Xm\u001d;J]Z\fG.\u001b3SKF,Xm\u001d;)\u0007\u0019\nY-A\ndQ\u0016\u001c7\u000eU1si&$\u0018n\u001c8FeJ|'\u000f\u0006\u0003\u0002\u0014\t\u0005\u0002bBAvO\u0001\u0007\u0011Q^\u0001\u0013i\u0016\u001cH\u000fU1si&$\u0018n\u001c8FeJ|'\u000f\u0006\u0004\u0003(\t5\"\u0011\u0007\t\u0004\u001f\n%\u0012b\u0001B\u0016\u0001\n)\u0012\t\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014\bb\u0002B\u0018Q\u0001\u0007\u00111E\u0001\u0003iBDq!a;)\u0001\u0004\ti/A\buKN$xJ\\3J]\u001ac\u0017n\u001a5u)\u0011\t\u0019Ba\u000e\t\u000f\u0005M\u0013\u00061\u0001\u0002V!\u001a\u0011&!\u0019)\u000f%\ny'a\u001f\u0003>1\u0012\u0011qP\u0001\u001fi\u0016\u001cH\u000fU1si&$\u0018n\u001c8NSN\u001c\u0018N\\4J]J+7\u000f]8og\u0016$B!a\u0005\u0003D!9\u00111\u000b\u0016A\u0002\u0005U\u0003f\u0001\u0016\u0002b!:!&a\u001c\u0002|\t%CFAA@\u0003M!Xm\u001d;QCJ$\u0018.\u00197U_BL7-\u00133t)\u0011\t\u0019Ba\u0014\t\u000f\u0005M3\u00061\u0001\u0002V!\u001a1&!\u0019)\u000f-\ny'a\u001f\u0003V1\u0012\u0011qP\u0001\u0012m\u0016\u0014\u0018NZ=TK:$'+Z9vKN$HC\u0002B.\u0005C\u0012\u0019\u0007\u0005\u0003\u0002\n\tu\u0013b\u0001B0_\n\u00113i\u001c8ue>dG.\u001a:SKF,Xm\u001d;D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJDq!a\u0001-\u0001\u0004\t9\u0001C\u0004\u0003f1\u0002\rAa\u001a\u0002\u001f\u0015D\b/Z2uK\u0012\u0014V-];fgR\u0004bA!\u001b\u0003p\tMTB\u0001B6\u0015\r\u0011i\u0007Z\u0001\b[>\u001c7.\u001b;p\u0013\u0011\u0011\tHa\u001b\u0003\u001f\u0005\u0013x-^7f]Rl\u0015\r^2iKJ\u0004DA!\u001e\u0003\u000eB1!q\u000fBB\u0005\u0013sAA!\u001f\u0003\u00005\u0011!1\u0010\u0006\u0004\u0005{z\u0016\u0001\u0003:fcV,7\u000f^:\n\t\t\u0005%1P\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!!Q\u0011BD\u0005\u001d\u0011U/\u001b7eKJTAA!!\u0003|A!!1\u0012BG\u0019\u0001!ABa$\u0003d\u0005\u0005\t\u0011!B\u0001\u0005#\u00131a\u0018\u00133#\u0011\u0011\u0019J!'\u0011\u0007\u001d\u0013)*C\u0002\u0003\u0018\"\u0013qAT8uQ&tw\r\u0005\u0003\u0003z\tm\u0015\u0002\u0002BO\u0005w\u0012q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0001\u001dC2$XM\u001d)beRLG/[8o%\u0016\fX/Z:u\u001b\u0006$8\r[3s)\u0019\u0011\u0019Ka,\u0003JB1!\u0011\u000eB8\u0005K\u0003DAa*\u0003,B1!q\u000fBB\u0005S\u0003BAa#\u0003,\u0012Y!QV\u0017\u0002\u0002\u0003\u0005)\u0011\u0001BI\u0005\ryFe\r\u0005\b\u0005ck\u0003\u0019\u0001BZ\u0003])\u0007\u0010]3di\u0016$Gk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u00036\n\r\u00171\u0005\b\u0005\u0005o\u0013y\fE\u0002\u0003:\"k!Aa/\u000b\u0007\tuF)\u0001\u0004=e>|GOP\u0005\u0004\u0005\u0003D\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003F\n\u001d'aA*fi*\u0019!\u0011\u0019%\t\u000f\t-W\u00061\u0001\u0003N\u0006yQ\r\u001f9fGR,GMV3sg&|g\u000eE\u0002H\u0005\u001fL1A!5I\u0005\u0015\u0019\u0006n\u001c:u\u0003Ii\u0017m[3DY&,g\u000e\u001e*fgB|gn]3\u0015\r\t\u0005!q\u001bBp\u0011\u001d\tyP\fa\u0001\u00053\u0004BA!\u001f\u0003\\&!!Q\u001cB>\u0005Y\tE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,\u0007b\u0002Bq]\u0001\u0007!QZ\u0001\bm\u0016\u00148/[8o\u0003Ii\u0017m[3BYR,'\u000fU1si&$\u0018n\u001c8\u0015\t\te'q\u001d\u0005\b\u0005S|\u0003\u0019\u0001Bv\u0003\u0019!x\u000e]5dgB1!Q\u001eB|\u0005{tAAa<\u0003t:!!\u0011\u0018By\u0013\u0005I\u0015b\u0001B{\u0011\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B}\u0005w\u00141aU3r\u0015\r\u0011)\u0010\u0013\t\u0005\u0005\u007f\u001cYA\u0004\u0003\u0004\u0002\r\u001dQBAB\u0002\u0015\r\u0019)aX\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0019Iaa\u0001\u00025\u0005cG/\u001a:QCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$\u0015\r^1\n\t\r51q\u0002\u0002\n)>\u0004\u0018n\u0019#bi\u0006TAa!\u0003\u0004\u0004\u0005YR.Y6f\u00032$XM\u001d)beRLG/[8o)>\u0004\u0018n\u0019#bi\u0006$bA!@\u0004\u0016\re\u0001bBB\fa\u0001\u0007\u00111E\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:Dq!a;1\u0001\u0004\ti/A\u0006uKN$(l\u001b\"bg&\u001c\u0007fA\u0019\u0002L\u0006IB/Z:u\u0007\u0006t7+\u001e2nSR4%o\\7DC2d'-Y2l)\u0011\t\u0019ba\t\t\u000f\u0005M#\u00071\u0001\u0002V!\u001a!'!\u0019)\u000fI\ny'a\u001f\u0004*1\u0012\u0011qP\u0001\u0012a\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,GC\u0004Bm\u0007_\u0019\tda\r\u00048\rm2q\b\u0005\n\u0005_\u0019\u0004\u0013!a\u0001\u0003GA\u0011\"a;4!\u0003\u0005\r!!<\t\u0011\rU2\u0007%AA\u0002u\fa\u0002]1si&$\u0018n\u001c8Fa>\u001c\u0007\u000e\u0003\u0005\u0004:M\u0002\n\u00111\u0001~\u0003!aW-\u00193fe&#\u0007\u0002CB\u001fgA\u0005\t\u0019A?\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\n\u0007\u0003\u001a\u0004\u0013!a\u0001\u0007\u0007\n1![:s!\u0015\u0011io!\u0012~\u0013\u0011\u00199Ea?\u0003\t1K7\u000f^\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r5#\u0006BA\u0012\u0007\u001fZ#a!\u0015\u0011\t\rM3QL\u0007\u0003\u0007+RAaa\u0016\u0004Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00077B\u0015AC1o]>$\u0018\r^5p]&!1qLB+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r\u0015$\u0006BAw\u0007\u001f\n1\u0004]1si&$\u0018n\u001c8SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u001aTCAB6U\ri8qJ\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001b\u00027A\f'\u000f^5uS>t'+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00136\u0003m\u0001\u0018M\u001d;ji&|gNU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%mU\u00111Q\u000f\u0016\u0005\u0007\u0007\u001ay%A\rBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:UKN$\bCA(<'\tYd\t\u0006\u0002\u0004zQ\u00111\u0011\u0011\t\u0007\u0007\u0007\u001bY)!\u0016\u000e\u0005\r\u0015%\u0002BBD\u0007\u0013\u000baa\u001d;sK\u0006l'B\u00018W\u0013\u0011\u0019ii!\"\u0003\rM#(/Z1n)\t\u0019\t\n\u0005\u0004\u0004\u0004\u000e-51\u0013\t\u0005\u0003c\u001a)*\u0003\u0003\u0004\u0018\u0006M$!C!sOVlWM\u001c;t\u0001")
public class AlterPartitionManagerTest {
    private final String topic;
    private final Uuid topicId = Uuid.randomUuid();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private NodeToControllerChannelManager brokerToController;
    private final TopicIdPartition tp0 = new TopicIdPartition(this.topicId(), 0, this.topic());
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), 1, this.topic());
    private final TopicIdPartition tp2 = new TopicIdPartition(this.topicId(), 2, this.topic());

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterPartitionManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<MetadataVersion> provideMetadataVersions() {
        return AlterPartitionManagerTest$.MODULE$.provideMetadataVersions();
    }

    public String topic() {
        return this.topic;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public NodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(NodeToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicIdPartition tp0() {
        return this.tp0;
    }

    public TopicIdPartition tp1() {
        return this.tp1;
    }

    public TopicIdPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasic(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasicWithBrokerEpoch(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 101L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        ListBuffer isrWithBrokerEpoch = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable)ii -> AlterPartitionManagerTest.$anonfun$testBasicWithBrokerEpoch$3(isrWithBrokerEpoch, BoxesRunTime.unboxToInt((Object)ii)));
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, LeaderRecoveryState.RECOVERED, isrWithBrokerEpoch.toList(), 10, (Option)None$.MODULE$), 0, false);
        AlterPartitionRequestData expectedAlterPartitionData = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(101L);
        AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(this.topic()).setTopicId(this.topicId());
        if (metadataVersion.isTopicIdsSupported()) {
            ListBuffer newIsrWithBrokerEpoch = new ListBuffer();
            newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(1).setBrokerEpoch(101L));
            newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(2).setBrokerEpoch(102L));
            newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(3).setBrokerEpoch(103L));
            topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsrWithEpochs(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newIsrWithBrokerEpoch.toList()).asJava()));
        } else {
            topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()));
        }
        expectedAlterPartitionData.topics().add(topicData);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ArgumentCaptor captor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)captor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedAlterPartitionData, (Object)((AlterPartitionRequest)((AlterPartitionRequest.Builder)captor.getValue()).build()).data());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(MetadataVersion metadataVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10, (Option)None$.MODULE$), 0, false);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        LeaderRecoveryState expectedLeaderRecoveryState = metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED;
        AlterPartitionRequestData.PartitionData partitionReq = (AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0);
        Assertions.assertEquals((byte)expectedLeaderRecoveryState.value(), (byte)partitionReq.leaderRecoveryState());
        LeaderRecoveryState leaderRecoveryState2 = leaderRecoveryState;
        LeaderRecoveryState leaderRecoveryState3 = LeaderRecoveryState.RECOVERING;
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!(leaderRecoveryState2 != null ? !leaderRecoveryState2.equals(leaderRecoveryState3) : leaderRecoveryState3 != null) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)partitionReq.isUnclean()));
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOverwriteWithinBatch(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        CompletableFuture failedSubmitFuture = alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        if (request.version() < 3) {
            Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
            return;
        }
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsrWithEpochs().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testSingleBatch(MetadataVersion metadataVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(new TopicIdPartition(this.topicId(), 0, this.topic()), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable)i -> alterPartitionManager.submit(new TopicIdPartition(this.topicId(), BoxesRunTime.unboxToInt((Object)i), this.topic()), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testSubmitFromCallback() {
        AlterPartitionResponse alterPartitionRespWithPartitionError = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse errorResponse = this.makeClientResponse(alterPartitionRespWithPartitionError, ApiKeys.ALTER_PARTITION.latestVersion());
        int leaderId = 1;
        int leaderEpoch = 1;
        int partitionEpoch = 10;
        List isr = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderId, leaderEpoch, isr, LeaderRecoveryState.RECOVERED, partitionEpoch, (Option)None$.MODULE$);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false);
        CompletableFuture finalFuture = new CompletableFuture();
        future.whenComplete((x$2, e2) -> {
            if (e2 != null) {
                alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false).whenComplete((result, e) -> {
                    if (e != null) {
                        finalFuture.completeExceptionally((Throwable)e);
                        return;
                    }
                    finalFuture.complete(result);
                });
                return;
            }
            finalFuture.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Expected the future to be failed")));
        });
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(errorResponse);
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, partitionEpoch, leaderId, leaderEpoch, (List<Object>)isr);
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertEquals((Object)leaderAndIsr, finalFuture.get(200L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
    }

    private AlterPartitionManager testPartitionError(TopicIdPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(tp, LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterPartitionManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOneInFlight(MetadataVersion metadataVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterPartitionManager.submit(this.tp1(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterPartitionManager.submit(this.tp2(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartitionMissingInResponse(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isTopicIdsSupported() ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1;
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(this.tp0(), leaderAndIsr, controlledEpoch, false);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp0()}))), expectedVersion));
        CompletableFuture future2 = alterPartitionManager.submit(this.tp1(), leaderAndIsr, controlledEpoch, false);
        CompletableFuture future3 = alterPartitionManager.submit(this.tp2(), leaderAndIsr, controlledEpoch, false);
        callback1.onComplete(this.makeClientResponse(this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1(), this.tp2()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp2(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp1(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartialTopicIds(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        TopicIdPartition foo = new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo");
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), 0, "bar");
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), 0, "zar");
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, (Function0 & Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(zar, leaderAndIsr, controlledEpoch, false);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar}))), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        CompletableFuture future2 = alterPartitionManager.submit(foo, leaderAndIsr, controlledEpoch, false);
        CompletableFuture future3 = alterPartitionManager.submit(bar, leaderAndIsr, controlledEpoch, false);
        callback1.onComplete(this.makeClientResponse(this.makeAlterPartition((scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(zar, Errors.NONE), (List)Nil$.MODULE$)), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar}))), (short)1)).onComplete(this.makeClientResponse(this.makeAlterPartition((scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(foo, Errors.NONE), (List)new .colon.colon((Object)this.makeAlterPartitionTopicData(bar, Errors.NONE), (List)Nil$.MODULE$))), (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertTrue((boolean)future2.isDone());
        Assertions.assertTrue((boolean)future3.isDone());
    }

    private ControllerRequestCompletionHandler verifySendRequest(NodeToControllerChannelManager brokerToController, ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> expectedRequest) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)brokerToController)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.argThat(expectedRequest), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{brokerToController});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> alterPartitionRequestMatcher(Set<TopicIdPartition> expectedTopicPartitions, short expectedVersion) {
        return request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Assertions.assertEquals((short)expectedVersion, (short)alterPartitionRequest.version());
            Set requestTopicPartitions = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(alterPartitionRequest.data().topics()).asScala().flatMap((Function1 & Serializable)topicData -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicData.partitions()).asScala().map((Function1 & Serializable)partitionData -> new TopicIdPartition(topicData.topicId(), partitionData.partitionIndex(), topicData.topicName())))).toSet();
            Set set = expectedTopicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        };
    }

    private ClientResponse makeClientResponse(AlterPartitionResponse response, short version) {
        return new ClientResponse(new RequestHeader(response.apiKey(), version, "", 0), null, "", 0L, 0L, false, null, null, (AbstractResponse)AlterPartitionResponse.parse((ByteBuffer)MessageUtil.toByteBuffer((Message)response.data(), (short)version), (short)version, (MessageContext)MessageContext.IDENTITY));
    }

    private AlterPartitionResponse makeAlterPartition(scala.collection.immutable.Seq<AlterPartitionResponseData.TopicData> topics) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava()));
    }

    private AlterPartitionResponseData.TopicData makeAlterPartitionTopicData(TopicIdPartition topicIdPartition, Errors error) {
        return new AlterPartitionResponseData.TopicData().setTopicName(topicIdPartition.topic()).setTopicId(topicIdPartition.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition()).setErrorCode(error.code())));
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$4 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        ZkAlterPartitionManager zkIsrManager = new ZkAlterPartitionManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2, (Option)None$.MODULE$), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testCanSubmitFromCallback(MetadataVersion metadataVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterIsrManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (Function0 & Serializable)() -> metadataVersion);
        alterIsrManager.start();
        CompletableFuture future = this.submitAndVerify$1((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), alterIsrManager);
        future.whenComplete((x$5, x$6) -> this.submitAndVerify$1((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), alterIsrManager));
        AlterPartitionResponse alterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isDone());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)1, (int)request.data().topics().size());
        if (request.version() < 3) {
            Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
            return;
        }
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsrWithEpochs().size(), (int)1);
    }

    private AlterPartitionResponse partitionResponse(TopicIdPartition tp, Errors error, int partitionEpoch, int leaderId, int leaderEpoch, List<Object> isr) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setTopicName(tp.topic()).setTopicId(tp.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setPartitionEpoch(partitionEpoch).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isr.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setErrorCode(error.code()))))));
    }

    private TopicIdPartition partitionResponse$default$1() {
        return this.tp0();
    }

    private Errors partitionResponse$default$2() {
        return Errors.NONE;
    }

    private int partitionResponse$default$3() {
        return 0;
    }

    private int partitionResponse$default$4() {
        return 0;
    }

    private int partitionResponse$default$5() {
        return 0;
    }

    private List<Object> partitionResponse$default$6() {
        return package$.MODULE$.List().empty();
    }

    public static final /* synthetic */ ListBuffer $anonfun$testBasicWithBrokerEpoch$3(ListBuffer isrWithBrokerEpoch$1, int ii) {
        return (ListBuffer)isrWithBrokerEpoch$1.$plus$eq((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(ii).setBrokerEpoch((long)(100 + ii)));
    }

    private final CompletableFuture submitAndVerify$1(List isr, DefaultAlterPartitionManager alterIsrManager$1) {
        CompletableFuture future = alterIsrManager$1.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, isr, LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertFalse((boolean)future.isDone());
        return future;
    }

    public AlterPartitionManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

