/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Set;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.DefaultApiVersionManager;
import kafka.server.ForwardingManager;
import kafka.server.MetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.server.ClientMetricsManager;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0007\u000f\u0001MAQA\u0007\u0001\u0005\u0002mAqA\b\u0001C\u0002\u0013%q\u0004\u0003\u0004$\u0001\u0001\u0006I\u0001\t\u0005\bI\u0001\u0011\r\u0011\"\u0003&\u0011\u0019a\u0003\u0001)A\u0005M!)Q\u0006\u0001C\u0001]!)Q\r\u0001C\u0001M\")!\u000e\u0001C\u0001W\")A\u000f\u0001C\u0001k\")Q\u0010\u0001C\u0001k\")q\u0010\u0001C\u0001k\"1\u0011q\u0002\u0001\u0005\u0002U\u0014Q#\u00119j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0010!\u000511/\u001a:wKJT\u0011!E\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u00039\taB\u0019:pW\u0016\u0014h)Z1ukJ,7/F\u0001!!\ti\u0012%\u0003\u0002#\u001d\tq!I]8lKJ4U-\u0019;ve\u0016\u001c\u0018a\u00042s_.,'OR3biV\u0014Xm\u001d\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u00051\u0003CA\u0014+\u001b\u0005A#BA\u0015\u000f\u0003!iW\r^1eCR\f\u0017BA\u0016)\u0005=Q6.T3uC\u0012\fG/Y\"bG\",\u0017AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\ri\u0016\u001cH/\u00119j'\u000e|\u0007/\u001a\u000b\u0003_I\u0002\"!\u0006\u0019\n\u0005E2\"\u0001B+oSRDQa\r\u0004A\u0002Q\n\u0001\"\u00199j'\u000e|\u0007/\u001a\t\u0003k9s!AN&\u000f\u0005]BeB\u0001\u001dF\u001d\tI4I\u0004\u0002;\u0001:\u00111HP\u0007\u0002y)\u0011QHE\u0001\u0007yI|w\u000e\u001e \n\u0003}\n1a\u001c:h\u0013\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f%\u0011\u0011\u0003\u0012\u0006\u0003\u0003\nK!AR$\u0002\r\r|W.\\8o\u0015\t\tB)\u0003\u0002J\u0015\u00069Q.Z:tC\u001e,'B\u0001$H\u0013\taU*\u0001\bBa&lUm]:bO\u0016$\u0016\u0010]3\u000b\u0005%S\u0015BA(Q\u00051a\u0015n\u001d;f]\u0016\u0014H+\u001f9f\u0015\taU\n\u000b\u0002\u0007%B\u00111KW\u0007\u0002)*\u0011QKV\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005]C\u0016a\u00026va&$XM\u001d\u0006\u00033\n\u000bQA[;oSRL!a\u0017+\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0003\u0007;\u000e$\u0007C\u00010b\u001b\u0005y&B\u00011U\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018B\u00012`\u0005))e.^7T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0002i\u0005\u0001B/Z:u\t&\u001c\u0018M\u00197fI\u0006\u0003\u0018n\u001d\u000b\u0003_\u001dDQaM\u0004A\u0002QB#a\u0002*)\t\u001di6\rZ\u0001\u0013i\u0016\u001cH/\u00113wKJ$\u0018n]3e\u0003BL7\u000f\u0006\u00020Y\")Q\u000e\u0003a\u0001]\u0006i\u0011\r]5WSNL'-\u001b7jif\u0004\"!N8\n\u0005A\u0004&!D!qSZK7/\u001b2jY&$\u0018\u0010\u000b\u0002\t%\"\"\u0001\"X2tG\u0005q\u0017!\b;fgR\u001cuN\u001c;s_2dWM]!qS&sG/\u001a:tK\u000e$\u0018n\u001c8\u0015\u0003=B#!C<\u0011\u0005a\\X\"A=\u000b\u0005i4\u0016aA1qS&\u0011A0\u001f\u0002\u0005)\u0016\u001cH/\u0001\u0012uKN$XI\u001c<fY>\u0004X\rR5tC\ndW\r\u001a$pe.\u0013\u0016M\u001a;Ce>\\WM\u001d\u0015\u0003\u0015]\fq\u0006^3ti\u0016sg/\u001a7pa\u0016,e.\u00192mK\u0012<\u0006.\u001a8G_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJ\u0004&/Z:f]RDcaCA\u0002G\u0006%\u0001c\u0001=\u0002\u0006%\u0019\u0011qA=\u0003\u0011\u0011K7/\u00192mK\u0012\f#!a\u0003\u0002k\u0015s\u0017M\u00197fA\u00054G/\u001a:!K:\f'\r\\3!\u0017&\u0003V&N\u001d1A\u0019|'o^1sI&tw\rI5oA-\u000beiS!.cIB\u0004H\u000e\u0015\u0003\u0017]\fa\u0006^3ti\u0016sg/\u001a7pa\u0016$\u0015n]1cY\u0016$w\u000b[3o\r>\u0014x/\u0019:eS:<W*\u00198bO\u0016\u0014X)\u001c9us\"\u0012Ab\u001e")
public class ApiVersionManagerTest {
    private final BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
    private final ZkMetadataCache metadataCache = new ZkMetadataCache(1, MetadataVersion.latestTesting(), this.brokerFeatures(), (Seq)Seq$.MODULE$.empty(), false, false);

    private BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testApiScope(ApiMessageType.ListenerType apiScope) {
        None$ x$2 = None$.MODULE$;
        BrokerFeatures x$3 = this.brokerFeatures();
        ZkMetadataCache x$4 = this.metadataCache();
        boolean x$7 = false;
        None$ x$8 = None$.MODULE$;
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, (Option)x$2, x$3, (MetadataCache)x$4, true, x$7, ApiMessageType.ApiVisibility.CONFLUENT_CLOUD, (Option)x$8);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala(), (Object)versionManager.enabledApis());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala().forall((Function1 & Serializable)apiKey -> BoxesRunTime.boxToBoolean((boolean)ApiVersionManagerTest.$anonfun$testApiScope$1(versionManager, apiKey))));
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testDisabledApis(ApiMessageType.ListenerType apiScope) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, (Option)None$.MODULE$, this.brokerFeatures(), (MetadataCache)this.metadataCache(), false, false, ApiMessageType.ApiVisibility.DEFAULT, (Option)None$.MODULE$);
        ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope).forEach(apiKey -> {
            if (apiKey.messageType.latestVersionUnstable()) {
                Assertions.assertFalse((boolean)versionManager.isApiEnabled(apiKey, apiKey.latestVersion()), (String)new StringBuilder(29).append(apiKey).append(" version ").append(apiKey.latestVersion()).append(" should be disabled.").toString());
                return;
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ApiVisibility.class)
    public void testAdvertisedApis(ApiMessageType.ApiVisibility apiVisibility) {
        ClientMetricsManager clientMetricsManager = (ClientMetricsManager)Mockito.mock(ClientMetricsManager.class);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ApiMessageType.ListenerType.values()), (Function1 & Serializable)apiScope -> {
            ApiVersionManagerTest.$anonfun$testAdvertisedApis$1(this, apiVisibility, clientMetricsManager, apiScope);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testControllerApiIntersection() {
        short controllerMinVersion = 1;
        short controllerMaxVersion = 5;
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)new Some((Object)NodeApiVersions.create((short)ApiKeys.CREATE_TOPICS.id, (short)controllerMinVersion, (short)controllerMaxVersion)));
        ApiVersionsResponseData.ApiVersion alterConfigVersion = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, (Option)new Some((Object)forwardingManager), this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, false, ApiMessageType.ApiVisibility.DEFAULT, (Option)None$.MODULE$).apiVersionResponse(0).data().apiKeys().find(ApiKeys.CREATE_TOPICS.id);
        Assertions.assertNotNull((Object)alterConfigVersion);
        Assertions.assertEquals((short)controllerMinVersion, (short)alterConfigVersion.minVersion());
        Assertions.assertEquals((short)controllerMaxVersion, (short)alterConfigVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledForKRaftBroker() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        new .colon.colon((Object)new Some((Object)forwardingManager), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)forwardingManagerOpt -> {
            ApiVersionManagerTest.$anonfun$testEnvelopeDisabledForKRaftBroker$1(this, forwardingManagerOpt);
            return BoxedUnit.UNIT;
        });
    }

    @Disabled(value="Enable after enable KIP-590 forwarding in KAFKA-12886")
    @Test
    public void testEnvelopeEnabledWhenForwardingManagerPresent() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, (Option)new Some((Object)forwardingManager), this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, false, ApiMessageType.ApiVisibility.DEFAULT, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion()));
        Assertions.assertTrue((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        ApiVersionsResponseData.ApiVersion envelopeVersion = versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id);
        Assertions.assertNotNull((Object)envelopeVersion);
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.oldestVersion(), (short)envelopeVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.latestVersion(), (short)envelopeVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledWhenForwardingManagerEmpty() {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, (Option)None$.MODULE$, this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, false, ApiMessageType.ApiVisibility.DEFAULT, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion()));
        Assertions.assertTrue((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNotNull((Object)versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }

    public static final /* synthetic */ boolean $anonfun$testApiScope$1(DefaultApiVersionManager versionManager$1, ApiKeys apiKey) {
        return CollectionConverters$.MODULE$.ListHasAsScala(apiKey.allVersions()).asScala().forall((Function1 & Serializable)version -> BoxesRunTime.boxToBoolean((boolean)versionManager$1.isApiEnabled(apiKey, Predef$.MODULE$.Short2short(version))));
    }

    public static final /* synthetic */ void $anonfun$testAdvertisedApis$1(ApiVersionManagerTest $this, ApiMessageType.ApiVisibility apiVisibility$1, ClientMetricsManager clientMetricsManager$1, ApiMessageType.ListenerType apiScope) {
        None$ x$2 = None$.MODULE$;
        BrokerFeatures x$3 = $this.brokerFeatures();
        ZkMetadataCache x$4 = $this.metadataCache();
        Some x$7 = new Some((Object)clientMetricsManager$1);
        boolean x$8 = false;
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, (Option)x$2, x$3, (MetadataCache)x$4, true, x$8, apiVisibility$1, (Option)x$7);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)clientMetricsManager$1.isTelemetryReceiverConfigured())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ApiVersionsResponse apiVersionsResponse = versionManager.apiVersionResponse(0);
        ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope).forEach(apiKey -> {
            boolean isApiEnabled = versionManager.isApiEnabled(apiKey, apiKey.latestVersion());
            ApiMessageType.ApiVisibility apiVisibility = apiVisibility$1;
            ApiMessageType.ApiVisibility apiVisibility2 = ApiMessageType.ApiVisibility.CONFLUENT_CLOUD;
            if (!(apiVisibility != null ? !apiVisibility.equals(apiVisibility2) : apiVisibility2 != null)) {
                Assertions.assertTrue((boolean)isApiEnabled, (String)new StringBuilder(52).append(apiKey).append(" should be enabled when Confluent Cloud APIs enabled").toString());
                Assertions.assertNotNull((Object)apiVersionsResponse.apiVersion(apiKey.id), (String)new StringBuilder(43).append(apiKey).append(" should be included in ApiVersions response").toString());
                return;
            }
            ApiMessageType.ApiVisibility apiVisibility3 = apiKey.messageType.apiVisibility();
            ApiMessageType.ApiVisibility apiVisibility4 = ApiMessageType.ApiVisibility.CONFLUENT_CLOUD;
            boolean expectApiVisible = apiVisibility3 == null ? apiVisibility4 != null : !apiVisibility3.equals(apiVisibility4);
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectApiVisible), (Object)BoxesRunTime.boxToBoolean((boolean)isApiEnabled));
            if (expectApiVisible) {
                Assertions.assertNotNull((Object)apiVersionsResponse.apiVersion(apiKey.id), (String)new StringBuilder(78).append(apiKey).append(" should be included in ApiVersions response when Confluent Cloud APIs disabled").toString());
                return;
            }
            Assertions.assertNull((Object)apiVersionsResponse.apiVersion(apiKey.id), (String)new StringBuilder(80).append(apiKey).append(" should be excluded from ApiVersions response when Confluent Cloud APIs disabled").toString());
        });
    }

    public static final /* synthetic */ void $anonfun$testEnvelopeDisabledForKRaftBroker$1(ApiVersionManagerTest $this, Option forwardingManagerOpt) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.BROKER, forwardingManagerOpt, $this.brokerFeatures(), (MetadataCache)$this.metadataCache(), true, false, ApiMessageType.ApiVisibility.DEFAULT, (Option)None$.MODULE$);
        Assertions.assertFalse((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion()));
        Assertions.assertFalse((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNull((Object)versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }
}

