/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractApiVersionsRequestTest;
import kafka.server.ApiVersionsRequestTest$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterGenerator;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.ALL_NON_CORESIDENT, brokers=1)
@ScalaSignature(bytes="\u0006\u0005\u0005us!\u0002\n\u0014\u0011\u0003Ab!\u0002\u000e\u0014\u0011\u0003Y\u0002\"\u0002\u0012\u0002\t\u0003\u0019\u0003\"\u0002\u0013\u0002\t\u0003)c\u0001\u0002\u000e\u0014\u0001EB\u0001\"\u000e\u0003\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006E\u0011!\t!\u000f\u0005\u0006y\u0011!\t!\u0010\u0005\u0006!\u0012!\t!\u0015\u0005\u00067\u0012!\t!\u0015\u0005\u0006Y\u0012!\t!\u0015\u0005\u0006}\u0012!\t!\u0015\u0005\u0007\u0003\u001f!A\u0011A)\t\r\u0005eA\u0001\"\u0001R\u0011\u0019\ti\u0002\u0002C\u0001#\"1\u0011\u0011\u0005\u0003\u0005\u0002ECa!a\n\u0005\t\u0003\t\u0006BBA\u0016\t\u0011\u0005\u0011+\u0001\fBa&4VM]:j_:\u001c(+Z9vKN$H+Z:u\u0015\t!R#\u0001\u0004tKJ4XM\u001d\u0006\u0002-\u0005)1.\u00194lC\u000e\u0001\u0001CA\r\u0002\u001b\u0005\u0019\"AF!qSZ+'o]5p]N\u0014V-];fgR$Vm\u001d;\u0014\u0005\u0005a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00021\u0005Q1\u000f^1cY\u0016\f\u0005/[:\u0015\u0005\u0019J\u0003CA\u000f(\u0013\tAcD\u0001\u0003V]&$\b\"\u0002\u0016\u0004\u0001\u0004Y\u0013!C4f]\u0016\u0014\u0018\r^8s!\tas&D\u0001.\u0015\tqS#\u0001\u0003uKN$\u0018B\u0001\u0019.\u0005A\u0019E.^:uKJ<UM\\3sCR|'o\u0005\u0002\u0005eA\u0011\u0011dM\u0005\u0003iM\u0011a$\u00112tiJ\f7\r^!qSZ+'o]5p]N\u0014V-];fgR$Vm\u001d;\u0002\u000f\rdWo\u001d;feB\u0011AfN\u0005\u0003q5\u0012qb\u00117vgR,'/\u00138ti\u0006t7-\u001a\u000b\u0003um\u0002\"!\u0007\u0003\t\u000bU2\u0001\u0019\u0001\u001c\u0002\u000bM,G/\u001e9\u0015\u0005\u0019r\u0004\"B \b\u0001\u0004\u0001\u0015AB2p]\u001aLw\r\u0005\u0002-\u0003&\u0011!)\f\u0002\u000e\u00072,8\u000f^3s\u0007>tg-[4)\u0005\u001d!\u0005CA#O\u001b\u00051%BA$I\u0003\r\t\u0007/\u001b\u0006\u0003\u0013*\u000bqA[;qSR,'O\u0003\u0002L\u0019\u0006)!.\u001e8ji*\tQ*A\u0002pe\u001eL!a\u0014$\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\fuKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u00051\u0003\u0006\u0002\u0005T3j\u0003\"\u0001V,\u000e\u0003US!AV\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002Y+\ny1\t\\;ti\u0016\u0014H+Z7qY\u0006$X-A\u0003wC2,X-I\u0001%\u00031\"Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$\u0018J\\2mk\u0012,7/\u00168sK2,\u0017m]3e\u0003BL7\u000f\u000b\u0003\n;\u0002\f\u0007C\u0001+_\u0013\tyVKA\u0006DYV\u001cH/\u001a:UKN$\u0018aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8%\u0003\tL!a\u00193\u0002\u0017%\u0013\u0005kX\u001a`q}Ke\u000b\r\u0006\u0003K\u001a\fq\"T3uC\u0012\fG/\u0019,feNLwN\u001c\u0006\u0003O\"\faaY8n[>t'B\u0001\u000bj\u0015\t1\"N\u0003\u0002l\u0019\u00061\u0011\r]1dQ\u0016\fq\u0005^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f^%oG2,H-Z:DY>,H-\u00119jg\"\"!\"\u00188p\u0003A\u0019XM\u001d<feB\u0013x\u000e]3si&,7\u000f\f\u0002qs.*\u0011\u000f^;ZoB\u0011AK]\u0005\u0003gV\u0013Qc\u00117vgR,'oQ8oM&<\u0007K]8qKJ$\u00180A\u0002lKf\f\u0013A^\u0001\u0019G>tg\r\\;f]Rt\u0013\r]5/m&\u001c\u0018NY5mSRL\u0018%\u0001=\u0002\u001f\r{eJ\u0012'V\u000b:#vl\u0011'P+\u0012[S!\u001d;{3r\f\u0013a_\u0001\u001dk:\u001cH/\u00192mK:\n\u0007/\u001b\u0018wKJ\u001c\u0018n\u001c8t]\u0015t\u0017M\u00197fC\u0005i\u0018!\u00024bYN,\u0017!\r;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;UQJ|Wo\u001a5D_:$(o\u001c7QY\u0006tW\rT5ti\u0016tWM\u001d\u0015\n\u0017u\u000b\t!a\u0001o\u0003\u001b\t1b\u00197vgR,'\u000fV=qK\u0012\u0012\u0011QA\u0005\u0005\u0003\u000f\tI!\u0001\u0002[\u0017*\u0019\u00111B+\u0002\tQK\b/\u001a\u0017\u0002s\u0006yC/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000f\u00165s_V<\u0007nQ8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8fe\"2A\"XA\u0001\u0003'!#!!\u0006\n\t\u0005]\u0011\u0011B\u0001\u0006\u0017J\u000be\tV\u0001-i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti^KG\u000f[+ogV\u0004\bo\u001c:uK\u00124VM]:j_:D#!D/\u0002EQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR4\u0016\r\\5eCRLwN\u001c,1Q\u0011q1+\u0017.\u0002{Q,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR4\u0016\r\\5eCRLwN\u001c,1)\"\u0014x.^4i\u0007>tGO]8m!2\fg.\u001a'jgR,g.\u001a:)\u0013=i\u0016\u0011AA\u0002]\u0006\u0015B&A=\u0002wQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR4\u0016\r\\5eCRLwN\u001c,1)\"\u0014x.^4i\u0007>tGO]8mY\u0016\u0014H*[:uK:,'\u000f\u000b\u0004\u0011;\u0006\u0005\u00111C\u0001#i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiZ\u000bG.\u001b3bi&|gNV\u001a)\u0005Ei\u0006F\u0002\u0003\u00022e\u000bi\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9DR\u0001\nKb$XM\\:j_:LA!a\u000f\u00026\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5-\u0005\u0005}2EAA!!\u0011\t\u0019%a\u0012\u000e\u0005\u0005\u0015#BA&.\u0013\u0011\tI%!\u0012\u0003+\rcWo\u001d;feR+7\u000f^#yi\u0016t7/[8og\"ZA!!\u0014\u0002\u0002\u0005M\u0013\u0011LA.!\r!\u0016qJ\u0005\u0004\u0003#*&aE\"mkN$XM\u001d+fgR$UMZ1vYR\u001cHEAA+\u0013\u0011\t9&!\u0003\u0002%\u0005cEj\u0018(P\u001d~\u001buJU#T\u0013\u0012+e\nV\u0001\bEJ|7.\u001a:t;\u0005\t\u0001")
public class ApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    public static void stableApis(ClusterGenerator generator) {
        ApiVersionsRequestTest$.MODULE$.stableApis(generator);
    }

    @BeforeEach
    public void setup(ClusterConfig config) {
        super.brokerPropertyOverrides(config.serverProperties());
    }

    @ClusterTemplate(value="stableApis")
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(metadataVersion=MetadataVersion.IBP_3_8_IV0)
    public void testApiVersionsRequestIncludesUnreleasedApis() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        ListenerName x$3 = this.validateApiVersionsResponse$default$2();
        ApiMessageType.ApiVisibility x$4 = this.validateApiVersionsResponse$default$4();
        boolean x$5 = this.validateApiVersionsResponse$default$5();
        this.validateApiVersionsResponse(apiVersionsResponse, x$3, true, x$4, x$5);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.api.visibility", value="CONFLUENT_CLOUD"), @ClusterConfigProperty(key="unstable.api.versions.enable", value="false")})
    public void testApiVersionsRequestIncludesCloudApis() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        ListenerName x$3 = this.validateApiVersionsResponse$default$2();
        boolean x$4 = this.validateApiVersionsResponse$default$3();
        boolean x$5 = this.validateApiVersionsResponse$default$5();
        this.validateApiVersionsResponse(apiVersionsResponse, x$3, x$4, ApiMessageType.ApiVisibility.CONFLUENT_CLOUD, x$5);
    }

    @ClusterTest(clusterType=Type.ZK, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false")})
    public void testApiVersionsRequestThroughControlPlaneListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testApiVersionsRequestThroughControllerListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controllerListenerName().get(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
        Assertions.assertFalse((boolean)apiVersionsResponse.data().apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersion apiVersion = apiVersionsResponse.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
    }

    @ClusterTemplate(value="stableApis")
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(clusterType=Type.ZK, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false")})
    public void testApiVersionsRequestValidationV0ThroughControlPlaneListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testApiVersionsRequestValidationV0ThroughControllerListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controllerListenerName().get(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)apiVersionsResponse.data().errorCode());
    }

    public ApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

