/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.replication.push.ReplicationConfig;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseFetchRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.AppendRecordsRequestData;
import org.apache.kafka.common.message.AppendRecordsResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AppendRecordsRequest;
import org.apache.kafka.common.requests.AppendRecordsResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005c\u0001\u0002\u00180\u0001QBQ!\u000f\u0001\u0005\u0002iBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019!\u0006\u0001)A\u0005\u0013\"IQ\u000b\u0001a\u0001\u0002\u0004%\tA\u0016\u0005\nS\u0002\u0001\r\u00111A\u0005\u0002)D\u0011\"\u001d\u0001A\u0002\u0003\u0005\u000b\u0015B,\t\u0013I\u0004\u0001\u0019!a\u0001\n\u0003\u0019\b\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0001w\u0011%A\b\u00011A\u0001B\u0003&A\u000fC\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\"Ia\u0010\u0001a\u0001\u0002\u0004%\ta \u0005\u000b\u0003\u0007\u0001\u0001\u0019!A!B\u0013Y\bBCA\u0003\u0001\u0001\u0007\t\u0019!C\u0001u\"Y\u0011q\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0005\u0011)\ti\u0001\u0001a\u0001\u0002\u0003\u0006Ka\u001f\u0005\u000b\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0003Q\bbCA\t\u0001\u0001\u0007\t\u0019!C\u0001\u0003'A!\"a\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003|\u0011-\tI\u0002\u0001a\u0001\u0002\u0004%\t!a\u0007\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013\u0005\u0011Q\u0005\u0005\f\u0003S\u0001\u0001\u0019!A!B\u0013\ti\u0002\u0003\u0005\u0002,\u0001\u0011\r\u0011\"\u0001{\u0011\u001d\ti\u0003\u0001Q\u0001\nmDq!a\f\u0001\t#\t\t\u0004C\u0004\u0002N\u0001!\t\"a\u0014\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0005bBA[\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003C\u0004A\u0011AAr\u0011\u001d\ti\u000f\u0001C\u0001\u0003GDq!!=\u0001\t\u0003\t\u0019\u000fC\u0004\u0002v\u0002!\t!a9\t\u000f\u0005e\b\u0001\"\u0001\u0002d\"9\u0011Q \u0001\u0005\u0002\u0005\r\bb\u0002B\u0001\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005\u000b\u0001A\u0011AAr\u0011\u001d\u0011I\u0001\u0001C\u0001\u0003GDqA!\u0004\u0001\t\u0003\t\u0019\u000fC\u0004\u0003\u0012\u0001!\t!a9\t\u000f\tU\u0001\u0001\"\u0001\u0002d\"9!\u0011\u0004\u0001\u0005\u0002\u0005\r\bb\u0002B\u000f\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0005a\t\u0005\u000f]3oIJ+7m\u001c:egJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003aE\naa]3sm\u0016\u0014(\"\u0001\u001a\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u000e\t\u0003m]j\u0011aL\u0005\u0003q=\u0012ACQ1tK\u001a+Go\u00195SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001<!\t1\u0004!A\u0003u_BL7-F\u0001?!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003mC:<'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003%\u0003\"A\u0013*\u000e\u0003-S!\u0001T'\u0002\r\r|W.\\8o\u0015\t\u0011dJ\u0003\u0002P!\u00061\u0011\r]1dQ\u0016T\u0011!U\u0001\u0004_J<\u0017BA*L\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\ti>\u0004\u0018nY%egV\tq\u000b\u0005\u0003YC\u00124gBA-`!\tQV,D\u0001\\\u0015\ta6'\u0001\u0004=e>|GO\u0010\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-X\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'aA'ba*\u0011\u0001-\u0018\t\u00031\u0016L!!R2\u0011\u0005);\u0017B\u00015L\u0005\u0011)V/\u001b3\u0002\u0019Q|\u0007/[2JIN|F%Z9\u0015\u0005-|\u0007C\u00017n\u001b\u0005i\u0016B\u00018^\u0005\u0011)f.\u001b;\t\u000fA<\u0011\u0011!a\u0001/\u0006\u0019\u0001\u0010J\u0019\u0002\u0013Q|\u0007/[2JIN\u0004\u0013A\u0003;pa&\u001cg*Y7fgV\tA\u000f\u0005\u0003YC\u001a$\u0017A\u0004;pa&\u001cg*Y7fg~#S-\u001d\u000b\u0003W^Dq\u0001\u001d\u0006\u0002\u0002\u0003\u0007A/A\u0006u_BL7MT1nKN\u0004\u0013\u0001\u00037fC\u0012,'/\u00133\u0016\u0003m\u0004\"\u0001\u001c?\n\u0005ul&aA%oi\u0006aA.Z1eKJLEm\u0018\u0013fcR\u00191.!\u0001\t\u000fAl\u0011\u0011!a\u0001w\u0006IA.Z1eKJLE\rI\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.A\bmK\u0006$WM]#q_\u000eDw\fJ3r)\rY\u00171\u0002\u0005\baB\t\t\u00111\u0001|\u00031aW-\u00193fe\u0016\u0003xn\u00195!\u0003)1w\u000e\u001c7po\u0016\u0014\u0018\nZ\u0001\u000fM>dGn\\<fe&#w\fJ3r)\rY\u0017Q\u0003\u0005\baN\t\t\u00111\u0001|\u0003-1w\u000e\u001c7po\u0016\u0014\u0018\n\u001a\u0011\u0002'\u0019|G\u000e\\8xKJ\u0014%o\\6fe\u0016\u0003xn\u00195\u0016\u0005\u0005u\u0001c\u00017\u0002 %\u0019\u0011\u0011E/\u0003\t1{gnZ\u0001\u0018M>dGn\\<fe\n\u0013xn[3s\u000bB|7\r[0%KF$2a[A\u0014\u0011!\u0001h#!AA\u0002\u0005u\u0011\u0001\u00064pY2|w/\u001a:Ce>\\WM]#q_\u000eD\u0007%A\u000ej]&$\u0018.\u00197SKBd\u0017nY1uS>t7+Z:tS>t\u0017\nZ\u0001\u001dS:LG/[1m%\u0016\u0004H.[2bi&|gnU3tg&|g.\u00133!\u0003a\u0019XM\u001c3BaB,g\u000e\u001a*fG>\u0014Hm\u001d*fcV,7\u000f\u001e\u000b\u0007\u0003g\ty$a\u0011\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000fL\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u001f\u0003o\u0011Q#\u00119qK:$'+Z2pe\u0012\u001c(+Z:q_:\u001cX\r\u0003\u0004\u0002Bi\u0001\ra_\u0001\tEJ|7.\u001a:JI\"9\u0011Q\t\u000eA\u0002\u0005\u001d\u0013a\u0002:fcV,7\u000f\u001e\t\u0005\u0003k\tI%\u0003\u0003\u0002L\u0005]\"\u0001F!qa\u0016tGMU3d_J$7OU3rk\u0016\u001cH/A\ttK:$\u0017\t\u001d9f]\u0012\u0014VmY8sIN$\"\"a\r\u0002R\u0005M\u0013qOA=\u0011\u0019\t\te\u0007a\u0001w\"9\u0011QK\u000eA\u0002\u0005]\u0013A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002Z\u0005}\u00131M\u0007\u0003\u00037R1!!\u0018C\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00141\f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002f\u0005Ed\u0002BA4\u0003[j!!!\u001b\u000b\u0007\u0005-4*A\u0004nKN\u001c\u0018mZ3\n\t\u0005=\u0014\u0011N\u0001\u0019\u0003B\u0004XM\u001c3SK\u000e|'\u000fZ:SKF,Xm\u001d;ECR\f\u0017\u0002BA:\u0003k\u0012\u0011\u0002V8qS\u000e$\u0015\r^1\u000b\t\u0005=\u0014\u0011\u000e\u0005\b\u00033Y\u0002\u0019AA\u000f\u0011\u001d\tYh\u0007a\u0001\u0003{\nqA^3sg&|g\u000eE\u0002m\u0003\u007fJ1!!!^\u0005\u0015\u0019\u0006n\u001c:u\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000fF\u0002l\u0003\u000fCq!!#\u001d\u0001\u0004\tY)\u0001\u0006qe>\u0004XM\u001d;jKN\u0004B!!\u0017\u0002\u000e&!\u0011qRA.\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004W\u0006U\u0005bBAL;\u0001\u0007\u0011\u0011T\u0001\ti\u0016\u001cH/\u00138g_B!\u00111TAU\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016aA1qS*!\u00111UAS\u0003\u001dQW\u000f]5uKJT1!a*Q\u0003\u0015QWO\\5u\u0013\u0011\tY+!(\u0003\u0011Q+7\u000f^%oM>D3!HAX!\u0011\tY*!-\n\t\u0005M\u0016Q\u0014\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\u0007;fgRdU-\u00193feR\u0013\u0018M\\:ji&|g\u000eV8QkNDGcA6\u0002:\"1\u00111\u0018\u0010A\u0002\u0011\fa!];peVl\u0007f\u0001\u0010\u0002@B!\u0011\u0011YAd\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u0005\u0016A\u00029be\u0006l7/\u0003\u0003\u0002J\u0006\r'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":a$!4\u0002Z\u0006m\u0007\u0003BAh\u0003+l!!!5\u000b\t\u0005M\u00171Y\u0001\taJ|g/\u001b3fe&!\u0011q[Ai\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0011Q\\\u0011\u0003\u0003?\fQa\u001b:bMR\f\u0001\u0005^3tiN#\u0018\r\\3Ce>\\WM]#q_\u000eDgI]8n\r>dGn\\<feR\t1\u000eK\u0002 \u0003O\u0004B!a'\u0002j&!\u00111^AO\u0005\u0011!Vm\u001d;\u0002CQ,7\u000f\u001e$f]\u000e,G\rT3bI\u0016\u0014X\t]8dQ\u001a\u0013x.\u001c$pY2|w/\u001a:)\u0007\u0001\n9/\u0001\u0012uKN$XK\\6o_^tG*Z1eKJ,\u0005o\\2i\rJ|WNR8mY><XM\u001d\u0015\u0004C\u0005\u001d\u0018a\b;fgR\f\u0005\u000f]3oIJ+7m\u001c:egVs7N\\8x]R{\u0007/[2JI\"\u001a!%a:\u0002UQ,7\u000f\u001e$f]\u000e,GMU3qY&\u001c\u0017\r^5p]N+7o]5p]&#gI]8n\r>dGn\\<fe\"\u001a1%a:\u00029Q,7\u000f^'jgNLwN\u001c*fa2L7-\u0019;j_:|eMZ:fi\"\u001aA%a:\u0002;Q,7\u000f\u001e$pY2|w/\u001a:SKR,(O\\:D_J\u0014Xm\u0019;M\u000b>C3!JAt\u0003}!Xm\u001d;G_2dwn^3s\u0007>t7/Z2vi&4XMU3rk\u0016\u001cHo\u001d\u0015\u0004M\u0005\u001d\u0018!\n;fgR$U\u000f\u001d7jG\u0006$XMU3rk\u0016\u001cH\u000fR8fg:{G\u000fV1lK\u00163g-Z2uQ\r9\u0013q]\u0001+i\u0016\u001cH/\u00133f[B|G/\u001a8ds\u001a{'oU3f]2+\u0017\rZ3s\u000bB|7\r[!oI>3gm]3uQ\rA\u0013q]\u0001\u0016i\u0016\u001cHoU3oIR{gj\u001c8G_2dwn^3sQ\rI\u0013q]\u0001\u001ai\u0016\u001cH/\u00128e%\u0016\u0004H.[2bi&|gnU3tg&|g\u000eK\u0002+\u0003O\f1\u0004^3ti>+Ho\u00144Pe\u0012,'/\u00119qK:$'+Z2pe\u0012\u001c\bfA\u0016\u0002h\u0006yA/Z:u'.L\u0007OU3d_J$7\u000fK\u0002-\u0003O\f!dZ3u%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\"z!\u0006\u0014H/\u001b;j_:$bA!\n\u00036\t}\u0002#\u0002-b\u0013\n\u001d\u0002\u0003\u0002B\u0015\u0005_qA!a\u001a\u0003,%!!QFA5\u0003e\t\u0005\u000f]3oIJ+7m\u001c:egJ+7\u000f]8og\u0016$\u0015\r^1\n\t\tE\"1\u0007\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\t5\u0012\u0011\u000e\u0005\b\u0005oi\u0003\u0019\u0001B\u001d\u0003\u0011!\u0017\r^1\u0011\t\u0005\u001d$1H\u0005\u0005\u0005{\tIGA\rBaB,g\u000e\u001a*fG>\u0014Hm\u001d*fgB|gn]3ECR\f\u0007\"\u0002:.\u0001\u0004!\b")
public class AppendRecordsRequestTest
extends BaseFetchRequestTest {
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
    private scala.collection.immutable.Map<String, Uuid> topicIds;
    private scala.collection.immutable.Map<Uuid, String> topicNames;
    private int leaderId;
    private int leaderEpoch;
    private int followerId;
    private long followerBrokerEpoch;
    private final int initialReplicationSessionId;

    public String topic() {
        return this.topic;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public scala.collection.immutable.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public void topicIds_$eq(scala.collection.immutable.Map<String, Uuid> x$1) {
        this.topicIds = x$1;
    }

    public scala.collection.immutable.Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    public void topicNames_$eq(scala.collection.immutable.Map<Uuid, String> x$1) {
        this.topicNames = x$1;
    }

    public int leaderId() {
        return this.leaderId;
    }

    public void leaderId_$eq(int x$1) {
        this.leaderId = x$1;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public void leaderEpoch_$eq(int x$1) {
        this.leaderEpoch = x$1;
    }

    public int followerId() {
        return this.followerId;
    }

    public void followerId_$eq(int x$1) {
        this.followerId = x$1;
    }

    public long followerBrokerEpoch() {
        return this.followerBrokerEpoch;
    }

    public void followerBrokerEpoch_$eq(long x$1) {
        this.followerBrokerEpoch = x$1;
    }

    public int initialReplicationSessionId() {
        return this.initialReplicationSessionId;
    }

    public AppendRecordsResponse sendAppendRecordsRequest(int brokerId, AppendRecordsRequest request) {
        return (AppendRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(brokerId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AppendRecordsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public AppendRecordsResponse sendAppendRecords(int brokerId, java.util.List<AppendRecordsRequestData.TopicData> topics, long followerBrokerEpoch, short version) {
        AppendRecordsRequestData data = new AppendRecordsRequestData().setReplicaEpoch(followerBrokerEpoch).setTopics(topics);
        AppendRecordsRequest appendRecordsRequest = new AppendRecordsRequest.Builder(data).build(version);
        return this.sendAppendRecordsRequest(brokerId, appendRecordsRequest);
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("confluent.api.visibility", ApiMessageType.ApiVisibility.CONFLUENT_CLOUD.toString());
        properties.put("confluent.replication.push.feature.enable", "true");
        properties.put("confluent.replication.mode", ReplicationConfig.Mode.PULL_PUSH.toString());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(this.topic(), 1, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.leaderId_$eq(BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition()))));
        this.leaderEpoch_$eq(TestUtils$.MODULE$.findLeaderEpoch(this.leaderId(), this.topicPartition(), (Iterable<KafkaBroker>)this.brokers()));
        this.followerId_$eq(TestUtils$.MODULE$.findFollowerId(this.topicPartition(), (Iterable<KafkaBroker>)this.brokers()));
        KafkaBroker followerBroker = (KafkaBroker)this.brokers().apply(this.followerId());
        this.followerBrokerEpoch_$eq(followerBroker.brokerEpoch());
        this.topicIds_$eq(this.getTopicIds());
        this.topicNames_$eq((scala.collection.immutable.Map<Uuid, String>)((scala.collection.immutable.Map)this.topicIds().map((Function1 & Serializable)x$7 -> x$7.swap())));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testLeaderTransitionToPush(String quorum) {
        void forReplica_minBytes;
        void forReplica_maxWait;
        void forReplica_replicaEpoch;
        void forReplica_replicaId;
        java.util.Map partitionMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new FetchRequest.PartitionData((Uuid)this.topicIds().apply((Object)this.topic()), 0L, 0L, 0, Optional.of(Predef$.MODULE$.long2Long(0L)), Optional.of(Predef$.MODULE$.int2Integer(this.leaderEpoch())), Optional.of(Predef$.MODULE$.int2Integer(this.leaderEpoch()))))}))).asJava();
        boolean bl = false;
        int n = Integer.MAX_VALUE;
        long l = this.followerBrokerEpoch();
        int n2 = this.followerId();
        short forReplica_allowedVersion = ApiKeys.FETCH.latestVersion();
        FetchRequest fetchRequest = new FetchRequest.Builder(forReplica_allowedVersion, forReplica_allowedVersion, (int)forReplica_replicaId, (long)forReplica_replicaEpoch, (int)forReplica_maxWait, (int)forReplica_minBytes, partitionMap).build(ApiKeys.FETCH.latestVersion());
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(this.leaderId(), fetchRequest).responseData(CollectionConverters$.MODULE$.MapHasAsJava(this.topicNames()).asJava(), ApiKeys.FETCH.latestVersion()).get(this.topicPartition());
        Assertions.assertEquals((short)Errors.PUSH_REPLICATION_STARTED.code(), (short)partitionData.errorCode());
    }

    @Test
    public void testStaleBrokerEpochFromFollower() {
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch() - 1L, (short)0);
        Assertions.assertEquals((short)Errors.STALE_BROKER_EPOCH.code(), (short)appendRecordsResponse.data().errorCode());
    }

    @Test
    public void testFencedLeaderEpochFromFollower() {
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch() - 1));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.FENCED_LEADER_EPOCH.code(), (short)partitionData.errorCode());
    }

    @Test
    public void testUnknownLeaderEpochFromFollower() {
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch() + 1));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.UNKNOWN_LEADER_EPOCH.code(), (short)partitionData.errorCode());
    }

    @Test
    public void testAppendRecordsUnknownTopicId() {
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId(Uuid.ZERO_UUID).setPartitions(partitions));
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)((AppendRecordsResponseData.TopicData)this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0).data().topics().get(0)).partitions().get(0);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_ID.code(), (short)partitionData.errorCode());
    }

    @Test
    public void testFencedReplicationSessionIdFromFollower() {
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setCurrentLeaderEpoch(this.leaderEpoch()).setReplicationSessionId((long)(this.initialReplicationSessionId() + 1)));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.FENCED_REPLICATION_SESSION_ID.code(), (short)partitionData.errorCode());
    }

    @Test
    public void testMissionReplicationOffset() {
        .colon.colon x$1 = new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$3 = 2;
        CompressionType x$4 = CompressionType.NONE;
        long x$5 = -1L;
        short x$6 = -1;
        int x$7 = -1;
        long x$8 = 0L;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$1, x$3, x$4, x$5, x$6, x$7, x$8, 0)));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.INVALID_REPLICATION_OFFSET.code(), (short)partitionData.errorCode());
    }

    @Test
    public void testFollowerReturnsCorrectLEO() {
        .colon.colon x$1 = new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$3 = 2;
        CompressionType x$4 = CompressionType.NONE;
        long x$5 = -1L;
        short x$6 = -1;
        int x$7 = -1;
        long x$8 = 0L;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$1, x$3, x$4, x$5, x$6, x$7, x$8, 0)).setAppendOffset(0L));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((long)2L, (long)partitionData.logEndOffset());
    }

    @Test
    public void testFollowerConsecutiveRequests() {
        .colon.colon x$1 = new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$3 = 2;
        CompressionType x$4 = CompressionType.NONE;
        long x$5 = -1L;
        short x$6 = -1;
        int x$7 = -1;
        long x$8 = 0L;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$1, x$3, x$4, x$5, x$6, x$7, x$8, 0)).setAppendOffset(0L));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((long)2L, (long)partitionData.logEndOffset());
        .colon.colon x$9 = new .colon.colon((Object)new SimpleRecord(13L, "k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(14L, "k4".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$12 = 2;
        CompressionType x$13 = CompressionType.NONE;
        long x$14 = -1L;
        short x$15 = -1;
        int x$16 = -1;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions2 = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$9, x$12, x$13, x$14, x$15, x$16, 2L, 0)).setAppendOffset(2L));
        java.util.List<AppendRecordsRequestData.TopicData> topics2 = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions2));
        AppendRecordsResponse appendRecordsResponse2 = this.sendAppendRecords(this.followerId(), topics2, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData2 = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse2.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData2.errorCode());
        Assertions.assertEquals((long)4L, (long)partitionData2.logEndOffset());
    }

    @Test
    public void testDuplicateRequestDoesNotTakeEffect() {
        .colon.colon x$1 = new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$3 = 2;
        CompressionType x$4 = CompressionType.NONE;
        long x$5 = -1L;
        short x$6 = -1;
        int x$7 = -1;
        long x$8 = 0L;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$1, x$3, x$4, x$5, x$6, x$7, x$8, 0)).setAppendOffset(0L));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((long)2L, (long)partitionData.logEndOffset());
        AppendRecordsResponse appendRecordsResponse2 = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData2 = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse2.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData2.errorCode());
        Assertions.assertEquals((long)2L, (long)partitionData2.logEndOffset());
    }

    @Test
    public void testIdempotencyForSeenLeaderEpochAndOffset() {
        .colon.colon x$1 = new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$4 = 2;
        CompressionType x$5 = CompressionType.NONE;
        long x$6 = -1L;
        short x$7 = -1;
        int x$8 = -1;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$1, x$4, x$5, x$6, x$7, x$8, 20L, 0)).setAppendOffset(0L));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((long)22L, (long)partitionData.logEndOffset());
        .colon.colon x$9 = new .colon.colon((Object)new SimpleRecord(8L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(9L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$12 = 2;
        CompressionType x$13 = CompressionType.NONE;
        long x$14 = -1L;
        short x$15 = -1;
        int x$16 = -1;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions2 = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$9, x$12, x$13, x$14, x$15, x$16, 2L, 0)).setAppendOffset(2L));
        java.util.List<AppendRecordsRequestData.TopicData> topics2 = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions2));
        AppendRecordsResponse appendRecordsResponse2 = this.sendAppendRecords(this.followerId(), topics2, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData2 = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse2.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData2.errorCode());
        Assertions.assertEquals((long)22L, (long)partitionData2.logEndOffset());
    }

    @Test
    public void testSendToNonFollower() {
        int nonFollowerId = BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.servers().filterNot((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)AppendRecordsRequestTest.$anonfun$testSendToNonFollower$1(this, server)))).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)AppendRecordsRequestTest.$anonfun$testSendToNonFollower$2(x$8)))).head());
        long nonFollowerBrokerEpoch = ((KafkaServer)this.servers().apply(nonFollowerId)).kafkaController().brokerEpoch();
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(nonFollowerId, topics, nonFollowerBrokerEpoch, (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)appendRecordsResponse.data().errorCode());
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)partitionData.errorCode());
    }

    @Test
    public void testEndReplicationSession() {
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setEndReplicationSession(true));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        java.util.List<AppendRecordsRequestData.PartitionData> partitions2 = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setAppendOffset(0L));
        java.util.List<AppendRecordsRequestData.TopicData> topics2 = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions2));
        AppendRecordsResponse appendRecordsResponse2 = this.sendAppendRecords(this.followerId(), topics2, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData2 = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse2.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.FENCED_REPLICATION_SESSION_ID.code(), (short)partitionData2.errorCode());
        java.util.List<AppendRecordsRequestData.PartitionData> partitions3 = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId(1L).setCurrentLeaderEpoch(this.leaderEpoch()).setAppendOffset(0L));
        java.util.List<AppendRecordsRequestData.TopicData> topics3 = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions3));
        AppendRecordsResponse appendRecordsResponse3 = this.sendAppendRecords(this.followerId(), topics3, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData3 = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse3.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData3.errorCode());
    }

    @Test
    public void testOutOfOrderAppendRecords() {
        .colon.colon x$1 = new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$4 = 2;
        CompressionType x$5 = CompressionType.NONE;
        long x$6 = -1L;
        short x$7 = -1;
        int x$8 = -1;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$1, x$4, x$5, x$6, x$7, x$8, 20L, 0)).setAppendOffset(20L));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.INVALID_REPLICATION_OFFSET.code(), (short)partitionData.errorCode());
        .colon.colon x$9 = new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$12 = 2;
        CompressionType x$13 = CompressionType.NONE;
        long x$14 = -1L;
        short x$15 = -1;
        int x$16 = -1;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions2 = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)(this.initialReplicationSessionId() + 1)).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$9, x$12, x$13, x$14, x$15, x$16, 0L, 0)).setAppendOffset(0L));
        java.util.List<AppendRecordsRequestData.TopicData> topics2 = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions2));
        AppendRecordsResponse appendRecordsResponse2 = this.sendAppendRecords(this.followerId(), topics2, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData2 = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse2.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData2.errorCode());
    }

    @Test
    public void testSkipRecords() {
        .colon.colon x$1 = new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$4 = 2;
        CompressionType x$5 = CompressionType.NONE;
        long x$6 = -1L;
        short x$7 = -1;
        int x$8 = -1;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$1, x$4, x$5, x$6, x$7, x$8, 0L, 0)).setAppendOffset(0L));
        java.util.List<AppendRecordsRequestData.TopicData> topics = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions));
        AppendRecordsResponse appendRecordsResponse = this.sendAppendRecords(this.followerId(), topics, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((long)2L, (long)partitionData.logEndOffset());
        .colon.colon x$9 = new .colon.colon((Object)new SimpleRecord(8L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(9L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        byte x$12 = 2;
        CompressionType x$13 = CompressionType.NONE;
        long x$14 = -1L;
        short x$15 = -1;
        int x$16 = -1;
        java.util.List<AppendRecordsRequestData.PartitionData> partitions2 = Collections.singletonList(new AppendRecordsRequestData.PartitionData().setPartitionIndex(0).setReplicationSessionId((long)this.initialReplicationSessionId()).setCurrentLeaderEpoch(this.leaderEpoch()).setRecords((BaseRecords)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$9, x$12, x$13, x$14, x$15, x$16, 4L, 0)).setAppendOffset(4L));
        java.util.List<AppendRecordsRequestData.TopicData> topics2 = Collections.singletonList(new AppendRecordsRequestData.TopicData().setTopicId((Uuid)this.topicIds().apply((Object)this.topic())).setPartitions(partitions2));
        AppendRecordsResponse appendRecordsResponse2 = this.sendAppendRecords(this.followerId(), topics2, this.followerBrokerEpoch(), (short)0);
        AppendRecordsResponseData.PartitionData partitionData2 = (AppendRecordsResponseData.PartitionData)this.getResponseDataByPartition(appendRecordsResponse2.data(), this.topicNames()).apply((Object)this.topicPartition());
        Assertions.assertEquals((short)Errors.INVALID_REPLICATION_OFFSET.code(), (short)partitionData2.errorCode());
    }

    public scala.collection.immutable.Map<TopicPartition, AppendRecordsResponseData.PartitionData> getResponseDataByPartition(AppendRecordsResponseData data, scala.collection.immutable.Map<Uuid, String> topicNames) {
        scala.collection.mutable.Map responseByPartition = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        data.topics().forEach(topicData -> {
            Option topicName = topicNames.get((Object)topicData.topicId());
            if (topicName.isDefined()) {
                topicData.partitions().forEach(partitionData -> responseByPartition.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition((String)topicName.get(), partitionData.partitionIndex())), partitionData)));
                return;
            }
        });
        return responseByPartition.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$testSendToNonFollower$1(AppendRecordsRequestTest $this, KafkaServer server) {
        return server.config().brokerId() == $this.followerId() || server.config().brokerId() == $this.leaderId();
    }

    public static final /* synthetic */ int $anonfun$testSendToNonFollower$2(KafkaServer x$8) {
        return x$8.config().brokerId();
    }

    public AppendRecordsRequestTest() {
        this.topic = "topic";
        this.initialReplicationSessionId = 0;
    }
}

