/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.AutoTopicCreationManager$;
import kafka.server.ControllerMutationQuota;
import kafka.server.DefaultAutoTopicCreationManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.UnboundedControllerMutationQuota$;
import kafka.server.ZkAdminManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u001dh\u0001B A\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004V\u0001\u0001\u0006IA\u0015\u0005\n-\u0002\u0001\r\u00111A\u0005\n]C\u0011b\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002/\t\u0013\t\u0004\u0001\u0019!A!B\u0013A\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B3\t\u000f%\u0004!\u0019!C\u0005U\"1Q\u000f\u0001Q\u0001\n-DqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001f\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\t9\u0001\u0001Q\u0001\nyD\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u001bA\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005E\u0002\u0001)A\u0005\u0003GA1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026!Y\u0011Q\b\u0001A\u0002\u0003\u0007I\u0011BA \u0011-\t\u0019\u0005\u0001a\u0001\u0002\u0003\u0006K!a\u000e\t\u0011\u0005\u0015\u0003A1A\u0005\nECq!a\u0012\u0001A\u0003%!\u000bC\u0005\u0002J\u0001\u0011\r\u0011\"\u0003\u0002L!A\u00111\u000b\u0001!\u0002\u0013\ti\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X!A\u0011q\u000e\u0001!\u0002\u0013\tI\u0006C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005-\u0005\u0001\"\u0001\u0002t!9\u0011Q\u0013\u0001\u0005\u0002\u0005M\u0004bBAM\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003;\u0003A\u0011AA:\u0011\u001d\t\t\u000b\u0001C\u0001\u0003gBq!!*\u0001\t\u0013\t9\u000bC\u0005\u0002T\u0002\t\n\u0011\"\u0003\u0002V\"I\u00111\u001e\u0001\u0012\u0002\u0013%\u0011Q\u001e\u0005\n\u0003c\u0004\u0011\u0013!C\u0005\u0003gDq!a>\u0001\t\u0003\t\u0019\bC\u0004\u0002|\u0002!\t!a\u001d\t\u000f\u0005}\b\u0001\"\u0001\u0002t!9!1\u0001\u0001\u0005\u0002\u0005M\u0004b\u0002B\u0004\u0001\u0011\u0005\u00111\u000f\u0005\b\u0005\u0017\u0001A\u0011AA:\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003gBqAa\u0005\u0001\t\u0003\t\u0019\bC\u0004\u0003\u0018\u0001!\t!a\u001d\t\u000f\tm\u0001\u0001\"\u0001\u0002t!9!q\u0004\u0001\u0005\u0002\u0005M\u0004b\u0002B\u0012\u0001\u0011\u0005\u00111\u000f\u0005\b\u0005O\u0001A\u0011AA:\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0003gBqAa\f\u0001\t\u0003\t\u0019\bC\u0004\u00034\u0001!\t!a\u001d\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!\u0011\u000f\u0001\u0005\n\tM\u0004\"\u0003BJ\u0001E\u0005I\u0011\u0002BK\u0011\u001d\u0011I\n\u0001C\u0005\u00057C\u0011B!+\u0001#\u0003%IAa+\t\u000f\t=\u0006\u0001\"\u0003\u00032\"I!\u0011\u001d\u0001\u0012\u0002\u0013%\u0011Q\u001b\u0005\n\u0005G\u0004\u0011\u0013!C\u0005\u0003[D\u0011B!:\u0001#\u0003%I!a=\u00039\u0005+Ho\u001c+pa&\u001c7I]3bi&|g.T1oC\u001e,'\u000fV3ti*\u0011\u0011IQ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\r\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\rB\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001(\u0011\u0005=\u0003Q\"\u0001!\u0002\u001dI,\u0017/^3tiRKW.Z8viV\t!\u000b\u0005\u0002H'&\u0011A\u000b\u0013\u0002\u0004\u0013:$\u0018a\u0004:fcV,7\u000f\u001e+j[\u0016|W\u000f\u001e\u0011\u0002\r\r|gNZ5h+\u0005A\u0006CA(Z\u0013\tQ\u0006IA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR\u0011Q\f\u0019\t\u0003\u000fzK!a\u0018%\u0003\tUs\u0017\u000e\u001e\u0005\bC\u0016\t\t\u00111\u0001Y\u0003\rAH%M\u0001\bG>tg-[4!\u00035iW\r^1eCR\f7)Y2iKV\tQ\r\u0005\u0002PM&\u0011q\r\u0011\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005\u0011\"M]8lKJ$vnQ8oiJ|G\u000e\\3s+\u0005Y\u0007C\u00017t\u001b\u0005i'BA!o\u0015\t\u0019uN\u0003\u0002qc\u00061\u0011\r]1dQ\u0016T\u0011A]\u0001\u0004_J<\u0017B\u0001;n\u0005yqu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/A\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014\b%\u0001\u0007bI6Lg.T1oC\u001e,'/F\u0001y!\ty\u00150\u0003\u0002{\u0001\nq!l[!e[&tW*\u00198bO\u0016\u0014\u0018!D1e[&tW*\u00198bO\u0016\u0014\b%\u0001\u0006d_:$(o\u001c7mKJ,\u0012A \t\u0004\u007f\u0006\rQBAA\u0001\u0015\ta()\u0003\u0003\u0002\u0006\u0005\u0005!aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002\u0017\r|g\u000e\u001e:pY2,'\u000fI\u0001\u0011OJ|W\u000f]\"p_J$\u0017N\\1u_J,\"!!\u0004\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005)qM]8va*\u0019\u0011q\u00038\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0005\u00037\t\tB\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006\trM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002-Q\u0014\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J,\"!a\t\u0011\t\u0005\u0015\u0012QF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005YAO]1og\u0006\u001cG/[8o\u0015\r\t9BQ\u0005\u0005\u0003_\t9C\u0001\fUe\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s\u0003]!(/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014\b%\u0001\rbkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:l\u0015M\\1hKJ,\"!a\u000e\u0011\u0007=\u000bI$C\u0002\u0002<\u0001\u0013\u0001$Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s\u0003q\tW\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM]0%KF$2!XA!\u0011!\tG#!AA\u0002\u0005]\u0012!G1vi>$v\u000e]5d\u0007J,\u0017\r^5p]6\u000bg.Y4fe\u0002\nq#\u001b8uKJt\u0017\r\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\:\u00021%tG/\u001a:oC2$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0010j]R,'O\\1m)>\u0004\u0018n\u0019*fa2L7-\u0019;j_:4\u0015m\u0019;peV\u0011\u0011Q\n\t\u0004\u000f\u0006=\u0013bAA)\u0011\n)1\u000b[8si\u0006y\u0012N\u001c;fe:\fG\u000eV8qS\u000e\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u00027Ad\u0017mY3nK:$(j]8o\u0013:$XM\u001d8bYR{\u0007/[2t+\t\tI\u0006\u0005\u0003\u0002\\\u0005%d\u0002BA/\u0003K\u00022!a\u0018I\u001b\t\t\tGC\u0002\u0002d\u0011\u000ba\u0001\u0010:p_Rt\u0014bAA4\u0011\u00061\u0001K]3eK\u001aLA!a\u001b\u0002n\t11\u000b\u001e:j]\u001eT1!a\u001aI\u0003q\u0001H.Y2f[\u0016tGOS:p]&sG/\u001a:oC2$v\u000e]5dg\u0002\nQa]3ukB$\u0012!\u0018\u0015\u00049\u0005]\u0004\u0003BA=\u0003\u000fk!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0004CBL'\u0002BAA\u0003\u0007\u000bqA[;qSR,'OC\u0002\u0002\u0006F\fQA[;oSRLA!!#\u0002|\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002+Q,7\u000f^\"sK\u0006$Xm\u00144gg\u0016$Hk\u001c9jG\"\u001aQ$a$\u0011\t\u0005e\u0014\u0011S\u0005\u0005\u0003'\u000bYH\u0001\u0003UKN$\u0018!\f;fgR\u001c%/Z1uK>3gm]3u)>\u0004\u0018nY,ji\"\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8ug\"\u001aa$a$\u0002%Q,7\u000f^\"sK\u0006$X\r\u0016=o)>\u0004\u0018n\u0019\u0015\u0004?\u0005=\u0015A\u000b;fgR\u001c%/Z1uKRCh\u000eV8qS\u000e<\u0016\u000e\u001e5QY\u0006\u001cW-\\3oi\u000e{gn\u001d;sC&tGo\u001d\u0015\u0004A\u0005=\u0015A\u0007;fgR\u001c%/Z1uK:{g.\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007fA\u0011\u0002\u0010\u0006yA/Z:u\u0007J,\u0017\r^3U_BL7\rF\u0006^\u0003S\u000bi+a.\u0002<\u0006}\u0006bBAVE\u0001\u0007\u0011\u0011L\u0001\ni>\u0004\u0018n\u0019(b[\u0016Dq!a,#\u0001\u0004\t\t,\u0001\u0006jg&sG/\u001a:oC2\u00042aRAZ\u0013\r\t)\f\u0013\u0002\b\u0005>|G.Z1o\u0011!\tIL\tI\u0001\u0002\u0004\u0011\u0016!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0005\u0002>\n\u0002\n\u00111\u0001\u0002N\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u0013\u0005\u0005'\u0005%AA\u0002\u0005\r\u0017\u0001\u0004;pa&\u001c7i\u001c8gS\u001e\u001c\b\u0003BAc\u0003\u001fl!!a2\u000b\t\u0005%\u00171Z\u0001\u0005kRLGN\u0003\u0002\u0002N\u0006!!.\u0019<b\u0013\u0011\t\t.a2\u0003\u0015A\u0013x\u000e]3si&,7/A\ruKN$8I]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\u001aTCAAlU\r\u0011\u0016\u0011\\\u0016\u0003\u00037\u0004B!!8\u0002h6\u0011\u0011q\u001c\u0006\u0005\u0003C\f\u0019/A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001d%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002j\u0006}'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006IB/Z:u\u0007J,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tyO\u000b\u0003\u0002N\u0005e\u0017!\u0007;fgR\u001c%/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIU*\"!!>+\t\u0005\r\u0017\u0011\\\u0001'i\u0016\u001cHo\u0011:fCR,Gk\u001c9jGN<\u0016\u000e\u001e5G_J<\u0018M\u001d3j]\u001e$\u0015n]1cY\u0016$\u0007f\u0001\u0014\u0002\u0010\u0006\u0001D/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2bi&|gNR1di>\u0014hi\u001c:O_:Le\u000e^3s]\u0006dGk\u001c9jGND3aJAH\u0003M\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_J4uN]\"p]N,X.\u001a:PM\u001a\u001cX\r^:U_BL7\rK\u0002)\u0003\u001f\u000bQ\u0006^3ti&sg/\u00197jIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'OR8s)btwJ\u001a4tKR$v\u000e]5dQ\rI\u0013qR\u0001-i\u0016\u001cH\u000fV8qS\u000e,\u00050[:ug\u0016\u0013(o\u001c:To\u0006\u0004hi\u001c:O_:Le\u000e^3s]\u0006dGk\u001c9jGND3AKAH\u0003=\"Xm\u001d;U_BL7-\u0012=jgR\u001cXI\u001d:peN;\u0018\r\u001d$pe\u000e{gn];nKJ|eMZ:fiN$v\u000e]5dQ\rY\u0013qR\u0001*i\u0016\u001cH\u000fV8qS\u000e,\u00050[:ug\u0016\u0013(o\u001c:To\u0006\u0004hi\u001c:Uq:|eMZ:fiR{\u0007/[2)\u00071\ny)A\u0018uKN$(+Z9vKN$H+[7f_V$XI\u001d:peN;\u0018\r\u001d$pe:{g.\u00138uKJt\u0017\r\u001c+pa&\u001c7\u000fK\u0002.\u0003\u001f\u000b\u0011\u0007^3tiJ+\u0017/^3tiRKW.Z8vi\u0016\u0013(o\u001c:To\u0006\u0004hi\u001c:D_:\u001cX/\\3s\u001f\u001a47/\u001a;U_BL7\rK\u0002/\u0003\u001f\u000bA\u0006^3tiJ+\u0017/^3tiRKW.Z8vi\u0016\u0013(o\u001c:To\u0006\u0004hi\u001c:Uq:|eMZ:fiR{\u0007/[2)\u0007=\ny)\u0001\u0017uKN$XK\\6o_^tGk\u001c9jGB\u000b'\u000f^5uS>tgi\u001c:O_:Le\u000e^3sm\u0006dGk\u001c9jG\"\u001a\u0001'a$\u0002_Q,7\u000f^+oW:|wO\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c$pe\u000e{gn];nKJ|eMZ:fiR{\u0007/[2)\u0007E\ny)\u0001\u0016uKN$XK\\6o_^tGk\u001c9jGB\u000b'\u000f^5uS>tgi\u001c:Uq:|eMZ:fiR{\u0007/[2)\u0007I\ny)A\u0019uKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5NKR\fG-\u0019;b\u0007>tG/\u001a=u!\u0006\u001c8\u000f\u0015:j]\u000eL\u0007/\u00197)\u0007M\ny)\u0001!uKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5NKR\fG-\u0019;b\u0007>tG/\u001a=u/\",g\u000e\u0015:j]\u000eL\u0007/\u00197TKJ$WMT8u\t\u00164\u0017N\\3eQ\r!\u0014qR\u0001Bi\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\u001b\u0016$\u0018\rZ1uC\u000e{g\u000e^3yi:{'+\u001a;ssV\u0003xN\\+ogV\u0004\bo\u001c:uK\u00124VM]:j_:D3!NAH\u0003aIg.\u001b;jC2L'0\u001a*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u000b\t\u0005w\u0011YE!\u0014\u0003bA!!Q\bB$\u001b\t\u0011yD\u0003\u0003\u0003B\t\r\u0013\u0001\u0003:fcV,7\u000f^:\u000b\u0007\t\u0015c.\u0001\u0004d_6lwN\\\u0005\u0005\u0005\u0013\u0012yD\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000f\u0005-f\u00071\u0001\u0002Z!9!q\n\u001cA\u0002\tE\u0013AD6bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\t\u0005\u0005'\u0012i&\u0004\u0002\u0003V)!!q\u000bB-\u0003\u0011\tW\u000f\u001e5\u000b\t\tm#1I\u0001\tg\u0016\u001cWO]5us&!!q\fB+\u00059Y\u0015MZ6b!JLgnY5qC2DqAa\u00197\u0001\u0004\u0011)'\u0001\bqe&t7-\u001b9bYN+'\u000fZ3\u0011\r\u0005\u0015'q\rB6\u0013\u0011\u0011I'a2\u0003\u0011=\u0003H/[8oC2\u0004BAa\u0015\u0003n%!!q\u000eB+\u0005MY\u0015MZ6b!JLgnY5qC2\u001cVM\u001d3f\u0003e!Xm\u001d;FeJ|'oV5uQ\u000e\u0013X-\u0019;j_:LeNW6\u0015\u0013u\u0013)H!\"\u0003\b\n%\u0005b\u0002B<o\u0001\u0007!\u0011P\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0005w\u0012\t)\u0004\u0002\u0003~)!!q\u0010B\"\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002BB\u0005{\u0012a!\u0012:s_J\u001c\bbBAVo\u0001\u0007\u0011\u0011\f\u0005\b\u0003_;\u0004\u0019AAY\u0011%\u0011Yi\u000eI\u0001\u0002\u0004\u0011i)A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0006\u000f\n=%\u0011P\u0005\u0004\u0005#C%AB(qi&|g.A\u0012uKN$XI\u001d:pe^KG\u000f[\"sK\u0006$\u0018n\u001c8J]j[G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t]%\u0006\u0002BG\u00033\f!d\u0019:fCR,Gk\u001c9jG\u0006sGMV3sS\u001aL(+Z:vYR$\u0012\"\u0018BO\u0005?\u0013\tKa)\t\u000f\t]\u0014\b1\u0001\u0003z!9\u00111V\u001dA\u0002\u0005e\u0003bBAXs\u0001\u0007\u0011\u0011\u0017\u0005\n\u0005KK\u0004\u0013!a\u0001\u0005O\u000bq\"\\3uC\u0012\fG/Y\"p]R,\u0007\u0010\u001e\t\u0006\u000f\n=%1H\u0001%GJ,\u0017\r^3U_BL7-\u00118e-\u0016\u0014\u0018NZ=SKN,H\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0016\u0016\u0005\u0005O\u000bI.A\u0006hKRtUm\u001e+pa&\u001cGC\u0003BZ\u00053\u0014YN!8\u0003`B!!Q\u0017Bj\u001d\u0011\u00119L!4\u000f\t\te&\u0011\u001a\b\u0005\u0005w\u00139M\u0004\u0003\u0003>\n\u0015g\u0002\u0002B`\u0005\u0007tA!a\u0018\u0003B&\t!/\u0003\u0002qc&\u00111i\\\u0005\u0004\u0005\u000br\u0017\u0002\u0002Bf\u0005\u0007\nq!\\3tg\u0006<W-\u0003\u0003\u0003P\nE\u0017aF\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H)\u0019;b\u0015\u0011\u0011YMa\u0011\n\t\tU'q\u001b\u0002\u000f\u0007J,\u0017\r^1cY\u0016$v\u000e]5d\u0015\u0011\u0011yM!5\t\u000f\u0005-6\b1\u0001\u0002Z!A\u0011\u0011X\u001e\u0011\u0002\u0003\u0007!\u000bC\u0005\u0002>n\u0002\n\u00111\u0001\u0002N!I\u0011\u0011Y\u001e\u0011\u0002\u0003\u0007\u00111Y\u0001\u0016O\u0016$h*Z<U_BL7\r\n3fM\u0006,H\u000e\u001e\u00133\u0003U9W\r\u001e(foR{\u0007/[2%I\u00164\u0017-\u001e7uIM\nQcZ3u\u001d\u0016<Hk\u001c9jG\u0012\"WMZ1vYR$C\u0007")
public class AutoTopicCreationManagerTest {
    private final int requestTimeout;
    private KafkaConfig config;
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
    private final ZkAdminManager adminManager = (ZkAdminManager)Mockito.mock(ZkAdminManager.class);
    private final KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private AutoTopicCreationManager autoTopicCreationManager;
    private final int internalTopicPartitions;
    private final short internalTopicReplicationFactor = (short)2;
    private final String placementJsonInternalTopics = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |{\n      | \"version\": 1,\n      | \"replicas\": [{\n      |   \"count\": 1,\n      |   \"constraints\": {\n      |     \"rack\": \"rack0\"\n      |   }\n      | },\n      | {\n      |   \"count\": 1,\n      |   \"constraints\": {\n      |     \"rack\": \"rack1\"\n      |   }\n      | }],\n      | \"observers\": []\n      |}\n      |")).split("\\s+")).mkString();

    private int requestTimeout() {
        return this.requestTimeout;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ZkAdminManager adminManager() {
        return this.adminManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private TransactionCoordinator transactionCoordinator() {
        return this.transactionCoordinator;
    }

    private AutoTopicCreationManager autoTopicCreationManager() {
        return this.autoTopicCreationManager;
    }

    private void autoTopicCreationManager_$eq(AutoTopicCreationManager x$1) {
        this.autoTopicCreationManager = x$1;
    }

    private int internalTopicPartitions() {
        return this.internalTopicPartitions;
    }

    private short internalTopicReplicationFactor() {
        return this.internalTopicReplicationFactor;
    }

    private String placementJsonInternalTopics() {
        return this.placementJsonInternalTopics;
    }

    @BeforeEach
    public void setup() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), Integer.toString(this.requestTimeout()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(this.internalTopicPartitions()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(this.internalTopicPartitions()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        .colon.colon aliveBrokers = new .colon.colon((Object)new Node(0, "host0", 0, "rack0"), (List)new .colon.colon((Object)new Node(1, "host1", 1, "rack1"), (List)Nil$.MODULE$));
        Mockito.reset((Object[])new Object[]{this.metadataCache(), this.controller(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator()});
        Mockito.when((Object)this.metadataCache().getAliveBrokerNodes((ListenerName)ArgumentMatchers.any(ListenerName.class))).thenReturn((Object)aliveBrokers);
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        Mockito.when((Object)this.transactionCoordinator().placementConstraints()).thenReturn((Object)"");
    }

    @Test
    public void testCreateOffsetTopic() {
        this.testCreateTopic("__consumer_offsets", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor(), new Properties());
    }

    @Test
    public void testCreateOffsetTopicWithPlacementConstraints() {
        Properties properties = new Properties();
        properties.setProperty("confluent.placement.constraints", this.placementJsonInternalTopics());
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)properties);
        this.testCreateTopic("__consumer_offsets", true, this.internalTopicPartitions(), (short)-1, properties);
    }

    @Test
    public void testCreateTxnTopic() {
        this.testCreateTopic("__transaction_state", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor(), new Properties());
    }

    @Test
    public void testCreateTxnTopicWithPlacementConstraints() {
        Mockito.when((Object)this.transactionCoordinator().placementConstraints()).thenReturn((Object)this.placementJsonInternalTopics());
        this.testCreateTopic("__transaction_state", true, this.internalTopicPartitions(), (short)-1, new Properties());
    }

    @Test
    public void testCreateNonInternalTopic() {
        this.testCreateTopic("topic", false, 1, (short)1, new Properties());
    }

    private void testCreateTopic(String topicName, boolean isInternal, int numPartitions, short replicationFactor, Properties topicConfigs) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        CreateTopicsRequestData.CreatableTopicCollection topicsCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, numPartitions, replicationFactor, topicConfigs));
        CreateTopicsRequest.Builder requestBody = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicsCollection).setTimeoutMs(this.requestTimeout()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.eq((Object)requestBody), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
    }

    private int testCreateTopic$default$3() {
        return 1;
    }

    private short testCreateTopic$default$4() {
        return 1;
    }

    private Properties testCreateTopic$default$5() {
        return new Properties();
    }

    @Test
    public void testCreateTopicsWithForwardingDisabled() {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        String topicName = "topic";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, false, (Option<RequestContext>)None$.MODULE$);
        ((ZkAdminManager)Mockito.verify((Object)this.adminManager())).createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)this.getNewTopic(topicName, 1, (short)1, new Properties()))}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), (Function1)ArgumentMatchers.any(Function1.class));
    }

    @Test
    public void testInvalidReplicationFactorForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "topic", false, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testInvalidReplicationFactorForConsumerOffsetsTopic() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__consumer_offsets", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testInvalidReplicationFactorForTxnOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__transaction_state", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testTopicExistsErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForConsumerOffsetsTopic() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForTxnOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForConsumerOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForTxnOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testUnknownTopicPartitionForNonIntervalTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "topic", false, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testUnknownTopicPartitionForConsumerOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__consumer_offsets", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testUnknownTopicPartitionForTxnOffsetTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__transaction_state", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testTopicCreationWithMetadataContextPassPrincipal() {
        String topicName = "topic";
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "user");
        AtomicBoolean serializeIsCalled = new AtomicBoolean(false);
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null, userPrincipal, serializeIsCalled){
            private final KafkaPrincipal userPrincipal$1;
            private final AtomicBoolean serializeIsCalled$1;

            public byte[] serialize(KafkaPrincipal principal) {
                Assertions.assertEquals((Object)principal, (Object)this.userPrincipal$1);
                this.serializeIsCalled$1.set(true);
                return principal.toString().getBytes(StandardCharsets.UTF_8);
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
            }
            {
                this.userPrincipal$1 = userPrincipal$1;
                this.serializeIsCalled$1 = serializeIsCalled$1;
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, userPrincipal, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        Assertions.assertTrue((boolean)serializeIsCalled.get());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)argumentCaptor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
        EnvelopeRequest capturedRequest = ((EnvelopeRequest.Builder)argumentCaptor.getValue()).build(ApiKeys.ENVELOPE.latestVersion());
        byte[] utf8_bytes = capturedRequest.requestPrincipal();
        Object var8_8 = null;
        Assertions.assertEquals((Object)userPrincipal, (Object)SecurityUtils.parseKafkaPrincipal((String)new String(utf8_bytes, StandardCharsets.UTF_8)));
    }

    @Test
    public void testTopicCreationWithMetadataContextWhenPrincipalSerdeNotDefined() {
        String topicName = "topic";
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext)));
    }

    @Test
    public void testTopicCreationWithMetadataContextNoRetryUponUnsupportedVersion() {
        String topicName = "topic";
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

            public byte[] serialize(KafkaPrincipal principal) {
                return principal.toString().getBytes(StandardCharsets.UTF_8);
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        RequestHeader header = new RequestHeader(ApiKeys.ENVELOPE, 0, "client", 1);
        EnvelopeResponse response = new EnvelopeResponse(ByteBuffer.allocate(0), Errors.UNSUPPORTED_VERSION);
        ClientResponse clientResponse = new ClientResponse(header, null, null, 0L, 0L, false, null, null, (AbstractResponse)response);
        ((RequestCompletionHandler)argumentCaptor.getValue()).onComplete(clientResponse);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
    }

    private RequestContext initializeRequestContext(String topicName, KafkaPrincipal kafkaPrincipal, Optional<KafkaPrincipalSerde> principalSerde) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        new CreateTopicsRequestData.CreatableTopicCollection().add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, 1, (short)1, new Properties()));
        ApiVersionsResponseData.ApiVersion createTopicApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.CREATE_TOPICS.id).setMinVersion((short)0).setMaxVersion((short)0);
        Mockito.when((Object)this.brokerToController().controllerApiVersions()).thenReturn(Optional.of(NodeApiVersions.create(Collections.singleton(createTopicApiVersion))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 0);
        return new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), kafkaPrincipal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false, principalSerde);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void testErrorWithCreationInZk(Errors error, String topicName, boolean isInternal, Option<Errors> expectedError) {
        CreateTopicsRequestData.CreatableTopic creatableTopic;
        block5: {
            block4: {
                this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
                if (!isInternal) break block4;
                switch (topicName == null ? 0 : topicName.hashCode()) {
                    case -970371369: {
                        if (!"__consumer_offsets".equals(topicName)) break;
                        creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().offsetsTopicPartitions()), Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor()), new Properties());
                        break block5;
                    }
                    case -253293552: {
                        if (!"__transaction_state".equals(topicName)) break;
                        creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().transactionTopicPartitions()), Predef$.MODULE$.Short2short(this.config().transactionTopicReplicationFactor()), new Properties());
                        break block5;
                    }
                }
                throw new MatchError((Object)topicName);
            }
            creatableTopic = this.getNewTopic(topicName, 1, (short)1, new Properties());
        }
        CreateTopicsRequestData.CreatableTopic newTopic = creatableTopic;
        Errors errors = error;
        Errors errors2 = Errors.UNKNOWN_TOPIC_OR_PARTITION;
        Map topicErrors = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? null : (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)new ApiError(error))}));
        this.adminManager().createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)newTopic)}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Option)ArgumentMatchers.any(Option.class), (Function1)ArgumentMatchers.any(Function1.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            AutoTopicCreationManagerTest.$anonfun$testErrorWithCreationInZk$1(topicErrors, invocation);
            return BoxedUnit.UNIT;
        });
        this.createTopicAndVerifyResult((Errors)expectedError.getOrElse((Function0 & Serializable)() -> error), topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
    }

    private Option<Errors> testErrorWithCreationInZk$default$4() {
        return None$.MODULE$;
    }

    private void createTopicAndVerifyResult(Errors error, String topicName, boolean isInternal, Option<RequestContext> metadataContext) {
        Seq topicResponses = this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, metadataContext);
        Assertions.assertEquals((Object)new .colon.colon((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setIsInternal(isInternal).setName(topicName), (List)Nil$.MODULE$), (Object)topicResponses);
    }

    private Option<RequestContext> createTopicAndVerifyResult$default$4() {
        return None$.MODULE$;
    }

    private CreateTopicsRequestData.CreatableTopic getNewTopic(String topicName, int numPartitions, short replicationFactor, Properties topicConfigs) {
        return new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(numPartitions).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(topicConfigs));
    }

    private int getNewTopic$default$2() {
        return 1;
    }

    private short getNewTopic$default$3() {
        return 1;
    }

    private Properties getNewTopic$default$4() {
        return new Properties();
    }

    public static final /* synthetic */ void $anonfun$testErrorWithCreationInZk$1(Map topicErrors$1, InvocationOnMock invocation) {
        ((Function1)invocation.getArgument(6)).apply((Object)topicErrors$1);
    }

    public AutoTopicCreationManagerTest() {
        this.requestTimeout = 100;
        this.internalTopicPartitions = 2;
    }
}

