/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.telemetry.api.events.NoOpEventEmitter;
import io.opentelemetry.context.Context;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ThrottleCallback;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.junit.jupiter.api.AfterEach;
import org.mockito.Mockito;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001A\u0002\u0013Ea\u0005C\u00045\u0001\u0001\u0007I\u0011C\u001b\t\rm\u0002\u0001\u0015)\u0003(\u0011\u001da\u0004\u00011A\u0005\u0012uBq!\u0011\u0001A\u0002\u0013E!\t\u0003\u0004E\u0001\u0001\u0006KA\u0010\u0005\b\u000b\u0002\u0001\r\u0011\"\u0005G\u0011\u001da\u0005\u00011A\u0005\u00125Caa\u0014\u0001!B\u00139\u0005\"\u0002)\u0001\t\u0003\t\u0006\"B/\u0001\t#q\u0006\"\u00022\u0001\t#\u0019\u0007\"CA\u001e\u0001E\u0005I\u0011CA\u001f\u0011%\t9\u0006AI\u0001\n#\tI\u0006C\u0004\u0002b\u0001!\t\"a\u0019\t\u000f\u0005e\u0004\u0001\"\u0005\u0002|!9\u0011\u0011\u0010\u0001\u0005\u0012\u0005U\u0005bBAQ\u0001\u0011E\u00111\u0015\u0002\u001b\u0005\u0006\u001cXm\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005)\u0012\u0001\u0002;j[\u0016,\u0012a\n\t\u0003QIj\u0011!\u000b\u0006\u0003U-\nQ!\u001e;jYNT!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\tAbF\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a*\u0005!iunY6US6,\u0017\u0001\u0003;j[\u0016|F%Z9\u0015\u0005YJ\u0004C\u0001\u000f8\u0013\tATD\u0001\u0003V]&$\bb\u0002\u001e\u0004\u0003\u0003\u0005\raJ\u0001\u0004q\u0012\n\u0014!\u0002;j[\u0016\u0004\u0013\u0001\u00048v[\u000e\u000bG\u000e\u001c2bG.\u001cX#\u0001 \u0011\u0005qy\u0014B\u0001!\u001e\u0005\rIe\u000e^\u0001\u0011]Vl7)\u00197mE\u0006\u001c7n]0%KF$\"AN\"\t\u000fi2\u0011\u0011!a\u0001}\u0005ia.^7DC2d'-Y2lg\u0002\nq!\\3ue&\u001c7/F\u0001H!\tA%*D\u0001J\u0015\t)5&\u0003\u0002L\u0013\n9Q*\u001a;sS\u000e\u001c\u0018aC7fiJL7m]0%KF$\"A\u000e(\t\u000fiJ\u0011\u0011!a\u0001\u000f\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0005uK\u0006\u0014Hi\\<o)\u00051\u0004FA\u0006T!\t!6,D\u0001V\u0015\t1v+A\u0002ba&T!\u0001W-\u0002\u000f),\b/\u001b;fe*\u0011!\fM\u0001\u0006UVt\u0017\u000e^\u0005\u00039V\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0011\r\fG\u000e\u001c2bG.,\u0012a\u0018\t\u0003I\u0001L!!Y\u000b\u0003!QC'o\u001c;uY\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0017\u0001\u00042vS2$'+Z9vKN$XC\u00013k)\u001d)\u0017\u0011AA\n\u0003C\u0001B\u0001\b4im&\u0011q-\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005%TG\u0002\u0001\u0003\u0006W6\u0011\r\u0001\u001c\u0002\u0002)F\u0011Q\u000e\u001d\t\u000399L!a\\\u000f\u0003\u000f9{G\u000f[5oOB\u0011\u0011\u000f^\u0007\u0002e*\u00111oK\u0001\te\u0016\fX/Z:ug&\u0011QO\u001d\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3tiB\u0011q/ \b\u0003qnl\u0011!\u001f\u0006\u0003u^\tqA\\3uo>\u00148.\u0003\u0002}s\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017B\u0001@\u0000\u0005\u001d\u0011V-];fgRT!\u0001`=\t\u000f\u0005\rQ\u00021\u0001\u0002\u0006\u00059!-^5mI\u0016\u0014\b#BA\u0004\u0003\u001bAgbA9\u0002\n%\u0019\u00111\u0002:\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLA!a\u0004\u0002\u0012\t9!)^5mI\u0016\u0014(bAA\u0006e\"I\u0011QC\u0007\u0011\u0002\u0003\u0007\u0011qC\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u00033\ti\"\u0004\u0002\u0002\u001c)\u0011!pK\u0005\u0005\u0003?\tYB\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0005\u0002$5\u0001\n\u00111\u0001\u0002&\u0005A1\r\\5f]RLE\r\u0005\u0003\u0002(\u0005Ub\u0002BA\u0015\u0003c\u00012!a\u000b\u001e\u001b\t\tiCC\u0002\u00020e\ta\u0001\u0010:p_Rt\u0014bAA\u001a;\u00051\u0001K]3eK\u001aLA!a\u000e\u0002:\t11\u000b\u001e:j]\u001eT1!a\r\u001e\u0003Y\u0011W/\u001b7e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012T\u0003BA \u0003+*\"!!\u0011+\t\u0005]\u00111I\u0016\u0003\u0003\u000b\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%A\u0005v]\u000eDWmY6fI*\u0019\u0011qJ\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002T\u0005%#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)1N\u0004b\u0001Y\u00061\"-^5mIJ+\u0017/^3ti\u0012\"WMZ1vYR$3'\u0006\u0003\u0002\\\u0005}SCAA/U\u0011\t)#a\u0011\u0005\u000b-|!\u0019\u00017\u0002\u0019\t,\u0018\u000e\u001c3TKN\u001c\u0018n\u001c8\u0015\t\u0005\u0015\u0014Q\u000f\t\u0005\u0003O\n\tHD\u0002\u0002jmtA!a\u001b\u0002p9!\u00111FA7\u0013\u0005A\u0012B\u0001>\u0018\u0013\r\t\u0019h \u0002\b'\u0016\u001c8/[8o\u0011\u001d\t9\b\u0005a\u0001\u0003K\tA!^:fe\u0006YQ.Y=cKJ+7m\u001c:e)%q\u0014QPAD\u0003\u0013\u000bY\tC\u0004\u0002\u0000E\u0001\r!!!\u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0011\u0007\u0011\n\u0019)C\u0002\u0002\u0006V\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\"9\u0011qO\tA\u0002\u0005\u0015\u0002bBA\u0012#\u0001\u0007\u0011Q\u0005\u0005\b\u0003\u001b\u000b\u0002\u0019AAH\u0003\u00151\u0018\r\\;f!\ra\u0012\u0011S\u0005\u0004\u0003'k\"A\u0002#pk\ndW\rF\u0005?\u0003/\u000bI*!(\u0002 \"9\u0011q\u0010\nA\u0002\u0005\u0005\u0005bBAN%\u0001\u0007\u0011QM\u0001\bg\u0016\u001c8/[8o\u0011\u001d\t\u0019C\u0005a\u0001\u0003KAq!!$\u0013\u0001\u0004\ty)\u0001\u0005uQJ|G\u000f\u001e7f)-1\u0014QUAT\u0003S\u000bY+a,\t\u000f\u0005}4\u00031\u0001\u0002\u0002\"9\u0011qO\nA\u0002\u0005\u0015\u0002bBA\u0012'\u0001\u0007\u0011Q\u0005\u0005\u0007\u0003[\u001b\u0002\u0019\u0001 \u0002\u001dQD'o\u001c;uY\u0016$\u0016.\\3Ng\"1\u0011\u0011W\nA\u0002}\u000b\u0011d\u00195b]:,G\u000e\u00165s_R$H.\u001b8h\u0007\u0006dGNY1dW\u0002")
public class BaseClientQuotaManagerTest {
    private MockTime time = new MockTime();
    private int numCallbacks = 0;
    private Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    public ThrottleCallback callback() {
        return new ThrottleCallback(this){
            private final /* synthetic */ BaseClientQuotaManagerTest $outer;

            public void startThrottling() {
            }

            public void endThrottling() {
                this.$outer.numCallbacks_$eq(this.$outer.numCallbacks() + 1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName, String clientId) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(builder.apiKey(), request.version(), clientId, 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics, (Option)None$.MODULE$, Context.root(), NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L));
    }

    public <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public <T extends AbstractRequest> String buildRequest$default$3() {
        return "";
    }

    public RequestChannel.Session buildSession(String user) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return new RequestChannel.Session(principal, null);
    }

    public int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        RequestChannel.Session session = this.buildSession(user);
        return this.maybeRecord(quotaManager, session, clientId, value);
    }

    public int maybeRecord(ClientQuotaManager quotaManager, RequestChannel.Session session, String clientId, double value) {
        return quotaManager.maybeRecordAndGetThrottleTimeMs(session, clientId, value, this.time().milliseconds());
    }

    /*
     * WARNING - void declaration
     */
    public void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, ThrottleCallback channelThrottlingCallback) {
        void var9_9;
        ListenerName x$3;
        FetchRequest.Builder x$1 = FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1000, new HashMap());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)x$1, x$3 = this.buildRequest$default$2(), clientId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        quotaManager.throttle((RequestChannel.Request)var9_9, channelThrottlingCallback, throttleTimeMs);
    }
}

