/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.server.BrokerConfigHandler;
import kafka.server.ConfigEntityName$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=a\u0001B\f\u0019\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u0004.\u0001\u0001\u0006IA\u000b\u0005\b]\u0001\u0011\r\u0011\"\u0001*\u0011\u0019y\u0003\u0001)A\u0005U!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0004BB\u001f\u0001A\u0003%!\u0007C\u0005?\u0001\u0001\u0007\t\u0019!C\u0001\u007f!I1\t\u0001a\u0001\u0002\u0004%\t\u0001\u0012\u0005\n\u0015\u0002\u0001\r\u0011!Q!\n\u0001C\u0011b\u0013\u0001A\u0002\u0003\u0007I\u0011\u0001'\t\u0013m\u0003\u0001\u0019!a\u0001\n\u0003a\u0006\"\u00030\u0001\u0001\u0004\u0005\t\u0015)\u0003N\u0011%y\u0006\u00011AA\u0002\u0013%\u0001\rC\u0005g\u0001\u0001\u0007\t\u0019!C\u0005O\"I\u0011\u000e\u0001a\u0001\u0002\u0003\u0006K!\u0019\u0005\u0006U\u0002!\ta\u001b\u0005\u0006o\u0002!\ta\u001b\u0005\u0006y\u0002!\ta\u001b\u0005\u0007\u0003\u0007\u0001A\u0011A6\t\r\u0005\u001d\u0001\u0001\"\u0001l\u0011\u0019\tY\u0001\u0001C\u0001W\n9\"I]8lKJ\u001cuN\u001c4jO\"\u000bg\u000e\u001a7feR+7\u000f\u001e\u0006\u00033i\taa]3sm\u0016\u0014(\"A\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0014\u0001\u001b\u0005A\u0012\u0001F:uCRL7\rT3bI\u0016\u0014H\u000b\u001b:piRdW-F\u0001+!\ty2&\u0003\u0002-A\t!Aj\u001c8h\u0003U\u0019H/\u0019;jG2+\u0017\rZ3s)\"\u0014x\u000e\u001e;mK\u0002\nac\u001d;bi&\u001cgi\u001c7m_^,'\u000f\u00165s_R$H.Z\u0001\u0018gR\fG/[2G_2dwn^3s)\"\u0014x\u000e\u001e;mK\u0002\n!\u0001\u001e9\u0016\u0003I\u0002\"aM\u001e\u000e\u0003QR!!\u000e\u001c\u0002\r\r|W.\\8o\u0015\tYrG\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f5\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u00035\u0019wN\u001c4jO\"\u000bg\u000e\u001a7feV\t\u0001\t\u0005\u0002(\u0003&\u0011!\t\u0007\u0002\u0014\u0005J|7.\u001a:D_:4\u0017n\u001a%b]\u0012dWM]\u0001\u0012G>tg-[4IC:$G.\u001a:`I\u0015\fHCA#I!\tyb)\u0003\u0002HA\t!QK\\5u\u0011\u001dI\u0015\"!AA\u0002\u0001\u000b1\u0001\u001f\u00132\u00039\u0019wN\u001c4jO\"\u000bg\u000e\u001a7fe\u0002\nQ\"];pi\u0006l\u0015M\\1hKJ\u001cX#A'\u0011\u00059CfBA(W\u001d\t\u0001VK\u0004\u0002R)6\t!K\u0003\u0002T9\u00051AH]8pizJ\u0011aG\u0005\u00033iI!a\u0016\r\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u0005eS&!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u0002X1\u0005\t\u0012/^8uC6\u000bg.Y4feN|F%Z9\u0015\u0005\u0015k\u0006bB%\r\u0003\u0003\u0005\r!T\u0001\u000fcV|G/Y'b]\u0006<WM]:!\u0003\u001diW\r\u001e:jGN,\u0012!\u0019\t\u0003E\u0012l\u0011a\u0019\u0006\u0003?RJ!!Z2\u0003\u000f5+GO]5dg\u0006YQ.\u001a;sS\u000e\u001cx\fJ3r)\t)\u0005\u000eC\u0004J\u001f\u0005\u0005\t\u0019A1\u0002\u00115,GO]5dg\u0002\nQa]3u+B$\u0012!\u0012\u0015\u0003#5\u0004\"A\\;\u000e\u0003=T!\u0001]9\u0002\u0007\u0005\u0004\u0018N\u0003\u0002sg\u00069!.\u001e9ji\u0016\u0014(B\u0001;:\u0003\u0015QWO\\5u\u0013\t1xN\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003%e\u0004\"A\u001c>\n\u0005m|'!C!gi\u0016\u0014X)Y2i\u0003\u0005\"Xm\u001d;Pm\u0016\u0014(/\u001b3fgJ+\u0007\u000f\\5dCRLwN\u001c+ie>$H\u000f\\3tQ\t\u0019b\u0010\u0005\u0002o\u007f&\u0019\u0011\u0011A8\u0003\tQ+7\u000f^\u0001*i\u0016\u001cHo\u0014<feJLG-Z:SKBd\u0017nY1uS>tG\u000b\u001b:piRdW\r\u001a*fa2L7-Y:)\u0005Qq\u0018A\r;fgR\u0014VM^3siN\u0014\u0015mY6U_N#\u0018\r^5dC2d\u0017pU3u%\u0016\u0004H.[2bi&|g\u000e\u00165s_R$H.Z:)\u0005Uq\u0018A\u000f;fgR\u0014VM^3siN\u0014\u0015mY6U_N#\u0018\r^5dC2d\u0017pU3u%\u0016\u0004H.[2bi&|g\u000e\u00165s_R$H.\u001a3SKBd\u0017nY1tQ\t1b\u0010")
public class BrokerConfigHandlerTest {
    private final long staticLeaderThrottle;
    private final long staticFollowerThrottle;
    private final TopicPartition tp = new TopicPartition("tp", 0);
    private BrokerConfigHandler configHandler;
    private QuotaFactory.QuotaManagers quotaManagers;
    private Metrics metrics;

    public long staticLeaderThrottle() {
        return this.staticLeaderThrottle;
    }

    public long staticFollowerThrottle() {
        return this.staticFollowerThrottle;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public BrokerConfigHandler configHandler() {
        return this.configHandler;
    }

    public void configHandler_$eq(BrokerConfigHandler x$1) {
        this.configHandler = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, "127.0.0.1:9999", true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        props.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(this.staticLeaderThrottle()));
        props.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), Long.toString(this.staticFollowerThrottle()));
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "none");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.metrics_$eq(new Metrics());
        this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)new MockTime(), "", (Option)None$.MODULE$, (Option)None$.MODULE$));
        this.configHandler_$eq(new BrokerConfigHandler(config, this.quotaManagers()));
    }

    @AfterEach
    public void teardown() {
        this.metrics().close();
        this.quotaManagers().shutdown();
    }

    @Test
    public void testOverridesReplicationThrottles() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "333");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "444");
        Assertions.assertEquals((long)Defaults$.MODULE$.QuotaBytesPerSecond(), (long)this.quotaManagers().alterLogDirs().upperBound());
        this.configHandler().processConfigChanges("0", props);
        Assertions.assertEquals((long)333L, (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)444L, (long)this.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)Defaults$.MODULE$.QuotaBytesPerSecond(), (long)this.quotaManagers().alterLogDirs().upperBound());
        Properties propsDefault = new Properties();
        propsDefault.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "555");
        this.configHandler().processConfigChanges(ConfigEntityName$.MODULE$.Default(), propsDefault);
        Assertions.assertEquals((long)333L, (long)this.quotaManagers().leader().upperBound());
        this.configHandler().processConfigChanges("0", new Properties());
        Assertions.assertEquals((long)555L, (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)this.staticFollowerThrottle(), (long)this.quotaManagers().follower().upperBound());
        Properties props2 = new Properties();
        props2.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "666");
        this.configHandler().processConfigChanges("1", props2);
        Assertions.assertEquals((long)555L, (long)this.quotaManagers().leader().upperBound());
        this.configHandler().processConfigChanges(ConfigEntityName$.MODULE$.Default(), new Properties());
        Assertions.assertEquals((long)this.staticLeaderThrottle(), (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)this.staticFollowerThrottle(), (long)this.quotaManagers().follower().upperBound());
    }

    @Test
    public void testOverridesReplicationThrottledReplicas() {
        Properties props = new Properties();
        Assertions.assertTrue((boolean)this.quotaManagers().leader().isThrottled(this.tp()));
        Assertions.assertFalse((boolean)this.quotaManagers().follower().isThrottled(this.tp()));
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "none");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "*");
        this.configHandler().processConfigChanges("0", props);
        Assertions.assertFalse((boolean)this.quotaManagers().leader().isThrottled(this.tp()), (String)"expected leader throttle to be disabled after dynamic reconfiguration");
        Assertions.assertTrue((boolean)this.quotaManagers().follower().isThrottled(this.tp()), (String)"expected follower throttle to be enabled after dynamic reconfiguration");
    }

    @Test
    public void testRevertsBackToStaticallySetReplicationThrottles() {
        Properties props = new Properties();
        Assertions.assertTrue((boolean)this.quotaManagers().leader().isThrottled(this.tp()));
        Assertions.assertFalse((boolean)this.quotaManagers().follower().isThrottled(this.tp()));
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "none");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "*");
        this.configHandler().processConfigChanges("0", props);
        Assertions.assertFalse((boolean)this.quotaManagers().leader().isThrottled(this.tp()), (String)"Dynamic broker throttle setting should override the static one");
        Assertions.assertTrue((boolean)this.quotaManagers().follower().isThrottled(this.tp()));
        this.configHandler().processConfigChanges("0", new Properties());
        Assertions.assertTrue((boolean)this.quotaManagers().leader().isThrottled(this.tp()), (String)"expected leader throttle to be enabled after resetting to static config");
        Assertions.assertFalse((boolean)this.quotaManagers().follower().isThrottled(this.tp()), (String)"expected follower throttle to be disabled after resetting to static config");
    }

    @Test
    public void testRevertsBackToStaticallySetReplicationThrottledReplicas() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "333");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "444");
        this.configHandler().processConfigChanges("0", props);
        Assertions.assertEquals((long)333L, (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)444L, (long)this.quotaManagers().follower().upperBound());
        this.configHandler().processConfigChanges("0", new Properties());
        Assertions.assertEquals((long)this.staticLeaderThrottle(), (long)this.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)this.staticFollowerThrottle(), (long)this.quotaManagers().follower().upperBound());
    }

    public BrokerConfigHandlerTest() {
        this.staticLeaderThrottle = 111L;
        this.staticFollowerThrottle = 222L;
    }
}

