/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import kafka.server.BaseRequestTest;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.DescribeBrokerHealthRequest;
import org.apache.kafka.common.requests.DescribeBrokerHealthResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.$less$colon$less$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000593A\u0001B\u0003\u0001\u0015!)q\u0002\u0001C\u0001!!)!\u0003\u0001C)'!)\u0001\u0005\u0001C\u0001C\t)\"I]8lKJDU-\u00197uQ.\u0013\u0018M\u001a;UKN$(B\u0001\u0004\b\u0003\u0019\u0019XM\u001d<fe*\t\u0001\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Y\u0001C\u0001\u0007\u000e\u001b\u0005)\u0011B\u0001\b\u0006\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0012!\ta\u0001!A\bnKR\fG-\u0019;b-\u0016\u00148/[8o+\u0005!\u0002CA\u000b\u001f\u001b\u00051\"BA\f\u0019\u0003\u0019\u0019w.\\7p]*\u0011a!\u0007\u0006\u0003\u0011iQ!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO&\u0011qD\u0006\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006!B/Z:u\t\u0016<'/\u00193bi&|gNR1jYN$\"A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006S\r\u0001\rAK\u0001\u0007cV|'/^7\u0011\u0005-\u0012dB\u0001\u00171!\tiC%D\u0001/\u0015\ty\u0013\"\u0001\u0004=e>|GOP\u0005\u0003c\u0011\na\u0001\u0015:fI\u00164\u0017BA\u001a5\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0007\n\u0015\u0005\u0007Y\u0002\u0015\t\u0005\u00028}5\t\u0001H\u0003\u0002:u\u00051\u0001/\u0019:b[NT!a\u000f\u001f\u0002\u000f),\b/\u001b;fe*\u0011Q\bH\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u007fa\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003\t\u000b!e\u001f3jgBd\u0017-\u001f(b[\u0016lhf_1sOVlWM\u001c;t/&$\bNT1nKNl\b\u0006B\u0002E\u0015.\u0003\"!\u0012%\u000e\u0003\u0019S!a\u0012\u001d\u0002\u0011A\u0014xN^5eKJL!!\u0013$\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0005a\u0015%A'\u0002\u000b-\u0014\u0018M\u001a;")
public class BrokerHealthKraftTest
extends BaseRequestTest {
    @Override
    public MetadataVersion metadataVersion() {
        return MetadataVersion.IBP_3_4_IV0;
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft"})
    public void testDegradationFails(String quorum) {
        AlterBrokerHealthRequest request = (AlterBrokerHealthRequest)new AlterBrokerHealthRequest.Builder(new AlterBrokerHealthRequestData().setBrokerIds(Collections.singletonList(Predef$.MODULE$.int2Integer(0))).setReason("rcca-123").setComponentCode(BrokerComponent.UNSPECIFIED.id()).setStatusCode(ComponentHealthStatus.DEGRADED.id()).setForce(true)).build();
        AlterBrokerHealthResponse response = (AlterBrokerHealthResponse)this.connectAndReceive((AbstractRequest)request, this.adminSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)response.data().errorCode());
        Assertions.assertEquals((Object)String.format("Alter broker health not supported in version %s", this.metadataVersion().confluentRelease()), (Object)response.data().errorMessage());
        DescribeBrokerHealthRequest describeRequest = (DescribeBrokerHealthRequest)new DescribeBrokerHealthRequest.Builder().build();
        DescribeBrokerHealthResponse describeResponse = (DescribeBrokerHealthResponse)this.connectAndReceive((AbstractRequest)describeRequest, this.adminSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)describeResponse.data().errorCode());
    }
}

