/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBroker;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.DescribeBrokerHealthRequest;
import org.apache.kafka.common.requests.DescribeBrokerHealthResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tag(value="bazel:cpu:2")
@ScalaSignature(bytes="\u0006\u0005\r}e\u0001B\u001b7\u0001mBQ\u0001\u0011\u0001\u0005\u0002\u0005Cqa\u0011\u0001A\u0002\u0013\u0005A\tC\u0004Q\u0001\u0001\u0007I\u0011A)\t\ri\u0003\u0001\u0015)\u0003F\u0011\u001dY\u0006A1A\u0005\u0002qCa!\u001a\u0001!\u0002\u0013i\u0006b\u00024\u0001\u0005\u0004%\ta\u001a\u0005\u0007W\u0002\u0001\u000b\u0011\u00025\t\u000f1\u0004!\u0019!C\u0001O\"1Q\u000e\u0001Q\u0001\n!DqA\u001c\u0001C\u0002\u0013\u0005q\r\u0003\u0004p\u0001\u0001\u0006I\u0001\u001b\u0005\u0006a\u0002!\t%\u001d\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002x\u0001!\t!!\u001f\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!a0\u0001\t\u0003\t\t\rC\u0004\u0002L\u0002!\t!!4\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\bbBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013AqAa\u0005\u0001\t\u0013\u0011)\u0002C\u0005\u0003|\u0001\t\n\u0011\"\u0003\u0003~!I!1\u0013\u0001\u0012\u0002\u0013%!Q\u0013\u0005\n\u00053\u0003\u0011\u0013!C\u0005\u00057C\u0011Ba(\u0001#\u0003%IA!)\t\u000f\t\u0015\u0006\u0001\"\u0003\u0003(\"9!Q\u0017\u0001\u0005\n\t]\u0006\"\u0003B|\u0001E\u0005I\u0011\u0002B}\u0011%\u0011i\u0010AI\u0001\n\u0013\u0011\t\u000bC\u0005\u0003\u0000\u0002\t\n\u0011\"\u0003\u0003~!I1\u0011\u0001\u0001\u0012\u0002\u0013%!Q\u0013\u0005\n\u0007\u0007\u0001\u0011\u0013!C\u0005\u0007\u000bA\u0011b!\u0003\u0001#\u0003%Iaa\u0003\t\u0013\r=\u0001!%A\u0005\n\rE\u0001bBB\u000b\u0001\u0011%1q\u0003\u0005\b\u0007w\u0001A\u0011BB\u001f\u0011%\u0019\u0019\u0005AI\u0001\n\u0013\u0019)\u0001C\u0004\u0004F\u0001!Iaa\u0012\t\u0013\r5\u0003!%A\u0005\n\r\u0015\u0001bBB(\u0001\u0011%1\u0011\u000b\u0005\b\u0007?\u0002A\u0011BB1\u0011\u001d\u00199\u0007\u0001C\u0005\u0007SBqa!\u001d\u0001\t\u0013\u0019\u0019H\u0001\tCe>\\WM\u001d%fC2$\b\u000eV3ti*\u0011q\u0007O\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003e\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001yA\u0011QHP\u0007\u0002m%\u0011qH\u000e\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\u0011\t\u0003{\u0001\t1\"\u00193nS:\u001cE.[3oiV\tQ\t\u0005\u0002G\u001d6\tqI\u0003\u0002I\u0013\u000691\r\\5f]R\u001c(BA\u001dK\u0015\tYE*A\u0005d_:4G.^3oi*\tQ*\u0001\u0002j_&\u0011qj\u0012\u0002\u000b\u00072|W\u000fZ!e[&t\u0017aD1e[&t7\t\\5f]R|F%Z9\u0015\u0005IC\u0006CA*W\u001b\u0005!&\"A+\u0002\u000bM\u001c\u0017\r\\1\n\u0005]#&\u0001B+oSRDq!W\u0002\u0002\u0002\u0003\u0007Q)A\u0002yIE\nA\"\u00193nS:\u001cE.[3oi\u0002\n\u0011\u0002^8qS\u000et\u0015-\\3\u0016\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\t1\fgn\u001a\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0004TiJLgnZ\u0001\u000bi>\u0004\u0018n\u0019(b[\u0016\u0004\u0013A\u000191+\u0005A\u0007CA*j\u0013\tQGKA\u0002J]R\f1\u0001\u001d\u0019!\u0003\t\u0001\u0018'A\u0002qc\u0001\n!\u0001\u001d\u001a\u0002\u0007A\u0014\u0004%A\u0003tKR,\u0006\u000f\u0006\u0002Se\")1/\u0004a\u0001i\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002v}6\taO\u0003\u0002xq\u0006\u0019\u0011\r]5\u000b\u0005eT\u0018a\u00026va&$XM\u001d\u0006\u0003wr\fQA[;oSRT\u0011!`\u0001\u0004_J<\u0017BA@w\u0005!!Vm\u001d;J]\u001a|\u0007fA\u0007\u0002\u0004A\u0019Q/!\u0002\n\u0007\u0005\u001daO\u0001\u0006CK\u001a|'/Z#bG\"\fqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0003\u0003\u001b\u0001b!a\u0004\u0002 \u0005\u0015b\u0002BA\t\u00037qA!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/Q\u0014A\u0002\u001fs_>$h(C\u0001V\u0013\r\ti\u0002V\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t#a\t\u0003\u0007M+\u0017OC\u0002\u0002\u001eQ\u00032!PA\u0014\u0013\r\tIC\u000e\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\r\u0006\u0003\u0002&\u0005=\u0002BBA\u0019\u001f\u0001\u0007\u0001.\u0001\u0004o_\u0012,\u0017\nZ\u0001\u0018i\u0016\u001cH\u000fR3n_RLwN\\:XSRDGk\u001c9jGN$2AUA\u001c\u0011\u001d\tI\u0004\u0005a\u0001\u0003w\ta!];peVl\u0007\u0003BA\u001f\u0003\u000brA!a\u0010\u0002BA\u0019\u00111\u0003+\n\u0007\u0005\rC+\u0001\u0004Qe\u0016$WMZ\u0005\u0004I\u0006\u001d#bAA\")\":\u0001#a\u0013\u0002X\u0005e\u0003\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005E\u00030\u0001\u0004qCJ\fWn]\u0005\u0005\u0003+\nyEA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u00111L\u0001#w\u0012L7\u000f\u001d7bs:\u000bW.Z?/w\u0006\u0014x-^7f]R\u001cx+\u001b;i\u001d\u0006lWm]?)\u000fA\ty&a\u001b\u0002nA!\u0011\u0011MA4\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005=\u0013\u0001\u00039s_ZLG-\u001a:\n\t\u0005%\u00141\r\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005=\u00141O\u0011\u0003\u0003c\n!A_6\"\u0005\u0005U\u0014!B6sC\u001a$\u0018a\t;fgR$U-\\8uS>t7oV5uQ\u000e{g\u000e\u001e:pY2,'OR1jY>4XM\u001d\u000b\u0004%\u0006m\u0004bBA\u001d#\u0001\u0007\u00111\b\u0015\b#\u0005-\u0013qKA-Q\u001d\t\u0012qLA6\u0003\u0003c#!a\u001c\u0002QQ,7\u000f\u001e#f[>$\u0018n\u001c8t/&$\bn\u0013*bMR\u001cuN\u001c;s_2dWM\u001d$bS2|g/\u001a:\u0015\u0007I\u000b9\tC\u0004\u0002:I\u0001\r!a\u000f)\u000fI\tY%a\u0016\u0002Z!:!#a\u0018\u0002l\u00055EFAA:\u0003I\"Xm\u001d;D_:$(o\u001c7mKJ4\u0015-\u001b7pm\u0016\u0014\u0018*\\7fI&\fG/\u001a7z\u0003\u001a$XM\u001d#f[>$XM\u0011:pW\u0016\u0014Hc\u0001*\u0002\u0014\"9\u0011\u0011H\nA\u0002\u0005m\u0002fB\n\u0002L\u0005]\u0013\u0011\f\u0015\b'\u0005}\u00131NAMY\t\ty'A\u000buKN$\u0018\t\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5\u0015\u0007I\u000by\nC\u0004\u0002:Q\u0001\r!a\u000f)\u000fQ\tY%a\u0016\u0002Z!:A#a\u0018\u0002l\u0005\u0015F\u0006BA8\u0003g\n!\u0006^3ti\u0006cG/\u001a:Ce>\\WM\u001d%fC2$\bn\u00148V]J,w-[:uKJ,GM\u0011:pW\u0016\u00148\u000fF\u0002S\u0003WCq!!\u000f\u0016\u0001\u0004\tY\u0004K\u0004\u0016\u0003\u0017\n9&!\u0017)\u000fU\ty&a\u001b\u000222\u0012\u0011qN\u00010i\u0016\u001cHo\u0013*bMR\fE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[(o+:\u0014XmZ5ti\u0016\u0014X\r\u001a\"s_.,'o\u001d\u000b\u0004%\u0006]\u0006bBA\u001d-\u0001\u0007\u00111\b\u0015\b-\u0005-\u0013qKA-Q\u001d1\u0012qLA6\u0003{c#!a\u001d\u0002UQ,7\u000f^!mi\u0016\u0014(I]8lKJDU-\u00197uQB\u0013x\u000e]1hCR,7\u000fS3bYRD7\u000b^1uKR\u0019!+a1\t\u000f\u0005er\u00031\u0001\u0002<!:q#a\u0013\u0002X\u0005e\u0003fB\f\u0002`\u0005-\u0014\u0011\u001a\u0017\u0005\u0003_\n\u0019(\u0001\u0010uKN$H)Z7pi&|gn]#yG\u0016,Gm]'bq\n\u0013xn[3sgR\u0019!+a4\t\u000f\u0005e\u0002\u00041\u0001\u0002<!:\u0001$a\u0013\u0002X\u0005e\u0003f\u0002\r\u0002`\u0005-\u0014Q\u001b\u0017\u0005\u0003_\n\u0019(\u0001\u0012uKN$H)Z7pi&|gn],iK:$vn\u001c$fo2Kg/\u001a\"s_.,'o\u001d\u000b\u0004%\u0006m\u0007bBA\u001d3\u0001\u0007\u00111\b\u0015\b3\u0005-\u0013qKA-Q\u001dI\u0012qLA6\u0003CdC!a\u001c\u0002t\u0005\u0001C/Z:u\u00032$XM\u001d\"s_.,'\u000fS3bYRD\u0017\nZ3na>$XM\\2f)\r\u0011\u0016q\u001d\u0005\b\u0003sQ\u0002\u0019AA\u001eQ\u001dQ\u00121JA,\u00033BsAGA0\u0003W\ni\u000f\f\u0003\u0002p\u0005M\u0014A\r;fgR\fE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f\u001b%b]\u0012dWm\u001d(pi\u000e{g\u000e\u001e:pY2,'/\u0012=dKB$\u0018n\u001c8\u0015\u0007I\u000b\u0019\u0010C\u0004\u0002:m\u0001\r!a\u000f)\u000fm\tY%a\u0016\u0002Z!:1$a\u0018\u0002l\u0005eHFAA8\u0003M\"Xm\u001d;BYR,'O\u0011:pW\u0016\u0014\b*Z1mi\"D\u0015M\u001c3mKNLeN^1mS\u0012\u0014V-];fgR,\u0005pY3qi&|g\u000eF\u0002S\u0003\u007fDq!!\u000f\u001d\u0001\u0004\tY\u0004K\u0004\u001d\u0003\u0017\n9&!\u0017)\u000fq\ty&a\u001b\u0003\u00061\"\u0011qNA:\u0003U\"Xm\u001d;EKN\u001c'/\u001b2f\u0005J|7.\u001a:IK\u0006dG\u000f\u001b%b]\u0012dWm\u001d(pi\u000e{g\u000e\u001e:pY2,'/\u0012=dKB$\u0018n\u001c8\u0015\u0007I\u0013Y\u0001C\u0004\u0002:u\u0001\r!a\u000f)\u000fu\tY%a\u0016\u0002Z!:Q$a\u0018\u0002l\tEAFAA8\u0003y\u0019'/Z1uK\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo\u001d*fgVdG\u000f\u0006\u0007\u0003\u0018\t\u001d#1\nB/\u0005O\u00129\b\u0005\u0003\u0003\u001a\t\u0005c\u0002\u0002B\u000e\u0005wqAA!\b\u000369!!q\u0004B\u0018\u001d\u0011\u0011\tCa\u000b\u000f\t\t\r\"q\u0005\b\u0005\u0003'\u0011)#C\u0001~\u0013\r\u0011I\u0003`\u0001\u0007CB\f7\r[3\n\u0007e\u0012iCC\u0002\u0003*qLAA!\r\u00034\u000511m\\7n_:T1!\u000fB\u0017\u0013\u0011\u00119D!\u000f\u0002\u000f5,7o]1hK*!!\u0011\u0007B\u001a\u0013\u0011\u0011iDa\u0010\u0002;\u0005cG/\u001a:Ce>\\WM\u001d%fC2$\bNU3ta>t7/\u001a#bi\u0006TAAa\u000e\u0003:%!!1\tB#\u0005a\u0011%o\\6fe\"+\u0017\r\u001c;i'R\fG/^:SKN,H\u000e\u001e\u0006\u0005\u0005{\u0011y\u0004\u0003\u0004\u0003Jy\u0001\r\u0001[\u0001\tEJ|7.\u001a:JI\"I!Q\n\u0010\u0011\u0002\u0003\u0007!qJ\u0001\nG>l\u0007o\u001c8f]R\u0004BA!\u0015\u0003Z5\u0011!1\u000b\u0006\u0005\u0005+\u00129&A\u0003bI6LgNC\u0002I\u0005gIAAa\u0017\u0003T\ty!I]8lKJ\u001cu.\u001c9p]\u0016tG\u000fC\u0005\u0003`y\u0001\n\u00111\u0001\u0003b\u0005a\u0001.Z1mi\"\u001cF/\u0019;vgB!!\u0011\u000bB2\u0013\u0011\u0011)Ga\u0015\u0003+\r{W\u000e]8oK:$\b*Z1mi\"\u001cF/\u0019;vg\"I!\u0011\u000e\u0010\u0011\u0002\u0003\u0007!1N\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0005[\u0012\u0019(\u0004\u0002\u0003p)!!\u0011\u000fB\u001d\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B;\u0005_\u0012a!\u0012:s_J\u001c\b\"\u0003B==A\u0005\t\u0019AA\u001e\u0003!)'O]8s\u001bN<\u0017\u0001K2sK\u0006$XM\u0011:pW\u0016\u0014\b*Z1mi\"\u001cF/\u0019;vgJ+7/\u001e7uI\u0011,g-Y;mi\u0012\u0012TC\u0001B@U\u0011\u0011yE!!,\u0005\t\r\u0005\u0003\u0002BC\u0005\u001fk!Aa\"\u000b\t\t%%1R\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!$U\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005#\u00139IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001f\u0019:fCR,'I]8lKJDU-\u00197uQN#\u0018\r^;t%\u0016\u001cX\u000f\u001c;%I\u00164\u0017-\u001e7uIM*\"Aa&+\t\t\u0005$\u0011Q\u0001)GJ,\u0017\r^3Ce>\\WM\u001d%fC2$\bn\u0015;biV\u001c(+Z:vYR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005;SCAa\u001b\u0003\u0002\u0006A3M]3bi\u0016\u0014%o\\6fe\"+\u0017\r\u001c;i'R\fG/^:SKN,H\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u0015\u0016\u0005\u0003w\u0011\t)\u0001\nhKR\u0014%o\\6fe\"+\u0017\r\u001c;i\u001b\u0006\u0004XC\u0001BU!\u001d\tiDa+i\u0005_KAA!,\u0002H\t\u0019Q*\u00199\u0011\t\tE#\u0011W\u0005\u0005\u0005g\u0013\u0019F\u0001\bEK\u001e\u0014\u0018\rZ3e\u0005J|7.\u001a:\u0002?\u0005dG/\u001a:Ce>\\WM\u001d%fC2$\b.\u00118e\u000f\u0016$(+Z:q_:\u001cX\r\u0006\t\u0003:\n\u0015'1\u001aBh\u0005#\u0014\u0019N!8\u0003hB!!1\u0018Ba\u001b\t\u0011iL\u0003\u0003\u0003@\ne\u0012\u0001\u0003:fcV,7\u000f^:\n\t\t\r'Q\u0018\u0002\u001a\u00032$XM\u001d\"s_.,'\u000fS3bYRD'+Z:q_:\u001cX\rC\u0005\u0003H\u0012\u0002\n\u00111\u0001\u0003J\u0006I!M]8lKJLEm\u001d\t\u0006\u0003\u001f\ty\u0002\u001b\u0005\n\u0005\u001b$\u0003\u0013!a\u0001\u0003w\taA]3bg>t\u0007\"\u0003B'IA\u0005\t\u0019\u0001B(\u0011%\u0011y\u0006\nI\u0001\u0002\u0004\u0011\t\u0007C\u0005\u0003V\u0012\u0002\n\u00111\u0001\u0003X\u0006)am\u001c:dKB\u00191K!7\n\u0007\tmGKA\u0004C_>dW-\u00198\t\u0013\t}G\u0005%AA\u0002\t\u0005\u0018a\u0002<feNLwN\u001c\t\u0004'\n\r\u0018b\u0001Bs)\n)1\u000b[8si\"I!\u0011\u001e\u0013\u0011\u0002\u0003\u0007!1^\u0001\rg>\u001c7.\u001a;TKJ4XM\u001d\t\u0005\u0005[\u0014\u00190\u0004\u0002\u0003p*\u0019!\u0011\u001f\u001d\u0002\u000f9,Go^8sW&!!Q\u001fBx\u00051\u0019vnY6fiN+'O^3s\u0003%\nG\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[!oI\u001e+GOU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1 \u0016\u0005\u0005\u0013\u0014\t)A\u0015bYR,'O\u0011:pW\u0016\u0014\b*Z1mi\"\fe\u000eZ$fiJ+7\u000f]8og\u0016$C-\u001a4bk2$HEM\u0001*C2$XM\u001d\"s_.,'\u000fS3bYRD\u0017I\u001c3HKR\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000fJ\u001a\u0002S\u0005dG/\u001a:Ce>\\WM\u001d%fC2$\b.\u00118e\u000f\u0016$(+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00135\u0003%\nG\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f[!oI\u001e+GOU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u00111q\u0001\u0016\u0005\u0005/\u0014\t)A\u0015bYR,'O\u0011:pW\u0016\u0014\b*Z1mi\"\fe\u000eZ$fiJ+7\u000f]8og\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0007\u001bQCA!9\u0003\u0002\u0006I\u0013\r\u001c;fe\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5B]\u0012<U\r\u001e*fgB|gn]3%I\u00164\u0017-\u001e7uI]*\"aa\u0005+\t\t-(\u0011Q\u0001\fGJ,\u0017\r^3U_BL7\rF\u0004S\u00073\u0019\tca\t\t\r\rc\u0003\u0019AB\u000e!\u0011\u0011\tf!\b\n\t\r}!1\u000b\u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\u000772\u0002\r!a\u000f\t\u000f\r\u0015B\u00061\u0001\u0004(\u0005yAo\u001c9jG\u0006\u001b8/[4o[\u0016tG\u000fE\u0004\u0004*\rM\u0002n!\u000e\u000e\u0005\r-\"\u0002BB\u0017\u0007_\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\rEB+\u0001\u0006d_2dWm\u0019;j_:LAA!,\u0004,A)1\u0011FB\u001cQ&!1\u0011HB\u0016\u0005\u0011a\u0015n\u001d;\u0002\u0019\u0011,Wn\u001c;f\u0005J|7.\u001a:\u0015\u000bI\u001byd!\u0011\t\r\t%S\u00061\u0001i\u0011%\u0011).\fI\u0001\u0002\u0004\u00119.\u0001\feK6|G/\u001a\"s_.,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\\7pi\u0016\u0014%o\\6feR)!k!\u0013\u0004L!1!\u0011J\u0018A\u0002!D\u0011B!60!\u0003\u0005\rAa6\u0002/A\u0014x.\\8uK\n\u0013xn[3sI\u0011,g-Y;mi\u0012\u0012\u0014!\t<bY&$\u0017\r^3O_2+\u0017\rZ3sg>sG)Z7pi\u0016$'I]8lKJ\u001cH#\u0002*\u0004T\rU\u0003BB.2\u0001\u0004\tY\u0004C\u0004\u0004XE\u0002\ra!\u0017\u0002!\u0011,Wn\u001c;fI\n\u0013xn[3s\u0013\u0012\u001c\b#BA\u001f\u00077B\u0017\u0002BB/\u0003\u000f\u00121aU3u\u0003\u00192\u0018\r\\5eCR,G*Z1eKJ\u001c\bK]3tK:$xJ\u001c)s_6|G/\u001a3Ce>\\WM\u001d\u000b\u0006%\u000e\r4Q\r\u0005\u00077J\u0002\r!a\u000f\t\r\t%#\u00071\u0001i\u0003\t2\u0018\r\\5eCR,G*Z1eKJ\u001c\bK]3tK:$xJ\\!mY\n\u0013xn[3sgR)!ka\u001b\u0004n!11l\ra\u0001\u0003wAaaa\u001c4\u0001\u0004A\u0017a\u00048v[\n,'o\u00144Ce>\\WM]:\u0002\u001b\rDWmY6SKN\u0004xN\\:f)\u001d\u00116QOB?\u0007\u0017Cqaa\u001e5\u0001\u0004\u0019I(A\bfqB,7\r^3e%\u0016\u001cX\u000f\u001c;t!\u0019\tyaa\u001f\u0003\u0018%!1\u0011HA\u0012\u0011\u001d\u0019y\b\u000ea\u0001\u0007\u0003\u000ba\"Y2uk\u0006d'+Z:q_:\u001cX\r\u0005\u0004\u0002\u0010\rm41\u0011\t\u0005\u0007\u000b\u001b9)\u0004\u0002\u0003@%!1\u0011\u0012B \u0005u\tE\u000e^3s\u0005J|7.\u001a:IK\u0006dG\u000f\u001b*fgB|gn]3ECR\f\u0007bBBGi\u0001\u00071qR\u0001\nKJ\u0014xN]\"pI\u0016\u0004b!a\u0004\u0004|\t\u0005\bf\u0002\u0001\u0004\u0014\u000ee51\u0014\t\u0004k\u000eU\u0015bABLm\n\u0019A+Y4\u0002\u000bY\fG.^3\"\u0005\ru\u0015a\u00032bu\u0016d'h\u00199vuI\u0002")
public class BrokerHealthTest
extends BaseRequestTest {
    private CloudAdmin adminClient;
    private final String topicName;
    private final int p0;
    private final int p1;
    private final int p2;

    public CloudAdmin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(CloudAdmin x$1) {
        this.adminClient = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    public int p0() {
        return this.p0;
    }

    public int p1() {
        return this.p1;
    }

    public int p2() {
        return this.p2;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.isKRaftTest()) {
            this.brokers().foreach((Function1 & Serializable)broker -> (Void)((BrokerServer)broker).lifecycleManager().initialUnfenceFuture().get());
        }
        this.adminClient_$eq(this.createCloudAdminClient(this.createCloudAdminClient$default$1()));
        scala.collection.immutable.Map validAssignment = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p0())), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p1())), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p2())), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopic((Admin)this.adminClient(), this.topicName(), (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)p -> this.waitUntilLogCreatedOnBrokers(this.topicName(), p));
    }

    public scala.collection.immutable.Seq<KafkaConfig> generateConfigs() {
        return package$.MODULE$.Range().apply(0, this.brokerCount()).map((Function1 & Serializable)x$1 -> this.createConfig(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    private KafkaConfig createConfig(int nodeId) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.AlterBrokerHealthMaxDemotedBrokersPercentageProp(), "67");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDemotionsWithTopics(String quorum) {
        this.demoteBroker(0, false);
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        this.promoteBroker(0, false);
        this.validateLeadersPresentOnPromotedBroker(this.topicName(), 0);
        this.demoteBroker(0, false);
        this.demoteBroker(1, false);
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        this.demoteBroker(2, true);
        this.validateLeadersPresentOnAllBrokers(this.topicName(), 3);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testDemotionsWithControllerFailover(String quorum) {
        this.demoteBroker(0, false);
        KafkaServer controller = this.getController();
        controller.shutdown();
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        controller.startup();
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), controller.config().brokerId());
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft"})
    public void testDemotionsWithKRaftControllerFailover(String quorum) {
        this.demoteBroker(0, false);
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
        Integer prevPort = this.shutdownControllerServer();
        this.restartControllerServer(prevPort);
        TestUtils$.MODULE$.waitForOnlineController((Admin)this.adminClient());
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testControllerFailoverImmediatelyAfterDemoteBroker(String quorum) {
        this.killAllBrokers();
        scala.collection.immutable.Set degradedBrokerComponents = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id())}));
        this.zkClient().setBrokerHealthState((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)degradedBrokerComponents), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)degradedBrokerComponents)})));
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.adminClientConfig().put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers(this.servers(), this.listenerName()));
        this.adminClient_$eq(this.createCloudAdminClient(this.createCloudAdminClient$default$1()));
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 2);
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 1);
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$4(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerHealth(String quorum) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        ComponentHealthStatus x$5 = this.alterBrokerHealthAndGetResponse$default$4();
        short x$6 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$7 = this.alterBrokerHealthAndGetResponse$default$7();
        scala.collection.immutable.Seq x$8 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
        ComponentHealthStatus x$12 = this.alterBrokerHealthAndGetResponse$default$4();
        short x$13 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$14 = this.alterBrokerHealthAndGetResponse$default$7();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.STORAGE, this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.NETWORK, this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", BrokerComponent.STORAGE, x$5, true, x$6, x$7).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$8, "reason", BrokerComponent.NETWORK, x$12, true, x$13, x$14).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.NETWORK.id()))))})), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$15 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
        ComponentHealthStatus x$19 = this.alterBrokerHealthAndGetResponse$default$4();
        short x$20 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$21 = this.alterBrokerHealthAndGetResponse$default$7();
        scala.collection.immutable.Seq x$22 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        ComponentHealthStatus x$26 = this.alterBrokerHealthAndGetResponse$default$4();
        short x$27 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$28 = this.alterBrokerHealthAndGetResponse$default$7();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, this.createBrokerHealthStatusResult$default$2(), this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, this.createBrokerHealthStatusResult$default$2(), this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$15, "reason2", BrokerComponent.UNSPECIFIED, x$19, true, x$20, x$21).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$22, "reason2", BrokerComponent.UNSPECIFIED, x$26, true, x$27, x$28).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.NETWORK.id()), new DegradedBrokerComponent("reason2", BrokerComponent.UNSPECIFIED.id())}))).asJava())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new DegradedBroker(2, Collections.singleton(new DegradedBrokerComponent("reason2", BrokerComponent.UNSPECIFIED.id()))))})), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$29 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
        ComponentHealthStatus x$33 = this.alterBrokerHealthAndGetResponse$default$4();
        short x$34 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$35 = this.alterBrokerHealthAndGetResponse$default$7();
        scala.collection.immutable.Seq x$36 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        ComponentHealthStatus x$40 = this.alterBrokerHealthAndGetResponse$default$4();
        short x$41 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$42 = this.alterBrokerHealthAndGetResponse$default$7();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.STORAGE, this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, BrokerComponent.NETWORK, this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$29, "reason", BrokerComponent.STORAGE, x$33, true, x$34, x$35).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$36, "reason", BrokerComponent.NETWORK, x$40, true, x$41, x$42).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.NETWORK.id()), new DegradedBrokerComponent("reason2", BrokerComponent.UNSPECIFIED.id()), new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())}))).asJava())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new DegradedBroker(2, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason2", BrokerComponent.UNSPECIFIED.id()), new DegradedBrokerComponent("reason", BrokerComponent.NETWORK.id())}))).asJava()))})), this.getBrokerHealthMap());
        BrokerComponent x$45 = this.createBrokerHealthStatusResult$default$2();
        Errors x$46 = this.createBrokerHealthStatusResult$default$4();
        String x$47 = this.createBrokerHealthStatusResult$default$5();
        BrokerComponent x$50 = this.createBrokerHealthStatusResult$default$2();
        Errors x$51 = this.createBrokerHealthStatusResult$default$4();
        String x$52 = this.createBrokerHealthStatusResult$default$5();
        scala.collection.immutable.Seq x$53 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
        BrokerComponent x$56 = this.alterBrokerHealthAndGetResponse$default$3();
        boolean x$57 = this.alterBrokerHealthAndGetResponse$default$5();
        short x$58 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$59 = this.alterBrokerHealthAndGetResponse$default$7();
        scala.collection.immutable.Seq x$60 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        BrokerComponent x$63 = this.alterBrokerHealthAndGetResponse$default$3();
        boolean x$64 = this.alterBrokerHealthAndGetResponse$default$5();
        short x$65 = this.alterBrokerHealthAndGetResponse$default$6();
        SocketServer x$66 = this.alterBrokerHealthAndGetResponse$default$7();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, x$45, ComponentHealthStatus.HEALTHY, x$46, x$47), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, x$50, ComponentHealthStatus.HEALTHY, x$51, x$52), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$53, "reason2", x$56, ComponentHealthStatus.HEALTHY, x$57, x$58, x$59).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$60, "reason2", x$63, ComponentHealthStatus.HEALTHY, x$64, x$65, x$66).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.NETWORK.id()), new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())}))).asJava())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new DegradedBroker(2, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.NETWORK.id()))))})), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, BrokerComponent.NETWORK, ComponentHealthStatus.HEALTHY, this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, this.alterBrokerHealthAndGetResponse$default$5(), this.alterBrokerHealthAndGetResponse$default$6(), this.alterBrokerHealthAndGetResponse$default$7()).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}))), "reason", BrokerComponent.NETWORK, ComponentHealthStatus.HEALTHY, this.alterBrokerHealthAndGetResponse$default$5(), this.alterBrokerHealthAndGetResponse$default$6(), this.alterBrokerHealthAndGetResponse$default$7()).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.NETWORK.id()), new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())}))).asJava()))})), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.NETWORK, ComponentHealthStatus.HEALTHY, this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), "reason", BrokerComponent.NETWORK, ComponentHealthStatus.HEALTHY, this.alterBrokerHealthAndGetResponse$default$5(), this.alterBrokerHealthAndGetResponse$default$6(), this.alterBrokerHealthAndGetResponse$default$7()).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, this.alterBrokerHealthAndGetResponse$default$5(), this.alterBrokerHealthAndGetResponse$default$6(), this.alterBrokerHealthAndGetResponse$default$7()).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testAlterBrokerHealthOnUnregisteredBrokers(String quorum) {
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(3, BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new DegradedBroker(3, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id()))))})), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(3, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, Errors.NONE, ""), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3}))), "reason", BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft"})
    public void testKRaftAlterBrokerHealthOnUnregisteredBrokers(String quorum) {
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}));
        ComponentHealthStatus x$5 = ComponentHealthStatus.DEGRADED;
        short x$6 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$7 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)package$.MODULE$.List().empty(), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", BrokerComponent.STORAGE, x$5, true, x$6, x$7).data(), (List)Nil$.MODULE$), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.INVALID_REQUEST.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$8 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3}));
        String x$11 = "";
        boolean x$12 = false;
        short x$13 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$14 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)package$.MODULE$.List().empty(), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$8, x$11, BrokerComponent.STORAGE, ComponentHealthStatus.HEALTHY, x$12, x$13, x$14).data(), (List)Nil$.MODULE$), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.INVALID_REQUEST.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerHealthPropagatesHealthState(String quorum) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        ComponentHealthStatus x$5 = ComponentHealthStatus.DEGRADED;
        short x$6 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$7 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.STORAGE, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", BrokerComponent.STORAGE, x$5, true, x$6, x$7).data(), (List)Nil$.MODULE$), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.STORAGE.id()))))})), this.getBrokerHealthMap());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$testAlterBrokerHealthPropagatesHealthState$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Broker 0 should be degraded on all brokers.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDemotionsExceedsMaxBrokers(String quorum) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, this.alterBrokerHealthAndGetResponse$default$5(), ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), "reason", this.alterBrokerHealthAndGetResponse$default$3(), this.alterBrokerHealthAndGetResponse$default$4(), this.alterBrokerHealthAndGetResponse$default$5(), ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()))))})), this.getBrokerHealthMap());
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}));
        ComponentHealthStatus x$4 = this.alterBrokerHealthAndGetResponse$default$4();
        boolean x$5 = this.alterBrokerHealthAndGetResponse$default$5();
        short x$6 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$7 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)Nil$.MODULE$, (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", BrokerComponent.STORAGE, x$4, x$5, x$6, x$7).data(), (List)Nil$.MODULE$), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.DEMOTION_LIMIT_REACHED.code()}))));
        BrokerComponent x$10 = this.createBrokerHealthStatusResult$default$2();
        Errors x$11 = this.createBrokerHealthStatusResult$default$4();
        String x$12 = this.createBrokerHealthStatusResult$default$5();
        BrokerComponent x$15 = this.createBrokerHealthStatusResult$default$2();
        Errors x$16 = this.createBrokerHealthStatusResult$default$4();
        String x$17 = this.createBrokerHealthStatusResult$default$5();
        scala.collection.immutable.Seq x$18 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        BrokerComponent x$21 = this.alterBrokerHealthAndGetResponse$default$3();
        boolean x$22 = this.alterBrokerHealthAndGetResponse$default$5();
        short x$23 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$24 = this.adminSocketServer();
        scala.collection.immutable.Seq x$25 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
        BrokerComponent x$28 = this.alterBrokerHealthAndGetResponse$default$3();
        boolean x$29 = this.alterBrokerHealthAndGetResponse$default$5();
        short x$30 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$31 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, x$10, ComponentHealthStatus.HEALTHY, x$11, x$12), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, x$15, ComponentHealthStatus.HEALTHY, x$16, x$17), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$18, "reason", x$21, ComponentHealthStatus.HEALTHY, x$22, x$23, x$24).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$25, "reason", x$28, ComponentHealthStatus.HEALTHY, x$29, x$30, x$31).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)Nil$.MODULE$, (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), "reason", this.alterBrokerHealthAndGetResponse$default$3(), this.alterBrokerHealthAndGetResponse$default$4(), this.alterBrokerHealthAndGetResponse$default$5(), ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)Nil$.MODULE$), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.DEMOTION_LIMIT_REACHED.code()}))));
        scala.collection.immutable.Seq x$32 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        BrokerComponent x$35 = this.alterBrokerHealthAndGetResponse$default$3();
        ComponentHealthStatus x$36 = this.alterBrokerHealthAndGetResponse$default$4();
        boolean x$37 = this.alterBrokerHealthAndGetResponse$default$5();
        SocketServer x$38 = this.adminSocketServer();
        scala.collection.immutable.Seq x$39 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
        BrokerComponent x$42 = this.alterBrokerHealthAndGetResponse$default$3();
        ComponentHealthStatus x$43 = this.alterBrokerHealthAndGetResponse$default$4();
        boolean x$44 = this.alterBrokerHealthAndGetResponse$default$5();
        SocketServer x$45 = this.adminSocketServer();
        scala.collection.immutable.Seq x$46 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        BrokerComponent x$49 = this.alterBrokerHealthAndGetResponse$default$3();
        ComponentHealthStatus x$50 = this.alterBrokerHealthAndGetResponse$default$4();
        boolean x$51 = this.alterBrokerHealthAndGetResponse$default$5();
        SocketServer x$52 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, this.createBrokerHealthStatusResult$default$2(), this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, this.createBrokerHealthStatusResult$default$2(), this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(2, this.createBrokerHealthStatusResult$default$2(), this.createBrokerHealthStatusResult$default$3(), this.createBrokerHealthStatusResult$default$4(), this.createBrokerHealthStatusResult$default$5()), (List)Nil$.MODULE$))), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$32, "reason", x$35, x$36, x$37, (short)0, x$38).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$39, "reason", x$42, x$43, x$44, (short)0, x$45).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$46, "reason", x$49, x$50, x$51, (short)0, x$52).data(), (List)Nil$.MODULE$))), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code(), Errors.NONE.code()}))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDemotionsWhenTooFewLiveBrokers(String quorum) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getBrokerHealthMap());
        this.killBroker(1);
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)Nil$.MODULE$, (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)Nil$.MODULE$), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.DEMOTION_LIMIT_REACHED.code()}))));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerHealthIdempotence(String quorum) {
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)new .colon.colon((Object)this.createBrokerHealthStatusResult(1, BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, Errors.NONE, ""), (List)Nil$.MODULE$)), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), "reason", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data(), (List)Nil$.MODULE$)), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code(), Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new DegradedBroker(0, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()))))})), this.getBrokerHealthMap());
        BrokerComponent x$3 = BrokerComponent.UNSPECIFIED;
        Errors x$4 = Errors.NONE;
        String x$5 = "";
        scala.collection.immutable.Seq x$6 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        BrokerComponent x$9 = BrokerComponent.UNSPECIFIED;
        boolean x$10 = false;
        short x$11 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$12 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, x$3, ComponentHealthStatus.HEALTHY, x$4, x$5), (List)Nil$.MODULE$), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$6, "reason", x$9, ComponentHealthStatus.HEALTHY, x$10, x$11, x$12).data(), (List)Nil$.MODULE$), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code()}))));
        BrokerComponent x$15 = BrokerComponent.UNSPECIFIED;
        Errors x$16 = Errors.NONE;
        String x$17 = "";
        scala.collection.immutable.Seq x$18 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        BrokerComponent x$21 = BrokerComponent.UNSPECIFIED;
        boolean x$22 = false;
        short x$23 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        SocketServer x$24 = this.adminSocketServer();
        this.checkResponse((List<AlterBrokerHealthResponseData.BrokerHealthStatusResult>)new .colon.colon((Object)this.createBrokerHealthStatusResult(0, x$15, ComponentHealthStatus.HEALTHY, x$16, x$17), (List)Nil$.MODULE$), (List<AlterBrokerHealthResponseData>)new .colon.colon((Object)this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$18, "reason", x$21, ComponentHealthStatus.HEALTHY, x$22, x$23, x$24).data(), (List)Nil$.MODULE$), (List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Errors.NONE.code()}))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new DegradedBroker(1, Collections.singleton(new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()))))})), this.getBrokerHealthMap());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testAlterBrokerHealthHandlesNotControllerException(String quorum) {
        scala.collection.immutable.Seq x$1 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        SocketServer x$3 = this.notControllerSocketServer();
        BrokerComponent x$4 = BrokerComponent.UNSPECIFIED;
        ComponentHealthStatus x$5 = ComponentHealthStatus.DEGRADED;
        boolean x$6 = false;
        short x$7 = ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
        AlterBrokerHealthResponse response = this.alterBrokerHealthAndGetResponse((scala.collection.immutable.Seq<Object>)x$1, "reason", x$4, x$5, x$6, x$7, x$3);
        Assertions.assertEquals((short)Errors.NOT_CONTROLLER.code(), (short)response.data().errorCode());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerHealthHandlesInvalidRequestException(String quorum) {
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)this.alterBrokerHealthAndGetResponse(this.alterBrokerHealthAndGetResponse$default$1(), "", BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, false, ApiKeys.ALTER_BROKER_HEALTH.latestVersion(), this.adminSocketServer()).data().errorCode());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testDescribeBrokerHealthHandlesNotControllerException(String quorum) {
        DescribeBrokerHealthRequest request = (DescribeBrokerHealthRequest)new DescribeBrokerHealthRequest.Builder().build();
        DescribeBrokerHealthResponse response = (DescribeBrokerHealthResponse)this.connectAndReceive((AbstractRequest)request, this.notControllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)Errors.NOT_CONTROLLER.code(), (short)response.data().errorCode());
    }

    private AlterBrokerHealthResponseData.BrokerHealthStatusResult createBrokerHealthStatusResult(int brokerId, BrokerComponent component, ComponentHealthStatus healthStatus, Errors error, String errorMsg) {
        String string;
        String string2 = errorMsg;
        String string3 = "";
        if (string2 == null || !string2.equals(string3)) {
            string = errorMsg;
        } else {
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            string = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? "" : error.message();
        }
        String msg = string;
        return new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId(brokerId).setComponentCode(component.id()).setStatusCode(healthStatus.id()).setErrorCode(error.code()).setErrorMessage(Optional.ofNullable(msg).orElse(""));
    }

    private BrokerComponent createBrokerHealthStatusResult$default$2() {
        return BrokerComponent.UNSPECIFIED;
    }

    private ComponentHealthStatus createBrokerHealthStatusResult$default$3() {
        return ComponentHealthStatus.DEGRADED;
    }

    private Errors createBrokerHealthStatusResult$default$4() {
        return Errors.NONE;
    }

    private String createBrokerHealthStatusResult$default$5() {
        return "";
    }

    private scala.collection.immutable.Map<Object, DegradedBroker> getBrokerHealthMap() {
        DescribeBrokerHealthRequest request = (DescribeBrokerHealthRequest)new DescribeBrokerHealthRequest.Builder().build();
        DescribeBrokerHealthResponse response = (DescribeBrokerHealthResponse)this.connectAndReceive((AbstractRequest)request, this.adminSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        response.data().degradedBrokers().forEach(degradedBroker -> result.put((Object)BoxesRunTime.boxToInteger((int)degradedBroker.brokerId()), (Object)new DegradedBroker(degradedBroker.brokerId(), CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(degradedBroker.degradedBrokerComponents()).asScala().map((Function1 & Serializable)degradedBrokerComponent -> new DegradedBrokerComponent(degradedBrokerComponent.reason(), degradedBrokerComponent.componentCode()))).toSet()).asJava())));
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private AlterBrokerHealthResponse alterBrokerHealthAndGetResponse(scala.collection.immutable.Seq<Object> brokerIds, String reason, BrokerComponent component, ComponentHealthStatus healthStatus, boolean force, short version, SocketServer socketServer) {
        AlterBrokerHealthRequest request = new AlterBrokerHealthRequest.Builder(new AlterBrokerHealthRequestData().setBrokerIds(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokerIds.map((Function1 & Serializable)x -> BoxesRunTime.unboxToInt((Object)x))).asJava()).setReason(reason).setComponentCode(component.id()).setStatusCode(healthStatus.id()).setForce(force)).build(version);
        return (AlterBrokerHealthResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterBrokerHealthResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private scala.collection.immutable.Seq<Object> alterBrokerHealthAndGetResponse$default$1() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private String alterBrokerHealthAndGetResponse$default$2() {
        return "";
    }

    private BrokerComponent alterBrokerHealthAndGetResponse$default$3() {
        return BrokerComponent.UNSPECIFIED;
    }

    private ComponentHealthStatus alterBrokerHealthAndGetResponse$default$4() {
        return ComponentHealthStatus.DEGRADED;
    }

    private boolean alterBrokerHealthAndGetResponse$default$5() {
        return false;
    }

    private short alterBrokerHealthAndGetResponse$default$6() {
        return ApiKeys.ALTER_BROKER_HEALTH.latestVersion();
    }

    private SocketServer alterBrokerHealthAndGetResponse$default$7() {
        return this.adminSocketServer();
    }

    private void createTopic(Admin adminClient, String topicName, scala.collection.immutable.Map<Object, List<Object>> topicAssignment) {
        java.util.Map replicasAssignments = CollectionConverters$.MODULE$.MapHasAsJava((Map)topicAssignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = x0$1._1$mcI$sp();
                List value = (List)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)value.map((Function1 & Serializable)x -> BrokerHealthTest.$anonfun$createTopic$2(BoxesRunTime.unboxToInt((Object)x)))).asJava());
            }
            throw new MatchError(null);
        })).asJava();
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, replicasAssignments))).all().get();
    }

    private void demoteBroker(int brokerId, boolean force) {
        this.adminClient().alterBrokerHealth(new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)brokerId)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.DEGRADED, "testing", force), new AlterBrokerHealthOptions()).all().get();
    }

    private boolean demoteBroker$default$2() {
        return false;
    }

    private void promoteBroker(int brokerId, boolean force) {
        this.adminClient().alterBrokerHealth(new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)brokerId)}))).asJava(), BrokerComponent.UNSPECIFIED, ComponentHealthStatus.HEALTHY, "testing", force), new AlterBrokerHealthOptions()).all().get();
    }

    private boolean promoteBroker$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void validateNoLeadersOnDemotedBrokers(String topicName, scala.collection.immutable.Set<Object> demotedBrokerIds) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$validateNoLeadersOnDemotedBrokers$1(this, topicName, demotedBrokerIds)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthTest.$anonfun$validateNoLeadersOnDemotedBrokers$4(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateLeadersPresentOnPromotedBroker(String topicName, int brokerId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$validateLeadersPresentOnPromotedBroker$1(this, topicName, brokerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthTest.$anonfun$validateLeadersPresentOnPromotedBroker$4(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateLeadersPresentOnAllBrokers(String topicName, int numberOfBrokers) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthTest.$anonfun$validateLeadersPresentOnAllBrokers$1(this, topicName, numberOfBrokers)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthTest.$anonfun$validateLeadersPresentOnAllBrokers$3(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void checkResponse(List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> expectedResults, List<AlterBrokerHealthResponseData> actualResponse, List<Object> errorCode) {
        actualResponse.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((short)BoxesRunTime.unboxToShort((Object)errorCode.apply(i)), (short)((AlterBrokerHealthResponseData)actualResponse.apply(i)).errorCode()));
        expectedResults.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)expectedResults.apply(i), ((AlterBrokerHealthResponseData)actualResponse.apply(i)).brokerHealthStatusResults().get(0)));
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$2(TopicPartitionInfo p) {
        return p.leader().id() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$1(BrokerHealthTest $this) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList($this.topicName())).topicNameValues().get($this.topicName())).get();
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$2(p)))).reduce((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$4(BrokerHealthTest $this) {
        return new StringBuilder(45).append("Topic ").append($this.topicName()).append(" does not have all leaders on broker 2.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthPropagatesHealthState$2(KafkaBroker x$2) {
        return x$2.metadataCache().isBrokerDegraded(0);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthPropagatesHealthState$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterBrokerHealthPropagatesHealthState$1(BrokerHealthTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.brokers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$testAlterBrokerHealthPropagatesHealthState$2(x$2)))).reduce((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$testAlterBrokerHealthPropagatesHealthState$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$testAlterBrokerHealthPropagatesHealthState$4() {
        return "Broker 0 should be degraded on all brokers.";
    }

    public static final /* synthetic */ Integer $anonfun$createTopic$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$2(scala.collection.immutable.Set demotedBrokerIds$1, TopicPartitionInfo p) {
        return !demotedBrokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)p.leader().id()));
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$1(BrokerHealthTest $this, String topicName$1, scala.collection.immutable.Set demotedBrokerIds$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$1)).topicNameValues().get(topicName$1)).get();
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$validateNoLeadersOnDemotedBrokers$2(demotedBrokerIds$1, p)))).reduce((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$validateNoLeadersOnDemotedBrokers$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$validateNoLeadersOnDemotedBrokers$4(String topicName$1) {
        return new StringBuilder(38).append("Topic ").append(topicName$1).append(" has a demoted broker as leader.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$2(int brokerId$1, TopicPartitionInfo p) {
        return p.leader().id() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$3(boolean x, boolean y) {
        return x || y;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$1(BrokerHealthTest $this, String topicName$2, int brokerId$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$2)).topicNameValues().get(topicName$2)).get();
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$validateLeadersPresentOnPromotedBroker$2(brokerId$1, p)))).reduce((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthTest.$anonfun$validateLeadersPresentOnPromotedBroker$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$validateLeadersPresentOnPromotedBroker$4(String topicName$2) {
        return new StringBuilder(41).append("Topic ").append(topicName$2).append(" has no leaders on promoted broker.").toString();
    }

    public static final /* synthetic */ int $anonfun$validateLeadersPresentOnAllBrokers$2(TopicPartitionInfo p) {
        return p.leader().id();
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnAllBrokers$1(BrokerHealthTest $this, String topicName$3, int numberOfBrokers$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$3)).topicNameValues().get(topicName$3)).get();
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)BrokerHealthTest.$anonfun$validateLeadersPresentOnAllBrokers$2(p)))).toSet().size() == numberOfBrokers$1;
    }

    public static final /* synthetic */ String $anonfun$validateLeadersPresentOnAllBrokers$3(String topicName$3) {
        return new StringBuilder(44).append("Topic ").append(topicName$3).append(" does not have leaders on all brokers.").toString();
    }

    public BrokerHealthTest() {
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.AlterBrokerHealthMaxDemotedBrokersPercentageProp(), "67");
        this.adminClient = null;
        this.topicName = "topic";
        this.p0 = 0;
        this.p1 = 1;
        this.p2 = 2;
    }
}

