/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.server.BrokerLifecycleManager;
import kafka.server.KafkaConfig$;
import kafka.server.RegistrationTestContext;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@Timeout(value=12L)
@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0007\u000f\u0001MAQA\u0007\u0001\u0005\u0002mAQA\b\u0001\u0005\u0002}AQ\u0001\u000b\u0001\u0005\u0002%BQA\u000f\u0001\u0005\u0002%BQ\u0001\u0010\u0001\u0005\u0002%BQA\u0010\u0001\u0005\u0002%BQ\u0001\u0011\u0001\u0005\u0002%BQA\u0011\u0001\u0005\u0002\rCQ\u0001\u001b\u0001\u0005\u0002%DQa\u001f\u0001\u0005\u0002%Ba!a\u0002\u0001\t\u0003I\u0003BBA\u0006\u0001\u0011\u0005\u0011F\u0001\u000eCe>\\WM\u001d'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0010!\u000511/\u001a:wKJT\u0011!E\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u00039\t\u0001cY8oM&<\u0007K]8qKJ$\u0018.Z:\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0006Qe>\u0004XM\u001d;jKN\f!\u0003^3ti\u000e\u0013X-\u0019;f\u0003:$7\t\\8tKR\t!\u0006\u0005\u0002\u0016W%\u0011AF\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0004]A\u0011q\u0006O\u0007\u0002a)\u0011\u0011GM\u0001\u0004CBL'BA\u001a5\u0003\u001dQW\u000f]5uKJT!!\u000e\u001c\u0002\u000b),h.\u001b;\u000b\u0003]\n1a\u001c:h\u0013\tI\u0004G\u0001\u0003UKN$\u0018a\u0006;fgR\u001c%/Z1uKN#\u0018M\u001d;B]\u0012\u001cEn\\:fQ\t!a&\u0001\u000euKN$8+^2dKN\u001ch-\u001e7SK\u001eL7\u000f\u001e:bi&|g\u000e\u000b\u0002\u0006]\u00059B/Z:u%\u0016<\u0017n\u001d;sCRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0003\r9\na\u0003^3ti\u000e{g\u000e\u001e:pY2,Gm\u00155vi\u0012|wO\u001c\u0015\u0003\u000f9\nq\u0002\u001d:fa\u0006\u0014XMU3ta>t7/Z\u000b\u0003\t6#2!\u00120d!\r1\u0015jS\u0007\u0002\u000f*\u0011\u0001JI\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001&H\u0005\u00191U\u000f^;sKB\u0011A*\u0014\u0007\u0001\t\u0015q\u0005B1\u0001P\u0005\u0005!\u0016C\u0001)T!\t)\u0012+\u0003\u0002S-\t9aj\u001c;iS:<\u0007C\u0001+]\u001b\u0005)&B\u0001,X\u0003!\u0011X-];fgR\u001c(B\u0001-Z\u0003\u0019\u0019w.\\7p]*\u0011\u0011C\u0017\u0006\u00037Z\na!\u00199bG\",\u0017BA/V\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\"B0\t\u0001\u0004\u0001\u0017aA2uqB\u0011Q$Y\u0005\u0003E:\u0011qCU3hSN$(/\u0019;j_:$Vm\u001d;D_:$X\r\u001f;\t\u000b\u0011D\u0001\u0019A3\u0002\u0011I,7\u000f]8og\u0016\u0004\"\u0001\u00164\n\u0005\u001d,&\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0003\u0011\u0001x\u000e\u001c7\u0016\u0005)dG\u0003B6rgb\u0004\"\u0001\u00147\u0005\u000b9K!\u0019A7\u0012\u0005As\u0007CA\u000bp\u0013\t\u0001hCA\u0002B]fDQA]\u0005A\u0002\u0001\fqaY8oi\u0016DH\u000fC\u0003u\u0013\u0001\u0007Q/A\u0004nC:\fw-\u001a:\u0011\u0005u1\u0018BA<\u000f\u0005Y\u0011%o\\6fe2Kg-Z2zG2,W*\u00198bO\u0016\u0014\b\"B=\n\u0001\u0004Q\u0018A\u00024viV\u0014X\rE\u0002G\u0013.\fQ\u0005^3ti\u0006cw/Y=t'\u0016tGm]!dGVlW\u000f\\1uK\u0012|eM\u001a7j]\u0016$\u0015N]:)\r)i\u0018\u0011AA\u0002!\tyc0\u0003\u0002\u0000a\t9A+[7f_V$\u0018!\u0002<bYV,g$\u0001=)\u0005)q\u0013\u0001\b;fgR\u0014VmZ5tiJ\fG/[8o\u0013:\u001cG.\u001e3fg\u0012K'o\u001d\u0015\u0003\u00179\nq\u0005^3ti.\u0013\u0018M\u001a;K\u0005>#U*\u001a;bI\u0006$\u0018MV3sg&|g.\u00169eCR,WI^3oi\"\u0012AB\f\u0015\u0007\u0001u\f\t!!\u0005\u001f\u00031\u0001")
public class BrokerLifecycleManagerTest {
    public Properties configProperties() {
        Properties properties = new Properties();
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), "/tmp/foo");
        properties.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        properties.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9093");
        properties.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        properties.setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "300000");
        properties.setProperty(KafkaConfig$.MODULE$.BrokerHeartbeatIntervalMsProp(), "100");
        return properties;
    }

    @Test
    public void testCreateAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-and-close-", false, () -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"oFoTeS9QT0aAyCyH41v45A")}))).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateStartAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-start-and-close-", false, () -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"uiUADXZWTPixVvp6UWFWnw")})));
        Assertions.assertEquals((Object)BrokerState.NOT_RUNNING, (Object)manager.state());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testCreateStartAndClose$3(manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var3_4 = null;
        Object var8_8 = null;
        manager.close();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager.state());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulRegistration() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "successful-registration-", false, () -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$3(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var16_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_10 = null;
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var17_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_12 = null;
        Object var15_16 = null;
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegistrationTimeout() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        Node controllerNode = new Node(3000, "localhost", 8021);
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "registration-timeout-", false, () -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"9XBOAtr4T0Wbx2sbiWh6xg")})));
        context.controllerNodeProvider().node().set(controllerNode);
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        Assertions.assertEquals((int)1, (int)context.mockClient().futureResponses().size());
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$3(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var22_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_10 = null;
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        long l3 = 60000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var23_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_12 = null;
        Object var15_16 = null;
        context.time().sleep(300000L);
        long l5 = 60000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$5(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    Object var24_24 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += package$.MODULE$.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var16_19 = null;
        Object var21_23 = null;
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "controlled-shutdown-", false, () -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"B4RtUz1ySGip3A7ZFYB2dg")})));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsCaughtUp(true)), controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$3(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var28_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_9 = null;
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsFenced(false)), controllerNode);
        context.time().sleep(20L);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var29_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_12 = null;
        Object var15_16 = null;
        manager.beginControlledShutdown();
        long l5 = 10000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$5(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    Object var30_24 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += package$.MODULE$.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var16_19 = null;
        Object var21_23 = null;
        context.mockClient().respond(body -> {
            if (body instanceof BrokerHeartbeatRequest) {
                Assertions.assertTrue((boolean)((BrokerHeartbeatRequest)body).data().wantShutDown());
                return true;
            }
            return false;
        }, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setShouldShutDown(true)));
        long l7 = 10000L;
        TestUtils$ retry_this4 = TestUtils$.MODULE$;
        long l8 = 1L;
        long retry_startTime4 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$7(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime4 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this4.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l8).append(", and then retrying.").toString();
                    Object var31_31 = null;
                    retry_this4.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this4, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l8);
                l8 += package$.MODULE$.min(l8, 1000L);
                continue;
            }
            break;
        }
        Object var22_26 = null;
        Object var27_30 = null;
        manager.controlledShutdownFuture().get();
        manager.close();
    }

    public <T extends AbstractRequest> Future<T> prepareResponse(RegistrationTestContext ctx, AbstractResponse response) {
        CompletableFuture result = new CompletableFuture();
        ctx.mockClient().prepareResponseFrom(body -> result.complete(body), response, ctx.controllerNodeProvider().node().get());
        return result;
    }

    public <T> T poll(RegistrationTestContext context, BrokerLifecycleManager manager, Future<T> future) {
        while (!future.isDone() || context.mockClient().hasInFlightRequests()) {
            context.poll();
            manager.eventQueue().wakeup();
            context.time().sleep(5L);
        }
        return future.get();
    }

    @Timeout(value=120L)
    @Test
    public void testAlwaysSendsAccumulatedOfflineDirs() {
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "offline-dirs-sent-in-heartbeat-", false, () -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"0IbF1sjhSGG6FNvnrPbqQg")})));
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        this.poll(ctx, manager, registration);
        manager.propagateDirectoryFailure(Uuid.fromString((String)"h3sC4Yk-Q9-fd0ntJTocCA"));
        manager.propagateDirectoryFailure(Uuid.fromString((String)"ej8Q9_d2Ri6FXNiTxKFiow"));
        manager.propagateDirectoryFailure(Uuid.fromString((String)"1iF76HVNRPqC7Y4r6647eg"));
        BrokerHeartbeatRequest latestHeartbeat = (BrokerHeartbeatRequest)((IterableOps)((IterableOps)scala.package$.MODULE$.Seq().fill(10, (Function0 & Serializable)() -> this.prepareResponse(ctx, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData())))).map((Function1 & Serializable)x$1 -> (BrokerHeartbeatRequest)this.poll(ctx, manager, (Future)x$1))).last();
        Assertions.assertEquals((Object)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA", "ej8Q9_d2Ri6FXNiTxKFiow", "1iF76HVNRPqC7Y4r6647eg"}))).map((Function1 & Serializable)x$1 -> Uuid.fromString((String)x$1)), (Object)CollectionConverters$.MODULE$.ListHasAsScala(latestHeartbeat.data().offlineLogDirs()).asScala().toSet());
        manager.close();
    }

    @Test
    public void testRegistrationIncludesDirs() {
        Set logDirs = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ad5FLIeCTnaQdai5vOjeng", "ybdzUKmYSLK6oiIpI6CPlw"}))).map((Function1 & Serializable)x$1 -> Uuid.fromString((String)x$1));
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "registration-includes-dirs-", false, () -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY, logDirs);
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        BrokerRegistrationRequest request = (BrokerRegistrationRequest)this.poll(ctx, manager, registration);
        Assertions.assertEquals((Object)logDirs, (Object)CollectionConverters$.MODULE$.ListHasAsScala(request.data().logDirs()).asScala().toSet());
        manager.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKraftJBODMetadataVersionUpdateEvent() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        BrokerLifecycleManager manager = new BrokerLifecycleManager(context.config(), (Time)context.time(), "successful-registration-", false, () -> MetadataEncryptorFactory.NO_ENCRYPTION_FACTORY, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        manager.start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testKraftJBODMetadataVersionUpdateEvent$3(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var22_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_5 = null;
        Object var9_10 = null;
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testKraftJBODMetadataVersionUpdateEvent$4(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    Object var23_17 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var10_12 = null;
        Object var15_16 = null;
        manager.resendBrokerRegistrationUnlessZkMode();
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1200L)), controllerNode);
        long l5 = 60000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        long l6 = 1L;
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testKraftJBODMetadataVersionUpdateEvent$5(context, manager);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l6).append(", and then retrying.").toString();
                    Object var24_24 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l6);
                l6 += package$.MODULE$.min(l6, 1000L);
                continue;
            }
            break;
        }
        Object var16_19 = null;
        Object var21_23 = null;
        manager.close();
    }

    public static final /* synthetic */ void $anonfun$testCreateStartAndClose$3(BrokerLifecycleManager manager$1) {
        Assertions.assertEquals((Object)BrokerState.STARTING, (Object)manager$1.state());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$3(RegistrationTestContext context$2) {
        Assertions.assertEquals((int)1, (int)context$2.mockChannelManager().unsentQueue().size());
        Assertions.assertEquals((long)10L, (long)((BrokerRegistrationRequest)context$2.mockChannelManager().unsentQueue().getFirst().request().build()).data().previousBrokerEpoch());
        Assertions.assertNull((Object)((BrokerRegistrationRequest)context$2.mockChannelManager().unsentQueue().getFirst().request().build()).data().metadataEncryptors());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$4(RegistrationTestContext context$2, BrokerLifecycleManager manager$2) {
        context$2.poll();
        Assertions.assertEquals((long)1000L, (long)manager$2.brokerEpoch());
    }

    private static final void newDuplicateRegistrationResponse$1(RegistrationTestContext context$3, Node controllerNode$1) {
        context$3.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setErrorCode(Errors.DUPLICATE_BROKER_REGISTRATION.code())), controllerNode$1);
        context$3.mockChannelManager().poll();
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$3(RegistrationTestContext context$3) {
        context$3.poll();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$4(RegistrationTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.time().sleep(100L);
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$5(RegistrationTestContext context$3, BrokerLifecycleManager manager$3) {
        context$3.poll();
        manager$3.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$3.state());
        Assertions.assertTrue((boolean)manager$3.initialCatchUpFuture().isCompletedExceptionally());
        Assertions.assertEquals((long)-1L, (long)manager$3.brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$3(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RECOVERY, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$4(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$5(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.PENDING_CONTROLLED_SHUTDOWN, (Object)manager$4.state());
        Assertions.assertTrue((boolean)context$4.mockClient().hasInFlightRequests());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$7(RegistrationTestContext context$4, BrokerLifecycleManager manager$4) {
        context$4.poll();
        manager$4.eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)manager$4.state());
    }

    public static final /* synthetic */ void $anonfun$testKraftJBODMetadataVersionUpdateEvent$3(RegistrationTestContext context$5) {
        Assertions.assertEquals((int)1, (int)context$5.mockChannelManager().unsentQueue().size());
        Assertions.assertEquals((long)10L, (long)((BrokerRegistrationRequest)context$5.mockChannelManager().unsentQueue().getFirst().request().build()).data().previousBrokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testKraftJBODMetadataVersionUpdateEvent$4(RegistrationTestContext context$5, BrokerLifecycleManager manager$6) {
        context$5.poll();
        Assertions.assertEquals((long)1000L, (long)manager$6.brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testKraftJBODMetadataVersionUpdateEvent$5(RegistrationTestContext context$5, BrokerLifecycleManager manager$6) {
        context$5.time().sleep(100L);
        context$5.poll();
        manager$6.eventQueue().wakeup();
        Assertions.assertEquals((long)1200L, (long)manager$6.brokerEpoch());
    }
}

