/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.NodeToControllerChannelManagerImpl;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120L)
@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\tMa\u0001\u0002\u0007\u000e\u0001IAQ!\u0007\u0001\u0005\u0002iAQ!\b\u0001\u0005\u0002yAQ!\r\u0001\u0005\u0002IBQa\u0017\u0001\u0005\u0002qC\u0011\"a\u0006\u0001#\u0003%\t!!\u0007\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!a0\u0001\t\u0003\t\tMA\u000fCe>\\WM\u001d*fO&\u001cHO]1uS>t'+Z9vKN$H+Z:u\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!D\u0001!EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0006\u0002 SA\u0011\u0001eJ\u0007\u0002C)\u0011aB\t\u0006\u0003!\rR!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001&\t\u0002\u001f\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJDQA\u000b\u0002A\u0002-\nqb\u00197vgR,'/\u00138ti\u0006t7-\u001a\t\u0003Y=j\u0011!\f\u0006\u0003]=\tA\u0001^3ti&\u0011\u0001'\f\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u0006q1/\u001a8e\u0003:$'+Z2fSZ,WcA\u001aQmQ!A\u0007\u0012$W!\t)d\u0007\u0004\u0001\u0005\u000b]\u001a!\u0019\u0001\u001d\u0003\u0003I\u000b\"!\u000f\u001f\u0011\u0005QQ\u0014BA\u001e\u0016\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u0011I,\u0017/^3tiNT!!\u0011\u0012\u0002\r\r|W.\\8o\u0013\t\u0019eH\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\")Qi\u0001a\u0001?\u0005q1\r[1o]\u0016dW*\u00198bO\u0016\u0014\b\"B$\u0004\u0001\u0004A\u0015A\u0003:fc\n+\u0018\u000e\u001c3feB\u0019\u0011\nT(\u000f\u0005uR\u0015BA&?\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018BA'O\u0005\u001d\u0011U/\u001b7eKJT!a\u0013 \u0011\u0005U\u0002F!B)\u0004\u0005\u0004\u0011&!\u0001+\u0012\u0005e\u001a\u0006CA\u001fU\u0013\t)fHA\bBEN$(/Y2u%\u0016\fX/Z:u\u0011\u001596\u00011\u0001Y\u0003%!\u0018.\\3pkRl5\u000f\u0005\u0002\u00153&\u0011!,\u0006\u0002\u0004\u0013:$\u0018A\u0004:fO&\u001cH/\u001a:Ce>\\WM\u001d\u000b\t;\u000e$\u0017o]>\u0002\u000eA\u0011a,Y\u0007\u0002?*\u0011\u0001\rQ\u0001\taJ|Go\\2pY&\u0011!m\u0018\u0002\u0007\u000bJ\u0014xN]:\t\u000b\u0015#\u0001\u0019A\u0010\t\u000b\u0015$\u0001\u0019\u00014\u0002\u0013\rdWo\u001d;fe&#\u0007CA4o\u001d\tAG\u000e\u0005\u0002j+5\t!N\u0003\u0002l#\u00051AH]8pizJ!!\\\u000b\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[VAQA\u001d\u0003A\u0002a\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\u0006i\u0012\u0001\r!^\u0001\bu.,\u0005o\\2i!\r!b\u000f_\u0005\u0003oV\u0011aa\u00149uS>t\u0007C\u0001\u000bz\u0013\tQXC\u0001\u0003M_:<\u0007\"\u0002?\u0005\u0001\u0004i\u0018!C5caR{7+\u001a8e!\r!bO \t\u0007)}\f\u0019!a\u0001\n\u0007\u0005\u0005QC\u0001\u0004UkBdWM\r\t\u0005\u0003\u000b\tI!\u0004\u0002\u0002\b)\u0011\u0011)I\u0005\u0005\u0003\u0017\t9AA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0011%\ty\u0001\u0002I\u0001\u0002\u0004\t\t\"A\tvg\u0016\f\u0005/Y2iKZ+'o]5p]N\u00042\u0001FA\n\u0013\r\t)\"\u0006\u0002\b\u0005>|G.Z1o\u0003a\u0011XmZ5ti\u0016\u0014(I]8lKJ$C-\u001a4bk2$HEN\u000b\u0003\u00037QC!!\u0005\u0002\u001e-\u0012\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003%)hn\u00195fG.,GMC\u0002\u0002*U\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti#a\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000fF\u0003^\u0003g\t)\u0004C\u0003F\r\u0001\u0007q\u0004\u0003\u0004\u00028\u0019\u0001\rAZ\u0001\ni>\u0004\u0018n\u0019(b[\u0016\f\u0001\b^3tiJ+w-[:uKJT6nV5uQ.\u0013\u0016M\u001a;NS\u001e\u0014\u0018\r^5p]\u0016s\u0017M\u00197fI^KG\u000f[!qC\u000eDWMV3sg&|g\u000e\u0006\u0003\u0002>\u0005\r\u0003c\u0001\u000b\u0002@%\u0019\u0011\u0011I\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\u001d\u0001\ra\u000b\u0015\u001c\u000f\u0005\u001d\u0013\u0011KA*\u0003;\ny&!\u0019\u0002`\u0005\r\u0014QMA8\u0003c\nY(! \u0011\t\u0005%\u0013QJ\u0007\u0003\u0003\u0017R1!!\u000b.\u0013\u0011\ty%a\u0013\u0003\u0017\rcWo\u001d;feR+7\u000f^\u0001\fG2,8\u000f^3s)f\u0004X\r\n\u0002\u0002V%!\u0011qKA-\u0003\u0015Y%+\u0011$U\u0015\u0011\tY&a\u0013\u0002\tQK\b/Z\u0001\bEJ|7.\u001a:t;\u0005\t\u0011aC2p]R\u0014x\u000e\u001c7feN\fq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\u0013\u0003\u0003OJA!!\u001b\u0002l\u0005Y\u0011J\u0011)`g}#t,\u0013,1\u0015\u0011\ti'a\u0002\u0002\u001f5+G/\u00193bi\u00064VM]:j_:\f\u0011\"Y;u_N#\u0018M\u001d;%\u0005\u0005M\u0014\u0002BA;\u0003o\n!AT(\u000b\t\u0005e\u00141J\u0001\n\u0003V$xn\u0015;beR\f\u0001c]3sm\u0016\u0014\bK]8qKJ$\u0018.Z:-\u0005\u0005}4FCAA\u0003\u000f\u000bI)!$\u0002\u0010B!\u0011\u0011JAB\u0013\u0011\t))a\u0013\u0003+\rcWo\u001d;fe\u000e{gNZ5h!J|\u0007/\u001a:us\u0006\u00191.Z=\"\u0005\u0005-\u0015a\t>p_.,W\r]3s]5,G/\u00193bi\u0006tS.[4sCRLwN\u001c\u0018f]\u0006\u0014G.Z\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003#\u000bA\u0001\u001e:vK\u0006AC/Z:u%\u0016<\u0017n\u001d;fej[w+\u001b;i\u0017J\u000bg\r^'jOJ\fG/[8o\t&\u001c\u0018M\u00197fIR!\u0011QHAL\u0011\u0015Q\u0003\u00021\u0001,Q]A\u0011qIA)\u0003'\ni&a'\u0002b\u0005}\u00131MA3\u0003w\ni*H\u0001\u0001Y\t\tyj\u000b\u0006\u0002\u0002\u0006\u001d\u0015\u0011RAG\u0003C\u000b#!a)\u0002\u000b\u0019\fGn]3\u0002=Q,7\u000f\u001e*fO&\u001cH/\u001a:[W^KG\u000f[\u001a4\u0007>tGO]8mY\u0016\u0014H\u0003BA\u001f\u0003SCQAK\u0005A\u0002-Bs#CA$\u0003#\n\u0019&!\u0018\u0002\u001c\u0006\u0005\u0014qLA2\u0003[\u000bY(a-%\u0005\u0005=\u0016\u0002BAY\u0003W\n1\"\u0013\"Q?Nz6gX%Wg1\u0012\u0011qT\u0001(i\u0016\u001cHOU3hSN$XM\u001d.l/&$\bn\u0013*bMRl\u0015n\u001a:bi&|g.\u00128bE2,G\r\u0006\u0003\u0002>\u0005e\u0006\"\u0002\u0016\u000b\u0001\u0004Y\u0003f\u0007\u0006\u0002H\u0005E\u00131KA/\u0003?\n\t'a\u0018\u0002d\u0005\u0015\u0014qNA9\u0003w\ni\f\f\u0002\u0002\u0000\u00059C/Z:u\u001d>lU\r^1eCR\f7\t[1oO\u0016\u001c\u0018J\u001c)sK6KwM]1uS>tWj\u001c3f)\u0011\ti$a1\t\u000b)Z\u0001\u0019A\u0016)\u000f-\t9-!$\u0002NB!\u0011\u0011JAe\u0013\u0011\tY-a\u0013\u0003\u0019\rcWo\u001d;feR+7\u000f^:-\u0005\u0005=7FFA$\u0003#\n\u0019&a\u001c\u0002r\u0005\u0005\u0014qLA2\u0003K\nY(!5-\u0005\u0005}\u0004f\u0002\u0001\u0002V\u00065\u0015\u0011\u001e\t\u0005\u0003/\f)/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003\r\t\u0007/\u001b\u0006\u0005\u0003?\f\t/A\u0004kkBLG/\u001a:\u000b\u0007\u0005\rX%A\u0003kk:LG/\u0003\u0003\u0002h\u0006e'a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002q\":\u0001!!<\u0002\u000e\u0006M\b\u0003BAl\u0003_LA!!=\u0002Z\n\u0019A+Y4\"\u0005\u0005U\u0018aC5oi\u0016<'/\u0019;j_:Ds\u0001AA}\u0003\u001b\u0013)\u0001\u0005\u0003\u0002|\n\u0005QBAA\u007f\u0015\u0011\ty0!7\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002\u0002B\u0002\u0003{\u0014!\"\u0012=uK:$w+\u001b;iY\t\u00119a\t\u0002\u0003\nA!!1\u0002B\b\u001b\t\u0011iAC\u0002\u0002d6JAA!\u0005\u0003\u000e\t)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\b")
public class BrokerRegistrationRequestTest {
    public NodeToControllerChannelManager brokerToControllerChannelManager(ClusterInstance clusterInstance) {
        return new NodeToControllerChannelManagerImpl(new ControllerNodeProvider(null, clusterInstance){
            private final SecurityProtocol securityProtocol;
            private final String saslMechanism;
            private final ClusterInstance clusterInstance$1;

            private Option<Node> node() {
                return new Some((Object)new Node(this.clusterInstance$1.anyControllerSocketServer().config().nodeId(), "127.0.0.1", this.clusterInstance$1.anyControllerSocketServer().boundPort(this.clusterInstance$1.controllerListenerName().get())));
            }

            private ListenerName listenerName() {
                return this.clusterInstance$1.controllerListenerName().get();
            }

            private SecurityProtocol securityProtocol() {
                return this.securityProtocol;
            }

            private String saslMechanism() {
                return this.saslMechanism;
            }

            private boolean isZkController() {
                return !this.clusterInstance$1.isKRaftTest();
            }

            public ControllerInformation getControllerInfo() {
                return new ControllerInformation(this.node(), this.listenerName(), this.securityProtocol(), this.saslMechanism(), this.isZkController());
            }
            {
                this.clusterInstance$1 = clusterInstance$1;
                this.securityProtocol = SecurityProtocol.PLAINTEXT;
                this.saslMechanism = "";
            }
        }, Time.SYSTEM, new Metrics(), clusterInstance.anyControllerSocketServer().config(), "heartbeat", "test-heartbeat-", 10000L);
    }

    public <T extends AbstractRequest, R extends AbstractResponse> R sendAndReceive(NodeToControllerChannelManager channelManager, AbstractRequest.Builder<T> reqBuilder, int timeoutMs) {
        CompletableFuture responseFuture = new CompletableFuture();
        channelManager.sendRequest(reqBuilder, new ControllerRequestCompletionHandler(null, responseFuture){
            private final CompletableFuture responseFuture$1;

            public void onTimeout() {
                this.responseFuture$1.completeExceptionally(new TimeoutException());
            }

            public void onComplete(ClientResponse response) {
                this.responseFuture$1.complete(response.responseBody());
            }
            {
                this.responseFuture$1 = responseFuture$1;
            }
        });
        return (R)((AbstractResponse)responseFuture.get(timeoutMs, TimeUnit.MILLISECONDS));
    }

    public Errors registerBroker(NodeToControllerChannelManager channelManager, String clusterId, int brokerId, Option<Object> zkEpoch, Option<Tuple2<MetadataVersion, MetadataVersion>> ibpToSend, boolean useApacheVersions) {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        ibpToSend.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerRegistrationRequestTest.$anonfun$registerBroker$1(useApacheVersions, features, x0$1)));
        BrokerRegistrationRequestData req = new BrokerRegistrationRequestData().setBrokerId(brokerId).setClusterId(clusterId).setIncarnationId(Uuid.randomUuid()).setIsMigratingZkBroker(zkEpoch.isDefined()).setFeatures(features);
        return Errors.forCode((short)((BrokerRegistrationResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)new BrokerRegistrationRequest.Builder(req), 30000)).data().errorCode());
    }

    public boolean registerBroker$default$6() {
        return false;
    }

    public Errors createTopics(NodeToControllerChannelManager channelManager, String topicName) {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        createTopics.setTopics(new CreateTopicsRequestData.CreatableTopicCollection());
        createTopics.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(10).setReplicationFactor((short)1));
        createTopics.setTimeoutMs(500);
        CreateTopicsRequest.Builder req = new CreateTopicsRequest.Builder(createTopics);
        return Errors.forCode((short)((CreateTopicsResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)req, 3000)).data().topics().find(topicName).errorCode());
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftMigrationEnabledWithApacheVersion(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).interBrokerPortFuture().foreach((Function1 & Serializable)future -> BoxesRunTime.boxToBoolean((boolean)future.complete(Predef$.MODULE$.int2Integer(1000))));
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$1 -> x$1.startup());
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV0)), true));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$, this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), true));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), true));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWithKRaftMigrationDisabled(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).interBrokerPortFuture().foreach((Function1 & Serializable)future -> BoxesRunTime.boxToBoolean((boolean)future.complete(Predef$.MODULE$.int2Integer(1000))));
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV0)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$, this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_3_IV3, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWith33Controller(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV3)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$, this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftMigrationEnabled(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).interBrokerPortFuture().foreach((Function1 & Serializable)future -> BoxesRunTime.boxToBoolean((boolean)future.complete(Predef$.MODULE$.int2Integer(1000))));
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$2 -> x$2.startup());
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$, this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_3_IV3)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, autoStart=AutoStart.NO, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})})
    public void testNoMetadataChangesInPreMigrationMode(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).interBrokerPortFuture().foreach((Function1 & Serializable)future -> BoxesRunTime.boxToBoolean((boolean)future.complete(Predef$.MODULE$.int2Integer(1000))));
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$3 -> x$3.startup());
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertThrows(TimeoutException.class, () -> this.createTopics(channelManager, "test-pre-migration"));
        }
        finally {
            channelManager.shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$registerBroker$1(boolean useApacheVersions$1, BrokerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataVersion min = (MetadataVersion)x0$1._1();
            MetadataVersion max = (MetadataVersion)x0$1._2();
            if (useApacheVersions$1) {
                return features$1.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(min.apacheFeatureLevel()).setMaxSupportedVersion(max.apacheFeatureLevel()));
            }
            return features$1.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(min.confluentFeatureLevel()).setMaxSupportedVersion(max.confluentFeatureLevel()));
        }
        throw new MatchError(null);
    }
}

