/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.Defaults$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.QuotaType;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u001db\u0001\u0002)R\u0001YCQa\u0017\u0001\u0005\u0002qCqA\u0018\u0001C\u0002\u0013%q\f\u0003\u0004d\u0001\u0001\u0006I\u0001\u0019\u0005\u0006I\u0002!I!\u001a\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\t9\u0010\u0001C\u0001\u00037Dq!a?\u0001\t\u0003\tY\u000eC\u0004\u0002\u0000\u0002!\t!a7\t\u000f\t\r\u0001\u0001\"\u0001\u0002\\\"9!q\u0001\u0001\u0005\n\t%\u0001b\u0002B\u0016\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005_\u0001A\u0011AAn\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u00037DqAa\u000e\u0001\t\u0003\tY\u000eC\u0004\u0003<\u0001!\t!a7\t\u000f\t}\u0002\u0001\"\u0001\u0002\\\"9!1\t\u0001\u0005\u0002\u0005m\u0007b\u0002B$\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005\u0017\u0002A\u0011AAn\u0011\u001d\u0011y\u0005\u0001C\u0001\u00037DqAa\u0015\u0001\t\u0003\tY\u000eC\u0004\u0003X\u0001!\t!a7\t\u000f\tm\u0003\u0001\"\u0001\u0002\\\"9!q\f\u0001\u0005\u0002\u0005m\u0007b\u0002B2\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005O\u0002A\u0011AAn\u0011\u001d\u0011Y\u0007\u0001C\u0001\u00037DqAa\u001c\u0001\t\u0003\tY\u000eC\u0004\u0003t\u0001!\t!a7\t\u000f\t]\u0004\u0001\"\u0001\u0002\\\"9!1\u0010\u0001\u0005\u0002\u0005m\u0007b\u0002B@\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011I\n\u0001C\u0001\u00037DqA!(\u0001\t\u0003\tY\u000eC\u0004\u0003\"\u0002!\t!a7\t\u000f\t\u0015\u0006\u0001\"\u0001\u0002\\\"9!\u0011\u0016\u0001\u0005\u0002\u0005m\u0007b\u0002BW\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005c\u0003A\u0011AAn\u0011\u001d\u0011)\f\u0001C\u0001\u00037DqA!/\u0001\t\u0003\u0011Y\fC\u0004\u0003B\u0002!\tAa1\t\u000f\t-\u0007\u0001\"\u0001\u0003N\u001a!\u0011\u000f\u0001#s\u0011)\tY!\fBK\u0002\u0013\u0005\u0011Q\u0002\u0005\u000b\u0003?i#\u0011#Q\u0001\n\u0005=\u0001BCA\u0011[\tU\r\u0011\"\u0001\u0002\u000e!Q\u00111E\u0017\u0003\u0012\u0003\u0006I!a\u0004\t\u0015\u0005\u0015RF!f\u0001\n\u0003\t9\u0003\u0003\u0006\u000205\u0012\t\u0012)A\u0005\u0003SA!\"!\r.\u0005+\u0007I\u0011AA\u0014\u0011)\t\u0019$\fB\tB\u0003%\u0011\u0011\u0006\u0005\u000776\"\t!!\u000e\t\u000f\u0005}R\u0006\"\u0001\u0002B!I\u00111K\u0017\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003?j\u0013\u0013!C\u0001\u0003CB\u0011\"a\u001e.#\u0003%\t!!\u0019\t\u0013\u0005eT&%A\u0005\u0002\u0005m\u0004\"CA@[E\u0005I\u0011AA>\u0011%\t\t)LA\u0001\n\u0003\n\u0019\tC\u0005\u0002\u00066\n\t\u0011\"\u0001\u0002\b\"I\u0011qR\u0017\u0002\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003;k\u0013\u0011!C!\u0003?C\u0011\"!,.\u0003\u0003%\t!a,\t\u0013\u0005eV&!A\u0005B\u0005m\u0006\"CA`[\u0005\u0005I\u0011IAa\u0011%\t\u0019-LA\u0001\n\u0003\n)\rC\u0005\u0002H6\n\t\u0011\"\u0011\u0002J\u001eI!Q\u001d\u0001\u0002\u0002#%!q\u001d\u0004\tc\u0002\t\t\u0011#\u0003\u0003j\"11l\u0012C\u0001\u0007\u0003A\u0011\"a1H\u0003\u0003%)%!2\t\u0013\r\rq)!A\u0005\u0002\u000e\u0015\u0001\"CB\b\u000fF\u0005I\u0011AA>\u0011%\u0019\tbRI\u0001\n\u0003\tY\bC\u0005\u0004\u0014\u001d\u000b\t\u0011\"!\u0004\u0016!I11E$\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0007K9\u0015\u0013!C\u0001\u0003w\u0012ac\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003%N\u000baa]3sm\u0016\u0014(\"\u0001+\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0016\t\u00031fk\u0011!U\u0005\u00035F\u0013!DQ1tK\u000ec\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d+fgR\fa\u0001P5oSRtD#A/\u0011\u0005a\u0003\u0011AB2p]\u001aLw-F\u0001a!\tA\u0016-\u0003\u0002c#\nA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005\u0001B/Z:u#V|G/\u0019)beNLgn\u001a\u000b\nM2l\u0017QZAi\u0003+\u0004\"a\u001a6\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014A!\u00168ji\")a\f\u0002a\u0001A\")a\u000e\u0002a\u0001_\u000691\r\\5f]R\f\u0004C\u00019.\u001b\u0005\u0001!AC+tKJ\u001cE.[3oiN!Qf\u001d<z!\t9G/\u0003\u0002vQ\n1\u0011I\\=SK\u001a\u0004\"aZ<\n\u0005aD'a\u0002)s_\u0012,8\r\u001e\t\u0004u\u0006\u0015abA>\u0002\u00029\u0011Ap`\u0007\u0002{*\u0011a0V\u0001\u0007yI|w\u000e\u001e \n\u0003%L1!a\u0001i\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0002\u0002\n\ta1+\u001a:jC2L'0\u00192mK*\u0019\u00111\u00015\u0002\tU\u001cXM]\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001a9!\u00111CA\u000b!\ta\b.C\u0002\u0002\u0018!\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u000e\u0003;\u0011aa\u0015;sS:<'bAA\fQ\u0006)Qo]3sA\u0005A1\r\\5f]RLE-A\u0005dY&,g\u000e^%eA\u0005Q1m\u001c8gS\u001e,6/\u001a:\u0016\u0005\u0005%\u0002#B4\u0002,\u0005=\u0011bAA\u0017Q\n1q\n\u001d;j_:\f1bY8oM&<Wk]3sA\u0005q1m\u001c8gS\u001e\u001cE.[3oi&#\u0017aD2p]\u001aLwm\u00117jK:$\u0018\n\u001a\u0011\u0015\u0013=\f9$!\u000f\u0002<\u0005u\u0002bBA\u0006m\u0001\u0007\u0011q\u0002\u0005\b\u0003C1\u0004\u0019AA\b\u0011%\t)C\u000eI\u0001\u0002\u0004\tI\u0003C\u0005\u00022Y\u0002\n\u00111\u0001\u0002*\u000592/\u00198ji&TX\rZ\"p]\u001aLwm\u00117jK:$\u0018\nZ\u000b\u0003\u0003\u0007\u0002RaZA\u0016\u0003\u000b\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%\u0001\u0003mC:<'BAA(\u0003\u0011Q\u0017M^1\n\t\u0005m\u0011\u0011J\u0001\u0005G>\u0004\u0018\u0010F\u0005p\u0003/\nI&a\u0017\u0002^!I\u00111\u0002\u001d\u0011\u0002\u0003\u0007\u0011q\u0002\u0005\n\u0003CA\u0004\u0013!a\u0001\u0003\u001fA\u0011\"!\n9!\u0003\u0005\r!!\u000b\t\u0013\u0005E\u0002\b%AA\u0002\u0005%\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003GRC!a\u0004\u0002f-\u0012\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003%)hn\u00195fG.,GMC\u0002\u0002r!\f!\"\u00198o_R\fG/[8o\u0013\u0011\t)(a\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0010\u0016\u0005\u0003S\t)'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\nB\u0019q-a#\n\u0007\u00055\u0005NA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\u0006e\u0005cA4\u0002\u0016&\u0019\u0011q\u00135\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u001c~\n\t\u00111\u0001\u0002\n\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!)\u0011\r\u0005\r\u0016\u0011VAJ\u001b\t\t)KC\u0002\u0002(\"\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY+!*\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003c\u000b9\fE\u0002h\u0003gK1!!.i\u0005\u001d\u0011un\u001c7fC:D\u0011\"a'B\u0003\u0003\u0005\r!a%\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u000b\ni\fC\u0005\u0002\u001c\n\u000b\t\u00111\u0001\u0002\n\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\n\u0006AAo\\*ue&tw\r\u0006\u0002\u0002F\u00051Q-];bYN$B!!-\u0002L\"I\u00111T#\u0002\u0002\u0003\u0007\u00111\u0013\u0005\u0007\u0003\u001f$\u0001\u0019A8\u0002\u000f\rd\u0017.\u001a8ue!1\u00111\u001b\u0003A\u0002=\fAB]1oI>l7\t\\5f]RDa!a6\u0005\u0001\u0004y\u0017a\u00053fM\u0006,H\u000e^\"p]\u001aLwm\u00117jK:$\u0018\u0001\u0007;fgR\u001cE.[3oi&#\u0017+^8uCB\u000b'o]5oOR\ta\rK\u0002\u0006\u0003?\u0004B!!9\u0002t6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/A\u0002ba&TA!!;\u0002l\u00069!.\u001e9ji\u0016\u0014(\u0002BAw\u0003_\fQA[;oSRT!!!=\u0002\u0007=\u0014x-\u0003\u0003\u0002v\u0006\r(\u0001\u0002+fgR\fA\u0003^3tiV\u001bXM])v_R\f\u0007+\u0019:tS:<\u0007f\u0001\u0004\u0002`\u0006aB/Z:u+N,'o\u00117jK:$\u0018\nZ)v_R\f\u0007+\u0019:tS:<\u0007fA\u0004\u0002`\u0006aC/Z:u+N,'/U;pi\u0006\u0004\u0016M]:j]\u001e<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;DY&,g\u000e^%e#V|G/\u0019\u0015\u0004\u0011\u0005}\u0017\u0001\u000e;fgR,6/\u001a:DY&,g\u000e^)v_R\f\u0007+\u0019:tS:<\u0017\nZ,ji\"$UMZ1vYR\u001cE.[3oi&#\u0017+^8uC\"\u001a\u0011\"a8\u0002\u0015\rDWmY6Rk>$\u0018\rF\u0007g\u0005\u0017\u0011)Ba\u0006\u0003\u001a\t\r\"q\u0005\u0005\b\u0005\u001bQ\u0001\u0019\u0001B\b\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s!\rA&\u0011C\u0005\u0004\u0005'\t&AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJDq!a\u0003\u000b\u0001\u0004\ty\u0001C\u0004\u0002\")\u0001\r!a\u0004\t\u000f\tm!\u00021\u0001\u0003\u001e\u0005iQ\r\u001f9fGR,GMQ8v]\u0012\u00042a\u001aB\u0010\u0013\r\u0011\t\u0003\u001b\u0002\u0005\u0019>tw\rC\u0004\u0003&)\u0001\r!!#\u0002\u000bY\fG.^3\t\u000f\t%\"\u00021\u0001\u00022\u0006qQ\r\u001f9fGR$\u0006N]8ui2,\u0017!\u000e;fgR<U\r^'bqZ\u000bG.^3J]F+x\u000e^1XS:$wn^,ji\"tuN\u001c#fM\u0006,H\u000e^)v_R\fw+\u001b8e_^D3aCAp\u0003\u0001\"Xm\u001d;TKR\fe\u000e\u001a*f[>4X\rR3gCVdG/V:feF+x\u000e^1)\u00071\ty.A\ruKN$8+\u001a;B]\u0012\u0014V-\\8wKV\u001bXM])v_R\f\u0007fA\u0007\u0002`\u0006yB/Z:u'\u0016$\u0018I\u001c3SK6|g/Z+tKJ\u001cE.[3oiF+x\u000e^1)\u00079\ty.A\ruKN$\u0018+^8uC\u000e{gNZ5h!J,7-\u001a3f]\u000e,\u0007fA\b\u0002`\u0006\u0011B/Z:u#V|G/\u0019,j_2\fG/[8oQ\r\u0001\u0012q\\\u0001&i\u0016\u001cH/U;pi\u00064\u0016n\u001c7bi&|gnV5uQ6\u000b\u0007\u0010\u00165s_R$H.\u001a+j[\u0016D3!EAp\u0003q!Xm\u001d;FqBL'/\u001a+ie>$H\u000f\\3US6,7+\u001a8t_JD3AEAp\u0003Y!Xm\u001d;FqBL'/Z)v_R\f7+\u001a8t_J\u001c\bfA\n\u0002`\u0006AB/Z:u\u00072LWM\u001c;JI:{GoU1oSRL'0\u001a3)\u0007Q\ty.A\u0010uKN$XK\\5wKJ\u001c\u0018\r\\5us>3\u0017i\u0019;jm\u0016$VM\\1oiND3!FAp\u0003q!Xm\u001d;Ge\u0016\fX/\u001a8ds>3\u0017)\u001e;p)VtW-U;pi\u0006D3AFAp\u0003u!Xm\u001d;J]\u0006\u001cG/\u001b<f)\u0016t\u0017M\u001c;t%\u0016\u001cX\r^)v_R\f\u0007fA\f\u0002`\u0006YC/Z:u\u0003V$x\u000eV;oK\n\u000bg\u000eZ<jIRD\u0017+^8uC\u0006cG.\u00112pm\u00164\u0015-\u001b:MS6LG\u000fK\u0002\u0019\u0003?\f\u0001\u0007^3ti\u0006+Ho\u001c+v]\u0016\u0014\u0015M\u001c3xS\u0012$\b.U;pi\u0006\f%m\u001c<f\u0003:$')\u001a7po\u001a\u000b\u0017N\u001d'j[&$\bfA\r\u0002`\u0006YC/Z:u\u0003V$x\u000eV;oK\n\u000bg\u000eZ<jIRD\u0017+^8uC\u0006cGNQ3m_^4\u0015-\u001b:MS6LG\u000fK\u0002\u001b\u0003?\f\u0011\u0006^3ti\u0006+Ho\u001c+v]\u0016\u0014\u0015M\u001c3xS\u0012$\b.U;pi\u0006lU\u000f\u001c;ja2,G+\u001a8b]R\u001c\bfA\u000e\u0002`\u0006AC/Z:u\u0003V$x\u000eV;oK^KG\u000f[\"iC:<\u0017N\\4Ce>\\WM])v_R\fG*[7ji\"\u001aA$a8\u0002CQ,7\u000f\u001e#z]\u0006l\u0017nY+qI\u0006$XM\u0011:pW\u0016\u0014\u0018+^8uC2KW.\u001b;)\u0007u\ty.A\u0016uKN$\u0018)\u001e;p)VtWmV5uQ\u000eC\u0017M\\4j]\u001e|%/[4j]\u0006d7\t\\5f]R\fVo\u001c;bQ\rq\u0012q\\\u0001'i\u0016\u001cH/Q;u_R+h.Z,iK:\u001cE.[3oiN#x\u000e]:TK:$\u0017N\\4M_\u0006$\u0007fA\u0010\u0002`\u0006\u0019D/Z:u\u0003V$x\u000eV;oK^CWM\\\"mS\u0016tG/V:bO\u0016$Um\u0019:fCNLgnZ!gi\u0016\u0014H\u000b\u001b:piRdW\r\u001a\u0015\u0004A\u0005}\u0017a\u0005<fe&4\u0017\u0010R=oC6L7-U;pi\u0006\u001cH#\u00024\u0003\b\n%\u0005b\u0002B\u0007C\u0001\u0007!q\u0002\u0005\b\u0005\u0017\u000b\u0003\u0019\u0001BG\u0003a)\u0007\u0010]3di\u0016$\u0017+^8uCN4uN]\"mS\u0016tGo\u001d\t\t\u0003#\u0011y)a\u0004\u0003\u0014&!!\u0011SA\u000f\u0005\ri\u0015\r\u001d\t\u0004O\nU\u0015b\u0001BLQ\n1Ai\\;cY\u0016\f1\u0007^3ti\u0006+Ho\u001c+v]&tw-\u00117m_\u000e\fG/Z:CC:$w/\u001b3uQB\u0013x\u000e]8si&|g.\u00197U_F+x\u000e^1)\u0007\t\ny.A\u0015uKN$\u0018)\u001e;p)Vt\u0017N\\4V]2LW.\u001b;fIF+x\u000e^1G_J\fE\u000e\\\"mS\u0016tGo\u001d\u0015\u0004G\u0005}\u0017A\u000b;fgR\fU\u000f^8Uk:LgnZ+oY&l\u0017\u000e^3e#V|G/\u0019$peN{W.Z\"mS\u0016tGo\u001d\u0015\u0004I\u0005}\u0017a\f;fgR\fU\u000f^8Uk:LgnZ+oY&l\u0017\u000e^3e#V|G/Y,ji\"dun^+tC\u001e,7\t\\5f]R\u001c\bfA\u0013\u0002`\u0006AC/Z:u\u0003V$x\u000eV;oS:<WK\u001c7j[&$X\rZ)v_R\fw+\u001b;i\u0019><Xk]1hK\"\u001aa%a8\u0002=Q,7\u000f^!vi>$VO\\5oO\"\u000bg\u000e\u001a7fgj+'o\\)v_R\f\u0007fA\u0014\u0002`\u0006\u0001C/Z:u\u0003V$x\u000eV;oS:<7k\u001c:ug\nKX\u000b^5mSj\fG/[8oQ\rA\u0013q\\\u0001*i\u0016\u001cH\u000f\u0015:pIV\u001cWM]%t)\"\u0014x\u000e\u001e;mK\u0012<\u0006.\u001a8ESN\\7\u000b]1dK&\u001bHj\\<)\u0007%\ny.A\bnS2d\u0017n\u001d+p!\u0016\u00148-\u001a8u)\u0011\u0011\u0019J!0\t\u000f\t}&\u00061\u0001\u0003\u0014\u00061Q.\u001b7mSN\f!\"\\3ue&\u001cG+Y4t)\u0019\u0011)Ma2\u0003JBA\u0011\u0011\u0003BH\u0003\u001f\ty\u0001C\u0004\u0002\f-\u0002\r!a\u0004\t\u000f\u0005\u00052\u00061\u0001\u0002\u0010\u0005Qa.Z<NKR\u0014\u0018nY:\u0016\u0005\t=\u0007\u0003\u0002Bi\u0005Cl!Aa5\u000b\t\tU'q[\u0001\b[\u0016$(/[2t\u0015\u0011\u0011INa7\u0002\r\r|W.\\8o\u0015\r!&Q\u001c\u0006\u0005\u0005?\fy/\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0005G\u0014\u0019NA\u0004NKR\u0014\u0018nY:\u0002\u0015U\u001bXM]\"mS\u0016tG\u000f\u0005\u0002q\u000fN)qIa;\u0003xBi!Q\u001eBz\u0003\u001f\ty!!\u000b\u0002*=l!Aa<\u000b\u0007\tE\b.A\u0004sk:$\u0018.\\3\n\t\tU(q\u001e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003\u0002B}\u0005\u007fl!Aa?\u000b\t\tu\u0018QJ\u0001\u0003S>LA!a\u0002\u0003|R\u0011!q]\u0001\u0006CB\u0004H.\u001f\u000b\n_\u000e\u001d1\u0011BB\u0006\u0007\u001bAq!a\u0003K\u0001\u0004\ty\u0001C\u0004\u0002\")\u0003\r!a\u0004\t\u0013\u0005\u0015\"\n%AA\u0002\u0005%\u0002\"CA\u0019\u0015B\u0005\t\u0019AA\u0015\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!1qCB\u0010!\u00159\u00171FB\r!-971DA\b\u0003\u001f\tI#!\u000b\n\u0007\ru\u0001N\u0001\u0004UkBdW\r\u000e\u0005\t\u0007Ci\u0015\u0011!a\u0001_\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE);

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)9.223372036854776E18, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)new StringBuilder(63).append("Default producer quota should be ").append(9.223372036854776E18).toString());
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), (double)2500 * (double)config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), (double)600 * (double)config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), (double)1000 * (double)config.numQuotaSamples());
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE);
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE);
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, (double)value * (double)this.config().numQuotaSamples());
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1, Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            this.time().sleep(1000L);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 6550.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolationWithMaxThrottleTime() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            clientQuotaManager.updateClientQuotaMaxThrottleTimeMs(10000L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 200000.0);
            Assertions.assertEquals((int)10000, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString()), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString()), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testUniversalityOfActiveTenants() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        ClientRequestQuotaManager requestQuotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        scala.collection.mutable.Set activeTenants = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            requestQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(quotaManager, "User1", "Client1", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client1"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
            this.maybeRecord((ClientQuotaManager)requestQuotaManager, "User3", "Client3", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client3"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
        }
        finally {
            quotaManager.shutdown();
            requestQuotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testFrequencyOfAutoTuneQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$32 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$42 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$32, x$42, x$1, x$5, 250.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testInactiveTenantsResetQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$3 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$4 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$52 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$52, 250.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            this.time().sleep(11000L);
            this.maybeRecord(quotaManager, "", "", 300.0);
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllAboveFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAboveAndBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client2").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaMultipleTenants() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            Assertions.assertEquals((Object)quotaManager.quota("", "Client1"), (Object)quotaManager.dynamicQuota("", "Client1"));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertTrue((boolean)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.maybeRecord(quotaManager, "", "Client1", 250.0), this.maybeRecord(quotaManager, "", "Client2", 100.0), this.maybeRecord(quotaManager, "", "Client3", 200.0), this.maybeRecord(quotaManager, "", "Client4", 50.0)}))).forall((Function1)(JFunction1.mcZI.sp & Serializable)throttleTime -> throttleTime == 0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client3"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client4"), (Object)BoxesRunTime.boxToDouble((double)125.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingBrokerQuotaLimit() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 250.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)0.0, (double)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.setBrokerQuotaLimit(500.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            quotaManager.setBrokerQuotaLimit(250.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testDynamicUpdateBrokerQuotaLimit() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$2 = new BrokerBackpressureConfig(true, BrokerBackpressureConfig$.MODULE$.DefaultBackpressureCheckFrequencyMs(), (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$4 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$4, x$2, x$5, 250.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)0.0, (double)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.dynamicUpdateBrokerQuotaLimit(500L);
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            quotaManager.dynamicUpdateBrokerQuotaLimit(250L);
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingOriginalClientQuota() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 250.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(300.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(200.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientStopsSendingLoad() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
            int throttleTimeMs1 = this.maybeRecord(quotaManager, "", "C2", 400.0);
            this.time().sleep((long)Math.max(1000, throttleTimeMs1));
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientUsageDecreasingAfterThrottled() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 190.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)310.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    private void verifyDynamicQuotas(ClientQuotaManager quotaManager, Map<String, Object> expectedQuotasForClients) {
        expectedQuotasForClients.foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotaManagerTest.$anonfun$verifyDynamicQuotas$1(quotaManager, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAutoTuningAllocatesBandwidthProportionalToQuota() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(1400.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)700.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForAllClients() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForSomeClients() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsageClients() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 600.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(600.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 0.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)200.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)100.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsage() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 100.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningHandlesZeroQuota() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(0.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(700.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 0.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 600.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)0.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningSortsByUtilization() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7, x$8);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(500.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)300.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testProducerIsThrottledWhenDiskSpaceIsLow() {
        Path tempLogDir = Files.createTempDirectory("some-dir", new FileAttribute[0]);
        long diskThreshold = Long.MAX_VALUE;
        Metrics metrics = this.newMetrics();
        int throttledBandwidth = 300;
        long x$1 = throttledBandwidth;
        .colon.colon x$2 = new .colon.colon((Object)((Object)tempLogDir).toString(), (List)Nil$.MODULE$);
        long x$5 = 0x500000000L;
        double x$6 = 1.5;
        boolean x$7 = false;
        DiskUsageBasedThrottlingConfig qual$1 = DiskUsageBasedThrottlingConfig$.MODULE$.apply(x$5, x$1, (Seq)x$2, true, 1000L, x$6, x$7);
        Seq x$10 = qual$1.copy$default$3();
        boolean x$11 = qual$1.copy$default$4();
        long x$12 = qual$1.copy$default$5();
        double x$13 = qual$1.copy$default$6();
        boolean x$14 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig diskThrottlingConfig = qual$1.copy(diskThreshold, 300L, x$10, x$11, x$12, x$13, x$14);
        BrokerBackpressureConfig x$16 = new BrokerBackpressureConfig(false, BrokerBackpressureConfig$.MODULE$.DefaultBackpressureCheckFrequencyMs(), (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$18 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        double x$19 = 9.223372036854776E18;
        long x$20 = 0L;
        int x$21 = 0;
        long x$22 = Long.MAX_VALUE;
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(2, x$18, x$16, diskThrottlingConfig, x$19, x$20, x$21, x$22);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this, configWithBackpressure, metrics, activeTenantsManager){
            private final DiskThrottleListenerManager listenerManager;

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                QuotaType.Produce$ x$3 = QuotaType.Produce$.MODULE$;
                MockTime x$4 = $outer.time();
                Some x$6 = new Some((Object)activeTenantsManager$1);
                None$ x$7 = None$.MODULE$;
                super(configWithBackpressure$1, metrics$1, (QuotaType)x$3, (Time)x$4, "", (Option)x$7, (Option)x$6);
                this.listenerManager = new DiskThrottleListenerManager(null){
                    private ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                        Statics.releaseFence();
                    }
                };
            }
        };
        quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(1000.0, true)));
        quotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)quotaManager);
        Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertFalse((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        this.time().sleep(Math.max(configWithBackpressure.backpressureConfig().backpressureCheckFrequencyMs(), quotaManager.getCurrentDiskThrottlingConfig().diskCheckFrequencyMs()) + 1000L);
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        Assertions.assertEquals((double)throttledBandwidth, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertTrue((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((long)throttledBandwidth, (long)BoxesRunTime.unboxToLong((Object)((Option)quotaManager.lastSignalledQuotaOptRef().get()).get()));
        quotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)quotaManager);
    }

    public double millisToPercent(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public Map<String, String> metricTags(String user, String clientId) {
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyDynamicQuotas$1(ClientQuotaManager quotaManager$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String clientId = (String)x0$1._1();
            Assertions.assertEquals((double)x0$1._2$mcD$sp(), (double)quotaManager$3.dynamicQuota("", clientId).bound(), (double)0.1, (String)new StringBuilder(21).append("Unexpected quota for ").append(clientId).toString());
            return;
        }
        throw new MatchError(null);
    }

    private class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return ConfigEntityName$.MODULE$.Default();
                }
                return Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "clientId";
                }
                case 2: {
                    return "configUser";
                }
                case 3: {
                    return "configClientId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof UserClient && ((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() == this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer())) break block3;
                    UserClient userClient = (UserClient)x$1;
                    String string = this.user();
                    String string2 = userClient.user();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.clientId();
                    String string4 = userClient.clientId();
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                    Option<String> option = this.configUser();
                    Option<String> option2 = userClient.configUser();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<String> option3 = this.configClientId();
                    Option<String> option4 = userClient.configClientId();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !userClient.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

