/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.multitenant.InetAddressToTenantMapping;
import io.confluent.kafka.multitenant.SingletonInetAddressToTenantMapping;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.metrics.BrokerLoad;
import kafka.network.ConnectionQuotas;
import kafka.server.ActiveTenantsManager;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaMetricsReporter;
import kafka.server.ClientQuotaMetricsReporterConfig;
import kafka.server.ClientQuotaMetricsReporterTest;
import kafka.server.Defaults$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory$;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.apache.kafka.server.metrics.TenantRequestSensorBuilder;
import org.apache.kafka.server.metrics.TenantRequestSensors;
import org.apache.kafka.server.util.MockTime;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005]2AAB\u0004\u0001\u0019!)\u0011\u0003\u0001C\u0001%!)A\u0003\u0001C\u0001+!)\u0011\u0006\u0001C\u0001+!)1\u0006\u0001C\u0001+!)Q\u0006\u0001C\u0001]\tq2\t\\5f]R\fVo\u001c;b\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;feR+7\u000f\u001e\u0006\u0003\u0011%\taa]3sm\u0016\u0014(\"\u0001\u0006\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0004\t\u0003\u001d=i\u0011aB\u0005\u0003!\u001d\u0011!DQ1tK\u000ec\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d+fgR\fa\u0001P5oSRtD#A\n\u0011\u00059\u0001\u0011!\t;fgR\fVo\u001c;b%\u0016\u0004xN\u001d;j]\u001e\u001c\u0015\r\u001c7cC\u000e\\WI\\1cY\u0016$G#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005u\u0001\"AH\u0014\u000e\u0003}Q!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018N\u0003\u0002#G\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0013&\u0003\u0015QWO\\5u\u0015\u00051\u0013aA8sO&\u0011\u0001f\b\u0002\u0005)\u0016\u001cH/A\u0018uKN$\u0018+^8uCJ+\u0007o\u001c:uS:<7)\u00197mE\u0006\u001c7nV5uQ\u0006\u001bG/\u001b<f\u0007>t7/^7qi&|g\u000e\u000b\u0002\u0004;\u0005AC/Z:u\u001d>t\u0017+^8uC\u0016sgm\u001c:dK\u0012,5i[;NKR\u0014\u0018nY:SKB|'\u000f^5oO\"\u0012A!H\u0001'EJ|7.\u001a:Qe>\u00048oV5uQ\u0012+g-Y;mi\u000e{gN\\3di&|g\u000eT5nSR\u001cX#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001B;uS2T\u0011\u0001N\u0001\u0005U\u00064\u0018-\u0003\u00027c\tQ\u0001K]8qKJ$\u0018.Z:")
public class ClientQuotaMetricsReporterTest
extends BaseClientQuotaManagerTest {
    @Test
    public void testQuotaReportingCallbackEnabled() {
        Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
        int x$5 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(2, x$5, x$6, x$7, 100000.0, 1000L, 102400, x$8);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        reportingRequestThread.schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.eq((long)config.consumptionReportingIntervalMs()));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{reportingRequestThread});
        BrokerLoad brokerLoad = (BrokerLoad)EasyMock.createMock(BrokerLoad.class);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager produceQuotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager));
        ClientQuotaManager fetchQuotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager));
        ClientQuotaMetricsReporterConfig clientQuotaMetricsReporterConfig = new ClientQuotaMetricsReporterConfig(1000L, 102400.0, true);
        new ClientQuotaMetricsReporter(clientQuotaMetricsReporterConfig, metrics, fetchQuotaManager, produceQuotaManager, (Option)new Some((Object)activeTenantsManager), (Option)new Some((Object)reportingRequestThread), (Option)new Some((Object)brokerLoad)).init();
        EasyMock.verify((Object[])new Object[]{reportingRequestThread});
        produceQuotaManager.shutdown();
        fetchQuotaManager.shutdown();
        metrics.close();
    }

    @Test
    public void testQuotaReportingCallbackWithActiveConsumption() {
        Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
        int x$5 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$8 = Long.MAX_VALUE;
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(2, x$5, x$6, x$7, 100000.0, 1000L, 102400, x$8);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        BrokerLoad brokerLoad = (BrokerLoad)EasyMock.createMock(BrokerLoad.class);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager produceQuotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager));
        ClientQuotaManager fetchQuotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager));
        QuotaFactory$.MODULE$.quotaConsumptionReportingEnabled_$eq(true);
        ClientQuotaMetricsReporterConfig clientQuotaMetricsReporterConfig = new ClientQuotaMetricsReporterConfig(1000L, 102400.0, true);
        ClientQuotaMetricsReporter clientQuotaMetricsReporter = new ClientQuotaMetricsReporter(clientQuotaMetricsReporterConfig, metrics, fetchQuotaManager, produceQuotaManager, (Option)new Some((Object)activeTenantsManager), (Option)new Some((Object)reportingRequestThread), (Option)new Some((Object)brokerLoad));
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        entryData.setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C1")));
        entryData.setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(102400.0).setThrottled(false)));
        ReportQuotaConsumptionRequestData.EntryData entryData2 = new ReportQuotaConsumptionRequestData.EntryData();
        entryData2.setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C2")));
        entryData2.setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(160000.0).setThrottled(true)));
        Option$.MODULE$.apply((Object)reportingRequestThread).foreach((Function1 & Serializable)x$1 -> {
            x$1.addEntryForNode(EasyMock.eq((Object)entryData));
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        Option$.MODULE$.apply((Object)reportingRequestThread).foreach((Function1 & Serializable)x$2 -> {
            x$2.addEntryForNode(EasyMock.eq((Object)entryData2));
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        Option$.MODULE$.apply((Object)reportingRequestThread).foreach((Function1 & Serializable)x$3 -> {
            x$3.wakeup();
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{reportingRequestThread});
        try {
            produceQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(30000.0, true)));
            produceQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(70000.0, true)));
            produceQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(2.147483647E9, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(produceQuotaManager, "", "C3", 1000.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(produceQuotaManager, "", "C1", 100.0));
            int throttleTime = this.maybeRecord(produceQuotaManager, "", "C2", (double)80000 * (double)config.numQuotaSamples());
            Assertions.assertTrue((throttleTime > 0 ? 1 : 0) != 0);
            this.throttle(produceQuotaManager, "", "C2", throttleTime, this.callback());
            clientQuotaMetricsReporter.quotaUsageReportingCallback();
            EasyMock.verify((Object[])new Object[]{reportingRequestThread});
        }
        finally {
            produceQuotaManager.shutdown();
            fetchQuotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testNonQuotaEnforcedECkuMetricsReporting() {
        Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        BrokerLoad brokerLoad = (BrokerLoad)EasyMock.createMock(BrokerLoad.class);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        activeTenantsManager.trackActiveTenant((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"lkc-123")})), this.time().milliseconds());
        ClientQuotaManager produceQuotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager));
        ClientQuotaManager fetchQuotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager));
        QuotaFactory$.MODULE$.quotaConsumptionReportingEnabled_$eq(true);
        ClientQuotaMetricsReporterConfig clientQuotaMetricsReporterConfig = new ClientQuotaMetricsReporterConfig(1000L, 102400.0, true);
        ClientQuotaMetricsReporter clientQuotaMetricsReporter = new ClientQuotaMetricsReporter(clientQuotaMetricsReporterConfig, metrics, fetchQuotaManager, produceQuotaManager, (Option)new Some((Object)activeTenantsManager), (Option)new Some((Object)reportingRequestThread), (Option)new Some((Object)brokerLoad));
        ReportQuotaConsumptionRequestData.EntryData requestRateEntryData = new ReportQuotaConsumptionRequestData.EntryData();
        requestRateEntryData.setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("tenant").setEntityName("lkc-123")));
        requestRateEntryData.setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("aggregate-request-rate").setUsage(0.13333333333333333).setThrottled(false)));
        ReportQuotaConsumptionRequestData.EntryData connectionCountEntryData = new ReportQuotaConsumptionRequestData.EntryData();
        connectionCountEntryData.setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("tenant").setEntityName("lkc-123")));
        connectionCountEntryData.setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("authenticated-unthrottled-connection-count").setUsage(1.0).setThrottled(false)));
        Option$.MODULE$.apply((Object)reportingRequestThread).foreach((Function1 & Serializable)x$4 -> {
            x$4.addEntryForNode(EasyMock.eq((Object)requestRateEntryData));
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        Option$.MODULE$.apply((Object)reportingRequestThread).foreach((Function1 & Serializable)x$5 -> {
            x$5.addEntryForNode(EasyMock.eq((Object)connectionCountEntryData));
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        Option$.MODULE$.apply((Object)reportingRequestThread).foreach((Function1 & Serializable)x$6 -> {
            x$6.wakeup();
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{reportingRequestThread});
        public class Kafka_server_ClientQuotaMetricsReporterTest$TenantLevelMetricsContext$1
        implements MetricsBuilderContext {
            private final String principal;

            public String principal() {
                return this.principal;
            }

            public String metricsGroup() {
                return "tenant-metrics";
            }

            public java.util.Map<String, String> metricTags() {
                HashMap<String, String> tags = new HashMap<String, String>();
                tags.put("tenant", this.principal());
                return tags;
            }

            public String sensorSuffix() {
                return String.format(":%s-%s", "tenant", this.principal());
            }

            public Kafka_server_ClientQuotaMetricsReporterTest$TenantLevelMetricsContext$1(ClientQuotaMetricsReporterTest $outer, String principal) {
                this.principal = principal;
            }
        }
        TenantRequestSensors tenantRequestSensors = new TenantRequestSensorBuilder(metrics, (MetricsBuilderContext)new Kafka_server_ClientQuotaMetricsReporterTest$TenantLevelMetricsContext$1(null, "lkc-123")).build();
        tenantRequestSensors.recordRequest(this.time().milliseconds());
        tenantRequestSensors.recordRequest(this.time().milliseconds());
        tenantRequestSensors.recordRequest(this.time().milliseconds());
        tenantRequestSensors.recordRequest(this.time().milliseconds());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(kafkaConfig, (Time)new MockTime(), metrics);
        String externalLkc = "lkc-123";
        int numConnections = 70;
        ListenerName externalListenerName = new ListenerName("EXTERNAL");
        java.util.Map listenerConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.max.connection.rate.per.tenant"), (Object)Integer.toString(10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.floor.connection.rate.per.tenant"), (Object)Integer.toString(10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.step.connection.rate.per.tenant"), (Object)Integer.toString(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.connection.creation.rate.per.tenant.enable.threshold"), (Object)Double.toString(0.5))}))).asJava();
        connectionQuotas.addListener(kafkaConfig, externalListenerName);
        ((ConnectionQuotas.ListenerConnectionQuota)connectionQuotas.maxConnectionsPerListener().get((Object)externalListenerName).get()).configure(listenerConfig);
        connectionQuotas.updateTenantConnectionRateQuota((Option)new Some((Object)externalLkc), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)));
        InetAddress address = InetAddress.getByName("192.168.1.1");
        connectionQuotas.inc(externalListenerName, address, null, false, (InetAddressToTenantMapping)new SingletonInetAddressToTenantMapping(address, externalLkc), true);
        connectionQuotas.updateTenantConnectionCountQuota((Option)new Some((Object)externalLkc), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)numConnections)));
        connectionQuotas.incAuthenticatedConnectionCountMaybeThrottle((Object)externalLkc, connectionQuotas.tenantConnectionQuota());
        clientQuotaMetricsReporter.quotaUsageReportingCallback();
        EasyMock.verify((Object[])new Object[]{reportingRequestThread});
    }

    public Properties brokerPropsWithDefaultConnectionLimits() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var21_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var22_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var23_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 0, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:0,REPLICATION://localhost:1,ADMIN://localhost:2");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,ADMIN:PLAINTEXT");
        return props;
    }
}

