/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.network.SocketServer;
import kafka.server.ConfigEntityName$;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaBroker;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasRequest;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ClusterTestDefaults(clusterType=Type.ALL_NON_CORESIDENT)
@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\tme\u0001\u0002\u00192\u0001YB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u0019\u0019\u0006\u0001)A\u0005\u0017\"9A\u000b\u0001b\u0001\n\u0013Q\u0005BB+\u0001A\u0003%1\nC\u0004W\u0001\t\u0007I\u0011\u0002&\t\r]\u0003\u0001\u0015!\u0003L\u0011\u001dA\u0006A1A\u0005\n)Ca!\u0017\u0001!\u0002\u0013Y\u0005b\u0002.\u0001\u0005\u0004%IA\u0013\u0005\u00077\u0002\u0001\u000b\u0011B&\t\u000fq\u0003!\u0019!C\u0005\u0015\"1Q\f\u0001Q\u0001\n-CqA\u0018\u0001C\u0002\u0013%!\n\u0003\u0004`\u0001\u0001\u0006Ia\u0013\u0005\u0006A\u0002!\t!\u0019\u0005\u0006Y\u0002!\t!\u0019\u0005\u0006]\u0002!\t!\u0019\u0005\u0006m\u0002!\t!\u0019\u0005\u0006q\u0002!\t!\u0019\u0005\u0006u\u0002!\t!\u0019\u0005\u0006y\u0002!\t!\u0019\u0005\u0006}\u0002!\t!\u0019\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u0019\t9\u0003\u0001C\u0001C\"1\u00111\u0006\u0001\u0005\u0002\u0005Da!a\f\u0001\t\u0003\t\u0007\"CA\u001a\u0001\t\u0007I\u0011BA\u001b\u0011!\ti\u0007\u0001Q\u0001\n\u0005]\u0002\"CA8\u0001\t\u0007I\u0011BA\u001b\u0011!\t\t\b\u0001Q\u0001\n\u0005]\u0002BBA:\u0001\u0011%\u0011\r\u0003\u0004\u0002v\u0001!\t!\u0019\u0005\u0007\u0003s\u0002A\u0011A1\t\r\u0005u\u0004\u0001\"\u0001b\u0011\u0019\t\t\t\u0001C\u0001C\"1\u0011Q\u0011\u0001\u0005\u0002\u0005Dq!!#\u0001\t\u0013\tY\tC\u0004\u0002\u001c\u0002!I!!(\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\ti\u000f\u0001C\u0005\u0003_DqAa\u0003\u0001\t\u0013\u0011i\u0001C\u0004\u0003.\u0001!IAa\f\u0003/\rc\u0017.\u001a8u#V|G/Y:SKF,Xm\u001d;UKN$(B\u0001\u001a4\u0003\u0019\u0019XM\u001d<fe*\tA'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g-A\u0004dYV\u001cH/\u001a:\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005\u001b\u0014\u0001\u0002;fgRL!a\u0011!\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fa\u0001P5oSRtDC\u0001$I!\t9\u0005!D\u00012\u0011\u0015i$\u00011\u0001?\u0003Q\u0019uN\\:v[\u0016\u0014()\u001f;f%\u0006$X\r\u0015:paV\t1\n\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006!A.\u00198h\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\rM#(/\u001b8h\u0003U\u0019uN\\:v[\u0016\u0014()\u001f;f%\u0006$X\r\u0015:pa\u0002\nA\u0003\u0015:pIV\u001cWM\u001d\"zi\u0016\u0014\u0016\r^3Qe>\u0004\u0018!\u0006)s_\u0012,8-\u001a:CsR,'+\u0019;f!J|\u0007\u000fI\u0001\u0016%\u0016\fX/Z:u!\u0016\u00148-\u001a8uC\u001e,\u0007K]8q\u0003Y\u0011V-];fgR\u0004VM]2f]R\fw-\u001a)s_B\u0004\u0013\u0001F%q\u0007>tg.Z2uS>t'+\u0019;f!J|\u0007/A\u000bJa\u000e{gN\\3di&|gNU1uKB\u0013x\u000e\u001d\u0011\u00021Q+g.\u00198u\u0007>tg.Z2uS>t'+\u0019;f!J|\u0007/A\rUK:\fg\u000e^\"p]:,7\r^5p]J\u000bG/\u001a)s_B\u0004\u0013\u0001\b+f]\u0006tG\u000f\u0015:pIV\u001cWM]%e\u000bb\u0004\u0018N]1uS>tWj]\u0001\u001e)\u0016t\u0017M\u001c;Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005IB+\u001a8b]R\u001cuN\u001c8fGRLwN\\\"pk:$\bK]8q\u0003i!VM\\1oi\u000e{gN\\3di&|gnQ8v]R\u0004&o\u001c9!\u0003q!Xm\u001d;BYR,'o\u00117jK:$\u0018+^8uCN\u0014V-];fgR$\u0012A\u0019\t\u0003q\rL!\u0001Z\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u0003#\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002lQ\nY1\t\\;ti\u0016\u0014H+Z:u\u0003!\"Xm\u001d;BYR,'o\u00117jK:$\u0018+^8uCN\u0014V-];fgR4\u0016\r\\5eCR,wJ\u001c7zQ\t\u0011b-A\u000fuKN$8\t\\5f]R\fVo\u001c;bg\u001a{'oU2sC6,6/\u001a:tQ\u0011\u0019b\r]9\u0002\u0017\rdWo\u001d;feRK\b/\u001a\u0013\u0002e&\u00111\u000f^\u0001\u00035.S!!\u001e5\u0002\tQK\b/Z\u0001\u0019i\u0016\u001cH/\u00117uKJL\u0005/U;pi\u0006\u001c(+Z9vKN$\bF\u0001\u000bg\u0003)\"Xm\u001d;BYR,'\u000fV3oC:$\u0018+^8uCN\u001cuN\u001c8fGRLwN\u001c*bi\u0016\u0014V-];fgRD#!\u00064\u0002eQ,7\u000f^!mi\u0016\u0014H+\u001a8b]R\fVo\u001c;bgB\u0013x\u000eZ;dKJLE-\u0012=qSJ\fG/[8o\u001bN\u0014V-];fgRD#A\u00064\u0002WQ,7\u000f^!mi\u0016\u0014H+\u001a8b]R\fVo\u001c;bg\u000e{gN\\3di&|gnQ8v]R\u0014V-];fgRD#a\u00064\u0002IQ,7\u000f^!mi\u0016\u00148\t\\5f]R\fVo\u001c;bg&sg/\u00197jIJ+\u0017/^3tiND#\u0001\u00074\u0002?\u0015D\b/Z2u\u0013:4\u0018\r\\5e%\u0016\fX/Z:u/&$\b.T3tg\u0006<W\rF\u0003c\u0003\u000b\ty\u0001\u0003\u0005\u0002\be!\t\u0019AA\u0005\u0003!\u0011XO\u001c8bE2,\u0007\u0003\u0002\u001d\u0002\f\tL1!!\u0004:\u0005!a$-\u001f8b[\u0016t\u0004bBA\t3\u0001\u0007\u00111C\u0001\u0010Kb\u0004Xm\u0019;fI6+7o]1hKB!\u0011QCA\u0012\u001d\u0011\t9\"a\b\u0011\u0007\u0005e\u0011(\u0004\u0002\u0002\u001c)\u0019\u0011QD\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\t\t#O\u0001\u0007!J,G-\u001a4\n\u0007I\u000b)CC\u0002\u0002\"e\nQ\u0006^3ti\u0006cG/\u001a:DY&,g\u000e^)v_R\f7/\u00138wC2LG-\u00128uSRL8i\\7cS:\fG/[8oQ\tQb-\u0001\u000euKN$\u0018\t\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:CC\u0012L\u0005\u000f\u000b\u0002\u001cM\u0006\u0001D/Z:u\t\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:J]Z\fG.\u001b3GS2$XM]\"p[\nLg.\u0019;j_:D#\u0001\b4\u0002/5\fGo\u00195Vg\u0016\u00148\t\\5f]R,e\u000e^5uS\u0016\u001cXCAA\u001c!\u0019\tI$a\u0011\u0002H5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011I\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002F\u0005m\"\u0001\u0002'jgR\u0004r\u0001OA%\u0003\u001b\n9'C\u0002\u0002Le\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA(\u0003Gj!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0006cV|G/\u0019\u0006\u0005\u0003/\nI&\u0001\u0004d_6lwN\u001c\u0006\u0004i\u0005m#\u0002BA/\u0003?\na!\u00199bG\",'BAA1\u0003\ry'oZ\u0005\u0005\u0003K\n\tFA\tDY&,g\u000e^)v_R\fWI\u001c;jif\u00042\u0001OA5\u0013\r\tY'\u000f\u0002\u0007\t>,(\r\\3\u000215\fGo\u00195Vg\u0016\u00148\t\\5f]R,e\u000e^5uS\u0016\u001c\b%A\bnCR\u001c\u0007.\u00139F]RLG/[3t\u0003Ai\u0017\r^2i\u0013B,e\u000e^5uS\u0016\u001c\b%\u0001\u0012tKR,\b\u000fR3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001cX*\u0019;dQR+7\u000f^\u0001#i\u0016\u001cH\u000fR3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001cX*\u0019;dQ\u0016C\u0018m\u0019;)\u0005\t2\u0017\u0001\n;fgR$Um]2sS\n,7\t\\5f]R\fVo\u001c;bg6\u000bGo\u00195QCJ$\u0018.\u00197)\u0005\r2\u0017A\n;fgR\u001cE.[3oiF+x\u000e^1t+:\u001cX\u000f\u001d9peR,G-\u00128uSRLH+\u001f9fg\"\u0012AEZ\u0001\u001ai\u0016\u001cHo\u00117jK:$\u0018+^8uCN\u001c\u0016M\\5uSj,G\r\u000b\u0002&M\u0006yB/Z:u\u00072LWM\u001c;Rk>$\u0018m],ji\"$UMZ1vYRt\u0015-\\3)\u0005\u00192\u0017A\u0007<fe&4\u0017\u0010R3tGJL'-Z#oi&$\u00180U;pi\u0006\u001cH#\u00022\u0002\u000e\u0006E\u0005bBAHO\u0001\u0007\u0011QJ\u0001\u0007K:$\u0018\u000e^=\t\u000f\u0005Mu\u00051\u0001\u0002\u0016\u00061\u0011/^8uCN\u0004\u0002\"!\u0006\u0002\u0018\u0006M\u0011qM\u0005\u0005\u00033\u000b)CA\u0002NCB\fa\u0002^8DY&,g\u000e^#oi&$\u0018\u0010\u0006\u0004\u0002N\u0005}\u0015\u0011\u0016\u0005\b\u0003CC\u0003\u0019AAR\u0003\u0011)8/\u001a:\u0011\u000ba\n)+a\u0005\n\u0007\u0005\u001d\u0016H\u0001\u0004PaRLwN\u001c\u0005\b\u0003WC\u0003\u0019AAR\u0003!\u0019G.[3oi&#\u0017A\u0003;p\u0013B,e\u000e^5usR!\u0011QJAY\u0011\u001d\t\u0019,\u000ba\u0001\u0003G\u000b!!\u001b9\u0002\u001dQ|G+\u001a8b]R,e\u000e^5usR!\u0011QJA]\u0011\u001d\tYL\u000ba\u0001\u0003G\u000ba\u0001^3oC:$\u0018\u0001\u00063fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7\u000f\u0006\u0003\u0002B\u0006E\u0007\u0003CAb\u0003\u0013\fi%a3\u000e\u0005\u0005\u0015'bAAd\u001f\u0006!Q\u000f^5m\u0013\u0011\tI*!2\u0011\u0011\u0005\r\u0017\u0011ZA\n\u0003\u001b\u00042\u0001TAh\u0013\r\tY'\u0014\u0005\b\u0003'\\\u0003\u0019AAk\u0003\u00191\u0017\u000e\u001c;feB!\u0011qJAl\u0013\u0011\tI.!\u0015\u0003#\rc\u0017.\u001a8u#V|G/\u0019$jYR,'/A\u0010tK:$G)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCN\u0014V-];fgR$B!a8\u0002lB!\u0011\u0011]At\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006U\u0013\u0001\u0003:fcV,7\u000f^:\n\t\u0005%\u00181\u001d\u0002\u001d\t\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:SKN\u0004xN\\:f\u0011\u001d\t\u0019\u000e\fa\u0001\u0003+\f\u0011#\u00197uKJ,e\u000e^5usF+x\u000e^1t)!\t\t0a>\u0002z\n\u0005\u0001c\u0001'\u0002t&\u0019\u0011Q_'\u0003\tY{\u0017\u000e\u001a\u0005\b\u0003\u001fk\u0003\u0019AA'\u0011\u001d\tY0\fa\u0001\u0003{\fQ!\u00197uKJ\u0004\u0002\"!\u0006\u0002\u0018\u0006M\u0011q \t\u0006q\u0005\u0015\u0016q\r\u0005\b\u0005\u0007i\u0003\u0019\u0001B\u0003\u000311\u0018\r\\5eCR,wJ\u001c7z!\rA$qA\u0005\u0004\u0005\u0013I$a\u0002\"p_2,\u0017M\\\u0001\u0012C2$XM]\"mS\u0016tG/U;pi\u0006\u001cHC\u0002B\b\u0005K\u0011Y\u0003\u0005\u0005\u0003\u0012\t]\u0011Q\nB\r\u001b\t\u0011\u0019B\u0003\u0003\u0003\u0016\u0005}\u0012aB7vi\u0006\u0014G.Z\u0005\u0005\u00033\u0013\u0019\u0002\u0005\u0004\u0003\u001c\t\u0005\u0012\u0011_\u0007\u0003\u0005;QAAa\b\u0002V\u0005I\u0011N\u001c;fe:\fGn]\u0005\u0005\u0005G\u0011iBA\bLC\u001a\\\u0017MR;ukJ,\u0017*\u001c9m\u0011\u001d\u00119C\fa\u0001\u0005S\tqA]3rk\u0016\u001cH\u000f\u0005\u0005\u0002\u0016\u0005]\u0015QJA\u007f\u0011\u001d\u0011\u0019A\fa\u0001\u0005\u000b\tAd]3oI\u0006cG/\u001a:DY&,g\u000e^)v_R\f7OU3rk\u0016\u001cH\u000f\u0006\u0004\u00032\t]\"1\u000b\t\u0005\u0003C\u0014\u0019$\u0003\u0003\u00036\u0005\r(!G!mi\u0016\u00148\t\\5f]R\fVo\u001c;bgJ+7\u000f]8og\u0016DqA!\u000f0\u0001\u0004\u0011Y$A\u0004f]R\u0014\u0018.Z:\u0011\r\tu\"q\tB'\u001d\u0011\u0011yDa\u0011\u000f\t\u0005e!\u0011I\u0005\u0002u%\u0019!QI\u001d\u0002\u000fA\f7m[1hK&!!\u0011\nB&\u0005!IE/\u001a:bE2,'b\u0001B#sA!\u0011q\nB(\u0013\u0011\u0011\t&!\u0015\u0003+\rc\u0017.\u001a8u#V|G/Y!mi\u0016\u0014\u0018\r^5p]\"9!1A\u0018A\u0002\t\u0015\u0001F\u0002\u0001\u0003XA\u0014i\u0006E\u0002h\u00053J1Aa\u0017i\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;tI\t\u0011y&C\u0002\u0003bQ\f!#\u0011'M?:{ejX\"P%\u0016\u001b\u0016\nR#O)\":\u0001A!\u001a\u0003~\t}\u0004\u0003\u0002B4\u0005sj!A!\u001b\u000b\t\t-$QN\u0001\nKb$XM\\:j_:TAAa\u001c\u0003r\u0005\u0019\u0011\r]5\u000b\t\tM$QO\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u00119(a\u0018\u0002\u000b),h.\u001b;\n\t\tm$\u0011\u000e\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,GF\u0001BAG\t\u0011\u0019\t\u0005\u0003\u0003\u0006\n%UB\u0001BD\u0015\r\u00119\bQ\u0005\u0005\u0005\u0017\u00139IA\u000bDYV\u001cH/\u001a:UKN$X\t\u001f;f]NLwN\\:)\u000f\u0001\u0011yI! \u0003\u0018B!!\u0011\u0013BJ\u001b\t\u0011i'\u0003\u0003\u0003\u0016\n5$a\u0001+bO\u0006\u0012!\u0011T\u0001\fS:$Xm\u001a:bi&|g\u000e")
public class ClientQuotasRequestTest {
    private final ClusterInstance cluster;
    private final String ConsumerByteRateProp;
    private final String ProducerByteRateProp;
    private final String RequestPercentageProp;
    private final String IpConnectionRateProp;
    private final String TenantConnectionRateProp;
    private final String TenantProducerIdExpirationMs;
    private final String TenantConnectionCountProp;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities;
    private final List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities;

    private String ConsumerByteRateProp() {
        return this.ConsumerByteRateProp;
    }

    private String ProducerByteRateProp() {
        return this.ProducerByteRateProp;
    }

    private String RequestPercentageProp() {
        return this.RequestPercentageProp;
    }

    private String IpConnectionRateProp() {
        return this.IpConnectionRateProp;
    }

    private String TenantConnectionRateProp() {
        return this.TenantConnectionRateProp;
    }

    private String TenantProducerIdExpirationMs() {
        return this.TenantProducerIdExpirationMs;
    }

    private String TenantConnectionCountProp() {
        return this.TenantConnectionCountProp;
    }

    @ClusterTest
    public void testAlterClientQuotasRequest() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-id")}))).asJava());
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)15000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)15000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)None$.MODULE$)}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)5000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)5000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.3)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)12.3))}))));
    }

    @ClusterTest
    public void testAlterClientQuotasRequestValidateOnly() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)23.45)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0)))}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)None$.MODULE$)}))), true);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)BoxesRunTime.boxToDouble((double)23.45))}))));
    }

    @ClusterTest(clusterType=Type.ZK)
    public void testClientQuotasForScramUsers() {
        String userName = "user";
        this.cluster.createAdminClient().alterUserScramCredentials(Arrays.asList(new UserScramCredentialUpsertion(userName, new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 4096), "password"))).all().get();
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)userName)}))).asJava());
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ConsumerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
    }

    @ClusterTest
    public void testAlterIpQuotasRequest() {
        String knownHost = "1.2.3.4";
        String unknownHost = "2.3.4.5";
        ClientQuotaEntity entity = this.toIpEntity((Option<String>)new Some((Object)knownHost));
        ClientQuotaEntity defaultEntity = this.toIpEntity((Option<String>)new Some(null));
        ClientQuotaFilterComponent entityFilter = ClientQuotaFilterComponent.ofEntity((String)"ip", (String)knownHost);
        ClientQuotaFilterComponent defaultEntityFilter = ClientQuotaFilterComponent.ofDefaultEntity((String)"ip");
        ClientQuotaFilterComponent allIpEntityFilter = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)100.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)100.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)150.0)))}))), false);
        this.verifyIpQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0))})), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)200.0)))}))), false);
        this.verifyIpQuotas$1(defaultEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.verifyIpQuotas$1(allIpEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})), unknownHost);
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(entityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyIpQuotas$1(allIpEntityFilter, Predef$.MODULE$.Map().empty(), unknownHost);
    }

    @ClusterTest
    public void testAlterTenantQuotasConnectionRateRequest() {
        String tenant = "lkc-1234";
        ClientQuotaEntity entity = this.toTenantEntity((Option<String>)new Some((Object)tenant));
        ClientQuotaEntity defaultEntity = this.toTenantEntity((Option<String>)new Some(null));
        ClientQuotaFilterComponent entityFilter = ClientQuotaFilterComponent.ofEntity((String)"confluent-tenant", (String)tenant);
        ClientQuotaFilterComponent defaultEntityFilter = ClientQuotaFilterComponent.ofDefaultEntity((String)"confluent-tenant");
        ClientQuotaFilterComponent allTenantEntityFilter = ClientQuotaFilterComponent.ofEntityType((String)"confluent-tenant");
        this.verifyTenantQuotas$1(allTenantEntityFilter, Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)100.0)))}))), false);
        this.verifyTenantQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)100.0))})));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)150.0)))}))), false);
        this.verifyTenantQuotas$1(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0))})));
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)200.0)))}))), false);
        this.verifyTenantQuotas$1(defaultEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})));
        this.verifyTenantQuotas$1(allTenantEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyTenantQuotas$1(entityFilter, Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionRateProp()), (Object)None$.MODULE$)}))), false);
        this.verifyTenantQuotas$1(allTenantEntityFilter, Predef$.MODULE$.Map().empty());
    }

    @ClusterTest
    public void testAlterTenantQuotasProducerIdExpirationMsRequest() {
        String tenant = "lkc-1234";
        ClientQuotaEntity entity = this.toTenantEntity((Option<String>)new Some((Object)tenant));
        ClientQuotaEntity defaultEntity = this.toTenantEntity((Option<String>)new Some(null));
        ClientQuotaFilterComponent entityFilter = ClientQuotaFilterComponent.ofEntity((String)"confluent-tenant", (String)tenant);
        ClientQuotaFilterComponent defaultEntityFilter = ClientQuotaFilterComponent.ofDefaultEntity((String)"confluent-tenant");
        ClientQuotaFilterComponent allTenantEntityFilter = ClientQuotaFilterComponent.ofEntityType((String)"confluent-tenant");
        this.verifyTenantQuotas$2(allTenantEntityFilter, Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantProducerIdExpirationMs()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)100.0)))}))), false);
        this.verifyTenantQuotas$2(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)100.0))})));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantProducerIdExpirationMs()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)150.0)))}))), false);
        this.verifyTenantQuotas$2(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0))})));
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantProducerIdExpirationMs()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)200.0)))}))), false);
        this.verifyTenantQuotas$2(defaultEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})));
        this.verifyTenantQuotas$2(allTenantEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantProducerIdExpirationMs()), (Object)None$.MODULE$)}))), false);
        this.verifyTenantQuotas$2(entityFilter, Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantProducerIdExpirationMs()), (Object)None$.MODULE$)}))), false);
        this.verifyTenantQuotas$2(allTenantEntityFilter, Predef$.MODULE$.Map().empty());
    }

    @ClusterTest
    public void testAlterTenantQuotasConnectionCountRequest() {
        String tenant = "lkc-1234";
        ClientQuotaEntity entity = this.toTenantEntity((Option<String>)new Some((Object)tenant));
        ClientQuotaEntity defaultEntity = this.toTenantEntity((Option<String>)new Some(null));
        ClientQuotaFilterComponent entityFilter = ClientQuotaFilterComponent.ofEntity((String)"confluent-tenant", (String)tenant);
        ClientQuotaFilterComponent defaultEntityFilter = ClientQuotaFilterComponent.ofDefaultEntity((String)"confluent-tenant");
        ClientQuotaFilterComponent allTenantEntityFilter = ClientQuotaFilterComponent.ofEntityType((String)"confluent-tenant");
        this.verifyTenantQuotas$3(allTenantEntityFilter, Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionCountProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)100.0)))}))), false);
        this.verifyTenantQuotas$3(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)100.0))})));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionCountProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)150.0)))}))), false);
        this.verifyTenantQuotas$3(entityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0))})));
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionCountProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)200.0)))}))), false);
        this.verifyTenantQuotas$3(defaultEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})));
        this.verifyTenantQuotas$3(allTenantEntityFilter, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultEntity), (Object)BoxesRunTime.boxToDouble((double)200.0))})));
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionCountProp()), (Object)None$.MODULE$)}))), false);
        this.verifyTenantQuotas$3(entityFilter, Predef$.MODULE$.Map().empty());
        this.alterEntityQuotas(defaultEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TenantConnectionCountProp()), (Object)None$.MODULE$)}))), false);
        this.verifyTenantQuotas$3(allTenantEntityFilter, Predef$.MODULE$.Map().empty());
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidRequests() {
        ObjectRef entity = ObjectRef.create((Object)new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"")}))).asJava()));
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"name")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)))}))), true));
        entity.elem = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user")}))).asJava());
        Assertions.assertThrows(InvalidRequestException.class, () -> this.alterEntityQuotas((ClientQuotaEntity)entity$1.elem, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)10000.5)))}))), true));
    }

    private void expectInvalidRequestWithMessage(Function0<BoxedUnit> runnable, String expectedMessage) {
        InvalidRequestException exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> runnable.apply$mcV$sp());
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage), (String)new StringBuilder(29).append("Expected message ").append(exception).append(" to contain ").append(expectedMessage).toString());
    }

    @ClusterTest
    public void testAlterClientQuotasInvalidEntityCombination() {
        ClientQuotaEntity userAndIpEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        ClientQuotaEntity clientAndIpEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.2.3.4")}))).asJava());
        String expectedExceptionMessage = "Invalid quota entity combination";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(userAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        Object var4_4 = null;
        Object var5_5 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(clientAndIpEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RequestPercentageProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)12.34)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    @ClusterTest
    public void testAlterClientQuotasBadIp() {
        ClientQuotaEntity invalidHostPatternEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"not a valid host because it has spaces")}))).asJava());
        ClientQuotaEntity unresolvableHostEntity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"RFC2606.invalid")}))).asJava());
        String expectedExceptionMessage = "not a valid IP";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(invalidHostPatternEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        Object var4_4 = null;
        Object var5_5 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.alterEntityQuotas(unresolvableHostEntity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.IpConnectionRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)50.0)))}))), true);
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    @ClusterTest
    public void testDescribeClientQuotasInvalidFilterCombination() {
        ClientQuotaFilterComponent ipFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        ClientQuotaFilterComponent userFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"user");
        ClientQuotaFilterComponent clientIdFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"client-id");
        String expectedExceptionMessage = "Invalid entity filter component combination";
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable = (JFunction0.mcV.sp & Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ipFilterComponent, (List)new .colon.colon((Object)userFilterComponent, (List)Nil$.MODULE$))).asJava()));
        InvalidRequestException expectInvalidRequestWithMessage_exception = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception).append(" to contain ").append(expectedExceptionMessage).toString());
        Object var5_5 = null;
        Object var6_6 = null;
        JFunction0.mcV.sp & Serializable expectInvalidRequestWithMessage_runnable2 = (JFunction0.mcV.sp & Serializable)() -> this.describeClientQuotas(ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ipFilterComponent, (List)new .colon.colon((Object)clientIdFilterComponent, (List)Nil$.MODULE$))).asJava()));
        InvalidRequestException expectInvalidRequestWithMessage_exception2 = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> ClientQuotasRequestTest.$anonfun$expectInvalidRequestWithMessage$1((Function0)expectInvalidRequestWithMessage_runnable2));
        Assertions.assertTrue((boolean)expectInvalidRequestWithMessage_exception2.getMessage().contains(expectedExceptionMessage), (String)new StringBuilder(29).append("Expected message ").append(expectInvalidRequestWithMessage_exception2).append(" to contain ").append(expectedExceptionMessage).toString());
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchUserClientEntities() {
        return this.matchUserClientEntities;
    }

    private List<Tuple2<ClientQuotaEntity, Object>> matchIpEntities() {
        return this.matchIpEntities;
    }

    private void setupDescribeClientQuotasMatchTest() {
        scala.collection.immutable.Map userClientQuotas = this.matchUserClientEntities().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
                double v = x0$1._2$mcD$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.RequestPercentageProp(), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map ipQuotas = this.matchIpEntities().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ClientQuotaEntity e = (ClientQuotaEntity)x0$2._1();
                double v = x0$2._2$mcD$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.IpConnectionRateProp(), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)v)))})));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> result = this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)((scala.collection.immutable.Map)userClientQuotas.$plus$plus((IterableOnce)ipQuotas)), false);
        ((List)this.matchUserClientEntities().$plus$plus(this.matchIpEntities())).foreach((Function1 & Serializable)e -> (Void)((KafkaFutureImpl)result.apply(e._1())).get(10L, TimeUnit.SECONDS));
    }

    @ClusterTest
    public void testDescribeClientQuotasMatchExact() {
        this.setupDescribeClientQuotasMatchTest();
        this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-2")), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-1")), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-2"), (Object)new Some(null)), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"user-4"), (Object)None$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)new Some(null), (Object)new Some((Object)"client-id-2")), (List)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-1")), (List)new .colon.colon((Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"client-id-3")), (List)Nil$.MODULE$))))))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Option u = (Option)x0$2._1();
                Option c = (Option)x0$2._2();
                return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)Option$.MODULE$.option2Iterable(u.map((Function1 & Serializable)x$1 -> new Tuple2((Object)"user", x$1))).$plus$plus((IterableOnce)c.map((Function1 & Serializable)x$2 -> new Tuple2((Object)"client-id", x$2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
            }
            throw new MatchError(null);
        }).foreach((Function1 & Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$7(this, e);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testDescribeClientQuotasMatchPartial() {
        Object var153_120;
        Tuple2 tuple2;
        void testMatchEntities$1_expectedMatchSize;
        void testMatchEntities$1_partition;
        Object var140_110;
        Tuple2 tuple22;
        void testMatchEntities$1_expectedMatchSize2;
        void testMatchEntities$1_partition2;
        Object var127_100;
        Tuple2 tuple23;
        void testMatchEntities$1_expectedMatchSize3;
        void testMatchEntities$1_partition3;
        Object var114_90;
        Tuple2 tuple24;
        void testMatchEntities$1_expectedMatchSize4;
        void testMatchEntities$1_partition4;
        Object var101_80;
        Tuple2 tuple25;
        void testMatchEntities$1_expectedMatchSize5;
        void testMatchEntities$1_partition5;
        Object var88_70;
        Tuple2 tuple26;
        void testMatchEntities$1_expectedMatchSize6;
        void testMatchEntities$1_partition6;
        Object var75_60;
        Tuple2 tuple27;
        void testMatchEntities$1_expectedMatchSize7;
        void testMatchEntities$1_partition7;
        Object var62_50;
        Tuple2 tuple28;
        void testMatchEntities$1_expectedMatchSize8;
        void testMatchEntities$1_partition8;
        Object var49_40;
        Tuple2 tuple29;
        void testMatchEntities$1_expectedMatchSize9;
        void testMatchEntities$1_partition9;
        Object var36_30;
        Tuple2 tuple210;
        void testMatchEntities$1_expectedMatchSize10;
        void testMatchEntities$1_partition10;
        Object var23_20;
        Tuple2 tuple211;
        void testMatchEntities$1_expectedMatchSize11;
        void testMatchEntities$1_partition11;
        Object var10_10;
        Tuple2 tuple212;
        void testMatchEntities$1_partition12;
        this.setupDescribeClientQuotasMatchTest();
        Function1 & Serializable intersect = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$5(entity));
        int testMatchEntities$1_expectedMatchSize12 = 3;
        ClientQuotaFilter testMatchEntities$1_filter = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-1"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect2 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter, (Function1)testMatchEntities$1_partition12, testMatchEntities$1_expectedMatchSize12);
        long l = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple212 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime + testMatchEntities$1_tryUntilNoAssertionError_waitTime) {
                tuple212 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var13_8 = null;
        Tuple2 tuple213 = tuple212;
        if (tuple213 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either = (Either)tuple213._1();
        tuple213._2$mcZ$sp();
        if (!(var10_10 instanceof Left)) {
            if (var10_10 instanceof Right) {
                throw (AssertionError)((Right)var10_10).value();
            }
            throw new MatchError((Object)var10_10);
        }
        ((Left)var10_10).value();
        intersect2 = null;
        tuple213 = null;
        var10_10 = null;
        Object var1_3 = null;
        intersect = null;
        Function1 & Serializable intersect3 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$6(entity));
        boolean bl = false;
        ClientQuotaFilter testMatchEntities$1_filter2 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"unknown"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect4 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter2, (Function1)testMatchEntities$1_partition11, (int)testMatchEntities$1_expectedMatchSize11);
        long l2 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime2 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple211 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime2 + testMatchEntities$1_tryUntilNoAssertionError_waitTime2) {
                tuple211 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime2), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var26_18 = null;
        Tuple2 tuple214 = tuple211;
        if (tuple214 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either2 = (Either)tuple214._1();
        tuple214._2$mcZ$sp();
        if (!(var23_20 instanceof Left)) {
            if (var23_20 instanceof Right) {
                throw (AssertionError)((Right)var23_20).value();
            }
            throw new MatchError((Object)var23_20);
        }
        ((Left)var23_20).value();
        intersect4 = null;
        tuple214 = null;
        var23_20 = null;
        Object var14_13 = null;
        intersect3 = null;
        Function1 & Serializable intersect5 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$7(entity));
        int n = 2;
        ClientQuotaFilter testMatchEntities$1_filter3 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-2"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect6 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter3, (Function1)testMatchEntities$1_partition10, (int)testMatchEntities$1_expectedMatchSize10);
        long l3 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime3 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple210 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime3 + testMatchEntities$1_tryUntilNoAssertionError_waitTime3) {
                tuple210 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime3), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var39_28 = null;
        Tuple2 tuple215 = tuple210;
        if (tuple215 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either3 = (Either)tuple215._1();
        tuple215._2$mcZ$sp();
        if (!(var36_30 instanceof Left)) {
            if (var36_30 instanceof Right) {
                throw (AssertionError)((Right)var36_30).value();
            }
            throw new MatchError((Object)var36_30);
        }
        ((Left)var36_30).value();
        intersect6 = null;
        tuple215 = null;
        var36_30 = null;
        Object var27_23 = null;
        intersect5 = null;
        Function1 & Serializable intersect7 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$8(entity));
        int n2 = 2;
        ClientQuotaFilter testMatchEntities$1_filter4 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect8 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter4, (Function1)testMatchEntities$1_partition9, (int)testMatchEntities$1_expectedMatchSize9);
        long l4 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime4 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime4 + testMatchEntities$1_tryUntilNoAssertionError_waitTime4) {
                tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime4), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var52_38 = null;
        Tuple2 tuple216 = tuple29;
        if (tuple216 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either4 = (Either)tuple216._1();
        tuple216._2$mcZ$sp();
        if (!(var49_40 instanceof Left)) {
            if (var49_40 instanceof Right) {
                throw (AssertionError)((Right)var49_40).value();
            }
            throw new MatchError((Object)var49_40);
        }
        ((Left)var49_40).value();
        intersect8 = null;
        tuple216 = null;
        var49_40 = null;
        Object var40_33 = null;
        intersect7 = null;
        Function1 & Serializable intersect9 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$9(entity));
        boolean bl2 = true;
        ClientQuotaFilter testMatchEntities$1_filter5 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user-2"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect10 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter5, (Function1)testMatchEntities$1_partition8, (int)testMatchEntities$1_expectedMatchSize8);
        long l5 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime5 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime5 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime5 + testMatchEntities$1_tryUntilNoAssertionError_waitTime5) {
                tuple28 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime5), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var65_48 = null;
        Tuple2 tuple217 = tuple28;
        if (tuple217 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either5 = (Either)tuple217._1();
        tuple217._2$mcZ$sp();
        if (!(var62_50 instanceof Left)) {
            if (var62_50 instanceof Right) {
                throw (AssertionError)((Right)var62_50).value();
            }
            throw new MatchError((Object)var62_50);
        }
        ((Left)var62_50).value();
        intersect10 = null;
        tuple217 = null;
        var62_50 = null;
        Object var53_43 = null;
        intersect9 = null;
        Function1 & Serializable intersect11 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$10(entity));
        boolean bl3 = false;
        ClientQuotaFilter testMatchEntities$1_filter6 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"client-id-1"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect12 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter6, (Function1)testMatchEntities$1_partition7, (int)testMatchEntities$1_expectedMatchSize7);
        long l6 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime6 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime6 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime6 + testMatchEntities$1_tryUntilNoAssertionError_waitTime6) {
                tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime6), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var78_58 = null;
        Tuple2 tuple218 = tuple27;
        if (tuple218 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either6 = (Either)tuple218._1();
        tuple218._2$mcZ$sp();
        if (!(var75_60 instanceof Left)) {
            if (var75_60 instanceof Right) {
                throw (AssertionError)((Right)var75_60).value();
            }
            throw new MatchError((Object)var75_60);
        }
        ((Left)var75_60).value();
        intersect12 = null;
        tuple218 = null;
        var75_60 = null;
        Object var66_53 = null;
        intersect11 = null;
        Function1 & Serializable intersect13 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$11(entity));
        int n3 = 4;
        ClientQuotaFilter testMatchEntities$1_filter7 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect14 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter7, (Function1)testMatchEntities$1_partition6, (int)testMatchEntities$1_expectedMatchSize6);
        long l7 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime7 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime7 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime7 + testMatchEntities$1_tryUntilNoAssertionError_waitTime7) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime7), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var91_68 = null;
        Tuple2 tuple219 = tuple26;
        if (tuple219 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either7 = (Either)tuple219._1();
        tuple219._2$mcZ$sp();
        if (!(var88_70 instanceof Left)) {
            if (var88_70 instanceof Right) {
                throw (AssertionError)((Right)var88_70).value();
            }
            throw new MatchError((Object)var88_70);
        }
        ((Left)var88_70).value();
        intersect14 = null;
        tuple219 = null;
        var88_70 = null;
        Object var79_63 = null;
        intersect13 = null;
        Function1 & Serializable intersect15 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$12(entity));
        int n4 = 10;
        ClientQuotaFilter testMatchEntities$1_filter8 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect16 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter8, (Function1)testMatchEntities$1_partition5, (int)testMatchEntities$1_expectedMatchSize5);
        long l8 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime8 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime8 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime8 + testMatchEntities$1_tryUntilNoAssertionError_waitTime8) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime8), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var104_78 = null;
        Tuple2 tuple220 = tuple25;
        if (tuple220 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either8 = (Either)tuple220._1();
        tuple220._2$mcZ$sp();
        if (!(var101_80 instanceof Left)) {
            if (var101_80 instanceof Right) {
                throw (AssertionError)((Right)var101_80).value();
            }
            throw new MatchError((Object)var101_80);
        }
        ((Left)var101_80).value();
        intersect16 = null;
        tuple220 = null;
        var101_80 = null;
        Object var92_73 = null;
        intersect15 = null;
        Function1 & Serializable intersect17 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$13(entity));
        boolean bl4 = true;
        ClientQuotaFilter testMatchEntities$1_filter9 = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"client-id"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect18 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter9, (Function1)testMatchEntities$1_partition4, (int)testMatchEntities$1_expectedMatchSize4);
        long l9 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime9 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime9 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime9 + testMatchEntities$1_tryUntilNoAssertionError_waitTime9) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime9), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var117_88 = null;
        Tuple2 tuple221 = tuple24;
        if (tuple221 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either9 = (Either)tuple221._1();
        tuple221._2$mcZ$sp();
        if (!(var114_90 instanceof Left)) {
            if (var114_90 instanceof Right) {
                throw (AssertionError)((Right)var114_90).value();
            }
            throw new MatchError((Object)var114_90);
        }
        ((Left)var114_90).value();
        intersect18 = null;
        tuple221 = null;
        var114_90 = null;
        Object var105_83 = null;
        intersect17 = null;
        Function1 & Serializable intersect19 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$14(entity));
        int n5 = 7;
        ClientQuotaFilter testMatchEntities$1_filter10 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"client-id"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect20 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter10, (Function1)testMatchEntities$1_partition3, (int)testMatchEntities$1_expectedMatchSize3);
        long l10 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime10 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime10 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime10 + testMatchEntities$1_tryUntilNoAssertionError_waitTime10) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime10), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var130_98 = null;
        Tuple2 tuple222 = tuple23;
        if (tuple222 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either10 = (Either)tuple222._1();
        tuple222._2$mcZ$sp();
        if (!(var127_100 instanceof Left)) {
            if (var127_100 instanceof Right) {
                throw (AssertionError)((Right)var127_100).value();
            }
            throw new MatchError((Object)var127_100);
        }
        ((Left)var127_100).value();
        intersect20 = null;
        tuple222 = null;
        var127_100 = null;
        Object var118_93 = null;
        intersect19 = null;
        Function1 & Serializable intersect21 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$15(entity));
        int n6 = 2;
        ClientQuotaFilter testMatchEntities$1_filter11 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntityType((String)"ip"), (List)Nil$.MODULE$)).asJava());
        JFunction0.mcV.sp & Serializable intersect22 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter11, (Function1)testMatchEntities$1_partition2, (int)testMatchEntities$1_expectedMatchSize2);
        long l11 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime11 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime11 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime11 + testMatchEntities$1_tryUntilNoAssertionError_waitTime11) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime11), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var143_108 = null;
        Tuple2 tuple223 = tuple22;
        if (tuple223 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either11 = (Either)tuple223._1();
        tuple223._2$mcZ$sp();
        if (!(var140_110 instanceof Left)) {
            if (var140_110 instanceof Right) {
                throw (AssertionError)((Right)var140_110).value();
            }
            throw new MatchError((Object)var140_110);
        }
        ((Left)var140_110).value();
        intersect22 = null;
        tuple223 = null;
        var140_110 = null;
        Object var131_103 = null;
        intersect21 = null;
        Function1 & Serializable intersect23 = (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$16(entity));
        int n7 = 13;
        ClientQuotaFilter testMatchEntities$1_filter12 = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        JFunction0.mcV.sp & Serializable intersect24 = () -> ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$1(this, testMatchEntities$1_filter12, (Function1)testMatchEntities$1_partition, (int)testMatchEntities$1_expectedMatchSize);
        long l12 = 100L;
        long testMatchEntities$1_tryUntilNoAssertionError_waitTime12 = 15000L;
        long testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime12 = System.currentTimeMillis();
        while (true) {
            void testMatchEntities$1_tryUntilNoAssertionError_pause;
            void testMatchEntities$1_tryUntilNoAssertionError_assertions;
            Either testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result;
            if (BoxesRunTime.unboxToBoolean((Object)TestUtils$.$anonfun$tryUntilNoAssertionError$2$adapted(testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)testMatchEntities$1_tryUntilNoAssertionError_assertions)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_startTime12 + testMatchEntities$1_tryUntilNoAssertionError_waitTime12) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testMatchEntities$1_tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(testMatchEntities$1_tryUntilNoAssertionError_waitTime12), (long)testMatchEntities$1_tryUntilNoAssertionError_pause));
        }
        Object var156_118 = null;
        Tuple2 tuple224 = tuple2;
        if (tuple224 == null) {
            throw new MatchError(null);
        }
        Either testMatchEntities$1_tryUntilNoAssertionError_either12 = (Either)tuple224._1();
        tuple224._2$mcZ$sp();
        if (!(var153_120 instanceof Left)) {
            if (var153_120 instanceof Right) {
                throw (AssertionError)((Right)var153_120).value();
            }
            throw new MatchError((Object)var153_120);
        }
        ((Left)var153_120).value();
        intersect24 = null;
        tuple224 = null;
        var153_120 = null;
        Object var144_113 = null;
        intersect23 = null;
        this.testMatchEntities$1(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()), 0, (Function1 & Serializable)entity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$17(entity)));
    }

    @ClusterTest
    public void testClientQuotasUnsupportedEntityTypes() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"name")}))).asJava());
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty()));
    }

    @ClusterTest
    public void testClientQuotasSanitized() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user with spaces")}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
    }

    @ClusterTest
    public void testClientQuotasWithDefaultName() {
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)ConfigEntityName$.MODULE$.Default())}))).asJava());
        this.alterEntityQuotas(entity, (scala.collection.immutable.Map<String, Option<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)20000.0)))}))), false);
        this.verifyDescribeEntityQuotas(entity, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ProducerByteRateProp()), (Object)BoxesRunTime.boxToDouble((double)20000.0))}))));
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"client-id"), (List)Nil$.MODULE$)).asJava()));
        Predef$.MODULE$.assert(result.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private void verifyDescribeEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Object> quotas) {
        void var8_11;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 5000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                ClientQuotasRequestTest.$anonfun$verifyDescribeEntityQuotas$1(this, entity, quotas);
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var12_7 = null;
            Object var13_8 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        tuple22._2$mcZ$sp();
        if (var8_11 instanceof Left) {
            ((Left)var8_11).value();
            return;
        }
        if (var8_11 instanceof Right) {
            throw (AssertionError)((Right)var8_11).value();
        }
        throw new MatchError((Object)var8_11);
    }

    private ClientQuotaEntity toClientEntity(Option<String> user, Option<String> clientId) {
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)Option$.MODULE$.option2Iterable(user.map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), x$3))).$plus$plus((IterableOnce)clientId.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), x$4)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private ClientQuotaEntity toIpEntity(Option<String> ip) {
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Option$.MODULE$.option2Iterable(ip.map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), x$5))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private ClientQuotaEntity toTenantEntity(Option<String> tenant) {
        return new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Option$.MODULE$.option2Iterable(tenant.map((Function1 & Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent-tenant"), x$6))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    private java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describeClientQuotas(ClientQuotaFilter filter) {
        KafkaFutureImpl result = new KafkaFutureImpl();
        this.sendDescribeClientQuotasRequest(filter).complete(result);
        try {
            return (java.util.Map)result.get();
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private DescribeClientQuotasResponse sendDescribeClientQuotasRequest(ClientQuotaFilter filter) {
        DescribeClientQuotasRequest request = (DescribeClientQuotasRequest)new DescribeClientQuotasRequest.Builder(filter).build();
        return (DescribeClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(DescribeClientQuotasResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Void alterEntityQuotas(ClientQuotaEntity entity, scala.collection.immutable.Map<String, Option<Object>> alter, boolean validateOnly) {
        try {
            return (Void)((KafkaFutureImpl)this.alterClientQuotas((scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), alter)}))), validateOnly).get((Object)entity).get()).get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, KafkaFutureImpl<Void>> alterClientQuotas(scala.collection.immutable.Map<ClientQuotaEntity, scala.collection.immutable.Map<String, Option<Object>>> request, boolean validateOnly) {
        scala.collection.immutable.Iterable entries = (scala.collection.immutable.Iterable)request.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
                scala.collection.immutable.Map alter = (scala.collection.immutable.Map)x0$1._2();
                Collection ops = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)alter.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String key = (String)x0$2._1();
                        Option value = (Option)x0$2._2();
                        return new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable)x -> ClientQuotasRequestTest.$anonfun$alterClientQuotas$3(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(null);
                })).asJavaCollection();
                return new ClientQuotaAlteration(entity, ops);
            }
            throw new MatchError(null);
        });
        java.util.Map response = CollectionConverters$.MODULE$.MapHasAsJava((Map)request.map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), (Object)new KafkaFutureImpl()))).asJava();
        this.sendAlterClientQuotasRequest((Iterable<ClientQuotaAlteration>)entries, validateOnly).complete(response);
        scala.collection.mutable.Map result = CollectionConverters$.MODULE$.MapHasAsScala(response).asScala();
        Assertions.assertEquals((int)request.size(), (int)result.size());
        request.foreach((Function1 & Serializable)e -> {
            ClientQuotasRequestTest.$anonfun$alterClientQuotas$5(result, e);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    private AlterClientQuotasResponse sendAlterClientQuotasRequest(Iterable<ClientQuotaAlteration> entries, boolean validateOnly) {
        AlterClientQuotasRequest request = (AlterClientQuotasRequest)new AlterClientQuotasRequest.Builder(CollectionConverters$.MODULE$.IterableHasAsJava(entries).asJavaCollection(), validateOnly).build();
        return (AlterClientQuotasResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), ClassTag$.MODULE$.apply(AlterClientQuotasResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ void $anonfun$testAlterIpQuotasRequest$2(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatches$1, String unknownHost$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            java.util.Map props = (java.util.Map)x0$1._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.IpConnectionRateProp()})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(props).asScala().keySet());
            Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity)), (Double)((Double)props.get($this.IpConnectionRateProp())));
            String entityName = (String)entity.entries().get("ip");
            InetAddress entityIp = entityName == null ? InetAddress.getByName(unknownHost$1) : InetAddress.getByName(entityName);
            double currentServerQuota = ((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.brokerSocketServers()).asScala().head()).connectionQuotas().ipConnectionQuota().maxConnectionRate((Object)entityIp);
            Assertions.assertTrue((Math.abs(BoxesRunTime.unboxToDouble((Object)expectedMatches$1.apply((Object)entity)) - currentServerQuota) < 0.01 ? 1 : 0) != 0, (String)new StringBuilder(33).append("Connection quota of ").append(entity).append(" is not ").append(expectedMatches$1.apply((Object)entity)).append(" but ").append(currentServerQuota).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAlterIpQuotasRequest$1(ClientQuotasRequestTest $this, ClientQuotaFilterComponent entityFilter$1, scala.collection.immutable.Map expectedMatches$1, String unknownHost$1) {
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entityFilter$1, (List)Nil$.MODULE$)).asJava()));
        Assertions.assertEquals((Object)expectedMatches$1.keySet(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().keySet());
        CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$2($this, expectedMatches$1, unknownHost$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyIpQuotas$1(ClientQuotaFilterComponent entityFilter, scala.collection.immutable.Map expectedMatches, String unknownHost$1) {
        void var9_12;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                ClientQuotasRequestTest.$anonfun$testAlterIpQuotasRequest$1(this, entityFilter, expectedMatches, unknownHost$1);
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var13_8 = null;
            Object var14_9 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        tuple22._2$mcZ$sp();
        if (var9_12 instanceof Left) {
            ((Left)var9_12).value();
            return;
        }
        if (var9_12 instanceof Right) {
            throw (AssertionError)((Right)var9_12).value();
        }
        throw new MatchError((Object)var9_12);
    }

    public static final /* synthetic */ void $anonfun$testAlterTenantQuotasConnectionRateRequest$2(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatches$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            java.util.Map props = (java.util.Map)x0$1._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.TenantConnectionRateProp()})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(props).asScala().keySet());
            Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)expectedMatches$2.apply((Object)entity)), (Double)((Double)props.get($this.TenantConnectionRateProp())));
            String entityName = (String)entity.entries().get("confluent-tenant");
            String entityTenant = entityName == null ? "<default>" : entityName;
            double currentServerQuota = ((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.brokerSocketServers()).asScala().head()).connectionQuotas().tenantConnectionQuota().maxConnectionRate((Object)entityTenant);
            Assertions.assertTrue((Math.abs(BoxesRunTime.unboxToDouble((Object)expectedMatches$2.apply((Object)entity)) - currentServerQuota) < 0.01 ? 1 : 0) != 0, (String)new StringBuilder(33).append("Connection quota of ").append(entity).append(" is not ").append(expectedMatches$2.apply((Object)entity)).append(" but ").append(currentServerQuota).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAlterTenantQuotasConnectionRateRequest$1(ClientQuotasRequestTest $this, ClientQuotaFilterComponent entityFilter$2, scala.collection.immutable.Map expectedMatches$2) {
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entityFilter$2, (List)Nil$.MODULE$)).asJava()));
        Assertions.assertEquals((Object)expectedMatches$2.keySet(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().keySet());
        CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testAlterTenantQuotasConnectionRateRequest$2($this, expectedMatches$2, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyTenantQuotas$1(ClientQuotaFilterComponent entityFilter, scala.collection.immutable.Map expectedMatches) {
        void var8_11;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                ClientQuotasRequestTest.$anonfun$testAlterTenantQuotasConnectionRateRequest$1(this, entityFilter, expectedMatches);
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var12_7 = null;
            Object var13_8 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        tuple22._2$mcZ$sp();
        if (var8_11 instanceof Left) {
            ((Left)var8_11).value();
            return;
        }
        if (var8_11 instanceof Right) {
            throw (AssertionError)((Right)var8_11).value();
        }
        throw new MatchError((Object)var8_11);
    }

    public static final /* synthetic */ void $anonfun$testAlterTenantQuotasProducerIdExpirationMsRequest$2(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatches$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            java.util.Map props = (java.util.Map)x0$1._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.TenantProducerIdExpirationMs()})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(props).asScala().keySet());
            Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)expectedMatches$3.apply((Object)entity)), (Double)((Double)props.get($this.TenantProducerIdExpirationMs())));
            String entityName = (String)entity.entries().get("confluent-tenant");
            String entityTenant = entityName == null ? "<default>" : entityName;
            double currentServerQuota = ((KafkaBroker)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.brokersMap().values()).asScala().head()).logManager().producerStateManagerConfig().producerIdExpirationMs(Optional.of(entityTenant));
            Assertions.assertTrue((Math.abs(BoxesRunTime.unboxToDouble((Object)expectedMatches$3.apply((Object)entity)) - currentServerQuota) < 0.01 ? 1 : 0) != 0, (String)new StringBuilder(33).append("Connection quota of ").append(entity).append(" is not ").append(expectedMatches$3.apply((Object)entity)).append(" but ").append(currentServerQuota).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAlterTenantQuotasProducerIdExpirationMsRequest$1(ClientQuotasRequestTest $this, ClientQuotaFilterComponent entityFilter$3, scala.collection.immutable.Map expectedMatches$3) {
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entityFilter$3, (List)Nil$.MODULE$)).asJava()));
        Assertions.assertEquals((Object)expectedMatches$3.keySet(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().keySet());
        CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testAlterTenantQuotasProducerIdExpirationMsRequest$2($this, expectedMatches$3, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyTenantQuotas$2(ClientQuotaFilterComponent entityFilter, scala.collection.immutable.Map expectedMatches) {
        void var8_11;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                ClientQuotasRequestTest.$anonfun$testAlterTenantQuotasProducerIdExpirationMsRequest$1(this, entityFilter, expectedMatches);
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var12_7 = null;
            Object var13_8 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        tuple22._2$mcZ$sp();
        if (var8_11 instanceof Left) {
            ((Left)var8_11).value();
            return;
        }
        if (var8_11 instanceof Right) {
            throw (AssertionError)((Right)var8_11).value();
        }
        throw new MatchError((Object)var8_11);
    }

    public static final /* synthetic */ void $anonfun$testAlterTenantQuotasConnectionCountRequest$2(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatches$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            java.util.Map props = (java.util.Map)x0$1._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.TenantConnectionCountProp()})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(props).asScala().keySet());
            Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)expectedMatches$4.apply((Object)entity)), (Double)((Double)props.get($this.TenantConnectionCountProp())));
            String entityName = (String)entity.entries().get("confluent-tenant");
            String entityTenant = entityName == null ? "<default>" : entityName;
            double currentServerQuota = ((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala($this.cluster.brokerSocketServers()).asScala().head()).connectionQuotas().tenantConnectionQuota().maxConnections((Object)entityTenant);
            Assertions.assertTrue((Math.abs(BoxesRunTime.unboxToDouble((Object)expectedMatches$4.apply((Object)entity)) - currentServerQuota) < 0.01 ? 1 : 0) != 0, (String)new StringBuilder(33).append("Connection quota of ").append(entity).append(" is not ").append(expectedMatches$4.apply((Object)entity)).append(" but ").append(currentServerQuota).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAlterTenantQuotasConnectionCountRequest$1(ClientQuotasRequestTest $this, ClientQuotaFilterComponent entityFilter$4, scala.collection.immutable.Map expectedMatches$4) {
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entityFilter$4, (List)Nil$.MODULE$)).asJava()));
        Assertions.assertEquals((Object)expectedMatches$4.keySet(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().keySet());
        CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testAlterTenantQuotasConnectionCountRequest$2($this, expectedMatches$4, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyTenantQuotas$3(ClientQuotaFilterComponent entityFilter, scala.collection.immutable.Map expectedMatches) {
        void var8_11;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                ClientQuotasRequestTest.$anonfun$testAlterTenantQuotasConnectionCountRequest$1(this, entityFilter, expectedMatches);
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var12_7 = null;
            Object var13_8 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var11_6 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        tuple22._2$mcZ$sp();
        if (var8_11 instanceof Left) {
            ((Left)var8_11).value();
            return;
        }
        if (var8_11 instanceof Right) {
            throw (AssertionError)((Right)var8_11).value();
        }
        throw new MatchError((Object)var8_11);
    }

    private final java.util.Map matchEntity$1(ClientQuotaEntity entity) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)CollectionConverters$.MODULE$.MapHasAsScala(entity.entries()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String entityType = (String)x0$1._1();
                String entityName = (String)x0$1._2();
                switch (entityName == null ? 0 : entityName.hashCode()) {
                    case 0: {
                        if (entityName != null) break;
                        return ClientQuotaFilterComponent.ofDefaultEntity((String)entityType);
                    }
                }
                return ClientQuotaFilterComponent.ofEntity((String)entityType, (String)entityName);
            }
            throw new MatchError(null);
        });
        return this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)components.toList()).asJava()));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$3(ClientQuotasRequestTest $this, ClientQuotaEntity e$1, double v$1) {
        java.util.Map result = $this.matchEntity$1(e$1);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertTrue((result.get(e$1) != null ? 1 : 0) != 0);
        Double value = (Double)((java.util.Map)result.get(e$1)).get($this.RequestPercentageProp());
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((double)Predef$.MODULE$.Double2double(value), (double)v$1, (double)1.0E-6);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$2(ClientQuotasRequestTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var10_12;
            Tuple2 tuple2;
            ClientQuotaEntity e = (ClientQuotaEntity)x0$1._1();
            double v = x0$1._2$mcD$sp();
            long l = 100L;
            long tryUntilNoAssertionError_waitTime = 15000L;
            long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void tryUntilNoAssertionError_pause;
                Right right;
                try {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchExact$3($this, e, v);
                    BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                    right = package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
                }
                catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                    right = package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                }
                Object var14_8 = null;
                Object var15_9 = null;
                Right tryUntilNoAssertionError_computeUntilTrue_result = right;
                if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
            }
            Object var13_7 = null;
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Either tryUntilNoAssertionError_either = (Either)tuple22._1();
            tuple22._2$mcZ$sp();
            if (!(var10_12 instanceof Left)) {
                if (var10_12 instanceof Right) {
                    throw (AssertionError)((Right)var10_12).value();
                }
                throw new MatchError((Object)var10_12);
            }
            BoxedUnit cfr_ignored_0 = (BoxedUnit)((Left)var10_12).value();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchExact$7(ClientQuotasRequestTest $this, ClientQuotaEntity e) {
        java.util.Map result = $this.matchEntity$1(e);
        Assertions.assertEquals((int)0, (int)result.size());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$2(Function1 partition$1, Tuple2 e) {
        return BoxesRunTime.unboxToBoolean((Object)partition$1.apply(e._1()));
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$3(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
            double expectedValue = x0$1._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get($this.RequestPercentageProp());
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$4(ClientQuotasRequestTest $this, scala.collection.immutable.Map expectedMatchesMap$1, java.util.Map result$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            ClientQuotaEntity entity = (ClientQuotaEntity)x0$2._1();
            double expectedValue = x0$2._2$mcD$sp();
            if (expectedMatchesMap$1.contains((Object)entity)) {
                java.util.Map config = (java.util.Map)result$2.get(entity);
                Assertions.assertNotNull((Object)config);
                Double value = (Double)config.get($this.IpConnectionRateProp());
                Assertions.assertNotNull((Object)value);
                Assertions.assertEquals((double)expectedValue, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
                return;
            }
            Assertions.assertNull(result$2.get(entity));
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDescribeClientQuotasMatchPartial$1(ClientQuotasRequestTest $this, ClientQuotaFilter filter$1, Function1 partition$1, int expectedMatchSize$1) {
        void var6_6;
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> result = $this.describeClientQuotas(filter$1);
        Tuple2 tuple2 = ((List)$this.matchUserClientEntities().$plus$plus($this.matchIpEntities())).partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(partition$1, e)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List expectedMatches = (List)tuple2._1();
        Assertions.assertEquals((int)expectedMatchSize$1, (int)var6_6.size());
        Assertions.assertEquals((int)expectedMatchSize$1, (int)result.size(), (String)new StringBuilder(30).append("Failed to match ").append(expectedMatchSize$1).append(" entities for ").append(filter$1).toString());
        scala.collection.immutable.Map expectedMatchesMap = var6_6.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        $this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, expectedMatchesMap, result, x0$1);
            return BoxedUnit.UNIT;
        });
        $this.matchIpEntities().foreach((Function1 & Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$4(this, expectedMatchesMap, result, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void testMatchEntities$1(ClientQuotaFilter filter, int expectedMatchSize, Function1 partition) {
        void var9_16;
        Tuple2 tuple2;
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                Object var17_13;
                java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> $anonfun$testDescribeClientQuotasMatchPartial$1_result = this.describeClientQuotas(filter);
                Tuple2 tuple22 = ((List)this.matchUserClientEntities().$plus$plus(this.matchIpEntities())).partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$2(partition$1, e)));
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                List $anonfun$testDescribeClientQuotasMatchPartial$1_expectedMatches = (List)tuple22._1();
                Assertions.assertEquals((int)expectedMatchSize, (int)var17_13.size());
                Assertions.assertEquals((int)expectedMatchSize, (int)$anonfun$testDescribeClientQuotasMatchPartial$1_result.size(), (String)new StringBuilder(30).append("Failed to match ").append(expectedMatchSize).append(" entities for ").append(filter).toString());
                scala.collection.immutable.Map $anonfun$testDescribeClientQuotasMatchPartial$1_expectedMatchesMap = var17_13.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.matchUserClientEntities().foreach((Function1 & Serializable)x0$1 -> {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$3(this, expectedMatchesMap, result, x0$1);
                    return BoxedUnit.UNIT;
                });
                this.matchIpEntities().foreach((Function1 & Serializable)x0$2 -> {
                    ClientQuotasRequestTest.$anonfun$testDescribeClientQuotasMatchPartial$4(this, expectedMatchesMap, result, x0$2);
                    return BoxedUnit.UNIT;
                });
                Object var15_11 = null;
                tuple22 = null;
                var17_13 = null;
                Object var18_14 = null;
                BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                right = package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var13_8 = null;
            Object var14_9 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple23 = tuple2;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple23._1();
        tuple23._2$mcZ$sp();
        if (var9_16 instanceof Left) {
            ((Left)var9_16).value();
            return;
        }
        if (var9_16 instanceof Right) {
            throw (AssertionError)((Right)var9_16).value();
        }
        throw new MatchError((Object)var9_16);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$5(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-1";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$6(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$7(ClientQuotaEntity entity) {
        Object v = entity.entries().get("client-id");
        String string = "client-id-2";
        return v != null && v.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$8(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && entity.entries().get("user") == null;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$9(ClientQuotaEntity entity) {
        Object v = entity.entries().get("user");
        String string = "user-2";
        return v != null && v.equals(string) && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$10(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$11(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user") && !entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$12(ClientQuotaEntity entity) {
        return entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$13(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id") && !entity.entries().containsKey("user");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$14(ClientQuotaEntity entity) {
        return entity.entries().containsKey("client-id");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$15(ClientQuotaEntity entity) {
        return entity.entries().containsKey("ip");
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$16(ClientQuotaEntity entity) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClientQuotasMatchPartial$17(ClientQuotaEntity entity) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$verifyDescribeEntityQuotas$5(java.util.Map configs$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            double v = x0$2._2$mcD$sp();
            Double value = (Double)configs$1.get(k);
            Assertions.assertNotNull((Object)value);
            Assertions.assertEquals((double)v, (double)Predef$.MODULE$.Double2double(value), (double)1.0E-6);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyDescribeEntityQuotas$1(ClientQuotasRequestTest $this, ClientQuotaEntity entity$3, scala.collection.immutable.Map quotas$1) {
        scala.collection.mutable.Iterable components = (scala.collection.mutable.Iterable)CollectionConverters$.MODULE$.MapHasAsScala(entity$3.entries()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String entityType = (String)x0$1._1();
                String entityName = (String)x0$1._2();
                return (ClientQuotaFilterComponent)Option$.MODULE$.apply((Object)entityName).map((Function1 & Serializable)name -> ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name)).getOrElse((Function0 & Serializable)() -> ClientQuotaFilterComponent.ofDefaultEntity((String)entityType));
            }
            throw new MatchError(null);
        });
        java.util.Map<ClientQuotaEntity, java.util.Map<String, Double>> describe = $this.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)components.toList()).asJava()));
        if (quotas$1.isEmpty()) {
            Assertions.assertEquals((int)0, (int)describe.size());
            return;
        }
        Assertions.assertEquals((int)1, (int)describe.size());
        java.util.Map<String, Double> configs = describe.get(entity$3);
        Assertions.assertNotNull(configs);
        Assertions.assertEquals((int)quotas$1.size(), (int)configs.size());
        quotas$1.foreach((Function1 & Serializable)x0$2 -> {
            ClientQuotasRequestTest.$anonfun$verifyDescribeEntityQuotas$5(configs, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Double $anonfun$alterClientQuotas$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    public static final /* synthetic */ void $anonfun$alterClientQuotas$5(scala.collection.mutable.Map result$3, Tuple2 e) {
        Assertions.assertTrue((boolean)result$3.contains(e._1()));
    }

    public ClientQuotasRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        this.ConsumerByteRateProp = "consumer_byte_rate";
        this.ProducerByteRateProp = "producer_byte_rate";
        this.RequestPercentageProp = "request_percentage";
        this.IpConnectionRateProp = "connection_creation_rate";
        this.TenantConnectionRateProp = "connection_creation_rate";
        this.TenantProducerIdExpirationMs = "producer_id_expiration_ms";
        this.TenantConnectionCountProp = "connection_creation_count";
        this.matchUserClientEntities = ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)50.5)), new Tuple3((Object)new Some((Object)"user-2"), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)51.51)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)52.52)), new Tuple3((Object)new Some(null), (Object)new Some((Object)"client-id-1"), (Object)BoxesRunTime.boxToDouble((double)53.53)), new Tuple3((Object)new Some((Object)"user-1"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)54.54)), new Tuple3((Object)new Some((Object)"user-3"), (Object)new Some(null), (Object)BoxesRunTime.boxToDouble((double)55.55)), new Tuple3((Object)new Some((Object)"user-1"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)56.56)), new Tuple3((Object)new Some((Object)"user-2"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)57.57)), new Tuple3((Object)new Some((Object)"user-3"), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)58.58)), new Tuple3((Object)new Some(null), (Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)59.59)), new Tuple3((Object)None$.MODULE$, (Object)new Some((Object)"client-id-2"), (Object)BoxesRunTime.boxToDouble((double)60.6))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Option u = (Option)x0$1._1();
                Option c = (Option)x0$1._2();
                double v = BoxesRunTime.unboxToDouble((Object)x0$1._3());
                return new Tuple2((Object)this.toClientEntity((Option<String>)u, (Option<String>)c), (Object)BoxesRunTime.boxToDouble((double)v));
            }
            throw new MatchError(null);
        });
        this.matchIpEntities = new .colon.colon((Object)new Tuple2((Object)new Some((Object)"1.2.3.4"), (Object)BoxesRunTime.boxToDouble((double)10.0)), (List)new .colon.colon((Object)new Tuple2((Object)new Some((Object)"2.3.4.5"), (Object)BoxesRunTime.boxToDouble((double)20.0)), (List)Nil$.MODULE$)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Some ip = (Some)x0$2._1();
                double quota = x0$2._2$mcD$sp();
                return new Tuple2((Object)this.toIpEntity((Option<String>)ip), (Object)BoxesRunTime.boxToDouble((double)quota));
            }
            throw new MatchError(null);
        });
    }
}

