/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.io.Serializable;
import java.util.stream.Stream;
import kafka.network.RequestChannel;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkReplicaQuota;
import kafka.server.ClusterLinkReplicaQuotaAdapter;
import kafka.server.ClusterLinkReplicationConfig;
import kafka.server.ClusterLinkReplicationQuotaManager;
import kafka.server.ClusterLinkReplicationQuotaManagerTest$;
import kafka.server.ClusterLinkReplicationQuotaManagerTest$ClProduce$;
import kafka.server.ClusterLinkReplicationQuotaManagerTest$MixedProduce$;
import kafka.server.ClusterLinkReplicationQuotaManagerTest$NormalProduce$;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.ClusterLinkTenantRequestQuota;
import kafka.server.ConfigEntityName$;
import kafka.server.Defaults$;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.UnboundedClusterLinkTenantRequestQuota$;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkPrincipal;
import kafka.server.link.ConnectionMode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t}g\u0001B!C\u0001\u001dCQ\u0001\u0014\u0001\u0005\u00025Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004Z\u0001\u0001\u0006I!\u0015\u0005\b5\u0002\u0011\r\u0011\"\u0001Q\u0011\u0019Y\u0006\u0001)A\u0005#\"9A\f\u0001b\u0001\n\u0013i\u0006BB5\u0001A\u0003%a\fC\u0004k\u0001\t\u0007I\u0011A6\t\r=\u0004\u0001\u0015!\u0003m\u0011\u001d\u0001\bA1A\u0005\u0002EDa\u0001\u001f\u0001!\u0002\u0013\u0011\bbB=\u0001\u0005\u0004%\tA\u001f\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003|\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u000b\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\f\u0002!I!!$\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0003s\u0004A\u0011AAu\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u007fDqA!5\u0001\t\u0013\ti\bC\u0004\u0003T\u0002!IA!6\b\u000f\tE!\t#\u0001\u0003\u0014\u00191\u0011I\u0011E\u0001\u0005+Aa\u0001T\u000e\u0005\u0002\tua!\u0003B\u00107A\u0005\u0019\u0013\u0005B\u0011\u000f\u001d\u0011)k\u0007EA\u000573qA!&\u001c\u0011\u0003\u00139\n\u0003\u0004M?\u0011\u0005!\u0011\u0014\u0005\t\u0005\u0013z\u0012\u0011!C!!\"I!1J\u0010\u0002\u0002\u0013\u0005!Q\n\u0005\n\u0005\u001fz\u0012\u0011!C\u0001\u0005;C\u0011B!\u0018 \u0003\u0003%\tEa\u0018\t\u0013\t5t$!A\u0005\u0002\t\u0005\u0006\"\u0003B:?\u0005\u0005I\u0011\tB;\u0011%\u00119hHA\u0001\n\u0003\u0012I\bC\u0005\u0003|}\t\t\u0011\"\u0003\u0003~\u001d9!qU\u000e\t\u0002\n\u001dca\u0002B\u00137!\u0005%q\u0005\u0005\u0007\u0019*\"\tA!\u0012\t\u0011\t%#&!A\u0005BAC\u0011Ba\u0013+\u0003\u0003%\tA!\u0014\t\u0013\t=#&!A\u0005\u0002\tE\u0003\"\u0003B/U\u0005\u0005I\u0011\tB0\u0011%\u0011iGKA\u0001\n\u0003\u0011y\u0007C\u0005\u0003t)\n\t\u0011\"\u0011\u0003v!I!q\u000f\u0016\u0002\u0002\u0013\u0005#\u0011\u0010\u0005\n\u0005wR\u0013\u0011!C\u0005\u0005{:qA!+\u001c\u0011\u0003\u0013YIB\u0004\u0003\u0006nA\tIa\"\t\r1+D\u0011\u0001BE\u0011!\u0011I%NA\u0001\n\u0003\u0002\u0006\"\u0003B&k\u0005\u0005I\u0011\u0001B'\u0011%\u0011y%NA\u0001\n\u0003\u0011i\tC\u0005\u0003^U\n\t\u0011\"\u0011\u0003`!I!QN\u001b\u0002\u0002\u0013\u0005!\u0011\u0013\u0005\n\u0005g*\u0014\u0011!C!\u0005kB\u0011Ba\u001e6\u0003\u0003%\tE!\u001f\t\u0013\tmT'!A\u0005\n\tu\u0004b\u0002BV7\u0011\u0005!Q\u0016\u0005\b\u0003sZB\u0011\u0001BW\u0005\u0019\u001aE.^:uKJd\u0015N\\6SKBd\u0017nY1uS>t\u0017+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0007\u0012\u000baa]3sm\u0016\u0014(\"A#\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0013\t\u0003\u0013*k\u0011AQ\u0005\u0003\u0017\n\u0013!DQ1tK\u000ec\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d+fgR\fa\u0001P5oSRtD#\u0001(\u0011\u0005%\u0003\u0011A\u0002;f]\u0006tG/F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0003mC:<'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013aa\u0015;sS:<\u0017a\u0002;f]\u0006tG\u000fI\u0001\tY&t7NT1nK\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\u0007Y&t7.\u00133\u0016\u0003y\u0003\"aX4\u000e\u0003\u0001T!!\u00192\u0002\r\r|W.\\8o\u0015\t)5M\u0003\u0002eK\u00061\u0011\r]1dQ\u0016T\u0011AZ\u0001\u0004_J<\u0017B\u00015a\u0005\u0011)V/\u001b3\u0002\u000f1Lgn[%eA\u0005\u0011B.\u001b8l%\u0016\u0004H.[2b\u0007>tG/\u001a=u+\u0005a\u0007CA%n\u0013\tq'I\u0001\rDYV\u001cH/\u001a:MS:\\G+\u001a8b]R\u001cuN\u001c;fqR\f1\u0003\\5oWJ+\u0007\u000f\\5dC\u000e{g\u000e^3yi\u0002\nAc\u00197vgR,'\u000fT5oWB\u0013\u0018N\\2ja\u0006dW#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U\u0014\u0015\u0001\u00027j].L!a\u001e;\u0003)\rcWo\u001d;fe2Kgn\u001b)sS:\u001c\u0017\u000e]1m\u0003U\u0019G.^:uKJd\u0015N\\6Qe&t7-\u001b9bY\u0002\nA!^:feV\t1\u0010E\u0002}\u0003\u0017q1!`A\u0004!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001$\u0002\rq\u0012xn\u001c;?\u0015\t\t)!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\n\u0005\r\u0011A\u0002)sK\u0012,g-C\u0002Y\u0003\u001bQA!!\u0003\u0002\u0004\u0005)Qo]3sA\u0005\u00112\r\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t+\t\t)\u0002E\u0002t\u0003/I1!!\u0007u\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u0002'\rdWo\u001d;fe2Kgn['fiJL7m\u001d\u0011\u0002YQ,7\u000f\u001e\"s_.,'\u000fT3wK2\u001cE.^:uKJd\u0015N\\6Rk>$\u0018MT8s[\u0006d\u0007K]8ek\u000e,GCBA\u0011\u0003S\t\u0019\u0004\u0005\u0003\u0002$\u0005\u0015RBAA\u0002\u0013\u0011\t9#a\u0001\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003W\u0001\u0002\u0019AA\u0017\u0003Q\u0001(o\u001c3vG\u0016\fVo\u001c;bg\u0016s\u0017M\u00197fIB!\u00111EA\u0018\u0013\u0011\t\t$a\u0001\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0007\tA\u0002\u0005]\u0012\u0001F2mkN$XM\u001d'j].\fVo\u001c;b\u001b>$W\r\u0005\u0003\u0002:\u0005%c\u0002BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\nS:$XM\u001d8bYNT1!a\u0011a\u0003\u0019\u0019wN\u001c4jO&!\u0011qIA\u001f\u0003A\u0019uN\u001c4mk\u0016tGoQ8oM&<7/\u0003\u0003\u0002L\u00055#\u0001F\"mkN$XM\u001d'j].\fVo\u001c;b\u001b>$WM\u0003\u0003\u0002H\u0005u\u0002f\u0001\t\u0002RA!\u00111KA1\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013A\u00029be\u0006l7O\u0003\u0003\u0002\\\u0005u\u0013a\u00026va&$XM\u001d\u0006\u0004\u0003?*\u0017!\u00026v]&$\u0018\u0002BA2\u0003+\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d\u0001\u0012qMA:\u0003k\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0005\u0003[\n)&\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\t\t(a\u001b\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0005\u0005]\u0014EAA=\u0003u\tXo\u001c;bg\u0012K7/\u00192mK\u0012\fE\u000e\\\"p[\nLg.\u0019;j_:\u001c\u0018\u0001\u000f2s_.,'\u000fT3wK2\u001cE.^:uKJd\u0015N\\6Rk>$\u0018\rT5oWJ+\u0007\u000f\\5dCRLwN\u001c\"zi\u0016\u0014\u0016\r^3NKR\u0014\u0018nY\u000b\u0003\u0003\u007f\u0002B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0004\u0003\u000b\u0003\u0017aB7fiJL7m]\u0005\u0005\u0003\u0013\u000b\u0019IA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0017AF2sK\u0006$X\r\\5oWF+x\u000e^1NC:\fw-\u001a:\u0015\u0011\u0005=\u0015QSAM\u00037\u00032!SAI\u0013\r\t\u0019J\u0011\u0002#\u00072,8\u000f^3s\u0019&t7NU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\t\u000f\u0005]%\u00031\u0001\u0002.\u0005i2\r\\;ti\u0016\u0014H*\u001b8l)\u0016t\u0017M\u001c;Rk>$\u0018m]#oC\ndW\rC\u0004\u00026I\u0001\r!a\u000e\t\u000f\u0005u%\u00031\u0001\u0002 \u000613\r\\;ti\u0016\u0014H*\u001b8l#V|G/Y'pI\u0016\u0004VM\u001d+f]\u0006tGo\u0014<feJLG-Z:\u0011\r\u0005\r\u0012\u0011UAS\u0013\u0011\t\u0019+a\u0001\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0002?\u0002(n\fY+\u0003\u0003\u0002*\u00065!aA'baB!\u0011QVA%\u001d\u0011\ty+!\u0012\u000f\t\u0005E\u0016Q\u0019\b\u0005\u0003g\u000b\u0019M\u0004\u0003\u00026\u0006\u0005g\u0002BA\\\u0003\u007fsA!!/\u0002>:\u0019a0a/\n\u0003\u0019L!\u0001Z3\n\u0005\u0015\u001b\u0017BA1c\u0013\r\t\u0019\u0005Y\u0005\u0005\u0003\u007f\t\t%\u0001\ndYV\u001cH/\u001a:MS:\\\u0007K]8ek\u000e,GCBAf\u0003#\f)\u000e\u0005\u0003\u0002$\u00055\u0017\u0002BAh\u0003\u0007\u00111!\u00138u\u0011\u001d\t\u0019n\u0005a\u0001\u0003\u001f\u000b\u0001\u0003\\5oWF+x\u000e^1NC:\fw-\u001a:\t\u000f\u0005]7\u00031\u0001\u0002Z\u0006)Qo]1hKB!\u00111EAn\u0013\u0011\ti.a\u0001\u0003\r\u0011{WO\u00197f\u00035qwN]7bYB\u0013x\u000eZ;dKR1\u00111ZAr\u0003KDq!a5\u0015\u0001\u0004\ty\tC\u0004\u0002XR\u0001\r!!7\u0002YQ,7\u000f\u001e)sS>\u0014\u0018\u000e^5{K2{7-\u00197Qe>$WoY3Pm\u0016\u00148\t\\;ti\u0016\u0014H*\u001b8lS:<GCAA\u0011Q\r)\u0012Q\u001e\t\u0005\u0003_\f)0\u0004\u0002\u0002r*!\u00111_A-\u0003\r\t\u0007/[\u0005\u0005\u0003o\f\tP\u0001\u0003UKN$\u0018A\r;fgR\u001cE.^:uKJd\u0015N\\6j]\u001e$\u0006N]8ui2,G-\u00134M_\u000e\fG\u000e\u0015:pIV\u001cWm\u0014<feF+x\u000e^1)\u0007Y\ti/A\nuKN$\bK]8ek\u000e,G\u000b\u001b:piRdW\r\u0006\u0004\u0002\"\t\u0005!Q\u0019\u0005\b\u0005\u00079\u0002\u0019\u0001B\u0003\u0003-\u0001(o\u001c3vG\u0016$\u0016\u0010]3\u0011\u0007\t\u001dQDD\u0002\u0003\niqAAa\u0003\u0003\u00109\u0019aP!\u0004\n\u0003\u0015K!a\u0011#\u0002M\rcWo\u001d;fe2Kgn\u001b*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cH\u000f\u0005\u0002J7M\u00191Da\u0006\u0011\t\u0005\r\"\u0011D\u0005\u0005\u00057\t\u0019A\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005'\u00111\u0002\u0015:pIV\u001cW\rV=qKN\u0019QDa\u0006*\tuQSg\b\u0002\n\u00072\u0004&o\u001c3vG\u0016\u001c\u0012B\u000bB\f\u0005S\u0011iCa\r\u0011\u0007\t-R$D\u0001\u001c!\u0011\t\u0019Ca\f\n\t\tE\u00121\u0001\u0002\b!J|G-^2u!\u0011\u0011)Da\u0010\u000f\t\t]\"1\b\b\u0004}\ne\u0012BAA\u0003\u0013\u0011\u0011i$a\u0001\u0002\u000fA\f7m[1hK&!!\u0011\tB\"\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\u0011\u0011i$a\u0001\u0015\u0005\t\u001d\u0003c\u0001B\u0016U\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a3\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u000bB-!\u0011\t\u0019C!\u0016\n\t\t]\u00131\u0001\u0002\u0004\u0003:L\b\"\u0003B.]\u0005\u0005\t\u0019AAf\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\r\t\u0007\u0005G\u0012IGa\u0015\u000e\u0005\t\u0015$\u0002\u0002B4\u0003\u0007\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YG!\u001a\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003[\u0011\t\bC\u0005\u0003\\A\n\t\u00111\u0001\u0003T\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002L\u0006AAo\\*ue&tw\rF\u0001R\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011y\bE\u0002S\u0005\u0003K1Aa!T\u0005\u0019y%M[3di\naQ*\u001b=fIB\u0013x\u000eZ;dKNIQGa\u0006\u0003*\t5\"1\u0007\u000b\u0003\u0005\u0017\u00032Aa\u000b6)\u0011\u0011\u0019Fa$\t\u0013\tm\u0013(!AA\u0002\u0005-G\u0003BA\u0017\u0005'C\u0011Ba\u0017<\u0003\u0003\u0005\rAa\u0015\u0003\u001b9{'/\\1m!J|G-^2f'%y\"q\u0003B\u0015\u0005[\u0011\u0019\u0004\u0006\u0002\u0003\u001cB\u0019!1F\u0010\u0015\t\tM#q\u0014\u0005\n\u00057\u001a\u0013\u0011!a\u0001\u0003\u0017$B!!\f\u0003$\"I!1L\u0013\u0002\u0002\u0003\u0007!1K\u0001\u000e\u001d>\u0014X.\u00197Qe>$WoY3\u0002\u0013\rc\u0007K]8ek\u000e,\u0017\u0001D'jq\u0016$\u0007K]8ek\u000e,\u0017A\b9s_\u0012,8-\u001a+ie>$H\u000f\\3BY2\u001cu.\u001c2j]\u0006$\u0018n\u001c8t+\t\u0011y\u000b\u0005\u0004\u00032\nm&qX\u0007\u0003\u0005gSAA!.\u00038\u000611\u000f\u001e:fC6T1A!/V\u0003\u0011)H/\u001b7\n\t\tu&1\u0017\u0002\u0007'R\u0014X-Y7\u0011\t\u0005%$\u0011Y\u0005\u0005\u0005\u0007\fYGA\u0005Be\u001e,X.\u001a8ug\"9!qY\fA\u0002\u0005-\u0016A\u0007;f]\u0006tGo\u00117vgR,'\u000fT5oWF+x\u000e^1N_\u0012,\u0007fA\f\u0002R!:q#a\u001a\u0002t\t5GF\u0001BhC\t\u0011Y+\u0001\nhKR\fV/Z;f'&TX-T3ue&\u001c\u0017a\u0007;fgRdunY1m!J|G-^2f#V|G/Y+qI\u0006$X\r\u0006\u0006\u0002\"\t]'\u0011\u001cBn\u0005;Dq!a5\u001a\u0001\u0004\ty\tC\u0004\u0003\u0004e\u0001\rA!\u0002\t\u000f\u0005U\u0012\u00041\u0001\u0002,\")\u0001/\u0007a\u0001e\u0002")
public class ClusterLinkReplicationQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private final String tenant;
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final ClusterLinkTenantContext linkReplicaContext = new ClusterLinkTenantContext((Option)new Some((Object)this.tenant()), this.linkName());
    private final ClusterLinkPrincipal clusterLinkPrincipal = new ClusterLinkPrincipal(this.linkReplicaContext());
    private final String user = this.clusterLinkPrincipal().user();
    private final ClusterLinkMetrics clusterLinkMetrics = new ClusterLinkMetrics(this.linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, false, null, (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$, false);

    public static Stream<Arguments> quotasDisabledAllCombinations() {
        return ClusterLinkReplicationQuotaManagerTest$.MODULE$.quotasDisabledAllCombinations();
    }

    public static Stream<Arguments> produceThrottleAllCombinations() {
        return ClusterLinkReplicationQuotaManagerTest$.MODULE$.produceThrottleAllCombinations();
    }

    public String tenant() {
        return this.tenant;
    }

    public String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    public ClusterLinkTenantContext linkReplicaContext() {
        return this.linkReplicaContext;
    }

    public ClusterLinkPrincipal clusterLinkPrincipal() {
        return this.clusterLinkPrincipal;
    }

    public String user() {
        return this.user;
    }

    private ClusterLinkMetrics clusterLinkMetrics() {
        return this.clusterLinkMetrics;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"quotasDisabledAllCombinations"})
    public void testBrokerLevelClusterLinkQuotaNormalProduce(boolean produceQuotasEnabled, ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode) {
        void createlinkQuotaManager_clusterLinkQuotaModePerTenantOverrides;
        Function0 & Serializable intersect = (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty();
        boolean createlinkQuotaManager_clusterLinkTenantQuotasEnable = false;
        ClientQuotaManager createlinkQuotaManager_produceQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        ReplicationQuotaManagerConfig createlinkQuotaManager_replicationQuotaManagerConfig = new ReplicationQuotaManagerConfig(Defaults$.MODULE$.QuotaBytesPerSecond(), Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), false);
        ClusterLinkReplicationConfig createlinkQuotaManager_clusterLinkReplicationConfig = new ClusterLinkReplicationConfig(createlinkQuotaManager_replicationQuotaManagerConfig, (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function0)(JFunction0.mcZ.sp & Serializable)() -> createlinkQuotaManager_clusterLinkTenantQuotasEnable, (Function0 & Serializable)() -> clusterLinkQuotaMode, (Function0)createlinkQuotaManager_clusterLinkQuotaModePerTenantOverrides);
        intersect = null;
        Object var9_5 = null;
        Object var10_6 = null;
        Object var11_7 = null;
        ClusterLinkReplicationQuotaManager linkQuotaManager = new ClusterLinkReplicationQuotaManager(createlinkQuotaManager_clusterLinkReplicationConfig, createlinkQuotaManager_produceQuotaManager, this.metrics(), (Time)this.time());
        try {
            if (produceQuotasEnabled) {
                linkQuotaManager.produceQuotaManager().updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            }
            this.maybeRecord(linkQuotaManager.produceQuotaManager(), "ANONYMOUS", "unknown", 400.0);
            KafkaMetric clByteRateMetric = this.brokerLevelClusterLinkQuotaLinkReplicationByteRateMetric();
            ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode2 = clusterLinkQuotaMode;
            ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode3 = ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND;
            if (!(clusterLinkQuotaMode2 != null ? !clusterLinkQuotaMode2.equals(clusterLinkQuotaMode3) : clusterLinkQuotaMode3 != null)) {
                Assertions.assertEquals((double)400.0, (double)BoxesRunTime.unboxToDouble((Object)clByteRateMetric.metricValue()));
            } else {
                Assertions.assertNull((Object)clByteRateMetric);
            }
        }
        finally {
            linkQuotaManager.produceQuotaManager().shutdown();
        }
    }

    private KafkaMetric brokerLevelClusterLinkQuotaLinkReplicationByteRateMetric() {
        return (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("byte-rate", "ClusterLinkReplication", ""));
    }

    private ClusterLinkReplicationQuotaManager createlinkQuotaManager(boolean clusterLinkTenantQuotasEnable, ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode, Function0<Map<String, ConfluentConfigs.ClusterLinkQuotaMode>> clusterLinkQuotaModePerTenantOverrides) {
        ClientQuotaManager produceQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        ReplicationQuotaManagerConfig replicationQuotaManagerConfig = new ReplicationQuotaManagerConfig(Defaults$.MODULE$.QuotaBytesPerSecond(), Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), false);
        ClusterLinkReplicationConfig clusterLinkReplicationConfig = new ClusterLinkReplicationConfig(replicationQuotaManagerConfig, (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function0)(JFunction0.mcZ.sp & Serializable)() -> createlinkQuotaManager_clusterLinkTenantQuotasEnable, (Function0 & Serializable)() -> clusterLinkQuotaMode, clusterLinkQuotaModePerTenantOverrides);
        return new ClusterLinkReplicationQuotaManager(clusterLinkReplicationConfig, produceQuotaManager, this.metrics(), (Time)this.time());
    }

    public int clusterLinkProduce(ClusterLinkReplicationQuotaManager linkQuotaManager, double usage) {
        ClusterLinkQuotas quotas = new ClusterLinkQuotas((ClusterLinkReplicaQuota)linkQuotaManager, (ClusterLinkTenantRequestQuota)UnboundedClusterLinkTenantRequestQuota$.MODULE$);
        new ClusterLinkReplicaQuotaAdapter(quotas, this.clusterLinkMetrics(), (Option)new Some((Object)this.tenant()), this.linkName()).record((long)usage);
        return linkQuotaManager.getThrottleTimeMs(this.linkReplicaContext());
    }

    public int normalProduce(ClusterLinkReplicationQuotaManager linkQuotaManager, double usage) {
        MultiTenantPrincipal normalProducePrincipal = new MultiTenantPrincipal(this.user(), new TenantMetadata.Builder(this.tenant(), this.user()).build());
        return this.maybeRecord(linkQuotaManager.produceQuotaManager(), new RequestChannel.Session((KafkaPrincipal)normalProducePrincipal, null), "unknown", usage);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPrioritizeLocalProduceOverClusterLinking() {
        void createlinkQuotaManager_clusterLinkQuotaModePerTenantOverrides;
        void createlinkQuotaManager_clusterLinkQuotaMode;
        Function0 & Serializable intersect = (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty();
        ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND;
        boolean createlinkQuotaManager_clusterLinkTenantQuotasEnable = true;
        ClientQuotaManager createlinkQuotaManager_produceQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        ReplicationQuotaManagerConfig createlinkQuotaManager_replicationQuotaManagerConfig = new ReplicationQuotaManagerConfig(Defaults$.MODULE$.QuotaBytesPerSecond(), Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), false);
        ClusterLinkReplicationConfig createlinkQuotaManager_clusterLinkReplicationConfig = new ClusterLinkReplicationConfig(createlinkQuotaManager_replicationQuotaManagerConfig, (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function0)(JFunction0.mcZ.sp & Serializable)() -> createlinkQuotaManager_clusterLinkTenantQuotasEnable, () -> ClusterLinkReplicationQuotaManagerTest.$anonfun$createlinkQuotaManager$3((ConfluentConfigs.ClusterLinkQuotaMode)createlinkQuotaManager_clusterLinkQuotaMode), (Function0)createlinkQuotaManager_clusterLinkQuotaModePerTenantOverrides);
        clusterLinkQuotaMode = null;
        intersect = null;
        Object var8_4 = null;
        Object var9_5 = null;
        Object var10_6 = null;
        ClusterLinkReplicationQuotaManager linkQuotaManager = new ClusterLinkReplicationQuotaManager(createlinkQuotaManager_clusterLinkReplicationConfig, createlinkQuotaManager_produceQuotaManager, this.metrics(), (Time)this.time());
        ClientQuotaManager produceQuotaManager = linkQuotaManager.produceQuotaManager();
        try {
            KafkaMetric queueSizeMetric = this.getQueueSizeMetric();
            produceQuotaManager.updateQuota((Option)new Some((Object)this.clusterLinkPrincipal().getName()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)2000, (int)this.clusterLinkProduce(linkQuotaManager, 6500.0));
            Assertions.assertTrue((boolean)linkQuotaManager.isQuotaExceeded(this.linkReplicaContext()));
            this.time().sleep(1000L);
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)0, (int)this.normalProduce(linkQuotaManager, 500.0));
            Assertions.assertTrue((boolean)linkQuotaManager.isQuotaExceeded(this.linkReplicaContext()));
            Assertions.assertEquals((int)2000, (int)this.normalProduce(linkQuotaManager, 6000.0));
        }
        finally {
            produceQuotaManager.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinkingThrottledIfLocalProduceOverQuota() {
        void createlinkQuotaManager_clusterLinkQuotaModePerTenantOverrides;
        void createlinkQuotaManager_clusterLinkQuotaMode;
        Function0 & Serializable intersect = (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty();
        ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND;
        boolean createlinkQuotaManager_clusterLinkTenantQuotasEnable = true;
        ClientQuotaManager createlinkQuotaManager_produceQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        ReplicationQuotaManagerConfig createlinkQuotaManager_replicationQuotaManagerConfig = new ReplicationQuotaManagerConfig(Defaults$.MODULE$.QuotaBytesPerSecond(), Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), false);
        ClusterLinkReplicationConfig createlinkQuotaManager_clusterLinkReplicationConfig = new ClusterLinkReplicationConfig(createlinkQuotaManager_replicationQuotaManagerConfig, (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function0)(JFunction0.mcZ.sp & Serializable)() -> createlinkQuotaManager_clusterLinkTenantQuotasEnable, () -> ClusterLinkReplicationQuotaManagerTest.$anonfun$createlinkQuotaManager$3((ConfluentConfigs.ClusterLinkQuotaMode)createlinkQuotaManager_clusterLinkQuotaMode), (Function0)createlinkQuotaManager_clusterLinkQuotaModePerTenantOverrides);
        clusterLinkQuotaMode = null;
        intersect = null;
        Object var7_4 = null;
        Object var8_5 = null;
        Object var9_6 = null;
        ClusterLinkReplicationQuotaManager linkQuotaManager = new ClusterLinkReplicationQuotaManager(createlinkQuotaManager_clusterLinkReplicationConfig, createlinkQuotaManager_produceQuotaManager, this.metrics(), (Time)this.time());
        ClientQuotaManager produceQuotaManager = linkQuotaManager.produceQuotaManager();
        try {
            produceQuotaManager.updateQuota((Option)new Some((Object)this.clusterLinkPrincipal().getName()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.normalProduce(linkQuotaManager, 1500.0));
            Assertions.assertFalse((boolean)linkQuotaManager.isQuotaExceeded(this.linkReplicaContext()));
            Assertions.assertEquals((int)0, (int)this.clusterLinkProduce(linkQuotaManager, 1500.0));
            Assertions.assertFalse((boolean)linkQuotaManager.isQuotaExceeded(this.linkReplicaContext()));
            Assertions.assertEquals((int)2000, (int)this.normalProduce(linkQuotaManager, 5000.0));
            Assertions.assertTrue((boolean)linkQuotaManager.isQuotaExceeded(this.linkReplicaContext()));
        }
        finally {
            produceQuotaManager.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"produceThrottleAllCombinations"})
    public void testProduceThrottle(ProduceType produceType, ConfluentConfigs.ClusterLinkQuotaMode tenantClusterLinkQuotaMode) {
        JFunction1.mcID.sp & Serializable intersect;
        void createlinkQuotaManager_clusterLinkQuotaModePerTenantOverrides;
        void createlinkQuotaManager_clusterLinkQuotaMode;
        Map clusterLinkQuotaModePerTenantOverrides = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tenant()), (Object)tenantClusterLinkQuotaMode)}));
        Function0 & Serializable intersect2 = (Function0 & Serializable)() -> clusterLinkQuotaModePerTenantOverrides;
        ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND;
        boolean createlinkQuotaManager_clusterLinkTenantQuotasEnable = true;
        ClientQuotaManager createlinkQuotaManager_produceQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0, Long.MAX_VALUE), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        ReplicationQuotaManagerConfig createlinkQuotaManager_replicationQuotaManagerConfig = new ReplicationQuotaManagerConfig(Defaults$.MODULE$.QuotaBytesPerSecond(), Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), false);
        ClusterLinkReplicationConfig createlinkQuotaManager_clusterLinkReplicationConfig = new ClusterLinkReplicationConfig(createlinkQuotaManager_replicationQuotaManagerConfig, (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function0)(JFunction0.mcZ.sp & Serializable)() -> createlinkQuotaManager_clusterLinkTenantQuotasEnable, () -> ClusterLinkReplicationQuotaManagerTest.$anonfun$createlinkQuotaManager$3((ConfluentConfigs.ClusterLinkQuotaMode)createlinkQuotaManager_clusterLinkQuotaMode), (Function0)createlinkQuotaManager_clusterLinkQuotaModePerTenantOverrides);
        clusterLinkQuotaMode = null;
        intersect2 = null;
        Object var14_7 = null;
        Object var15_8 = null;
        Object var16_9 = null;
        ClusterLinkReplicationQuotaManager linkQuotaManager = new ClusterLinkReplicationQuotaManager(createlinkQuotaManager_clusterLinkReplicationConfig, createlinkQuotaManager_produceQuotaManager, this.metrics(), (Time)this.time());
        ClientQuotaManager produceQuotaManager = linkQuotaManager.produceQuotaManager();
        IntRef produceCount = IntRef.create((int)0);
        if (ClusterLinkReplicationQuotaManagerTest$ClProduce$.MODULE$.equals(produceType)) {
            intersect = (JFunction1.mcID.sp & Serializable)usage -> this.clusterLinkProduce(linkQuotaManager, usage);
        } else if (ClusterLinkReplicationQuotaManagerTest$NormalProduce$.MODULE$.equals(produceType)) {
            intersect = (JFunction1.mcID.sp & Serializable)usage -> this.normalProduce(linkQuotaManager, usage);
        } else if (ClusterLinkReplicationQuotaManagerTest$MixedProduce$.MODULE$.equals(produceType)) {
            intersect = (JFunction1.mcID.sp & Serializable)usage -> {
                ++produceCount$1.elem;
                if (produceCount$1.elem % 2 == 0) {
                    return this.clusterLinkProduce(linkQuotaManager, usage);
                }
                return this.normalProduce(linkQuotaManager, usage);
            };
        } else {
            throw new MatchError((Object)produceType);
        }
        JFunction1.mcID.sp & Serializable produceFunc = intersect;
        try {
            KafkaMetric queueSizeMetric = this.getQueueSizeMetric();
            produceQuotaManager.updateQuota((Option)new Some((Object)this.clusterLinkPrincipal().getName()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkReplicationQuotaManagerTest.$anonfun$testProduceThrottle$5(this, (Function1)produceFunc, arg_0)));
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = produceFunc.apply$mcID$sp(6550.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(produceQuotaManager, this.user(), "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            produceQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            produceQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkReplicationQuotaManagerTest.$anonfun$testProduceThrottle$6(this, (Function1)produceFunc, arg_0)));
            Assertions.assertEquals((int)0, (int)produceFunc.apply$mcID$sp(0.0), (String)"Should be unthrottled since bursty sample has rolled over");
            Assertions.assertNull((Object)this.brokerLevelClusterLinkQuotaLinkReplicationByteRateMetric());
            this.testLocalProduceQuotaUpdate(linkQuotaManager, produceType, tenantClusterLinkQuotaMode, this.clusterLinkPrincipal());
        }
        finally {
            produceQuotaManager.shutdown();
        }
    }

    private KafkaMetric getQueueSizeMetric() {
        return (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
    }

    private void testLocalProduceQuotaUpdate(ClusterLinkReplicationQuotaManager linkQuotaManager, ProduceType produceType, ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode, ClusterLinkPrincipal clusterLinkPrincipal) {
        KafkaMetric localProduceMetric;
        Map metricTags;
        block3: {
            block2: {
                metricTags = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClientQuotaManager.DefaultTags$.MODULE$.User()), (Object)clusterLinkPrincipal.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClientQuotaManager.DefaultTags$.MODULE$.ClientId()), (Object)"")}));
                localProduceMetric = (KafkaMetric)this.metrics().metrics().get(linkQuotaManager.getLocalProduceQuotaMetricName(metricTags));
                ProduceType produceType2 = produceType;
                ClusterLinkReplicationQuotaManagerTest$ClProduce$ clusterLinkReplicationQuotaManagerTest$ClProduce$ = ClusterLinkReplicationQuotaManagerTest$ClProduce$.MODULE$;
                if (produceType2 != null && produceType2.equals(clusterLinkReplicationQuotaManagerTest$ClProduce$)) break block2;
                ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode2 = clusterLinkQuotaMode;
                ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode3 = ConfluentConfigs.ClusterLinkQuotaMode.CLUSTER_LINK_ONLY;
                if (clusterLinkQuotaMode2 != null ? !clusterLinkQuotaMode2.equals(clusterLinkQuotaMode3) : clusterLinkQuotaMode3 != null) break block3;
            }
            Assertions.assertNull((Object)localProduceMetric);
            return;
        }
        Assertions.assertEquals((double)localProduceMetric.config().quota().bound(), (double)500.0);
        int newBound = 200;
        linkQuotaManager.produceQuotaManager().updateQuota((Option)new Some((Object)clusterLinkPrincipal.getName()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota((double)newBound, true)));
        Assertions.assertEquals((double)localProduceMetric.config().quota().bound(), (double)newBound);
        KafkaMetric normalProduceQuotaMetric = (KafkaMetric)this.metrics().metrics().get(linkQuotaManager.produceQuotaManager().clientQuotaMetricName(metricTags));
        MetricConfig normalProduceQuotaMetricConfig = linkQuotaManager.produceQuotaManager().getQuotaMetricConfig(100.0);
        linkQuotaManager.produceQuotaManager().updateQuotaMetricConfig(normalProduceQuotaMetric, normalProduceQuotaMetricConfig);
        Assertions.assertEquals((double)normalProduceQuotaMetric.config().quota().bound(), (double)100.0);
        Assertions.assertEquals((double)localProduceMetric.config().quota().bound(), (double)100.0);
        linkQuotaManager.produceQuotaManager().resetQuotaCallback(metricTags);
        Assertions.assertEquals((double)normalProduceQuotaMetric.config().quota().bound(), (double)newBound);
        Assertions.assertEquals((double)localProduceMetric.config().quota().bound(), (double)newBound);
    }

    public static final /* synthetic */ void $anonfun$testProduceThrottle$5(ClusterLinkReplicationQuotaManagerTest $this, Function1 produceFunc$1, int x$1) {
        Assertions.assertEquals((int)0, (int)produceFunc$1.apply$mcID$sp(400.0));
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testProduceThrottle$6(ClusterLinkReplicationQuotaManagerTest $this, Function1 produceFunc$1, int x$2) {
        produceFunc$1.apply$mcID$sp(400.0);
        $this.time().sleep(1000L);
    }

    public ClusterLinkReplicationQuotaManagerTest() {
        this.tenant = "lkc-foo";
        this.linkName = "TestFooLink";
    }

    public static interface ProduceType {
    }
}

